/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.esmf.metamodel.loader;

import com.google.common.collect.Streams;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.apache.jena.rdf.model.Model;
import org.apache.jena.rdf.model.Property;
import org.apache.jena.rdf.model.RDFNode;
import org.apache.jena.rdf.model.Resource;
import org.apache.jena.rdf.model.Statement;
import org.apache.jena.rdf.model.StmtIterator;
import org.apache.jena.vocabulary.RDF;
import org.eclipse.esmf.aspectmodel.resolver.services.SammAspectMetaModelResourceResolver;
import org.eclipse.esmf.aspectmodel.urn.AspectModelUrn;
import org.eclipse.esmf.aspectmodel.vocabulary.SAMM;
import org.eclipse.esmf.metamodel.datatypes.LangString;
import org.eclipse.esmf.metamodel.loader.AspectLoadingException;
import org.eclipse.esmf.metamodel.loader.AttributeValueRetriever;
import org.eclipse.esmf.samm.KnownVersion;

public class MetaModelBaseAttributes {
    private static final SammAspectMetaModelResourceResolver metaModelResourceResolver = new SammAspectMetaModelResourceResolver();
    private final KnownVersion metaModelVersion;
    private final Optional<AspectModelUrn> urn;
    private final String name;
    private final Set<LangString> preferredNames;
    private final Set<LangString> descriptions;
    private final List<String> see;
    private final boolean hasSyntheticName;

    public MetaModelBaseAttributes(KnownVersion metaModelVersion, AspectModelUrn urn, String name, Set<LangString> preferredNames, Set<LangString> descriptions, List<String> see) {
        this(metaModelVersion, urn, name, preferredNames, descriptions, see, false);
    }

    public MetaModelBaseAttributes(KnownVersion metaModelVersion, AspectModelUrn urn, String name, Set<LangString> preferredNames, Set<LangString> descriptions, List<String> see, boolean hasSyntheticName) {
        this.metaModelVersion = metaModelVersion;
        this.urn = Optional.ofNullable(urn);
        this.name = name;
        this.preferredNames = preferredNames;
        this.descriptions = descriptions;
        this.see = see;
        this.hasSyntheticName = hasSyntheticName;
    }

    public KnownVersion getMetaModelVersion() {
        return this.metaModelVersion;
    }

    public Optional<AspectModelUrn> getUrn() {
        return this.urn;
    }

    public String getName() {
        return this.name;
    }

    public Set<LangString> getPreferredNames() {
        return this.preferredNames;
    }

    public Set<LangString> getDescriptions() {
        return this.descriptions;
    }

    public List<String> getSee() {
        return this.see;
    }

    public boolean hasSyntheticName() {
        return this.hasSyntheticName;
    }

    public static Builder builderFor(String name) {
        return new Builder(name);
    }

    public static MetaModelBaseAttributes from(KnownVersion metaModelVersion, AspectModelUrn urn, String name) {
        return MetaModelBaseAttributes.builderFor(name).withMetaModelVersion(metaModelVersion).withUrn(urn).build();
    }

    public static MetaModelBaseAttributes from(KnownVersion metaModelVersion, AspectModelUrn urn, String name, String preferredName) {
        return MetaModelBaseAttributes.builderFor(name).withMetaModelVersion(metaModelVersion).withUrn(urn).withPreferredName(Locale.ENGLISH, preferredName).build();
    }

    public static MetaModelBaseAttributes fromModelElement(KnownVersion metaModelVersion, Resource modelElement, Model model, SAMM samm) {
        AttributeValueRetriever valueRetriever = new AttributeValueRetriever(samm);
        Optional<AspectModelUrn> urn = MetaModelBaseAttributes.getUrn(modelElement, samm);
        Set<LangString> preferredNames = MetaModelBaseAttributes.getLanguages(modelElement, samm.preferredName(), valueRetriever);
        Set<LangString> descriptions = MetaModelBaseAttributes.getLanguages(modelElement, samm.description(), valueRetriever);
        List<String> seeValues = MetaModelBaseAttributes.getSeeValues(modelElement, samm, valueRetriever);
        String name = MetaModelBaseAttributes.getName(modelElement, samm).orElseGet(() -> MetaModelBaseAttributes.getSyntheticName(modelElement, model, samm));
        boolean isSyntheticName = urn.isEmpty();
        return new MetaModelBaseAttributes(metaModelVersion, urn.orElse(null), name, preferredNames, descriptions, seeValues, isSyntheticName);
    }

    private static Optional<AspectModelUrn> getUrn(Resource modelElement, SAMM samm) {
        if (modelElement.isAnon()) {
            Statement propertyStatement = modelElement.getProperty(samm.property());
            if (propertyStatement != null) {
                return MetaModelBaseAttributes.getUrn(propertyStatement.getObject().asResource(), samm);
            }
            return Optional.empty();
        }
        return Optional.of(AspectModelUrn.fromUrn((String)modelElement.getURI()));
    }

    private static Optional<String> getName(Resource modelElement, SAMM samm) {
        if (!modelElement.isAnon()) {
            return Optional.of(AspectModelUrn.fromUrn((String)modelElement.getURI()).getName());
        }
        Statement propertyStatement = modelElement.getProperty(samm.property());
        if (propertyStatement != null) {
            return MetaModelBaseAttributes.getName(propertyStatement.getObject().asResource(), samm);
        }
        Optional<Statement> extendsStatement = Streams.stream((Iterator)modelElement.getModel().listStatements(modelElement, samm._extends(), (RDFNode)null)).findAny();
        return extendsStatement.flatMap(statement -> MetaModelBaseAttributes.getName(statement.getObject().asResource(), samm));
    }

    private static String getSyntheticName(Resource modelElement, Model model, SAMM samm) {
        Resource namedParent = MetaModelBaseAttributes.getNamedParent(modelElement, model);
        if (namedParent == null) {
            throw new AspectLoadingException("At least one anonymous node in the model does not have a parent with a regular name.");
        }
        String parentModelElementUri = namedParent.getURI();
        String parentModelElementName = AspectModelUrn.from((String)parentModelElementUri).toJavaOptional().map(AspectModelUrn::getName).map(StringUtils::capitalize).orElse("");
        Resource modelElementType = MetaModelBaseAttributes.getModelElementType(modelElement, samm);
        String modelElementTypeUri = modelElementType.getURI();
        String modelElementTypeName = AspectModelUrn.from((String)modelElementTypeUri).toJavaOptional().map(AspectModelUrn::getName).orElse("");
        return parentModelElementName + modelElementTypeName;
    }

    private static Resource getNamedParent(Resource modelElement, Model model) {
        StmtIterator elements = model.listStatements(null, null, (RDFNode)modelElement);
        while (elements.hasNext()) {
            Resource parentModelElement = ((Statement)elements.next()).getSubject();
            if (parentModelElement.isAnon()) {
                Resource grandParent = MetaModelBaseAttributes.getNamedParent(parentModelElement, model);
                if (null == grandParent) continue;
                return grandParent;
            }
            return parentModelElement;
        }
        return null;
    }

    private static Resource getModelElementType(Resource modelElement, SAMM samm) {
        Statement typeStatement = modelElement.getProperty(RDF.type);
        if (typeStatement != null) {
            return typeStatement.getObject().asResource();
        }
        Statement propertyStatement = modelElement.getProperty(samm.property());
        if (propertyStatement != null) {
            return MetaModelBaseAttributes.getModelElementType(propertyStatement.getObject().asResource(), samm);
        }
        Statement extendsStatement = modelElement.getProperty(samm._extends());
        if (extendsStatement == null) {
            throw new AspectLoadingException("Model element has no type and does not extend another type: " + modelElement);
        }
        Resource superElement = extendsStatement.getObject().asResource();
        return MetaModelBaseAttributes.getModelElementType(superElement, samm);
    }

    private static Set<LangString> getLanguages(Resource modelElement, Property attribute, AttributeValueRetriever valueRetriever) {
        return valueRetriever.attributeValues(modelElement, attribute).stream().filter(languageStatement -> !"und".equals(Locale.forLanguageTag(languageStatement.getLanguage()).toLanguageTag())).map(statement -> new LangString(statement.getString(), Locale.forLanguageTag(statement.getLanguage()))).collect(Collectors.toSet());
    }

    private static List<String> getSeeValues(Resource resource, SAMM samm, AttributeValueRetriever valueRetriever) {
        return valueRetriever.attributeValues(resource, samm.see()).stream().map(statement -> statement.getObject().toString()).sorted().collect(Collectors.toList());
    }

    public static class Builder {
        private AspectModelUrn urn;
        private final String name;
        private final Set<LangString> preferredNames = new HashSet<LangString>();
        private final Set<LangString> descriptions = new HashSet<LangString>();
        private final List<String> see = new ArrayList<String>();
        private KnownVersion metaModelVersion;
        private boolean hasSyntheticName;

        public Builder(String name) {
            this.name = name;
        }

        public Builder withUrn(AspectModelUrn urn) {
            this.urn = urn;
            return this;
        }

        public Builder withPreferredName(Locale locale, String preferredName) {
            this.preferredNames.add(new LangString(preferredName, locale));
            return this;
        }

        public Builder withDescription(Locale locale, String description) {
            this.descriptions.add(new LangString(description, locale));
            return this;
        }

        public Builder withSee(String see) {
            this.see.add(see);
            return this;
        }

        public Builder withMetaModelVersion(KnownVersion metaModelVersion) {
            this.metaModelVersion = metaModelVersion;
            return this;
        }

        public Builder hasSyntheticName(boolean hasSyntheticName) {
            this.hasSyntheticName = hasSyntheticName;
            return this;
        }

        public MetaModelBaseAttributes build() {
            return new MetaModelBaseAttributes(this.metaModelVersion, this.urn, this.name, this.preferredNames, this.descriptions, this.see, this.hasSyntheticName);
        }
    }
}

