/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.esmf.metamodel.loader;

import com.google.common.collect.Streams;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.jena.rdf.model.Model;
import org.apache.jena.rdf.model.RDFNode;
import org.apache.jena.rdf.model.Resource;
import org.apache.jena.rdf.model.Statement;
import org.apache.jena.vocabulary.RDF;
import org.apache.jena.vocabulary.RDFS;
import org.eclipse.esmf.aspectmodel.urn.AspectModelUrn;
import org.eclipse.esmf.aspectmodel.vocabulary.SAMM;
import org.eclipse.esmf.aspectmodel.vocabulary.SAMMC;
import org.eclipse.esmf.aspectmodel.vocabulary.UNIT;
import org.eclipse.esmf.metamodel.ComplexType;
import org.eclipse.esmf.metamodel.Entity;
import org.eclipse.esmf.metamodel.ModelElement;
import org.eclipse.esmf.metamodel.ModelNamespace;
import org.eclipse.esmf.metamodel.QuantityKind;
import org.eclipse.esmf.metamodel.QuantityKinds;
import org.eclipse.esmf.metamodel.Unit;
import org.eclipse.esmf.metamodel.Units;
import org.eclipse.esmf.metamodel.impl.DefaultQuantityKind;
import org.eclipse.esmf.metamodel.impl.DefaultUnit;
import org.eclipse.esmf.metamodel.loader.AspectLoadingException;
import org.eclipse.esmf.metamodel.loader.AttributeValueRetriever;
import org.eclipse.esmf.metamodel.loader.Instantiator;
import org.eclipse.esmf.metamodel.loader.MetaModelBaseAttributes;
import org.eclipse.esmf.metamodel.loader.instantiator.AbstractEntityInstantiator;
import org.eclipse.esmf.metamodel.loader.instantiator.AspectInstantiator;
import org.eclipse.esmf.metamodel.loader.instantiator.CharacteristicInstantiator;
import org.eclipse.esmf.metamodel.loader.instantiator.CodeInstantiator;
import org.eclipse.esmf.metamodel.loader.instantiator.CollectionInstantiator;
import org.eclipse.esmf.metamodel.loader.instantiator.ConstraintInstantiator;
import org.eclipse.esmf.metamodel.loader.instantiator.DurationInstantiator;
import org.eclipse.esmf.metamodel.loader.instantiator.EitherInstantiator;
import org.eclipse.esmf.metamodel.loader.instantiator.EncodingConstraintInstantiator;
import org.eclipse.esmf.metamodel.loader.instantiator.EntityInstanceInstantiator;
import org.eclipse.esmf.metamodel.loader.instantiator.EntityInstantiator;
import org.eclipse.esmf.metamodel.loader.instantiator.EnumerationInstantiator;
import org.eclipse.esmf.metamodel.loader.instantiator.EventInstantiator;
import org.eclipse.esmf.metamodel.loader.instantiator.FixedPointConstraintInstantiator;
import org.eclipse.esmf.metamodel.loader.instantiator.LanguageConstraintInstantiator;
import org.eclipse.esmf.metamodel.loader.instantiator.LengthConstraintInstantiator;
import org.eclipse.esmf.metamodel.loader.instantiator.ListInstantiator;
import org.eclipse.esmf.metamodel.loader.instantiator.LocaleConstraintInstantiator;
import org.eclipse.esmf.metamodel.loader.instantiator.MeasurementInstantiator;
import org.eclipse.esmf.metamodel.loader.instantiator.OperationInstantiator;
import org.eclipse.esmf.metamodel.loader.instantiator.PropertyInstantiator;
import org.eclipse.esmf.metamodel.loader.instantiator.QuantifiableInstantiator;
import org.eclipse.esmf.metamodel.loader.instantiator.RangeConstraintInstantiator;
import org.eclipse.esmf.metamodel.loader.instantiator.RegularExpressionConstraintInstantiator;
import org.eclipse.esmf.metamodel.loader.instantiator.SetInstantiator;
import org.eclipse.esmf.metamodel.loader.instantiator.SingleEntityInstantiator;
import org.eclipse.esmf.metamodel.loader.instantiator.SortedSetInstantiator;
import org.eclipse.esmf.metamodel.loader.instantiator.StateInstantiator;
import org.eclipse.esmf.metamodel.loader.instantiator.StructuredValueInstantiator;
import org.eclipse.esmf.metamodel.loader.instantiator.TimeSeriesInstantiator;
import org.eclipse.esmf.metamodel.loader.instantiator.TraitInstantiator;
import org.eclipse.esmf.samm.KnownVersion;

public class ModelElementFactory
extends AttributeValueRetriever {
    private final KnownVersion metaModelVersion;
    private final Model model;
    private final SAMMC sammc;
    private final UNIT unit;
    private final Map<Resource, Instantiator<?>> instantiators = new HashMap();
    private final Map<Resource, ModelElement> loadedElements = new HashMap<Resource, ModelElement>();
    private Set<ModelNamespace> namespaces;

    public ModelElementFactory(KnownVersion metaModelVersion, Model model, Map<Resource, Instantiator<?>> additionalInstantiators) {
        super(new SAMM(metaModelVersion));
        this.metaModelVersion = metaModelVersion;
        this.model = model;
        this.sammc = new SAMMC(metaModelVersion);
        this.unit = new UNIT(metaModelVersion, this.samm);
        this.registerInstantiator(this.samm.AbstractEntity(), new AbstractEntityInstantiator(this));
        this.registerInstantiator(this.samm.AbstractProperty(), new PropertyInstantiator(this));
        this.registerInstantiator(this.samm.Aspect(), new AspectInstantiator(this));
        this.registerInstantiator(this.samm.Characteristic(), new CharacteristicInstantiator(this));
        this.registerInstantiator(this.samm.Constraint(), new ConstraintInstantiator(this));
        this.registerInstantiator(this.samm.Entity(), new EntityInstantiator(this));
        this.registerInstantiator(this.samm.Event(), new EventInstantiator(this));
        this.registerInstantiator(this.samm.Operation(), new OperationInstantiator(this));
        this.registerInstantiator(this.samm.Property(), new PropertyInstantiator(this));
        this.registerInstantiator(this.sammc.Code(), new CodeInstantiator(this));
        this.registerInstantiator(this.sammc.Collection(), new CollectionInstantiator(this));
        this.registerInstantiator(this.sammc.Duration(), new DurationInstantiator(this));
        this.registerInstantiator(this.sammc.Either(), new EitherInstantiator(this));
        this.registerInstantiator(this.sammc.EncodingConstraint(), new EncodingConstraintInstantiator(this));
        this.registerInstantiator(this.sammc.Enumeration(), new EnumerationInstantiator(this));
        this.registerInstantiator(this.sammc.FixedPointConstraint(), new FixedPointConstraintInstantiator(this));
        this.registerInstantiator(this.sammc.LanguageConstraint(), new LanguageConstraintInstantiator(this));
        this.registerInstantiator(this.sammc.LengthConstraint(), new LengthConstraintInstantiator(this));
        this.registerInstantiator(this.sammc.List(), new ListInstantiator(this));
        this.registerInstantiator(this.sammc.LocaleConstraint(), new LocaleConstraintInstantiator(this));
        this.registerInstantiator(this.sammc.Measurement(), new MeasurementInstantiator(this));
        this.registerInstantiator(this.sammc.Quantifiable(), new QuantifiableInstantiator(this));
        this.registerInstantiator(this.sammc.RangeConstraint(), new RangeConstraintInstantiator(this));
        this.registerInstantiator(this.sammc.RegularExpressionConstraint(), new RegularExpressionConstraintInstantiator(this));
        this.registerInstantiator(this.sammc.Set(), new SetInstantiator(this));
        this.registerInstantiator(this.sammc.SingleEntity(), new SingleEntityInstantiator(this));
        this.registerInstantiator(this.sammc.SortedSet(), new SortedSetInstantiator(this));
        this.registerInstantiator(this.sammc.State(), new StateInstantiator(this));
        this.registerInstantiator(this.sammc.StructuredValue(), new StructuredValueInstantiator(this));
        this.registerInstantiator(this.sammc.TimeSeries(), new TimeSeriesInstantiator(this));
        this.registerInstantiator(this.sammc.Trait(), new TraitInstantiator(this));
        this.instantiators.putAll(additionalInstantiators);
    }

    private void registerInstantiator(Resource resource, Instantiator<?> instantiator) {
        this.instantiators.put(resource, instantiator);
    }

    public <T extends ModelElement> T create(Class<T> clazz, Resource modelElement) {
        ModelElement element = this.loadedElements.get(modelElement);
        if (element != null) {
            return (T)element;
        }
        Resource targetType = this.resourceType(modelElement);
        if (this.samm.Unit().equals((Object)targetType)) {
            return (T)this.findOrCreateUnit(modelElement);
        }
        if (this.samm.QuantityKind().equals((Object)targetType)) {
            return (T)this.findOrCreateQuantityKind(modelElement);
        }
        Instantiator<?> instantiator = this.instantiators.get(targetType);
        if (instantiator != null) {
            element = (ModelElement)instantiator.apply(modelElement);
            this.loadedElements.put(modelElement, element);
            return (T)element;
        }
        if (!this.model.contains(targetType, RDF.type, (RDFNode)null)) {
            throw new AspectLoadingException("Could not load " + modelElement + ": Unknown type " + targetType);
        }
        Entity entity = this.create(Entity.class, targetType);
        if (entity == null) {
            throw new AspectLoadingException("Could not load " + modelElement + ": Expected " + targetType + " to be an Entity");
        }
        return (T)new EntityInstanceInstantiator(this, entity).apply(modelElement);
    }

    public QuantityKind findOrCreateQuantityKind(Resource quantityKindResource) {
        Optional<QuantityKind> predefinedQuantityKind = QuantityKinds.fromName(quantityKindResource.getLocalName());
        return predefinedQuantityKind.orElseGet(() -> new DefaultQuantityKind(MetaModelBaseAttributes.fromModelElement(this.metaModelVersion, quantityKindResource, this.model, this.samm), this.attributeValue(quantityKindResource, this.samm.preferredName()).getLiteral().getLexicalForm()));
    }

    public Unit findOrCreateUnit(Resource unitResource) {
        if (this.unit.getNamespace().equals(unitResource.getNameSpace())) {
            AspectModelUrn unitUrn = AspectModelUrn.fromUrn((String)unitResource.getURI());
            return Units.fromName(unitUrn.getName(), this.metaModelVersion).orElseThrow(() -> new AspectLoadingException("Unit definition for " + unitUrn + " is invalid"));
        }
        Set<QuantityKind> quantityKinds = Streams.stream((Iterator)this.model.listStatements(unitResource, this.samm.quantityKind(), (RDFNode)null)).map(quantityKindStatement -> this.findOrCreateQuantityKind(quantityKindStatement.getObject().asResource())).collect(Collectors.toSet());
        return new DefaultUnit(MetaModelBaseAttributes.fromModelElement(this.metaModelVersion, unitResource, this.model, this.samm), this.optionalAttributeValue(unitResource, this.samm.symbol()).map(Statement::getString), this.optionalAttributeValue(unitResource, this.samm.commonCode()).map(Statement::getString), this.optionalAttributeValue(unitResource, this.samm.referenceUnit()).map(Statement::getResource).map(Resource::getLocalName), this.optionalAttributeValue(unitResource, this.samm.conversionFactor()).map(Statement::getString), quantityKinds);
    }

    private Resource resourceType(Resource resource) {
        Supplier<Optional> directType = () -> this.optionalAttributeValue(resource, RDF.type).map(Statement::getResource);
        Supplier<Optional> propertyUsageType = () -> this.optionalAttributeValue(resource, this.samm.property()).map(statement -> this.resourceType(statement.getResource()));
        Supplier<Optional> subClassType = () -> this.optionalAttributeValue(resource, RDFS.subClassOf).map(Statement::getResource).map(this::resourceType);
        Supplier<Optional> extendsType = () -> this.optionalAttributeValue(resource, this.samm._extends()).map(Statement::getResource).map(this::resourceType);
        return Stream.of(directType, propertyUsageType, subClassType, extendsType).map(Supplier::get).filter(Optional::isPresent).map(Optional::get).findFirst().orElseThrow(() -> new AspectLoadingException("Resource " + resource + " has no type"));
    }

    protected KnownVersion getMetaModelVersion() {
        return this.metaModelVersion;
    }

    protected Model getModel() {
        return this.model;
    }

    protected SAMM getSamm() {
        return this.samm;
    }

    protected SAMMC getSammc() {
        return this.sammc;
    }

    public UNIT getUnit() {
        return this.unit;
    }

    public List<ComplexType> getExtendingElements(List<AspectModelUrn> extendingElements) {
        return extendingElements.stream().map(urn -> this.getModel().createResource(urn.toString())).map(this.loadedElements::get).filter(Objects::nonNull).map(modelElement -> (ComplexType)modelElement).collect(Collectors.toList());
    }
}

