/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.esmf.metamodel.loader;

import java.util.Locale;
import java.util.Optional;
import java.util.stream.Stream;
import org.apache.jena.datatypes.RDFDatatype;
import org.apache.jena.vocabulary.RDF;
import org.eclipse.esmf.aspectmodel.resolver.services.ExtendedXsdDataType;
import org.eclipse.esmf.metamodel.ScalarValue;
import org.eclipse.esmf.metamodel.datatypes.LangString;
import org.eclipse.esmf.metamodel.impl.DefaultScalar;
import org.eclipse.esmf.metamodel.impl.DefaultScalarValue;
import org.eclipse.esmf.metamodel.loader.CurieRdfType;
import org.eclipse.esmf.samm.KnownVersion;

public class ValueInstantiator {
    private final RDFDatatype curieDataType = new CurieRdfType();
    private final KnownVersion metaModelVersion;

    public ValueInstantiator(KnownVersion metaModelVersion) {
        this.metaModelVersion = metaModelVersion;
    }

    public Optional<ScalarValue> buildScalarValue(String lexicalRepresentation, String languageTag, String datatypeUri) {
        if (datatypeUri.equals(RDF.langString.getURI())) {
            return Optional.of(this.buildLanguageString(lexicalRepresentation, languageTag));
        }
        return Stream.concat(ExtendedXsdDataType.supportedXsdTypes.stream(), Stream.of(this.curieDataType)).filter(type -> type.getURI().equals(datatypeUri)).map(type -> type.parse(lexicalRepresentation)).map(value -> new DefaultScalarValue(value, new DefaultScalar(datatypeUri, this.metaModelVersion))).findAny();
    }

    public ScalarValue buildLanguageString(String lexicalRepresentation, String languageTag) {
        LangString langString = new LangString(lexicalRepresentation, Locale.forLanguageTag(languageTag));
        DefaultScalar type = new DefaultScalar(RDF.langString.getURI(), this.metaModelVersion);
        return new DefaultScalarValue(langString, type);
    }
}

