/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.esmf.metamodel.loader.instantiator;

import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import org.apache.jena.rdf.model.Resource;
import org.eclipse.esmf.characteristic.Collection;
import org.eclipse.esmf.metamodel.Aspect;
import org.eclipse.esmf.metamodel.Event;
import org.eclipse.esmf.metamodel.Operation;
import org.eclipse.esmf.metamodel.Property;
import org.eclipse.esmf.metamodel.impl.DefaultAspect;
import org.eclipse.esmf.metamodel.loader.Instantiator;
import org.eclipse.esmf.metamodel.loader.MetaModelBaseAttributes;
import org.eclipse.esmf.metamodel.loader.ModelElementFactory;

public class AspectInstantiator
extends Instantiator<Aspect> {
    public AspectInstantiator(ModelElementFactory modelElementFactory) {
        super(modelElementFactory, Aspect.class);
    }

    @Override
    public Aspect apply(Resource aspect) {
        MetaModelBaseAttributes metaModelBaseAttributes = this.buildBaseAttributes(aspect);
        List<Property> properties = this.getPropertiesModels(aspect, this.samm.properties());
        List<Operation> operations = this.getResourcesFromList(aspect, this.samm.operations()).map(operation -> this.modelElementFactory.create(Operation.class, (Resource)operation)).collect(Collectors.toList());
        List<Event> events = this.getResourcesFromList(aspect, this.samm.events()).map(event -> this.modelElementFactory.create(Event.class, (Resource)event)).collect(Collectors.toList());
        boolean isCollectionAspect = properties.stream().map(Property::getCharacteristic).flatMap(Optional::stream).filter(Collection.class::isInstance).count() == 1L;
        return new DefaultAspect(metaModelBaseAttributes, properties, operations, events, isCollectionAspect);
    }
}

