/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.esmf.metamodel.visitor;

import java.util.Collection;
import java.util.HashSet;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Stream;
import org.eclipse.esmf.characteristic.Either;
import org.eclipse.esmf.characteristic.Enumeration;
import org.eclipse.esmf.characteristic.Quantifiable;
import org.eclipse.esmf.characteristic.StructuredValue;
import org.eclipse.esmf.characteristic.Trait;
import org.eclipse.esmf.metamodel.AbstractEntity;
import org.eclipse.esmf.metamodel.Aspect;
import org.eclipse.esmf.metamodel.Characteristic;
import org.eclipse.esmf.metamodel.CollectionValue;
import org.eclipse.esmf.metamodel.ComplexType;
import org.eclipse.esmf.metamodel.Entity;
import org.eclipse.esmf.metamodel.EntityInstance;
import org.eclipse.esmf.metamodel.ModelElement;
import org.eclipse.esmf.metamodel.Operation;
import org.eclipse.esmf.metamodel.Property;
import org.eclipse.esmf.metamodel.StructureElement;
import org.eclipse.esmf.metamodel.Unit;
import org.eclipse.esmf.metamodel.visitor.AspectVisitor;

public class AspectStreamTraversalVisitor
implements AspectVisitor<Stream<ModelElement>, Void> {
    private final Set<ModelElement> hasVisited = new HashSet<ModelElement>();

    @Override
    public Stream<ModelElement> visitBase(ModelElement modelElement, Void context) {
        return Stream.of(modelElement);
    }

    @Override
    public Stream<ModelElement> visitStructureElement(StructureElement structureElement, Void context) {
        return Stream.concat(Stream.of(structureElement), this.visit(structureElement.getProperties()));
    }

    @Override
    public Stream<ModelElement> visitAspect(Aspect aspect, Void context) {
        return Stream.of(this.visitStructureElement((StructureElement)aspect, null), this.visit(aspect.getEvents()), this.visit(aspect.getOperations())).flatMap(Function.identity());
    }

    @Override
    public Stream<ModelElement> visitProperty(Property property, Void context) {
        if (this.hasVisited.contains(property)) {
            return Stream.empty();
        }
        this.hasVisited.add(property);
        return Stream.of(Stream.of(property), this.visit(property.getCharacteristic()), this.visit(property.getExtends())).flatMap(Function.identity());
    }

    @Override
    public Stream<ModelElement> visitOperation(Operation operation, Void context) {
        return Stream.of(Stream.of(operation), this.visit(operation.getInput()), this.visit(operation.getOutput())).reduce(Stream.empty(), Stream::concat);
    }

    @Override
    public Stream<ModelElement> visitCharacteristic(Characteristic characteristic, Void context) {
        return Stream.concat(Stream.of(characteristic), this.visit(characteristic.getDataType()));
    }

    @Override
    public Stream<ModelElement> visitEither(Either either, Void context) {
        return Stream.of(this.visitCharacteristic((Characteristic)either, null), either.getLeft().accept(this, null), either.getRight().accept(this, null)).flatMap(Function.identity());
    }

    @Override
    public Stream<ModelElement> visitUnit(Unit unit, Void context) {
        return Stream.concat(Stream.of(unit), this.visit(unit.getQuantityKinds()));
    }

    @Override
    public Stream<ModelElement> visitQuantifiable(Quantifiable quantifiable, Void context) {
        return Stream.concat(this.visitCharacteristic((Characteristic)quantifiable, null), this.visit(quantifiable.getUnit()));
    }

    @Override
    public Stream<ModelElement> visitTrait(Trait trait, Void context) {
        return Stream.of(this.visitCharacteristic((Characteristic)trait, null), trait.getBaseCharacteristic().accept(this, null), this.visit(trait.getConstraints())).flatMap(Function.identity());
    }

    @Override
    public Stream<ModelElement> visitStructuredValue(StructuredValue structuredValue, Void context) {
        Stream[] streamArray = new Stream[2];
        streamArray[0] = this.visitCharacteristic((Characteristic)structuredValue, null);
        streamArray[1] = structuredValue.getElements().stream().filter(Property.class::isInstance).map(Property.class::cast).flatMap(property -> property.accept(this, null));
        return Stream.of(streamArray).flatMap(Function.identity());
    }

    @Override
    public Stream<ModelElement> visitEntity(Entity entity, Void context) {
        return this.visitComplexType((ComplexType)entity, context);
    }

    @Override
    public Stream<ModelElement> visitAbstractEntity(AbstractEntity abstractEntity, Void context) {
        return this.visitComplexType((ComplexType)abstractEntity, context);
    }

    @Override
    public Stream<ModelElement> visitComplexType(ComplexType entity, Void context) {
        if (this.hasVisited.contains(entity)) {
            return Stream.empty();
        }
        this.hasVisited.add(entity);
        return Stream.of(this.visitStructureElement((StructureElement)entity, null), this.visit(entity.getExtendingElements()), this.visit(entity.getExtends())).flatMap(Function.identity());
    }

    @Override
    public Stream<ModelElement> visitEnumeration(Enumeration enumeration, Void context) {
        return Stream.concat(this.visitCharacteristic((Characteristic)enumeration, null), this.visit(enumeration.getValues()));
    }

    @Override
    public Stream<ModelElement> visitCollectionValue(CollectionValue collectionValue, Void context) {
        return Stream.concat(Stream.of(collectionValue), this.visit(collectionValue.getValues()));
    }

    @Override
    public Stream<ModelElement> visitCollection(org.eclipse.esmf.characteristic.Collection collection, Void context) {
        return Stream.concat(this.visitCharacteristic((Characteristic)collection, null), this.visit(collection.getElementCharacteristic()));
    }

    @Override
    public Stream<ModelElement> visitEntityInstance(EntityInstance instance, Void context) {
        if (this.hasVisited.contains(instance)) {
            return Stream.empty();
        }
        this.hasVisited.add(instance);
        return Stream.of(Stream.of(instance), instance.getEntityType().accept(this, null), this.visit(instance.getAssertions().values())).flatMap(Function.identity());
    }

    private <T extends ModelElement> Stream<ModelElement> visit(Collection<T> collection) {
        return collection.stream().flatMap(item -> item.accept(this, null));
    }

    private <T extends ModelElement> Stream<ModelElement> visit(Optional<T> optional) {
        return optional.stream().flatMap(item -> item.accept(this, null));
    }
}

