/*
 * Copyright (c) 2021 Robert Bosch Manufacturing Solutions GmbH
 *
 * See the AUTHORS file(s) distributed with this work for additional
 * information regarding authorship.
 *
 * This Source Code Form is subject to the terms of the Mozilla Public
 * License, v. 2.0. If a copy of the MPL was not distributed with this
 * file, You can obtain one at https://mozilla.org/MPL/2.0/.
 *
 * SPDX-License-Identifier: MPL-2.0
 */

var samm = {
    quantityKinds: {
        "absoluteActivity": { name: "absoluteActivity", label: "absolute activity" },
        "absorbance": { name: "absorbance", label: "absorbance" },
        "absorbedDose": { name: "absorbedDose", label: "absorbed dose" },
        "absorbedDoseRate": { name: "absorbedDoseRate", label: "absorbed dose rate" },
        "absorptionFactor": { name: "absorptionFactor", label: "absorption factor" },
        "acceleration": { name: "acceleration", label: "acceleration" },
        "accelerationDueToGravity": { name: "accelerationDueToGravity", label: "acceleration due to gravity" },
        "accelerationOfFreeFall": { name: "accelerationOfFreeFall", label: "acceleration of free fall" },
        "acceptorIonizationEnergy": { name: "acceptorIonizationEnergy", label: "acceptor ionization energy" },
        "acceptorNumberDensity": { name: "acceptorNumberDensity", label: "acceptor number density" },
        "acousticImpedance": { name: "acousticImpedance", label: "acoustic impedance" },
        "activeEnergy": { name: "activeEnergy", label: "active energy" },
        "activePower": { name: "activePower", label: "active power" },
        "activity": { name: "activity", label: "activity" },
        "activityCoefficientOfBInALiquidAsASolidMixture": { name: "activityCoefficientOfBInALiquidAsASolidMixture", label: "activity coefficient of B (in a liquid as a solid mixture)" },
        "activityCoefficientOfSoluteBEspeciallyInADiluteSolution": { name: "activityCoefficientOfSoluteBEspeciallyInADiluteSolution", label: "activity coefficient of solute B (especially in a dilute solution)" },
        "activityConcentration": { name: "activityConcentration", label: "activity concentration" },
        "activityOfSolventA": { name: "activityOfSolventA", label: "activity of solvent A" },
        "admittance": { name: "admittance", label: "admittance" },
        "affinityOfAChemicalReaction": { name: "affinityOfAChemicalReaction", label: "affinity (of a chemical reaction)" },
        "alfvenNumber": { name: "alfvenNumber", label: "Alfven number" },
        "alphaDisintegrationEnergy": { name: "alphaDisintegrationEnergy", label: "alpha disintegration energy" },
        "amountOfSubstance": { name: "amountOfSubstance", label: "amount of substance" },
        "angleOfOpticalRotation": { name: "angleOfOpticalRotation", label: "angle of optical rotation" },
        "anglePlane": { name: "anglePlane", label: "angle (plane)" },
        "angularAcceleration": { name: "angularAcceleration", label: "angular acceleration" },
        "angularCrossSection": { name: "angularCrossSection", label: "angular cross-section" },
        "angularFrequency": { name: "angularFrequency", label: "angular frequency" },
        "angularImpulse": { name: "angularImpulse", label: "angular impulse" },
        "angularMomentum": { name: "angularMomentum", label: "angular momentum" },
        "angularReciprocalLatticeVector": { name: "angularReciprocalLatticeVector", label: "angular reciprocal lattice vector" },
        "angularRepetency": { name: "angularRepetency", label: "angular repetency" },
        "angularVelocity": { name: "angularVelocity", label: "angular velocity" },
        "angularWaveNumber": { name: "angularWaveNumber", label: "angular wave number" },
        "angularWavenumber": { name: "angularWavenumber", label: "angular wavenumber" },
        "apparentPower": { name: "apparentPower", label: "apparent power" },
        "area": { name: "area", label: "area" },
        "areaRelatedTorsionalMoment": { name: "areaRelatedTorsionalMoment", label: "area-related torsional moment" },
        "areicMass": { name: "areicMass", label: "areic mass" },
        "atomicAttenuationCoefficient": { name: "atomicAttenuationCoefficient", label: "atomic attenuation coefficient" },
        "atomicNumber": { name: "atomicNumber", label: "atomic number" },
        "attenuationCoefficient": { name: "attenuationCoefficient", label: "attenuation coefficient" },
        "averageLogarithmicEnergyDecrement": { name: "averageLogarithmicEnergyDecrement", label: "average logarithmic energy decrement" },
        "avogadroConstant": { name: "avogadroConstant", label: "Avogadro constant" },
        "betaDisintegrationEnergy": { name: "betaDisintegrationEnergy", label: "beta disintegration energy" },
        "bindingFraction": { name: "bindingFraction", label: "binding fraction" },
        "bohrMagneton": { name: "bohrMagneton", label: "Bohr magneton" },
        "bohrRadius": { name: "bohrRadius", label: "Bohr radius" },
        "boltzmannConstant": { name: "boltzmannConstant", label: "Boltzmann constant" },
        "braggAngle": { name: "braggAngle", label: "Bragg angle" },
        "breadth": { name: "breadth", label: "breadth" },
        "bulkCompressibility": { name: "bulkCompressibility", label: "bulk compressibility" },
        "bulkModulus": { name: "bulkModulus", label: "bulk modulus" },
        "burgersVector": { name: "burgersVector", label: "Burgers vector" },
        "burstIndex": { name: "burstIndex", label: "burst index" },
        "canonicalPartitionFunction": { name: "canonicalPartitionFunction", label: "canonical partition function" },
        "capacitance": { name: "capacitance", label: "capacitance" },
        "carrierLifeTime": { name: "carrierLifeTime", label: "carrier life time" },
        "cartesianCoordinates": { name: "cartesianCoordinates", label: "cartesian coordinates" },
        "catalyticActivity": { name: "catalyticActivity", label: "catalytic activity" },
        "characteristicImpedanceOfAMedium": { name: "characteristicImpedanceOfAMedium", label: "characteristic impedance of a medium" },
        "chargeDensity": { name: "chargeDensity", label: "charge density" },
        "chargeNumberOfIon": { name: "chargeNumberOfIon", label: "charge number of ion" },
        "chemicalPotential": { name: "chemicalPotential", label: "chemical potential" },
        "cieColorimetricFunctions": { name: "cieColorimetricFunctions", label: "CIE colorimetric functions" },
        "circularFrequency": { name: "circularFrequency", label: "circular frequency" },
        "coefficient": { name: "coefficient", label: "coefficient" },
        "coefficientOfFriction": { name: "coefficientOfFriction", label: "coefficient of friction" },
        "coefficientOfHeatTransfer": { name: "coefficientOfHeatTransfer", label: "coefficient of heat transfer" },
        "coefficientOfThermalInsulation": { name: "coefficientOfThermalInsulation", label: "coefficient of thermal insulation" },
        "coherenceLength": { name: "coherenceLength", label: "coherence length" },
        "complexAdmittance": { name: "complexAdmittance", label: "complex admittance" },
        "complexImpedances": { name: "complexImpedances", label: "complex impedances" },
        "compressibility": { name: "compressibility", label: "compressibility" },
        "comptonWavelength": { name: "comptonWavelength", label: "Compton wavelength" },
        "concentrationOfB": { name: "concentrationOfB", label: "concentration of B" },
        "conductanceForAlternatingCurrent": { name: "conductanceForAlternatingCurrent", label: "conductance (for alternating current)" },
        "conductanceForDirectCurrent": { name: "conductanceForDirectCurrent", label: "conductance (for direct current)" },
        "conductivity": { name: "conductivity", label: "conductivity" },
        "coordinatesTrichromatic": { name: "coordinatesTrichromatic", label: "coordinates trichromatic" },
        "couplingCoefficient": { name: "couplingCoefficient", label: "coupling coefficient" },
        "cowlingNumber": { name: "cowlingNumber", label: "Cowling number" },
        "crossSection": { name: "crossSection", label: "cross-section" },
        "cubicExpansionCoefficient": { name: "cubicExpansionCoefficient", label: "cubic expansion coefficient" },
        "curieTemperature": { name: "curieTemperature", label: "Curie temperature" },
        "currentDensity": { name: "currentDensity", label: "current density" },
        "currentDensityOfParticles": { name: "currentDensityOfParticles", label: "current density of particles" },
        "currentFractionOfIonB": { name: "currentFractionOfIonB", label: "current fraction of ion B" },
        "currentLinkage": { name: "currentLinkage", label: "current linkage" },
        "curvature": { name: "curvature", label: "curvature" },
        "cyclotronAngularFrequency": { name: "cyclotronAngularFrequency", label: "cyclotron angular frequency" },
        "dampingCoefficient": { name: "dampingCoefficient", label: "damping coefficient" },
        "dataRate": { name: "dataRate", label: "Data rate" },
        "debyeAngularFrequency": { name: "debyeAngularFrequency", label: "Debye angular frequency" },
        "debyeAngularRepetency": { name: "debyeAngularRepetency", label: "Debye angular repetency" },
        "debyeAngularWaveNumber": { name: "debyeAngularWaveNumber", label: "Debye angular wave number" },
        "debyeTemperature": { name: "debyeTemperature", label: "Debye temperature" },
        "debyeWalleFactor": { name: "debyeWalleFactor", label: "Debye-Walle factor" },
        "decayConstant": { name: "decayConstant", label: "decay constant" },
        "degreeOfDissociation": { name: "degreeOfDissociation", label: "degree of dissociation" },
        "density": { name: "density", label: "density" },
        "densityOfHeatFlowRate": { name: "densityOfHeatFlowRate", label: "density of heat flow rate" },
        "densityOfStates": { name: "densityOfStates", label: "density of states" },
        "diameter": { name: "diameter", label: "diameter" },
        "diffusionArea": { name: "diffusionArea", label: "diffusion area" },
        "diffusionCoefficient": { name: "diffusionCoefficient", label: "diffusion coefficient" },
        "diffusionCoefficientForNeutronFluenceRate": { name: "diffusionCoefficientForNeutronFluenceRate", label: "diffusion coefficient for neutron fluence rate" },
        "diffusionCoefficientForNeutronFluxDensity": { name: "diffusionCoefficientForNeutronFluxDensity", label: "diffusion coefficient for neutron flux density" },
        "diffusionCoefficientForNeutronNumberDensity": { name: "diffusionCoefficientForNeutronNumberDensity", label: "diffusion coefficient for neutron number density" },
        "diffusionLength": { name: "diffusionLength", label: "diffusion length" },
        "dimensionless": { name: "dimensionless", label: "dimensionless" },
        "directionalSpectralEmissivity": { name: "directionalSpectralEmissivity", label: "directional spectral emissivity" },
        "disintegrationConstant": { name: "disintegrationConstant", label: "disintegration constant" },
        "displacementElectricPolarization": { name: "displacementElectricPolarization", label: "displacement electric polarization" },
        "displacementVectorOfIonOrAtom": { name: "displacementVectorOfIonOrAtom", label: "displacement vector of ion or atom" },
        "dissipance": { name: "dissipance", label: "dissipance" },
        "dissipationFactor": { name: "dissipationFactor", label: "dissipation factor" },
        "distance": { name: "distance", label: "distance" },
        "donorIonizationEnergy": { name: "donorIonizationEnergy", label: "donor ionization energy" },
        "donorNumberDensity": { name: "donorNumberDensity", label: "donor number density" },
        "doseEquivalent": { name: "doseEquivalent", label: "dose equivalent" },
        "effectiveMass": { name: "effectiveMass", label: "effective mass" },
        "effectiveMultiplicationFactor": { name: "effectiveMultiplicationFactor", label: "effective multiplication factor" },
        "electricCharge": { name: "electricCharge", label: "electric charge" },
        "electricConstant": { name: "electricConstant", label: "electric constant" },
        "electricCurrent": { name: "electricCurrent", label: "electric current" },
        "electricDipoleMoment": { name: "electricDipoleMoment", label: "electric dipole moment" },
        "electricDipoleMomentOfMolecule": { name: "electricDipoleMomentOfMolecule", label: "electric dipole moment of molecule" },
        "electricFieldStrength": { name: "electricFieldStrength", label: "electric field strength" },
        "electricFluxDensity": { name: "electricFluxDensity", label: "electric flux density" },
        "electricFluxFluxOfDisplacement": { name: "electricFluxFluxOfDisplacement", label: "electric flux (flux of displacement)" },
        "electricPolarizabilityOfAMolecule": { name: "electricPolarizabilityOfAMolecule", label: "electric polarizability of a molecule" },
        "electricPotential": { name: "electricPotential", label: "electric potential" },
        "electricSusceptibility": { name: "electricSusceptibility", label: "electric susceptibility" },
        "electrolyticConductivity": { name: "electrolyticConductivity", label: "electrolytic conductivity" },
        "electromagneticEnergyDensity": { name: "electromagneticEnergyDensity", label: "electromagnetic energy density" },
        "electromagneticMoment": { name: "electromagneticMoment", label: "electromagnetic moment" },
        "electromotiveForce": { name: "electromotiveForce", label: "electromotive force" },
        "electronAffinity": { name: "electronAffinity", label: "electron affinity" },
        "electronNumberDensity": { name: "electronNumberDensity", label: "electron number density" },
        "electronRadius": { name: "electronRadius", label: "electron radius" },
        "elementaryCharge": { name: "elementaryCharge", label: "elementary charge" },
        "emissivity": { name: "emissivity", label: "emissivity" },
        "emissivityAtASpecifiedWavelength": { name: "emissivityAtASpecifiedWavelength", label: "emissivity at a specified wavelength" },
        "energy": { name: "energy", label: "energy" },
        "energyDensity": { name: "energyDensity", label: "energy density" },
        "energyFluence": { name: "energyFluence", label: "energy fluence" },
        "energyFluenceRate": { name: "energyFluenceRate", label: "energy fluence rate" },
        "energyFluxDensity": { name: "energyFluxDensity", label: "energy flux density" },
        "energyImparted": { name: "energyImparted", label: "energy imparted" },
        "enthalpy": { name: "enthalpy", label: "enthalpy" },
        "entropy": { name: "entropy", label: "entropy" },
        "equilibriumPositionVectorOfIonOrAtom": { name: "equilibriumPositionVectorOfIonOrAtom", label: "equilibrium position vector of ion or atom" },
        "equivalenceDoseOutput": { name: "equivalenceDoseOutput", label: "equivalence dose output" },
        "equivalentAbsorptionAreaOfASurfaceOrObject": { name: "equivalentAbsorptionAreaOfASurfaceOrObject", label: "equivalent absorption area of a surface or object" },
        "eulerNumber": { name: "eulerNumber", label: "Euler number" },
        "exchangeIntergral": { name: "exchangeIntergral", label: "exchange intergral" },
        "exposure": { name: "exposure", label: "exposure" },
        "exposureRate": { name: "exposureRate", label: "exposure rate" },
        "fahrenheitTemperature": { name: "fahrenheitTemperature", label: "fahrenheit temperature" },
        "faradayConstant": { name: "faradayConstant", label: "Faraday constant" },
        "fastFissionFactor": { name: "fastFissionFactor", label: "fast fission factor" },
        "fermiAngularRepetency": { name: "fermiAngularRepetency", label: "Fermi angular repetency" },
        "fermiAngularWaveNumber": { name: "fermiAngularWaveNumber", label: "Fermi angular wave number" },
        "fermiEnergy": { name: "fermiEnergy", label: "Fermi energy" },
        "fermiTemperature": { name: "fermiTemperature", label: "Fermi temperature" },
        "fineStructureConstant": { name: "fineStructureConstant", label: "fine structure constant" },
        "firstRadiationConstant": { name: "firstRadiationConstant", label: "first radiation constant" },
        "fluenceRate": { name: "fluenceRate", label: "fluence rate" },
        "focalDistance": { name: "focalDistance", label: "focal distance" },
        "force": { name: "force", label: "force" },
        "forceDividedByLength": { name: "forceDividedByLength", label: "force divided by length" },
        "fourierNumber": { name: "fourierNumber", label: "Fourier number" },
        "fourierNumberForMassTransfer": { name: "fourierNumberForMassTransfer", label: "Fourier number for mass transfer" },
        "frequency": { name: "frequency", label: "frequency" },
        "frequencyInterval": { name: "frequencyInterval", label: "frequency interval" },
        "frictionFactor": { name: "frictionFactor", label: "friction factor" },
        "froudeNumber": { name: "froudeNumber", label: "Froude number" },
        "fugacityOfBInAGaseousMixture": { name: "fugacityOfBInAGaseousMixture", label: "fugacity of B (in a gaseous mixture)" },
        "fundamentalLatticeVector": { name: "fundamentalLatticeVector", label: "fundamental lattice vector" },
        "fundamentalReciprocalLatticeVector": { name: "fundamentalReciprocalLatticeVector", label: "fundamental reciprocal lattice vector" },
        "gFactorOfAtomOrElectron": { name: "gFactorOfAtomOrElectron", label: "g-factor of atom or electron" },
        "gFactorOfNucleus": { name: "gFactorOfNucleus", label: "g-factor of nucleus" },
        "gapEnergy": { name: "gapEnergy", label: "gap energy" },
        "grandCanonicalPartitionFunction": { name: "grandCanonicalPartitionFunction", label: "grand-canonical partition function" },
        "grandPartitionFunction": { name: "grandPartitionFunction", label: "grand partition function" },
        "grashofNumber": { name: "grashofNumber", label: "Grashof number" },
        "grashofNumberForMassTransfer": { name: "grashofNumberForMassTransfer", label: "Grashof number for mass transfer" },
        "gravitationalConstant": { name: "gravitationalConstant", label: "gravitational constant" },
        "groupVelocity": { name: "groupVelocity", label: "group velocity" },
        "grueneisenParameter": { name: "grueneisenParameter", label: "Grüneisen parameter" },
        "gyromagneticCoefficient": { name: "gyromagneticCoefficient", label: "gyromagnetic coefficient" },
        "gyromagneticRatio": { name: "gyromagneticRatio", label: "gyromagnetic ratio" },
        "halfLife": { name: "halfLife", label: "half life" },
        "halfThickness": { name: "halfThickness", label: "half-thickness" },
        "halfValueThickness": { name: "halfValueThickness", label: "half-value thickness" },
        "hallCoefficient": { name: "hallCoefficient", label: "Hall coefficient" },
        "hardnessIndex": { name: "hardnessIndex", label: "hardness index" },
        "hartmannNumber": { name: "hartmannNumber", label: "Hartmann number" },
        "hartreeEnergy": { name: "hartreeEnergy", label: "Hartree energy" },
        "heat": { name: "heat", label: "heat" },
        "heatCapacity": { name: "heatCapacity", label: "heat capacity" },
        "heatFlowRate": { name: "heatFlowRate", label: "heat flow rate" },
        "height": { name: "height", label: "height" },
        "helmholtzFreeEnergy": { name: "helmholtzFreeEnergy", label: "Helmholtz free energy" },
        "helmholtzFunction": { name: "helmholtzFunction", label: "Helmholtz function" },
        "holeNumberDensity": { name: "holeNumberDensity", label: "hole number density" },
        "hyperfineStructureQuantumNumber": { name: "hyperfineStructureQuantumNumber", label: "hyperfine structure quantum number" },
        "illuminance": { name: "illuminance", label: "illuminance" },
        "imageDistance": { name: "imageDistance", label: "image distance" },
        "impedance": { name: "impedance", label: "impedance" },
        "impulse": { name: "impulse", label: "impulse" },
        "infiniteMediumMultiplicationFactor": { name: "infiniteMediumMultiplicationFactor", label: "infinite medium multiplication factor" },
        "informationEntropy": { name: "informationEntropy", label: "Information entropy" },
        "instantaneousSoundParticleAcceleration": { name: "instantaneousSoundParticleAcceleration", label: "(instantaneous) sound particle acceleration" },
        "instantaneousSoundParticleDisplacement": { name: "instantaneousSoundParticleDisplacement", label: "(instantaneous) sound particle displacement" },
        "instantaneousSoundParticleVelocity": { name: "instantaneousSoundParticleVelocity", label: "(instantaneous) sound particle velocity" },
        "instantaneousSoundPressure": { name: "instantaneousSoundPressure", label: "(instantaneous) sound pressure" },
        "instantaneousVolumeFlowRate": { name: "instantaneousVolumeFlowRate", label: "(instantaneous) volume flow rate" },
        "internalConversionFactor": { name: "internalConversionFactor", label: "internal conversion factor" },
        "intrinsicNumberDensity": { name: "intrinsicNumberDensity", label: "intrinsic number density" },
        "ionDensity": { name: "ionDensity", label: "ion density" },
        "ionNumberDensity": { name: "ionNumberDensity", label: "ion number density" },
        "ionicStrength": { name: "ionicStrength", label: "ionic strength" },
        "irradiance": { name: "irradiance", label: "irradiance" },
        "isentropicCompressibility": { name: "isentropicCompressibility", label: "isentropic compressibility" },
        "isentropicExponent": { name: "isentropicExponent", label: "isentropic exponent" },
        "isothermalCompressibility": { name: "isothermalCompressibility", label: "isothermal compressibility" },
        "kinematicViscosity": { name: "kinematicViscosity", label: "kinematic viscosity" },
        "kineticEnergy": { name: "kineticEnergy", label: "kinetic energy" },
        "knudsenNumber": { name: "knudsenNumber", label: "Knudsen number" },
        "landauGinzburgNumber": { name: "landauGinzburgNumber", label: "Landau-Ginzburg number" },
        "larmorAngularFrequency": { name: "larmorAngularFrequency", label: "Larmor angular frequency" },
        "latticePlaneSpacing": { name: "latticePlaneSpacing", label: "lattice plane spacing" },
        "latticeVector": { name: "latticeVector", label: "lattice vector" },
        "leakageCoefficient": { name: "leakageCoefficient", label: "leakage coefficient" },
        "leakageRateOfGas": { name: "leakageRateOfGas", label: "leakage rate of gas" },
        "length": { name: "length", label: "length" },
        "lengthOfPath": { name: "lengthOfPath", label: "length of path" },
        "lensPower": { name: "lensPower", label: "lens power" },
        "lethargy": { name: "lethargy", label: "lethargy" },
        "levelOfAFieldQuantity": { name: "levelOfAFieldQuantity", label: "level of a field quantity" },
        "levelOfAPowerQuantity": { name: "levelOfAPowerQuantity", label: "level of a power quantity" },
        "levelWidth": { name: "levelWidth", label: "level width" },
        "lewisNumber": { name: "lewisNumber", label: "Lewis number" },
        "lightExposure": { name: "lightExposure", label: "light exposure" },
        "linearAbsorptionCoefficient": { name: "linearAbsorptionCoefficient", label: "linear absorption coefficient" },
        "linearAttenuationCoefficient": { name: "linearAttenuationCoefficient", label: "linear attenuation coefficient" },
        "linearDensity": { name: "linearDensity", label: "linear density" },
        "linearElectricCurrentDensity": { name: "linearElectricCurrentDensity", label: "linear electric current density" },
        "linearEnergyTransfer": { name: "linearEnergyTransfer", label: "linear energy transfer" },
        "linearExpansionCoefficient": { name: "linearExpansionCoefficient", label: "linear expansion coefficient" },
        "linearExtinctionCoefficient": { name: "linearExtinctionCoefficient", label: "linear extinction coefficient" },
        "linearIonizationByAParticle": { name: "linearIonizationByAParticle", label: "linear ionization by a particle" },
        "linearMass": { name: "linearMass", label: "linear mass" },
        "linearStrain": { name: "linearStrain", label: "linear strain" },
        "lineicCharge": { name: "lineicCharge", label: "lineic charge" },
        "lineicElectricCurrent": { name: "lineicElectricCurrent", label: "lineic electric current" },
        "lineicResistance": { name: "lineicResistance", label: "lineic resistance" },
        "logarithmicDecrement": { name: "logarithmicDecrement", label: "logarithmic decrement" },
        "londonPenetrationDepth": { name: "londonPenetrationDepth", label: "London penetration depth" },
        "longRangeOrderParameter": { name: "longRangeOrderParameter", label: "long-range order parameter" },
        "lossAngle": { name: "lossAngle", label: "loss angle" },
        "loudness": { name: "loudness", label: "loudness" },
        "loudnessLevel": { name: "loudnessLevel", label: "loudness level" },
        "lowerCriticalMagneticFluxDensity": { name: "lowerCriticalMagneticFluxDensity", label: "lower critical magnetic flux density" },
        "luminance": { name: "luminance", label: "luminance" },
        "luminiousEfficacy": { name: "luminiousEfficacy", label: "luminious efficacy" },
        "luminousEfficacyAtASpecifiedWavelength": { name: "luminousEfficacyAtASpecifiedWavelength", label: "luminous efficacy at a specified wavelength" },
        "luminousEfficiency": { name: "luminousEfficiency", label: "luminous efficiency" },
        "luminousEfficiencyAtASpecifiedWavelength": { name: "luminousEfficiencyAtASpecifiedWavelength", label: "luminous efficiency at a specified wavelength" },
        "luminousExitance": { name: "luminousExitance", label: "luminous exitance" },
        "luminousFlux": { name: "luminousFlux", label: "luminous flux" },
        "luminousIntensity": { name: "luminousIntensity", label: "luminous intensity" },
        "machNumber": { name: "machNumber", label: "Mach number" },
        "macroscopicCrossSection": { name: "macroscopicCrossSection", label: "macroscopic cross-section" },
        "macroscopicTotalCrossSection": { name: "macroscopicTotalCrossSection", label: "macroscopic total cross-section" },
        "madelungConstant": { name: "madelungConstant", label: "Madelung constant" },
        "magneticAreaMoment": { name: "magneticAreaMoment", label: "magnetic area moment" },
        "magneticConstant": { name: "magneticConstant", label: "magnetic constant" },
        "magneticDipoleMoment": { name: "magneticDipoleMoment", label: "magnetic dipole moment" },
        "magneticFieldStrength": { name: "magneticFieldStrength", label: "magnetic field strength" },
        "magneticFlux": { name: "magneticFlux", label: "magnetic flux" },
        "magneticFluxDensity": { name: "magneticFluxDensity", label: "magnetic flux density" },
        "magneticFluxQuantum": { name: "magneticFluxQuantum", label: "magnetic flux quantum" },
        "magneticInduction": { name: "magneticInduction", label: "magnetic induction" },
        "magneticMoment": { name: "magneticMoment", label: "magnetic moment" },
        "magneticMomentOfParticle": { name: "magneticMomentOfParticle", label: "magnetic moment of particle" },
        "magneticPolarization": { name: "magneticPolarization", label: "magnetic polarization" },
        "magneticPotentialDifference": { name: "magneticPotentialDifference", label: "magnetic potential difference" },
        "magneticQuantumNumber": { name: "magneticQuantumNumber", label: "magnetic quantum number" },
        "magneticReynoldsNumber": { name: "magneticReynoldsNumber", label: "magnetic Reynolds number" },
        "magneticSusceptibility": { name: "magneticSusceptibility", label: "magnetic susceptibility" },
        "magneticVectorPotential": { name: "magneticVectorPotential", label: "magnetic vector potential" },
        "magnetization": { name: "magnetization", label: "magnetization" },
        "magnetomotiveForce": { name: "magnetomotiveForce", label: "magnetomotive force" },
        "mass": { name: "mass", label: "mass" },
        "massAttenuationCoefficient": { name: "massAttenuationCoefficient", label: "mass attenuation coefficient" },
        "massConcentrationOfB": { name: "massConcentrationOfB", label: "mass concentration of B" },
        "massDefect": { name: "massDefect", label: "mass defect" },
        "massDensity": { name: "massDensity", label: "mass density" },
        "massEnergyTransferCoefficient": { name: "massEnergyTransferCoefficient", label: "mass energy transfer coefficient" },
        "massExcess": { name: "massExcess", label: "mass excess" },
        "massFlowRate": { name: "massFlowRate", label: "mass flow rate" },
        "massNumber": { name: "massNumber", label: "mass number" },
        "massOfAtomOfANuclideX": { name: "massOfAtomOfANuclideX", label: "mass of atom (of a nuclide x)" },
        "massOfMolecule": { name: "massOfMolecule", label: "mass of molecule" },
        "massRatio": { name: "massRatio", label: "mass ratio" },
        "massicEnergy": { name: "massicEnergy", label: "massic energy" },
        "massicEnergyImparted": { name: "massicEnergyImparted", label: "massic energy imparted" },
        "massicEnthalpy": { name: "massicEnthalpy", label: "massic enthalpy" },
        "massicHelmholtzFreeEnergy": { name: "massicHelmholtzFreeEnergy", label: "massic Helmholtz free energy" },
        "massicOptical": { name: "massicOptical", label: "massic optical" },
        "massicThermodynamicEnergy": { name: "massicThermodynamicEnergy", label: "massic thermodynamic energy" },
        "massicVolume": { name: "massicVolume", label: "massic volume" },
        "massieuFunction": { name: "massieuFunction", label: "massieu function" },
        "maximumBetaParticleEnergy": { name: "maximumBetaParticleEnergy", label: "maximum beta particle energy" },
        "maximumSpectralLuminousEfficacy": { name: "maximumSpectralLuminousEfficacy", label: "maximum spectral luminous efficacy" },
        "meanEnergyImparted": { name: "meanEnergyImparted", label: "mean energy imparted" },
        "meanFreePath": { name: "meanFreePath", label: "mean free path" },
        "meanFreePathOfPhononsOrElectrons": { name: "meanFreePathOfPhononsOrElectrons", label: "mean free path of phonons or electrons" },
        "meanLife": { name: "meanLife", label: "mean life" },
        "meanLinearRange": { name: "meanLinearRange", label: "mean linear range" },
        "meanMassRange": { name: "meanMassRange", label: "mean mass range" },
        "mechanicalImpedance": { name: "mechanicalImpedance", label: "mechanical impedance" },
        "microcanonicalPartitionFunction": { name: "microcanonicalPartitionFunction", label: "microcanonical partition function" },
        "migrationArea": { name: "migrationArea", label: "migration area" },
        "migrationLength": { name: "migrationLength", label: "migration length" },
        "mobility": { name: "mobility", label: "mobility" },
        "mobilityRatio": { name: "mobilityRatio", label: "mobility ratio" },
        "modulusOfAdmittance": { name: "modulusOfAdmittance", label: "modulus of admittance" },
        "modulusOfCompression": { name: "modulusOfCompression", label: "modulus of compression" },
        "modulusOfElasticity": { name: "modulusOfElasticity", label: "modulus of elasticity" },
        "modulusOfImpedance": { name: "modulusOfImpedance", label: "modulus of impedance" },
        "modulusOfRigidity": { name: "modulusOfRigidity", label: "modulus of rigidity" },
        "molalityOfSoluteB": { name: "molalityOfSoluteB", label: "molality of solute B" },
        "molarAbsorptionCoefficient": { name: "molarAbsorptionCoefficient", label: "molar absorption coefficient" },
        "molarAttenuationCoefficient": { name: "molarAttenuationCoefficient", label: "molar attenuation coefficient" },
        "molarConductivity": { name: "molarConductivity", label: "molar conductivity" },
        "molarEntropy": { name: "molarEntropy", label: "molar entropy" },
        "molarFlux": { name: "molarFlux", label: "molar flux" },
        "molarGasConstant": { name: "molarGasConstant", label: "molar gas constant" },
        "molarHeatCapacity": { name: "molarHeatCapacity", label: "molar heat capacity" },
        "molarMass": { name: "molarMass", label: "molar mass" },
        "molarOpticalRotatoryPower": { name: "molarOpticalRotatoryPower", label: "molar optical rotatory power" },
        "molarThermodynamicEnergy": { name: "molarThermodynamicEnergy", label: "molar thermodynamic energy" },
        "molarVolume": { name: "molarVolume", label: "molar volume" },
        "moleFractionOfB": { name: "moleFractionOfB", label: "mole fraction of B" },
        "moleRatioOfSoluteB": { name: "moleRatioOfSoluteB", label: "mole ratio of solute B" },
        "molecularConcentrationOfB": { name: "molecularConcentrationOfB", label: "molecular concentration of B" },
        "molecularPartitionFunction": { name: "molecularPartitionFunction", label: "molecular partition function" },
        "momentOfACouple": { name: "momentOfACouple", label: "moment of a couple" },
        "momentOfForce": { name: "momentOfForce", label: "moment of force" },
        "momentOfInertiaDynamicMomentOfInertia": { name: "momentOfInertiaDynamicMomentOfInertia", label: "moment of inertia (dynamic moment of inertia)" },
        "momentOfMomentum": { name: "momentOfMomentum", label: "moment of momentum" },
        "momentum": { name: "momentum", label: "momentum" },
        "multiplicationFactor": { name: "multiplicationFactor", label: "multiplication factor" },
        "mutualInductance": { name: "mutualInductance", label: "mutual inductance" },
        "neelTemperature": { name: "neelTemperature", label: "Néel temperature" },
        "neutronFluenceRate": { name: "neutronFluenceRate", label: "neutron fluence rate" },
        "neutronNumber": { name: "neutronNumber", label: "neutron number" },
        "neutronNumberDensity": { name: "neutronNumberDensity", label: "neutron number density" },
        "neutronSpeed": { name: "neutronSpeed", label: "neutron speed" },
        "neutronYieldPerAbsorption": { name: "neutronYieldPerAbsorption", label: "neutron yield per absorption" },
        "neutronYieldPerFission": { name: "neutronYieldPerFission", label: "neutron yield per fission" },
        "neutronfluxDensity": { name: "neutronfluxDensity", label: "neutronflux density" },
        "nonLeakageProbability": { name: "nonLeakageProbability", label: "non leakage probability" },
        "normalStress": { name: "normalStress", label: "normal stress" },
        "nuclearMagnetonOrnucleus": { name: "nuclearMagnetonOrnucleus", label: "nuclear magneton ornucleus" },
        "nuclearPrecession": { name: "nuclearPrecession", label: "nuclear precession" },
        "nuclearQuadrupoleMoment": { name: "nuclearQuadrupoleMoment", label: "nuclear quadrupole moment" },
        "nuclearRadius": { name: "nuclearRadius", label: "nuclear radius" },
        "nuclearSpinQuantumNumber": { name: "nuclearSpinQuantumNumber", label: "nuclear spin quantum number" },
        "nucleonNumber": { name: "nucleonNumber", label: "nucleon number" },
        "nuclidicMass": { name: "nuclidicMass", label: "nuclidic mass" },
        "numberDensityOfMoleculesOrParticles": { name: "numberDensityOfMoleculesOrParticles", label: "number density of molecules  (or particles)" },
        "numberOfMoleculesOrOtherElementaryEntities": { name: "numberOfMoleculesOrOtherElementaryEntities", label: "number of molecules or other elementary entities" },
        "numberOfPairsOfPoles": { name: "numberOfPairsOfPoles", label: "number of pairs of poles" },
        "numberOfPhases": { name: "numberOfPhases", label: "number of phases" },
        "numberOfTurnsInAWinding": { name: "numberOfTurnsInAWinding", label: "number of turns in a winding" },
        "nusseltNumber": { name: "nusseltNumber", label: "Nusselt number" },
        "nusseltNumberForMassTransfer": { name: "nusseltNumberForMassTransfer", label: "Nusselt number for mass transfer" },
        "objectDistance": { name: "objectDistance", label: "object distance" },
        "opticalDensity": { name: "opticalDensity", label: "optical density" },
        "orbitalAngularMomentumQuantumNumber": { name: "orbitalAngularMomentumQuantumNumber", label: "orbital angular momentum quantum number" },
        "orderOfReflexion": { name: "orderOfReflexion", label: "order of reflexion" },
        "osmoticCoefficientOfTheSolventAEspeciallyInADiluteSolution": { name: "osmoticCoefficientOfTheSolventAEspeciallyInADiluteSolution", label: "osmotic coefficient of the solvent A (especially in a dilute solution)" },
        "osmoticPressure": { name: "osmoticPressure", label: "osmotic pressure" },
        "packingFraction": { name: "packingFraction", label: "packing fraction" },
        "partialPressureOfBInAGaseousMixture": { name: "partialPressureOfBInAGaseousMixture", label: "partial pressure of B (in a gaseous mixture)" },
        "particalFluxDensity": { name: "particalFluxDensity", label: "partical flux density" },
        "particleFluence": { name: "particleFluence", label: "particle fluence" },
        "particleFluenceRate": { name: "particleFluenceRate", label: "particle fluence rate" },
        "particlePositionVector": { name: "particlePositionVector", label: "particle position vector" },
        "partitionFunctionOfAMolecule": { name: "partitionFunctionOfAMolecule", label: "partition function of a molecule" },
        "pecletNumber": { name: "pecletNumber", label: "Peclet number" },
        "pecletNumberForMassTransfer": { name: "pecletNumberForMassTransfer", label: "Peclet number for mass transfer" },
        "peltierCoefficientForSubstancesAAndB": { name: "peltierCoefficientForSubstancesAAndB", label: "Peltier coefficient for substances a and b" },
        "performanceCharacteristic": { name: "performanceCharacteristic", label: "performance characteristic" },
        "period": { name: "period", label: "period" },
        "periodicTime": { name: "periodicTime", label: "periodic time" },
        "permeability": { name: "permeability", label: "permeability" },
        "permeabilityOfVacuum": { name: "permeabilityOfVacuum", label: "permeability of vacuum" },
        "permeance": { name: "permeance", label: "permeance" },
        "permittivity": { name: "permittivity", label: "permittivity" },
        "permittivityOfVacuum": { name: "permittivityOfVacuum", label: "permittivity of vacuum" },
        "phaseCoefficient": { name: "phaseCoefficient", label: "phase coefficient" },
        "phaseDifference": { name: "phaseDifference", label: "phase difference" },
        "phaseDisplacement": { name: "phaseDisplacement", label: "phase displacement" },
        "phaseSpeedOfElectromagneticWaves": { name: "phaseSpeedOfElectromagneticWaves", label: "phase speed of electromagnetic waves" },
        "phaseVelocity": { name: "phaseVelocity", label: "phase velocity" },
        "phaseVelocityOfElectromagneticWaves": { name: "phaseVelocityOfElectromagneticWaves", label: "phase velocity of electromagnetic waves" },
        "photonExitance": { name: "photonExitance", label: "photon exitance" },
        "photonExposure": { name: "photonExposure", label: "photon exposure" },
        "photonFlux": { name: "photonFlux", label: "photon flux" },
        "photonIntensity": { name: "photonIntensity", label: "photon intensity" },
        "photonLuminance": { name: "photonLuminance", label: "photon luminance" },
        "photonRadiance": { name: "photonRadiance", label: "photon radiance" },
        "planckConstant": { name: "planckConstant", label: "Planck constant" },
        "planckFunction": { name: "planckFunction", label: "planck function" },
        "poissonNumber": { name: "poissonNumber", label: "poisson number" },
        "poissonRatio": { name: "poissonRatio", label: "poisson ratio" },
        "porosity": { name: "porosity", label: "porosity" },
        "potentialDifference": { name: "potentialDifference", label: "potential difference" },
        "potentialEnergy": { name: "potentialEnergy", label: "potential energy" },
        "power": { name: "power", label: "power" },
        "powerForDirectCurrent": { name: "powerForDirectCurrent", label: "power (for direct current)" },
        "poyntingVector": { name: "poyntingVector", label: "Poynting vector" },
        "prandtlNumber": { name: "prandtlNumber", label: "Prandtl number" },
        "pressure": { name: "pressure", label: "pressure" },
        "pressureCoefficient": { name: "pressureCoefficient", label: "pressure coefficient" },
        "pressureRatio": { name: "pressureRatio", label: "pressure ratio" },
        "principleQuantumNumber": { name: "principleQuantumNumber", label: "principle quantum number" },
        "propagationCoefficient": { name: "propagationCoefficient", label: "propagation coefficient" },
        "protonNumber": { name: "protonNumber", label: "proton number" },
        "pulsatance": { name: "pulsatance", label: "pulsatance" },
        "quantityOfElectricity": { name: "quantityOfElectricity", label: "quantity of electricity" },
        "quantityOfHeat": { name: "quantityOfHeat", label: "quantity of heat" },
        "quantityOfLight": { name: "quantityOfLight", label: "quantity of light" },
        "radiance": { name: "radiance", label: "radiance" },
        "radianceExposure": { name: "radianceExposure", label: "radiance exposure" },
        "radiantEnergy": { name: "radiantEnergy", label: "radiant energy" },
        "radiantEnergyDensity": { name: "radiantEnergyDensity", label: "radiant energy density" },
        "radiantEnergyFluence": { name: "radiantEnergyFluence", label: "radiant energy fluence" },
        "radiantEnergyflux": { name: "radiantEnergyflux", label: "radiant energyflux" },
        "radiantExitance": { name: "radiantExitance", label: "radiant exitance" },
        "radiantIntensity": { name: "radiantIntensity", label: "radiant intensity" },
        "radiantPower": { name: "radiantPower", label: "radiant power" },
        "radius": { name: "radius", label: "radius" },
        "radiusOfCurvature": { name: "radiusOfCurvature", label: "radius of curvature" },
        "ratioOfTheMassicHeatCapacity": { name: "ratioOfTheMassicHeatCapacity", label: "ratio of the massic heat capacity" },
        "ratioOfTheSpecificHeatCapacities": { name: "ratioOfTheSpecificHeatCapacities", label: "ratio of the specific heat capacities" },
        "rayleighNumber": { name: "rayleighNumber", label: "Rayleigh number" },
        "reactance": { name: "reactance", label: "reactance" },
        "reactionEnergy": { name: "reactionEnergy", label: "reaction energy" },
        "reactivePower": { name: "reactivePower", label: "reactive power" },
        "reactivity": { name: "reactivity", label: "reactivity" },
        "reactorTimeConstant": { name: "reactorTimeConstant", label: "reactor time constant" },
        "recombinationCoefficient": { name: "recombinationCoefficient", label: "recombination coefficient" },
        "reflectance": { name: "reflectance", label: "reflectance" },
        "reflectionFactor": { name: "reflectionFactor", label: "reflection factor" },
        "refractiveIndex": { name: "refractiveIndex", label: "refractive index" },
        "relativeActivityOfSolventAEspeciallyInADiluteSolution": { name: "relativeActivityOfSolventAEspeciallyInADiluteSolution", label: "relative activity of solvent A (especially in a dilute solution)" },
        "relativeAtomicMass": { name: "relativeAtomicMass", label: "relative atomic mass" },
        "relativeDensity": { name: "relativeDensity", label: "relative density" },
        "relativeElongation": { name: "relativeElongation", label: "relative elongation" },
        "relativeMassDefect": { name: "relativeMassDefect", label: "relative mass defect" },
        "relativeMassDensity": { name: "relativeMassDensity", label: "relative mass density" },
        "relativeMassExcess": { name: "relativeMassExcess", label: "relative mass excess" },
        "relativeMolecularMass": { name: "relativeMolecularMass", label: "relative molecular mass" },
        "relativePermeability": { name: "relativePermeability", label: "relative permeability" },
        "relativePermittivity": { name: "relativePermittivity", label: "relative permittivity" },
        "relativePressureCoefficient": { name: "relativePressureCoefficient", label: "relative pressure coefficient" },
        "relaxationTime": { name: "relaxationTime", label: "relaxation time" },
        "reluctance": { name: "reluctance", label: "reluctance" },
        "repetency": { name: "repetency", label: "repetency" },
        "residualResistivity": { name: "residualResistivity", label: "residual resistivity" },
        "resistanceLoadPerUnitLength": { name: "resistanceLoadPerUnitLength", label: "resistance load per unit length" },
        "resistanceToAlternatingCurrent": { name: "resistanceToAlternatingCurrent", label: "resistance (to alternating current)" },
        "resistanceToDirectCurrent": { name: "resistanceToDirectCurrent", label: "resistance (to direct current)" },
        "resistivity": { name: "resistivity", label: "resistivity" },
        "resonanceEnergy": { name: "resonanceEnergy", label: "resonance energy" },
        "resonanceEscapeProbability": { name: "resonanceEscapeProbability", label: "resonance escape probability" },
        "restMassOfElectron": { name: "restMassOfElectron", label: "(rest) mass of electron" },
        "restMassOfNeutron": { name: "restMassOfNeutron", label: "(rest) mass of neutron" },
        "restMassOfProton": { name: "restMassOfProton", label: "(rest) mass of proton" },
        "reverberationTime": { name: "reverberationTime", label: "reverberation time" },
        "reynoldsNumber": { name: "reynoldsNumber", label: "Reynolds number" },
        "richardsonConstant": { name: "richardsonConstant", label: "Richardson constant" },
        "rotationalFrequency": { name: "rotationalFrequency", label: "rotational frequency" },
        "rotatoryPower": { name: "rotatoryPower", label: "rotatory power" },
        "rydbergConstant": { name: "rydbergConstant", label: "Rydberg constant" },
        "schmidtNumber": { name: "schmidtNumber", label: "Schmidt number" },
        "secondAxialMomentOfArea": { name: "secondAxialMomentOfArea", label: "second axial moment of area" },
        "secondMomentOfArea": { name: "secondMomentOfArea", label: "second moment of area" },
        "secondPolarMomentOfArea": { name: "secondPolarMomentOfArea", label: "second polar moment of area" },
        "secondRadiationConstant": { name: "secondRadiationConstant", label: "second radiation constant" },
        "sectionModulus": { name: "sectionModulus", label: "section modulus" },
        "seebeckCoefficientForSubstancesAAndB": { name: "seebeckCoefficientForSubstancesAAndB", label: "Seebeck coefficient for substances a and b" },
        "selfInductance": { name: "selfInductance", label: "self inductance" },
        "shearModulus": { name: "shearModulus", label: "shear modulus" },
        "shearStrain": { name: "shearStrain", label: "shear strain" },
        "shearStress": { name: "shearStress", label: "shear stress" },
        "shortRangeOrderParameter": { name: "shortRangeOrderParameter", label: "short-range order parameter" },
        "slowingDownArea": { name: "slowingDownArea", label: "slowing down area" },
        "slowingDownDensity": { name: "slowingDownDensity", label: "slowing down density" },
        "slowingDownLength": { name: "slowingDownLength", label: "slowing-down length" },
        "solidAngle": { name: "solidAngle", label: "solid angle" },
        "soundEnergy": { name: "soundEnergy", label: "sound energy" },
        "soundEnergyDensity": { name: "soundEnergyDensity", label: "sound energy density" },
        "soundExposure": { name: "soundExposure", label: "sound exposure" },
        "soundIntensity": { name: "soundIntensity", label: "sound intensity" },
        "soundPower": { name: "soundPower", label: "sound power" },
        "soundPowerLevel": { name: "soundPowerLevel", label: "sound power level" },
        "soundPressureLevel": { name: "soundPressureLevel", label: "sound pressure level" },
        "soundReductionIndex": { name: "soundReductionIndex", label: "sound reduction index" },
        "specificActivityInASample": { name: "specificActivityInASample", label: "specific activity in a sample" },
        "specificEnergy": { name: "specificEnergy", label: "specific energy" },
        "specificEnergyImparted": { name: "specificEnergyImparted", label: "specific energy imparted" },
        "specificEnthalpy": { name: "specificEnthalpy", label: "specific enthalpy" },
        "specificHeatCapacityAtConstantPressure": { name: "specificHeatCapacityAtConstantPressure", label: "specific heat capacity at constant pressure" },
        "specificHeatCapacityAtConstantVolume": { name: "specificHeatCapacityAtConstantVolume", label: "specific heat capacity at constant volume" },
        "specificHeatCapacityAtSaturation": { name: "specificHeatCapacityAtSaturation", label: "specific heat capacity at saturation" },
        "specificOpticalRotatoryPower": { name: "specificOpticalRotatoryPower", label: "specific optical rotatory power" },
        "specificThermodynamicEnergy": { name: "specificThermodynamicEnergy", label: "specific thermodynamic energy" },
        "specificVolume": { name: "specificVolume", label: "specific volume" },
        "spectralAbsorptance": { name: "spectralAbsorptance", label: "spectral absorptance" },
        "spectralAbsorptionFactor": { name: "spectralAbsorptionFactor", label: "spectral absorption factor" },
        "spectralAngularCrossSection": { name: "spectralAngularCrossSection", label: "spectral angular cross-section" },
        "spectralConcentrationOfRadiantEnergyDensityInTermsOfWavelength": { name: "spectralConcentrationOfRadiantEnergyDensityInTermsOfWavelength", label: "spectral concentration of radiant energy density (in terms of wavelength)" },
        "spectralConcentrationOfVibrationalModesInTermsOfAngularFrequency": { name: "spectralConcentrationOfVibrationalModesInTermsOfAngularFrequency", label: "spectral concentration of vibrational modes (in terms of angular frequency)" },
        "spectralCrossSection": { name: "spectralCrossSection", label: "spectral cross-section" },
        "spectralEmissivity": { name: "spectralEmissivity", label: "spectral emissivity" },
        "spectralLuminousEfficacy": { name: "spectralLuminousEfficacy", label: "spectral luminous efficacy" },
        "spectralLuminousEfficiency": { name: "spectralLuminousEfficiency", label: "spectral luminous efficiency" },
        "spectralRadianceFactor": { name: "spectralRadianceFactor", label: "spectral radiance factor" },
        "spectralRadiantEnergyDensityInTermsOfWaveLength": { name: "spectralRadiantEnergyDensityInTermsOfWaveLength", label: "spectral radiant energy density (in terms of wave length)" },
        "spectralReflectance": { name: "spectralReflectance", label: "spectral reflectance" },
        "spectralReflectionfactor": { name: "spectralReflectionfactor", label: "spectral reflectionfactor" },
        "spectralTransmissionFactor": { name: "spectralTransmissionFactor", label: "spectral transmission factor" },
        "spectralTransmittance": { name: "spectralTransmittance", label: "spectral transmittance" },
        "spinAngularMomentumQuantumNumber": { name: "spinAngularMomentumQuantumNumber", label: "spin angular momentum quantum number" },
        "standardAbsoluteActivityOfBInAGaseousMixture": { name: "standardAbsoluteActivityOfBInAGaseousMixture", label: "standard absolute activity of B (in a gaseous mixture)" },
        "standardAbsoluteActivityOfBInALiquidOrASolidMixture": { name: "standardAbsoluteActivityOfBInALiquidOrASolidMixture", label: "standard absolute activity of B (in a liquid or a solid mixture)" },
        "standardAbsoluteActivityOfSoluteBEspeciallyInADiluteSolution": { name: "standardAbsoluteActivityOfSoluteBEspeciallyInADiluteSolution", label: "standard absolute activity of solute B (especially in a dilute solution)" },
        "standardAbsoluteActivityOfSolventAEspeciallyInADiluteSolution": { name: "standardAbsoluteActivityOfSolventAEspeciallyInADiluteSolution", label: "standard absolute activity of solvent A (especially in a dilute solution)" },
        "standardEquilibriumConstant": { name: "standardEquilibriumConstant", label: "standard equilibrium constant" },
        "stantonNumber": { name: "stantonNumber", label: "Stanton number" },
        "stantonNumberForMassTransfer": { name: "stantonNumberForMassTransfer", label: "Stanton number for mass transfer" },
        "staticPressure": { name: "staticPressure", label: "static pressure" },
        "statisticalWeight": { name: "statisticalWeight", label: "statistical weight" },
        "stefanBoltzmannConstant": { name: "stefanBoltzmannConstant", label: "Stefan-Boltzmann constant" },
        "stoichiometricNumberOfB": { name: "stoichiometricNumberOfB", label: "stoichiometric number of B" },
        "strouhalNumber": { name: "strouhalNumber", label: "Strouhal number" },
        "superConductorTransitionTemperature": { name: "superConductorTransitionTemperature", label: "Super conductor transition temperature" },
        "superconductorEnergyGap": { name: "superconductorEnergyGap", label: "superconductor energy gap" },
        "surfaceCoefficientOfHeatTransfer": { name: "surfaceCoefficientOfHeatTransfer", label: "surface coefficient of heat transfer" },
        "surfaceDensity": { name: "surfaceDensity", label: "surface density" },
        "surfaceDensityOfCharge": { name: "surfaceDensityOfCharge", label: "surface density of charge" },
        "surfaceTension": { name: "surfaceTension", label: "surface tension" },
        "temperature": { name: "temperature", label: "temperature" },
        "temperatureVariationOverTime": { name: "temperatureVariationOverTime", label: "temperature variation over time" },
        "tension": { name: "tension", label: "tension" },
        "thermalConductance": { name: "thermalConductance", label: "thermal conductance" },
        "thermalConductivity": { name: "thermalConductivity", label: "thermal conductivity" },
        "thermalDiffusionCoefficient": { name: "thermalDiffusionCoefficient", label: "thermal diffusion coefficient" },
        "thermalDiffusionFactor": { name: "thermalDiffusionFactor", label: "thermal diffusion factor" },
        "thermalDiffusionRatio": { name: "thermalDiffusionRatio", label: "thermal diffusion ratio" },
        "thermalDiffusivity": { name: "thermalDiffusivity", label: "thermal diffusivity" },
        "thermalInsulance": { name: "thermalInsulance", label: "thermal insulance" },
        "thermalResistance": { name: "thermalResistance", label: "thermal resistance" },
        "thermalUtilizationFactor": { name: "thermalUtilizationFactor", label: "thermal utilization factor" },
        "thermodynamic": { name: "thermodynamic", label: "thermodynamic" },
        "thermodynamicCriticalMagneticFluxDensity": { name: "thermodynamicCriticalMagneticFluxDensity", label: "thermodynamic critical magnetic flux density" },
        "thermodynamicEnergy": { name: "thermodynamicEnergy", label: "thermodynamic energy" },
        "thermoelectromotiveForceBetweenSubstancesAAndB": { name: "thermoelectromotiveForceBetweenSubstancesAAndB", label: "thermoelectromotive force between substances a and b" },
        "thickness": { name: "thickness", label: "thickness" },
        "thompsonCoefficient": { name: "thompsonCoefficient", label: "Thompson coefficient" },
        "time": { name: "time", label: "time" },
        "timeConstant": { name: "timeConstant", label: "time constant" },
        "torque": { name: "torque", label: "torque" },
        "torsionalStiffness": { name: "torsionalStiffness", label: "torsional stiffness" },
        "totalAngularMomentumQuantumNumber": { name: "totalAngularMomentumQuantumNumber", label: "total angular momentum quantum number" },
        "totalAtomicStoppingPower": { name: "totalAtomicStoppingPower", label: "total atomic stopping power" },
        "totalCrossSection": { name: "totalCrossSection", label: "total cross-section" },
        "totalIonizationByAParticle": { name: "totalIonizationByAParticle", label: "total ionization by a particle" },
        "totalLinearStoppingPower": { name: "totalLinearStoppingPower", label: "total linear stopping power" },
        "totalMassStoppingPower": { name: "totalMassStoppingPower", label: "total mass stopping power" },
        "transmissionFactor": { name: "transmissionFactor", label: "transmission factor" },
        "transmittance": { name: "transmittance", label: "transmittance" },
        "transportNumberOfIonB": { name: "transportNumberOfIonB", label: "transport number of ion B" },
        "unifiedAtomicMassConstant": { name: "unifiedAtomicMassConstant", label: "unified atomic mass constant" },
        "upperCriticalMagneticFluxDensity": { name: "upperCriticalMagneticFluxDensity", label: "upper critical magnetic flux density" },
        "velocity": { name: "velocity", label: "velocity" },
        "velocityOfSoundPhaseVelocity": { name: "velocityOfSoundPhaseVelocity", label: "velocity of sound (phase velocity)" },
        "velocitySpeedOnPropagationOfElectromagneticWavesInVacuo": { name: "velocitySpeedOnPropagationOfElectromagneticWavesInVacuo", label: "velocity (speed) on propagation of electromagnetic waves in vacuo" },
        "vergence": { name: "vergence", label: "vergence" },
        "viscosityDynamicViscosity": { name: "viscosityDynamicViscosity", label: "viscosity (dynamic viscosity)" },
        "voltage": { name: "voltage", label: "voltage" },
        "volume": { name: "volume", label: "volume" },
        "volumeDensityOfCharge": { name: "volumeDensityOfCharge", label: "volume density of charge" },
        "volumeFlowRate": { name: "volumeFlowRate", label: "volume flow rate" },
        "volumeOrBulkStrain": { name: "volumeOrBulkStrain", label: "volume or bulk strain" },
        "volumePerTemperature": { name: "volumePerTemperature", label: "volume per temperature" },
        "volumeRatio": { name: "volumeRatio", label: "volume ratio" },
        "volumic": { name: "volumic", label: "volumic" },
        "volumicAcceptorNumber": { name: "volumicAcceptorNumber", label: "volumic acceptor number" },
        "volumicActivity": { name: "volumicActivity", label: "volumic activity" },
        "volumicCharge": { name: "volumicCharge", label: "volumic charge" },
        "volumicCrossSection": { name: "volumicCrossSection", label: "volumic cross-section" },
        "volumicDonorNumber": { name: "volumicDonorNumber", label: "volumic donor number" },
        "volumicDose": { name: "volumicDose", label: "volumic dose" },
        "volumicElectromagneticEnergy": { name: "volumicElectromagneticEnergy", label: "volumic electromagnetic energy" },
        "volumicElectronNumber": { name: "volumicElectronNumber", label: "volumic electron number" },
        "volumicHoleNumber": { name: "volumicHoleNumber", label: "volumic hole number" },
        "volumicIntrinsisNumber": { name: "volumicIntrinsisNumber", label: "volumic intrinsis number" },
        "volumicMass": { name: "volumicMass", label: "volumic mass" },
        "volumicNumberOfMoleculesOrParticles": { name: "volumicNumberOfMoleculesOrParticles", label: "volumic number of molecules (or particles)" },
        "volumicTotalCrossSection": { name: "volumicTotalCrossSection", label: "volumic total cross-section" },
        "waveNumber": { name: "waveNumber", label: "wave number" },
        "wavelength": { name: "wavelength", label: "wavelength" },
        "wavenumber": { name: "wavenumber", label: "wavenumber" },
        "weberNumber": { name: "weberNumber", label: "Weber number" },
        "weight": { name: "weight", label: "weight" },
        "work": { name: "work", label: "work" },
        "workFunction": { name: "workFunction", label: "work function" },
        "workPerUnitWeight": { name: "workPerUnitWeight", label: "work per unit weight" }
    },

    units: {
        "accessLine": { name: "accessLine", label: "access line", symbol: null, code: "AL", referenceUnit: null, conversionFactor: null, quantityKinds: null },
        "accountingUnit": { name: "accountingUnit", label: "accounting unit", symbol: null, code: "E50", referenceUnit: null, conversionFactor: null, quantityKinds: null },
        "acre": { name: "acre", label: "acre", symbol: "acre", code: "ACR", referenceUnit: function() { return samm.units["squareMetre"] }, conversionFactor: "4046.873 m²", quantityKinds: [ "area", "area", "atomicAttenuationCoefficient", "migrationArea", "crossSection", "equivalentAbsorptionAreaOfASurfaceOrObject", "nuclearQuadrupoleMoment", "slowingDownArea", "diffusionArea" ] },
        "acreFootBasedOnUsSurveyFoot": { name: "acreFootBasedOnUsSurveyFoot", label: "acre-foot (based on U.S. survey foot)", symbol: "acre-ft (US survey)", code: "M67", referenceUnit: function() { return samm.units["cubicMetre"] }, conversionFactor: "1.233489 × 10³ m³", quantityKinds: [ "volume", "volume", "sectionModulus" ] },
        "activeUnit": { name: "activeUnit", label: "active unit", symbol: null, code: "E25", referenceUnit: null, conversionFactor: null, quantityKinds: null },
        "actualPer360": { name: "actualPer360", label: "actual/360", symbol: "y (360 days)", code: "M37", referenceUnit: function() { return samm.units["secondUnitOfTime"] }, conversionFactor: "3.1104000 × 10⁷ s", quantityKinds: [ "timeConstant", "reactorTimeConstant", "halfLife", "meanLife", "time", "relaxationTime", "period", "carrierLifeTime", "periodicTime", "reverberationTime" ] },
        "additionalMinute": { name: "additionalMinute", label: "additional minute", symbol: null, code: "AH", referenceUnit: null, conversionFactor: null, quantityKinds: null },
        "airDryMetricTon": { name: "airDryMetricTon", label: "air dry metric ton", symbol: null, code: "MD", referenceUnit: null, conversionFactor: null, quantityKinds: null },
        "airDryTon": { name: "airDryTon", label: "air dry ton", symbol: null, code: "E28", referenceUnit: null, conversionFactor: null, quantityKinds: null },
        "alcoholicStrengthByMass": { name: "alcoholicStrengthByMass", label: "alcoholic strength by mass", symbol: null, code: "ASM", referenceUnit: null, conversionFactor: null, quantityKinds: null },
        "alcoholicStrengthByVolume": { name: "alcoholicStrengthByVolume", label: "alcoholic strength by volume", symbol: null, code: "ASU", referenceUnit: null, conversionFactor: null, quantityKinds: null },
        "ampere": { name: "ampere", label: "ampere", symbol: "A", code: "AMP", referenceUnit: null, conversionFactor: null, quantityKinds: [ "magnetomotiveForce", "currentLinkage", "magneticPotentialDifference", "electricCurrent" ] },
        "ampereHour": { name: "ampereHour", label: "ampere hour", symbol: "A·h", code: "AMH", referenceUnit: function() { return samm.units["coulomb"] }, conversionFactor: "3.6 × 10³ C", quantityKinds: [ "electricCharge", "quantityOfElectricity", "electricFluxFluxOfDisplacement", "elementaryCharge", "electricFluxFluxOfDisplacement", "electricCharge", "quantityOfElectricity" ] },
        "ampereMinute": { name: "ampereMinute", label: "ampere minute", symbol: "A·min", code: "N95", referenceUnit: function() { return samm.units["coulomb"] }, conversionFactor: "60 C", quantityKinds: [ "elementaryCharge", "electricFluxFluxOfDisplacement", "electricCharge", "quantityOfElectricity", "electricCharge", "quantityOfElectricity", "electricFluxFluxOfDisplacement" ] },
        "amperePerCentimetre": { name: "amperePerCentimetre", label: "ampere per centimetre", symbol: "A/cm", code: "A2", referenceUnit: function() { return samm.units["amperePerMetre"] }, conversionFactor: "10² A/m", quantityKinds: [ "lineicElectricCurrent", "magneticFieldStrength", "magnetization", "linearElectricCurrentDensity", "linearElectricCurrentDensity", "magneticFieldStrength", "lineicElectricCurrent" ] },
        "amperePerKilogram": { name: "amperePerKilogram", label: "ampere per kilogram", symbol: "A/kg", code: "H31", referenceUnit: null, conversionFactor: null, quantityKinds: [ "currentDensity" ] },
        "amperePerMetre": { name: "amperePerMetre", label: "ampere per metre", symbol: "A/m", code: "AE", referenceUnit: null, conversionFactor: null, quantityKinds: [ "lineicElectricCurrent", "magneticFieldStrength", "magnetization", "linearElectricCurrentDensity" ] },
        "amperePerMillimetre": { name: "amperePerMillimetre", label: "ampere per millimetre", symbol: "A/mm", code: "A3", referenceUnit: function() { return samm.units["amperePerMetre"] }, conversionFactor: "10³ A/m", quantityKinds: [ "lineicElectricCurrent", "magneticFieldStrength", "magnetization", "linearElectricCurrentDensity", "linearElectricCurrentDensity", "lineicElectricCurrent", "magneticFieldStrength" ] },
        "amperePerPascal": { name: "amperePerPascal", label: "ampere per pascal", symbol: "A/Pa", code: "N93", referenceUnit: null, conversionFactor: null, quantityKinds: [ "currentDensity" ] },
        "amperePerSquareCentimetre": { name: "amperePerSquareCentimetre", label: "ampere per square centimetre", symbol: "A/cm²", code: "A4", referenceUnit: function() { return samm.units["amperePerSquareMetre"] }, conversionFactor: "10⁴ A/m²", quantityKinds: [ "currentDensity", "currentDensity" ] },
        "amperePerSquareMetre": { name: "amperePerSquareMetre", label: "ampere per square metre", symbol: "A/m²", code: "A41", referenceUnit: null, conversionFactor: null, quantityKinds: [ "currentDensity" ] },
        "amperePerSquareMetreKelvinSquared": { name: "amperePerSquareMetreKelvinSquared", label: "ampere per square metre kelvin squared", symbol: "A/(m²·K²)", code: "A6", referenceUnit: null, conversionFactor: null, quantityKinds: [ "richardsonConstant" ] },
        "amperePerSquareMillimetre": { name: "amperePerSquareMillimetre", label: "ampere per square millimetre", symbol: "A/mm²", code: "A7", referenceUnit: function() { return samm.units["amperePerSquareMetre"] }, conversionFactor: "10⁶ A/m²", quantityKinds: [ "currentDensity", "currentDensity" ] },
        "ampereSecond": { name: "ampereSecond", label: "ampere second", symbol: "A·s", code: "A8", referenceUnit: function() { return samm.units["coulomb"] }, conversionFactor: "C", quantityKinds: [ "elementaryCharge", "electricFluxFluxOfDisplacement", "electricCharge", "quantityOfElectricity", "electricFluxFluxOfDisplacement", "electricCharge", "quantityOfElectricity" ] },
        "ampereSquareMetre": { name: "ampereSquareMetre", label: "ampere square metre", symbol: "A·m²", code: "A5", referenceUnit: null, conversionFactor: null, quantityKinds: [ "nuclearMagnetonOrnucleus", "bohrMagneton", "magneticMomentOfParticle", "electromagneticMoment", "magneticMoment", "magneticAreaMoment" ] },
        "ampereSquareMetrePerJouleSecond": { name: "ampereSquareMetrePerJouleSecond", label: "ampere square metre per joule second", symbol: "A·m²/(J·s)", code: "A10", referenceUnit: null, conversionFactor: null, quantityKinds: [ "gyromagneticRatio", "gyromagneticCoefficient" ] },
        "ampereSquaredSecond": { name: "ampereSquaredSecond", label: "ampere squared second", symbol: "A²·s", code: "H32", referenceUnit: null, conversionFactor: null, quantityKinds: [ "quantityOfElectricity", "electricFluxFluxOfDisplacement", "electricCharge" ] },
        "angstrom": { name: "angstrom", label: "angstrom", symbol: "Å", code: "A11", referenceUnit: function() { return samm.units["metre"] }, conversionFactor: "10⁻¹⁰ m", quantityKinds: [ "thickness", "particlePositionVector", "cartesianCoordinates", "focalDistance", "radius", "radiusOfCurvature", "displacementVectorOfIonOrAtom", "lengthOfPath", "diameter", "comptonWavelength", "slowingDownLength", "migrationLength", "meanFreePath", "equilibriumPositionVectorOfIonOrAtom", "instantaneousSoundParticleDisplacement", "imageDistance", "breadth", "length", "halfValueThickness", "coherenceLength", "latticeVector", "londonPenetrationDepth", "diffusionLength", "meanFreePathOfPhononsOrElectrons", "diffusionCoefficientForNeutronFluxDensity", "halfThickness", "height", "electronRadius", "distance", "objectDistance", "bohrRadius", "diffusionCoefficientForNeutronFluenceRate", "nuclearRadius", "wavelength", "fundamentalLatticeVector", "meanLinearRange", "distance", "wavelength", "burgersVector", "cartesianCoordinates", "radius", "length", "radiusOfCurvature", "lengthOfPath", "latticePlaneSpacing", "height", "bohrRadius", "breadth", "diameter", "thickness" ] },
        "antiHemophilicFactorAhfUnit": { name: "antiHemophilicFactorAhfUnit", label: "anti-hemophilic factor (AHF) unit", symbol: null, code: "AQ", referenceUnit: null, conversionFactor: null, quantityKinds: null },
        "assembly": { name: "assembly", label: "assembly", symbol: null, code: "AY", referenceUnit: null, conversionFactor: null, quantityKinds: null },
        "assortment": { name: "assortment", label: "assortment", symbol: null, code: "AS", referenceUnit: null, conversionFactor: null, quantityKinds: null },
        "astronomicalUnit": { name: "astronomicalUnit", label: "astronomical unit", symbol: "ua", code: "A12", referenceUnit: function() { return samm.units["metre"] }, conversionFactor: "1.49597870 × 10¹¹ m", quantityKinds: [ "thickness", "particlePositionVector", "cartesianCoordinates", "focalDistance", "radius", "radiusOfCurvature", "displacementVectorOfIonOrAtom", "lengthOfPath", "diameter", "comptonWavelength", "slowingDownLength", "migrationLength", "meanFreePath", "equilibriumPositionVectorOfIonOrAtom", "instantaneousSoundParticleDisplacement", "imageDistance", "breadth", "length", "halfValueThickness", "coherenceLength", "latticeVector", "londonPenetrationDepth", "diffusionLength", "meanFreePathOfPhononsOrElectrons", "diffusionCoefficientForNeutronFluxDensity", "halfThickness", "height", "electronRadius", "distance", "objectDistance", "bohrRadius", "diffusionCoefficientForNeutronFluenceRate", "nuclearRadius", "wavelength", "fundamentalLatticeVector", "meanLinearRange", "radius", "height", "radiusOfCurvature", "thickness", "diameter", "breadth", "cartesianCoordinates", "distance", "lengthOfPath", "length" ] },
        "attofarad": { name: "attofarad", label: "attofarad", symbol: "aF", code: "H48", referenceUnit: null, conversionFactor: null, quantityKinds: [ "capacitance" ] },
        "attojoule": { name: "attojoule", label: "attojoule", symbol: "aJ", code: "A13", referenceUnit: function() { return samm.units["joule"] }, conversionFactor: "10⁻¹⁸ J", quantityKinds: [ "quantityOfHeat", "reactionEnergy", "workFunction", "activeEnergy", "kineticEnergy", "levelWidth", "meanEnergyImparted", "helmholtzFunction", "radiantEnergy", "potentialEnergy", "energy", "thermodynamicEnergy", "helmholtzFreeEnergy", "work", "heat", "hartreeEnergy", "energyImparted", "enthalpy", "alphaDisintegrationEnergy", "exchangeIntergral", "kineticEnergy", "energy", "superconductorEnergyGap", "electronAffinity", "potentialEnergy", "work", "donorIonizationEnergy", "acceptorIonizationEnergy" ] },
        "averageMinutePerCall": { name: "averageMinutePerCall", label: "average minute per call", symbol: null, code: "AI", referenceUnit: null, conversionFactor: null, quantityKinds: null },
        "ball": { name: "ball", label: "ball", symbol: null, code: "AA", referenceUnit: null, conversionFactor: null, quantityKinds: null },
        "barCubicMetrePerSecond": { name: "barCubicMetrePerSecond", label: "bar cubic metre per second", symbol: "bar·m³/s", code: "F92", referenceUnit: null, conversionFactor: null, quantityKinds: [ "leakageRateOfGas" ] },
        "barLitrePerSecond": { name: "barLitrePerSecond", label: "bar litre per second", symbol: "bar·l/s", code: "F91", referenceUnit: null, conversionFactor: null, quantityKinds: [ "leakageRateOfGas" ] },
        "barPerBar": { name: "barPerBar", label: "bar per bar", symbol: "bar/bar", code: "J56", referenceUnit: null, conversionFactor: null, quantityKinds: [ "pressureRatio" ] },
        "barPerKelvin": { name: "barPerKelvin", label: "bar per kelvin", symbol: "bar/K", code: "F81", referenceUnit: null, conversionFactor: null, quantityKinds: [ "pressureCoefficient" ] },
        "barUnitOfPressure": { name: "barUnitOfPressure", label: "bar [unit of pressure]", symbol: "bar", code: "BAR", referenceUnit: function() { return samm.units["pascal"] }, conversionFactor: "10⁵ Pa", quantityKinds: [ "fugacityOfBInAGaseousMixture", "pressure", "shearModulus", "staticPressure", "normalStress", "modulusOfRigidity", "instantaneousSoundPressure", "modulusOfElasticity", "shearStress", "modulusOfCompression", "partialPressureOfBInAGaseousMixture", "bulkModulus", "osmoticPressure", "modulusOfCompression", "modulusOfElasticity", "modulusOfRigidity", "instantaneousSoundPressure", "normalStress", "pressure", "shearModulus", "staticPressure", "bulkModulus", "shearStress" ] },
        "barn": { name: "barn", label: "barn", symbol: "b", code: "A14", referenceUnit: function() { return samm.units["squareMetre"] }, conversionFactor: "10⁻²⁸ m²", quantityKinds: [ "area", "atomicAttenuationCoefficient", "migrationArea", "crossSection", "equivalentAbsorptionAreaOfASurfaceOrObject", "nuclearQuadrupoleMoment", "slowingDownArea", "diffusionArea", "totalCrossSection" ] },
        "barnPerElectronvolt": { name: "barnPerElectronvolt", label: "barn per electronvolt", symbol: "b/eV", code: "A15", referenceUnit: function() { return samm.units["squareMetrePerJoule"] }, conversionFactor: "6.241 51 × 10⁻¹⁰ m²/J", quantityKinds: [ "spectralCrossSection", "spectralCrossSection" ] },
        "barnPerSteradian": { name: "barnPerSteradian", label: "barn per steradian", symbol: "b/sr", code: "A17", referenceUnit: function() { return samm.units["squareMetrePerSteradian"] }, conversionFactor: "1 × 10⁻²⁸ m²/sr", quantityKinds: [ "angularCrossSection", "angularCrossSection" ] },
        "barnPerSteradianElectronvolt": { name: "barnPerSteradianElectronvolt", label: "barn per steradian electronvolt", symbol: "b/(sr·eV)", code: "A16", referenceUnit: null, conversionFactor: null, quantityKinds: [ "spectralAngularCrossSection" ] },
        "barrelImperial": { name: "barrelImperial", label: "barrel, imperial", symbol: null, code: "B4", referenceUnit: null, conversionFactor: null, quantityKinds: null },
        "barrelUkPetroleum": { name: "barrelUkPetroleum", label: "barrel (UK petroleum)", symbol: "bbl (UK liq.)", code: "J57", referenceUnit: function() { return samm.units["cubicMetre"] }, conversionFactor: "0.15911315 m³", quantityKinds: [ "volume", "sectionModulus", "volume" ] },
        "barrelUkPetroleumPerDay": { name: "barrelUkPetroleumPerDay", label: "barrel (UK petroleum) per day", symbol: "bbl (UK liq.)/d", code: "J59", referenceUnit: function() { return samm.units["cubicMetrePerSecond"] }, conversionFactor: "1.8415874 × 10⁻⁶ m³/s", quantityKinds: [ "volumeFlowRate", "recombinationCoefficient", "instantaneousVolumeFlowRate", "volumeFlowRate" ] },
        "barrelUkPetroleumPerHour": { name: "barrelUkPetroleumPerHour", label: "barrel (UK petroleum) per hour", symbol: "bbl (UK liq.)/h", code: "J60", referenceUnit: function() { return samm.units["cubicMetrePerSecond"] }, conversionFactor: "4.419810 × 10⁻⁵ m³/s", quantityKinds: [ "volumeFlowRate", "recombinationCoefficient", "instantaneousVolumeFlowRate", "volumeFlowRate" ] },
        "barrelUkPetroleumPerMinute": { name: "barrelUkPetroleumPerMinute", label: "barrel (UK petroleum) per minute", symbol: "bbl (UK liq.)/min", code: "J58", referenceUnit: function() { return samm.units["cubicMetrePerSecond"] }, conversionFactor: "2.651886 m³/s", quantityKinds: [ "volumeFlowRate", "recombinationCoefficient", "instantaneousVolumeFlowRate", "volumeFlowRate" ] },
        "barrelUkPetroleumPerSecond": { name: "barrelUkPetroleumPerSecond", label: "barrel (UK petroleum) per second", symbol: "bbl (UK liq.)/s", code: "J61", referenceUnit: function() { return samm.units["cubicMetrePerSecond"] }, conversionFactor: "0.15911315 m³/s", quantityKinds: [ "volumeFlowRate", "recombinationCoefficient", "instantaneousVolumeFlowRate", "volumeFlowRate" ] },
        "barrelUs": { name: "barrelUs", label: "barrel (US)", symbol: "barrel (US)", code: "BLL", referenceUnit: function() { return samm.units["cubicMetre"] }, conversionFactor: "158.9873 × 10⁻³ m³", quantityKinds: [ "volume", "sectionModulus", "volume" ] },
        "barrelUsPerDay": { name: "barrelUsPerDay", label: "barrel (US) per day", symbol: "barrel (US)/d", code: "B1", referenceUnit: function() { return samm.units["cubicMetrePerSecond"] }, conversionFactor: "1.84013 × 10⁻⁶ m³/s", quantityKinds: [ "volumeFlowRate", "recombinationCoefficient", "instantaneousVolumeFlowRate" ] },
        "barrelUsPerMinute": { name: "barrelUsPerMinute", label: "barrel (US) per minute", symbol: "barrel (US)/min", code: "5A", referenceUnit: function() { return samm.units["cubicMetrePerSecond"] }, conversionFactor: "2.64979 × 10⁻³ m³/s", quantityKinds: [ "volumeFlowRate", "recombinationCoefficient", "instantaneousVolumeFlowRate", "volumeFlowRate" ] },
        "barrelUsPetroleumPerHour": { name: "barrelUsPetroleumPerHour", label: "barrel (US petroleum) per hour", symbol: "bbl (US)/h", code: "J62", referenceUnit: function() { return samm.units["cubicMetrePerSecond"] }, conversionFactor: "4.416314 × 10⁻⁵ m³/s", quantityKinds: [ "volumeFlowRate", "volumeFlowRate", "recombinationCoefficient", "instantaneousVolumeFlowRate" ] },
        "barrelUsPetroleumPerSecond": { name: "barrelUsPetroleumPerSecond", label: "barrel (US petroleum) per second", symbol: "bbl (US)/s", code: "J63", referenceUnit: function() { return samm.units["cubicMetrePerSecond"] }, conversionFactor: "0.1589873 m³/s", quantityKinds: [ "volumeFlowRate", "volumeFlowRate", "recombinationCoefficient", "instantaneousVolumeFlowRate" ] },
        "baseBox": { name: "baseBox", label: "base box", symbol: null, code: "BB", referenceUnit: null, conversionFactor: null, quantityKinds: null },
        "batch": { name: "batch", label: "batch", symbol: null, code: "5B", referenceUnit: null, conversionFactor: null, quantityKinds: null },
        "battingPound": { name: "battingPound", label: "batting pound", symbol: null, code: "B3", referenceUnit: null, conversionFactor: null, quantityKinds: null },
        "baud": { name: "baud", label: "baud", symbol: "Bd", code: "J38", referenceUnit: null, conversionFactor: null, quantityKinds: null },
        "beaufort": { name: "beaufort", label: "Beaufort", symbol: "Bft", code: "M19", referenceUnit: null, conversionFactor: null, quantityKinds: null },
        "becquerel": { name: "becquerel", label: "becquerel", symbol: "Bq", code: "BQL", referenceUnit: function() { return samm.units["curie"] }, conversionFactor: "27.027 × 10⁻¹² Ci", quantityKinds: [ "activity", "activity" ] },
        "becquerelPerCubicMetre": { name: "becquerelPerCubicMetre", label: "becquerel per cubic metre", symbol: "Bq/m³", code: "A19", referenceUnit: null, conversionFactor: null, quantityKinds: [ "volumicActivity", "activityConcentration" ] },
        "becquerelPerKilogram": { name: "becquerelPerKilogram", label: "becquerel per kilogram", symbol: "Bq/kg", code: "A18", referenceUnit: function() { return samm.units["curiePerKilogram"] }, conversionFactor: "27.027 × 10⁻¹² Ci/kg", quantityKinds: [ "specificActivityInASample", "specificActivityInASample" ] },
        "bel": { name: "bel", label: "bel", symbol: "B", code: "M72", referenceUnit: null, conversionFactor: null, quantityKinds: [ "levelOfAPowerQuantity", "levelOfAFieldQuantity" ] },
        "belPerMetre": { name: "belPerMetre", label: "bel per metre", symbol: "B/m", code: "P43", referenceUnit: null, conversionFactor: null, quantityKinds: [ "soundPressureLevel", "soundPowerLevel" ] },
        "bigPoint": { name: "bigPoint", label: "big point", symbol: "bp", code: "H82", referenceUnit: function() { return samm.units["metre"] }, conversionFactor: "0.3527778 × 10⁻³ m", quantityKinds: [ "thickness", "particlePositionVector", "cartesianCoordinates", "focalDistance", "radius", "radiusOfCurvature", "displacementVectorOfIonOrAtom", "lengthOfPath", "diameter", "comptonWavelength", "slowingDownLength", "migrationLength", "meanFreePath", "equilibriumPositionVectorOfIonOrAtom", "instantaneousSoundParticleDisplacement", "imageDistance", "breadth", "length", "halfValueThickness", "coherenceLength", "latticeVector", "londonPenetrationDepth", "diffusionLength", "meanFreePathOfPhononsOrElectrons", "diffusionCoefficientForNeutronFluxDensity", "halfThickness", "height", "electronRadius", "distance", "objectDistance", "bohrRadius", "diffusionCoefficientForNeutronFluenceRate", "nuclearRadius", "wavelength", "fundamentalLatticeVector", "meanLinearRange" ] },
        "billionEur": { name: "billionEur", label: "billion (EUR)", symbol: null, code: "BIL", referenceUnit: null, conversionFactor: null, quantityKinds: null },
        "biot": { name: "biot", label: "biot", symbol: "Bi", code: "N96", referenceUnit: function() { return samm.units["ampere"] }, conversionFactor: "10¹ A", quantityKinds: [ "magnetomotiveForce", "currentLinkage", "magneticPotentialDifference", "electricCurrent", "magnetomotiveForce", "currentLinkage", "magneticPotentialDifference", "electricCurrent" ] },
        "bit": { name: "bit", label: "bit", symbol: "b", code: "A99", referenceUnit: null, conversionFactor: null, quantityKinds: [ "informationEntropy" ] },
        "bitPerCubicMetre": { name: "bitPerCubicMetre", label: "bit per cubic metre", symbol: "bit/m³", code: "F01", referenceUnit: null, conversionFactor: null, quantityKinds: null },
        "bitPerMetre": { name: "bitPerMetre", label: "bit per metre", symbol: "bit/m", code: "E88", referenceUnit: null, conversionFactor: null, quantityKinds: null },
        "bitPerSecond": { name: "bitPerSecond", label: "bit per second", symbol: "bit/s", code: "B10", referenceUnit: null, conversionFactor: null, quantityKinds: null },
        "bitPerSquareMetre": { name: "bitPerSquareMetre", label: "bit per square metre", symbol: "bit/m²", code: "E89", referenceUnit: null, conversionFactor: null, quantityKinds: null },
        "blank": { name: "blank", label: "blank", symbol: null, code: "H21", referenceUnit: null, conversionFactor: null, quantityKinds: null },
        "boardFoot": { name: "boardFoot", label: "board foot", symbol: "fbm", code: "BFT", referenceUnit: null, conversionFactor: null, quantityKinds: null },
        "book": { name: "book", label: "book", symbol: null, code: "D63", referenceUnit: null, conversionFactor: null, quantityKinds: null },
        "brakeHorsePower": { name: "brakeHorsePower", label: "brake horse power", symbol: "BHP", code: "BHP", referenceUnit: function() { return samm.units["watt"] }, conversionFactor: "7.457 × 10² W", quantityKinds: [ "radiantEnergyflux", "activePower", "heatFlowRate", "soundPower", "power", "radiantPower", "powerForDirectCurrent", "power" ] },
        "britishThermalUnit39Degreesf": { name: "britishThermalUnit39Degreesf", label: "British thermal unit (39 °F)", symbol: "Btu (39 °F)", code: "N66", referenceUnit: function() { return samm.units["joule"] }, conversionFactor: "1.05967 × 10³ J", quantityKinds: [ "quantityOfHeat", "reactionEnergy", "workFunction", "activeEnergy", "kineticEnergy", "levelWidth", "meanEnergyImparted", "helmholtzFunction", "radiantEnergy", "potentialEnergy", "energy", "thermodynamicEnergy", "helmholtzFreeEnergy", "work", "heat", "hartreeEnergy", "energyImparted", "enthalpy", "alphaDisintegrationEnergy", "enthalpy", "energy", "helmholtzFreeEnergy", "thermodynamicEnergy", "helmholtzFunction", "quantityOfHeat", "heat" ] },
        "britishThermalUnit59Degreesf": { name: "britishThermalUnit59Degreesf", label: "British thermal unit (59 °F)", symbol: "Btu (59 °F)", code: "N67", referenceUnit: function() { return samm.units["joule"] }, conversionFactor: "1.05480 × 10³ J", quantityKinds: [ "quantityOfHeat", "reactionEnergy", "workFunction", "activeEnergy", "kineticEnergy", "levelWidth", "meanEnergyImparted", "helmholtzFunction", "radiantEnergy", "potentialEnergy", "energy", "thermodynamicEnergy", "helmholtzFreeEnergy", "work", "heat", "hartreeEnergy", "energyImparted", "enthalpy", "alphaDisintegrationEnergy", "energy", "heat", "helmholtzFunction", "enthalpy", "thermodynamicEnergy", "helmholtzFreeEnergy", "quantityOfHeat" ] },
        "britishThermalUnit60Degreesf": { name: "britishThermalUnit60Degreesf", label: "British thermal unit (60 °F)", symbol: "Btu (60 °F)", code: "N68", referenceUnit: function() { return samm.units["joule"] }, conversionFactor: "1.05468 × 10³ J", quantityKinds: [ "quantityOfHeat", "reactionEnergy", "workFunction", "activeEnergy", "kineticEnergy", "levelWidth", "meanEnergyImparted", "helmholtzFunction", "radiantEnergy", "potentialEnergy", "energy", "thermodynamicEnergy", "helmholtzFreeEnergy", "work", "heat", "hartreeEnergy", "energyImparted", "enthalpy", "alphaDisintegrationEnergy", "thermodynamicEnergy", "enthalpy", "heat", "energy", "helmholtzFunction", "helmholtzFreeEnergy", "quantityOfHeat" ] },
        "britishThermalUnitInternationalTable": { name: "britishThermalUnitInternationalTable", label: "British thermal unit (international table)", symbol: "BtuIT", code: "BTU", referenceUnit: function() { return samm.units["joule"] }, conversionFactor: "1.055056 × 10³ J", quantityKinds: [ "energy", "quantityOfHeat", "helmholtzFunction", "enthalpy", "heat", "helmholtzFreeEnergy", "thermodynamicEnergy", "quantityOfHeat", "reactionEnergy", "workFunction", "activeEnergy", "kineticEnergy", "levelWidth", "meanEnergyImparted", "helmholtzFunction", "radiantEnergy", "potentialEnergy", "energy", "thermodynamicEnergy", "helmholtzFreeEnergy", "work", "heat", "hartreeEnergy", "energyImparted", "enthalpy", "alphaDisintegrationEnergy" ] },
        "britishThermalUnitInternationalTableFootPerHourSquareFootDegreeFahrenheit": { name: "britishThermalUnitInternationalTableFootPerHourSquareFootDegreeFahrenheit", label: "British thermal unit (international table) foot per hour square foot degree Fahrenheit", symbol: "BtuIT·ft/(h·ft²·°F)", code: "J40", referenceUnit: function() { return samm.units["wattPerMetreKelvin"] }, conversionFactor: "1.730735 W/(m × K)", quantityKinds: [ "thermalConductivity", "thermalConductivity" ] },
        "britishThermalUnitInternationalTableInchPerHourSquareFootDegreeFahrenheit": { name: "britishThermalUnitInternationalTableInchPerHourSquareFootDegreeFahrenheit", label: "British thermal unit (international table) inch per hour square foot degree Fahrenheit", symbol: "BtuIT·in/(h·ft²·°F)", code: "J41", referenceUnit: function() { return samm.units["wattPerMetreKelvin"] }, conversionFactor: "0.1442279 W/(m × K)", quantityKinds: [ "thermalConductivity", "thermalConductivity" ] },
        "britishThermalUnitInternationalTableInchPerSecondSquareFootDegreeFahrenheit": { name: "britishThermalUnitInternationalTableInchPerSecondSquareFootDegreeFahrenheit", label: "British thermal unit (international table) inch per second square foot degree Fahrenheit", symbol: "BtuIT·in/(s·ft²·°F)", code: "J42", referenceUnit: function() { return samm.units["wattPerMetreKelvin"] }, conversionFactor: "5.192204 × 10² W/(m × K)", quantityKinds: [ "thermalConductivity", "thermalConductivity" ] },
        "britishThermalUnitInternationalTablePerCubicFoot": { name: "britishThermalUnitInternationalTablePerCubicFoot", label: "British thermal unit (international table) per cubic foot", symbol: "BtuIT/ft³", code: "N58", referenceUnit: function() { return samm.units["joulePerCubicMetre"] }, conversionFactor: "3.725895 ×10⁴ J/m³", quantityKinds: [ "soundEnergy", "volumic", "volumicElectromagneticEnergy", "soundEnergyDensity", "radiantEnergyDensity", "electromagneticEnergyDensity", "energyDensity" ] },
        "britishThermalUnitInternationalTablePerDegreeFahrenheit": { name: "britishThermalUnitInternationalTablePerDegreeFahrenheit", label: "British thermal unit (international table) per degree Fahrenheit", symbol: "BtuIT/°F", code: "N60", referenceUnit: function() { return samm.units["joulePerKelvin"] }, conversionFactor: "1.899101 × 10³ J/K", quantityKinds: [ "planckFunction", "heatCapacity", "massieuFunction", "boltzmannConstant", "entropy", "heatCapacity", "entropy" ] },
        "britishThermalUnitInternationalTablePerDegreeRankine": { name: "britishThermalUnitInternationalTablePerDegreeRankine", label: "British thermal unit (international table) per degree Rankine", symbol: "BtuIT/°R", code: "N62", referenceUnit: function() { return samm.units["joulePerKelvin"] }, conversionFactor: "1.899101 × 10³ J/K", quantityKinds: [ "planckFunction", "heatCapacity", "massieuFunction", "boltzmannConstant", "entropy", "entropy", "heatCapacity" ] },
        "britishThermalUnitInternationalTablePerHour": { name: "britishThermalUnitInternationalTablePerHour", label: "British thermal unit (international table) per hour", symbol: "BtuIT/h", code: "2I", referenceUnit: function() { return samm.units["watt"] }, conversionFactor: "2.930711× 10⁻¹ W", quantityKinds: [ "heatFlowRate", "radiantEnergyflux", "activePower", "heatFlowRate", "soundPower", "power", "radiantPower", "powerForDirectCurrent" ] },
        "britishThermalUnitInternationalTablePerHourSquareFootDegreeFahrenheit": { name: "britishThermalUnitInternationalTablePerHourSquareFootDegreeFahrenheit", label: "British thermal unit (international table) per hour square foot degree Fahrenheit", symbol: "BtuIT/(h·ft²·°F)", code: "N74", referenceUnit: function() { return samm.units["wattPerSquareMetreKelvin"] }, conversionFactor: "5.678263 W/(m² × K)", quantityKinds: [ "surfaceCoefficientOfHeatTransfer", "coefficientOfHeatTransfer" ] },
        "britishThermalUnitInternationalTablePerHourSquareFootDegreeRankine": { name: "britishThermalUnitInternationalTablePerHourSquareFootDegreeRankine", label: "British thermal unit (international table) per hour square foot degree Rankine", symbol: "BtuIT/(h·ft²·°R)", code: "A23", referenceUnit: null, conversionFactor: null, quantityKinds: [ "surfaceCoefficientOfHeatTransfer" ] },
        "britishThermalUnitInternationalTablePerMinute": { name: "britishThermalUnitInternationalTablePerMinute", label: "British thermal unit (international table) per minute", symbol: "BtuIT/min", code: "J44", referenceUnit: function() { return samm.units["watt"] }, conversionFactor: "17.584266 W", quantityKinds: [ "heatFlowRate", "radiantEnergyflux", "activePower", "heatFlowRate", "soundPower", "power", "radiantPower", "powerForDirectCurrent" ] },
        "britishThermalUnitInternationalTablePerPound": { name: "britishThermalUnitInternationalTablePerPound", label: "British thermal unit (international table) per pound", symbol: "BtuIT/lb", code: "AZ", referenceUnit: function() { return samm.units["joulePerKilogram"] }, conversionFactor: "2326 J/kg", quantityKinds: [ "massicHelmholtzFreeEnergy", "specificEnergy", "massicEnergy" ] },
        "britishThermalUnitInternationalTablePerPoundDegreeFahrenheit": { name: "britishThermalUnitInternationalTablePerPoundDegreeFahrenheit", label: "British thermal unit (international table) per pound degree Fahrenheit", symbol: "BtuIT/(lb·°F)", code: "J43", referenceUnit: function() { return samm.units["joulePerKilogramKelvin"] }, conversionFactor: "4.1868 × 10³ J/(kg × K)", quantityKinds: [ "entropy", "heatCapacity", "specificHeatCapacityAtSaturation", "specificHeatCapacityAtConstantVolume", "specificHeatCapacityAtConstantPressure" ] },
        "britishThermalUnitInternationalTablePerPoundDegreeRankine": { name: "britishThermalUnitInternationalTablePerPoundDegreeRankine", label: "British thermal unit (international table) per pound degree Rankine", symbol: "BtuIT/(lb·°R)", code: "A21", referenceUnit: function() { return samm.units["joulePerKilogramKelvin"] }, conversionFactor: "4186.8 J/(kg × K)", quantityKinds: [ "specificHeatCapacityAtSaturation", "specificHeatCapacityAtConstantVolume", "specificHeatCapacityAtConstantPressure", "specificHeatCapacityAtConstantPressure", "specificHeatCapacityAtSaturation", "specificHeatCapacityAtConstantVolume" ] },
        "britishThermalUnitInternationalTablePerSecond": { name: "britishThermalUnitInternationalTablePerSecond", label: "British thermal unit (international table) per second", symbol: "BtuIT/s", code: "J45", referenceUnit: function() { return samm.units["watt"] }, conversionFactor: "1.055056 × 10³ W", quantityKinds: [ "radiantEnergyflux", "activePower", "heatFlowRate", "soundPower", "power", "radiantPower", "powerForDirectCurrent", "heatFlowRate" ] },
        "britishThermalUnitInternationalTablePerSecondFootDegreeRankine": { name: "britishThermalUnitInternationalTablePerSecondFootDegreeRankine", label: "British thermal unit (international table) per second foot degree Rankine", symbol: "BtuIT/(s·ft·°R)", code: "A22", referenceUnit: function() { return samm.units["wattPerMetreKelvin"] }, conversionFactor: "6230.64 W/(m × K)", quantityKinds: [ "thermalConductivity", "thermalConductivity" ] },
        "britishThermalUnitInternationalTablePerSecondSquareFootDegreeFahrenheit": { name: "britishThermalUnitInternationalTablePerSecondSquareFootDegreeFahrenheit", label: "British thermal unit (international table) per second square foot degree Fahrenheit", symbol: "BtuIT/(s·ft²·°F)", code: "N76", referenceUnit: function() { return samm.units["wattPerSquareMetreKelvin"] }, conversionFactor: "2.044175 × 10⁴ W/(m² × K)", quantityKinds: [ "coefficientOfHeatTransfer", "surfaceCoefficientOfHeatTransfer" ] },
        "britishThermalUnitInternationalTablePerSecondSquareFootDegreeRankine": { name: "britishThermalUnitInternationalTablePerSecondSquareFootDegreeRankine", label: "British thermal unit (international table) per second square foot degree Rankine", symbol: "BtuIT/(s·ft²·°R)", code: "A20", referenceUnit: function() { return samm.units["wattPerSquareMetreKelvin"] }, conversionFactor: "20441.7 W/(m² × K)", quantityKinds: [ "surfaceCoefficientOfHeatTransfer", "coefficientOfHeatTransfer" ] },
        "britishThermalUnitInternationalTablePerSquareFoot": { name: "britishThermalUnitInternationalTablePerSquareFoot", label: "British thermal unit (international table) per square foot", symbol: "BtuIT/ft²", code: "P37", referenceUnit: function() { return samm.units["joulePerSquareMetre"] }, conversionFactor: "1.135653 × 10⁴ J/m²", quantityKinds: [ "radiantEnergyFluence", "radianceExposure", "radiantEnergyFluence", "radianceExposure", "energyFluence" ] },
        "britishThermalUnitInternationalTablePerSquareFootHour": { name: "britishThermalUnitInternationalTablePerSquareFootHour", label: "British thermal unit (international table) per square foot hour", symbol: "BtuIT/(ft²·h)", code: "N50", referenceUnit: function() { return samm.units["wattPerSquareMetre"] }, conversionFactor: "3.154591 W/m²", quantityKinds: [ "densityOfHeatFlowRate", "poyntingVector", "fluenceRate", "irradiance", "soundIntensity", "radiantEnergy", "firstRadiationConstant", "energyFluenceRate", "energyFluxDensity", "densityOfHeatFlowRate", "radiantExitance" ] },
        "britishThermalUnitInternationalTablePerSquareFootSecond": { name: "britishThermalUnitInternationalTablePerSquareFootSecond", label: "British thermal unit (international table) per square foot second", symbol: "BtuIT/(ft²·s)", code: "N53", referenceUnit: function() { return samm.units["wattPerSquareMetre"] }, conversionFactor: "1.135653 × 10⁴ W/m²", quantityKinds: [ "densityOfHeatFlowRate", "poyntingVector", "fluenceRate", "irradiance", "soundIntensity", "radiantEnergy", "firstRadiationConstant", "energyFluenceRate", "energyFluxDensity", "densityOfHeatFlowRate", "radiantExitance" ] },
        "britishThermalUnitInternationalTablePerSquareInchSecond": { name: "britishThermalUnitInternationalTablePerSquareInchSecond", label: "British thermal unit (international table) per square inch second", symbol: "BtuIT/(in²·s)", code: "N55", referenceUnit: function() { return samm.units["wattPerSquareMetre"] }, conversionFactor: "1.634246 × 10⁶ W/m²", quantityKinds: [ "densityOfHeatFlowRate", "poyntingVector", "fluenceRate", "irradiance", "soundIntensity", "radiantEnergy", "firstRadiationConstant", "energyFluenceRate", "energyFluxDensity", "densityOfHeatFlowRate", "radiantExitance" ] },
        "britishThermalUnitMean": { name: "britishThermalUnitMean", label: "British thermal unit (mean)", symbol: "Btu", code: "J39", referenceUnit: function() { return samm.units["joule"] }, conversionFactor: "1.05587 × 10³ J", quantityKinds: [ "quantityOfHeat", "reactionEnergy", "workFunction", "activeEnergy", "kineticEnergy", "levelWidth", "meanEnergyImparted", "helmholtzFunction", "radiantEnergy", "potentialEnergy", "energy", "thermodynamicEnergy", "helmholtzFreeEnergy", "work", "heat", "hartreeEnergy", "energyImparted", "enthalpy", "alphaDisintegrationEnergy", "thermodynamicEnergy", "energy", "helmholtzFreeEnergy", "enthalpy", "helmholtzFunction", "quantityOfHeat", "heat" ] },
        "britishThermalUnitThermochemicalFootPerHourSquareFootDegreeFahrenheit": { name: "britishThermalUnitThermochemicalFootPerHourSquareFootDegreeFahrenheit", label: "British thermal unit (thermochemical) foot per hour square foot degree Fahrenheit", symbol: "Btuth·ft/(h·ft²·°F)", code: "J46", referenceUnit: function() { return samm.units["wattPerMetreKelvin"] }, conversionFactor: "1.729577 W/(m × K)", quantityKinds: [ "thermalConductivity", "thermalConductivity" ] },
        "britishThermalUnitThermochemicalInchPerHourSquareFootDegreeFahrenheit": { name: "britishThermalUnitThermochemicalInchPerHourSquareFootDegreeFahrenheit", label: "British thermal unit (thermochemical) inch per hour square foot degree Fahrenheit", symbol: "Btuth·in/(h·ft²·°F)", code: "J48", referenceUnit: function() { return samm.units["wattPerMetreKelvin"] }, conversionFactor: "0.1441314 W/(m × K)", quantityKinds: [ "thermalConductivity", "thermalConductivity" ] },
        "britishThermalUnitThermochemicalInchPerSecondSquareFootDegreeFahrenheit": { name: "britishThermalUnitThermochemicalInchPerSecondSquareFootDegreeFahrenheit", label: "British thermal unit (thermochemical) inch per second square foot degree Fahrenheit", symbol: "Btuth·in/(s·ft²·°F)", code: "J49", referenceUnit: function() { return samm.units["wattPerMetreKelvin"] }, conversionFactor: "5.188732 × 10² W/(m × K)", quantityKinds: [ "thermalConductivity", "thermalConductivity" ] },
        "britishThermalUnitThermochemicalPerCubicFoot": { name: "britishThermalUnitThermochemicalPerCubicFoot", label: "British thermal unit (thermochemical) per cubic foot", symbol: "Btuth/ft³", code: "N59", referenceUnit: function() { return samm.units["joulePerCubicMetre"] }, conversionFactor: "3.723403 ×10⁴ J/m³", quantityKinds: [ "soundEnergy", "volumic", "volumicElectromagneticEnergy", "soundEnergyDensity", "radiantEnergyDensity", "electromagneticEnergyDensity", "energyDensity" ] },
        "britishThermalUnitThermochemicalPerDegreeFahrenheit": { name: "britishThermalUnitThermochemicalPerDegreeFahrenheit", label: "British thermal unit (thermochemical) per degree Fahrenheit", symbol: "Btuth/°F", code: "N61", referenceUnit: function() { return samm.units["joulePerKelvin"] }, conversionFactor: "1.897830 × 10³ J/K", quantityKinds: [ "planckFunction", "heatCapacity", "massieuFunction", "boltzmannConstant", "entropy", "entropy", "heatCapacity" ] },
        "britishThermalUnitThermochemicalPerDegreeRankine": { name: "britishThermalUnitThermochemicalPerDegreeRankine", label: "British thermal unit (thermochemical) per degree Rankine", symbol: "Btuth/°R", code: "N63", referenceUnit: function() { return samm.units["joulePerKelvin"] }, conversionFactor: "1.897830 × 10³ J/K", quantityKinds: [ "planckFunction", "heatCapacity", "massieuFunction", "boltzmannConstant", "entropy", "heatCapacity", "entropy" ] },
        "britishThermalUnitThermochemicalPerHour": { name: "britishThermalUnitThermochemicalPerHour", label: "British thermal unit (thermochemical) per hour", symbol: "Btuth/h", code: "J47", referenceUnit: function() { return samm.units["watt"] }, conversionFactor: "0.2928751 W", quantityKinds: [ "heatFlowRate", "radiantEnergyflux", "activePower", "heatFlowRate", "soundPower", "power", "radiantPower", "powerForDirectCurrent" ] },
        "britishThermalUnitThermochemicalPerHourSquareFootDegreeFahrenheit": { name: "britishThermalUnitThermochemicalPerHourSquareFootDegreeFahrenheit", label: "British thermal unit (thermochemical) per hour square foot degree Fahrenheit", symbol: "Btuth/(h·ft²·°F)", code: "N75", referenceUnit: function() { return samm.units["wattPerSquareMetreKelvin"] }, conversionFactor: "5.674466 W/(m² × K)", quantityKinds: [ "surfaceCoefficientOfHeatTransfer", "coefficientOfHeatTransfer" ] },
        "britishThermalUnitThermochemicalPerMinute": { name: "britishThermalUnitThermochemicalPerMinute", label: "British thermal unit (thermochemical) per minute", symbol: "Btuth/min", code: "J51", referenceUnit: function() { return samm.units["watt"] }, conversionFactor: "17.57250 W", quantityKinds: [ "radiantEnergyflux", "activePower", "heatFlowRate", "soundPower", "power", "radiantPower", "powerForDirectCurrent", "heatFlowRate" ] },
        "britishThermalUnitThermochemicalPerPound": { name: "britishThermalUnitThermochemicalPerPound", label: "British thermal unit (thermochemical) per pound", symbol: "Btuth/lb", code: "N73", referenceUnit: function() { return samm.units["joulePerKilogram"] }, conversionFactor: "2.324444 × 10³ J/kg", quantityKinds: [ "massicHelmholtzFreeEnergy", "specificEnergy", "massicEnergy" ] },
        "britishThermalUnitThermochemicalPerPoundDegreeFahrenheit": { name: "britishThermalUnitThermochemicalPerPoundDegreeFahrenheit", label: "British thermal unit (thermochemical) per pound degree Fahrenheit", symbol: "Btuth/(lb·°F)", code: "J50", referenceUnit: function() { return samm.units["joulePerKilogramKelvin"] }, conversionFactor: "4.184 × 10³ J/(kg × K)", quantityKinds: [ "specificHeatCapacityAtSaturation", "specificHeatCapacityAtConstantVolume", "specificHeatCapacityAtConstantPressure", "entropy", "heatCapacity" ] },
        "britishThermalUnitThermochemicalPerPoundDegreeRankine": { name: "britishThermalUnitThermochemicalPerPoundDegreeRankine", label: "British thermal unit (thermochemical) per pound degree Rankine", symbol: "(Btuth/°R)/lb", code: "N64", referenceUnit: function() { return samm.units["joulePerKilogramKelvin"] }, conversionFactor: "4.184 × 10³ J/(kg × K)", quantityKinds: [ "heatCapacity", "entropy", "specificHeatCapacityAtSaturation", "specificHeatCapacityAtConstantVolume", "specificHeatCapacityAtConstantPressure" ] },
        "britishThermalUnitThermochemicalPerSecond": { name: "britishThermalUnitThermochemicalPerSecond", label: "British thermal unit (thermochemical) per second", symbol: "Btuth/s", code: "J52", referenceUnit: function() { return samm.units["watt"] }, conversionFactor: "1.054350 × 10³ W", quantityKinds: [ "heatFlowRate", "radiantEnergyflux", "activePower", "heatFlowRate", "soundPower", "power", "radiantPower", "powerForDirectCurrent" ] },
        "britishThermalUnitThermochemicalPerSecondSquareFootDegreeFahrenheit": { name: "britishThermalUnitThermochemicalPerSecondSquareFootDegreeFahrenheit", label: "British thermal unit (thermochemical) per second square foot degree Fahrenheit", symbol: "Btuth/(s·ft²·°F)", code: "N77", referenceUnit: function() { return samm.units["wattPerSquareMetreKelvin"] }, conversionFactor: "2.042808 × 10⁴ W/(m² × K)", quantityKinds: [ "coefficientOfHeatTransfer", "surfaceCoefficientOfHeatTransfer" ] },
        "britishThermalUnitThermochemicalPerSquareFoot": { name: "britishThermalUnitThermochemicalPerSquareFoot", label: "British thermal unit (thermochemical) per square foot", symbol: "Btuth/ft²", code: "P38", referenceUnit: function() { return samm.units["joulePerSquareMetre"] }, conversionFactor: "1.134893 × 10⁴ J/m²", quantityKinds: [ "radianceExposure", "radiantEnergyFluence", "radiantEnergyFluence", "radianceExposure", "energyFluence" ] },
        "britishThermalUnitThermochemicalPerSquareFootHour": { name: "britishThermalUnitThermochemicalPerSquareFootHour", label: "British thermal unit (thermochemical) per square foot hour", symbol: "Btuth/(ft²·h)", code: "N51", referenceUnit: function() { return samm.units["wattPerSquareMetre"] }, conversionFactor: "3.152481 W/m²", quantityKinds: [ "poyntingVector", "fluenceRate", "irradiance", "soundIntensity", "radiantEnergy", "firstRadiationConstant", "energyFluenceRate", "energyFluxDensity", "densityOfHeatFlowRate", "radiantExitance", "densityOfHeatFlowRate" ] },
        "britishThermalUnitThermochemicalPerSquareFootMinute": { name: "britishThermalUnitThermochemicalPerSquareFootMinute", label: "British thermal unit (thermochemical) per square foot minute", symbol: "Btuth/(ft²·min)", code: "N52", referenceUnit: function() { return samm.units["wattPerSquareMetre"] }, conversionFactor: "1.891489 × 10² W/m²", quantityKinds: [ "densityOfHeatFlowRate", "poyntingVector", "fluenceRate", "irradiance", "soundIntensity", "radiantEnergy", "firstRadiationConstant", "energyFluenceRate", "energyFluxDensity", "densityOfHeatFlowRate", "radiantExitance" ] },
        "britishThermalUnitThermochemicalPerSquareFootSecond": { name: "britishThermalUnitThermochemicalPerSquareFootSecond", label: "British thermal unit (thermochemical) per square foot second", symbol: "Btuth/(ft²·s)", code: "N54", referenceUnit: function() { return samm.units["wattPerSquareMetre"] }, conversionFactor: "1.134893 × 10⁴ W/m²", quantityKinds: [ "densityOfHeatFlowRate", "poyntingVector", "fluenceRate", "irradiance", "soundIntensity", "radiantEnergy", "firstRadiationConstant", "energyFluenceRate", "energyFluxDensity", "densityOfHeatFlowRate", "radiantExitance" ] },
        "bulkPack": { name: "bulkPack", label: "bulk pack", symbol: "pk", code: "AB", referenceUnit: null, conversionFactor: null, quantityKinds: null },
        "bushelUk": { name: "bushelUk", label: "bushel (UK)", symbol: "bushel (UK)", code: "BUI", referenceUnit: function() { return samm.units["cubicMetre"] }, conversionFactor: "3.636872 × 10⁻² m³", quantityKinds: [ "volume", "sectionModulus", "volume" ] },
        "bushelUkPerDay": { name: "bushelUkPerDay", label: "bushel (UK) per day", symbol: "bu (UK)/d", code: "J64", referenceUnit: function() { return samm.units["cubicMetrePerSecond"] }, conversionFactor: "4.209343 × 10⁻⁷ m³/s", quantityKinds: [ "volumeFlowRate", "recombinationCoefficient", "instantaneousVolumeFlowRate", "volumeFlowRate" ] },
        "bushelUkPerHour": { name: "bushelUkPerHour", label: "bushel (UK) per hour", symbol: "bu (UK)/h", code: "J65", referenceUnit: function() { return samm.units["cubicMetrePerSecond"] }, conversionFactor: "1.010242 × 10⁻⁵ m³/s", quantityKinds: [ "volumeFlowRate", "recombinationCoefficient", "instantaneousVolumeFlowRate", "volumeFlowRate" ] },
        "bushelUkPerMinute": { name: "bushelUkPerMinute", label: "bushel (UK) per minute", symbol: "bu (UK)/min", code: "J66", referenceUnit: function() { return samm.units["cubicMetrePerSecond"] }, conversionFactor: "6.061453 × 10⁻⁴ m³/s", quantityKinds: [ "volumeFlowRate", "recombinationCoefficient", "instantaneousVolumeFlowRate", "volumeFlowRate" ] },
        "bushelUkPerSecond": { name: "bushelUkPerSecond", label: "bushel (UK) per second", symbol: "bu (UK)/s", code: "J67", referenceUnit: function() { return samm.units["cubicMetrePerSecond"] }, conversionFactor: "3.636872 × 10⁻² m³/s", quantityKinds: [ "volumeFlowRate", "recombinationCoefficient", "instantaneousVolumeFlowRate", "volumeFlowRate" ] },
        "bushelUs": { name: "bushelUs", label: "bushel (US)", symbol: "bu (US)", code: "BUA", referenceUnit: function() { return samm.units["cubicMetre"] }, conversionFactor: "3.523907 × 10⁻² m³", quantityKinds: [ "volume", "volume", "sectionModulus" ] },
        "bushelUsDryPerDay": { name: "bushelUsDryPerDay", label: "bushel (US dry) per day", symbol: "bu (US dry)/d", code: "J68", referenceUnit: function() { return samm.units["cubicMetrePerSecond"] }, conversionFactor: "4.078596 × 10⁻⁷ m³/s", quantityKinds: [ "volumeFlowRate", "recombinationCoefficient", "instantaneousVolumeFlowRate", "volumeFlowRate" ] },
        "bushelUsDryPerHour": { name: "bushelUsDryPerHour", label: "bushel (US dry) per hour", symbol: "bu (US dry)/h", code: "J69", referenceUnit: function() { return samm.units["cubicMetrePerSecond"] }, conversionFactor: "9.788631 × 10⁻⁶ m³/s", quantityKinds: [ "volumeFlowRate", "recombinationCoefficient", "instantaneousVolumeFlowRate", "volumeFlowRate" ] },
        "bushelUsDryPerMinute": { name: "bushelUsDryPerMinute", label: "bushel (US dry) per minute", symbol: "bu (US dry)/min", code: "J70", referenceUnit: function() { return samm.units["cubicMetrePerSecond"] }, conversionFactor: "5.873178 × 10⁻⁴ m³/s", quantityKinds: [ "volumeFlowRate", "recombinationCoefficient", "instantaneousVolumeFlowRate", "volumeFlowRate" ] },
        "bushelUsDryPerSecond": { name: "bushelUsDryPerSecond", label: "bushel (US dry) per second", symbol: "bu (US dry)/s", code: "J71", referenceUnit: function() { return samm.units["cubicMetrePerSecond"] }, conversionFactor: "3.523907 × 10⁻² m³/s", quantityKinds: [ "volumeFlowRate", "volumeFlowRate", "recombinationCoefficient", "instantaneousVolumeFlowRate" ] },
        "byte": { name: "byte", label: "byte", symbol: "B", code: "AD", referenceUnit: null, conversionFactor: null, quantityKinds: [ "informationEntropy" ] },
        "bytePerSecond": { name: "bytePerSecond", label: "byte per second", symbol: "byte/s", code: "P93", referenceUnit: null, conversionFactor: null, quantityKinds: null },
        "cake": { name: "cake", label: "cake", symbol: null, code: "KA", referenceUnit: null, conversionFactor: null, quantityKinds: null },
        "call": { name: "call", label: "call", symbol: null, code: "C0", referenceUnit: null, conversionFactor: null, quantityKinds: null },
        "calorie20Degreesc": { name: "calorie20Degreesc", label: "calorie (20 °C)", symbol: "cal₂₀", code: "N69", referenceUnit: function() { return samm.units["joule"] }, conversionFactor: "4.18190", quantityKinds: [ "quantityOfHeat", "reactionEnergy", "workFunction", "activeEnergy", "kineticEnergy", "levelWidth", "meanEnergyImparted", "helmholtzFunction", "radiantEnergy", "potentialEnergy", "energy", "thermodynamicEnergy", "helmholtzFreeEnergy", "work", "heat", "hartreeEnergy", "energyImparted", "enthalpy", "alphaDisintegrationEnergy", "quantityOfHeat", "thermodynamicEnergy", "heat", "enthalpy", "energy", "helmholtzFunction", "helmholtzFreeEnergy" ] },
        "calorieInternationalTablePerGramDegreeCelsius": { name: "calorieInternationalTablePerGramDegreeCelsius", label: "calorie (international table) per gram degree Celsius", symbol: "calIT/(g·°C)", code: "J76", referenceUnit: function() { return samm.units["joulePerKilogramKelvin"] }, conversionFactor: "4.1868 × 10³ J/(kg × K)", quantityKinds: [ "heatCapacity", "entropy", "specificHeatCapacityAtSaturation", "specificHeatCapacityAtConstantVolume", "specificHeatCapacityAtConstantPressure" ] },
        "calorieMean": { name: "calorieMean", label: "calorie (mean)", symbol: "cal", code: "J75", referenceUnit: function() { return samm.units["joule"] }, conversionFactor: "4.19002 J", quantityKinds: [ "quantityOfHeat", "reactionEnergy", "workFunction", "activeEnergy", "kineticEnergy", "levelWidth", "meanEnergyImparted", "helmholtzFunction", "radiantEnergy", "potentialEnergy", "energy", "thermodynamicEnergy", "helmholtzFreeEnergy", "work", "heat", "hartreeEnergy", "energyImparted", "enthalpy", "alphaDisintegrationEnergy", "quantityOfHeat", "heat", "helmholtzFreeEnergy", "energy", "helmholtzFunction", "enthalpy", "thermodynamicEnergy" ] },
        "calorieThermochemicalPerCentimetreSecondDegreeCelsius": { name: "calorieThermochemicalPerCentimetreSecondDegreeCelsius", label: "calorie (thermochemical) per centimetre second degree Celsius", symbol: "calth/(cm·s·°C)", code: "J78", referenceUnit: function() { return samm.units["wattPerMetreKelvin"] }, conversionFactor: "4.184 × 10² W/(m × K)", quantityKinds: [ "thermalConductivity", "thermalConductivity" ] },
        "calorieThermochemicalPerGramDegreeCelsius": { name: "calorieThermochemicalPerGramDegreeCelsius", label: "calorie (thermochemical) per gram degree Celsius", symbol: "calth/(g·°C)", code: "J79", referenceUnit: function() { return samm.units["joulePerKilogramKelvin"] }, conversionFactor: "4.184 × 10³ J/(kg × K)", quantityKinds: [ "heatCapacity", "entropy", "specificHeatCapacityAtSaturation", "specificHeatCapacityAtConstantVolume", "specificHeatCapacityAtConstantPressure" ] },
        "calorieThermochemicalPerMinute": { name: "calorieThermochemicalPerMinute", label: "calorie (thermochemical) per minute", symbol: "calth/min", code: "J81", referenceUnit: function() { return samm.units["watt"] }, conversionFactor: "6.973333 × 10⁻² W", quantityKinds: [ "radiantEnergyflux", "activePower", "heatFlowRate", "soundPower", "power", "radiantPower", "powerForDirectCurrent", "heatFlowRate" ] },
        "calorieThermochemicalPerSecond": { name: "calorieThermochemicalPerSecond", label: "calorie (thermochemical) per second", symbol: "calth/s", code: "J82", referenceUnit: function() { return samm.units["watt"] }, conversionFactor: "4.184 W", quantityKinds: [ "heatFlowRate", "radiantEnergyflux", "activePower", "heatFlowRate", "soundPower", "power", "radiantPower", "powerForDirectCurrent" ] },
        "calorieThermochemicalPerSquareCentimetre": { name: "calorieThermochemicalPerSquareCentimetre", label: "calorie (thermochemical) per square centimetre", symbol: "calth/cm²", code: "P39", referenceUnit: function() { return samm.units["joulePerSquareMetre"] }, conversionFactor: "4.184 × 10⁴ J/m²", quantityKinds: [ "radianceExposure", "radiantEnergyFluence", "radiantEnergyFluence", "radianceExposure", "energyFluence" ] },
        "calorieThermochemicalPerSquareCentimetreMinute": { name: "calorieThermochemicalPerSquareCentimetreMinute", label: "calorie (thermochemical) per square centimetre minute", symbol: "calth/(cm²·min)", code: "N56", referenceUnit: function() { return samm.units["wattPerSquareMetre"] }, conversionFactor: "6.973333 × 10² W/m²", quantityKinds: [ "densityOfHeatFlowRate", "poyntingVector", "fluenceRate", "irradiance", "soundIntensity", "radiantEnergy", "firstRadiationConstant", "energyFluenceRate", "energyFluxDensity", "densityOfHeatFlowRate", "radiantExitance" ] },
        "calorieThermochemicalPerSquareCentimetreSecond": { name: "calorieThermochemicalPerSquareCentimetreSecond", label: "calorie (thermochemical) per square centimetre second", symbol: "calth/(cm²·s)", code: "N57", referenceUnit: function() { return samm.units["wattPerSquareMetre"] }, conversionFactor: "4.184 × 10⁴ W/m²", quantityKinds: [ "densityOfHeatFlowRate", "poyntingVector", "fluenceRate", "irradiance", "soundIntensity", "radiantEnergy", "firstRadiationConstant", "energyFluenceRate", "energyFluxDensity", "densityOfHeatFlowRate", "radiantExitance" ] },
        "candela": { name: "candela", label: "candela", symbol: "cd", code: "CDL", referenceUnit: null, conversionFactor: null, quantityKinds: [ "luminousIntensity" ] },
        "candelaPerSquareFoot": { name: "candelaPerSquareFoot", label: "candela per square foot", symbol: "cd/ft²", code: "P32", referenceUnit: function() { return samm.units["candelaPerSquareMetre"] }, conversionFactor: "1.076391 × 10 cd/m²", quantityKinds: [ "luminance", "luminance" ] },
        "candelaPerSquareInch": { name: "candelaPerSquareInch", label: "candela per square inch", symbol: "cd/in²", code: "P28", referenceUnit: function() { return samm.units["candelaPerSquareMetre"] }, conversionFactor: "1.550003 × 10³ cd/m²", quantityKinds: [ "luminance", "luminance" ] },
        "candelaPerSquareMetre": { name: "candelaPerSquareMetre", label: "candela per square metre", symbol: "cd/m²", code: "A24", referenceUnit: null, conversionFactor: null, quantityKinds: [ "luminance" ] },
        "card": { name: "card", label: "card", symbol: null, code: "CG", referenceUnit: null, conversionFactor: null, quantityKinds: null },
        "carryingCapacityInMetricTon": { name: "carryingCapacityInMetricTon", label: "carrying capacity in metric ton", symbol: null, code: "CCT", referenceUnit: null, conversionFactor: null, quantityKinds: null },
        "centalUk": { name: "centalUk", label: "cental (UK)", symbol: null, code: "CNT", referenceUnit: function() { return samm.units["kilogram"] }, conversionFactor: "45.359237 kg", quantityKinds: [ "massOfAtomOfANuclideX", "massOfMolecule", "effectiveMass", "mass", "nuclidicMass", "massExcess" ] },
        "centigram": { name: "centigram", label: "centigram", symbol: "cg", code: "CGM", referenceUnit: function() { return samm.units["kilogram"] }, conversionFactor: "10⁻⁵ kg", quantityKinds: [ "mass", "massOfAtomOfANuclideX", "massOfMolecule", "effectiveMass", "mass", "nuclidicMass", "massExcess" ] },
        "centilitre": { name: "centilitre", label: "centilitre", symbol: "cl", code: "CLT", referenceUnit: function() { return samm.units["cubicMetre"] }, conversionFactor: "10⁻⁵ m³", quantityKinds: [ "volume", "sectionModulus", "volume" ] },
        "centimetre": { name: "centimetre", label: "centimetre", symbol: "cm", code: "CMT", referenceUnit: function() { return samm.units["metre"] }, conversionFactor: "10⁻² m", quantityKinds: [ "thickness", "particlePositionVector", "cartesianCoordinates", "focalDistance", "radius", "radiusOfCurvature", "displacementVectorOfIonOrAtom", "lengthOfPath", "diameter", "comptonWavelength", "slowingDownLength", "migrationLength", "meanFreePath", "equilibriumPositionVectorOfIonOrAtom", "instantaneousSoundParticleDisplacement", "imageDistance", "breadth", "length", "halfValueThickness", "coherenceLength", "latticeVector", "londonPenetrationDepth", "diffusionLength", "meanFreePathOfPhononsOrElectrons", "diffusionCoefficientForNeutronFluxDensity", "halfThickness", "height", "electronRadius", "distance", "objectDistance", "bohrRadius", "diffusionCoefficientForNeutronFluenceRate", "nuclearRadius", "wavelength", "fundamentalLatticeVector", "meanLinearRange", "height", "lengthOfPath", "radius", "radiusOfCurvature", "distance", "diameter", "thickness", "cartesianCoordinates", "length", "breadth" ] },
        "centimetreOfMercury0Degreesc": { name: "centimetreOfMercury0Degreesc", label: "centimetre of mercury (0 °C)", symbol: "cmHg (0 °C)", code: "N13", referenceUnit: function() { return samm.units["pascal"] }, conversionFactor: "1.33322 × 10³ Pa", quantityKinds: [ "fugacityOfBInAGaseousMixture", "pressure", "shearModulus", "staticPressure", "normalStress", "modulusOfRigidity", "instantaneousSoundPressure", "modulusOfElasticity", "shearStress", "modulusOfCompression", "partialPressureOfBInAGaseousMixture", "bulkModulus", "osmoticPressure", "shearModulus", "pressure", "modulusOfRigidity", "shearStress", "bulkModulus", "modulusOfCompression", "normalStress", "modulusOfElasticity" ] },
        "centimetreOfWater4Degreesc": { name: "centimetreOfWater4Degreesc", label: "centimetre of water (4 °C)", symbol: "cmH₂O (4 °C)", code: "N14", referenceUnit: function() { return samm.units["pascal"] }, conversionFactor: "9.80638 × 10 Pa", quantityKinds: [ "fugacityOfBInAGaseousMixture", "pressure", "shearModulus", "staticPressure", "normalStress", "modulusOfRigidity", "instantaneousSoundPressure", "modulusOfElasticity", "shearStress", "modulusOfCompression", "partialPressureOfBInAGaseousMixture", "bulkModulus", "osmoticPressure", "bulkModulus", "normalStress", "shearModulus", "modulusOfRigidity", "modulusOfElasticity", "pressure", "modulusOfCompression", "shearStress" ] },
        "centimetrePerBar": { name: "centimetrePerBar", label: "centimetre per bar", symbol: "cm/bar", code: "G04", referenceUnit: null, conversionFactor: null, quantityKinds: [ "lengthOfPath", "breadth", "cartesianCoordinates", "distance", "thickness", "height", "diameter", "radiusOfCurvature", "radius", "length" ] },
        "centimetrePerHour": { name: "centimetrePerHour", label: "centimetre per hour", symbol: "cm/h", code: "H49", referenceUnit: null, conversionFactor: null, quantityKinds: [ "velocity", "phaseVelocity", "groupVelocity" ] },
        "centimetrePerKelvin": { name: "centimetrePerKelvin", label: "centimetre per kelvin", symbol: "cm/K", code: "F51", referenceUnit: null, conversionFactor: null, quantityKinds: [ "radius", "length", "cartesianCoordinates", "distance", "lengthOfPath", "thickness", "radiusOfCurvature", "breadth", "height", "diameter" ] },
        "centimetrePerSecond": { name: "centimetrePerSecond", label: "centimetre per second", symbol: "cm/s", code: "2M", referenceUnit: function() { return samm.units["metrePerSecond"] }, conversionFactor: "10⁻² m/s", quantityKinds: [ "groupVelocity", "velocityOfSoundPhaseVelocity", "phaseVelocity", "neutronSpeed", "phaseSpeedOfElectromagneticWaves", "velocity", "velocitySpeedOnPropagationOfElectromagneticWavesInVacuo", "instantaneousSoundParticleVelocity", "phaseVelocityOfElectromagneticWaves", "groupVelocity", "velocity", "phaseVelocity" ] },
        "centimetrePerSecondBar": { name: "centimetrePerSecondBar", label: "centimetre per second bar", symbol: "(cm/s)/bar", code: "J85", referenceUnit: function() { return samm.units["metrePerSecondPascal"] }, conversionFactor: "10⁻⁷ (m/s)/Pa", quantityKinds: [ "velocity", "groupVelocity", "phaseVelocity", "velocity", "phaseVelocity", "groupVelocity" ] },
        "centimetrePerSecondKelvin": { name: "centimetrePerSecondKelvin", label: "centimetre per second kelvin", symbol: "(cm/s)/K", code: "J84", referenceUnit: function() { return samm.units["metrePerSecondKelvin"] }, conversionFactor: "10⁻² (m/s)/K", quantityKinds: [ "groupVelocity", "phaseVelocity", "velocity", "velocity", "phaseVelocity", "groupVelocity" ] },
        "centimetrePerSecondSquared": { name: "centimetrePerSecondSquared", label: "centimetre per second squared", symbol: "cm/s²", code: "M39", referenceUnit: function() { return samm.units["metrePerSecondSquared"] }, conversionFactor: "10⁻² m/s²", quantityKinds: [ "acceleration", "accelerationOfFreeFall", "accelerationDueToGravity", "acceleration", "instantaneousSoundParticleAcceleration", "accelerationOfFreeFall", "accelerationDueToGravity" ] },
        "centinewtonMetre": { name: "centinewtonMetre", label: "centinewton metre", symbol: "cN·m", code: "J72", referenceUnit: function() { return samm.units["newtonMetre"] }, conversionFactor: "10⁻² N × m", quantityKinds: [ "torque", "momentOfACouple", "momentOfForce", "torque", "momentOfForce", "momentOfACouple" ] },
        "centipoise": { name: "centipoise", label: "centipoise", symbol: "cP", code: "C7", referenceUnit: function() { return samm.units["pascalSecond"] }, conversionFactor: "10⁻³ Pa × s", quantityKinds: [ "viscosityDynamicViscosity", "viscosityDynamicViscosity" ] },
        "centipoisePerBar": { name: "centipoisePerBar", label: "centipoise per bar", symbol: "cP/bar", code: "J74", referenceUnit: function() { return samm.units["secondUnitOfTime"] }, conversionFactor: "10⁻⁸ s", quantityKinds: [ "timeConstant", "reactorTimeConstant", "halfLife", "meanLife", "time", "relaxationTime", "period", "carrierLifeTime", "periodicTime", "reverberationTime", "viscosityDynamicViscosity" ] },
        "centipoisePerKelvin": { name: "centipoisePerKelvin", label: "centipoise per kelvin", symbol: "cP/K", code: "J73", referenceUnit: null, conversionFactor: null, quantityKinds: [ "viscosityDynamicViscosity" ] },
        "centistokes": { name: "centistokes", label: "centistokes", symbol: "cSt", code: "4C", referenceUnit: function() { return samm.units["squareMetrePerSecond"] }, conversionFactor: "10⁻⁶ m²/s", quantityKinds: [ "thermalDiffusivity", "diffusionCoefficientForNeutronNumberDensity", "thermalDiffusionCoefficient", "diffusionCoefficient", "kinematicViscosity", "kinematicViscosity" ] },
        "chainBasedOnUsSurveyFoot": { name: "chainBasedOnUsSurveyFoot", label: "chain (based on U.S. survey foot)", symbol: "ch (US survey)", code: "M49", referenceUnit: function() { return samm.units["metre"] }, conversionFactor: "2.011684 × 10 m", quantityKinds: [ "thickness", "particlePositionVector", "cartesianCoordinates", "focalDistance", "radius", "radiusOfCurvature", "displacementVectorOfIonOrAtom", "lengthOfPath", "diameter", "comptonWavelength", "slowingDownLength", "migrationLength", "meanFreePath", "equilibriumPositionVectorOfIonOrAtom", "instantaneousSoundParticleDisplacement", "imageDistance", "breadth", "length", "halfValueThickness", "coherenceLength", "latticeVector", "londonPenetrationDepth", "diffusionLength", "meanFreePathOfPhononsOrElectrons", "diffusionCoefficientForNeutronFluxDensity", "halfThickness", "height", "electronRadius", "distance", "objectDistance", "bohrRadius", "diffusionCoefficientForNeutronFluenceRate", "nuclearRadius", "wavelength", "fundamentalLatticeVector", "meanLinearRange", "diameter", "radiusOfCurvature", "lengthOfPath", "breadth", "thickness", "height", "distance", "radius", "cartesianCoordinates", "length" ] },
        "circularMil": { name: "circularMil", label: "circular mil", symbol: "cmil", code: "M47", referenceUnit: function() { return samm.units["squareMetre"] }, conversionFactor: "5.067075 × 10⁻¹⁰ m²", quantityKinds: [ "area", "area", "atomicAttenuationCoefficient", "migrationArea", "crossSection", "equivalentAbsorptionAreaOfASurfaceOrObject", "nuclearQuadrupoleMoment", "slowingDownArea", "diffusionArea" ] },
        "clo": { name: "clo", label: "clo", symbol: "clo", code: "J83", referenceUnit: function() { return samm.units["squareMetreKelvinPerWatt"] }, conversionFactor: "0.155 m² × K/W", quantityKinds: [ "thermalInsulance", "coefficientOfThermalInsulation", "coefficientOfThermalInsulation", "thermalInsulance" ] },
        "coilGroup": { name: "coilGroup", label: "coil group", symbol: null, code: "C9", referenceUnit: null, conversionFactor: null, quantityKinds: null },
        "commonYear": { name: "commonYear", label: "common year", symbol: "y (365 days)", code: "L95", referenceUnit: function() { return samm.units["secondUnitOfTime"] }, conversionFactor: "3.1536 × 10⁷ s", quantityKinds: [ "time", "timeConstant", "reactorTimeConstant", "halfLife", "meanLife", "time", "relaxationTime", "period", "carrierLifeTime", "periodicTime", "reverberationTime" ] },
        "contentGram": { name: "contentGram", label: "content gram", symbol: null, code: "CTG", referenceUnit: null, conversionFactor: null, quantityKinds: null },
        "contentTonMetric": { name: "contentTonMetric", label: "content ton (metric)", symbol: null, code: "CTN", referenceUnit: null, conversionFactor: null, quantityKinds: null },
        "conventionalMetreOfWater": { name: "conventionalMetreOfWater", label: "conventional metre of water", symbol: "mH₂O", code: "N23", referenceUnit: function() { return samm.units["pascal"] }, conversionFactor: "9.80665 × 10³ Pa", quantityKinds: [ "fugacityOfBInAGaseousMixture", "pressure", "shearModulus", "staticPressure", "normalStress", "modulusOfRigidity", "instantaneousSoundPressure", "modulusOfElasticity", "shearStress", "modulusOfCompression", "partialPressureOfBInAGaseousMixture", "bulkModulus", "osmoticPressure", "modulusOfElasticity", "shearStress", "modulusOfRigidity", "modulusOfCompression", "normalStress", "shearModulus", "bulkModulus", "pressure" ] },
        "cord": { name: "cord", label: "cord", symbol: null, code: "WCD", referenceUnit: function() { return samm.units["cubicMetre"] }, conversionFactor: "3.63 m³", quantityKinds: [ "volume", "sectionModulus" ] },
        "cord128Ft3": { name: "cord128Ft3", label: "cord (128 ft3)", symbol: "cord", code: "M68", referenceUnit: function() { return samm.units["cubicMetre"] }, conversionFactor: "3.624556 m³", quantityKinds: [ "volume", "sectionModulus", "volume" ] },
        "coulomb": { name: "coulomb", label: "coulomb", symbol: "C", code: "COU", referenceUnit: function() { return samm.units["ampereSecond"] }, conversionFactor: "A × s", quantityKinds: [ "elementaryCharge", "electricFluxFluxOfDisplacement", "electricCharge", "quantityOfElectricity", "electricFluxFluxOfDisplacement", "electricCharge", "quantityOfElectricity" ] },
        "coulombMetre": { name: "coulombMetre", label: "coulomb metre", symbol: "C·m", code: "A26", referenceUnit: null, conversionFactor: null, quantityKinds: [ "electricDipoleMomentOfMolecule", "electricDipoleMoment" ] },
        "coulombMetreSquaredPerVolt": { name: "coulombMetreSquaredPerVolt", label: "coulomb metre squared per volt", symbol: "C·m²/V", code: "A27", referenceUnit: null, conversionFactor: null, quantityKinds: [ "electricPolarizabilityOfAMolecule" ] },
        "coulombPerCubicCentimetre": { name: "coulombPerCubicCentimetre", label: "coulomb per cubic centimetre", symbol: "C/cm³", code: "A28", referenceUnit: function() { return samm.units["coulombPerCubicMetre"] }, conversionFactor: "10⁶ C/m³", quantityKinds: [ "volumicCharge", "volumeDensityOfCharge", "chargeDensity", "volumeDensityOfCharge", "chargeDensity", "volumicCharge" ] },
        "coulombPerCubicMetre": { name: "coulombPerCubicMetre", label: "coulomb per cubic metre", symbol: "C/m³", code: "A29", referenceUnit: null, conversionFactor: null, quantityKinds: [ "volumicCharge", "volumeDensityOfCharge", "chargeDensity" ] },
        "coulombPerCubicMillimetre": { name: "coulombPerCubicMillimetre", label: "coulomb per cubic millimetre", symbol: "C/mm³", code: "A30", referenceUnit: function() { return samm.units["coulombPerCubicMetre"] }, conversionFactor: "10⁹ C/m³", quantityKinds: [ "volumeDensityOfCharge", "volumicCharge", "chargeDensity", "volumicCharge", "volumeDensityOfCharge", "chargeDensity" ] },
        "coulombPerKilogram": { name: "coulombPerKilogram", label: "coulomb per kilogram", symbol: "C/kg", code: "CKG", referenceUnit: null, conversionFactor: null, quantityKinds: [ "exposure" ] },
        "coulombPerKilogramSecond": { name: "coulombPerKilogramSecond", label: "coulomb per kilogram second", symbol: "C/(kg·s)", code: "A31", referenceUnit: function() { return samm.units["amperePerKilogram"] }, conversionFactor: "A/kg", quantityKinds: [ "exposureRate", "currentDensity" ] },
        "coulombPerMetre": { name: "coulombPerMetre", label: "coulomb per metre", symbol: "C/m", code: "P10", referenceUnit: null, conversionFactor: null, quantityKinds: [ "lineicCharge" ] },
        "coulombPerMole": { name: "coulombPerMole", label: "coulomb per mole", symbol: "C/mol", code: "A32", referenceUnit: null, conversionFactor: null, quantityKinds: [ "faradayConstant" ] },
        "coulombPerSquareCentimetre": { name: "coulombPerSquareCentimetre", label: "coulomb per square centimetre", symbol: "C/cm²", code: "A33", referenceUnit: function() { return samm.units["coulombPerSquareMetre"] }, conversionFactor: "10⁴ C/m²", quantityKinds: [ "surfaceDensityOfCharge", "electricFluxDensity", "displacementElectricPolarization", "surfaceDensityOfCharge", "electricFluxDensity", "displacementElectricPolarization" ] },
        "coulombPerSquareMetre": { name: "coulombPerSquareMetre", label: "coulomb per square metre", symbol: "C/m²", code: "A34", referenceUnit: null, conversionFactor: null, quantityKinds: [ "surfaceDensityOfCharge", "electricFluxDensity", "displacementElectricPolarization" ] },
        "coulombPerSquareMillimetre": { name: "coulombPerSquareMillimetre", label: "coulomb per square millimetre", symbol: "C/mm²", code: "A35", referenceUnit: function() { return samm.units["coulombPerSquareMetre"] }, conversionFactor: "10⁶ C/m²", quantityKinds: [ "surfaceDensityOfCharge", "displacementElectricPolarization", "electricFluxDensity", "surfaceDensityOfCharge", "electricFluxDensity", "displacementElectricPolarization" ] },
        "coulombSquareMetrePerKilogram": { name: "coulombSquareMetrePerKilogram", label: "coulomb square metre per kilogram", symbol: "C·m²/kg", code: "J53", referenceUnit: null, conversionFactor: null, quantityKinds: [ "exposure" ] },
        "credit": { name: "credit", label: "credit", symbol: null, code: "B17", referenceUnit: null, conversionFactor: null, quantityKinds: null },
        "cubicCentimetre": { name: "cubicCentimetre", label: "cubic centimetre", symbol: "cm³", code: "CMQ", referenceUnit: function() { return samm.units["cubicMetre"] }, conversionFactor: "10⁻⁶ m³", quantityKinds: [ "volume", "sectionModulus", "volume" ] },
        "cubicCentimetrePerBar": { name: "cubicCentimetrePerBar", label: "cubic centimetre per bar", symbol: "cm³/bar", code: "G94", referenceUnit: null, conversionFactor: null, quantityKinds: [ "volume" ] },
        "cubicCentimetrePerCubicMetre": { name: "cubicCentimetrePerCubicMetre", label: "cubic centimetre per cubic metre", symbol: "cm³/m³", code: "J87", referenceUnit: null, conversionFactor: null, quantityKinds: [ "volumeRatio" ] },
        "cubicCentimetrePerDay": { name: "cubicCentimetrePerDay", label: "cubic centimetre per day", symbol: "cm³/d", code: "G47", referenceUnit: null, conversionFactor: null, quantityKinds: [ "volumeFlowRate" ] },
        "cubicCentimetrePerDayBar": { name: "cubicCentimetrePerDayBar", label: "cubic centimetre per day bar", symbol: "cm³/(d·bar)", code: "G78", referenceUnit: null, conversionFactor: null, quantityKinds: [ "volumeFlowRate" ] },
        "cubicCentimetrePerDayKelvin": { name: "cubicCentimetrePerDayKelvin", label: "cubic centimetre per day kelvin", symbol: "cm³/(d·K)", code: "G61", referenceUnit: null, conversionFactor: null, quantityKinds: [ "volumeFlowRate" ] },
        "cubicCentimetrePerHour": { name: "cubicCentimetrePerHour", label: "cubic centimetre per hour", symbol: "cm³/h", code: "G48", referenceUnit: null, conversionFactor: null, quantityKinds: [ "volumeFlowRate" ] },
        "cubicCentimetrePerHourBar": { name: "cubicCentimetrePerHourBar", label: "cubic centimetre per hour bar", symbol: "cm³/(h·bar)", code: "G79", referenceUnit: null, conversionFactor: null, quantityKinds: [ "volumeFlowRate" ] },
        "cubicCentimetrePerHourKelvin": { name: "cubicCentimetrePerHourKelvin", label: "cubic centimetre per hour kelvin", symbol: "cm³/(h·K)", code: "G62", referenceUnit: null, conversionFactor: null, quantityKinds: [ "volumeFlowRate" ] },
        "cubicCentimetrePerKelvin": { name: "cubicCentimetrePerKelvin", label: "cubic centimetre per kelvin", symbol: "cm³/K", code: "G27", referenceUnit: null, conversionFactor: null, quantityKinds: [ "volumePerTemperature" ] },
        "cubicCentimetrePerMinute": { name: "cubicCentimetrePerMinute", label: "cubic centimetre per minute", symbol: "cm³/min", code: "G49", referenceUnit: null, conversionFactor: null, quantityKinds: [ "volumeFlowRate" ] },
        "cubicCentimetrePerMinuteBar": { name: "cubicCentimetrePerMinuteBar", label: "cubic centimetre per minute bar", symbol: "cm³/(min·bar)", code: "G80", referenceUnit: null, conversionFactor: null, quantityKinds: [ "volumeFlowRate" ] },
        "cubicCentimetrePerMinuteKelvin": { name: "cubicCentimetrePerMinuteKelvin", label: "cubic centimetre per minute kelvin", symbol: "cm³/(min·K)", code: "G63", referenceUnit: null, conversionFactor: null, quantityKinds: [ "volumeFlowRate" ] },
        "cubicCentimetrePerMole": { name: "cubicCentimetrePerMole", label: "cubic centimetre per mole", symbol: "cm³/mol", code: "A36", referenceUnit: function() { return samm.units["cubicMetrePerMole"] }, conversionFactor: "10⁻⁶ m³/mol", quantityKinds: [ "molarVolume", "molarVolume" ] },
        "cubicCentimetrePerSecond": { name: "cubicCentimetrePerSecond", label: "cubic centimetre per second", symbol: "cm³/s", code: "2J", referenceUnit: function() { return samm.units["cubicMetrePerSecond"] }, conversionFactor: "10⁻⁶ m³/s", quantityKinds: [ "volumeFlowRate", "volumeFlowRate", "recombinationCoefficient", "instantaneousVolumeFlowRate" ] },
        "cubicCentimetrePerSecondBar": { name: "cubicCentimetrePerSecondBar", label: "cubic centimetre per second bar", symbol: "cm³/(s·bar)", code: "G81", referenceUnit: null, conversionFactor: null, quantityKinds: [ "volumeFlowRate" ] },
        "cubicCentimetrePerSecondKelvin": { name: "cubicCentimetrePerSecondKelvin", label: "cubic centimetre per second kelvin", symbol: "cm³/(s·K)", code: "G64", referenceUnit: null, conversionFactor: null, quantityKinds: [ "volumeFlowRate" ] },
        "cubicDecametre": { name: "cubicDecametre", label: "cubic decametre", symbol: "dam³", code: "DMA", referenceUnit: function() { return samm.units["cubicMetre"] }, conversionFactor: "10³ m³", quantityKinds: [ "volume", "sectionModulus", "volume" ] },
        "cubicDecimetre": { name: "cubicDecimetre", label: "cubic decimetre", symbol: "dm³", code: "DMQ", referenceUnit: function() { return samm.units["cubicMetre"] }, conversionFactor: "10⁻³ m³", quantityKinds: [ "volume", "sectionModulus", "volume" ] },
        "cubicDecimetrePerCubicMetre": { name: "cubicDecimetrePerCubicMetre", label: "cubic decimetre per cubic metre", symbol: "dm³/m³", code: "J91", referenceUnit: null, conversionFactor: null, quantityKinds: [ "volumeRatio" ] },
        "cubicDecimetrePerDay": { name: "cubicDecimetrePerDay", label: "cubic decimetre per day", symbol: "dm³/d", code: "J90", referenceUnit: function() { return samm.units["cubicMetrePerSecond"] }, conversionFactor: "1.15741 × 10⁻⁸ m³/s", quantityKinds: [ "volumeFlowRate", "volumeFlowRate", "recombinationCoefficient", "instantaneousVolumeFlowRate" ] },
        "cubicDecimetrePerHour": { name: "cubicDecimetrePerHour", label: "cubic decimetre per hour", symbol: "dm³/h", code: "E92", referenceUnit: null, conversionFactor: null, quantityKinds: [ "volumeFlowRate" ] },
        "cubicDecimetrePerKilogram": { name: "cubicDecimetrePerKilogram", label: "cubic decimetre per kilogram", symbol: "dm³/kg", code: "N28", referenceUnit: null, conversionFactor: null, quantityKinds: [ "specificVolume", "massicVolume" ] },
        "cubicDecimetrePerMinute": { name: "cubicDecimetrePerMinute", label: "cubic decimetre per minute", symbol: "dm³/min", code: "J92", referenceUnit: function() { return samm.units["cubicMetrePerSecond"] }, conversionFactor: "1.66667 × 10⁻⁵ m³/s", quantityKinds: [ "volumeFlowRate", "volumeFlowRate", "recombinationCoefficient", "instantaneousVolumeFlowRate" ] },
        "cubicDecimetrePerMole": { name: "cubicDecimetrePerMole", label: "cubic decimetre per mole", symbol: "dm³/mol", code: "A37", referenceUnit: function() { return samm.units["cubicMetrePerMole"] }, conversionFactor: "10⁻³ m³/mol", quantityKinds: [ "molarVolume", "molarVolume" ] },
        "cubicDecimetrePerSecond": { name: "cubicDecimetrePerSecond", label: "cubic decimetre per second", symbol: "dm³/s", code: "J93", referenceUnit: function() { return samm.units["cubicMetrePerSecond"] }, conversionFactor: "10⁻³ m³/s", quantityKinds: [ "volumeFlowRate", "recombinationCoefficient", "instantaneousVolumeFlowRate", "volumeFlowRate" ] },
        "cubicFoot": { name: "cubicFoot", label: "cubic foot", symbol: "ft³", code: "FTQ", referenceUnit: function() { return samm.units["cubicMetre"] }, conversionFactor: "2.831685 × 10⁻² m³", quantityKinds: [ "volume", "sectionModulus", "volume" ] },
        "cubicFootPerDay": { name: "cubicFootPerDay", label: "cubic foot per day", symbol: "ft³/d", code: "K22", referenceUnit: function() { return samm.units["cubicMetrePerSecond"] }, conversionFactor: "3.277413 × 10⁻⁷ m³/s", quantityKinds: [ "volumeFlowRate", "recombinationCoefficient", "instantaneousVolumeFlowRate", "volumeFlowRate" ] },
        "cubicFootPerDegreeFahrenheit": { name: "cubicFootPerDegreeFahrenheit", label: "cubic foot per degree Fahrenheit", symbol: "ft³/°F", code: "K21", referenceUnit: function() { return samm.units["cubicMetrePerKelvin"] }, conversionFactor: "5.097033 × 10⁻² m³/K", quantityKinds: [ "volumePerTemperature", "volume" ] },
        "cubicFootPerHour": { name: "cubicFootPerHour", label: "cubic foot per hour", symbol: "ft³/h", code: "2K", referenceUnit: function() { return samm.units["cubicMetrePerSecond"] }, conversionFactor: "7.86579 × 10⁻⁶ m³/s", quantityKinds: [ "volumeFlowRate", "recombinationCoefficient", "instantaneousVolumeFlowRate", "volumeFlowRate" ] },
        "cubicFootPerMinute": { name: "cubicFootPerMinute", label: "cubic foot per minute", symbol: "ft³/min", code: "2L", referenceUnit: function() { return samm.units["cubicMetrePerSecond"] }, conversionFactor: "4.719474 × 10⁻⁴ m³/s", quantityKinds: [ "volumeFlowRate", "recombinationCoefficient", "instantaneousVolumeFlowRate", "volumeFlowRate" ] },
        "cubicFootPerPound": { name: "cubicFootPerPound", label: "cubic foot per pound", symbol: "ft³/lb", code: "N29", referenceUnit: function() { return samm.units["cubicMetrePerKilogram"] }, conversionFactor: "6.242796 × 10⁻² m³/kg", quantityKinds: [ "specificVolume", "massicVolume", "massicVolume", "specificVolume" ] },
        "cubicFootPerPsi": { name: "cubicFootPerPsi", label: "cubic foot per psi", symbol: "ft³/psi", code: "K23", referenceUnit: function() { return samm.units["cubicMetrePerPascal"] }, conversionFactor: "4.107012 × 10⁻⁶ m³/Pa", quantityKinds: [ "volume", "volume" ] },
        "cubicFootPerSecond": { name: "cubicFootPerSecond", label: "cubic foot per second", symbol: "ft³/s", code: "E17", referenceUnit: function() { return samm.units["cubicMetrePerSecond"] }, conversionFactor: "2.831685 × 10⁻² m³/s", quantityKinds: [ "volumeFlowRate", "recombinationCoefficient", "instantaneousVolumeFlowRate" ] },
        "cubicHectometre": { name: "cubicHectometre", label: "cubic hectometre", symbol: "hm³", code: "H19", referenceUnit: function() { return samm.units["cubicMetre"] }, conversionFactor: "10⁶ m³", quantityKinds: [ "volume", "sectionModulus", "volume" ] },
        "cubicInch": { name: "cubicInch", label: "cubic inch", symbol: "in³", code: "INQ", referenceUnit: function() { return samm.units["cubicMetre"] }, conversionFactor: "16.387064 × 10⁻⁶ m³", quantityKinds: [ "volume", "sectionModulus", "volume", "sectionModulus" ] },
        "cubicInchPerHour": { name: "cubicInchPerHour", label: "cubic inch per hour", symbol: "in³/h", code: "G56", referenceUnit: null, conversionFactor: null, quantityKinds: [ "volumeFlowRate" ] },
        "cubicInchPerMinute": { name: "cubicInchPerMinute", label: "cubic inch per minute", symbol: "in³/min", code: "G57", referenceUnit: null, conversionFactor: null, quantityKinds: [ "volumeFlowRate" ] },
        "cubicInchPerPound": { name: "cubicInchPerPound", label: "cubic inch per pound", symbol: "in³/lb", code: "N30", referenceUnit: function() { return samm.units["cubicMetrePerKilogram"] }, conversionFactor: "3.612728 × 10⁻⁵ m³/kg", quantityKinds: [ "specificVolume", "massicVolume", "specificVolume", "massicVolume" ] },
        "cubicInchPerSecond": { name: "cubicInchPerSecond", label: "cubic inch per second", symbol: "in³/s", code: "G58", referenceUnit: null, conversionFactor: null, quantityKinds: [ "volumeFlowRate" ] },
        "cubicKilometre": { name: "cubicKilometre", label: "cubic kilometre", symbol: "km³", code: "H20", referenceUnit: function() { return samm.units["cubicMetre"] }, conversionFactor: "10⁹ m³", quantityKinds: [ "volume", "sectionModulus", "volume" ] },
        "cubicMetre": { name: "cubicMetre", label: "cubic metre", symbol: "m³", code: "MTQ", referenceUnit: null, conversionFactor: null, quantityKinds: [ "volume", "sectionModulus" ] },
        "cubicMetrePerBar": { name: "cubicMetrePerBar", label: "cubic metre per bar", symbol: "m³/bar", code: "G96", referenceUnit: null, conversionFactor: null, quantityKinds: [ "volume" ] },
        "cubicMetrePerCoulomb": { name: "cubicMetrePerCoulomb", label: "cubic metre per coulomb", symbol: "m³/C", code: "A38", referenceUnit: null, conversionFactor: null, quantityKinds: [ "hallCoefficient" ] },
        "cubicMetrePerCubicMetre": { name: "cubicMetrePerCubicMetre", label: "cubic metre per cubic metre", symbol: "m³/m³", code: "H60", referenceUnit: null, conversionFactor: null, quantityKinds: [ "volumeRatio" ] },
        "cubicMetrePerDay": { name: "cubicMetrePerDay", label: "cubic metre per day", symbol: "m³/d", code: "G52", referenceUnit: null, conversionFactor: null, quantityKinds: [ "volumeFlowRate" ] },
        "cubicMetrePerDayBar": { name: "cubicMetrePerDayBar", label: "cubic metre per day bar", symbol: "m³/(d·bar)", code: "G86", referenceUnit: null, conversionFactor: null, quantityKinds: [ "volumeFlowRate" ] },
        "cubicMetrePerDayKelvin": { name: "cubicMetrePerDayKelvin", label: "cubic metre per day kelvin", symbol: "m³/(d·K)", code: "G69", referenceUnit: null, conversionFactor: null, quantityKinds: [ "volumeFlowRate" ] },
        "cubicMetrePerHour": { name: "cubicMetrePerHour", label: "cubic metre per hour", symbol: "m³/h", code: "MQH", referenceUnit: function() { return samm.units["cubicMetrePerSecond"] }, conversionFactor: "2.77778 × 10⁻⁴ m³/s", quantityKinds: [ "volumeFlowRate", "volumeFlowRate", "recombinationCoefficient", "instantaneousVolumeFlowRate" ] },
        "cubicMetrePerHourBar": { name: "cubicMetrePerHourBar", label: "cubic metre per hour bar", symbol: "m³/(h·bar)", code: "G87", referenceUnit: null, conversionFactor: null, quantityKinds: [ "volumeFlowRate" ] },
        "cubicMetrePerHourKelvin": { name: "cubicMetrePerHourKelvin", label: "cubic metre per hour kelvin", symbol: "m³/(h·K)", code: "G70", referenceUnit: null, conversionFactor: null, quantityKinds: [ "volumeFlowRate" ] },
        "cubicMetrePerKelvin": { name: "cubicMetrePerKelvin", label: "cubic metre per kelvin", symbol: "m³/K", code: "G29", referenceUnit: null, conversionFactor: null, quantityKinds: [ "volumePerTemperature" ] },
        "cubicMetrePerKilogram": { name: "cubicMetrePerKilogram", label: "cubic metre per kilogram", symbol: "m³/kg", code: "A39", referenceUnit: null, conversionFactor: null, quantityKinds: [ "specificVolume", "massicVolume" ] },
        "cubicMetrePerMinute": { name: "cubicMetrePerMinute", label: "cubic metre per minute", symbol: "m³/min", code: "G53", referenceUnit: null, conversionFactor: null, quantityKinds: [ "volumeFlowRate" ] },
        "cubicMetrePerMinuteBar": { name: "cubicMetrePerMinuteBar", label: "cubic metre per minute bar", symbol: "m³/(min·bar)", code: "G88", referenceUnit: null, conversionFactor: null, quantityKinds: [ "volumeFlowRate" ] },
        "cubicMetrePerMinuteKelvin": { name: "cubicMetrePerMinuteKelvin", label: "cubic metre per minute kelvin", symbol: "m³/(min·K)", code: "G71", referenceUnit: null, conversionFactor: null, quantityKinds: [ "volumeFlowRate" ] },
        "cubicMetrePerMole": { name: "cubicMetrePerMole", label: "cubic metre per mole", symbol: "m³/mol", code: "A40", referenceUnit: null, conversionFactor: null, quantityKinds: [ "molarVolume" ] },
        "cubicMetrePerPascal": { name: "cubicMetrePerPascal", label: "cubic metre per pascal", symbol: "m³/Pa", code: "M71", referenceUnit: null, conversionFactor: null, quantityKinds: [ "volume" ] },
        "cubicMetrePerSecond": { name: "cubicMetrePerSecond", label: "cubic metre per second", symbol: "m³/s", code: "MQS", referenceUnit: null, conversionFactor: null, quantityKinds: [ "volumeFlowRate", "recombinationCoefficient", "instantaneousVolumeFlowRate" ] },
        "cubicMetrePerSecondBar": { name: "cubicMetrePerSecondBar", label: "cubic metre per second bar", symbol: "m³/(s·bar)", code: "G89", referenceUnit: null, conversionFactor: null, quantityKinds: [ "volumeFlowRate" ] },
        "cubicMetrePerSecondKelvin": { name: "cubicMetrePerSecondKelvin", label: "cubic metre per second kelvin", symbol: "m³/(s·K)", code: "G72", referenceUnit: null, conversionFactor: null, quantityKinds: [ "volumeFlowRate" ] },
        "cubicMetrePerSecondPascal": { name: "cubicMetrePerSecondPascal", label: "cubic metre per second pascal", symbol: "(m³/s)/Pa", code: "N45", referenceUnit: null, conversionFactor: null, quantityKinds: [ "volumeFlowRate" ] },
        "cubicMetrePerSecondSquareMetre": { name: "cubicMetrePerSecondSquareMetre", label: "cubic metre per second square metre", symbol: "(m³/s)/m²", code: "P87", referenceUnit: function() { return samm.units["metrePerSecond"] }, conversionFactor: "m/s", quantityKinds: [ "groupVelocity", "velocityOfSoundPhaseVelocity", "phaseVelocity", "neutronSpeed", "phaseSpeedOfElectromagneticWaves", "velocity", "velocitySpeedOnPropagationOfElectromagneticWavesInVacuo", "instantaneousSoundParticleVelocity", "phaseVelocityOfElectromagneticWaves", "porosity" ] },
        "cubicMicrometre": { name: "cubicMicrometre", label: "cubic micrometre", symbol: "µm³", code: null, referenceUnit: function() { return samm.units["cubicMetre"] }, conversionFactor: "10⁻¹⁸ m³", quantityKinds: [ "volume", "sectionModulus", "volume" ] },
        "cubicMileUkStatute": { name: "cubicMileUkStatute", label: "cubic mile (UK statute)", symbol: "mi³", code: "M69", referenceUnit: function() { return samm.units["cubicMetre"] }, conversionFactor: "4.168182 × 10⁹ m³", quantityKinds: [ "volume", "sectionModulus", "volume" ] },
        "cubicMillimetre": { name: "cubicMillimetre", label: "cubic millimetre", symbol: "mm³", code: "MMQ", referenceUnit: function() { return samm.units["cubicMetre"] }, conversionFactor: "10⁻⁹ m³", quantityKinds: [ "volume", "sectionModulus", "volume" ] },
        "cubicMillimetrePerCubicMetre": { name: "cubicMillimetrePerCubicMetre", label: "cubic millimetre per cubic metre", symbol: "mm³/m³", code: "L21", referenceUnit: null, conversionFactor: null, quantityKinds: [ "volumeRatio" ] },
        "cubicYard": { name: "cubicYard", label: "cubic yard", symbol: "yd³", code: "YDQ", referenceUnit: function() { return samm.units["cubicMetre"] }, conversionFactor: "0.764555 m³", quantityKinds: [ "volume", "sectionModulus", "volume" ] },
        "cubicYardPerDay": { name: "cubicYardPerDay", label: "cubic yard per day", symbol: "yd³/d", code: "M12", referenceUnit: function() { return samm.units["cubicMetrePerSecond"] }, conversionFactor: "8.849015 × 10⁻⁶ m³/s", quantityKinds: [ "volumeFlowRate", "volumeFlowRate", "recombinationCoefficient", "instantaneousVolumeFlowRate" ] },
        "cubicYardPerDegreeFahrenheit": { name: "cubicYardPerDegreeFahrenheit", label: "cubic yard per degree Fahrenheit", symbol: "yd³/°F", code: "M11", referenceUnit: function() { return samm.units["cubicMetrePerKelvin"] }, conversionFactor: "1.376199 m³/K", quantityKinds: [ "volume", "volumePerTemperature" ] },
        "cubicYardPerHour": { name: "cubicYardPerHour", label: "cubic yard per hour", symbol: "yd³/h", code: "M13", referenceUnit: function() { return samm.units["cubicMetrePerSecond"] }, conversionFactor: "2.123764 × 10⁻⁴ m³/s", quantityKinds: [ "volumeFlowRate", "volumeFlowRate", "recombinationCoefficient", "instantaneousVolumeFlowRate" ] },
        "cubicYardPerMinute": { name: "cubicYardPerMinute", label: "cubic yard per minute", symbol: "yd³/min", code: "M15", referenceUnit: function() { return samm.units["cubicMetrePerSecond"] }, conversionFactor: "1.274258 × 10⁻² m³/s", quantityKinds: [ "volumeFlowRate", "recombinationCoefficient", "instantaneousVolumeFlowRate", "volumeFlowRate" ] },
        "cubicYardPerPsi": { name: "cubicYardPerPsi", label: "cubic yard per psi", symbol: "yd³/psi", code: "M14", referenceUnit: function() { return samm.units["cubicMetrePerPascal"] }, conversionFactor: "1.108893 × 10⁻⁴ m³/Pa", quantityKinds: [ "volume", "volume" ] },
        "cubicYardPerSecond": { name: "cubicYardPerSecond", label: "cubic yard per second", symbol: "yd³/s", code: "M16", referenceUnit: function() { return samm.units["cubicMetrePerSecond"] }, conversionFactor: "0.7645549 m³/s", quantityKinds: [ "volumeFlowRate", "volumeFlowRate", "recombinationCoefficient", "instantaneousVolumeFlowRate" ] },
        "cupUnitOfVolume": { name: "cupUnitOfVolume", label: "cup [unit of volume]", symbol: "cup (US)", code: "G21", referenceUnit: function() { return samm.units["cubicMetre"] }, conversionFactor: "2.365882 × 10⁻⁴ m³", quantityKinds: [ "volume", "sectionModulus", "volume" ] },
        "curie": { name: "curie", label: "curie", symbol: "Ci", code: "CUR", referenceUnit: function() { return samm.units["becquerel"] }, conversionFactor: "3.7 × 10¹⁰ Bq", quantityKinds: [ "activity", "activity" ] },
        "curiePerKilogram": { name: "curiePerKilogram", label: "curie per kilogram", symbol: "Ci/kg", code: "A42", referenceUnit: function() { return samm.units["becquerelPerKilogram"] }, conversionFactor: "3.7 × 10¹⁰ Bq/kg", quantityKinds: [ "specificActivityInASample", "specificActivityInASample" ] },
        "cycle": { name: "cycle", label: "cycle", symbol: null, code: "B7", referenceUnit: null, conversionFactor: null, quantityKinds: null },
        "day": { name: "day", label: "day", symbol: "d", code: "DAY", referenceUnit: function() { return samm.units["secondUnitOfTime"] }, conversionFactor: "86400 s", quantityKinds: [ "time", "timeConstant", "reactorTimeConstant", "halfLife", "meanLife", "time", "relaxationTime", "period", "carrierLifeTime", "periodicTime", "reverberationTime" ] },
        "deadweightTonnage": { name: "deadweightTonnage", label: "deadweight tonnage", symbol: "dwt", code: "A43", referenceUnit: null, conversionFactor: null, quantityKinds: null },
        "decade": { name: "decade", label: "decade", symbol: null, code: "DEC", referenceUnit: null, conversionFactor: null, quantityKinds: null },
        "decadeLogarithmic": { name: "decadeLogarithmic", label: "decade (logarithmic)", symbol: "dec", code: "P41", referenceUnit: null, conversionFactor: null, quantityKinds: [ "logarithmicDecrement" ] },
        "decagram": { name: "decagram", label: "decagram", symbol: "dag", code: "DJ", referenceUnit: function() { return samm.units["kilogram"] }, conversionFactor: "10⁻² kg", quantityKinds: [ "mass", "massOfAtomOfANuclideX", "massOfMolecule", "effectiveMass", "mass", "nuclidicMass", "massExcess" ] },
        "decalitre": { name: "decalitre", label: "decalitre", symbol: "dal", code: "A44", referenceUnit: function() { return samm.units["cubicMetre"] }, conversionFactor: "10⁻² m³", quantityKinds: [ "volume", "sectionModulus", "volume" ] },
        "decametre": { name: "decametre", label: "decametre", symbol: "dam", code: "A45", referenceUnit: function() { return samm.units["metre"] }, conversionFactor: "10 m", quantityKinds: [ "thickness", "radius", "height", "diameter", "length", "radiusOfCurvature", "distance", "lengthOfPath", "cartesianCoordinates", "breadth", "thickness", "particlePositionVector", "cartesianCoordinates", "focalDistance", "radius", "radiusOfCurvature", "displacementVectorOfIonOrAtom", "lengthOfPath", "diameter", "comptonWavelength", "slowingDownLength", "migrationLength", "meanFreePath", "equilibriumPositionVectorOfIonOrAtom", "instantaneousSoundParticleDisplacement", "imageDistance", "breadth", "length", "halfValueThickness", "coherenceLength", "latticeVector", "londonPenetrationDepth", "diffusionLength", "meanFreePathOfPhononsOrElectrons", "diffusionCoefficientForNeutronFluxDensity", "halfThickness", "height", "electronRadius", "distance", "objectDistance", "bohrRadius", "diffusionCoefficientForNeutronFluenceRate", "nuclearRadius", "wavelength", "fundamentalLatticeVector", "meanLinearRange" ] },
        "decapascal": { name: "decapascal", label: "decapascal", symbol: "daPa", code: "H75", referenceUnit: function() { return samm.units["pascal"] }, conversionFactor: "10¹ Pa", quantityKinds: [ "normalStress", "bulkModulus", "pressure", "modulusOfCompression", "shearModulus", "modulusOfElasticity", "modulusOfRigidity", "shearStress", "fugacityOfBInAGaseousMixture", "pressure", "shearModulus", "staticPressure", "normalStress", "modulusOfRigidity", "instantaneousSoundPressure", "modulusOfElasticity", "shearStress", "modulusOfCompression", "partialPressureOfBInAGaseousMixture", "bulkModulus", "osmoticPressure" ] },
        "decare": { name: "decare", label: "decare", symbol: "daa", code: "DAA", referenceUnit: function() { return samm.units["squareMetre"] }, conversionFactor: "10³ m²", quantityKinds: [ "area", "area", "atomicAttenuationCoefficient", "migrationArea", "crossSection", "equivalentAbsorptionAreaOfASurfaceOrObject", "nuclearQuadrupoleMoment", "slowingDownArea", "diffusionArea" ] },
        "decibel": { name: "decibel", label: "decibel", symbol: "dB", code: "2N", referenceUnit: function() { return samm.units["neper"] }, conversionFactor: "0.1151293 Np", quantityKinds: [ "levelOfAFieldQuantity", "levelOfAPowerQuantity", "soundReductionIndex", "soundPressureLevel", "soundPowerLevel", "logarithmicDecrement", "levelOfAPowerQuantity", "levelOfAFieldQuantity" ] },
        "decibelPerKilometre": { name: "decibelPerKilometre", label: "decibel per kilometre", symbol: "dB/km", code: "H51", referenceUnit: function() { return samm.units["belPerMetre"] }, conversionFactor: "10⁻⁴ B/m", quantityKinds: [ "soundPressureLevel", "soundPowerLevel", "soundPowerLevel", "soundPressureLevel" ] },
        "decibelPerMetre": { name: "decibelPerMetre", label: "decibel per metre", symbol: "dB/m", code: "H52", referenceUnit: function() { return samm.units["belPerMetre"] }, conversionFactor: "10⁻¹ B/m", quantityKinds: [ "soundPressureLevel", "soundPowerLevel", "soundPowerLevel", "soundPressureLevel" ] },
        "decigram": { name: "decigram", label: "decigram", symbol: "dg", code: "DG", referenceUnit: function() { return samm.units["kilogram"] }, conversionFactor: "10⁻⁴ kg", quantityKinds: [ "mass", "massOfAtomOfANuclideX", "massOfMolecule", "effectiveMass", "mass", "nuclidicMass", "massExcess" ] },
        "decilitre": { name: "decilitre", label: "decilitre", symbol: "dl", code: "DLT", referenceUnit: function() { return samm.units["cubicMetre"] }, conversionFactor: "10⁻⁴ m³", quantityKinds: [ "volume", "sectionModulus", "volume" ] },
        "decilitrePerGram": { name: "decilitrePerGram", label: "decilitre per gram", symbol: "dl/g", code: "22", referenceUnit: function() { return samm.units["cubicMetrePerKilogram"] }, conversionFactor: "10⁻¹ × m³/kg", quantityKinds: [ "specificVolume", "massicVolume", "massicVolume", "specificVolume" ] },
        "decimetre": { name: "decimetre", label: "decimetre", symbol: "dm", code: "DMT", referenceUnit: function() { return samm.units["metre"] }, conversionFactor: "10⁻¹ m", quantityKinds: [ "thickness", "particlePositionVector", "cartesianCoordinates", "focalDistance", "radius", "radiusOfCurvature", "displacementVectorOfIonOrAtom", "lengthOfPath", "diameter", "comptonWavelength", "slowingDownLength", "migrationLength", "meanFreePath", "equilibriumPositionVectorOfIonOrAtom", "instantaneousSoundParticleDisplacement", "imageDistance", "breadth", "length", "halfValueThickness", "coherenceLength", "latticeVector", "londonPenetrationDepth", "diffusionLength", "meanFreePathOfPhononsOrElectrons", "diffusionCoefficientForNeutronFluxDensity", "halfThickness", "height", "electronRadius", "distance", "objectDistance", "bohrRadius", "diffusionCoefficientForNeutronFluenceRate", "nuclearRadius", "wavelength", "fundamentalLatticeVector", "meanLinearRange", "cartesianCoordinates", "radius", "diameter", "height", "distance", "thickness", "breadth", "length", "radiusOfCurvature", "lengthOfPath" ] },
        "decinewtonMetre": { name: "decinewtonMetre", label: "decinewton metre", symbol: "dN·m", code: "DN", referenceUnit: function() { return samm.units["newtonMetre"] }, conversionFactor: "10⁻¹ N × m", quantityKinds: [ "torque", "momentOfForce", "momentOfACouple", "momentOfForce", "momentOfACouple", "torque" ] },
        "decitex": { name: "decitex", label: "decitex", symbol: "dtex (g/10km)", code: "A47", referenceUnit: null, conversionFactor: null, quantityKinds: null },
        "decitonne": { name: "decitonne", label: "decitonne", symbol: "dt or dtn", code: "DTN", referenceUnit: function() { return samm.units["kilogram"] }, conversionFactor: "10² kg", quantityKinds: [ "massOfAtomOfANuclideX", "massOfMolecule", "effectiveMass", "mass", "nuclidicMass", "massExcess", "mass" ] },
        "degreeApi": { name: "degreeApi", label: "degree API", symbol: "°API", code: "J13", referenceUnit: null, conversionFactor: null, quantityKinds: null },
        "degreeBalling": { name: "degreeBalling", label: "degree Balling", symbol: "°Balling", code: "J17", referenceUnit: null, conversionFactor: null, quantityKinds: null },
        "degreeBaumeOriginScale": { name: "degreeBaumeOriginScale", label: "degree Baume (origin scale)", symbol: "°Bé", code: "J14", referenceUnit: null, conversionFactor: null, quantityKinds: null },
        "degreeBaumeUsHeavy": { name: "degreeBaumeUsHeavy", label: "degree Baume (US heavy)", symbol: "°Bé (US heavy)", code: "J15", referenceUnit: null, conversionFactor: null, quantityKinds: null },
        "degreeBaumeUsLight": { name: "degreeBaumeUsLight", label: "degree Baume (US light)", symbol: "°Bé (US light)", code: "J16", referenceUnit: null, conversionFactor: null, quantityKinds: null },
        "degreeBrix": { name: "degreeBrix", label: "degree Brix", symbol: "°Bx", code: "J18", referenceUnit: null, conversionFactor: null, quantityKinds: null },
        "degreeCelsius": { name: "degreeCelsius", label: "degree Celsius", symbol: "°C", code: "CEL", referenceUnit: function() { return samm.units["kelvin"] }, conversionFactor: "1 × K", quantityKinds: [ "temperature", "neelTemperature", "thermodynamic", "superConductorTransitionTemperature", "debyeTemperature", "fermiTemperature", "curieTemperature" ] },
        "degreeCelsiusPerBar": { name: "degreeCelsiusPerBar", label: "degree Celsius per bar", symbol: "°C/bar", code: "F60", referenceUnit: null, conversionFactor: null, quantityKinds: [ "temperature" ] },
        "degreeCelsiusPerHour": { name: "degreeCelsiusPerHour", label: "degree Celsius per hour", symbol: "°C/h", code: "H12", referenceUnit: null, conversionFactor: null, quantityKinds: [ "temperature" ] },
        "degreeCelsiusPerKelvin": { name: "degreeCelsiusPerKelvin", label: "degree Celsius per kelvin", symbol: "°C/K", code: "E98", referenceUnit: null, conversionFactor: null, quantityKinds: [ "temperature" ] },
        "degreeCelsiusPerMinute": { name: "degreeCelsiusPerMinute", label: "degree Celsius per minute", symbol: "°C/min", code: "H13", referenceUnit: null, conversionFactor: null, quantityKinds: [ "temperature" ] },
        "degreeCelsiusPerSecond": { name: "degreeCelsiusPerSecond", label: "degree Celsius per second", symbol: "°C/s", code: "H14", referenceUnit: null, conversionFactor: null, quantityKinds: [ "temperature" ] },
        "degreeDay": { name: "degreeDay", label: "degree day", symbol: "deg da", code: "E10", referenceUnit: null, conversionFactor: null, quantityKinds: null },
        "degreeFahrenheit": { name: "degreeFahrenheit", label: "degree Fahrenheit", symbol: "°F", code: "FAH", referenceUnit: null, conversionFactor: null, quantityKinds: [ "fahrenheitTemperature" ] },
        "degreeFahrenheitHourPerBritishThermalUnitInternationalTable": { name: "degreeFahrenheitHourPerBritishThermalUnitInternationalTable", label: "degree Fahrenheit hour per British thermal unit (international table)", symbol: "°F/(BtuIT/h)", code: "N84", referenceUnit: function() { return samm.units["kelvinPerWatt"] }, conversionFactor: "1.895634 K/W", quantityKinds: [ "thermalResistance", "thermalResistance" ] },
        "degreeFahrenheitHourPerBritishThermalUnitThermochemical": { name: "degreeFahrenheitHourPerBritishThermalUnitThermochemical", label: "degree Fahrenheit hour per British thermal unit (thermochemical)", symbol: "°F/(Btuth/h)", code: "N85", referenceUnit: function() { return samm.units["kelvinPerWatt"] }, conversionFactor: "1.896903 K/W", quantityKinds: [ "thermalResistance", "thermalResistance" ] },
        "degreeFahrenheitHourSquareFootPerBritishThermalUnitInternationalTable": { name: "degreeFahrenheitHourSquareFootPerBritishThermalUnitInternationalTable", label: "degree Fahrenheit hour square foot per British thermal unit (international table)", symbol: "°F·h·ft²/BtuIT", code: "J22", referenceUnit: function() { return samm.units["squareMetreKelvinPerWatt"] }, conversionFactor: "0.1761102 m² × K/W", quantityKinds: [ "thermalInsulance", "coefficientOfThermalInsulation", "thermalInsulance", "coefficientOfThermalInsulation" ] },
        "degreeFahrenheitHourSquareFootPerBritishThermalUnitInternationalTableInch": { name: "degreeFahrenheitHourSquareFootPerBritishThermalUnitInternationalTableInch", label: "degree Fahrenheit hour square foot per British thermal unit (international table) inch", symbol: "°F·h·ft²/(BtuIT·in)", code: "N88", referenceUnit: function() { return samm.units["kelvinMetrePerWatt"] }, conversionFactor: "6.933472 K × m/W", quantityKinds: [ "thermalResistance", "thermalResistance" ] },
        "degreeFahrenheitHourSquareFootPerBritishThermalUnitThermochemical": { name: "degreeFahrenheitHourSquareFootPerBritishThermalUnitThermochemical", label: "degree Fahrenheit hour square foot per British thermal unit (thermochemical)", symbol: "°F·h·ft²/Btuth", code: "J19", referenceUnit: function() { return samm.units["squareMetreKelvinPerWatt"] }, conversionFactor: "0.176228 m² × K/W", quantityKinds: [ "thermalInsulance", "coefficientOfThermalInsulation", "thermalInsulance", "coefficientOfThermalInsulation" ] },
        "degreeFahrenheitHourSquareFootPerBritishThermalUnitThermochemicalInch": { name: "degreeFahrenheitHourSquareFootPerBritishThermalUnitThermochemicalInch", label: "degree Fahrenheit hour square foot per British thermal unit (thermochemical) inch", symbol: "°F·h·ft²/(Btuth·in)", code: "N89", referenceUnit: function() { return samm.units["kelvinMetrePerWatt"] }, conversionFactor: "6.938112 K × m/W", quantityKinds: [ "thermalResistance", "thermalResistance" ] },
        "degreeFahrenheitPerBar": { name: "degreeFahrenheitPerBar", label: "degree Fahrenheit per bar", symbol: "°F/bar", code: "J21", referenceUnit: function() { return samm.units["kelvinPerPascal"] }, conversionFactor: "0.5555556 × 10⁻⁵ K/Pa", quantityKinds: [ "temperature", "temperature" ] },
        "degreeFahrenheitPerHour": { name: "degreeFahrenheitPerHour", label: "degree Fahrenheit per hour", symbol: "°F/h", code: "J23", referenceUnit: function() { return samm.units["kelvinPerSecond"] }, conversionFactor: "1.543210 × 10⁻⁴ K/s", quantityKinds: [ "temperatureVariationOverTime", "temperature" ] },
        "degreeFahrenheitPerKelvin": { name: "degreeFahrenheitPerKelvin", label: "degree Fahrenheit per kelvin", symbol: "°F/K", code: "J20", referenceUnit: null, conversionFactor: null, quantityKinds: [ "temperature" ] },
        "degreeFahrenheitPerMinute": { name: "degreeFahrenheitPerMinute", label: "degree Fahrenheit per minute", symbol: "°F/min", code: "J24", referenceUnit: function() { return samm.units["kelvinPerSecond"] }, conversionFactor: "9.259259 × 10⁻³ K/s", quantityKinds: [ "temperatureVariationOverTime", "temperature" ] },
        "degreeFahrenheitPerSecond": { name: "degreeFahrenheitPerSecond", label: "degree Fahrenheit per second", symbol: "°F/s", code: "J25", referenceUnit: function() { return samm.units["kelvinPerSecond"] }, conversionFactor: "0.5555556 K/s", quantityKinds: [ "temperature", "temperatureVariationOverTime" ] },
        "degreeFahrenheitSecondPerBritishThermalUnitInternationalTable": { name: "degreeFahrenheitSecondPerBritishThermalUnitInternationalTable", label: "degree Fahrenheit second per British thermal unit (international table)", symbol: "°F/(BtuIT/s)", code: "N86", referenceUnit: function() { return samm.units["kelvinPerWatt"] }, conversionFactor: "5.265651 × 10⁻⁴ K/W", quantityKinds: [ "thermalResistance", "thermalResistance" ] },
        "degreeFahrenheitSecondPerBritishThermalUnitThermochemical": { name: "degreeFahrenheitSecondPerBritishThermalUnitThermochemical", label: "degree Fahrenheit second per British thermal unit (thermochemical)", symbol: "°F/(Btuth/s)", code: "N87", referenceUnit: function() { return samm.units["kelvinPerWatt"] }, conversionFactor: "5.269175 × 10⁻⁴ K/W", quantityKinds: [ "thermalResistance", "thermalResistance" ] },
        "degreeOechsle": { name: "degreeOechsle", label: "degree Oechsle", symbol: "°Oechsle", code: "J27", referenceUnit: null, conversionFactor: null, quantityKinds: null },
        "degreePerMetre": { name: "degreePerMetre", label: "degree per metre", symbol: "°/m", code: "H27", referenceUnit: function() { return samm.units["radianPerMetre"] }, conversionFactor: "1.745329 × 10⁻² rad/m", quantityKinds: [ "angularWaveNumber", "angularWavenumber", "angularRepetency", "debyeAngularRepetency", "debyeAngularWaveNumber", "solidAngle" ] },
        "degreePerSecond": { name: "degreePerSecond", label: "degree per second", symbol: "°/s", code: "E96", referenceUnit: null, conversionFactor: null, quantityKinds: [ "solidAngle" ] },
        "degreePlato": { name: "degreePlato", label: "degree Plato", symbol: "°P", code: "PLA", referenceUnit: null, conversionFactor: null, quantityKinds: null },
        "degreeRankine": { name: "degreeRankine", label: "degree Rankine", symbol: "°R", code: "A48", referenceUnit: null, conversionFactor: null, quantityKinds: [ "temperature" ] },
        "degreeRankinePerHour": { name: "degreeRankinePerHour", label: "degree Rankine per hour", symbol: "°R/h", code: "J28", referenceUnit: function() { return samm.units["kelvinPerSecond"] }, conversionFactor: "1.543210 × 10⁻⁴ K/s", quantityKinds: [ "temperature", "temperatureVariationOverTime" ] },
        "degreeRankinePerMinute": { name: "degreeRankinePerMinute", label: "degree Rankine per minute", symbol: "°R/min", code: "J29", referenceUnit: function() { return samm.units["kelvinPerSecond"] }, conversionFactor: "9.259259 × 10⁻³ K/s", quantityKinds: [ "temperatureVariationOverTime", "temperature" ] },
        "degreeRankinePerSecond": { name: "degreeRankinePerSecond", label: "degree Rankine per second", symbol: "°R/s", code: "J30", referenceUnit: function() { return samm.units["kelvinPerSecond"] }, conversionFactor: "0.5555556 K/s", quantityKinds: [ "temperature", "temperatureVariationOverTime" ] },
        "degreeTwaddell": { name: "degreeTwaddell", label: "degree Twaddell", symbol: "°Tw", code: "J31", referenceUnit: null, conversionFactor: null, quantityKinds: null },
        "degreeUnitOfAngle": { name: "degreeUnitOfAngle", label: "degree [unit of angle]", symbol: "°", code: "DD", referenceUnit: function() { return samm.units["rad"] }, conversionFactor: "1.745329 × 10⁻² rad", quantityKinds: [ "absorbedDose", "anglePlane", "braggAngle" ] },
        "degreeUnitOfAnglePerSecondSquared": { name: "degreeUnitOfAnglePerSecondSquared", label: "degree [unit of angle] per second squared", symbol: "°/s²", code: "M45", referenceUnit: null, conversionFactor: null, quantityKinds: [ "angularAcceleration" ] },
        "denier": { name: "denier", label: "denier", symbol: "den (g/9 km)", code: "A49", referenceUnit: function() { return samm.units["kilogramPerMetre"] }, conversionFactor: "1.111111 × 10⁻⁷ kg/m", quantityKinds: [ "linearMass", "linearDensity", "linearMass", "linearDensity" ] },
        "digit": { name: "digit", label: "digit", symbol: null, code: "B19", referenceUnit: null, conversionFactor: null, quantityKinds: null },
        "dioptre": { name: "dioptre", label: "dioptre", symbol: "dpt", code: "Q25", referenceUnit: function() { return samm.units["reciprocalMetre"] }, conversionFactor: "m⁻¹", quantityKinds: [ "linearAbsorptionCoefficient", "linearIonizationByAParticle", "attenuationCoefficient", "macroscopicTotalCrossSection", "repetency", "angularWaveNumber", "angularReciprocalLatticeVector", "fundamentalReciprocalLatticeVector", "linearAttenuationCoefficient", "volumicCrossSection", "propagationCoefficient", "linearExtinctionCoefficient", "vergence", "totalIonizationByAParticle", "angularRepetency", "wavenumber", "volumicTotalCrossSection", "lensPower", "waveNumber", "curvature", "phaseCoefficient", "rydbergConstant", "macroscopicCrossSection" ] },
        "displacementTonnage": { name: "displacementTonnage", label: "displacement tonnage", symbol: null, code: "DPT", referenceUnit: null, conversionFactor: null, quantityKinds: null },
        "dose": { name: "dose", label: "dose", symbol: null, code: "E27", referenceUnit: null, conversionFactor: null, quantityKinds: null },
        "dotsPerInch": { name: "dotsPerInch", label: "dots per inch", symbol: "dpi", code: "E39", referenceUnit: null, conversionFactor: null, quantityKinds: null },
        "dozen": { name: "dozen", label: "dozen", symbol: "DOZ", code: "DZN", referenceUnit: null, conversionFactor: null, quantityKinds: null },
        "dozenPack": { name: "dozenPack", label: "dozen pack", symbol: null, code: "DZP", referenceUnit: null, conversionFactor: null, quantityKinds: null },
        "dozenPair": { name: "dozenPair", label: "dozen pair", symbol: null, code: "DPR", referenceUnit: null, conversionFactor: null, quantityKinds: null },
        "dozenPiece": { name: "dozenPiece", label: "dozen piece", symbol: null, code: "DPC", referenceUnit: null, conversionFactor: null, quantityKinds: null },
        "dozenRoll": { name: "dozenRoll", label: "dozen roll", symbol: null, code: "DRL", referenceUnit: null, conversionFactor: null, quantityKinds: null },
        "dramUk": { name: "dramUk", label: "dram (UK)", symbol: null, code: "DRI", referenceUnit: function() { return samm.units["gram"] }, conversionFactor: "1.771745 g", quantityKinds: [ "mass" ] },
        "dramUs": { name: "dramUs", label: "dram (US)", symbol: null, code: "DRA", referenceUnit: function() { return samm.units["gram"] }, conversionFactor: "3.887935 g", quantityKinds: [ "mass" ] },
        "dryBarrelUs": { name: "dryBarrelUs", label: "dry barrel (US)", symbol: "bbl (US)", code: "BLD", referenceUnit: function() { return samm.units["cubicMetre"] }, conversionFactor: "1.15627 × 10⁻¹ m³", quantityKinds: [ "volume", "volume", "sectionModulus" ] },
        "dryGallonUs": { name: "dryGallonUs", label: "dry gallon (US)", symbol: "dry gal (US)", code: "GLD", referenceUnit: function() { return samm.units["cubicMetre"] }, conversionFactor: "4.404884 × 10⁻³ m³", quantityKinds: [ "volume", "sectionModulus", "volume" ] },
        "dryPintUs": { name: "dryPintUs", label: "dry pint (US)", symbol: "dry pt (US)", code: "PTD", referenceUnit: function() { return samm.units["cubicMetre"] }, conversionFactor: "5.506105 × 10⁻⁴ m³", quantityKinds: [ "volume", "sectionModulus", "volume" ] },
        "dryPound": { name: "dryPound", label: "dry pound", symbol: null, code: "DB", referenceUnit: null, conversionFactor: null, quantityKinds: null },
        "dryQuartUs": { name: "dryQuartUs", label: "dry quart (US)", symbol: "dry qt (US)", code: "QTD", referenceUnit: function() { return samm.units["cubicMetre"] }, conversionFactor: "1.101221 × 10⁻³ m³", quantityKinds: [ "volume", "sectionModulus", "volume" ] },
        "dryTon": { name: "dryTon", label: "dry ton", symbol: null, code: "DT", referenceUnit: null, conversionFactor: null, quantityKinds: null },
        "dyneMetre": { name: "dyneMetre", label: "dyne metre", symbol: "dyn·m", code: "M97", referenceUnit: function() { return samm.units["newtonMetre"] }, conversionFactor: "10⁻⁵ N × m", quantityKinds: [ "momentOfACouple", "torque", "momentOfForce", "torque", "momentOfForce", "momentOfACouple" ] },
        "each": { name: "each", label: "each", symbol: null, code: "EA", referenceUnit: null, conversionFactor: null, quantityKinds: null },
        "eightPartCloudCover": { name: "eightPartCloudCover", label: "8-part cloud cover", symbol: null, code: "A59", referenceUnit: null, conversionFactor: null, quantityKinds: null },
        "electronicMailBox": { name: "electronicMailBox", label: "electronic mail box", symbol: null, code: "EB", referenceUnit: null, conversionFactor: null, quantityKinds: null },
        "electronvolt": { name: "electronvolt", label: "electronvolt", symbol: "eV", code: "A53", referenceUnit: function() { return samm.units["joule"] }, conversionFactor: "1.602176487 × 10⁻¹⁹ J", quantityKinds: [ "quantityOfHeat", "reactionEnergy", "workFunction", "activeEnergy", "kineticEnergy", "levelWidth", "meanEnergyImparted", "helmholtzFunction", "radiantEnergy", "potentialEnergy", "energy", "thermodynamicEnergy", "helmholtzFreeEnergy", "work", "heat", "hartreeEnergy", "energyImparted", "enthalpy", "alphaDisintegrationEnergy", "maximumBetaParticleEnergy", "fermiEnergy", "potentialEnergy", "work", "kineticEnergy", "resonanceEnergy", "betaDisintegrationEnergy", "energy" ] },
        "electronvoltPerMetre": { name: "electronvoltPerMetre", label: "electronvolt per metre", symbol: "eV/m", code: "A54", referenceUnit: function() { return samm.units["joulePerMetre"] }, conversionFactor: "1.602176487 × 10⁻¹⁹ J/m", quantityKinds: [ "totalLinearStoppingPower", "linearEnergyTransfer", "linearEnergyTransfer", "totalLinearStoppingPower" ] },
        "electronvoltSquareMetre": { name: "electronvoltSquareMetre", label: "electronvolt square metre", symbol: "eV·m²", code: "A55", referenceUnit: function() { return samm.units["jouleSquareMetre"] }, conversionFactor: "1.602176487 × 10⁻¹⁹ J × m²", quantityKinds: [ "totalAtomicStoppingPower", "totalAtomicStoppingPower" ] },
        "electronvoltSquareMetrePerKilogram": { name: "electronvoltSquareMetrePerKilogram", label: "electronvolt square metre per kilogram", symbol: "eV·m²/kg", code: "A56", referenceUnit: function() { return samm.units["jouleSquareMetrePerKilogram"] }, conversionFactor: "1.602176487 × 10⁻¹⁹ J × m²/kg", quantityKinds: [ "totalMassStoppingPower", "totalMassStoppingPower" ] },
        "equivalentGallon": { name: "equivalentGallon", label: "equivalent gallon", symbol: null, code: "EQ", referenceUnit: null, conversionFactor: null, quantityKinds: null },
        "erlang": { name: "erlang", label: "erlang", symbol: "E", code: "Q11", referenceUnit: null, conversionFactor: null, quantityKinds: null },
        "exabitPerSecond": { name: "exabitPerSecond", label: "exabit per second", symbol: "Ebit/s", code: "E58", referenceUnit: null, conversionFactor: null, quantityKinds: null },
        "exabyte": { name: "exabyte", label: "Exabyte", symbol: "EB", code: null, referenceUnit: function() { return samm.units["byte"] }, conversionFactor: "10¹⁸ B", quantityKinds: [ "informationEntropy", "informationEntropy" ] },
        "exajoule": { name: "exajoule", label: "exajoule", symbol: "EJ", code: "A68", referenceUnit: function() { return samm.units["joule"] }, conversionFactor: "10¹⁸ J", quantityKinds: [ "quantityOfHeat", "reactionEnergy", "workFunction", "activeEnergy", "kineticEnergy", "levelWidth", "meanEnergyImparted", "helmholtzFunction", "radiantEnergy", "potentialEnergy", "energy", "thermodynamicEnergy", "helmholtzFreeEnergy", "work", "heat", "hartreeEnergy", "energyImparted", "enthalpy", "alphaDisintegrationEnergy", "work", "energy", "potentialEnergy", "kineticEnergy" ] },
        "exbibitPerCubicMetre": { name: "exbibitPerCubicMetre", label: "exbibit per cubic metre", symbol: "Eibit/m³", code: "E67", referenceUnit: null, conversionFactor: null, quantityKinds: null },
        "exbibitPerMetre": { name: "exbibitPerMetre", label: "exbibit per metre", symbol: "Eibit/m", code: "E65", referenceUnit: null, conversionFactor: null, quantityKinds: null },
        "exbibitPerSquareMetre": { name: "exbibitPerSquareMetre", label: "exbibit per square metre", symbol: "Eibit/m²", code: "E66", referenceUnit: null, conversionFactor: null, quantityKinds: null },
        "exbibyte": { name: "exbibyte", label: "exbibyte", symbol: "Eibyte", code: "E59", referenceUnit: function() { return samm.units["byte"] }, conversionFactor: "2⁶⁰ B", quantityKinds: [ "informationEntropy", "informationEntropy" ] },
        "failuresInTime": { name: "failuresInTime", label: "failures in time", symbol: "FIT", code: "FIT", referenceUnit: function() { return samm.units["reciprocalSecond"] }, conversionFactor: "2.77778 × 10⁻¹³ s⁻¹", quantityKinds: [ "angularFrequency", "decayConstant", "dampingCoefficient", "debyeAngularFrequency", "disintegrationConstant", "photonFlux", "larmorAngularFrequency", "circularFrequency", "pulsatance", "rotationalFrequency" ] },
        "farad": { name: "farad", label: "farad", symbol: "F", code: "FAR", referenceUnit: null, conversionFactor: null, quantityKinds: [ "capacitance" ] },
        "faradPerKilometre": { name: "faradPerKilometre", label: "farad per kilometre", symbol: "F/km", code: "H33", referenceUnit: function() { return samm.units["faradPerMetre"] }, conversionFactor: "10⁻³ F/m", quantityKinds: [ "permittivityOfVacuum", "permittivity", "electricConstant", "permittivity", "permittivityOfVacuum", "electricConstant" ] },
        "faradPerMetre": { name: "faradPerMetre", label: "farad per metre", symbol: "F/m", code: "A69", referenceUnit: null, conversionFactor: null, quantityKinds: [ "permittivityOfVacuum", "permittivity", "electricConstant" ] },
        "fathom": { name: "fathom", label: "fathom", symbol: "fth", code: "AK", referenceUnit: function() { return samm.units["metre"] }, conversionFactor: "1.8288 m", quantityKinds: [ "thickness", "particlePositionVector", "cartesianCoordinates", "focalDistance", "radius", "radiusOfCurvature", "displacementVectorOfIonOrAtom", "lengthOfPath", "diameter", "comptonWavelength", "slowingDownLength", "migrationLength", "meanFreePath", "equilibriumPositionVectorOfIonOrAtom", "instantaneousSoundParticleDisplacement", "imageDistance", "breadth", "length", "halfValueThickness", "coherenceLength", "latticeVector", "londonPenetrationDepth", "diffusionLength", "meanFreePathOfPhononsOrElectrons", "diffusionCoefficientForNeutronFluxDensity", "halfThickness", "height", "electronRadius", "distance", "objectDistance", "bohrRadius", "diffusionCoefficientForNeutronFluenceRate", "nuclearRadius", "wavelength", "fundamentalLatticeVector", "meanLinearRange", "diameter", "thickness", "length", "radius", "lengthOfPath", "distance", "cartesianCoordinates", "breadth", "height", "radiusOfCurvature" ] },
        "femtojoule": { name: "femtojoule", label: "femtojoule", symbol: "fJ", code: "A70", referenceUnit: function() { return samm.units["joule"] }, conversionFactor: "10⁻¹⁵ J", quantityKinds: [ "quantityOfHeat", "reactionEnergy", "workFunction", "activeEnergy", "kineticEnergy", "levelWidth", "meanEnergyImparted", "helmholtzFunction", "radiantEnergy", "potentialEnergy", "energy", "thermodynamicEnergy", "helmholtzFreeEnergy", "work", "heat", "hartreeEnergy", "energyImparted", "enthalpy", "alphaDisintegrationEnergy", "gapEnergy", "work", "potentialEnergy", "kineticEnergy", "energy" ] },
        "femtometre": { name: "femtometre", label: "femtometre", symbol: "fm", code: "A71", referenceUnit: function() { return samm.units["metre"] }, conversionFactor: "10⁻¹⁵ m", quantityKinds: [ "distance", "thickness", "length", "radiusOfCurvature", "radius", "lengthOfPath", "diameter", "cartesianCoordinates", "breadth", "height", "thickness", "particlePositionVector", "cartesianCoordinates", "focalDistance", "radius", "radiusOfCurvature", "displacementVectorOfIonOrAtom", "lengthOfPath", "diameter", "comptonWavelength", "slowingDownLength", "migrationLength", "meanFreePath", "equilibriumPositionVectorOfIonOrAtom", "instantaneousSoundParticleDisplacement", "imageDistance", "breadth", "length", "halfValueThickness", "coherenceLength", "latticeVector", "londonPenetrationDepth", "diffusionLength", "meanFreePathOfPhononsOrElectrons", "diffusionCoefficientForNeutronFluxDensity", "halfThickness", "height", "electronRadius", "distance", "objectDistance", "bohrRadius", "diffusionCoefficientForNeutronFluenceRate", "nuclearRadius", "wavelength", "fundamentalLatticeVector", "meanLinearRange" ] },
        "fibreMetre": { name: "fibreMetre", label: "fibre metre", symbol: null, code: "FBM", referenceUnit: null, conversionFactor: null, quantityKinds: null },
        "fivePack": { name: "fivePack", label: "five pack", symbol: null, code: "P5", referenceUnit: null, conversionFactor: null, quantityKinds: null },
        "fixedRate": { name: "fixedRate", label: "fixed rate", symbol: null, code: "1I", referenceUnit: null, conversionFactor: null, quantityKinds: null },
        "flakeTon": { name: "flakeTon", label: "flake ton", symbol: null, code: "FL", referenceUnit: null, conversionFactor: null, quantityKinds: null },
        "fluidOunceUk": { name: "fluidOunceUk", label: "fluid ounce (UK)", symbol: "fl oz (UK)", code: "OZI", referenceUnit: function() { return samm.units["cubicMetre"] }, conversionFactor: "2.841306 × 10⁻⁵ m³", quantityKinds: [ "volume", "sectionModulus", "volume" ] },
        "fluidOunceUs": { name: "fluidOunceUs", label: "fluid ounce (US)", symbol: "fl oz (US)", code: "OZA", referenceUnit: function() { return samm.units["cubicMetre"] }, conversionFactor: "2.957353 × 10⁻⁵ m³", quantityKinds: [ "volume", "sectionModulus", "volume" ] },
        "foot": { name: "foot", label: "foot", symbol: "ft", code: "FOT", referenceUnit: function() { return samm.units["metre"] }, conversionFactor: "0.3048 m", quantityKinds: [ "thickness", "particlePositionVector", "cartesianCoordinates", "focalDistance", "radius", "radiusOfCurvature", "displacementVectorOfIonOrAtom", "lengthOfPath", "diameter", "comptonWavelength", "slowingDownLength", "migrationLength", "meanFreePath", "equilibriumPositionVectorOfIonOrAtom", "instantaneousSoundParticleDisplacement", "imageDistance", "breadth", "length", "halfValueThickness", "coherenceLength", "latticeVector", "londonPenetrationDepth", "diffusionLength", "meanFreePathOfPhononsOrElectrons", "diffusionCoefficientForNeutronFluxDensity", "halfThickness", "height", "electronRadius", "distance", "objectDistance", "bohrRadius", "diffusionCoefficientForNeutronFluenceRate", "nuclearRadius", "wavelength", "fundamentalLatticeVector", "meanLinearRange", "lengthOfPath", "radiusOfCurvature", "diameter", "radius", "cartesianCoordinates", "length", "breadth", "distance", "height", "thickness" ] },
        "footOfWater392Degreesf": { name: "footOfWater392Degreesf", label: "foot of water (39.2 °F)", symbol: "ftH₂O (39,2 °F)", code: "N15", referenceUnit: function() { return samm.units["pascal"] }, conversionFactor: "2.98898 × 10³ Pa", quantityKinds: [ "modulusOfCompression", "modulusOfRigidity", "normalStress", "modulusOfElasticity", "bulkModulus", "pressure", "shearStress", "shearModulus", "fugacityOfBInAGaseousMixture", "pressure", "shearModulus", "staticPressure", "normalStress", "modulusOfRigidity", "instantaneousSoundPressure", "modulusOfElasticity", "shearStress", "modulusOfCompression", "partialPressureOfBInAGaseousMixture", "bulkModulus", "osmoticPressure" ] },
        "footPerDegreeFahrenheit": { name: "footPerDegreeFahrenheit", label: "foot per degree Fahrenheit", symbol: "ft/°F", code: "K13", referenceUnit: function() { return samm.units["metrePerKelvin"] }, conversionFactor: "0.54864 m/K", quantityKinds: [ "thickness", "length", "lengthOfPath", "distance", "radius", "diameter", "breadth", "cartesianCoordinates", "radiusOfCurvature", "height", "cartesianCoordinates", "diameter", "lengthOfPath", "height", "thickness", "radiusOfCurvature", "breadth", "radius", "distance", "length" ] },
        "footPerHour": { name: "footPerHour", label: "foot per hour", symbol: "ft/h", code: "K14", referenceUnit: function() { return samm.units["metrePerSecond"] }, conversionFactor: "8.466667 × 10⁻⁵m/s", quantityKinds: [ "groupVelocity", "velocityOfSoundPhaseVelocity", "phaseVelocity", "neutronSpeed", "phaseSpeedOfElectromagneticWaves", "velocity", "velocitySpeedOnPropagationOfElectromagneticWavesInVacuo", "instantaneousSoundParticleVelocity", "phaseVelocityOfElectromagneticWaves", "groupVelocity", "phaseVelocity", "velocity" ] },
        "footPerMinute": { name: "footPerMinute", label: "foot per minute", symbol: "ft/min", code: "FR", referenceUnit: function() { return samm.units["metrePerSecond"] }, conversionFactor: "5.08 × 10⁻³ m/s", quantityKinds: [ "groupVelocity", "velocityOfSoundPhaseVelocity", "phaseVelocity", "neutronSpeed", "phaseSpeedOfElectromagneticWaves", "velocity", "velocitySpeedOnPropagationOfElectromagneticWavesInVacuo", "instantaneousSoundParticleVelocity", "phaseVelocityOfElectromagneticWaves", "phaseVelocity", "groupVelocity", "velocity" ] },
        "footPerPsi": { name: "footPerPsi", label: "foot per psi", symbol: "ft/psi", code: "K17", referenceUnit: function() { return samm.units["metrePerPascal"] }, conversionFactor: "4.420750 × 10⁻⁵ m/Pa", quantityKinds: [ "cartesianCoordinates", "radius", "lengthOfPath", "diameter", "radiusOfCurvature", "height", "length", "breadth", "distance", "thickness", "distance", "breadth", "cartesianCoordinates", "radius", "length", "radiusOfCurvature", "diameter", "lengthOfPath", "height", "thickness" ] },
        "footPerSecond": { name: "footPerSecond", label: "foot per second", symbol: "ft/s", code: "FS", referenceUnit: function() { return samm.units["metrePerSecond"] }, conversionFactor: "0.3048 m/s", quantityKinds: [ "groupVelocity", "phaseVelocity", "velocity", "groupVelocity", "velocityOfSoundPhaseVelocity", "phaseVelocity", "neutronSpeed", "phaseSpeedOfElectromagneticWaves", "velocity", "velocitySpeedOnPropagationOfElectromagneticWavesInVacuo", "instantaneousSoundParticleVelocity", "phaseVelocityOfElectromagneticWaves" ] },
        "footPerSecondDegreeFahrenheit": { name: "footPerSecondDegreeFahrenheit", label: "foot per second degree Fahrenheit", symbol: "(ft/s)/°F", code: "K18", referenceUnit: function() { return samm.units["metrePerSecondKelvin"] }, conversionFactor: "0.54864 (m/s)/K", quantityKinds: [ "velocity", "groupVelocity", "phaseVelocity", "velocity", "phaseVelocity", "groupVelocity" ] },
        "footPerSecondPsi": { name: "footPerSecondPsi", label: "foot per second psi", symbol: "(ft/s)/psi", code: "K19", referenceUnit: function() { return samm.units["metrePerSecondPascal"] }, conversionFactor: "4.420750 × 10⁻⁵ (m/s)/Pa", quantityKinds: [ "phaseVelocity", "velocity", "groupVelocity", "velocity", "phaseVelocity", "groupVelocity" ] },
        "footPerSecondSquared": { name: "footPerSecondSquared", label: "foot per second squared", symbol: "ft/s²", code: "A73", referenceUnit: function() { return samm.units["metrePerSecondSquared"] }, conversionFactor: "0.3048 m/s²", quantityKinds: [ "acceleration", "accelerationOfFreeFall", "accelerationDueToGravity", "acceleration", "instantaneousSoundParticleAcceleration", "accelerationOfFreeFall", "accelerationDueToGravity" ] },
        "footPerThousand": { name: "footPerThousand", label: "foot per thousand", symbol: null, code: "E33", referenceUnit: function() { return samm.units["metre"] }, conversionFactor: "3.048 × 10⁻⁴ m", quantityKinds: [ "thickness", "particlePositionVector", "cartesianCoordinates", "focalDistance", "radius", "radiusOfCurvature", "displacementVectorOfIonOrAtom", "lengthOfPath", "diameter", "comptonWavelength", "slowingDownLength", "migrationLength", "meanFreePath", "equilibriumPositionVectorOfIonOrAtom", "instantaneousSoundParticleDisplacement", "imageDistance", "breadth", "length", "halfValueThickness", "coherenceLength", "latticeVector", "londonPenetrationDepth", "diffusionLength", "meanFreePathOfPhononsOrElectrons", "diffusionCoefficientForNeutronFluxDensity", "halfThickness", "height", "electronRadius", "distance", "objectDistance", "bohrRadius", "diffusionCoefficientForNeutronFluenceRate", "nuclearRadius", "wavelength", "fundamentalLatticeVector", "meanLinearRange" ] },
        "footPoundForce": { name: "footPoundForce", label: "foot pound-force", symbol: "ft·lbf", code: "85", referenceUnit: function() { return samm.units["joule"] }, conversionFactor: "1.355818 J", quantityKinds: [ "work", "kineticEnergy", "potentialEnergy", "energy", "quantityOfHeat", "reactionEnergy", "workFunction", "activeEnergy", "kineticEnergy", "levelWidth", "meanEnergyImparted", "helmholtzFunction", "radiantEnergy", "potentialEnergy", "energy", "thermodynamicEnergy", "helmholtzFreeEnergy", "work", "heat", "hartreeEnergy", "energyImparted", "enthalpy", "alphaDisintegrationEnergy" ] },
        "footPoundForcePerHour": { name: "footPoundForcePerHour", label: "foot pound-force per hour", symbol: "ft·lbf/h", code: "K15", referenceUnit: function() { return samm.units["watt"] }, conversionFactor: "3.766161 × 10⁻⁴ W", quantityKinds: [ "radiantEnergyflux", "activePower", "heatFlowRate", "soundPower", "power", "radiantPower", "powerForDirectCurrent", "power" ] },
        "footPoundForcePerMinute": { name: "footPoundForcePerMinute", label: "foot pound-force per minute", symbol: "ft·lbf/min", code: "K16", referenceUnit: function() { return samm.units["watt"] }, conversionFactor: "2.259697 × 10⁻² W", quantityKinds: [ "radiantEnergyflux", "activePower", "heatFlowRate", "soundPower", "power", "radiantPower", "powerForDirectCurrent", "power" ] },
        "footPoundForcePerSecond": { name: "footPoundForcePerSecond", label: "foot pound-force per second", symbol: "ft·lbf/s", code: "A74", referenceUnit: function() { return samm.units["watt"] }, conversionFactor: "1.355818 W", quantityKinds: [ "power", "radiantEnergyflux", "activePower", "heatFlowRate", "soundPower", "power", "radiantPower", "powerForDirectCurrent" ] },
        "footPoundal": { name: "footPoundal", label: "foot poundal", symbol: "ft·pdl", code: "N46", referenceUnit: function() { return samm.units["joule"] }, conversionFactor: "4.214011 × 10⁻² J", quantityKinds: [ "quantityOfHeat", "reactionEnergy", "workFunction", "activeEnergy", "kineticEnergy", "levelWidth", "meanEnergyImparted", "helmholtzFunction", "radiantEnergy", "potentialEnergy", "energy", "thermodynamicEnergy", "helmholtzFreeEnergy", "work", "heat", "hartreeEnergy", "energyImparted", "enthalpy", "alphaDisintegrationEnergy", "energy", "kineticEnergy", "work", "potentialEnergy" ] },
        "footToTheFourthPower": { name: "footToTheFourthPower", label: "foot to the fourth power", symbol: "ft⁴", code: "N27", referenceUnit: function() { return samm.units["metreToTheFourthPower"] }, conversionFactor: "8.630975 × 10⁻³ m⁴", quantityKinds: [ "secondPolarMomentOfArea", "secondMomentOfArea", "secondAxialMomentOfArea" ] },
        "footUsSurvey": { name: "footUsSurvey", label: "foot (U.S. survey)", symbol: "ft (US survey)", code: "M51", referenceUnit: function() { return samm.units["metre"] }, conversionFactor: "3.048006 × 10⁻¹ m", quantityKinds: [ "thickness", "particlePositionVector", "cartesianCoordinates", "focalDistance", "radius", "radiusOfCurvature", "displacementVectorOfIonOrAtom", "lengthOfPath", "diameter", "comptonWavelength", "slowingDownLength", "migrationLength", "meanFreePath", "equilibriumPositionVectorOfIonOrAtom", "instantaneousSoundParticleDisplacement", "imageDistance", "breadth", "length", "halfValueThickness", "coherenceLength", "latticeVector", "londonPenetrationDepth", "diffusionLength", "meanFreePathOfPhononsOrElectrons", "diffusionCoefficientForNeutronFluxDensity", "halfThickness", "height", "electronRadius", "distance", "objectDistance", "bohrRadius", "diffusionCoefficientForNeutronFluenceRate", "nuclearRadius", "wavelength", "fundamentalLatticeVector", "meanLinearRange", "radiusOfCurvature", "lengthOfPath", "height", "radius", "breadth", "cartesianCoordinates", "thickness", "length", "diameter", "distance" ] },
        "footcandle": { name: "footcandle", label: "footcandle", symbol: "ftc", code: "P27", referenceUnit: null, conversionFactor: null, quantityKinds: [ "illuminance" ] },
        "footlambert": { name: "footlambert", label: "footlambert", symbol: "ftL", code: "P29", referenceUnit: function() { return samm.units["candelaPerSquareMetre"] }, conversionFactor: "3.426259 cd/m²", quantityKinds: [ "luminance", "luminance" ] },
        "fortyFootContainer": { name: "fortyFootContainer", label: "forty foot container", symbol: null, code: "21", referenceUnit: null, conversionFactor: null, quantityKinds: null },
        "franklin": { name: "franklin", label: "franklin", symbol: "Fr", code: "N94", referenceUnit: function() { return samm.units["coulomb"] }, conversionFactor: "3.335641 × 10⁻¹⁰ C", quantityKinds: [ "elementaryCharge", "electricFluxFluxOfDisplacement", "electricCharge", "quantityOfElectricity", "quantityOfElectricity", "electricFluxFluxOfDisplacement", "electricCharge" ] },
        "freightTon": { name: "freightTon", label: "freight ton", symbol: null, code: "A75", referenceUnit: null, conversionFactor: null, quantityKinds: null },
        "frenchGauge": { name: "frenchGauge", label: "French gauge", symbol: "Fg", code: "H79", referenceUnit: function() { return samm.units["metre"] }, conversionFactor: "0.333333333 × 10⁻³ m", quantityKinds: [ "thickness", "particlePositionVector", "cartesianCoordinates", "focalDistance", "radius", "radiusOfCurvature", "displacementVectorOfIonOrAtom", "lengthOfPath", "diameter", "comptonWavelength", "slowingDownLength", "migrationLength", "meanFreePath", "equilibriumPositionVectorOfIonOrAtom", "instantaneousSoundParticleDisplacement", "imageDistance", "breadth", "length", "halfValueThickness", "coherenceLength", "latticeVector", "londonPenetrationDepth", "diffusionLength", "meanFreePathOfPhononsOrElectrons", "diffusionCoefficientForNeutronFluxDensity", "halfThickness", "height", "electronRadius", "distance", "objectDistance", "bohrRadius", "diffusionCoefficientForNeutronFluenceRate", "nuclearRadius", "wavelength", "fundamentalLatticeVector", "meanLinearRange", "cartesianCoordinates", "diameter", "radius", "thickness", "breadth", "radiusOfCurvature", "height", "length", "distance", "lengthOfPath" ] },
        "furlong": { name: "furlong", label: "furlong", symbol: "fur", code: "M50", referenceUnit: function() { return samm.units["metre"] }, conversionFactor: "2.01168 × 10² m", quantityKinds: [ "cartesianCoordinates", "radius", "diameter", "height", "distance", "length", "thickness", "radiusOfCurvature", "breadth", "lengthOfPath", "thickness", "particlePositionVector", "cartesianCoordinates", "focalDistance", "radius", "radiusOfCurvature", "displacementVectorOfIonOrAtom", "lengthOfPath", "diameter", "comptonWavelength", "slowingDownLength", "migrationLength", "meanFreePath", "equilibriumPositionVectorOfIonOrAtom", "instantaneousSoundParticleDisplacement", "imageDistance", "breadth", "length", "halfValueThickness", "coherenceLength", "latticeVector", "londonPenetrationDepth", "diffusionLength", "meanFreePathOfPhononsOrElectrons", "diffusionCoefficientForNeutronFluxDensity", "halfThickness", "height", "electronRadius", "distance", "objectDistance", "bohrRadius", "diffusionCoefficientForNeutronFluenceRate", "nuclearRadius", "wavelength", "fundamentalLatticeVector", "meanLinearRange" ] },
        "gal": { name: "gal", label: "gal", symbol: "Gal", code: "A76", referenceUnit: function() { return samm.units["metrePerSecondSquared"] }, conversionFactor: "10⁻² m/s²", quantityKinds: [ "acceleration", "accelerationDueToGravity", "accelerationOfFreeFall", "acceleration", "instantaneousSoundParticleAcceleration", "accelerationOfFreeFall", "accelerationDueToGravity" ] },
        "gallonUk": { name: "gallonUk", label: "gallon (UK)", symbol: "gal (UK)", code: "GLI", referenceUnit: function() { return samm.units["cubicMetre"] }, conversionFactor: "4.546092 × 10⁻³ m³", quantityKinds: [ "volume", "sectionModulus", "volume" ] },
        "gallonUkPerDay": { name: "gallonUkPerDay", label: "gallon (UK) per day", symbol: "gal (UK)/d", code: "K26", referenceUnit: function() { return samm.units["cubicMetrePerSecond"] }, conversionFactor: "5.261678 × 10⁻⁸ m³/s", quantityKinds: [ "volumeFlowRate", "volumeFlowRate", "recombinationCoefficient", "instantaneousVolumeFlowRate" ] },
        "gallonUkPerHour": { name: "gallonUkPerHour", label: "gallon (UK) per hour", symbol: "gal (UK)/h", code: "K27", referenceUnit: function() { return samm.units["cubicMetrePerSecond"] }, conversionFactor: "1.262803 × 10⁻⁶ m³/s", quantityKinds: [ "volumeFlowRate", "recombinationCoefficient", "instantaneousVolumeFlowRate", "volumeFlowRate" ] },
        "gallonUkPerSecond": { name: "gallonUkPerSecond", label: "gallon (UK) per second", symbol: "gal (UK)/s", code: "K28", referenceUnit: function() { return samm.units["cubicMetrePerSecond"] }, conversionFactor: "4.54609 × 10⁻³ m³/s", quantityKinds: [ "volumeFlowRate", "volumeFlowRate", "recombinationCoefficient", "instantaneousVolumeFlowRate" ] },
        "gallonUs": { name: "gallonUs", label: "gallon (US)", symbol: "gal (US)", code: "GLL", referenceUnit: function() { return samm.units["cubicMetre"] }, conversionFactor: "3.785412 × 10⁻³ m³", quantityKinds: [ "volume", "sectionModulus", "volume" ] },
        "gallonUsLiquidPerSecond": { name: "gallonUsLiquidPerSecond", label: "gallon (US liquid) per second", symbol: "gal (US liq.)/s", code: "K30", referenceUnit: function() { return samm.units["cubicMetrePerSecond"] }, conversionFactor: "3.785412 × 10⁻³ m³/s", quantityKinds: [ "volumeFlowRate", "recombinationCoefficient", "instantaneousVolumeFlowRate", "volumeFlowRate" ] },
        "gallonUsPerDay": { name: "gallonUsPerDay", label: "gallon (US) per day", symbol: "gal (US)/d", code: "GB", referenceUnit: function() { return samm.units["cubicMetrePerSecond"] }, conversionFactor: "4.381264 × 10⁻⁸ m³/s", quantityKinds: [ "volumeFlowRate", "recombinationCoefficient", "instantaneousVolumeFlowRate" ] },
        "gallonUsPerHour": { name: "gallonUsPerHour", label: "gallon (US) per hour", symbol: "gal/h", code: "G50", referenceUnit: null, conversionFactor: null, quantityKinds: [ "volumeFlowRate" ] },
        "gamma": { name: "gamma", label: "gamma", symbol: "γ", code: "P12", referenceUnit: function() { return samm.units["tesla"] }, conversionFactor: "10⁻⁹ T", quantityKinds: [ "magneticFluxDensity", "magneticInduction", "magneticPolarization", "magneticFluxDensity", "magneticInduction", "lowerCriticalMagneticFluxDensity", "upperCriticalMagneticFluxDensity", "magneticPolarization", "thermodynamicCriticalMagneticFluxDensity" ] },
        "gibibit": { name: "gibibit", label: "gibibit", symbol: "Gibit", code: "B30", referenceUnit: null, conversionFactor: null, quantityKinds: null },
        "gibibitPerCubicMetre": { name: "gibibitPerCubicMetre", label: "gibibit per cubic metre", symbol: "Gibit/m³", code: "E71", referenceUnit: null, conversionFactor: null, quantityKinds: null },
        "gibibitPerMetre": { name: "gibibitPerMetre", label: "gibibit per metre", symbol: "Gibit/m", code: "E69", referenceUnit: null, conversionFactor: null, quantityKinds: null },
        "gibibitPerSquareMetre": { name: "gibibitPerSquareMetre", label: "gibibit per square metre", symbol: "Gibit/m²", code: "E70", referenceUnit: null, conversionFactor: null, quantityKinds: null },
        "gibibyte": { name: "gibibyte", label: "Gibibyte", symbol: "GiB", code: "E62", referenceUnit: function() { return samm.units["byte"] }, conversionFactor: "2³⁰ B", quantityKinds: [ "informationEntropy", "informationEntropy" ] },
        "gigaabyte": { name: "gigaabyte", label: "Gigabyte", symbol: "Gbyte", code: "E34", referenceUnit: function() { return samm.units["byte"] }, conversionFactor: "10⁹ B", quantityKinds: [ "informationEntropy", "informationEntropy" ] },
        "gigabecquerel": { name: "gigabecquerel", label: "gigabecquerel", symbol: "GBq", code: "GBQ", referenceUnit: function() { return samm.units["becquerel"] }, conversionFactor: "10⁹ Bq", quantityKinds: [ "activity", "activity" ] },
        "gigabit": { name: "gigabit", label: "gigabit", symbol: "Gbit", code: "B68", referenceUnit: null, conversionFactor: null, quantityKinds: null },
        "gigabitPerSecond": { name: "gigabitPerSecond", label: "gigabit per second", symbol: "Gbit/s", code: "B80", referenceUnit: null, conversionFactor: null, quantityKinds: null },
        "gigabytePerSecond": { name: "gigabytePerSecond", label: "gigabyte per second", symbol: "Gbyte/s", code: "E68", referenceUnit: null, conversionFactor: null, quantityKinds: null },
        "gigacoulombPerCubicMetre": { name: "gigacoulombPerCubicMetre", label: "gigacoulomb per cubic metre", symbol: "GC/m³", code: "A84", referenceUnit: function() { return samm.units["coulombPerCubicMetre"] }, conversionFactor: "10⁹ C/m³", quantityKinds: [ "volumicCharge", "volumeDensityOfCharge", "chargeDensity", "volumeDensityOfCharge", "volumicCharge", "chargeDensity" ] },
        "gigaelectronvolt": { name: "gigaelectronvolt", label: "gigaelectronvolt", symbol: "GeV", code: "A85", referenceUnit: function() { return samm.units["electronvolt"] }, conversionFactor: "10⁹ eV", quantityKinds: [ "work", "energy", "potentialEnergy", "kineticEnergy", "maximumBetaParticleEnergy", "fermiEnergy", "potentialEnergy", "work", "kineticEnergy", "resonanceEnergy", "betaDisintegrationEnergy", "energy" ] },
        "gigahertz": { name: "gigahertz", label: "gigahertz", symbol: "GHz", code: "A86", referenceUnit: function() { return samm.units["hertz"] }, conversionFactor: "10⁹ Hz", quantityKinds: [ "frequency", "frequency" ] },
        "gigahertzMetre": { name: "gigahertzMetre", label: "gigahertz metre", symbol: "GHz·m", code: "M18", referenceUnit: function() { return samm.units["hertzMetre"] }, conversionFactor: "10⁹ Hz × m", quantityKinds: [ "coefficient", "performanceCharacteristic", "performanceCharacteristic", "coefficient" ] },
        "gigajoule": { name: "gigajoule", label: "gigajoule", symbol: "GJ", code: "GV", referenceUnit: function() { return samm.units["joule"] }, conversionFactor: "10⁹ J", quantityKinds: [ "kineticEnergy", "potentialEnergy", "energy", "work", "quantityOfHeat", "reactionEnergy", "workFunction", "activeEnergy", "kineticEnergy", "levelWidth", "meanEnergyImparted", "helmholtzFunction", "radiantEnergy", "potentialEnergy", "energy", "thermodynamicEnergy", "helmholtzFreeEnergy", "work", "heat", "hartreeEnergy", "energyImparted", "enthalpy", "alphaDisintegrationEnergy" ] },
        "gigaohm": { name: "gigaohm", label: "gigaohm", symbol: "GΩ", code: "A87", referenceUnit: function() { return samm.units["ohm"] }, conversionFactor: "10⁹ Ω", quantityKinds: [ "resistanceToAlternatingCurrent", "modulusOfImpedance", "reactance", "impedance", "resistanceToDirectCurrent", "complexImpedances", "impedance", "reactance", "modulusOfImpedance", "resistanceToDirectCurrent", "complexImpedances", "resistanceToAlternatingCurrent" ] },
        "gigaohmMetre": { name: "gigaohmMetre", label: "gigaohm metre", symbol: "GΩ·m", code: "A88", referenceUnit: function() { return samm.units["ohmMetre"] }, conversionFactor: "10⁹ Ω × m", quantityKinds: [ "resistivity", "residualResistivity", "resistivity" ] },
        "gigaohmPerMetre": { name: "gigaohmPerMetre", label: "gigaohm per metre", symbol: "GΩ/m", code: "M26", referenceUnit: function() { return samm.units["ohmPerMetre"] }, conversionFactor: "10⁹ Ω/m", quantityKinds: [ "lineicResistance", "resistanceLoadPerUnitLength" ] },
        "gigapascal": { name: "gigapascal", label: "gigapascal", symbol: "GPa", code: "A89", referenceUnit: function() { return samm.units["pascal"] }, conversionFactor: "10⁹ Pa", quantityKinds: [ "modulusOfElasticity", "modulusOfRigidity", "modulusOfCompression", "bulkModulus", "normalStress", "shearStress", "pressure", "shearModulus", "fugacityOfBInAGaseousMixture", "pressure", "shearModulus", "staticPressure", "normalStress", "modulusOfRigidity", "instantaneousSoundPressure", "modulusOfElasticity", "shearStress", "modulusOfCompression", "partialPressureOfBInAGaseousMixture", "bulkModulus", "osmoticPressure" ] },
        "gigawatt": { name: "gigawatt", label: "gigawatt", symbol: "GW", code: "A90", referenceUnit: function() { return samm.units["watt"] }, conversionFactor: "10⁹ W", quantityKinds: [ "activePower", "powerForDirectCurrent", "power", "radiantEnergyflux", "activePower", "heatFlowRate", "soundPower", "power", "radiantPower", "powerForDirectCurrent" ] },
        "gigawattHour": { name: "gigawattHour", label: "gigawatt hour", symbol: "GW·h", code: "GWH", referenceUnit: function() { return samm.units["joule"] }, conversionFactor: "3.6 × 10¹² J", quantityKinds: [ "quantityOfHeat", "reactionEnergy", "workFunction", "activeEnergy", "kineticEnergy", "levelWidth", "meanEnergyImparted", "helmholtzFunction", "radiantEnergy", "potentialEnergy", "energy", "thermodynamicEnergy", "helmholtzFreeEnergy", "work", "heat", "hartreeEnergy", "energyImparted", "enthalpy", "alphaDisintegrationEnergy", "energy", "work", "potentialEnergy", "kineticEnergy" ] },
        "gilbert": { name: "gilbert", label: "gilbert", symbol: "Gi", code: "N97", referenceUnit: function() { return samm.units["ampere"] }, conversionFactor: "7.957747 × 10⁻¹ A", quantityKinds: [ "magnetomotiveForce", "currentLinkage", "magneticPotentialDifference", "electricCurrent", "magnetomotiveForce", "currentLinkage", "magneticPotentialDifference", "electricCurrent" ] },
        "gillUk": { name: "gillUk", label: "gill (UK)", symbol: "gi (UK)", code: "GII", referenceUnit: function() { return samm.units["cubicMetre"] }, conversionFactor: "1.420653 × 10⁻⁴ m³", quantityKinds: [ "volume", "sectionModulus" ] },
        "gillUkPerDay": { name: "gillUkPerDay", label: "gill (UK) per day", symbol: "gi (UK)/d", code: "K32", referenceUnit: function() { return samm.units["cubicMetrePerSecond"] }, conversionFactor: "1.644274 × 10⁻⁵ m³/s", quantityKinds: [ "volumeFlowRate", "recombinationCoefficient", "instantaneousVolumeFlowRate", "volumeFlowRate" ] },
        "gillUkPerHour": { name: "gillUkPerHour", label: "gill (UK) per hour", symbol: "gi (UK)/h", code: "K33", referenceUnit: function() { return samm.units["cubicMetrePerSecond"] }, conversionFactor: "3.946258 × 10⁻⁸ m³/s", quantityKinds: [ "volumeFlowRate", "recombinationCoefficient", "instantaneousVolumeFlowRate", "volumeFlowRate" ] },
        "gillUkPerMinute": { name: "gillUkPerMinute", label: "gill (UK) per minute", symbol: "gi (UK)/min", code: "K34", referenceUnit: function() { return samm.units["cubicMetrePerSecond"] }, conversionFactor: "0.02367755 m³/s", quantityKinds: [ "volumeFlowRate", "recombinationCoefficient", "instantaneousVolumeFlowRate", "volumeFlowRate" ] },
        "gillUkPerSecond": { name: "gillUkPerSecond", label: "gill (UK) per second", symbol: "gi (UK)/s", code: "K35", referenceUnit: function() { return samm.units["cubicMetrePerSecond"] }, conversionFactor: "1.420653 × 10⁻⁴ m³/s", quantityKinds: [ "volumeFlowRate", "volumeFlowRate", "recombinationCoefficient", "instantaneousVolumeFlowRate" ] },
        "gillUs": { name: "gillUs", label: "gill (US)", symbol: "gi (US)", code: "GIA", referenceUnit: function() { return samm.units["cubicMetre"] }, conversionFactor: "1.182941 × 10⁻⁴ m³", quantityKinds: [ "volume", "sectionModulus" ] },
        "gillUsPerDay": { name: "gillUsPerDay", label: "gill (US) per day", symbol: "gi (US)/d", code: "K36", referenceUnit: function() { return samm.units["cubicMetrePerSecond"] }, conversionFactor: "1.369145 × 10⁻⁹ m³/s", quantityKinds: [ "volumeFlowRate", "recombinationCoefficient", "instantaneousVolumeFlowRate", "volumeFlowRate" ] },
        "gillUsPerHour": { name: "gillUsPerHour", label: "gill (US) per hour", symbol: "gi (US)/h", code: "K37", referenceUnit: function() { return samm.units["cubicMetrePerSecond"] }, conversionFactor: "3.285947 × 10⁻⁸ m³/s", quantityKinds: [ "volumeFlowRate", "recombinationCoefficient", "instantaneousVolumeFlowRate", "volumeFlowRate" ] },
        "gillUsPerMinute": { name: "gillUsPerMinute", label: "gill (US) per minute", symbol: "gi (US)/min", code: "K38", referenceUnit: function() { return samm.units["cubicMetrePerSecond"] }, conversionFactor: "1.971568 × 10⁻⁶ m³/s", quantityKinds: [ "volumeFlowRate", "recombinationCoefficient", "instantaneousVolumeFlowRate", "volumeFlowRate" ] },
        "gillUsPerSecond": { name: "gillUsPerSecond", label: "gill (US) per second", symbol: "gi (US)/s", code: "K39", referenceUnit: function() { return samm.units["cubicMetrePerSecond"] }, conversionFactor: "1.182941 × 10⁻⁴ m³/s", quantityKinds: [ "volumeFlowRate", "recombinationCoefficient", "instantaneousVolumeFlowRate", "volumeFlowRate" ] },
        "gon": { name: "gon", label: "gon", symbol: "gon", code: "A91", referenceUnit: function() { return samm.units["rad"] }, conversionFactor: "1.570796 × 10⁻² rad", quantityKinds: [ "absorbedDose", "anglePlane" ] },
        "grain": { name: "grain", label: "grain", symbol: "gr", code: "GRN", referenceUnit: function() { return samm.units["kilogram"] }, conversionFactor: "64.79891 × 10⁻⁶ kg", quantityKinds: [ "massOfAtomOfANuclideX", "massOfMolecule", "effectiveMass", "mass", "nuclidicMass", "massExcess", "mass" ] },
        "grainPerGallonUs": { name: "grainPerGallonUs", label: "grain per gallon (US)", symbol: "gr/gal (US)", code: "K41", referenceUnit: function() { return samm.units["kilogramPerCubicMetre"] }, conversionFactor: "1.711806 × 10⁻² kg/m³", quantityKinds: [ "density", "volumicMass", "massDensity", "amountOfSubstance", "massDensity", "density", "concentrationOfB", "massConcentrationOfB", "volumicMass" ] },
        "gram": { name: "gram", label: "gram", symbol: "g", code: "GRM", referenceUnit: function() { return samm.units["kilogram"] }, conversionFactor: "10⁻³ kg", quantityKinds: [ "massOfAtomOfANuclideX", "massOfMolecule", "effectiveMass", "mass", "nuclidicMass", "massExcess", "mass" ] },
        "gramCentimetrePerSecond": { name: "gramCentimetrePerSecond", label: "gram centimetre per second", symbol: "g·(cm/s)", code: "M99", referenceUnit: function() { return samm.units["kilogramMetrePerSecond"] }, conversionFactor: "10⁻⁵ kg × m/s", quantityKinds: [ "momentum", "momentum" ] },
        "gramDryWeight": { name: "gramDryWeight", label: "gram, dry weight", symbol: null, code: "GDW", referenceUnit: null, conversionFactor: null, quantityKinds: null },
        "gramForcePerSquareCentimetre": { name: "gramForcePerSquareCentimetre", label: "gram-force per square centimetre", symbol: "gf/cm²", code: "K31", referenceUnit: function() { return samm.units["pascal"] }, conversionFactor: "98.0665 Pa", quantityKinds: [ "fugacityOfBInAGaseousMixture", "pressure", "shearModulus", "staticPressure", "normalStress", "modulusOfRigidity", "instantaneousSoundPressure", "modulusOfElasticity", "shearStress", "modulusOfCompression", "partialPressureOfBInAGaseousMixture", "bulkModulus", "osmoticPressure", "shearStress", "modulusOfElasticity", "bulkModulus", "modulusOfRigidity", "pressure", "shearModulus", "normalStress", "modulusOfCompression" ] },
        "gramIncludingContainer": { name: "gramIncludingContainer", label: "gram, including container", symbol: null, code: "GIC", referenceUnit: null, conversionFactor: null, quantityKinds: null },
        "gramIncludingInnerPackaging": { name: "gramIncludingInnerPackaging", label: "gram, including inner packaging", symbol: null, code: "GIP", referenceUnit: null, conversionFactor: null, quantityKinds: null },
        "gramMillimetre": { name: "gramMillimetre", label: "gram millimetre", symbol: "g·mm", code: "H84", referenceUnit: function() { return samm.units["kilogramMetre"] }, conversionFactor: "10⁻⁶ kg × m", quantityKinds: [ "breadth", "distance", "diameter", "lengthOfPath", "radiusOfCurvature", "cartesianCoordinates", "thickness", "height", "length", "radius", "torque", "momentOfForce", "momentOfACouple" ] },
        "gramOfFissileIsotope": { name: "gramOfFissileIsotope", label: "gram of fissile isotope", symbol: "gi F/S", code: "GFI", referenceUnit: null, conversionFactor: null, quantityKinds: null },
        "gramPerBar": { name: "gramPerBar", label: "gram per bar", symbol: "g/bar", code: "F74", referenceUnit: null, conversionFactor: null, quantityKinds: [ "volumicMass", "massDensity", "density" ] },
        "gramPerCentimetreSecond": { name: "gramPerCentimetreSecond", label: "gram per centimetre second", symbol: "g/(cm·s)", code: "N41", referenceUnit: function() { return samm.units["pascalSecond"] }, conversionFactor: "0.1 Pa × s", quantityKinds: [ "viscosityDynamicViscosity", "viscosityDynamicViscosity" ] },
        "gramPerCubicCentimetre": { name: "gramPerCubicCentimetre", label: "gram per cubic centimetre", symbol: "g/cm³", code: "23", referenceUnit: function() { return samm.units["kilogramPerCubicMetre"] }, conversionFactor: "10³ kg/m³", quantityKinds: [ "amountOfSubstance", "massDensity", "density", "concentrationOfB", "massConcentrationOfB", "volumicMass", "density", "volumicMass", "massDensity" ] },
        "gramPerCubicCentimetreBar": { name: "gramPerCubicCentimetreBar", label: "gram per cubic centimetre bar", symbol: "g/(cm³·bar)", code: "G11", referenceUnit: null, conversionFactor: null, quantityKinds: [ "volumicMass", "massDensity", "density" ] },
        "gramPerCubicCentimetreKelvin": { name: "gramPerCubicCentimetreKelvin", label: "gram per cubic centimetre kelvin", symbol: "g/(cm³·K)", code: "G33", referenceUnit: null, conversionFactor: null, quantityKinds: [ "volumicMass", "massDensity", "density" ] },
        "gramPerCubicDecimetre": { name: "gramPerCubicDecimetre", label: "gram per cubic decimetre", symbol: "g/dm³", code: "F23", referenceUnit: null, conversionFactor: null, quantityKinds: [ "volumicMass", "massDensity", "density" ] },
        "gramPerCubicDecimetreBar": { name: "gramPerCubicDecimetreBar", label: "gram per cubic decimetre bar", symbol: "g/(dm³·bar)", code: "G12", referenceUnit: null, conversionFactor: null, quantityKinds: [ "volumicMass", "massDensity", "density" ] },
        "gramPerCubicDecimetreKelvin": { name: "gramPerCubicDecimetreKelvin", label: "gram per cubic decimetre kelvin", symbol: "g/(dm³·K)", code: "G34", referenceUnit: null, conversionFactor: null, quantityKinds: [ "volumicMass", "massDensity", "density" ] },
        "gramPerCubicMetre": { name: "gramPerCubicMetre", label: "gram per cubic metre", symbol: "g/m³", code: "A93", referenceUnit: function() { return samm.units["kilogramPerCubicMetre"] }, conversionFactor: "10⁻³ kg/m³", quantityKinds: [ "amountOfSubstance", "massDensity", "density", "concentrationOfB", "massConcentrationOfB", "volumicMass", "density", "massDensity", "volumicMass" ] },
        "gramPerCubicMetreBar": { name: "gramPerCubicMetreBar", label: "gram per cubic metre bar", symbol: "g/(m³·bar)", code: "G14", referenceUnit: null, conversionFactor: null, quantityKinds: [ "volumicMass", "massDensity", "density" ] },
        "gramPerCubicMetreKelvin": { name: "gramPerCubicMetreKelvin", label: "gram per cubic metre kelvin", symbol: "g/(m³·K)", code: "G36", referenceUnit: null, conversionFactor: null, quantityKinds: [ "volumicMass", "massDensity", "density" ] },
        "gramPerDay": { name: "gramPerDay", label: "gram per day", symbol: "g/d", code: "F26", referenceUnit: null, conversionFactor: null, quantityKinds: [ "massFlowRate" ] },
        "gramPerDayBar": { name: "gramPerDayBar", label: "gram per day bar", symbol: "g/(d·bar)", code: "F62", referenceUnit: null, conversionFactor: null, quantityKinds: [ "massFlowRate" ] },
        "gramPerDayKelvin": { name: "gramPerDayKelvin", label: "gram per day kelvin", symbol: "g/(d·K)", code: "F35", referenceUnit: null, conversionFactor: null, quantityKinds: [ "massFlowRate" ] },
        "gramPerHertz": { name: "gramPerHertz", label: "gram per hertz", symbol: "g/Hz", code: "F25", referenceUnit: null, conversionFactor: null, quantityKinds: [ "massFlowRate" ] },
        "gramPerHour": { name: "gramPerHour", label: "gram per hour", symbol: "g/h", code: "F27", referenceUnit: null, conversionFactor: null, quantityKinds: [ "massFlowRate" ] },
        "gramPerHourBar": { name: "gramPerHourBar", label: "gram per hour bar", symbol: "g/(h·bar)", code: "F63", referenceUnit: null, conversionFactor: null, quantityKinds: [ "massFlowRate" ] },
        "gramPerHourKelvin": { name: "gramPerHourKelvin", label: "gram per hour kelvin", symbol: "g/(h·K)", code: "F36", referenceUnit: null, conversionFactor: null, quantityKinds: [ "massFlowRate" ] },
        "gramPerKelvin": { name: "gramPerKelvin", label: "gram per kelvin", symbol: "g/K", code: "F14", referenceUnit: null, conversionFactor: null, quantityKinds: [ "volumicMass", "massDensity", "density" ] },
        "gramPerLitre": { name: "gramPerLitre", label: "gram per litre", symbol: "g/l", code: "GL", referenceUnit: function() { return samm.units["kilogramPerCubicMetre"] }, conversionFactor: "kg/m³", quantityKinds: [ "amountOfSubstance", "massDensity", "density", "concentrationOfB", "massConcentrationOfB", "volumicMass", "volumicMass", "density", "massDensity" ] },
        "gramPerLitreBar": { name: "gramPerLitreBar", label: "gram per litre bar", symbol: "g/(l·bar)", code: "G13", referenceUnit: null, conversionFactor: null, quantityKinds: [ "volumicMass", "massDensity", "density" ] },
        "gramPerLitreKelvin": { name: "gramPerLitreKelvin", label: "gram per litre kelvin", symbol: "g/(l·K)", code: "G35", referenceUnit: null, conversionFactor: null, quantityKinds: [ "volumicMass", "massDensity", "density" ] },
        "gramPerMetreGramPer100Centimetres": { name: "gramPerMetreGramPer100Centimetres", label: "gram per metre (gram per 100 centimetres)", symbol: "g/m", code: "GF", referenceUnit: function() { return samm.units["kilogramPerMetre"] }, conversionFactor: "10⁻³ kg/m", quantityKinds: [ "linearMass", "linearDensity", "linearDensity", "linearMass" ] },
        "gramPerMillilitre": { name: "gramPerMillilitre", label: "gram per millilitre", symbol: "g/ml", code: "GJ", referenceUnit: function() { return samm.units["kilogramPerCubicMetre"] }, conversionFactor: "10³ kg/m³", quantityKinds: [ "massDensity", "volumicMass", "density", "amountOfSubstance", "massDensity", "density", "concentrationOfB", "massConcentrationOfB", "volumicMass" ] },
        "gramPerMillilitreBar": { name: "gramPerMillilitreBar", label: "gram per millilitre bar", symbol: "g/(ml·bar)", code: "G15", referenceUnit: null, conversionFactor: null, quantityKinds: [ "volumicMass", "massDensity", "density" ] },
        "gramPerMillilitreKelvin": { name: "gramPerMillilitreKelvin", label: "gram per millilitre kelvin", symbol: "g/(ml·K)", code: "G37", referenceUnit: null, conversionFactor: null, quantityKinds: [ "volumicMass", "massDensity", "density" ] },
        "gramPerMillimetre": { name: "gramPerMillimetre", label: "gram per millimetre", symbol: "g/mm", code: "H76", referenceUnit: null, conversionFactor: null, quantityKinds: [ "linearMass", "linearDensity" ] },
        "gramPerMinute": { name: "gramPerMinute", label: "gram per minute", symbol: "g/min", code: "F28", referenceUnit: null, conversionFactor: null, quantityKinds: [ "massFlowRate" ] },
        "gramPerMinuteBar": { name: "gramPerMinuteBar", label: "gram per minute bar", symbol: "g/(min·bar)", code: "F64", referenceUnit: null, conversionFactor: null, quantityKinds: [ "massFlowRate" ] },
        "gramPerMinuteKelvin": { name: "gramPerMinuteKelvin", label: "gram per minute kelvin", symbol: "g/(min·K)", code: "F37", referenceUnit: null, conversionFactor: null, quantityKinds: [ "massFlowRate" ] },
        "gramPerMole": { name: "gramPerMole", label: "gram per mole", symbol: "g/mol", code: "A94", referenceUnit: function() { return samm.units["kilogramPerMole"] }, conversionFactor: "10⁻³ kg/mol", quantityKinds: [ "molarMass", "molarMass" ] },
        "gramPerSecond": { name: "gramPerSecond", label: "gram per second", symbol: "g/s", code: "F29", referenceUnit: null, conversionFactor: null, quantityKinds: [ "massFlowRate" ] },
        "gramPerSecondBar": { name: "gramPerSecondBar", label: "gram per second bar", symbol: "g/(s·bar)", code: "F65", referenceUnit: null, conversionFactor: null, quantityKinds: [ "massFlowRate" ] },
        "gramPerSecondKelvin": { name: "gramPerSecondKelvin", label: "gram per second kelvin", symbol: "g/(s·K)", code: "F38", referenceUnit: null, conversionFactor: null, quantityKinds: [ "massFlowRate" ] },
        "gramPerSquareCentimetre": { name: "gramPerSquareCentimetre", label: "gram per square centimetre", symbol: "g/cm²", code: "25", referenceUnit: function() { return samm.units["kilogramPerSquareMetre"] }, conversionFactor: "10 kg/m²", quantityKinds: [ "areicMass", "surfaceDensity", "surfaceDensity", "meanMassRange", "areicMass" ] },
        "gramPerSquareMetre": { name: "gramPerSquareMetre", label: "gram per square metre", symbol: "g/m²", code: "GM", referenceUnit: function() { return samm.units["kilogramPerSquareMetre"] }, conversionFactor: "10⁻³ kg/m²", quantityKinds: [ "surfaceDensity", "areicMass", "surfaceDensity", "meanMassRange", "areicMass" ] },
        "gramPerSquareMillimetre": { name: "gramPerSquareMillimetre", label: "gram per square millimetre", symbol: "g/mm²", code: "N24", referenceUnit: function() { return samm.units["kilogramPerSquareMetre"] }, conversionFactor: "10³ kg/m²", quantityKinds: [ "modulusOfElasticity", "pressure", "modulusOfRigidity", "shearStress", "modulusOfCompression", "shearModulus", "normalStress", "bulkModulus", "surfaceDensity", "meanMassRange", "areicMass" ] },
        "gray": { name: "gray", label: "gray", symbol: "Gy", code: "A95", referenceUnit: null, conversionFactor: null, quantityKinds: [ "specificEnergyImparted", "massicEnergyImparted" ] },
        "grayPerHour": { name: "grayPerHour", label: "gray per hour", symbol: "Gy/h", code: "P61", referenceUnit: function() { return samm.units["grayPerSecond"] }, conversionFactor: "2.77778 × 10⁻⁴ Gy/s", quantityKinds: [ "absorbedDoseRate", "absorbedDoseRate" ] },
        "grayPerMinute": { name: "grayPerMinute", label: "gray per minute", symbol: "Gy/min", code: "P57", referenceUnit: function() { return samm.units["grayPerSecond"] }, conversionFactor: "1.66667 × 10⁻² Gy/s", quantityKinds: [ "absorbedDoseRate", "absorbedDoseRate" ] },
        "grayPerSecond": { name: "grayPerSecond", label: "gray per second", symbol: "Gy/s", code: "A96", referenceUnit: null, conversionFactor: null, quantityKinds: [ "absorbedDoseRate" ] },
        "greatGross": { name: "greatGross", label: "great gross", symbol: null, code: "GGR", referenceUnit: null, conversionFactor: null, quantityKinds: null },
        "gross": { name: "gross", label: "gross", symbol: "gr", code: "GRO", referenceUnit: null, conversionFactor: null, quantityKinds: null },
        "grossKilogram": { name: "grossKilogram", label: "gross kilogram", symbol: null, code: "E4", referenceUnit: null, conversionFactor: null, quantityKinds: null },
        "group": { name: "group", label: "group", symbol: null, code: "10", referenceUnit: null, conversionFactor: null, quantityKinds: null },
        "guntersChain": { name: "guntersChain", label: "Gunter's chain", symbol: "ch (UK)", code: "X1", referenceUnit: function() { return samm.units["metre"] }, conversionFactor: "20.1168 m", quantityKinds: [ "thickness", "particlePositionVector", "cartesianCoordinates", "focalDistance", "radius", "radiusOfCurvature", "displacementVectorOfIonOrAtom", "lengthOfPath", "diameter", "comptonWavelength", "slowingDownLength", "migrationLength", "meanFreePath", "equilibriumPositionVectorOfIonOrAtom", "instantaneousSoundParticleDisplacement", "imageDistance", "breadth", "length", "halfValueThickness", "coherenceLength", "latticeVector", "londonPenetrationDepth", "diffusionLength", "meanFreePathOfPhononsOrElectrons", "diffusionCoefficientForNeutronFluxDensity", "halfThickness", "height", "electronRadius", "distance", "objectDistance", "bohrRadius", "diffusionCoefficientForNeutronFluenceRate", "nuclearRadius", "wavelength", "fundamentalLatticeVector", "meanLinearRange", "radius", "distance", "diameter", "radiusOfCurvature", "cartesianCoordinates", "height", "thickness", "breadth", "length", "lengthOfPath" ] },
        "halfYear6Months": { name: "halfYear6Months", label: "half year (6 months)", symbol: null, code: "SAN", referenceUnit: null, conversionFactor: null, quantityKinds: null },
        "hangingContainer": { name: "hangingContainer", label: "hanging container", symbol: null, code: "Z11", referenceUnit: null, conversionFactor: null, quantityKinds: null },
        "hank": { name: "hank", label: "hank", symbol: null, code: "HA", referenceUnit: null, conversionFactor: null, quantityKinds: null },
        "hartley": { name: "hartley", label: "hartley", symbol: "Hart", code: "Q15", referenceUnit: null, conversionFactor: null, quantityKinds: null },
        "hartleyPerSecond": { name: "hartleyPerSecond", label: "hartley per second", symbol: "Hart/s", code: "Q18", referenceUnit: null, conversionFactor: null, quantityKinds: null },
        "head": { name: "head", label: "head", symbol: null, code: "HEA", referenceUnit: null, conversionFactor: null, quantityKinds: null },
        "hectobar": { name: "hectobar", label: "hectobar", symbol: "hbar", code: "HBA", referenceUnit: function() { return samm.units["pascal"] }, conversionFactor: "10⁷ Pa", quantityKinds: [ "fugacityOfBInAGaseousMixture", "pressure", "shearModulus", "staticPressure", "normalStress", "modulusOfRigidity", "instantaneousSoundPressure", "modulusOfElasticity", "shearStress", "modulusOfCompression", "partialPressureOfBInAGaseousMixture", "bulkModulus", "osmoticPressure", "pressure", "normalStress", "modulusOfRigidity", "modulusOfElasticity", "shearStress", "modulusOfCompression", "shearModulus", "bulkModulus" ] },
        "hectogram": { name: "hectogram", label: "hectogram", symbol: "hg", code: "HGM", referenceUnit: function() { return samm.units["kilogram"] }, conversionFactor: "10⁻¹ kg", quantityKinds: [ "massOfAtomOfANuclideX", "massOfMolecule", "effectiveMass", "mass", "nuclidicMass", "massExcess", "mass" ] },
        "hectolitre": { name: "hectolitre", label: "hectolitre", symbol: "hl", code: "HLT", referenceUnit: function() { return samm.units["cubicMetre"] }, conversionFactor: "10⁻¹ m³", quantityKinds: [ "volume", "volume", "sectionModulus" ] },
        "hectolitreOfPureAlcohol": { name: "hectolitreOfPureAlcohol", label: "hectolitre of pure alcohol", symbol: null, code: "HPA", referenceUnit: null, conversionFactor: null, quantityKinds: null },
        "hectometre": { name: "hectometre", label: "hectometre", symbol: "hm", code: "HMT", referenceUnit: function() { return samm.units["metre"] }, conversionFactor: "10² m", quantityKinds: [ "thickness", "particlePositionVector", "cartesianCoordinates", "focalDistance", "radius", "radiusOfCurvature", "displacementVectorOfIonOrAtom", "lengthOfPath", "diameter", "comptonWavelength", "slowingDownLength", "migrationLength", "meanFreePath", "equilibriumPositionVectorOfIonOrAtom", "instantaneousSoundParticleDisplacement", "imageDistance", "breadth", "length", "halfValueThickness", "coherenceLength", "latticeVector", "londonPenetrationDepth", "diffusionLength", "meanFreePathOfPhononsOrElectrons", "diffusionCoefficientForNeutronFluxDensity", "halfThickness", "height", "electronRadius", "distance", "objectDistance", "bohrRadius", "diffusionCoefficientForNeutronFluenceRate", "nuclearRadius", "wavelength", "fundamentalLatticeVector", "meanLinearRange", "height", "lengthOfPath", "thickness", "breadth", "diameter", "radius", "radiusOfCurvature", "distance", "cartesianCoordinates", "length" ] },
        "hectopascal": { name: "hectopascal", label: "hectopascal", symbol: "hPa", code: "A97", referenceUnit: function() { return samm.units["pascal"] }, conversionFactor: "10² Pa", quantityKinds: [ "fugacityOfBInAGaseousMixture", "pressure", "shearModulus", "staticPressure", "normalStress", "modulusOfRigidity", "instantaneousSoundPressure", "modulusOfElasticity", "shearStress", "modulusOfCompression", "partialPressureOfBInAGaseousMixture", "bulkModulus", "osmoticPressure", "modulusOfRigidity", "shearStress", "shearModulus", "normalStress", "modulusOfElasticity", "modulusOfCompression", "pressure", "bulkModulus" ] },
        "hectopascalCubicMetrePerSecond": { name: "hectopascalCubicMetrePerSecond", label: "hectopascal cubic metre per second", symbol: "hPa·m³/s", code: "F94", referenceUnit: null, conversionFactor: null, quantityKinds: [ "shearStress", "modulusOfRigidity", "normalStress", "pressure", "shearModulus", "modulusOfCompression", "modulusOfElasticity", "bulkModulus" ] },
        "hectopascalLitrePerSecond": { name: "hectopascalLitrePerSecond", label: "hectopascal litre per second", symbol: "hPa·l/s", code: "F93", referenceUnit: null, conversionFactor: null, quantityKinds: [ "shearStress", "shearModulus", "bulkModulus", "pressure", "modulusOfElasticity", "normalStress", "modulusOfCompression", "modulusOfRigidity" ] },
        "hectopascalPerBar": { name: "hectopascalPerBar", label: "hectopascal per bar", symbol: "hPa/bar", code: "E99", referenceUnit: null, conversionFactor: null, quantityKinds: [ "pressureRatio" ] },
        "hectopascalPerKelvin": { name: "hectopascalPerKelvin", label: "hectopascal per kelvin", symbol: "hPa/K", code: "F82", referenceUnit: null, conversionFactor: null, quantityKinds: [ "bulkModulus", "normalStress", "pressure", "modulusOfCompression", "modulusOfRigidity", "shearModulus", "shearStress", "modulusOfElasticity" ] },
        "hectopascalPerMetre": { name: "hectopascalPerMetre", label: "hectopascal per metre", symbol: "hPa/m", code: "P82", referenceUnit: null, conversionFactor: null, quantityKinds: [ "hardnessIndex" ] },
        "hefnerKerze": { name: "hefnerKerze", label: "Hefner-Kerze", symbol: "HK", code: "P35", referenceUnit: function() { return samm.units["candela"] }, conversionFactor: "0.903 cd", quantityKinds: [ "luminousIntensity", "luminousIntensity" ] },
        "henry": { name: "henry", label: "henry", symbol: "H", code: "81", referenceUnit: null, conversionFactor: null, quantityKinds: [ "selfInductance", "permeance", "mutualInductance" ] },
        "henryPerKiloohm": { name: "henryPerKiloohm", label: "henry per kiloohm", symbol: "H/kΩ", code: "H03", referenceUnit: function() { return samm.units["secondUnitOfTime"] }, conversionFactor: "10⁻³ s", quantityKinds: [ "timeConstant", "reactorTimeConstant", "halfLife", "meanLife", "time", "relaxationTime", "period", "carrierLifeTime", "periodicTime", "reverberationTime", "selfInductance", "permeance", "mutualInductance" ] },
        "henryPerMetre": { name: "henryPerMetre", label: "henry per metre", symbol: "H/m", code: "A98", referenceUnit: null, conversionFactor: null, quantityKinds: [ "permeabilityOfVacuum", "permeability", "magneticConstant" ] },
        "henryPerOhm": { name: "henryPerOhm", label: "henry per ohm", symbol: "H/Ω", code: "H04", referenceUnit: function() { return samm.units["secondUnitOfTime"] }, conversionFactor: "s", quantityKinds: [ "timeConstant", "reactorTimeConstant", "halfLife", "meanLife", "time", "relaxationTime", "period", "carrierLifeTime", "periodicTime", "reverberationTime", "mutualInductance", "selfInductance", "permeance" ] },
        "hertz": { name: "hertz", label: "hertz", symbol: "Hz", code: "HTZ", referenceUnit: null, conversionFactor: null, quantityKinds: [ "frequency" ] },
        "hertzMetre": { name: "hertzMetre", label: "hertz metre", symbol: "Hz·m", code: "H34", referenceUnit: null, conversionFactor: null, quantityKinds: [ "performanceCharacteristic", "coefficient" ] },
        "horsepowerBoiler": { name: "horsepowerBoiler", label: "horsepower (boiler)", symbol: "boiler hp", code: "K42", referenceUnit: function() { return samm.units["watt"] }, conversionFactor: "9.80950 × 10³ W", quantityKinds: [ "power", "radiantEnergyflux", "activePower", "heatFlowRate", "soundPower", "power", "radiantPower", "powerForDirectCurrent" ] },
        "horsepowerElectric": { name: "horsepowerElectric", label: "horsepower (electric)", symbol: "electric hp", code: "K43", referenceUnit: function() { return samm.units["watt"] }, conversionFactor: "746 W", quantityKinds: [ "powerForDirectCurrent", "activePower", "radiantEnergyflux", "activePower", "heatFlowRate", "soundPower", "power", "radiantPower", "powerForDirectCurrent" ] },
        "hour": { name: "hour", label: "hour", symbol: "h", code: "HUR", referenceUnit: function() { return samm.units["secondUnitOfTime"] }, conversionFactor: "3600 s", quantityKinds: [ "timeConstant", "reactorTimeConstant", "halfLife", "meanLife", "time", "relaxationTime", "period", "carrierLifeTime", "periodicTime", "reverberationTime", "time" ] },
        "hundred": { name: "hundred", label: "hundred", symbol: null, code: "CEN", referenceUnit: null, conversionFactor: null, quantityKinds: null },
        "hundredBoardFoot": { name: "hundredBoardFoot", label: "hundred board foot", symbol: null, code: "BP", referenceUnit: null, conversionFactor: null, quantityKinds: null },
        "hundredBoxes": { name: "hundredBoxes", label: "hundred boxes", symbol: null, code: "HBX", referenceUnit: null, conversionFactor: null, quantityKinds: null },
        "hundredCount": { name: "hundredCount", label: "hundred count", symbol: null, code: "HC", referenceUnit: null, conversionFactor: null, quantityKinds: null },
        "hundredCubicFoot": { name: "hundredCubicFoot", label: "hundred cubic foot", symbol: null, code: "HH", referenceUnit: null, conversionFactor: null, quantityKinds: null },
        "hundredCubicMetre": { name: "hundredCubicMetre", label: "hundred cubic metre", symbol: null, code: "FF", referenceUnit: null, conversionFactor: null, quantityKinds: null },
        "hundredInternationalUnit": { name: "hundredInternationalUnit", label: "hundred international unit", symbol: null, code: "HIU", referenceUnit: null, conversionFactor: null, quantityKinds: null },
        "hundredKilogramDryWeight": { name: "hundredKilogramDryWeight", label: "hundred kilogram, dry weight", symbol: null, code: "HDW", referenceUnit: null, conversionFactor: null, quantityKinds: null },
        "hundredKilogramNetMass": { name: "hundredKilogramNetMass", label: "hundred kilogram, net mass", symbol: null, code: "HKM", referenceUnit: null, conversionFactor: null, quantityKinds: null },
        "hundredLeave": { name: "hundredLeave", label: "hundred leave", symbol: null, code: "CLF", referenceUnit: null, conversionFactor: null, quantityKinds: null },
        "hundredMetre": { name: "hundredMetre", label: "hundred metre", symbol: null, code: "JPS", referenceUnit: null, conversionFactor: null, quantityKinds: null },
        "hundredPack": { name: "hundredPack", label: "hundred pack", symbol: null, code: "CNP", referenceUnit: null, conversionFactor: null, quantityKinds: null },
        "hundredPoundCwtOrHundredWeightUs": { name: "hundredPoundCwtOrHundredWeightUs", label: "hundred pound (cwt) / hundred weight (US)", symbol: "cwt (US)", code: "CWA", referenceUnit: function() { return samm.units["kilogram"] }, conversionFactor: "45.3592 kg", quantityKinds: [ "massOfAtomOfANuclideX", "massOfMolecule", "effectiveMass", "mass", "nuclidicMass", "massExcess", "mass" ] },
        "hundredWeightUk": { name: "hundredWeightUk", label: "hundred weight (UK)", symbol: "cwt (UK)", code: "CWI", referenceUnit: function() { return samm.units["kilogram"] }, conversionFactor: "50.80235 kg", quantityKinds: [ "mass", "massOfAtomOfANuclideX", "massOfMolecule", "effectiveMass", "mass", "nuclidicMass", "massExcess" ] },
        "hydraulicHorsePower": { name: "hydraulicHorsePower", label: "hydraulic horse power", symbol: null, code: "5J", referenceUnit: null, conversionFactor: null, quantityKinds: null },
        "imperialGallonPerMinute": { name: "imperialGallonPerMinute", label: "Imperial gallon per minute", symbol: "gal (UK) /min", code: "G3", referenceUnit: function() { return samm.units["cubicMetrePerSecond"] }, conversionFactor: "7.57682 × 10⁻⁵ m³/s", quantityKinds: [ "volumeFlowRate", "recombinationCoefficient", "instantaneousVolumeFlowRate", "volumeFlowRate" ] },
        "inch": { name: "inch", label: "inch", symbol: "in", code: "INH", referenceUnit: function() { return samm.units["metre"] }, conversionFactor: "25.4 × 10⁻³ m", quantityKinds: [ "thickness", "particlePositionVector", "cartesianCoordinates", "focalDistance", "radius", "radiusOfCurvature", "displacementVectorOfIonOrAtom", "lengthOfPath", "diameter", "comptonWavelength", "slowingDownLength", "migrationLength", "meanFreePath", "equilibriumPositionVectorOfIonOrAtom", "instantaneousSoundParticleDisplacement", "imageDistance", "breadth", "length", "halfValueThickness", "coherenceLength", "latticeVector", "londonPenetrationDepth", "diffusionLength", "meanFreePathOfPhononsOrElectrons", "diffusionCoefficientForNeutronFluxDensity", "halfThickness", "height", "electronRadius", "distance", "objectDistance", "bohrRadius", "diffusionCoefficientForNeutronFluenceRate", "nuclearRadius", "wavelength", "fundamentalLatticeVector", "meanLinearRange", "cartesianCoordinates", "length", "thickness", "diameter", "lengthOfPath", "height", "breadth", "radius", "radiusOfCurvature", "distance" ] },
        "inchOfMercury": { name: "inchOfMercury", label: "inch of mercury", symbol: "inHg", code: "F79", referenceUnit: null, conversionFactor: null, quantityKinds: [ "shearModulus", "modulusOfElasticity", "modulusOfRigidity", "modulusOfCompression", "bulkModulus", "normalStress", "shearStress", "pressure" ] },
        "inchOfMercury32Degreesf": { name: "inchOfMercury32Degreesf", label: "inch of mercury (32 °F)", symbol: "inHG (32 °F)", code: "N16", referenceUnit: function() { return samm.units["pascal"] }, conversionFactor: "3.38638 × 10³ Pa", quantityKinds: [ "modulusOfCompression", "normalStress", "shearModulus", "pressure", "bulkModulus", "modulusOfElasticity", "modulusOfRigidity", "shearStress", "fugacityOfBInAGaseousMixture", "pressure", "shearModulus", "staticPressure", "normalStress", "modulusOfRigidity", "instantaneousSoundPressure", "modulusOfElasticity", "shearStress", "modulusOfCompression", "partialPressureOfBInAGaseousMixture", "bulkModulus", "osmoticPressure" ] },
        "inchOfMercury60Degreesf": { name: "inchOfMercury60Degreesf", label: "inch of mercury (60 °F)", symbol: "inHg (60 °F)", code: "N17", referenceUnit: function() { return samm.units["pascal"] }, conversionFactor: "3.37685 × 10³ Pa", quantityKinds: [ "normalStress", "bulkModulus", "modulusOfCompression", "pressure", "modulusOfRigidity", "modulusOfElasticity", "shearModulus", "shearStress", "fugacityOfBInAGaseousMixture", "pressure", "shearModulus", "staticPressure", "normalStress", "modulusOfRigidity", "instantaneousSoundPressure", "modulusOfElasticity", "shearStress", "modulusOfCompression", "partialPressureOfBInAGaseousMixture", "bulkModulus", "osmoticPressure" ] },
        "inchOfWater": { name: "inchOfWater", label: "inch of water", symbol: "inH₂O", code: "F78", referenceUnit: null, conversionFactor: null, quantityKinds: [ "modulusOfRigidity", "shearStress", "modulusOfCompression", "pressure", "modulusOfElasticity", "normalStress", "bulkModulus", "shearModulus" ] },
        "inchOfWater392Degreesf": { name: "inchOfWater392Degreesf", label: "inch of water (39.2 °F)", symbol: "inH₂O (39,2 °F)", code: "N18", referenceUnit: function() { return samm.units["pascal"] }, conversionFactor: "2.49082 × 10² Pa", quantityKinds: [ "fugacityOfBInAGaseousMixture", "pressure", "shearModulus", "staticPressure", "normalStress", "modulusOfRigidity", "instantaneousSoundPressure", "modulusOfElasticity", "shearStress", "modulusOfCompression", "partialPressureOfBInAGaseousMixture", "bulkModulus", "osmoticPressure", "modulusOfCompression", "modulusOfRigidity", "modulusOfElasticity", "pressure", "shearModulus", "normalStress", "shearStress", "bulkModulus" ] },
        "inchOfWater60Degreesf": { name: "inchOfWater60Degreesf", label: "inch of water (60 °F)", symbol: "inH₂O (60 °F)", code: "N19", referenceUnit: function() { return samm.units["pascal"] }, conversionFactor: "2.4884 × 10² Pa", quantityKinds: [ "fugacityOfBInAGaseousMixture", "pressure", "shearModulus", "staticPressure", "normalStress", "modulusOfRigidity", "instantaneousSoundPressure", "modulusOfElasticity", "shearStress", "modulusOfCompression", "partialPressureOfBInAGaseousMixture", "bulkModulus", "osmoticPressure", "bulkModulus", "modulusOfElasticity", "modulusOfRigidity", "shearStress", "modulusOfCompression", "normalStress", "shearModulus", "pressure" ] },
        "inchPerDegreeFahrenheit": { name: "inchPerDegreeFahrenheit", label: "inch per degree Fahrenheit", symbol: "in/°F", code: "K45", referenceUnit: function() { return samm.units["metrePerKelvin"] }, conversionFactor: "4.572 × 10⁻² m/K", quantityKinds: [ "breadth", "radius", "cartesianCoordinates", "distance", "lengthOfPath", "diameter", "length", "height", "thickness", "radiusOfCurvature", "thickness", "length", "lengthOfPath", "distance", "radius", "diameter", "breadth", "cartesianCoordinates", "radiusOfCurvature", "height" ] },
        "inchPerLinearFoot": { name: "inchPerLinearFoot", label: "inch per linear foot", symbol: null, code: "B82", referenceUnit: null, conversionFactor: null, quantityKinds: null },
        "inchPerMinute": { name: "inchPerMinute", label: "inch per minute", symbol: "in/min", code: "M63", referenceUnit: function() { return samm.units["metrePerSecond"] }, conversionFactor: "4.233333 × 10⁻⁴ m/s", quantityKinds: [ "groupVelocity", "velocityOfSoundPhaseVelocity", "phaseVelocity", "neutronSpeed", "phaseSpeedOfElectromagneticWaves", "velocity", "velocitySpeedOnPropagationOfElectromagneticWavesInVacuo", "instantaneousSoundParticleVelocity", "phaseVelocityOfElectromagneticWaves", "groupVelocity", "velocity", "phaseVelocity" ] },
        "inchPerPsi": { name: "inchPerPsi", label: "inch per psi", symbol: "in/psi", code: "K46", referenceUnit: function() { return samm.units["metrePerPascal"] }, conversionFactor: "3.683959 × 10⁻⁶ m/Pa", quantityKinds: [ "cartesianCoordinates", "radius", "lengthOfPath", "diameter", "radiusOfCurvature", "height", "length", "breadth", "distance", "thickness", "radius", "diameter", "cartesianCoordinates", "length", "thickness", "radiusOfCurvature", "height", "distance", "breadth", "lengthOfPath" ] },
        "inchPerSecond": { name: "inchPerSecond", label: "inch per second", symbol: "in/s", code: "IU", referenceUnit: function() { return samm.units["metrePerSecond"] }, conversionFactor: "0.0254 m/s", quantityKinds: [ "groupVelocity", "velocityOfSoundPhaseVelocity", "phaseVelocity", "neutronSpeed", "phaseSpeedOfElectromagneticWaves", "velocity", "velocitySpeedOnPropagationOfElectromagneticWavesInVacuo", "instantaneousSoundParticleVelocity", "phaseVelocityOfElectromagneticWaves", "phaseVelocity", "velocity", "groupVelocity" ] },
        "inchPerSecondDegreeFahrenheit": { name: "inchPerSecondDegreeFahrenheit", label: "inch per second degree Fahrenheit", symbol: "(in/s)/°F", code: "K47", referenceUnit: function() { return samm.units["metrePerSecondKelvin"] }, conversionFactor: "4.572 × 10⁻² (m/s)/K", quantityKinds: [ "velocity", "groupVelocity", "phaseVelocity", "velocity", "phaseVelocity", "groupVelocity" ] },
        "inchPerSecondPsi": { name: "inchPerSecondPsi", label: "inch per second psi", symbol: "(in/s)/psi", code: "K48", referenceUnit: function() { return samm.units["metrePerSecondPascal"] }, conversionFactor: "3.683959 × 10⁻⁶ (m/s)/Pa", quantityKinds: [ "groupVelocity", "phaseVelocity", "velocity", "velocity", "phaseVelocity", "groupVelocity" ] },
        "inchPerSecondSquared": { name: "inchPerSecondSquared", label: "inch per second squared", symbol: "in/s²", code: "IV", referenceUnit: function() { return samm.units["metrePerSecondSquared"] }, conversionFactor: "0.0254 m/s²", quantityKinds: [ "accelerationOfFreeFall", "acceleration", "accelerationDueToGravity", "acceleration", "instantaneousSoundParticleAcceleration", "accelerationOfFreeFall", "accelerationDueToGravity" ] },
        "inchPerTwoPiRadiant": { name: "inchPerTwoPiRadiant", label: "inch per two pi radiant", symbol: "in/revolution", code: "H57", referenceUnit: null, conversionFactor: null, quantityKinds: [ "solidAngle" ] },
        "inchPerYear": { name: "inchPerYear", label: "inch per year", symbol: "in/y", code: "M61", referenceUnit: function() { return samm.units["metrePerSecond"] }, conversionFactor: "8.048774 × 10⁻¹⁰ m/s", quantityKinds: [ "velocity", "phaseVelocity", "groupVelocity", "groupVelocity", "velocityOfSoundPhaseVelocity", "phaseVelocity", "neutronSpeed", "phaseSpeedOfElectromagneticWaves", "velocity", "velocitySpeedOnPropagationOfElectromagneticWavesInVacuo", "instantaneousSoundParticleVelocity", "phaseVelocityOfElectromagneticWaves" ] },
        "inchPoundPoundInch": { name: "inchPoundPoundInch", label: "inch pound (pound inch)", symbol: "in·lb", code: "IA", referenceUnit: function() { return samm.units["kilogramMetre"] }, conversionFactor: "1.15212 × 10⁻² kg × m", quantityKinds: [ "momentOfACouple", "momentOfForce", "torque", "torque", "momentOfForce", "momentOfACouple" ] },
        "inchPoundal": { name: "inchPoundal", label: "inch poundal", symbol: "in·pdl", code: "N47", referenceUnit: function() { return samm.units["joule"] }, conversionFactor: "3.511677 × 10⁻³ J", quantityKinds: [ "potentialEnergy", "work", "kineticEnergy", "energy", "quantityOfHeat", "reactionEnergy", "workFunction", "activeEnergy", "kineticEnergy", "levelWidth", "meanEnergyImparted", "helmholtzFunction", "radiantEnergy", "potentialEnergy", "energy", "thermodynamicEnergy", "helmholtzFreeEnergy", "work", "heat", "hartreeEnergy", "energyImparted", "enthalpy", "alphaDisintegrationEnergy" ] },
        "inchToTheFourthPower": { name: "inchToTheFourthPower", label: "inch to the fourth power", symbol: "in⁴", code: "D69", referenceUnit: function() { return samm.units["metreToTheFourthPower"] }, conversionFactor: "41.62314 × 10⁻⁸ m⁴", quantityKinds: [ "secondPolarMomentOfArea", "secondMomentOfArea", "secondAxialMomentOfArea" ] },
        "internationalCandle": { name: "internationalCandle", label: "international candle", symbol: "IK", code: "P36", referenceUnit: function() { return samm.units["candela"] }, conversionFactor: "1.019 cd", quantityKinds: [ "luminousIntensity", "luminousIntensity" ] },
        "internationalSugarDegree": { name: "internationalSugarDegree", label: "international sugar degree", symbol: null, code: "ISD", referenceUnit: null, conversionFactor: null, quantityKinds: null },
        "job": { name: "job", label: "job", symbol: null, code: "E51", referenceUnit: null, conversionFactor: null, quantityKinds: null },
        "joule": { name: "joule", label: "joule", symbol: "J", code: "JOU", referenceUnit: null, conversionFactor: null, quantityKinds: [ "quantityOfHeat", "reactionEnergy", "workFunction", "activeEnergy", "kineticEnergy", "levelWidth", "meanEnergyImparted", "helmholtzFunction", "radiantEnergy", "potentialEnergy", "energy", "thermodynamicEnergy", "helmholtzFreeEnergy", "work", "heat", "hartreeEnergy", "energyImparted", "enthalpy", "alphaDisintegrationEnergy" ] },
        "joulePerCubicMetre": { name: "joulePerCubicMetre", label: "joule per cubic metre", symbol: "J/m³", code: "B8", referenceUnit: null, conversionFactor: null, quantityKinds: [ "soundEnergy", "volumic", "volumicElectromagneticEnergy", "soundEnergyDensity", "radiantEnergyDensity", "electromagneticEnergyDensity" ] },
        "joulePerDay": { name: "joulePerDay", label: "joule per day", symbol: "J/d", code: "P17", referenceUnit: function() { return samm.units["watt"] }, conversionFactor: "1.15741 × 10⁻⁵ W", quantityKinds: [ "activePower", "powerForDirectCurrent", "radiantEnergyflux", "activePower", "heatFlowRate", "soundPower", "power", "radiantPower", "powerForDirectCurrent" ] },
        "joulePerGram": { name: "joulePerGram", label: "joule per gram", symbol: "J/g", code: "D95", referenceUnit: null, conversionFactor: null, quantityKinds: [ "massicThermodynamicEnergy" ] },
        "joulePerHour": { name: "joulePerHour", label: "joule per hour", symbol: "J/h", code: "P16", referenceUnit: function() { return samm.units["watt"] }, conversionFactor: "2.77778 × 10⁻⁴ W", quantityKinds: [ "activePower", "powerForDirectCurrent", "radiantEnergyflux", "activePower", "heatFlowRate", "soundPower", "power", "radiantPower", "powerForDirectCurrent" ] },
        "joulePerKelvin": { name: "joulePerKelvin", label: "joule per kelvin", symbol: "J/K", code: "JE", referenceUnit: null, conversionFactor: null, quantityKinds: [ "planckFunction", "heatCapacity", "massieuFunction", "boltzmannConstant", "entropy" ] },
        "joulePerKilogram": { name: "joulePerKilogram", label: "joule per kilogram", symbol: "J/kg", code: "J2", referenceUnit: null, conversionFactor: null, quantityKinds: [ "specificEnergy", "massicEnergy" ] },
        "joulePerKilogramKelvin": { name: "joulePerKilogramKelvin", label: "joule per kilogram kelvin", symbol: "J/(kg·K)", code: "B11", referenceUnit: null, conversionFactor: null, quantityKinds: [ "specificHeatCapacityAtSaturation", "specificHeatCapacityAtConstantVolume", "specificHeatCapacityAtConstantPressure" ] },
        "joulePerMetre": { name: "joulePerMetre", label: "joule per metre", symbol: "J/m", code: "B12", referenceUnit: null, conversionFactor: null, quantityKinds: [ "totalLinearStoppingPower", "linearEnergyTransfer" ] },
        "joulePerMetreToTheFourthPower": { name: "joulePerMetreToTheFourthPower", label: "joule per metre to the fourth power", symbol: "J/m⁴", code: "B14", referenceUnit: null, conversionFactor: null, quantityKinds: [ "spectralRadiantEnergyDensityInTermsOfWaveLength", "spectralConcentrationOfRadiantEnergyDensityInTermsOfWavelength" ] },
        "joulePerMinute": { name: "joulePerMinute", label: "joule per minute", symbol: "J/min", code: "P15", referenceUnit: function() { return samm.units["watt"] }, conversionFactor: "1.66667 × 10⁻² W", quantityKinds: [ "radiantEnergyflux", "activePower", "heatFlowRate", "soundPower", "power", "radiantPower", "powerForDirectCurrent", "powerForDirectCurrent", "activePower" ] },
        "joulePerMole": { name: "joulePerMole", label: "joule per mole", symbol: "J/mol", code: "B15", referenceUnit: null, conversionFactor: null, quantityKinds: [ "molarThermodynamicEnergy", "chemicalPotential", "affinityOfAChemicalReaction" ] },
        "joulePerMoleKelvin": { name: "joulePerMoleKelvin", label: "joule per mole kelvin", symbol: "J/(mol·K)", code: "B16", referenceUnit: null, conversionFactor: null, quantityKinds: [ "molarHeatCapacity", "molarGasConstant", "molarEntropy" ] },
        "joulePerSecond": { name: "joulePerSecond", label: "joule per second", symbol: "J/s", code: "P14", referenceUnit: function() { return samm.units["watt"] }, conversionFactor: "W", quantityKinds: [ "activePower", "powerForDirectCurrent", "radiantEnergyflux", "activePower", "heatFlowRate", "soundPower", "power", "radiantPower", "powerForDirectCurrent" ] },
        "joulePerSquareCentimetre": { name: "joulePerSquareCentimetre", label: "joule per square centimetre", symbol: "J/cm²", code: "E43", referenceUnit: function() { return samm.units["joulePerSquareMetre"] }, conversionFactor: "10⁴ J/m²", quantityKinds: [ "radiantEnergyFluence", "radianceExposure", "energyFluence", "radianceExposure", "radiantEnergyFluence" ] },
        "joulePerSquareMetre": { name: "joulePerSquareMetre", label: "joule per square metre", symbol: "J/m²", code: "B13", referenceUnit: null, conversionFactor: null, quantityKinds: [ "radiantEnergyFluence", "radianceExposure", "energyFluence" ] },
        "joulePerTesla": { name: "joulePerTesla", label: "joule per tesla", symbol: "J/T", code: "Q10", referenceUnit: null, conversionFactor: null, quantityKinds: null },
        "jouleSecond": { name: "jouleSecond", label: "joule second", symbol: "J·s", code: "B18", referenceUnit: null, conversionFactor: null, quantityKinds: [ "planckConstant" ] },
        "jouleSquareMetre": { name: "jouleSquareMetre", label: "joule square metre", symbol: "J·m²", code: "D73", referenceUnit: null, conversionFactor: null, quantityKinds: [ "totalAtomicStoppingPower" ] },
        "jouleSquareMetrePerKilogram": { name: "jouleSquareMetrePerKilogram", label: "joule square metre per kilogram", symbol: "J·m²/kg", code: "B20", referenceUnit: null, conversionFactor: null, quantityKinds: [ "totalMassStoppingPower" ] },
        "katal": { name: "katal", label: "katal", symbol: "kat", code: "KAT", referenceUnit: null, conversionFactor: null, quantityKinds: [ "catalyticActivity" ] },
        "kelvin": { name: "kelvin", label: "kelvin", symbol: "K", code: "KEL", referenceUnit: null, conversionFactor: null, quantityKinds: [ "neelTemperature", "thermodynamic", "superConductorTransitionTemperature", "debyeTemperature", "fermiTemperature", "curieTemperature" ] },
        "kelvinMetrePerWatt": { name: "kelvinMetrePerWatt", label: "kelvin metre per watt", symbol: "K·m/W", code: "H35", referenceUnit: null, conversionFactor: null, quantityKinds: [ "thermalResistance" ] },
        "kelvinPerBar": { name: "kelvinPerBar", label: "kelvin per bar", symbol: "K/bar", code: "F61", referenceUnit: null, conversionFactor: null, quantityKinds: [ "temperature" ] },
        "kelvinPerHour": { name: "kelvinPerHour", label: "kelvin per hour", symbol: "K/h", code: "F10", referenceUnit: null, conversionFactor: null, quantityKinds: [ "temperature" ] },
        "kelvinPerKelvin": { name: "kelvinPerKelvin", label: "kelvin per kelvin", symbol: "K/K", code: "F02", referenceUnit: null, conversionFactor: null, quantityKinds: [ "temperature" ] },
        "kelvinPerMinute": { name: "kelvinPerMinute", label: "kelvin per minute", symbol: "K/min", code: "F11", referenceUnit: null, conversionFactor: null, quantityKinds: [ "temperature" ] },
        "kelvinPerPascal": { name: "kelvinPerPascal", label: "kelvin per pascal", symbol: "K/Pa", code: "N79", referenceUnit: null, conversionFactor: null, quantityKinds: [ "temperature" ] },
        "kelvinPerSecond": { name: "kelvinPerSecond", label: "kelvin per second", symbol: "K/s", code: "F12", referenceUnit: null, conversionFactor: null, quantityKinds: [ "temperature" ] },
        "kelvinPerWatt": { name: "kelvinPerWatt", label: "kelvin per watt", symbol: "K/W", code: "B21", referenceUnit: null, conversionFactor: null, quantityKinds: [ "thermalResistance" ] },
        "kibibit": { name: "kibibit", label: "kibibit", symbol: "Kibit", code: "C21", referenceUnit: null, conversionFactor: null, quantityKinds: null },
        "kibibitPerCubicMetre": { name: "kibibitPerCubicMetre", label: "kibibit per cubic metre", symbol: "Kibit/m³", code: "E74", referenceUnit: null, conversionFactor: null, quantityKinds: null },
        "kibibitPerMetre": { name: "kibibitPerMetre", label: "kibibit per metre", symbol: "Kibit/m", code: "E72", referenceUnit: null, conversionFactor: null, quantityKinds: null },
        "kibibitPerSquareMetre": { name: "kibibitPerSquareMetre", label: "kibibit per square metre", symbol: "Kibit/m²", code: "E73", referenceUnit: null, conversionFactor: null, quantityKinds: null },
        "kibibyte": { name: "kibibyte", label: "kibibyte", symbol: "Kibyte", code: "E64", referenceUnit: function() { return samm.units["byte"] }, conversionFactor: "2¹⁰ B", quantityKinds: [ "informationEntropy", "informationEntropy" ] },
        "kiloampere": { name: "kiloampere", label: "kiloampere", symbol: "kA", code: "B22", referenceUnit: function() { return samm.units["ampere"] }, conversionFactor: "10³ A", quantityKinds: [ "magnetomotiveForce", "currentLinkage", "magneticPotentialDifference", "electricCurrent", "magnetomotiveForce", "currentLinkage", "electricCurrent", "magneticPotentialDifference" ] },
        "kiloampereHourThousandAmpereHour": { name: "kiloampereHourThousandAmpereHour", label: "kiloampere hour (thousand ampere hour)", symbol: "kA·h", code: "TAH", referenceUnit: function() { return samm.units["coulomb"] }, conversionFactor: "3.6 × 10⁶ C", quantityKinds: [ "elementaryCharge", "electricFluxFluxOfDisplacement", "electricCharge", "quantityOfElectricity", "electricFluxFluxOfDisplacement", "electricCharge", "quantityOfElectricity" ] },
        "kiloamperePerMetre": { name: "kiloamperePerMetre", label: "kiloampere per metre", symbol: "kA/m", code: "B24", referenceUnit: function() { return samm.units["amperePerMetre"] }, conversionFactor: "10³ A/m", quantityKinds: [ "lineicElectricCurrent", "magneticFieldStrength", "magnetization", "linearElectricCurrentDensity", "linearElectricCurrentDensity", "magneticFieldStrength", "lineicElectricCurrent" ] },
        "kiloamperePerSquareMetre": { name: "kiloamperePerSquareMetre", label: "kiloampere per square metre", symbol: "kA/m²", code: "B23", referenceUnit: function() { return samm.units["amperePerSquareMetre"] }, conversionFactor: "10³ A/m²", quantityKinds: [ "currentDensity", "currentDensity" ] },
        "kilobar": { name: "kilobar", label: "kilobar", symbol: "kbar", code: "KBA", referenceUnit: function() { return samm.units["pascal"] }, conversionFactor: "10⁸ Pa", quantityKinds: [ "modulusOfElasticity", "normalStress", "shearModulus", "pressure", "modulusOfRigidity", "shearStress", "bulkModulus", "modulusOfCompression", "fugacityOfBInAGaseousMixture", "pressure", "shearModulus", "staticPressure", "normalStress", "modulusOfRigidity", "instantaneousSoundPressure", "modulusOfElasticity", "shearStress", "modulusOfCompression", "partialPressureOfBInAGaseousMixture", "bulkModulus", "osmoticPressure" ] },
        "kilobaud": { name: "kilobaud", label: "kilobaud", symbol: "kBd", code: "K50", referenceUnit: function() { return samm.units["baud"] }, conversionFactor: "10³ Bd", quantityKinds: null },
        "kilobecquerel": { name: "kilobecquerel", label: "kilobecquerel", symbol: "kBq", code: "2Q", referenceUnit: function() { return samm.units["becquerel"] }, conversionFactor: "10³ Bq", quantityKinds: [ "activity", "activity" ] },
        "kilobecquerelPerKilogram": { name: "kilobecquerelPerKilogram", label: "kilobecquerel per kilogram", symbol: "kBq/kg", code: "B25", referenceUnit: function() { return samm.units["becquerelPerKilogram"] }, conversionFactor: "10³ Bq/kg", quantityKinds: [ "specificActivityInASample", "specificActivityInASample" ] },
        "kilobit": { name: "kilobit", label: "kilobit", symbol: "kbit", code: "C37", referenceUnit: null, conversionFactor: null, quantityKinds: null },
        "kilobitPerSecond": { name: "kilobitPerSecond", label: "kilobit per second", symbol: "kbit/s", code: "C74", referenceUnit: function() { return samm.units["bitPerSecond"] }, conversionFactor: "10³ bit/s", quantityKinds: null },
        "kilobyte": { name: "kilobyte", label: "Kilobyte", symbol: "kbyte", code: "2P", referenceUnit: function() { return samm.units["byte"] }, conversionFactor: "10³ B", quantityKinds: [ "informationEntropy", "informationEntropy" ] },
        "kilobytePerSecond": { name: "kilobytePerSecond", label: "kilobyte per second", symbol: "kbyte/s", code: "P94", referenceUnit: function() { return samm.units["bytePerSecond"] }, conversionFactor: "10³ byte/s", quantityKinds: null },
        "kilocalorieInternationalTable": { name: "kilocalorieInternationalTable", label: "kilocalorie (international table)", symbol: "kcalIT", code: "E14", referenceUnit: function() { return samm.units["joule"] }, conversionFactor: "4.1868 × 10³ J", quantityKinds: [ "energy", "thermodynamicEnergy", "quantityOfHeat", "helmholtzFreeEnergy", "helmholtzFunction", "heat", "enthalpy", "quantityOfHeat", "reactionEnergy", "workFunction", "activeEnergy", "kineticEnergy", "levelWidth", "meanEnergyImparted", "helmholtzFunction", "radiantEnergy", "potentialEnergy", "energy", "thermodynamicEnergy", "helmholtzFreeEnergy", "work", "heat", "hartreeEnergy", "energyImparted", "enthalpy", "alphaDisintegrationEnergy" ] },
        "kilocalorieInternationalTablePerGramKelvin": { name: "kilocalorieInternationalTablePerGramKelvin", label: "kilocalorie (international table) per gram kelvin", symbol: "(kcalIT/K)/g", code: "N65", referenceUnit: function() { return samm.units["joulePerKilogramKelvin"] }, conversionFactor: "4.1868 × 10⁶ J/(kg × K)", quantityKinds: [ "entropy", "heatCapacity", "specificHeatCapacityAtSaturation", "specificHeatCapacityAtConstantVolume", "specificHeatCapacityAtConstantPressure" ] },
        "kilocalorieInternationalTablePerHourMetreDegreeCelsius": { name: "kilocalorieInternationalTablePerHourMetreDegreeCelsius", label: "kilocalorie (international table) per hour metre degree Celsius", symbol: "kcal/(m·h·°C)", code: "K52", referenceUnit: null, conversionFactor: null, quantityKinds: [ "thermalConductivity" ] },
        "kilocalorieMean": { name: "kilocalorieMean", label: "kilocalorie (mean)", symbol: "kcal", code: "K51", referenceUnit: function() { return samm.units["joule"] }, conversionFactor: "4.19002 × 10³ J", quantityKinds: [ "quantityOfHeat", "reactionEnergy", "workFunction", "activeEnergy", "kineticEnergy", "levelWidth", "meanEnergyImparted", "helmholtzFunction", "radiantEnergy", "potentialEnergy", "energy", "thermodynamicEnergy", "helmholtzFreeEnergy", "work", "heat", "hartreeEnergy", "energyImparted", "enthalpy", "alphaDisintegrationEnergy", "thermodynamicEnergy", "heat", "enthalpy", "quantityOfHeat", "energy", "helmholtzFunction", "helmholtzFreeEnergy" ] },
        "kilocalorieThermochemical": { name: "kilocalorieThermochemical", label: "kilocalorie (thermochemical)", symbol: "kcalth", code: "K53", referenceUnit: function() { return samm.units["joule"] }, conversionFactor: "4.184 × 10³ J", quantityKinds: [ "quantityOfHeat", "reactionEnergy", "workFunction", "activeEnergy", "kineticEnergy", "levelWidth", "meanEnergyImparted", "helmholtzFunction", "radiantEnergy", "potentialEnergy", "energy", "thermodynamicEnergy", "helmholtzFreeEnergy", "work", "heat", "hartreeEnergy", "energyImparted", "enthalpy", "alphaDisintegrationEnergy", "helmholtzFunction", "quantityOfHeat", "thermodynamicEnergy", "enthalpy", "energy", "helmholtzFreeEnergy", "heat" ] },
        "kilocalorieThermochemicalPerHour": { name: "kilocalorieThermochemicalPerHour", label: "kilocalorie (thermochemical) per hour", symbol: "kcalth/h", code: "E15", referenceUnit: function() { return samm.units["watt"] }, conversionFactor: "1.16222 W", quantityKinds: [ "heatFlowRate", "radiantEnergyflux", "activePower", "heatFlowRate", "soundPower", "power", "radiantPower", "powerForDirectCurrent" ] },
        "kilocalorieThermochemicalPerMinute": { name: "kilocalorieThermochemicalPerMinute", label: "kilocalorie (thermochemical) per minute", symbol: "kcalth/min", code: "K54", referenceUnit: function() { return samm.units["watt"] }, conversionFactor: "69.73333 W", quantityKinds: [ "heatFlowRate", "radiantEnergyflux", "activePower", "heatFlowRate", "soundPower", "power", "radiantPower", "powerForDirectCurrent" ] },
        "kilocalorieThermochemicalPerSecond": { name: "kilocalorieThermochemicalPerSecond", label: "kilocalorie (thermochemical) per second", symbol: "kcalth/s", code: "K55", referenceUnit: function() { return samm.units["watt"] }, conversionFactor: "4.184 × 10³ W", quantityKinds: [ "heatFlowRate", "radiantEnergyflux", "activePower", "heatFlowRate", "soundPower", "power", "radiantPower", "powerForDirectCurrent" ] },
        "kilocandela": { name: "kilocandela", label: "kilocandela", symbol: "kcd", code: "P33", referenceUnit: function() { return samm.units["candela"] }, conversionFactor: "10³ cd", quantityKinds: [ "luminousIntensity", "luminousIntensity" ] },
        "kilocharacter": { name: "kilocharacter", label: "kilocharacter", symbol: null, code: "KB", referenceUnit: null, conversionFactor: null, quantityKinds: null },
        "kilocoulomb": { name: "kilocoulomb", label: "kilocoulomb", symbol: "kC", code: "B26", referenceUnit: function() { return samm.units["coulomb"] }, conversionFactor: "10³ C", quantityKinds: [ "quantityOfElectricity", "electricFluxFluxOfDisplacement", "electricCharge", "elementaryCharge", "electricFluxFluxOfDisplacement", "electricCharge", "quantityOfElectricity" ] },
        "kilocoulombPerCubicMetre": { name: "kilocoulombPerCubicMetre", label: "kilocoulomb per cubic metre", symbol: "kC/m³", code: "B27", referenceUnit: function() { return samm.units["coulombPerCubicMetre"] }, conversionFactor: "10³ C/m³", quantityKinds: [ "chargeDensity", "volumeDensityOfCharge", "volumicCharge", "volumicCharge", "volumeDensityOfCharge", "chargeDensity" ] },
        "kilocoulombPerSquareMetre": { name: "kilocoulombPerSquareMetre", label: "kilocoulomb per square metre", symbol: "kC/m²", code: "B28", referenceUnit: function() { return samm.units["coulombPerSquareMetre"] }, conversionFactor: "10³ C/m²", quantityKinds: [ "electricFluxDensity", "displacementElectricPolarization", "surfaceDensityOfCharge", "surfaceDensityOfCharge", "electricFluxDensity", "displacementElectricPolarization" ] },
        "kilocurie": { name: "kilocurie", label: "kilocurie", symbol: "kCi", code: "2R", referenceUnit: function() { return samm.units["becquerel"] }, conversionFactor: "3.7 × 10¹³ Bq", quantityKinds: [ "activity", "activity" ] },
        "kiloelectronvolt": { name: "kiloelectronvolt", label: "kiloelectronvolt", symbol: "keV", code: "B29", referenceUnit: function() { return samm.units["electronvolt"] }, conversionFactor: "10³ eV", quantityKinds: [ "work", "kineticEnergy", "energy", "potentialEnergy", "maximumBetaParticleEnergy", "fermiEnergy", "potentialEnergy", "work", "kineticEnergy", "resonanceEnergy", "betaDisintegrationEnergy", "energy" ] },
        "kilofarad": { name: "kilofarad", label: "kilofarad", symbol: "kF", code: "N90", referenceUnit: function() { return samm.units["farad"] }, conversionFactor: "10³ F", quantityKinds: [ "capacitance", "capacitance" ] },
        "kilogram": { name: "kilogram", label: "kilogram", symbol: "kg", code: "KGM", referenceUnit: null, conversionFactor: null, quantityKinds: [ "massOfAtomOfANuclideX", "massOfMolecule", "effectiveMass", "mass", "nuclidicMass", "massExcess" ] },
        "kilogramCentimetrePerSecond": { name: "kilogramCentimetrePerSecond", label: "kilogram centimetre per second", symbol: "kg·(cm/s)", code: "M98", referenceUnit: function() { return samm.units["kilogramMetrePerSecond"] }, conversionFactor: "10⁻² kg × m/s", quantityKinds: [ "momentum", "momentum" ] },
        "kilogramDrainedNetWeight": { name: "kilogramDrainedNetWeight", label: "kilogram drained net weight", symbol: "kg/net eda", code: "KDW", referenceUnit: null, conversionFactor: null, quantityKinds: null },
        "kilogramDryWeight": { name: "kilogramDryWeight", label: "kilogram, dry weight", symbol: null, code: "MND", referenceUnit: null, conversionFactor: null, quantityKinds: null },
        "kilogramForceMetrePerSquareCentimetre": { name: "kilogramForceMetrePerSquareCentimetre", label: "kilogram-force metre per square centimetre", symbol: "kgf·m/cm²", code: "E44", referenceUnit: null, conversionFactor: null, quantityKinds: null },
        "kilogramForcePerSquareCentimetre": { name: "kilogramForcePerSquareCentimetre", label: "kilogram-force per square centimetre", symbol: "kgf/cm²", code: "E42", referenceUnit: function() { return samm.units["pascal"] }, conversionFactor: "9.80665 × 10⁴ Pa", quantityKinds: [ "fugacityOfBInAGaseousMixture", "pressure", "shearModulus", "staticPressure", "normalStress", "modulusOfRigidity", "instantaneousSoundPressure", "modulusOfElasticity", "shearStress", "modulusOfCompression", "partialPressureOfBInAGaseousMixture", "bulkModulus", "osmoticPressure", "pressure", "modulusOfElasticity", "normalStress", "shearModulus", "modulusOfRigidity", "shearStress", "modulusOfCompression", "bulkModulus" ] },
        "kilogramForcePerSquareMillimetre": { name: "kilogramForcePerSquareMillimetre", label: "kilogram-force per square millimetre", symbol: "kgf/mm²", code: "E41", referenceUnit: function() { return samm.units["pascal"] }, conversionFactor: "9.80665 × 10⁶ Pa", quantityKinds: [ "modulusOfRigidity", "shearStress", "normalStress", "bulkModulus", "modulusOfElasticity", "pressure", "shearModulus", "modulusOfCompression", "fugacityOfBInAGaseousMixture", "pressure", "shearModulus", "staticPressure", "normalStress", "modulusOfRigidity", "instantaneousSoundPressure", "modulusOfElasticity", "shearStress", "modulusOfCompression", "partialPressureOfBInAGaseousMixture", "bulkModulus", "osmoticPressure" ] },
        "kilogramIncludingContainer": { name: "kilogramIncludingContainer", label: "kilogram, including container", symbol: null, code: "KIC", referenceUnit: null, conversionFactor: null, quantityKinds: null },
        "kilogramIncludingInnerPackaging": { name: "kilogramIncludingInnerPackaging", label: "kilogram, including inner packaging", symbol: null, code: "KIP", referenceUnit: null, conversionFactor: null, quantityKinds: null },
        "kilogramMetre": { name: "kilogramMetre", label: "kilogram metre", symbol: "kg·m", code: "M94", referenceUnit: null, conversionFactor: null, quantityKinds: [ "torque", "momentOfForce", "momentOfACouple" ] },
        "kilogramMetrePerSecond": { name: "kilogramMetrePerSecond", label: "kilogram metre per second", symbol: "kg·m/s", code: "B31", referenceUnit: null, conversionFactor: null, quantityKinds: [ "momentum" ] },
        "kilogramMetrePerSecondSquared": { name: "kilogramMetrePerSecondSquared", label: "kilogram metre per second squared", symbol: "kg·m/s²", code: "M77", referenceUnit: null, conversionFactor: null, quantityKinds: [ "weight", "force" ] },
        "kilogramMetreSquared": { name: "kilogramMetreSquared", label: "kilogram metre squared", symbol: "kg·m²", code: "B32", referenceUnit: null, conversionFactor: null, quantityKinds: [ "momentOfInertiaDynamicMomentOfInertia" ] },
        "kilogramMetreSquaredPerSecond": { name: "kilogramMetreSquaredPerSecond", label: "kilogram metre squared per second", symbol: "kg·m²/s", code: "B33", referenceUnit: null, conversionFactor: null, quantityKinds: [ "momentOfMomentum", "angularMomentum" ] },
        "kilogramNamedSubstance": { name: "kilogramNamedSubstance", label: "kilogram named substance", symbol: null, code: "KNS", referenceUnit: null, conversionFactor: null, quantityKinds: null },
        "kilogramOfCholineChloride": { name: "kilogramOfCholineChloride", label: "kilogram of choline chloride", symbol: "kg C₅ H₁₄ClNO", code: "KCC", referenceUnit: null, conversionFactor: null, quantityKinds: null },
        "kilogramOfHydrogenPeroxide": { name: "kilogramOfHydrogenPeroxide", label: "kilogram of hydrogen peroxide", symbol: "kg H₂O₂", code: "KHY", referenceUnit: null, conversionFactor: null, quantityKinds: null },
        "kilogramOfImportedMeatLessOffal": { name: "kilogramOfImportedMeatLessOffal", label: "kilogram of imported meat, less offal", symbol: null, code: "TMS", referenceUnit: null, conversionFactor: null, quantityKinds: null },
        "kilogramOfMethylamine": { name: "kilogramOfMethylamine", label: "kilogram of methylamine", symbol: "kg met.am.", code: "KMA", referenceUnit: null, conversionFactor: null, quantityKinds: null },
        "kilogramOfNitrogen": { name: "kilogramOfNitrogen", label: "kilogram of nitrogen", symbol: "kg N", code: "KNI", referenceUnit: null, conversionFactor: null, quantityKinds: null },
        "kilogramOfPhosphorusPentoxidePhosphoricAnhydride": { name: "kilogramOfPhosphorusPentoxidePhosphoricAnhydride", label: "kilogram of phosphorus pentoxide (phosphoric anhydride)", symbol: null, code: "KPP", referenceUnit: null, conversionFactor: null, quantityKinds: null },
        "kilogramOfPotassiumHydroxideCausticPotash": { name: "kilogramOfPotassiumHydroxideCausticPotash", label: "kilogram of potassium hydroxide (caustic potash)", symbol: "kg KOH", code: "KPH", referenceUnit: null, conversionFactor: null, quantityKinds: null },
        "kilogramOfPotassiumOxide": { name: "kilogramOfPotassiumOxide", label: "kilogram of potassium oxide", symbol: "kg K₂O", code: "KPO", referenceUnit: null, conversionFactor: null, quantityKinds: null },
        "kilogramOfSodiumHydroxideCausticSoda": { name: "kilogramOfSodiumHydroxideCausticSoda", label: "kilogram of sodium hydroxide (caustic soda)", symbol: "kg NaOH", code: "KSH", referenceUnit: null, conversionFactor: null, quantityKinds: null },
        "kilogramOfSubstance90PercentDry": { name: "kilogramOfSubstance90PercentDry", label: "kilogram of substance 90 % dry", symbol: "kg 90 % sdt", code: "KSD", referenceUnit: null, conversionFactor: null, quantityKinds: null },
        "kilogramOfTungstenTrioxide": { name: "kilogramOfTungstenTrioxide", label: "kilogram of tungsten trioxide", symbol: "kg WO₃", code: "KWO", referenceUnit: null, conversionFactor: null, quantityKinds: null },
        "kilogramOfUranium": { name: "kilogramOfUranium", label: "kilogram of uranium", symbol: "kg U", code: "KUR", referenceUnit: null, conversionFactor: null, quantityKinds: null },
        "kilogramPerBar": { name: "kilogramPerBar", label: "kilogram per bar", symbol: "kg/bar", code: "H53", referenceUnit: null, conversionFactor: null, quantityKinds: [ "volumicMass", "massDensity", "density" ] },
        "kilogramPerCubicCentimetre": { name: "kilogramPerCubicCentimetre", label: "kilogram per cubic centimetre", symbol: "kg/cm³", code: "G31", referenceUnit: null, conversionFactor: null, quantityKinds: [ "volumicMass", "massDensity", "density" ] },
        "kilogramPerCubicCentimetreBar": { name: "kilogramPerCubicCentimetreBar", label: "kilogram per cubic centimetre bar", symbol: "kg/(cm³·bar)", code: "G16", referenceUnit: null, conversionFactor: null, quantityKinds: [ "volumicMass", "massDensity", "density" ] },
        "kilogramPerCubicCentimetreKelvin": { name: "kilogramPerCubicCentimetreKelvin", label: "kilogram per cubic centimetre kelvin", symbol: "kg/(cm³·K)", code: "G38", referenceUnit: null, conversionFactor: null, quantityKinds: [ "volumicMass", "massDensity", "density" ] },
        "kilogramPerCubicDecimetre": { name: "kilogramPerCubicDecimetre", label: "kilogram per cubic decimetre", symbol: "kg/dm³", code: "B34", referenceUnit: function() { return samm.units["kilogramPerCubicMetre"] }, conversionFactor: "10³ kg/m³", quantityKinds: [ "density", "volumicMass", "massDensity", "amountOfSubstance", "massDensity", "density", "concentrationOfB", "massConcentrationOfB", "volumicMass" ] },
        "kilogramPerCubicDecimetreBar": { name: "kilogramPerCubicDecimetreBar", label: "kilogram per cubic decimetre bar", symbol: "(kg/dm³)/bar", code: "H55", referenceUnit: null, conversionFactor: null, quantityKinds: [ "volumicMass", "massDensity", "density" ] },
        "kilogramPerCubicDecimetreKelvin": { name: "kilogramPerCubicDecimetreKelvin", label: "kilogram per cubic decimetre kelvin", symbol: "(kg/dm³)/K", code: "H54", referenceUnit: null, conversionFactor: null, quantityKinds: [ "volumicMass", "massDensity", "density" ] },
        "kilogramPerCubicMetre": { name: "kilogramPerCubicMetre", label: "kilogram per cubic metre", symbol: "kg/m³", code: "KMQ", referenceUnit: null, conversionFactor: null, quantityKinds: [ "amountOfSubstance", "massDensity", "density", "concentrationOfB", "massConcentrationOfB", "volumicMass" ] },
        "kilogramPerCubicMetreBar": { name: "kilogramPerCubicMetreBar", label: "kilogram per cubic metre bar", symbol: "kg/(m³·bar)", code: "G18", referenceUnit: null, conversionFactor: null, quantityKinds: [ "volumicMass", "massDensity", "density" ] },
        "kilogramPerCubicMetreKelvin": { name: "kilogramPerCubicMetreKelvin", label: "kilogram per cubic metre kelvin", symbol: "kg/(m³·K)", code: "G40", referenceUnit: null, conversionFactor: null, quantityKinds: [ "volumicMass", "massDensity", "density" ] },
        "kilogramPerCubicMetrePascal": { name: "kilogramPerCubicMetrePascal", label: "kilogram per cubic metre pascal", symbol: "(kg/m³)/Pa", code: "M73", referenceUnit: null, conversionFactor: null, quantityKinds: [ "volumicMass", "massDensity", "density" ] },
        "kilogramPerDay": { name: "kilogramPerDay", label: "kilogram per day", symbol: "kg/d", code: "F30", referenceUnit: null, conversionFactor: null, quantityKinds: [ "massFlowRate" ] },
        "kilogramPerDayBar": { name: "kilogramPerDayBar", label: "kilogram per day bar", symbol: "kg/(d·bar)", code: "F66", referenceUnit: null, conversionFactor: null, quantityKinds: [ "massFlowRate" ] },
        "kilogramPerDayKelvin": { name: "kilogramPerDayKelvin", label: "kilogram per day kelvin", symbol: "kg/(d·K)", code: "F39", referenceUnit: null, conversionFactor: null, quantityKinds: [ "massFlowRate" ] },
        "kilogramPerHour": { name: "kilogramPerHour", label: "kilogram per hour", symbol: "kg/h", code: "E93", referenceUnit: null, conversionFactor: null, quantityKinds: [ "massFlowRate" ] },
        "kilogramPerHourBar": { name: "kilogramPerHourBar", label: "kilogram per hour bar", symbol: "kg/(h·bar)", code: "F67", referenceUnit: null, conversionFactor: null, quantityKinds: [ "massFlowRate" ] },
        "kilogramPerHourKelvin": { name: "kilogramPerHourKelvin", label: "kilogram per hour kelvin", symbol: "kg/(h·K)", code: "F40", referenceUnit: null, conversionFactor: null, quantityKinds: [ "massFlowRate" ] },
        "kilogramPerKelvin": { name: "kilogramPerKelvin", label: "kilogram per kelvin", symbol: "kg/K", code: "F15", referenceUnit: null, conversionFactor: null, quantityKinds: [ "volumicMass", "massDensity", "density" ] },
        "kilogramPerKilogram": { name: "kilogramPerKilogram", label: "kilogram per kilogram", symbol: "kg/kg", code: "M29", referenceUnit: null, conversionFactor: null, quantityKinds: [ "massRatio" ] },
        "kilogramPerKilometre": { name: "kilogramPerKilometre", label: "kilogram per kilometre", symbol: "kg/km", code: "M31", referenceUnit: function() { return samm.units["kilogramPerMetre"] }, conversionFactor: "10⁻³ kg/m", quantityKinds: [ "linearMass", "linearDensity", "linearDensity", "linearMass" ] },
        "kilogramPerKilomol": { name: "kilogramPerKilomol", label: "kilogram per kilomol", symbol: "kg/kmol", code: "F24", referenceUnit: null, conversionFactor: null, quantityKinds: [ "volumicMass", "massDensity", "density" ] },
        "kilogramPerLitre": { name: "kilogramPerLitre", label: "kilogram per litre", symbol: "kg/l or kg/L", code: "B35", referenceUnit: function() { return samm.units["kilogramPerCubicMetre"] }, conversionFactor: "10³ kg/m³", quantityKinds: [ "amountOfSubstance", "massDensity", "density", "concentrationOfB", "massConcentrationOfB", "volumicMass", "concentrationOfB", "density", "amountOfSubstance", "massConcentrationOfB", "volumicMass", "massDensity" ] },
        "kilogramPerLitreBar": { name: "kilogramPerLitreBar", label: "kilogram per litre bar", symbol: "kg/(l·bar)", code: "G17", referenceUnit: null, conversionFactor: null, quantityKinds: [ "volumicMass", "massDensity", "density" ] },
        "kilogramPerLitreKelvin": { name: "kilogramPerLitreKelvin", label: "kilogram per litre kelvin", symbol: "kg/(l·K)", code: "G39", referenceUnit: null, conversionFactor: null, quantityKinds: [ "volumicMass", "massDensity", "density" ] },
        "kilogramPerMetre": { name: "kilogramPerMetre", label: "kilogram per metre", symbol: "kg/m", code: "KL", referenceUnit: null, conversionFactor: null, quantityKinds: [ "linearMass", "linearDensity" ] },
        "kilogramPerMetreDay": { name: "kilogramPerMetreDay", label: "kilogram per metre day", symbol: "kg/(m·d)", code: "N39", referenceUnit: function() { return samm.units["pascalSecond"] }, conversionFactor: "1.15741 × 10⁻⁵ Pa × s", quantityKinds: [ "viscosityDynamicViscosity", "viscosityDynamicViscosity" ] },
        "kilogramPerMetreHour": { name: "kilogramPerMetreHour", label: "kilogram per metre hour", symbol: "kg/(m·h)", code: "N40", referenceUnit: function() { return samm.units["pascalSecond"] }, conversionFactor: "2.77778 × 10⁻⁴ Pa × s", quantityKinds: [ "viscosityDynamicViscosity", "viscosityDynamicViscosity" ] },
        "kilogramPerMetreMinute": { name: "kilogramPerMetreMinute", label: "kilogram per metre minute", symbol: "kg/(m·min)", code: "N38", referenceUnit: function() { return samm.units["pascalSecond"] }, conversionFactor: "1.66667 × 10⁻² Pa × s", quantityKinds: [ "viscosityDynamicViscosity", "viscosityDynamicViscosity" ] },
        "kilogramPerMetreSecond": { name: "kilogramPerMetreSecond", label: "kilogram per metre second", symbol: "kg/(m·s)", code: "N37", referenceUnit: function() { return samm.units["pascalSecond"] }, conversionFactor: "Pa × s", quantityKinds: [ "viscosityDynamicViscosity", "viscosityDynamicViscosity" ] },
        "kilogramPerMillimetre": { name: "kilogramPerMillimetre", label: "kilogram per millimetre", symbol: "kg/mm", code: "KW", referenceUnit: function() { return samm.units["kilogramPerMetre"] }, conversionFactor: "10³ kg/m", quantityKinds: [ "linearMass", "linearDensity", "linearMass", "linearDensity" ] },
        "kilogramPerMillimetreWidth": { name: "kilogramPerMillimetreWidth", label: "kilogram per millimetre width", symbol: null, code: "KI", referenceUnit: function() { return samm.units["kilogramPerMetre"] }, conversionFactor: "10³ kg/m", quantityKinds: [ "linearMass", "linearDensity" ] },
        "kilogramPerMinute": { name: "kilogramPerMinute", label: "kilogram per minute", symbol: "kg/min", code: "F31", referenceUnit: null, conversionFactor: null, quantityKinds: [ "massFlowRate" ] },
        "kilogramPerMinuteBar": { name: "kilogramPerMinuteBar", label: "kilogram per minute bar", symbol: "kg/(min·bar)", code: "F68", referenceUnit: null, conversionFactor: null, quantityKinds: [ "massFlowRate" ] },
        "kilogramPerMinuteKelvin": { name: "kilogramPerMinuteKelvin", label: "kilogram per minute kelvin", symbol: "kg/(min·K)", code: "F41", referenceUnit: null, conversionFactor: null, quantityKinds: [ "massFlowRate" ] },
        "kilogramPerMole": { name: "kilogramPerMole", label: "kilogram per mole", symbol: "kg/mol", code: "D74", referenceUnit: null, conversionFactor: null, quantityKinds: [ "molarMass" ] },
        "kilogramPerPascal": { name: "kilogramPerPascal", label: "kilogram per pascal", symbol: "kg/Pa", code: "M74", referenceUnit: null, conversionFactor: null, quantityKinds: [ "volumicMass", "massDensity", "density" ] },
        "kilogramPerSecond": { name: "kilogramPerSecond", label: "kilogram per second", symbol: "kg/s", code: "KGS", referenceUnit: null, conversionFactor: null, quantityKinds: [ "massFlowRate" ] },
        "kilogramPerSecondBar": { name: "kilogramPerSecondBar", label: "kilogram per second bar", symbol: "kg/(s·bar)", code: "F69", referenceUnit: null, conversionFactor: null, quantityKinds: [ "massFlowRate" ] },
        "kilogramPerSecondKelvin": { name: "kilogramPerSecondKelvin", label: "kilogram per second kelvin", symbol: "kg/(s·K)", code: "F42", referenceUnit: null, conversionFactor: null, quantityKinds: [ "massFlowRate" ] },
        "kilogramPerSecondPascal": { name: "kilogramPerSecondPascal", label: "kilogram per second pascal", symbol: "(kg/s)/Pa", code: "M87", referenceUnit: null, conversionFactor: null, quantityKinds: [ "massFlowRate" ] },
        "kilogramPerSquareCentimetre": { name: "kilogramPerSquareCentimetre", label: "kilogram per square centimetre", symbol: "kg/cm²", code: "D5", referenceUnit: function() { return samm.units["kilogramPerSquareMetre"] }, conversionFactor: "10⁴ kg/m²", quantityKinds: [ "surfaceDensity", "areicMass", "surfaceDensity", "meanMassRange", "areicMass" ] },
        "kilogramPerSquareMetre": { name: "kilogramPerSquareMetre", label: "kilogram per square metre", symbol: "kg/m²", code: "28", referenceUnit: null, conversionFactor: null, quantityKinds: [ "surfaceDensity", "meanMassRange", "areicMass" ] },
        "kilogramPerSquareMetrePascalSecond": { name: "kilogramPerSquareMetrePascalSecond", label: "kilogram per square metre pascal second", symbol: "kg/(m²·Pa·s)", code: "Q28", referenceUnit: null, conversionFactor: null, quantityKinds: null },
        "kilogramPerSquareMetreSecond": { name: "kilogramPerSquareMetreSecond", label: "kilogram per square metre second", symbol: "kg/(m²·s)", code: "H56", referenceUnit: null, conversionFactor: null, quantityKinds: [ "massFlowRate" ] },
        "kilogramSquareCentimetre": { name: "kilogramSquareCentimetre", label: "kilogram square centimetre", symbol: "kg·cm²", code: "F18", referenceUnit: null, conversionFactor: null, quantityKinds: [ "volumicMass", "massDensity", "density" ] },
        "kilogramSquareMillimetre": { name: "kilogramSquareMillimetre", label: "kilogram square millimetre", symbol: "kg·mm²", code: "F19", referenceUnit: null, conversionFactor: null, quantityKinds: [ "volumicMass", "massDensity", "density" ] },
        "kilohenry": { name: "kilohenry", label: "kilohenry", symbol: "kH", code: "P24", referenceUnit: function() { return samm.units["henry"] }, conversionFactor: "10³ H", quantityKinds: [ "mutualInductance", "permeance", "selfInductance", "selfInductance", "permeance", "mutualInductance" ] },
        "kilohertz": { name: "kilohertz", label: "kilohertz", symbol: "kHz", code: "KHZ", referenceUnit: function() { return samm.units["hertz"] }, conversionFactor: "10³ Hz", quantityKinds: [ "frequency", "frequency" ] },
        "kilohertzMetre": { name: "kilohertzMetre", label: "kilohertz metre", symbol: "kHz·m", code: "M17", referenceUnit: function() { return samm.units["hertzMetre"] }, conversionFactor: "10³ Hz × m", quantityKinds: [ "performanceCharacteristic", "coefficient", "coefficient", "performanceCharacteristic" ] },
        "kilojoule": { name: "kilojoule", label: "kilojoule", symbol: "kJ", code: "KJO", referenceUnit: function() { return samm.units["joule"] }, conversionFactor: "10³ J", quantityKinds: [ "quantityOfHeat", "reactionEnergy", "workFunction", "activeEnergy", "kineticEnergy", "levelWidth", "meanEnergyImparted", "helmholtzFunction", "radiantEnergy", "potentialEnergy", "energy", "thermodynamicEnergy", "helmholtzFreeEnergy", "work", "heat", "hartreeEnergy", "energyImparted", "enthalpy", "alphaDisintegrationEnergy", "energy", "potentialEnergy", "kineticEnergy", "work" ] },
        "kilojoulePerDay": { name: "kilojoulePerDay", label: "kilojoule per day", symbol: "kJ/d", code: "P21", referenceUnit: function() { return samm.units["watt"] }, conversionFactor: "1.15741 × 10⁻² W", quantityKinds: [ "powerForDirectCurrent", "activePower", "radiantEnergyflux", "activePower", "heatFlowRate", "soundPower", "power", "radiantPower", "powerForDirectCurrent" ] },
        "kilojoulePerHour": { name: "kilojoulePerHour", label: "kilojoule per hour", symbol: "kJ/h", code: "P20", referenceUnit: function() { return samm.units["watt"] }, conversionFactor: "2.77778 × 10⁻¹ W", quantityKinds: [ "powerForDirectCurrent", "activePower", "radiantEnergyflux", "activePower", "heatFlowRate", "soundPower", "power", "radiantPower", "powerForDirectCurrent" ] },
        "kilojoulePerKelvin": { name: "kilojoulePerKelvin", label: "kilojoule per kelvin", symbol: "kJ/K", code: "B41", referenceUnit: function() { return samm.units["joulePerKelvin"] }, conversionFactor: "10³ J/K", quantityKinds: [ "planckFunction", "heatCapacity", "massieuFunction", "boltzmannConstant", "entropy", "heatCapacity", "entropy" ] },
        "kilojoulePerKilogram": { name: "kilojoulePerKilogram", label: "kilojoule per kilogram", symbol: "kJ/kg", code: "B42", referenceUnit: function() { return samm.units["joulePerKilogram"] }, conversionFactor: "10³ J/kg", quantityKinds: [ "specificEnthalpy", "massicEnthalpy", "specificEnergy", "massicEnergy" ] },
        "kilojoulePerKilogramKelvin": { name: "kilojoulePerKilogramKelvin", label: "kilojoule per kilogram kelvin", symbol: "kJ/(kg·K)", code: "B43", referenceUnit: function() { return samm.units["joulePerKilogramKelvin"] }, conversionFactor: "10³ J/(kg × K)", quantityKinds: [ "specificHeatCapacityAtSaturation", "specificHeatCapacityAtConstantPressure", "specificHeatCapacityAtConstantVolume", "specificHeatCapacityAtSaturation", "specificHeatCapacityAtConstantVolume", "specificHeatCapacityAtConstantPressure" ] },
        "kilojoulePerMinute": { name: "kilojoulePerMinute", label: "kilojoule per minute", symbol: "kJ/min", code: "P19", referenceUnit: function() { return samm.units["watt"] }, conversionFactor: "1.66667 × 10 W", quantityKinds: [ "radiantEnergyflux", "activePower", "heatFlowRate", "soundPower", "power", "radiantPower", "powerForDirectCurrent", "powerForDirectCurrent", "activePower" ] },
        "kilojoulePerMole": { name: "kilojoulePerMole", label: "kilojoule per mole", symbol: "kJ/mol", code: "B44", referenceUnit: function() { return samm.units["joulePerMole"] }, conversionFactor: "10³ J/mol", quantityKinds: [ "molarThermodynamicEnergy", "chemicalPotential", "affinityOfAChemicalReaction", "molarThermodynamicEnergy" ] },
        "kilojoulePerSecond": { name: "kilojoulePerSecond", label: "kilojoule per second", symbol: "kJ/s", code: "P18", referenceUnit: function() { return samm.units["watt"] }, conversionFactor: "10³ W", quantityKinds: [ "radiantEnergyflux", "activePower", "heatFlowRate", "soundPower", "power", "radiantPower", "powerForDirectCurrent", "powerForDirectCurrent", "activePower" ] },
        "kilolitre": { name: "kilolitre", label: "kilolitre", symbol: "kl", code: "K6", referenceUnit: function() { return samm.units["cubicMetre"] }, conversionFactor: "m³", quantityKinds: [ "volume", "sectionModulus", "volume" ] },
        "kilolitrePerHour": { name: "kilolitrePerHour", label: "kilolitre per hour", symbol: "kl/h", code: "4X", referenceUnit: function() { return samm.units["cubicMetrePerSecond"] }, conversionFactor: "2.77778 × 10⁻⁴ m³/s", quantityKinds: [ "volumeFlowRate", "volumeFlowRate", "recombinationCoefficient", "instantaneousVolumeFlowRate" ] },
        "kilolux": { name: "kilolux", label: "kilolux", symbol: "klx", code: "KLX", referenceUnit: null, conversionFactor: null, quantityKinds: [ "illuminance" ] },
        "kilometre": { name: "kilometre", label: "kilometre", symbol: "km", code: "KMT", referenceUnit: function() { return samm.units["metre"] }, conversionFactor: "10³ m", quantityKinds: [ "thickness", "height", "cartesianCoordinates", "radiusOfCurvature", "length", "distance", "radius", "diameter", "lengthOfPath", "breadth", "thickness", "particlePositionVector", "cartesianCoordinates", "focalDistance", "radius", "radiusOfCurvature", "displacementVectorOfIonOrAtom", "lengthOfPath", "diameter", "comptonWavelength", "slowingDownLength", "migrationLength", "meanFreePath", "equilibriumPositionVectorOfIonOrAtom", "instantaneousSoundParticleDisplacement", "imageDistance", "breadth", "length", "halfValueThickness", "coherenceLength", "latticeVector", "londonPenetrationDepth", "diffusionLength", "meanFreePathOfPhononsOrElectrons", "diffusionCoefficientForNeutronFluxDensity", "halfThickness", "height", "electronRadius", "distance", "objectDistance", "bohrRadius", "diffusionCoefficientForNeutronFluenceRate", "nuclearRadius", "wavelength", "fundamentalLatticeVector", "meanLinearRange" ] },
        "kilometrePerHour": { name: "kilometrePerHour", label: "kilometre per hour", symbol: "km/h", code: "KMH", referenceUnit: function() { return samm.units["metrePerSecond"] }, conversionFactor: "0.277778 m/s", quantityKinds: [ "groupVelocity", "velocityOfSoundPhaseVelocity", "phaseVelocity", "neutronSpeed", "phaseSpeedOfElectromagneticWaves", "velocity", "velocitySpeedOnPropagationOfElectromagneticWavesInVacuo", "instantaneousSoundParticleVelocity", "phaseVelocityOfElectromagneticWaves", "phaseVelocity", "velocity", "groupVelocity" ] },
        "kilometrePerSecond": { name: "kilometrePerSecond", label: "kilometre per second", symbol: "km/s", code: "M62", referenceUnit: function() { return samm.units["metrePerSecond"] }, conversionFactor: "10³ m/s", quantityKinds: [ "groupVelocity", "velocityOfSoundPhaseVelocity", "phaseVelocity", "neutronSpeed", "phaseSpeedOfElectromagneticWaves", "velocity", "velocitySpeedOnPropagationOfElectromagneticWavesInVacuo", "instantaneousSoundParticleVelocity", "phaseVelocityOfElectromagneticWaves", "groupVelocity", "phaseVelocity", "velocity" ] },
        "kilometrePerSecondSquared": { name: "kilometrePerSecondSquared", label: "kilometre per second squared", symbol: "km/s²", code: "M38", referenceUnit: function() { return samm.units["metrePerSecondSquared"] }, conversionFactor: "10³ m/s²", quantityKinds: [ "accelerationOfFreeFall", "acceleration", "accelerationDueToGravity", "acceleration", "instantaneousSoundParticleAcceleration", "accelerationOfFreeFall", "accelerationDueToGravity" ] },
        "kilomole": { name: "kilomole", label: "kilomole", symbol: "kmol", code: "B45", referenceUnit: function() { return samm.units["mole"] }, conversionFactor: "10³ mol", quantityKinds: [ "amountOfSubstance", "amountOfSubstance" ] },
        "kilomolePerCubicMetre": { name: "kilomolePerCubicMetre", label: "kilomole per cubic metre", symbol: "kmol/m³", code: "B46", referenceUnit: function() { return samm.units["molePerCubicMetre"] }, conversionFactor: "10³ mol/m³", quantityKinds: [ "massDensity", "density", "amountOfSubstance", "concentrationOfB", "volumicMass", "massConcentrationOfB", "amountOfSubstance", "massDensity", "volumicMass", "massConcentrationOfB", "density", "concentrationOfB" ] },
        "kilomolePerCubicMetreBar": { name: "kilomolePerCubicMetreBar", label: "kilomole per cubic metre bar", symbol: "(kmol/m³)/bar", code: "K60", referenceUnit: function() { return samm.units["molPerCubicMetrePascal"] }, conversionFactor: "10⁻² (mol/m³)/Pa", quantityKinds: [ "concentrationOfB", "density", "massDensity", "amountOfSubstance", "volumicMass", "massConcentrationOfB", "concentrationOfB", "volumicMass", "amountOfSubstance", "massDensity", "density", "massConcentrationOfB" ] },
        "kilomolePerCubicMetreKelvin": { name: "kilomolePerCubicMetreKelvin", label: "kilomole per cubic metre kelvin", symbol: "(kmol/m³)/K", code: "K59", referenceUnit: function() { return samm.units["molePerCubicMetreKelvin"] }, conversionFactor: "10³ (mol/m³)/K", quantityKinds: [ "massDensity", "amountOfSubstance", "massConcentrationOfB", "density", "volumicMass", "concentrationOfB", "massDensity", "amountOfSubstance", "volumicMass", "massConcentrationOfB", "density", "concentrationOfB" ] },
        "kilomolePerHour": { name: "kilomolePerHour", label: "kilomole per hour", symbol: "kmol/h", code: "K58", referenceUnit: function() { return samm.units["molePerSecond"] }, conversionFactor: "2.77778 × 10⁻¹ mol/s", quantityKinds: [ "molarFlux", "volumicMass", "density", "concentrationOfB", "massConcentrationOfB", "amountOfSubstance", "massDensity" ] },
        "kilomolePerKilogram": { name: "kilomolePerKilogram", label: "kilomole per kilogram", symbol: "kmol/kg", code: "P47", referenceUnit: function() { return samm.units["molePerKilogram"] }, conversionFactor: "10³ mol/kg", quantityKinds: [ "molalityOfSoluteB", "ionicStrength" ] },
        "kilomolePerMinute": { name: "kilomolePerMinute", label: "kilomole per minute", symbol: "kmol/min", code: "K61", referenceUnit: function() { return samm.units["molePerSecond"] }, conversionFactor: "16.6667 mol/s", quantityKinds: [ "molarFlux", "volumicMass", "density", "concentrationOfB", "massConcentrationOfB", "amountOfSubstance", "massDensity" ] },
        "kilomolePerSecond": { name: "kilomolePerSecond", label: "kilomole per second", symbol: "kmol/s", code: "E94", referenceUnit: null, conversionFactor: null, quantityKinds: [ "catalyticActivity" ] },
        "kilonewton": { name: "kilonewton", label: "kilonewton", symbol: "kN", code: "B47", referenceUnit: function() { return samm.units["newton"] }, conversionFactor: "10³ N", quantityKinds: [ "weight", "force", "weight", "force" ] },
        "kilonewtonMetre": { name: "kilonewtonMetre", label: "kilonewton metre", symbol: "kN·m", code: "B48", referenceUnit: function() { return samm.units["newtonMetre"] }, conversionFactor: "10³ N × m", quantityKinds: [ "momentOfForce", "torque", "momentOfACouple", "torque", "momentOfForce", "momentOfACouple" ] },
        "kilonewtonPerMetre": { name: "kilonewtonPerMetre", label: "kilonewton per metre", symbol: "kN/m", code: "N31", referenceUnit: function() { return samm.units["newtonPerMetre"] }, conversionFactor: "10³ N/m", quantityKinds: [ "surfaceTension", "surfaceTension" ] },
        "kiloohm": { name: "kiloohm", label: "kiloohm", symbol: "kΩ", code: "B49", referenceUnit: function() { return samm.units["ohm"] }, conversionFactor: "10³ Ω", quantityKinds: [ "impedance", "reactance", "modulusOfImpedance", "resistanceToDirectCurrent", "complexImpedances", "resistanceToAlternatingCurrent", "complexImpedances", "resistanceToDirectCurrent", "reactance", "impedance", "resistanceToAlternatingCurrent", "modulusOfImpedance" ] },
        "kiloohmMetre": { name: "kiloohmMetre", label: "kiloohm metre", symbol: "kΩ·m", code: "B50", referenceUnit: function() { return samm.units["ohmMetre"] }, conversionFactor: "10³ Ω × m", quantityKinds: [ "resistivity", "residualResistivity", "resistivity" ] },
        "kilopascal": { name: "kilopascal", label: "kilopascal", symbol: "kPa", code: "KPA", referenceUnit: function() { return samm.units["pascal"] }, conversionFactor: "10³ Pa", quantityKinds: [ "pressure", "modulusOfCompression", "modulusOfRigidity", "modulusOfElasticity", "normalStress", "bulkModulus", "shearStress", "shearModulus", "fugacityOfBInAGaseousMixture", "pressure", "shearModulus", "staticPressure", "normalStress", "modulusOfRigidity", "instantaneousSoundPressure", "modulusOfElasticity", "shearStress", "modulusOfCompression", "partialPressureOfBInAGaseousMixture", "bulkModulus", "osmoticPressure" ] },
        "kilopascalPerBar": { name: "kilopascalPerBar", label: "kilopascal per bar", symbol: "kPa/bar", code: "F03", referenceUnit: null, conversionFactor: null, quantityKinds: [ "pressureRatio" ] },
        "kilopascalPerKelvin": { name: "kilopascalPerKelvin", label: "kilopascal per kelvin", symbol: "kPa/K", code: "F83", referenceUnit: null, conversionFactor: null, quantityKinds: [ "shearStress", "modulusOfCompression", "modulusOfElasticity", "pressure", "normalStress", "shearModulus", "modulusOfRigidity", "bulkModulus" ] },
        "kilopascalPerMetre": { name: "kilopascalPerMetre", label: "kilopascal per metre", symbol: "kPa/m", code: "P81", referenceUnit: null, conversionFactor: null, quantityKinds: [ "hardnessIndex" ] },
        "kilopascalPerMillimetre": { name: "kilopascalPerMillimetre", label: "kilopascal per millimetre", symbol: "kPa/mm", code: "34", referenceUnit: null, conversionFactor: null, quantityKinds: [ "hardnessIndex" ] },
        "kilopascalSquareMetrePerGram": { name: "kilopascalSquareMetrePerGram", label: "kilopascal square metre per gram", symbol: "kPa·m²/g", code: "33", referenceUnit: function() { return samm.units["metrePerSecondSquared"] }, conversionFactor: "10⁶ m/s²", quantityKinds: [ "burstIndex", "acceleration", "instantaneousSoundParticleAcceleration", "accelerationOfFreeFall", "accelerationDueToGravity" ] },
        "kilopoundForce": { name: "kilopoundForce", label: "kilopound-force", symbol: "kip", code: "M75", referenceUnit: function() { return samm.units["newton"] }, conversionFactor: "4.448222 × 10³ N", quantityKinds: [ "force", "weight", "weight", "force" ] },
        "kilopoundPerHour": { name: "kilopoundPerHour", label: "kilopound per hour", symbol: "klb/h", code: "M90", referenceUnit: function() { return samm.units["kilogramPerSecond"] }, conversionFactor: "0.125997889 kg/s", quantityKinds: [ "massFlowRate", "massFlowRate" ] },
        "kiloroentgen": { name: "kiloroentgen", label: "kiloroentgen", symbol: "kR", code: "KR", referenceUnit: function() { return samm.units["coulombPerKilogram"] }, conversionFactor: "2.58 × 10⁻¹ C/kg", quantityKinds: [ "exposure", "exposure" ] },
        "kilosecond": { name: "kilosecond", label: "kilosecond", symbol: "ks", code: "B52", referenceUnit: function() { return samm.units["secondUnitOfTime"] }, conversionFactor: "10³ s", quantityKinds: [ "time", "timeConstant", "reactorTimeConstant", "halfLife", "meanLife", "time", "relaxationTime", "period", "carrierLifeTime", "periodicTime", "reverberationTime" ] },
        "kilosegment": { name: "kilosegment", label: "kilosegment", symbol: null, code: "KJ", referenceUnit: null, conversionFactor: null, quantityKinds: null },
        "kilosiemens": { name: "kilosiemens", label: "kilosiemens", symbol: "kS", code: "B53", referenceUnit: function() { return samm.units["siemens"] }, conversionFactor: "10³ S", quantityKinds: [ "conductanceForDirectCurrent", "admittance", "modulusOfAdmittance", "conductanceForAlternatingCurrent", "complexAdmittance", "modulusOfAdmittance", "complexAdmittance", "admittance", "conductanceForAlternatingCurrent", "conductanceForDirectCurrent" ] },
        "kilosiemensPerMetre": { name: "kilosiemensPerMetre", label: "kilosiemens per metre", symbol: "kS/m", code: "B54", referenceUnit: function() { return samm.units["siemensPerMetre"] }, conversionFactor: "10³ S/m", quantityKinds: [ "electrolyticConductivity", "conductivity", "conductivity" ] },
        "kilotesla": { name: "kilotesla", label: "kilotesla", symbol: "kT", code: "P13", referenceUnit: function() { return samm.units["tesla"] }, conversionFactor: "10³ T", quantityKinds: [ "magneticFluxDensity", "magneticInduction", "magneticPolarization", "magneticFluxDensity", "magneticInduction", "lowerCriticalMagneticFluxDensity", "upperCriticalMagneticFluxDensity", "magneticPolarization", "thermodynamicCriticalMagneticFluxDensity" ] },
        "kilotonne": { name: "kilotonne", label: "kilotonne", symbol: "kt", code: "KTN", referenceUnit: function() { return samm.units["kilogram"] }, conversionFactor: "10⁶ kg", quantityKinds: [ "mass", "massOfAtomOfANuclideX", "massOfMolecule", "effectiveMass", "mass", "nuclidicMass", "massExcess" ] },
        "kilovar": { name: "kilovar", label: "kilovar", symbol: "kvar", code: "KVR", referenceUnit: function() { return samm.units["voltAmpere"] }, conversionFactor: "10³ V × A", quantityKinds: [ "apparentPower", "reactivePower" ] },
        "kilovolt": { name: "kilovolt", label: "kilovolt", symbol: "kV", code: "KVT", referenceUnit: function() { return samm.units["volt"] }, conversionFactor: "10³ V", quantityKinds: [ "tension", "voltage", "peltierCoefficientForSubstancesAAndB", "electromotiveForce", "thermoelectromotiveForceBetweenSubstancesAAndB", "potentialDifference", "electricPotential", "voltage", "potentialDifference", "electricPotential", "tension", "electromotiveForce" ] },
        "kilovoltAmpere": { name: "kilovoltAmpere", label: "kilovolt - ampere", symbol: "kV·A", code: "KVA", referenceUnit: function() { return samm.units["voltAmpere"] }, conversionFactor: "10³ V × A", quantityKinds: [ "apparentPower", "apparentPower" ] },
        "kilovoltAmpereHour": { name: "kilovoltAmpereHour", label: "kilovolt ampere hour", symbol: "kVAh", code: "C79", referenceUnit: null, conversionFactor: null, quantityKinds: null },
        "kilovoltAmpereReactiveDemand": { name: "kilovoltAmpereReactiveDemand", label: "kilovolt ampere reactive demand", symbol: null, code: "K2", referenceUnit: null, conversionFactor: null, quantityKinds: null },
        "kilovoltAmpereReactiveHour": { name: "kilovoltAmpereReactiveHour", label: "kilovolt ampere reactive hour", symbol: "kvar·h", code: "K3", referenceUnit: null, conversionFactor: null, quantityKinds: null },
        "kilovoltPerMetre": { name: "kilovoltPerMetre", label: "kilovolt per metre", symbol: "kV/m", code: "B55", referenceUnit: function() { return samm.units["voltPerMetre"] }, conversionFactor: "10³ V/m", quantityKinds: [ "electricFieldStrength", "electricFieldStrength" ] },
        "kilowatt": { name: "kilowatt", label: "kilowatt", symbol: "kW", code: "KWT", referenceUnit: function() { return samm.units["watt"] }, conversionFactor: "10³ W", quantityKinds: [ "radiantEnergyflux", "activePower", "heatFlowRate", "soundPower", "power", "radiantPower", "powerForDirectCurrent", "power", "powerForDirectCurrent", "activePower", "heatFlowRate" ] },
        "kilowattDemand": { name: "kilowattDemand", label: "kilowatt demand", symbol: null, code: "K1", referenceUnit: null, conversionFactor: null, quantityKinds: null },
        "kilowattHour": { name: "kilowattHour", label: "kilowatt hour", symbol: "kW·h", code: "KWH", referenceUnit: function() { return samm.units["joule"] }, conversionFactor: "3.6 × 10⁶ J", quantityKinds: [ "kineticEnergy", "energy", "potentialEnergy", "work", "quantityOfHeat", "reactionEnergy", "workFunction", "activeEnergy", "kineticEnergy", "levelWidth", "meanEnergyImparted", "helmholtzFunction", "radiantEnergy", "potentialEnergy", "energy", "thermodynamicEnergy", "helmholtzFreeEnergy", "work", "heat", "hartreeEnergy", "energyImparted", "enthalpy", "alphaDisintegrationEnergy" ] },
        "kilowattHourPerCubicMetre": { name: "kilowattHourPerCubicMetre", label: "kilowatt hour per cubic metre", symbol: "kW·h/m³", code: "E46", referenceUnit: function() { return samm.units["joulePerCubicMetre"] }, conversionFactor: "3.6 × 10⁶ J/m³", quantityKinds: [ "soundEnergy", "volumic", "volumicElectromagneticEnergy", "soundEnergyDensity", "radiantEnergyDensity", "electromagneticEnergyDensity" ] },
        "kilowattHourPerHour": { name: "kilowattHourPerHour", label: "kilowatt hour per hour", symbol: "kW·h/h", code: "D03", referenceUnit: null, conversionFactor: null, quantityKinds: null },
        "kilowattHourPerKelvin": { name: "kilowattHourPerKelvin", label: "kilowatt hour per kelvin", symbol: "kW·h/K", code: "E47", referenceUnit: function() { return samm.units["joulePerKelvin"] }, conversionFactor: "3.6 × 10⁶ J/K", quantityKinds: [ "planckFunction", "heatCapacity", "massieuFunction", "boltzmannConstant", "entropy" ] },
        "kilowattPerMetreDegreeCelsius": { name: "kilowattPerMetreDegreeCelsius", label: "kilowatt per metre degree Celsius", symbol: "kW/(m·°C)", code: "N82", referenceUnit: function() { return samm.units["wattPerMetreKelvin"] }, conversionFactor: "10³ W/(m × K)", quantityKinds: [ "thermalConductivity", "thermalConductivity" ] },
        "kilowattPerMetreKelvin": { name: "kilowattPerMetreKelvin", label: "kilowatt per metre kelvin", symbol: "kW/(m·K)", code: "N81", referenceUnit: function() { return samm.units["wattPerMetreKelvin"] }, conversionFactor: "10³ W/(m × K)", quantityKinds: [ "thermalConductivity", "thermalConductivity" ] },
        "kilowattPerSquareMetreKelvin": { name: "kilowattPerSquareMetreKelvin", label: "kilowatt per square metre kelvin", symbol: "kW/(m²·K)", code: "N78", referenceUnit: function() { return samm.units["wattPerSquareMetreKelvin"] }, conversionFactor: "10³ W/(m² × K)", quantityKinds: [ "surfaceCoefficientOfHeatTransfer", "coefficientOfHeatTransfer" ] },
        "kiloweber": { name: "kiloweber", label: "kiloweber", symbol: "kWb", code: "P11", referenceUnit: function() { return samm.units["weber"] }, conversionFactor: "10³ Wb", quantityKinds: [ "magneticFluxQuantum", "magneticFlux", "magneticFlux" ] },
        "kiloweberPerMetre": { name: "kiloweberPerMetre", label: "kiloweber per metre", symbol: "kWb/m", code: "B56", referenceUnit: function() { return samm.units["weberPerMetre"] }, conversionFactor: "10³ Wb/m", quantityKinds: [ "magneticVectorPotential", "magneticVectorPotential" ] },
        "kipPerSquareInch": { name: "kipPerSquareInch", label: "kip per square inch", symbol: "ksi", code: "N20", referenceUnit: function() { return samm.units["pascal"] }, conversionFactor: "6.894757 × 10⁶ Pa", quantityKinds: [ "fugacityOfBInAGaseousMixture", "pressure", "shearModulus", "staticPressure", "normalStress", "modulusOfRigidity", "instantaneousSoundPressure", "modulusOfElasticity", "shearStress", "modulusOfCompression", "partialPressureOfBInAGaseousMixture", "bulkModulus", "osmoticPressure", "modulusOfElasticity", "modulusOfRigidity", "normalStress", "modulusOfCompression", "bulkModulus", "shearStress", "pressure", "shearModulus" ] },
        "kit": { name: "kit", label: "kit", symbol: null, code: "KT", referenceUnit: null, conversionFactor: null, quantityKinds: null },
        "knot": { name: "knot", label: "knot", symbol: "kn", code: "KNT", referenceUnit: function() { return samm.units["metrePerSecond"] }, conversionFactor: "0.514444 m/s", quantityKinds: [ "groupVelocity", "velocityOfSoundPhaseVelocity", "phaseVelocity", "neutronSpeed", "phaseSpeedOfElectromagneticWaves", "velocity", "velocitySpeedOnPropagationOfElectromagneticWavesInVacuo", "instantaneousSoundParticleVelocity", "phaseVelocityOfElectromagneticWaves", "groupVelocity", "velocity", "phaseVelocity" ] },
        "labourHour": { name: "labourHour", label: "labour hour", symbol: null, code: "LH", referenceUnit: null, conversionFactor: null, quantityKinds: null },
        "lacticDryMaterialPercentage": { name: "lacticDryMaterialPercentage", label: "lactic dry material percentage", symbol: null, code: "KLK", referenceUnit: null, conversionFactor: null, quantityKinds: null },
        "lactoseExcessPercentage": { name: "lactoseExcessPercentage", label: "lactose excess percentage", symbol: null, code: "LAC", referenceUnit: null, conversionFactor: null, quantityKinds: null },
        "lambert": { name: "lambert", label: "lambert", symbol: "Lb", code: "P30", referenceUnit: function() { return samm.units["candelaPerSquareMetre"] }, conversionFactor: "3.183099 × 10³ cd/m²", quantityKinds: [ "luminance", "luminance" ] },
        "langley": { name: "langley", label: "langley", symbol: "Ly", code: "P40", referenceUnit: function() { return samm.units["joulePerSquareMetre"] }, conversionFactor: "4.184 × 10⁴ J/m²", quantityKinds: [ "radianceExposure", "radiantEnergyFluence", "radiantEnergyFluence", "radianceExposure", "energyFluence" ] },
        "layer": { name: "layer", label: "layer", symbol: null, code: "LR", referenceUnit: null, conversionFactor: null, quantityKinds: null },
        "leaf": { name: "leaf", label: "leaf", symbol: null, code: "LEF", referenceUnit: null, conversionFactor: null, quantityKinds: null },
        "lengthUnit": { name: "lengthUnit", label: "length", symbol: null, code: "LN", referenceUnit: null, conversionFactor: null, quantityKinds: null },
        "lightYear": { name: "lightYear", label: "light year", symbol: "ly", code: "B57", referenceUnit: function() { return samm.units["metre"] }, conversionFactor: "9.46073 × 10¹⁵ m", quantityKinds: [ "lengthOfPath", "height", "breadth", "length", "diameter", "thickness", "radiusOfCurvature", "cartesianCoordinates", "distance", "radius", "thickness", "particlePositionVector", "cartesianCoordinates", "focalDistance", "radius", "radiusOfCurvature", "displacementVectorOfIonOrAtom", "lengthOfPath", "diameter", "comptonWavelength", "slowingDownLength", "migrationLength", "meanFreePath", "equilibriumPositionVectorOfIonOrAtom", "instantaneousSoundParticleDisplacement", "imageDistance", "breadth", "length", "halfValueThickness", "coherenceLength", "latticeVector", "londonPenetrationDepth", "diffusionLength", "meanFreePathOfPhononsOrElectrons", "diffusionCoefficientForNeutronFluxDensity", "halfThickness", "height", "electronRadius", "distance", "objectDistance", "bohrRadius", "diffusionCoefficientForNeutronFluenceRate", "nuclearRadius", "wavelength", "fundamentalLatticeVector", "meanLinearRange" ] },
        "linearFoot": { name: "linearFoot", label: "linear foot", symbol: null, code: "LF", referenceUnit: null, conversionFactor: null, quantityKinds: null },
        "linearMetre": { name: "linearMetre", label: "linear metre", symbol: null, code: "LM", referenceUnit: null, conversionFactor: null, quantityKinds: null },
        "linearYard": { name: "linearYard", label: "linear yard", symbol: null, code: "LY", referenceUnit: null, conversionFactor: null, quantityKinds: null },
        "link": { name: "link", label: "link", symbol: null, code: "LK", referenceUnit: null, conversionFactor: null, quantityKinds: null },
        "liquidPintUs": { name: "liquidPintUs", label: "liquid pint (US)", symbol: "liq pt (US)", code: "PTL", referenceUnit: function() { return samm.units["cubicMetre"] }, conversionFactor: "4. 731765 × 10⁻⁴ m³", quantityKinds: [ "volume", "sectionModulus", "volume" ] },
        "liquidPound": { name: "liquidPound", label: "liquid pound", symbol: null, code: "LP", referenceUnit: null, conversionFactor: null, quantityKinds: null },
        "liquidQuartUs": { name: "liquidQuartUs", label: "liquid quart (US)", symbol: "liq qt (US)", code: "QTL", referenceUnit: function() { return samm.units["cubicMetre"] }, conversionFactor: "9.463529 × 10⁻⁴ m³", quantityKinds: [ "volume", "sectionModulus", "volume" ] },
        "litre": { name: "litre", label: "litre", symbol: "l", code: "LTR", referenceUnit: function() { return samm.units["cubicMetre"] }, conversionFactor: "10⁻³ m³", quantityKinds: [ "volume", "sectionModulus", "volume" ] },
        "litreOfPureAlcohol": { name: "litreOfPureAlcohol", label: "litre of pure alcohol", symbol: null, code: "LPA", referenceUnit: null, conversionFactor: null, quantityKinds: null },
        "litrePerBar": { name: "litrePerBar", label: "litre per bar", symbol: "l/bar", code: "G95", referenceUnit: null, conversionFactor: null, quantityKinds: [ "volume" ] },
        "litrePerDay": { name: "litrePerDay", label: "litre per day", symbol: "l/d", code: "LD", referenceUnit: function() { return samm.units["cubicMetrePerSecond"] }, conversionFactor: "1.15741 × 10⁻⁸ m³/s", quantityKinds: [ "volumeFlowRate", "recombinationCoefficient", "instantaneousVolumeFlowRate", "volumeFlowRate" ] },
        "litrePerDayBar": { name: "litrePerDayBar", label: "litre per day bar", symbol: "l/(d·bar)", code: "G82", referenceUnit: null, conversionFactor: null, quantityKinds: [ "volumeFlowRate" ] },
        "litrePerDayKelvin": { name: "litrePerDayKelvin", label: "litre per day kelvin", symbol: "l/(d·K)", code: "G65", referenceUnit: null, conversionFactor: null, quantityKinds: [ "volumeFlowRate" ] },
        "litrePerHour": { name: "litrePerHour", label: "litre per hour", symbol: "l/h", code: "E32", referenceUnit: function() { return samm.units["cubicMetrePerSecond"] }, conversionFactor: "2.77778 × 10⁻⁷ m³/s", quantityKinds: [ "volumeFlowRate", "recombinationCoefficient", "instantaneousVolumeFlowRate" ] },
        "litrePerHourBar": { name: "litrePerHourBar", label: "litre per hour bar", symbol: "l/(h·bar)", code: "G83", referenceUnit: null, conversionFactor: null, quantityKinds: [ "volumeFlowRate" ] },
        "litrePerHourKelvin": { name: "litrePerHourKelvin", label: "litre per hour kelvin", symbol: "l/(h·K)", code: "G66", referenceUnit: null, conversionFactor: null, quantityKinds: [ "volumeFlowRate" ] },
        "litrePerKelvin": { name: "litrePerKelvin", label: "litre per kelvin", symbol: "l/K", code: "G28", referenceUnit: null, conversionFactor: null, quantityKinds: [ "volumePerTemperature" ] },
        "litrePerKilogram": { name: "litrePerKilogram", label: "litre per kilogram", symbol: "l/kg", code: "H83", referenceUnit: null, conversionFactor: null, quantityKinds: [ "specificVolume", "massicVolume" ] },
        "litrePerLitre": { name: "litrePerLitre", label: "litre per litre", symbol: "l/l", code: "K62", referenceUnit: null, conversionFactor: null, quantityKinds: [ "volumeRatio" ] },
        "litrePerMinute": { name: "litrePerMinute", label: "litre per minute", symbol: "l/min", code: "L2", referenceUnit: function() { return samm.units["cubicMetrePerSecond"] }, conversionFactor: "1.66667 × 10⁻⁵ m³/s", quantityKinds: [ "volumeFlowRate", "volumeFlowRate", "recombinationCoefficient", "instantaneousVolumeFlowRate" ] },
        "litrePerMinuteBar": { name: "litrePerMinuteBar", label: "litre per minute bar", symbol: "l/(min·bar)", code: "G84", referenceUnit: null, conversionFactor: null, quantityKinds: [ "volumeFlowRate" ] },
        "litrePerMinuteKelvin": { name: "litrePerMinuteKelvin", label: "litre per minute kelvin", symbol: "l/(min·K)", code: "G67", referenceUnit: null, conversionFactor: null, quantityKinds: [ "volumeFlowRate" ] },
        "litrePerMole": { name: "litrePerMole", label: "litre per mole", symbol: "l/mol", code: "B58", referenceUnit: function() { return samm.units["cubicMetrePerMole"] }, conversionFactor: "10⁻³ m³/mol", quantityKinds: [ "molarVolume", "molarVolume" ] },
        "litrePerSecond": { name: "litrePerSecond", label: "litre per second", symbol: "l/s", code: "G51", referenceUnit: null, conversionFactor: null, quantityKinds: [ "volumeFlowRate" ] },
        "litrePerSecondBar": { name: "litrePerSecondBar", label: "litre per second bar", symbol: "l/(s·bar)", code: "G85", referenceUnit: null, conversionFactor: null, quantityKinds: [ "volumeFlowRate" ] },
        "litrePerSecondKelvin": { name: "litrePerSecondKelvin", label: "litre per second kelvin", symbol: "l/(s·K)", code: "G68", referenceUnit: null, conversionFactor: null, quantityKinds: [ "volumeFlowRate" ] },
        "load": { name: "load", label: "load", symbol: null, code: "NL", referenceUnit: null, conversionFactor: null, quantityKinds: null },
        "lotUnitOfProcurement": { name: "lotUnitOfProcurement", label: "lot  [unit of procurement]", symbol: null, code: "LO", referenceUnit: null, conversionFactor: null, quantityKinds: null },
        "lotUnitOfWeight": { name: "lotUnitOfWeight", label: "lot  [unit of weight]", symbol: null, code: "D04", referenceUnit: null, conversionFactor: null, quantityKinds: null },
        "lumen": { name: "lumen", label: "lumen", symbol: "lm", code: "LUM", referenceUnit: null, conversionFactor: null, quantityKinds: [ "luminousFlux" ] },
        "lumenHour": { name: "lumenHour", label: "lumen hour", symbol: "lm·h", code: "B59", referenceUnit: null, conversionFactor: null, quantityKinds: [ "quantityOfLight" ] },
        "lumenPerSquareFoot": { name: "lumenPerSquareFoot", label: "lumen per square foot", symbol: "lm/ft²", code: "P25", referenceUnit: null, conversionFactor: null, quantityKinds: [ "illuminance" ] },
        "lumenPerSquareMetre": { name: "lumenPerSquareMetre", label: "lumen per square metre", symbol: "lm/m²", code: "B60", referenceUnit: null, conversionFactor: null, quantityKinds: [ "luminousExitance" ] },
        "lumenPerWatt": { name: "lumenPerWatt", label: "lumen per watt", symbol: "lm/W", code: "B61", referenceUnit: null, conversionFactor: null, quantityKinds: [ "spectralLuminousEfficacy", "maximumSpectralLuminousEfficacy", "luminousEfficacyAtASpecifiedWavelength", "luminiousEfficacy" ] },
        "lumenSecond": { name: "lumenSecond", label: "lumen second", symbol: "lm·s", code: "B62", referenceUnit: null, conversionFactor: null, quantityKinds: [ "quantityOfLight" ] },
        "lumpSum": { name: "lumpSum", label: "lump sum", symbol: null, code: "LS", referenceUnit: null, conversionFactor: null, quantityKinds: null },
        "lux": { name: "lux", label: "lux", symbol: "lx", code: "LUX", referenceUnit: null, conversionFactor: null, quantityKinds: [ "illuminance" ] },
        "luxHour": { name: "luxHour", label: "lux hour", symbol: "lx·h", code: "B63", referenceUnit: null, conversionFactor: null, quantityKinds: [ "lightExposure" ] },
        "luxSecond": { name: "luxSecond", label: "lux second", symbol: "lx·s", code: "B64", referenceUnit: null, conversionFactor: null, quantityKinds: [ "lightExposure" ] },
        "manmonth": { name: "manmonth", label: "manmonth", symbol: null, code: "3C", referenceUnit: null, conversionFactor: null, quantityKinds: null },
        "meal": { name: "meal", label: "meal", symbol: null, code: "Q3", referenceUnit: null, conversionFactor: null, quantityKinds: null },
        "mebibit": { name: "mebibit", label: "mebibit", symbol: "Mibit", code: "D11", referenceUnit: null, conversionFactor: null, quantityKinds: null },
        "mebibitPerCubicMetre": { name: "mebibitPerCubicMetre", label: "mebibit per cubic metre", symbol: "Mibit/m³", code: "E77", referenceUnit: null, conversionFactor: null, quantityKinds: null },
        "mebibitPerMetre": { name: "mebibitPerMetre", label: "mebibit per metre", symbol: "Mibit/m", code: "E75", referenceUnit: null, conversionFactor: null, quantityKinds: null },
        "mebibitPerSquareMetre": { name: "mebibitPerSquareMetre", label: "mebibit per square metre", symbol: "Mibit/m²", code: "E76", referenceUnit: null, conversionFactor: null, quantityKinds: null },
        "mebibyte": { name: "mebibyte", label: "mebibyte", symbol: "Mibyte", code: "E63", referenceUnit: function() { return samm.units["byte"] }, conversionFactor: "2²⁰ B", quantityKinds: [ "informationEntropy", "informationEntropy" ] },
        "megaampere": { name: "megaampere", label: "megaampere", symbol: "MA", code: "H38", referenceUnit: function() { return samm.units["ampere"] }, conversionFactor: "10⁶ A", quantityKinds: [ "magnetomotiveForce", "currentLinkage", "magneticPotentialDifference", "electricCurrent", "magnetomotiveForce", "magneticPotentialDifference", "electricCurrent", "currentLinkage" ] },
        "megaamperePerSquareMetre": { name: "megaamperePerSquareMetre", label: "megaampere per square metre", symbol: "MA/m²", code: "B66", referenceUnit: function() { return samm.units["amperePerSquareMetre"] }, conversionFactor: "10⁶ A/m²", quantityKinds: [ "currentDensity", "currentDensity" ] },
        "megabaud": { name: "megabaud", label: "megabaud", symbol: "MBd", code: "J54", referenceUnit: function() { return samm.units["baud"] }, conversionFactor: "10⁶ Bd", quantityKinds: null },
        "megabecquerel": { name: "megabecquerel", label: "megabecquerel", symbol: "MBq", code: "4N", referenceUnit: function() { return samm.units["becquerel"] }, conversionFactor: "10⁶ Bq", quantityKinds: [ "activity", "activity" ] },
        "megabecquerelPerKilogram": { name: "megabecquerelPerKilogram", label: "megabecquerel per kilogram", symbol: "MBq/kg", code: "B67", referenceUnit: function() { return samm.units["becquerelPerKilogram"] }, conversionFactor: "10⁶ Bq/kg", quantityKinds: [ "specificActivityInASample", "specificActivityInASample" ] },
        "megabit": { name: "megabit", label: "megabit", symbol: "Mbit", code: "D36", referenceUnit: null, conversionFactor: null, quantityKinds: null },
        "megabitPerSecond": { name: "megabitPerSecond", label: "megabit per second", symbol: "Mbit/s", code: "E20", referenceUnit: null, conversionFactor: null, quantityKinds: null },
        "megabyte": { name: "megabyte", label: "Megabyte", symbol: "MB", code: "4L", referenceUnit: function() { return samm.units["byte"] }, conversionFactor: "10⁶ B", quantityKinds: [ "informationEntropy", "informationEntropy" ] },
        "megabytePerSecond": { name: "megabytePerSecond", label: "megabyte per second", symbol: "Mbyte/s", code: "P95", referenceUnit: function() { return samm.units["bytePerSecond"] }, conversionFactor: "10⁶ byte/s", quantityKinds: null },
        "megacoulomb": { name: "megacoulomb", label: "megacoulomb", symbol: "MC", code: "D77", referenceUnit: function() { return samm.units["coulomb"] }, conversionFactor: "10⁶ C", quantityKinds: [ "elementaryCharge", "electricFluxFluxOfDisplacement", "electricCharge", "quantityOfElectricity", "quantityOfElectricity", "electricFluxFluxOfDisplacement", "electricCharge" ] },
        "megacoulombPerCubicMetre": { name: "megacoulombPerCubicMetre", label: "megacoulomb per cubic metre", symbol: "MC/m³", code: "B69", referenceUnit: function() { return samm.units["coulombPerCubicMetre"] }, conversionFactor: "10⁶ C/m³", quantityKinds: [ "volumicCharge", "volumeDensityOfCharge", "chargeDensity", "volumicCharge", "volumeDensityOfCharge", "chargeDensity" ] },
        "megacoulombPerSquareMetre": { name: "megacoulombPerSquareMetre", label: "megacoulomb per square metre", symbol: "MC/m²", code: "B70", referenceUnit: function() { return samm.units["coulombPerSquareMetre"] }, conversionFactor: "10⁶ C/m²", quantityKinds: [ "electricFluxDensity", "displacementElectricPolarization", "surfaceDensityOfCharge", "surfaceDensityOfCharge", "electricFluxDensity", "displacementElectricPolarization" ] },
        "megaelectronvolt": { name: "megaelectronvolt", label: "megaelectronvolt", symbol: "MeV", code: "B71", referenceUnit: function() { return samm.units["electronvolt"] }, conversionFactor: "10⁶ eV", quantityKinds: [ "energy", "kineticEnergy", "work", "potentialEnergy", "maximumBetaParticleEnergy", "fermiEnergy", "potentialEnergy", "work", "kineticEnergy", "resonanceEnergy", "betaDisintegrationEnergy", "energy" ] },
        "megagram": { name: "megagram", label: "megagram", symbol: "Mg", code: "2U", referenceUnit: function() { return samm.units["kilogram"] }, conversionFactor: "10³ kg", quantityKinds: [ "mass", "massOfAtomOfANuclideX", "massOfMolecule", "effectiveMass", "mass", "nuclidicMass", "massExcess" ] },
        "megagramPerCubicMetre": { name: "megagramPerCubicMetre", label: "megagram per cubic metre", symbol: "Mg/m³", code: "B72", referenceUnit: function() { return samm.units["kilogramPerCubicMetre"] }, conversionFactor: "10³ kg/m³", quantityKinds: [ "massDensity", "volumicMass", "density", "amountOfSubstance", "massDensity", "density", "concentrationOfB", "massConcentrationOfB", "volumicMass" ] },
        "megahertz": { name: "megahertz", label: "megahertz", symbol: "MHz", code: "MHZ", referenceUnit: function() { return samm.units["hertz"] }, conversionFactor: "10⁶ Hz", quantityKinds: [ "frequency", "frequency" ] },
        "megahertzKilometre": { name: "megahertzKilometre", label: "megahertz kilometre", symbol: "MHz·km", code: "H39", referenceUnit: function() { return samm.units["hertzMetre"] }, conversionFactor: "10⁹ Hz × m", quantityKinds: [ "coefficient", "performanceCharacteristic", "performanceCharacteristic", "coefficient" ] },
        "megahertzMetre": { name: "megahertzMetre", label: "megahertz metre", symbol: "MHz·m", code: "M27", referenceUnit: function() { return samm.units["hertzMetre"] }, conversionFactor: "10⁶ Hz × m", quantityKinds: [ "performanceCharacteristic", "coefficient", "performanceCharacteristic", "coefficient" ] },
        "megajoule": { name: "megajoule", label: "megajoule", symbol: "MJ", code: "3B", referenceUnit: function() { return samm.units["joule"] }, conversionFactor: "10⁶ J", quantityKinds: [ "quantityOfHeat", "reactionEnergy", "workFunction", "activeEnergy", "kineticEnergy", "levelWidth", "meanEnergyImparted", "helmholtzFunction", "radiantEnergy", "potentialEnergy", "energy", "thermodynamicEnergy", "helmholtzFreeEnergy", "work", "heat", "hartreeEnergy", "energyImparted", "enthalpy", "alphaDisintegrationEnergy", "kineticEnergy", "work", "energy", "potentialEnergy" ] },
        "megajoulePerCubicMetre": { name: "megajoulePerCubicMetre", label: "megajoule per cubic metre", symbol: "MJ/m³", code: "JM", referenceUnit: function() { return samm.units["joulePerCubicMetre"] }, conversionFactor: "10⁶ J/m³", quantityKinds: [ "radiantEnergyDensity", "soundEnergy", "volumic", "volumicElectromagneticEnergy", "soundEnergyDensity", "radiantEnergyDensity", "electromagneticEnergyDensity" ] },
        "megajoulePerKilogram": { name: "megajoulePerKilogram", label: "megajoule per kilogram", symbol: "MJ/kg", code: "JK", referenceUnit: function() { return samm.units["joulePerKilogram"] }, conversionFactor: "10⁶ J/kg", quantityKinds: [ "specificThermodynamicEnergy", "specificEnergy", "massicEnergy" ] },
        "megajoulePerSecond": { name: "megajoulePerSecond", label: "megajoule per second", symbol: "MJ/s", code: "D78", referenceUnit: null, conversionFactor: null, quantityKinds: null },
        "megalitre": { name: "megalitre", label: "megalitre", symbol: "Ml", code: "MAL", referenceUnit: function() { return samm.units["cubicMetre"] }, conversionFactor: "10³ m³", quantityKinds: [ "volume", "sectionModulus", "volume" ] },
        "megametre": { name: "megametre", label: "megametre", symbol: "Mm", code: "MAM", referenceUnit: function() { return samm.units["metre"] }, conversionFactor: "10⁶ m", quantityKinds: [ "thickness", "particlePositionVector", "cartesianCoordinates", "focalDistance", "radius", "radiusOfCurvature", "displacementVectorOfIonOrAtom", "lengthOfPath", "diameter", "comptonWavelength", "slowingDownLength", "migrationLength", "meanFreePath", "equilibriumPositionVectorOfIonOrAtom", "instantaneousSoundParticleDisplacement", "imageDistance", "breadth", "length", "halfValueThickness", "coherenceLength", "latticeVector", "londonPenetrationDepth", "diffusionLength", "meanFreePathOfPhononsOrElectrons", "diffusionCoefficientForNeutronFluxDensity", "halfThickness", "height", "electronRadius", "distance", "objectDistance", "bohrRadius", "diffusionCoefficientForNeutronFluenceRate", "nuclearRadius", "wavelength", "fundamentalLatticeVector", "meanLinearRange", "height", "cartesianCoordinates", "breadth", "lengthOfPath", "radiusOfCurvature", "thickness", "diameter", "distance", "radius", "length" ] },
        "meganewton": { name: "meganewton", label: "meganewton", symbol: "MN", code: "B73", referenceUnit: function() { return samm.units["newton"] }, conversionFactor: "10⁶ N", quantityKinds: [ "weight", "force", "force", "weight" ] },
        "meganewtonMetre": { name: "meganewtonMetre", label: "meganewton metre", symbol: "MN·m", code: "B74", referenceUnit: function() { return samm.units["newtonMetre"] }, conversionFactor: "10⁶ N × m", quantityKinds: [ "momentOfForce", "momentOfACouple", "torque", "torque", "momentOfForce", "momentOfACouple" ] },
        "megaohm": { name: "megaohm", label: "megaohm", symbol: "MΩ", code: "B75", referenceUnit: function() { return samm.units["ohm"] }, conversionFactor: "10⁶ Ω", quantityKinds: [ "impedance", "reactance", "modulusOfImpedance", "resistanceToDirectCurrent", "complexImpedances", "resistanceToAlternatingCurrent", "resistanceToAlternatingCurrent", "modulusOfImpedance", "resistanceToDirectCurrent", "complexImpedances", "reactance", "impedance" ] },
        "megaohmKilometre": { name: "megaohmKilometre", label: "megaohm kilometre", symbol: "MΩ·km", code: "H88", referenceUnit: function() { return samm.units["ohmMetre"] }, conversionFactor: "10⁹ Ω × m", quantityKinds: [ "resistivity", "resistivity", "residualResistivity" ] },
        "megaohmMetre": { name: "megaohmMetre", label: "megaohm metre", symbol: "MΩ·m", code: "B76", referenceUnit: function() { return samm.units["ohmMetre"] }, conversionFactor: "10⁶ Ω × m", quantityKinds: [ "resistivity", "residualResistivity", "resistivity" ] },
        "megaohmPerKilometre": { name: "megaohmPerKilometre", label: "megaohm per kilometre", symbol: "MΩ/km", code: "H36", referenceUnit: function() { return samm.units["ohmPerMetre"] }, conversionFactor: "10³ Ω/m", quantityKinds: [ "lineicResistance", "lineicResistance" ] },
        "megaohmPerMetre": { name: "megaohmPerMetre", label: "megaohm per metre", symbol: "MΩ/m", code: "H37", referenceUnit: function() { return samm.units["ohmPerMetre"] }, conversionFactor: "10⁶ Ω/m", quantityKinds: [ "lineicResistance", "lineicResistance" ] },
        "megapascal": { name: "megapascal", label: "megapascal", symbol: "MPa", code: "MPA", referenceUnit: function() { return samm.units["pascal"] }, conversionFactor: "10⁶ Pa", quantityKinds: [ "modulusOfCompression", "normalStress", "pressure", "shearModulus", "shearStress", "bulkModulus", "modulusOfElasticity", "modulusOfRigidity", "fugacityOfBInAGaseousMixture", "pressure", "shearModulus", "staticPressure", "normalStress", "modulusOfRigidity", "instantaneousSoundPressure", "modulusOfElasticity", "shearStress", "modulusOfCompression", "partialPressureOfBInAGaseousMixture", "bulkModulus", "osmoticPressure" ] },
        "megapascalCubicMetrePerSecond": { name: "megapascalCubicMetrePerSecond", label: "megapascal cubic metre per second", symbol: "MPa·m³/s", code: "F98", referenceUnit: null, conversionFactor: null, quantityKinds: [ "pressure", "modulusOfCompression", "modulusOfRigidity", "bulkModulus", "normalStress", "shearStress", "shearModulus", "modulusOfElasticity" ] },
        "megapascalLitrePerSecond": { name: "megapascalLitrePerSecond", label: "megapascal litre per second", symbol: "MPa·l/s", code: "F97", referenceUnit: null, conversionFactor: null, quantityKinds: [ "modulusOfRigidity", "normalStress", "shearStress", "pressure", "bulkModulus", "modulusOfElasticity", "shearModulus", "modulusOfCompression" ] },
        "megapascalPerBar": { name: "megapascalPerBar", label: "megapascal per bar", symbol: "MPa/bar", code: "F05", referenceUnit: null, conversionFactor: null, quantityKinds: [ "pressureRatio" ] },
        "megapascalPerKelvin": { name: "megapascalPerKelvin", label: "megapascal per kelvin", symbol: "MPa/K", code: "F85", referenceUnit: null, conversionFactor: null, quantityKinds: [ "bulkModulus", "shearModulus", "modulusOfCompression", "pressure", "normalStress", "modulusOfRigidity", "shearStress", "modulusOfElasticity" ] },
        "megapixel": { name: "megapixel", label: "megapixel", symbol: null, code: "E38", referenceUnit: null, conversionFactor: null, quantityKinds: null },
        "megasiemensPerMetre": { name: "megasiemensPerMetre", label: "megasiemens per metre", symbol: "MS/m", code: "B77", referenceUnit: function() { return samm.units["siemensPerMetre"] }, conversionFactor: "10⁶ S/m", quantityKinds: [ "electrolyticConductivity", "conductivity", "conductivity" ] },
        "megavar": { name: "megavar", label: "megavar", symbol: "kvar", code: "MAR", referenceUnit: function() { return samm.units["voltAmpere"] }, conversionFactor: "10³ V × A", quantityKinds: [ "reactivePower", "apparentPower" ] },
        "megavolt": { name: "megavolt", label: "megavolt", symbol: "MV", code: "B78", referenceUnit: function() { return samm.units["volt"] }, conversionFactor: "10⁶ V", quantityKinds: [ "tension", "voltage", "peltierCoefficientForSubstancesAAndB", "electromotiveForce", "thermoelectromotiveForceBetweenSubstancesAAndB", "potentialDifference", "electricPotential", "electromotiveForce", "voltage", "tension", "electricPotential", "potentialDifference" ] },
        "megavoltAmpere": { name: "megavoltAmpere", label: "megavolt - ampere", symbol: "MV·A", code: "MVA", referenceUnit: function() { return samm.units["voltAmpere"] }, conversionFactor: "10⁶ V × A", quantityKinds: [ "apparentPower", "apparentPower" ] },
        "megavoltAmpereReactiveHour": { name: "megavoltAmpereReactiveHour", label: "megavolt ampere reactive hour", symbol: "Mvar·h", code: "MAH", referenceUnit: null, conversionFactor: null, quantityKinds: null },
        "megavoltPerMetre": { name: "megavoltPerMetre", label: "megavolt per metre", symbol: "MV/m", code: "B79", referenceUnit: function() { return samm.units["voltPerMetre"] }, conversionFactor: "10⁶ V/m", quantityKinds: [ "electricFieldStrength", "electricFieldStrength" ] },
        "megawatt": { name: "megawatt", label: "megawatt", symbol: "MW", code: "MAW", referenceUnit: function() { return samm.units["watt"] }, conversionFactor: "10⁶ W", quantityKinds: [ "radiantEnergyflux", "activePower", "heatFlowRate", "soundPower", "power", "radiantPower", "powerForDirectCurrent", "powerForDirectCurrent", "power", "activePower" ] },
        "megawattHour1000Kwh": { name: "megawattHour1000Kwh", label: "megawatt hour (1000 kW.h)", symbol: "MW·h", code: "MWH", referenceUnit: function() { return samm.units["joule"] }, conversionFactor: "3.6 × 10⁹ J", quantityKinds: [ "quantityOfHeat", "reactionEnergy", "workFunction", "activeEnergy", "kineticEnergy", "levelWidth", "meanEnergyImparted", "helmholtzFunction", "radiantEnergy", "potentialEnergy", "energy", "thermodynamicEnergy", "helmholtzFreeEnergy", "work", "heat", "hartreeEnergy", "energyImparted", "enthalpy", "alphaDisintegrationEnergy", "work", "kineticEnergy", "energy", "potentialEnergy" ] },
        "megawattHourPerHour": { name: "megawattHourPerHour", label: "megawatt hour per hour", symbol: "MW·h/h", code: "E07", referenceUnit: null, conversionFactor: null, quantityKinds: null },
        "megawattPerHertz": { name: "megawattPerHertz", label: "megawatt per hertz", symbol: "MW/Hz", code: "E08", referenceUnit: null, conversionFactor: null, quantityKinds: null },
        "mesh": { name: "mesh", label: "mesh", symbol: null, code: "57", referenceUnit: null, conversionFactor: null, quantityKinds: null },
        "message": { name: "message", label: "message", symbol: null, code: "NF", referenceUnit: null, conversionFactor: null, quantityKinds: null },
        "metre": { name: "metre", label: "metre", symbol: "m", code: "MTR", referenceUnit: null, conversionFactor: null, quantityKinds: [ "thickness", "particlePositionVector", "cartesianCoordinates", "focalDistance", "radius", "radiusOfCurvature", "displacementVectorOfIonOrAtom", "lengthOfPath", "diameter", "comptonWavelength", "slowingDownLength", "migrationLength", "meanFreePath", "equilibriumPositionVectorOfIonOrAtom", "instantaneousSoundParticleDisplacement", "imageDistance", "breadth", "length", "halfValueThickness", "coherenceLength", "latticeVector", "londonPenetrationDepth", "diffusionLength", "meanFreePathOfPhononsOrElectrons", "diffusionCoefficientForNeutronFluxDensity", "halfThickness", "height", "electronRadius", "distance", "objectDistance", "bohrRadius", "diffusionCoefficientForNeutronFluenceRate", "nuclearRadius", "wavelength", "fundamentalLatticeVector", "meanLinearRange" ] },
        "metreKelvin": { name: "metreKelvin", label: "metre kelvin", symbol: "m·K", code: "D18", referenceUnit: null, conversionFactor: null, quantityKinds: [ "secondRadiationConstant" ] },
        "metrePerBar": { name: "metrePerBar", label: "metre per bar", symbol: "m/bar", code: "G05", referenceUnit: null, conversionFactor: null, quantityKinds: [ "radius", "height", "breadth", "distance", "lengthOfPath", "length", "thickness", "cartesianCoordinates", "diameter", "radiusOfCurvature" ] },
        "metrePerDegreeCelsiusMetre": { name: "metrePerDegreeCelsiusMetre", label: "metre per degree Celsius metre", symbol: "m/(°C·m)", code: "N83", referenceUnit: function() { return samm.units["reciprocalKelvinOrKelvinToThePowerMinusOne"] }, conversionFactor: "K⁻¹", quantityKinds: [ "relativePressureCoefficient", "linearExpansionCoefficient", "cubicExpansionCoefficient", "thermalDiffusivity" ] },
        "metrePerHour": { name: "metrePerHour", label: "metre per hour", symbol: "m/h", code: "M60", referenceUnit: function() { return samm.units["metrePerSecond"] }, conversionFactor: "2.77778 × 10⁻⁴ m/s", quantityKinds: [ "groupVelocity", "velocityOfSoundPhaseVelocity", "phaseVelocity", "neutronSpeed", "phaseSpeedOfElectromagneticWaves", "velocity", "velocitySpeedOnPropagationOfElectromagneticWavesInVacuo", "instantaneousSoundParticleVelocity", "phaseVelocityOfElectromagneticWaves", "groupVelocity", "velocity", "phaseVelocity" ] },
        "metrePerKelvin": { name: "metrePerKelvin", label: "metre per kelvin", symbol: "m/K", code: "F52", referenceUnit: null, conversionFactor: null, quantityKinds: [ "thickness", "length", "lengthOfPath", "distance", "radius", "diameter", "breadth", "cartesianCoordinates", "radiusOfCurvature", "height" ] },
        "metrePerMinute": { name: "metrePerMinute", label: "metre per minute", symbol: "m/min", code: "2X", referenceUnit: function() { return samm.units["metrePerSecond"] }, conversionFactor: "0.016666 m/s", quantityKinds: [ "velocity", "phaseVelocity", "groupVelocity", "groupVelocity", "velocityOfSoundPhaseVelocity", "phaseVelocity", "neutronSpeed", "phaseSpeedOfElectromagneticWaves", "velocity", "velocitySpeedOnPropagationOfElectromagneticWavesInVacuo", "instantaneousSoundParticleVelocity", "phaseVelocityOfElectromagneticWaves" ] },
        "metrePerPascal": { name: "metrePerPascal", label: "metre per pascal", symbol: "m/Pa", code: "M53", referenceUnit: null, conversionFactor: null, quantityKinds: [ "cartesianCoordinates", "radius", "lengthOfPath", "diameter", "radiusOfCurvature", "height", "length", "breadth", "distance", "thickness" ] },
        "metrePerRadiant": { name: "metrePerRadiant", label: "metre per radiant", symbol: "m/rad", code: "M55", referenceUnit: null, conversionFactor: null, quantityKinds: [ "solidAngle" ] },
        "metrePerSecond": { name: "metrePerSecond", label: "metre per second", symbol: "m/s", code: "MTS", referenceUnit: null, conversionFactor: null, quantityKinds: [ "groupVelocity", "velocityOfSoundPhaseVelocity", "phaseVelocity", "neutronSpeed", "phaseSpeedOfElectromagneticWaves", "velocity", "velocitySpeedOnPropagationOfElectromagneticWavesInVacuo", "instantaneousSoundParticleVelocity", "phaseVelocityOfElectromagneticWaves" ] },
        "metrePerSecondBar": { name: "metrePerSecondBar", label: "metre per second bar", symbol: "(m/s)/bar", code: "L13", referenceUnit: function() { return samm.units["metrePerSecondPascal"] }, conversionFactor: "10⁻⁵ (m/s)/Pa", quantityKinds: [ "velocity", "phaseVelocity", "groupVelocity", "velocity", "phaseVelocity", "groupVelocity" ] },
        "metrePerSecondKelvin": { name: "metrePerSecondKelvin", label: "metre per second kelvin", symbol: "(m/s)/K", code: "L12", referenceUnit: null, conversionFactor: null, quantityKinds: [ "velocity", "phaseVelocity", "groupVelocity" ] },
        "metrePerSecondPascal": { name: "metrePerSecondPascal", label: "metre per second pascal", symbol: "(m/s)/Pa", code: "M59", referenceUnit: null, conversionFactor: null, quantityKinds: [ "velocity", "phaseVelocity", "groupVelocity" ] },
        "metrePerSecondSquared": { name: "metrePerSecondSquared", label: "metre per second squared", symbol: "m/s²", code: "MSK", referenceUnit: null, conversionFactor: null, quantityKinds: [ "acceleration", "instantaneousSoundParticleAcceleration", "accelerationOfFreeFall", "accelerationDueToGravity" ] },
        "metrePerVoltSecond": { name: "metrePerVoltSecond", label: "metre per volt second", symbol: "m/(V·s)", code: "H58", referenceUnit: null, conversionFactor: null, quantityKinds: [ "mobility" ] },
        "metreToTheFourthPower": { name: "metreToTheFourthPower", label: "metre to the fourth power", symbol: "m⁴", code: "B83", referenceUnit: null, conversionFactor: null, quantityKinds: [ "secondMomentOfArea", "secondAxialMomentOfArea" ] },
        "metricCarat": { name: "metricCarat", label: "metric carat", symbol: null, code: "CTM", referenceUnit: function() { return samm.units["milligram"] }, conversionFactor: "200 mg", quantityKinds: [ "mass" ] },
        "metricTonIncludingContainer": { name: "metricTonIncludingContainer", label: "metric ton, including container", symbol: null, code: "TIC", referenceUnit: null, conversionFactor: null, quantityKinds: null },
        "metricTonIncludingInnerPackaging": { name: "metricTonIncludingInnerPackaging", label: "metric ton, including inner packaging", symbol: null, code: "TIP", referenceUnit: null, conversionFactor: null, quantityKinds: null },
        "metricTonLubricatingOil": { name: "metricTonLubricatingOil", label: "metric ton, lubricating oil", symbol: null, code: "LUB", referenceUnit: null, conversionFactor: null, quantityKinds: null },
        "microInch": { name: "microInch", label: "micro-inch", symbol: "µin", code: "M7", referenceUnit: function() { return samm.units["metre"] }, conversionFactor: "25.4 × 10⁻⁹ m", quantityKinds: [ "thickness", "particlePositionVector", "cartesianCoordinates", "focalDistance", "radius", "radiusOfCurvature", "displacementVectorOfIonOrAtom", "lengthOfPath", "diameter", "comptonWavelength", "slowingDownLength", "migrationLength", "meanFreePath", "equilibriumPositionVectorOfIonOrAtom", "instantaneousSoundParticleDisplacement", "imageDistance", "breadth", "length", "halfValueThickness", "coherenceLength", "latticeVector", "londonPenetrationDepth", "diffusionLength", "meanFreePathOfPhononsOrElectrons", "diffusionCoefficientForNeutronFluxDensity", "halfThickness", "height", "electronRadius", "distance", "objectDistance", "bohrRadius", "diffusionCoefficientForNeutronFluenceRate", "nuclearRadius", "wavelength", "fundamentalLatticeVector", "meanLinearRange", "radius", "cartesianCoordinates", "lengthOfPath", "distance", "length", "diameter", "radiusOfCurvature", "thickness", "breadth", "height" ] },
        "microampere": { name: "microampere", label: "microampere", symbol: "µA", code: "B84", referenceUnit: function() { return samm.units["ampere"] }, conversionFactor: "10⁻⁶ A", quantityKinds: [ "magnetomotiveForce", "currentLinkage", "magneticPotentialDifference", "electricCurrent", "electricCurrent", "magneticPotentialDifference", "currentLinkage", "magnetomotiveForce" ] },
        "microbar": { name: "microbar", label: "microbar", symbol: "µbar", code: "B85", referenceUnit: function() { return samm.units["pascal"] }, conversionFactor: "10⁻¹ Pa", quantityKinds: [ "normalStress", "modulusOfCompression", "modulusOfRigidity", "shearModulus", "pressure", "shearStress", "modulusOfElasticity", "bulkModulus", "fugacityOfBInAGaseousMixture", "pressure", "shearModulus", "staticPressure", "normalStress", "modulusOfRigidity", "instantaneousSoundPressure", "modulusOfElasticity", "shearStress", "modulusOfCompression", "partialPressureOfBInAGaseousMixture", "bulkModulus", "osmoticPressure" ] },
        "microbecquerel": { name: "microbecquerel", label: "microbecquerel", symbol: "µBq", code: "H08", referenceUnit: function() { return samm.units["becquerel"] }, conversionFactor: "10⁻⁶ Bq", quantityKinds: [ "activity", "activity" ] },
        "microcoulomb": { name: "microcoulomb", label: "microcoulomb", symbol: "µC", code: "B86", referenceUnit: function() { return samm.units["coulomb"] }, conversionFactor: "10⁻⁶ C", quantityKinds: [ "quantityOfElectricity", "electricFluxFluxOfDisplacement", "electricCharge", "elementaryCharge", "electricFluxFluxOfDisplacement", "electricCharge", "quantityOfElectricity" ] },
        "microcoulombPerCubicMetre": { name: "microcoulombPerCubicMetre", label: "microcoulomb per cubic metre", symbol: "µC/m³", code: "B87", referenceUnit: function() { return samm.units["coulombPerCubicMetre"] }, conversionFactor: "10⁻⁶ C/m³", quantityKinds: [ "volumeDensityOfCharge", "volumicCharge", "chargeDensity", "volumicCharge", "volumeDensityOfCharge", "chargeDensity" ] },
        "microcoulombPerSquareMetre": { name: "microcoulombPerSquareMetre", label: "microcoulomb per square metre", symbol: "µC/m²", code: "B88", referenceUnit: function() { return samm.units["coulombPerSquareMetre"] }, conversionFactor: "10⁻⁶ C/m²", quantityKinds: [ "electricFluxDensity", "surfaceDensityOfCharge", "displacementElectricPolarization", "surfaceDensityOfCharge", "electricFluxDensity", "displacementElectricPolarization" ] },
        "microcurie": { name: "microcurie", label: "microcurie", symbol: "µCi", code: "M5", referenceUnit: function() { return samm.units["becquerel"] }, conversionFactor: "3.7 × 10⁴ Bq", quantityKinds: [ "activity", "activity" ] },
        "microfarad": { name: "microfarad", label: "microfarad", symbol: "µF", code: "4O", referenceUnit: function() { return samm.units["farad"] }, conversionFactor: "10⁻⁶ F", quantityKinds: [ "capacitance", "capacitance" ] },
        "microfaradPerKilometre": { name: "microfaradPerKilometre", label: "microfarad per kilometre", symbol: "µF/km", code: "H28", referenceUnit: function() { return samm.units["faradPerMetre"] }, conversionFactor: "10⁻⁹ F/m", quantityKinds: [ "electricConstant", "permittivity", "permittivityOfVacuum", "permittivityOfVacuum", "permittivity", "electricConstant" ] },
        "microfaradPerMetre": { name: "microfaradPerMetre", label: "microfarad per metre", symbol: "µF/m", code: "B89", referenceUnit: function() { return samm.units["faradPerMetre"] }, conversionFactor: "10⁻⁶ F/m", quantityKinds: [ "permittivityOfVacuum", "permittivity", "electricConstant", "electricConstant", "permittivity", "permittivityOfVacuum" ] },
        "microgram": { name: "microgram", label: "microgram", symbol: "µg", code: "MC", referenceUnit: function() { return samm.units["kilogram"] }, conversionFactor: "10⁻⁹ kg", quantityKinds: [ "massOfAtomOfANuclideX", "massOfMolecule", "effectiveMass", "mass", "nuclidicMass", "massExcess", "mass" ] },
        "microgramPerCubicMetre": { name: "microgramPerCubicMetre", label: "microgram per cubic metre", symbol: "µg/m³", code: "GQ", referenceUnit: function() { return samm.units["kilogramPerCubicMetre"] }, conversionFactor: "10⁻⁹ kg/m³", quantityKinds: [ "volumicMass", "density", "massDensity", "amountOfSubstance", "massDensity", "density", "concentrationOfB", "massConcentrationOfB", "volumicMass" ] },
        "microgramPerCubicMetreBar": { name: "microgramPerCubicMetreBar", label: "microgram per cubic metre bar", symbol: "(µg/m³)/bar", code: "J35", referenceUnit: function() { return samm.units["kilogramPerCubicMetrePascal"] }, conversionFactor: "10⁻¹⁴ (kg/m³)/Pa", quantityKinds: [ "volumicMass", "massDensity", "density", "density", "massDensity", "volumicMass" ] },
        "microgramPerCubicMetreKelvin": { name: "microgramPerCubicMetreKelvin", label: "microgram per cubic metre kelvin", symbol: "(µg/m³)/K", code: "J34", referenceUnit: null, conversionFactor: null, quantityKinds: [ "volumicMass", "massDensity", "density" ] },
        "microgramPerKilogram": { name: "microgramPerKilogram", label: "microgram per kilogram", symbol: "µg/kg", code: "J33", referenceUnit: null, conversionFactor: null, quantityKinds: [ "massRatio" ] },
        "microgramPerLitre": { name: "microgramPerLitre", label: "microgram per litre", symbol: "µg/l", code: "H29", referenceUnit: null, conversionFactor: null, quantityKinds: [ "volumicMass", "massDensity", "density" ] },
        "micrograyPerHour": { name: "micrograyPerHour", label: "microgray per hour", symbol: "µGy/h", code: "P63", referenceUnit: function() { return samm.units["grayPerSecond"] }, conversionFactor: "2.77778 × 10⁻¹⁰ Gy/s", quantityKinds: [ "absorbedDoseRate", "absorbedDoseRate" ] },
        "micrograyPerMinute": { name: "micrograyPerMinute", label: "microgray per minute", symbol: "µGy/min", code: "P59", referenceUnit: function() { return samm.units["grayPerSecond"] }, conversionFactor: "1.66667 × 10⁻⁸ Gy/s", quantityKinds: [ "absorbedDoseRate", "absorbedDoseRate" ] },
        "micrograyPerSecond": { name: "micrograyPerSecond", label: "microgray per second", symbol: "µGy/s", code: "P55", referenceUnit: function() { return samm.units["grayPerSecond"] }, conversionFactor: "10⁻⁶ Gy/s", quantityKinds: [ "absorbedDoseRate", "absorbedDoseRate" ] },
        "microhenry": { name: "microhenry", label: "microhenry", symbol: "µH", code: "B90", referenceUnit: function() { return samm.units["henry"] }, conversionFactor: "10⁻⁶ H", quantityKinds: [ "mutualInductance", "permeance", "selfInductance", "selfInductance", "permeance", "mutualInductance" ] },
        "microhenryPerKiloohm": { name: "microhenryPerKiloohm", label: "microhenry per kiloohm", symbol: "µH/kΩ", code: "G98", referenceUnit: function() { return samm.units["secondUnitOfTime"] }, conversionFactor: "10⁻⁹ s", quantityKinds: [ "mutualInductance", "permeance", "selfInductance", "timeConstant", "reactorTimeConstant", "halfLife", "meanLife", "time", "relaxationTime", "period", "carrierLifeTime", "periodicTime", "reverberationTime" ] },
        "microhenryPerMetre": { name: "microhenryPerMetre", label: "microhenry per metre", symbol: "µH/m", code: "B91", referenceUnit: function() { return samm.units["henryPerMetre"] }, conversionFactor: "10⁻⁶ H/m", quantityKinds: [ "magneticConstant", "permeabilityOfVacuum", "permeability", "permeabilityOfVacuum", "permeability", "magneticConstant" ] },
        "microhenryPerOhm": { name: "microhenryPerOhm", label: "microhenry per ohm", symbol: "µH/Ω", code: "G99", referenceUnit: function() { return samm.units["secondUnitOfTime"] }, conversionFactor: "10⁻⁶ s", quantityKinds: [ "permeance", "selfInductance", "mutualInductance", "timeConstant", "reactorTimeConstant", "halfLife", "meanLife", "time", "relaxationTime", "period", "carrierLifeTime", "periodicTime", "reverberationTime" ] },
        "microlitre": { name: "microlitre", label: "microlitre", symbol: "µl", code: "4G", referenceUnit: function() { return samm.units["cubicMetre"] }, conversionFactor: "10⁻⁹ m³", quantityKinds: [ "volume", "sectionModulus", "volume" ] },
        "microlitrePerLitre": { name: "microlitrePerLitre", label: "microlitre per litre", symbol: "µl/l", code: "J36", referenceUnit: null, conversionFactor: null, quantityKinds: [ "volumeRatio" ] },
        "micrometreMicron": { name: "micrometreMicron", label: "micrometre (micron)", symbol: "µm", code: "4H", referenceUnit: function() { return samm.units["metre"] }, conversionFactor: "10⁻⁶ m", quantityKinds: [ "thickness", "particlePositionVector", "cartesianCoordinates", "focalDistance", "radius", "radiusOfCurvature", "displacementVectorOfIonOrAtom", "lengthOfPath", "diameter", "comptonWavelength", "slowingDownLength", "migrationLength", "meanFreePath", "equilibriumPositionVectorOfIonOrAtom", "instantaneousSoundParticleDisplacement", "imageDistance", "breadth", "length", "halfValueThickness", "coherenceLength", "latticeVector", "londonPenetrationDepth", "diffusionLength", "meanFreePathOfPhononsOrElectrons", "diffusionCoefficientForNeutronFluxDensity", "halfThickness", "height", "electronRadius", "distance", "objectDistance", "bohrRadius", "diffusionCoefficientForNeutronFluenceRate", "nuclearRadius", "wavelength", "fundamentalLatticeVector", "meanLinearRange", "radius", "cartesianCoordinates", "radiusOfCurvature", "height", "diameter", "lengthOfPath", "thickness", "length", "distance", "breadth" ] },
        "micrometrePerKelvin": { name: "micrometrePerKelvin", label: "micrometre per kelvin", symbol: "µm/K", code: "F50", referenceUnit: null, conversionFactor: null, quantityKinds: [ "breadth", "cartesianCoordinates", "lengthOfPath", "distance", "thickness", "radiusOfCurvature", "radius", "length", "height", "diameter" ] },
        "micromole": { name: "micromole", label: "micromole", symbol: "µmol", code: "FH", referenceUnit: function() { return samm.units["mole"] }, conversionFactor: "10⁻⁶ mol", quantityKinds: [ "amountOfSubstance", "amountOfSubstance" ] },
        "micronewton": { name: "micronewton", label: "micronewton", symbol: "µN", code: "B92", referenceUnit: function() { return samm.units["newton"] }, conversionFactor: "10⁻⁶ N", quantityKinds: [ "weight", "force", "weight", "force" ] },
        "micronewtonMetre": { name: "micronewtonMetre", label: "micronewton metre", symbol: "µN·m", code: "B93", referenceUnit: function() { return samm.units["newtonMetre"] }, conversionFactor: "10⁻⁶ N × m", quantityKinds: [ "momentOfForce", "momentOfACouple", "torque", "torque", "momentOfForce", "momentOfACouple" ] },
        "microohm": { name: "microohm", label: "microohm", symbol: "µΩ", code: "B94", referenceUnit: function() { return samm.units["ohm"] }, conversionFactor: "10⁻⁶ Ω", quantityKinds: [ "resistanceToAlternatingCurrent", "impedance", "complexImpedances", "resistanceToDirectCurrent", "modulusOfImpedance", "reactance", "impedance", "reactance", "modulusOfImpedance", "resistanceToDirectCurrent", "complexImpedances", "resistanceToAlternatingCurrent" ] },
        "microohmMetre": { name: "microohmMetre", label: "microohm metre", symbol: "µΩ·m", code: "B95", referenceUnit: function() { return samm.units["ohmMetre"] }, conversionFactor: "10⁻⁶ Ω × m", quantityKinds: [ "resistivity", "residualResistivity", "resistivity" ] },
        "micropascal": { name: "micropascal", label: "micropascal", symbol: "µPa", code: "B96", referenceUnit: function() { return samm.units["pascal"] }, conversionFactor: "10⁻⁶ Pa", quantityKinds: [ "shearModulus", "modulusOfRigidity", "shearStress", "pressure", "modulusOfElasticity", "bulkModulus", "modulusOfCompression", "normalStress", "fugacityOfBInAGaseousMixture", "pressure", "shearModulus", "staticPressure", "normalStress", "modulusOfRigidity", "instantaneousSoundPressure", "modulusOfElasticity", "shearStress", "modulusOfCompression", "partialPressureOfBInAGaseousMixture", "bulkModulus", "osmoticPressure" ] },
        "micropoise": { name: "micropoise", label: "micropoise", symbol: "µP", code: "J32", referenceUnit: function() { return samm.units["pascalSecond"] }, conversionFactor: "10⁻⁶ Pa × s", quantityKinds: [ "viscosityDynamicViscosity", "viscosityDynamicViscosity" ] },
        "microradian": { name: "microradian", label: "microradian", symbol: "µrad", code: "B97", referenceUnit: function() { return samm.units["rad"] }, conversionFactor: "10⁻⁶ rad", quantityKinds: [ "anglePlane", "absorbedDose" ] },
        "microsecond": { name: "microsecond", label: "microsecond", symbol: "µs", code: "B98", referenceUnit: function() { return samm.units["secondUnitOfTime"] }, conversionFactor: "10⁻⁶ s", quantityKinds: [ "time", "timeConstant", "reactorTimeConstant", "halfLife", "meanLife", "time", "relaxationTime", "period", "carrierLifeTime", "periodicTime", "reverberationTime" ] },
        "microsiemens": { name: "microsiemens", label: "microsiemens", symbol: "µS", code: "B99", referenceUnit: function() { return samm.units["siemens"] }, conversionFactor: "10⁻⁶ S", quantityKinds: [ "conductanceForDirectCurrent", "admittance", "modulusOfAdmittance", "conductanceForAlternatingCurrent", "complexAdmittance", "admittance", "modulusOfAdmittance", "conductanceForDirectCurrent", "complexAdmittance", "conductanceForAlternatingCurrent" ] },
        "microsiemensPerCentimetre": { name: "microsiemensPerCentimetre", label: "microsiemens per centimetre", symbol: "µS/cm", code: "G42", referenceUnit: function() { return samm.units["siemensPerMetre"] }, conversionFactor: "10⁻⁴ S/m", quantityKinds: [ "electrolyticConductivity", "conductivity", "admittance", "conductanceForDirectCurrent", "complexAdmittance", "conductanceForAlternatingCurrent", "modulusOfAdmittance" ] },
        "microsiemensPerMetre": { name: "microsiemensPerMetre", label: "microsiemens per metre", symbol: "µS/m", code: "G43", referenceUnit: function() { return samm.units["siemensPerMetre"] }, conversionFactor: "10⁻⁶ S/m", quantityKinds: [ "electrolyticConductivity", "conductivity", "conductanceForDirectCurrent", "modulusOfAdmittance", "conductanceForAlternatingCurrent", "complexAdmittance", "admittance" ] },
        "microsievertPerHour": { name: "microsievertPerHour", label: "microsievert per hour", symbol: "µSv/h", code: "P72", referenceUnit: function() { return samm.units["sievertPerSecond"] }, conversionFactor: "0.277777778 × 10⁻¹⁰ Sv/s", quantityKinds: [ "equivalenceDoseOutput", "equivalenceDoseOutput" ] },
        "microsievertPerMinute": { name: "microsievertPerMinute", label: "microsievert per minute", symbol: "µSv/min", code: "P76", referenceUnit: function() { return samm.units["sievertPerSecond"] }, conversionFactor: "1.666666667 × 10⁻⁸ Sv/s", quantityKinds: [ "equivalenceDoseOutput", "equivalenceDoseOutput" ] },
        "microsievertPerSecond": { name: "microsievertPerSecond", label: "microsievert per second", symbol: "µSv/s", code: "P67", referenceUnit: function() { return samm.units["sievertPerSecond"] }, conversionFactor: "10⁻⁶ Sv/s", quantityKinds: [ "equivalenceDoseOutput", "equivalenceDoseOutput" ] },
        "microtesla": { name: "microtesla", label: "microtesla", symbol: "µT", code: "D81", referenceUnit: function() { return samm.units["tesla"] }, conversionFactor: "10⁻⁶ T", quantityKinds: [ "magneticInduction", "magneticPolarization", "magneticFluxDensity", "magneticFluxDensity", "magneticInduction", "lowerCriticalMagneticFluxDensity", "upperCriticalMagneticFluxDensity", "magneticPolarization", "thermodynamicCriticalMagneticFluxDensity" ] },
        "microvolt": { name: "microvolt", label: "microvolt", symbol: "µV", code: "D82", referenceUnit: function() { return samm.units["volt"] }, conversionFactor: "10⁻⁶ V", quantityKinds: [ "tension", "voltage", "peltierCoefficientForSubstancesAAndB", "electromotiveForce", "thermoelectromotiveForceBetweenSubstancesAAndB", "potentialDifference", "electricPotential", "tension", "electromotiveForce", "electricPotential", "potentialDifference", "voltage" ] },
        "microvoltPerMetre": { name: "microvoltPerMetre", label: "microvolt per metre", symbol: "µV/m", code: "C3", referenceUnit: function() { return samm.units["voltPerMetre"] }, conversionFactor: "10⁻⁶ V/m", quantityKinds: [ "electricFieldStrength", "electricFieldStrength" ] },
        "microwatt": { name: "microwatt", label: "microwatt", symbol: "µW", code: "D80", referenceUnit: function() { return samm.units["watt"] }, conversionFactor: "10⁻⁶ W", quantityKinds: [ "power", "activePower", "powerForDirectCurrent", "radiantEnergyflux", "activePower", "heatFlowRate", "soundPower", "power", "radiantPower", "powerForDirectCurrent" ] },
        "microwattPerSquareMetre": { name: "microwattPerSquareMetre", label: "microwatt per square metre", symbol: "µW/m²", code: "D85", referenceUnit: function() { return samm.units["wattPerSquareMetre"] }, conversionFactor: "10⁻⁶ W/m²", quantityKinds: [ "soundIntensity", "poyntingVector", "fluenceRate", "irradiance", "soundIntensity", "radiantEnergy", "firstRadiationConstant", "energyFluenceRate", "energyFluxDensity", "densityOfHeatFlowRate", "radiantExitance" ] },
        "mil": { name: "mil", label: "mil", symbol: "mil", code: "M43", referenceUnit: function() { return samm.units["rad"] }, conversionFactor: "9.817477 × 10⁻⁴ rad", quantityKinds: [ "anglePlane", "absorbedDose" ] },
        "mileBasedOnUsSurveyFoot": { name: "mileBasedOnUsSurveyFoot", label: "mile (based on U.S. survey foot)", symbol: "mi (US survey)", code: "M52", referenceUnit: function() { return samm.units["metre"] }, conversionFactor: "1.609347 × 10³ m", quantityKinds: [ "thickness", "particlePositionVector", "cartesianCoordinates", "focalDistance", "radius", "radiusOfCurvature", "displacementVectorOfIonOrAtom", "lengthOfPath", "diameter", "comptonWavelength", "slowingDownLength", "migrationLength", "meanFreePath", "equilibriumPositionVectorOfIonOrAtom", "instantaneousSoundParticleDisplacement", "imageDistance", "breadth", "length", "halfValueThickness", "coherenceLength", "latticeVector", "londonPenetrationDepth", "diffusionLength", "meanFreePathOfPhononsOrElectrons", "diffusionCoefficientForNeutronFluxDensity", "halfThickness", "height", "electronRadius", "distance", "objectDistance", "bohrRadius", "diffusionCoefficientForNeutronFluenceRate", "nuclearRadius", "wavelength", "fundamentalLatticeVector", "meanLinearRange", "distance", "cartesianCoordinates", "radius", "breadth", "thickness", "height", "lengthOfPath", "radiusOfCurvature", "length", "diameter" ] },
        "milePerHourStatuteMile": { name: "milePerHourStatuteMile", label: "mile per hour (statute mile)", symbol: "mile/h", code: "HM", referenceUnit: function() { return samm.units["metrePerSecond"] }, conversionFactor: "0.44704 m/s", quantityKinds: [ "groupVelocity", "velocityOfSoundPhaseVelocity", "phaseVelocity", "neutronSpeed", "phaseSpeedOfElectromagneticWaves", "velocity", "velocitySpeedOnPropagationOfElectromagneticWavesInVacuo", "instantaneousSoundParticleVelocity", "phaseVelocityOfElectromagneticWaves", "phaseVelocity", "velocity", "groupVelocity" ] },
        "milePerMinute": { name: "milePerMinute", label: "mile per minute", symbol: "mi/min", code: "M57", referenceUnit: function() { return samm.units["metrePerSecond"] }, conversionFactor: "26.8224 m/s", quantityKinds: [ "groupVelocity", "velocityOfSoundPhaseVelocity", "phaseVelocity", "neutronSpeed", "phaseSpeedOfElectromagneticWaves", "velocity", "velocitySpeedOnPropagationOfElectromagneticWavesInVacuo", "instantaneousSoundParticleVelocity", "phaseVelocityOfElectromagneticWaves", "phaseVelocity", "velocity", "groupVelocity" ] },
        "milePerSecond": { name: "milePerSecond", label: "mile per second", symbol: "mi/s", code: "M58", referenceUnit: function() { return samm.units["metrePerSecond"] }, conversionFactor: "1.609344 × 10³ m/s", quantityKinds: [ "groupVelocity", "velocityOfSoundPhaseVelocity", "phaseVelocity", "neutronSpeed", "phaseSpeedOfElectromagneticWaves", "velocity", "velocitySpeedOnPropagationOfElectromagneticWavesInVacuo", "instantaneousSoundParticleVelocity", "phaseVelocityOfElectromagneticWaves", "phaseVelocity", "groupVelocity", "velocity" ] },
        "mileStatuteMile": { name: "mileStatuteMile", label: "mile (statute mile)", symbol: "mile", code: "SMI", referenceUnit: function() { return samm.units["metre"] }, conversionFactor: "1609.344 m", quantityKinds: [ "thickness", "diameter", "breadth", "lengthOfPath", "cartesianCoordinates", "radius", "height", "length", "radiusOfCurvature", "distance", "thickness", "particlePositionVector", "cartesianCoordinates", "focalDistance", "radius", "radiusOfCurvature", "displacementVectorOfIonOrAtom", "lengthOfPath", "diameter", "comptonWavelength", "slowingDownLength", "migrationLength", "meanFreePath", "equilibriumPositionVectorOfIonOrAtom", "instantaneousSoundParticleDisplacement", "imageDistance", "breadth", "length", "halfValueThickness", "coherenceLength", "latticeVector", "londonPenetrationDepth", "diffusionLength", "meanFreePathOfPhononsOrElectrons", "diffusionCoefficientForNeutronFluxDensity", "halfThickness", "height", "electronRadius", "distance", "objectDistance", "bohrRadius", "diffusionCoefficientForNeutronFluenceRate", "nuclearRadius", "wavelength", "fundamentalLatticeVector", "meanLinearRange" ] },
        "mileStatuteMilePerSecondSquared": { name: "mileStatuteMilePerSecondSquared", label: "mile (statute mile) per second squared", symbol: "mi/s²", code: "M42", referenceUnit: function() { return samm.units["metrePerSecondSquared"] }, conversionFactor: "1.609344 × 10³ m/s²", quantityKinds: [ "acceleration", "accelerationDueToGravity", "accelerationOfFreeFall", "acceleration", "instantaneousSoundParticleAcceleration", "accelerationOfFreeFall", "accelerationDueToGravity" ] },
        "mille": { name: "mille", label: "mille", symbol: null, code: "E12", referenceUnit: null, conversionFactor: null, quantityKinds: null },
        "milliInch": { name: "milliInch", label: "milli-inch", symbol: "mil", code: "77", referenceUnit: function() { return samm.units["metre"] }, conversionFactor: "25.4 × 10⁻⁶ m", quantityKinds: [ "thickness", "particlePositionVector", "cartesianCoordinates", "focalDistance", "radius", "radiusOfCurvature", "displacementVectorOfIonOrAtom", "lengthOfPath", "diameter", "comptonWavelength", "slowingDownLength", "migrationLength", "meanFreePath", "equilibriumPositionVectorOfIonOrAtom", "instantaneousSoundParticleDisplacement", "imageDistance", "breadth", "length", "halfValueThickness", "coherenceLength", "latticeVector", "londonPenetrationDepth", "diffusionLength", "meanFreePathOfPhononsOrElectrons", "diffusionCoefficientForNeutronFluxDensity", "halfThickness", "height", "electronRadius", "distance", "objectDistance", "bohrRadius", "diffusionCoefficientForNeutronFluenceRate", "nuclearRadius", "wavelength", "fundamentalLatticeVector", "meanLinearRange", "lengthOfPath", "distance", "height", "thickness", "diameter", "length", "radiusOfCurvature", "cartesianCoordinates", "breadth", "radius" ] },
        "milliampere": { name: "milliampere", label: "milliampere", symbol: "mA", code: "4K", referenceUnit: function() { return samm.units["ampere"] }, conversionFactor: "10⁻³ A", quantityKinds: [ "magnetomotiveForce", "currentLinkage", "magneticPotentialDifference", "electricCurrent", "currentLinkage", "electricCurrent", "magneticPotentialDifference", "magnetomotiveForce" ] },
        "milliampereHour": { name: "milliampereHour", label: "milliampere hour", symbol: "mA·h", code: "E09", referenceUnit: function() { return samm.units["coulomb"] }, conversionFactor: "3.6 C", quantityKinds: [ "quantityOfElectricity", "electricCharge", "electricFluxFluxOfDisplacement", "elementaryCharge", "electricFluxFluxOfDisplacement", "electricCharge", "quantityOfElectricity" ] },
        "milliamperePerBar": { name: "milliamperePerBar", label: "milliampere per bar", symbol: "mA/bar", code: "F59", referenceUnit: null, conversionFactor: null, quantityKinds: [ "magneticFieldStrength", "lineicElectricCurrent", "linearElectricCurrentDensity" ] },
        "milliamperePerInch": { name: "milliamperePerInch", label: "milliampere per inch", symbol: "mA/in", code: "F08", referenceUnit: null, conversionFactor: null, quantityKinds: [ "magneticFieldStrength", "lineicElectricCurrent", "linearElectricCurrentDensity" ] },
        "milliamperePerLitreMinute": { name: "milliamperePerLitreMinute", label: "milliampere per litre minute", symbol: "mA/(l·min)", code: "G59", referenceUnit: null, conversionFactor: null, quantityKinds: [ "currentDensity" ] },
        "milliamperePerMillimetre": { name: "milliamperePerMillimetre", label: "milliampere per millimetre", symbol: "mA/mm", code: "F76", referenceUnit: null, conversionFactor: null, quantityKinds: [ "magneticFieldStrength", "lineicElectricCurrent", "linearElectricCurrentDensity" ] },
        "milliamperePerPoundForcePerSquareInch": { name: "milliamperePerPoundForcePerSquareInch", label: "milliampere per pound-force per square inch", symbol: "mA/(lbf/in²)", code: "F57", referenceUnit: null, conversionFactor: null, quantityKinds: [ "currentDensity" ] },
        "milliard": { name: "milliard", label: "milliard", symbol: null, code: "MLD", referenceUnit: null, conversionFactor: null, quantityKinds: null },
        "millibar": { name: "millibar", label: "millibar", symbol: "mbar", code: "MBR", referenceUnit: function() { return samm.units["pascal"] }, conversionFactor: "10² Pa", quantityKinds: [ "fugacityOfBInAGaseousMixture", "pressure", "shearModulus", "staticPressure", "normalStress", "modulusOfRigidity", "instantaneousSoundPressure", "modulusOfElasticity", "shearStress", "modulusOfCompression", "partialPressureOfBInAGaseousMixture", "bulkModulus", "osmoticPressure", "modulusOfElasticity", "normalStress", "modulusOfRigidity", "shearModulus", "shearStress", "modulusOfCompression", "pressure", "bulkModulus" ] },
        "millibarCubicMetrePerSecond": { name: "millibarCubicMetrePerSecond", label: "millibar cubic metre per second", symbol: "mbar·m³/s", code: "F96", referenceUnit: null, conversionFactor: null, quantityKinds: [ "modulusOfElasticity", "bulkModulus", "modulusOfCompression", "modulusOfRigidity", "shearModulus", "shearStress", "normalStress", "pressure" ] },
        "millibarLitrePerSecond": { name: "millibarLitrePerSecond", label: "millibar litre per second", symbol: "mbar·l/s", code: "F95", referenceUnit: null, conversionFactor: null, quantityKinds: [ "bulkModulus", "shearModulus", "modulusOfElasticity", "normalStress", "modulusOfCompression", "shearStress", "modulusOfRigidity", "pressure" ] },
        "millibarPerBar": { name: "millibarPerBar", label: "millibar per bar", symbol: "mbar/bar", code: "F04", referenceUnit: null, conversionFactor: null, quantityKinds: [ "pressureRatio" ] },
        "millibarPerKelvin": { name: "millibarPerKelvin", label: "millibar per kelvin", symbol: "mbar/K", code: "F84", referenceUnit: null, conversionFactor: null, quantityKinds: [ "modulusOfElasticity", "normalStress", "modulusOfRigidity", "bulkModulus", "modulusOfCompression", "pressure", "shearModulus", "shearStress" ] },
        "millicandela": { name: "millicandela", label: "millicandela", symbol: "mcd", code: "P34", referenceUnit: function() { return samm.units["candela"] }, conversionFactor: "10⁻³ cd", quantityKinds: [ "luminousIntensity", "luminousIntensity" ] },
        "millicoulomb": { name: "millicoulomb", label: "millicoulomb", symbol: "mC", code: "D86", referenceUnit: function() { return samm.units["coulomb"] }, conversionFactor: "10⁻³ C", quantityKinds: [ "quantityOfElectricity", "electricCharge", "electricFluxFluxOfDisplacement", "elementaryCharge", "electricFluxFluxOfDisplacement", "electricCharge", "quantityOfElectricity" ] },
        "millicoulombPerCubicMetre": { name: "millicoulombPerCubicMetre", label: "millicoulomb per cubic metre", symbol: "mC/m³", code: "D88", referenceUnit: function() { return samm.units["coulombPerCubicMetre"] }, conversionFactor: "10⁻³ C/m³", quantityKinds: [ "chargeDensity", "volumicCharge", "volumeDensityOfCharge", "volumicCharge", "volumeDensityOfCharge", "chargeDensity" ] },
        "millicoulombPerKilogram": { name: "millicoulombPerKilogram", label: "millicoulomb per kilogram", symbol: "mC/kg", code: "C8", referenceUnit: function() { return samm.units["coulombPerKilogram"] }, conversionFactor: "10⁻³ C/kg", quantityKinds: [ "exposure", "exposure" ] },
        "millicoulombPerSquareMetre": { name: "millicoulombPerSquareMetre", label: "millicoulomb per square metre", symbol: "mC/m²", code: "D89", referenceUnit: function() { return samm.units["coulombPerSquareMetre"] }, conversionFactor: "10⁻³ C/m²", quantityKinds: [ "displacementElectricPolarization", "surfaceDensityOfCharge", "electricFluxDensity", "surfaceDensityOfCharge", "electricFluxDensity", "displacementElectricPolarization" ] },
        "millicurie": { name: "millicurie", label: "millicurie", symbol: "mCi", code: "MCU", referenceUnit: function() { return samm.units["becquerel"] }, conversionFactor: "3.7 × 10⁷ Bq", quantityKinds: [ "activity", "activity" ] },
        "milliequivalenceCausticPotashPerGramOfProduct": { name: "milliequivalenceCausticPotashPerGramOfProduct", label: "milliequivalence caustic potash per gram of product", symbol: null, code: "KO", referenceUnit: null, conversionFactor: null, quantityKinds: null },
        "millifarad": { name: "millifarad", label: "millifarad", symbol: "mF", code: "C10", referenceUnit: function() { return samm.units["farad"] }, conversionFactor: "10⁻³ F", quantityKinds: [ "capacitance", "capacitance" ] },
        "milligal": { name: "milligal", label: "milligal", symbol: "mGal", code: "C11", referenceUnit: function() { return samm.units["metrePerSecondSquared"] }, conversionFactor: "10⁻⁵ m/s²", quantityKinds: [ "accelerationDueToGravity", "accelerationOfFreeFall", "acceleration", "acceleration", "instantaneousSoundParticleAcceleration", "accelerationOfFreeFall", "accelerationDueToGravity" ] },
        "milligram": { name: "milligram", label: "milligram", symbol: "mg", code: "MGM", referenceUnit: function() { return samm.units["kilogram"] }, conversionFactor: "10⁻⁶ kg", quantityKinds: [ "mass", "massOfAtomOfANuclideX", "massOfMolecule", "effectiveMass", "mass", "nuclidicMass", "massExcess" ] },
        "milligramPerBar": { name: "milligramPerBar", label: "milligram per bar", symbol: "mg/bar", code: "F75", referenceUnit: null, conversionFactor: null, quantityKinds: [ "volumicMass", "massDensity", "density" ] },
        "milligramPerCubicMetre": { name: "milligramPerCubicMetre", label: "milligram per cubic metre", symbol: "mg/m³", code: "GP", referenceUnit: function() { return samm.units["kilogramPerCubicMetre"] }, conversionFactor: "10⁻⁶ kg/m³", quantityKinds: [ "density", "volumicMass", "massDensity", "amountOfSubstance", "massDensity", "density", "concentrationOfB", "massConcentrationOfB", "volumicMass" ] },
        "milligramPerCubicMetreBar": { name: "milligramPerCubicMetreBar", label: "milligram per cubic metre bar", symbol: "(mg/m³)/bar", code: "L18", referenceUnit: function() { return samm.units["kilogramPerCubicMetrePascal"] }, conversionFactor: "10⁻¹¹ (kg/m³)/Pa", quantityKinds: [ "volumicMass", "massDensity", "density", "massDensity", "volumicMass", "density" ] },
        "milligramPerCubicMetreKelvin": { name: "milligramPerCubicMetreKelvin", label: "milligram per cubic metre kelvin", symbol: "(mg/m³)/K", code: "L17", referenceUnit: null, conversionFactor: null, quantityKinds: [ "volumicMass", "massDensity", "density" ] },
        "milligramPerDay": { name: "milligramPerDay", label: "milligram per day", symbol: "mg/d", code: "F32", referenceUnit: null, conversionFactor: null, quantityKinds: [ "massFlowRate" ] },
        "milligramPerDayBar": { name: "milligramPerDayBar", label: "milligram per day bar", symbol: "mg/(d·bar)", code: "F70", referenceUnit: null, conversionFactor: null, quantityKinds: [ "massFlowRate" ] },
        "milligramPerDayKelvin": { name: "milligramPerDayKelvin", label: "milligram per day kelvin", symbol: "mg/(d·K)", code: "F43", referenceUnit: null, conversionFactor: null, quantityKinds: [ "massFlowRate" ] },
        "milligramPerGram": { name: "milligramPerGram", label: "milligram per gram", symbol: "mg/g", code: "H64", referenceUnit: null, conversionFactor: null, quantityKinds: [ "volumicMass", "massDensity", "density" ] },
        "milligramPerHour": { name: "milligramPerHour", label: "milligram per hour", symbol: "mg/h", code: "4M", referenceUnit: function() { return samm.units["kilogramPerSecond"] }, conversionFactor: "2.77778 × 10⁻¹⁰ kg/s", quantityKinds: [ "massFlowRate", "massFlowRate" ] },
        "milligramPerHourBar": { name: "milligramPerHourBar", label: "milligram per hour bar", symbol: "mg/(h·bar)", code: "F71", referenceUnit: null, conversionFactor: null, quantityKinds: [ "massFlowRate" ] },
        "milligramPerHourKelvin": { name: "milligramPerHourKelvin", label: "milligram per hour kelvin", symbol: "mg/(h·K)", code: "F44", referenceUnit: null, conversionFactor: null, quantityKinds: [ "massFlowRate" ] },
        "milligramPerKelvin": { name: "milligramPerKelvin", label: "milligram per kelvin", symbol: "mg/K", code: "F16", referenceUnit: null, conversionFactor: null, quantityKinds: [ "volumicMass", "massDensity", "density" ] },
        "milligramPerKilogram": { name: "milligramPerKilogram", label: "milligram per kilogram", symbol: "mg/kg", code: "NA", referenceUnit: null, conversionFactor: null, quantityKinds: [ "massRatio" ] },
        "milligramPerLitre": { name: "milligramPerLitre", label: "milligram per litre", symbol: "mg/l", code: "M1", referenceUnit: function() { return samm.units["kilogramPerCubicMetre"] }, conversionFactor: "10⁻³ kg/m³", quantityKinds: [ "amountOfSubstance", "massDensity", "density", "concentrationOfB", "massConcentrationOfB", "volumicMass", "volumicMass", "density", "massDensity" ] },
        "milligramPerMetre": { name: "milligramPerMetre", label: "milligram per metre", symbol: "mg/m", code: "C12", referenceUnit: function() { return samm.units["kilogramPerMetre"] }, conversionFactor: "10⁻⁶ kg/m", quantityKinds: [ "linearMass", "linearDensity", "linearDensity", "linearMass" ] },
        "milligramPerMinute": { name: "milligramPerMinute", label: "milligram per minute", symbol: "mg/min", code: "F33", referenceUnit: null, conversionFactor: null, quantityKinds: [ "massFlowRate" ] },
        "milligramPerMinuteBar": { name: "milligramPerMinuteBar", label: "milligram per minute bar", symbol: "mg/(min·bar)", code: "F72", referenceUnit: null, conversionFactor: null, quantityKinds: [ "massFlowRate" ] },
        "milligramPerMinuteKelvin": { name: "milligramPerMinuteKelvin", label: "milligram per minute kelvin", symbol: "mg/(min·K)", code: "F45", referenceUnit: null, conversionFactor: null, quantityKinds: [ "massFlowRate" ] },
        "milligramPerSecond": { name: "milligramPerSecond", label: "milligram per second", symbol: "mg/s", code: "F34", referenceUnit: null, conversionFactor: null, quantityKinds: [ "massFlowRate" ] },
        "milligramPerSecondBar": { name: "milligramPerSecondBar", label: "milligram per second bar", symbol: "mg/(s·bar)", code: "F73", referenceUnit: null, conversionFactor: null, quantityKinds: [ "massFlowRate" ] },
        "milligramPerSecondKelvin": { name: "milligramPerSecondKelvin", label: "milligram per second kelvin", symbol: "mg/(s·K)", code: "F46", referenceUnit: null, conversionFactor: null, quantityKinds: [ "massFlowRate" ] },
        "milligramPerSquareCentimetre": { name: "milligramPerSquareCentimetre", label: "milligram per square centimetre", symbol: "mg/cm²", code: "H63", referenceUnit: null, conversionFactor: null, quantityKinds: [ "surfaceDensity", "areicMass" ] },
        "milligramPerSquareMetre": { name: "milligramPerSquareMetre", label: "milligram per square metre", symbol: "mg/m²", code: "GO", referenceUnit: function() { return samm.units["kilogramPerSquareMetre"] }, conversionFactor: "10⁻⁶ kg/m²", quantityKinds: [ "surfaceDensity", "meanMassRange", "areicMass", "surfaceDensity", "areicMass" ] },
        "milligray": { name: "milligray", label: "milligray", symbol: "mGy", code: "C13", referenceUnit: function() { return samm.units["gray"] }, conversionFactor: "10⁻³ Gy", quantityKinds: [ "specificEnergyImparted", "massicEnergyImparted", "massicEnergyImparted", "specificEnergyImparted" ] },
        "milligrayPerHour": { name: "milligrayPerHour", label: "milligray per hour", symbol: "mGy/h", code: "P62", referenceUnit: function() { return samm.units["grayPerSecond"] }, conversionFactor: "2.77778 × 10⁻⁷ Gy/s", quantityKinds: [ "absorbedDoseRate", "absorbedDoseRate" ] },
        "milligrayPerMinute": { name: "milligrayPerMinute", label: "milligray per minute", symbol: "mGy/min", code: "P58", referenceUnit: function() { return samm.units["grayPerSecond"] }, conversionFactor: "1.66667 × 10⁻⁵ Gy/s", quantityKinds: [ "absorbedDoseRate", "absorbedDoseRate" ] },
        "milligrayPerSecond": { name: "milligrayPerSecond", label: "milligray per second", symbol: "mGy/s", code: "P54", referenceUnit: function() { return samm.units["grayPerSecond"] }, conversionFactor: "10⁻³ Gy/s", quantityKinds: [ "absorbedDoseRate", "absorbedDoseRate" ] },
        "millihenry": { name: "millihenry", label: "millihenry", symbol: "mH", code: "C14", referenceUnit: function() { return samm.units["henry"] }, conversionFactor: "10⁻³ H", quantityKinds: [ "selfInductance", "permeance", "mutualInductance", "permeance", "mutualInductance", "selfInductance" ] },
        "millihenryPerKiloohm": { name: "millihenryPerKiloohm", label: "millihenry per kiloohm", symbol: "mH/kΩ", code: "H05", referenceUnit: function() { return samm.units["secondUnitOfTime"] }, conversionFactor: "10⁻⁶ s", quantityKinds: [ "timeConstant", "reactorTimeConstant", "halfLife", "meanLife", "time", "relaxationTime", "period", "carrierLifeTime", "periodicTime", "reverberationTime", "permeance", "mutualInductance", "selfInductance" ] },
        "millihenryPerOhm": { name: "millihenryPerOhm", label: "millihenry per ohm", symbol: "mH/Ω", code: "H06", referenceUnit: function() { return samm.units["secondUnitOfTime"] }, conversionFactor: "10⁻³ s", quantityKinds: [ "permeance", "mutualInductance", "selfInductance", "timeConstant", "reactorTimeConstant", "halfLife", "meanLife", "time", "relaxationTime", "period", "carrierLifeTime", "periodicTime", "reverberationTime" ] },
        "millijoule": { name: "millijoule", label: "millijoule", symbol: "mJ", code: "C15", referenceUnit: function() { return samm.units["joule"] }, conversionFactor: "10⁻³ J", quantityKinds: [ "quantityOfHeat", "reactionEnergy", "workFunction", "activeEnergy", "kineticEnergy", "levelWidth", "meanEnergyImparted", "helmholtzFunction", "radiantEnergy", "potentialEnergy", "energy", "thermodynamicEnergy", "helmholtzFreeEnergy", "work", "heat", "hartreeEnergy", "energyImparted", "enthalpy", "alphaDisintegrationEnergy", "work", "energy", "kineticEnergy", "potentialEnergy" ] },
        "millilitre": { name: "millilitre", label: "millilitre", symbol: "ml", code: "MLT", referenceUnit: function() { return samm.units["cubicMetre"] }, conversionFactor: "10⁻⁶ m³", quantityKinds: [ "volume", "sectionModulus", "volume" ] },
        "millilitrePerBar": { name: "millilitrePerBar", label: "millilitre per bar", symbol: "ml/bar", code: "G97", referenceUnit: null, conversionFactor: null, quantityKinds: [ "volume" ] },
        "millilitrePerCubicMetre": { name: "millilitrePerCubicMetre", label: "millilitre per cubic metre", symbol: "ml/m³", code: "H65", referenceUnit: null, conversionFactor: null, quantityKinds: [ "specificVolume", "massicVolume" ] },
        "millilitrePerDay": { name: "millilitrePerDay", label: "millilitre per day", symbol: "ml/d", code: "G54", referenceUnit: null, conversionFactor: null, quantityKinds: [ "volumeFlowRate" ] },
        "millilitrePerDayBar": { name: "millilitrePerDayBar", label: "millilitre per day bar", symbol: "ml/(d·bar)", code: "G90", referenceUnit: null, conversionFactor: null, quantityKinds: [ "volumeFlowRate" ] },
        "millilitrePerDayKelvin": { name: "millilitrePerDayKelvin", label: "millilitre per day kelvin", symbol: "ml/(d·K)", code: "G73", referenceUnit: null, conversionFactor: null, quantityKinds: [ "volumeFlowRate" ] },
        "millilitrePerHour": { name: "millilitrePerHour", label: "millilitre per hour", symbol: "ml/h", code: "G55", referenceUnit: null, conversionFactor: null, quantityKinds: [ "volumeFlowRate" ] },
        "millilitrePerHourBar": { name: "millilitrePerHourBar", label: "millilitre per hour bar", symbol: "ml/(h·bar)", code: "G91", referenceUnit: null, conversionFactor: null, quantityKinds: [ "volumeFlowRate" ] },
        "millilitrePerHourKelvin": { name: "millilitrePerHourKelvin", label: "millilitre per hour kelvin", symbol: "ml/(h·K)", code: "G74", referenceUnit: null, conversionFactor: null, quantityKinds: [ "volumeFlowRate" ] },
        "millilitrePerKelvin": { name: "millilitrePerKelvin", label: "millilitre per kelvin", symbol: "ml/K", code: "G30", referenceUnit: null, conversionFactor: null, quantityKinds: [ "volumePerTemperature" ] },
        "millilitrePerKilogram": { name: "millilitrePerKilogram", label: "millilitre per kilogram", symbol: "ml/kg", code: "KX", referenceUnit: function() { return samm.units["cubicMetrePerKilogram"] }, conversionFactor: "10⁻⁶ m³/kg", quantityKinds: [ "specificVolume", "massicVolume", "massicVolume", "specificVolume" ] },
        "millilitrePerLitre": { name: "millilitrePerLitre", label: "millilitre per litre", symbol: "ml/l", code: "L19", referenceUnit: null, conversionFactor: null, quantityKinds: [ "volumeRatio" ] },
        "millilitrePerMinute": { name: "millilitrePerMinute", label: "millilitre per minute", symbol: "ml/min", code: "41", referenceUnit: function() { return samm.units["cubicMetrePerSecond"] }, conversionFactor: "1.66667 × 10⁻⁸ m³/s", quantityKinds: [ "volumeFlowRate", "recombinationCoefficient", "instantaneousVolumeFlowRate", "volumeFlowRate" ] },
        "millilitrePerMinuteBar": { name: "millilitrePerMinuteBar", label: "millilitre per minute bar", symbol: "ml/(min·bar)", code: "G92", referenceUnit: null, conversionFactor: null, quantityKinds: [ "volumeFlowRate" ] },
        "millilitrePerMinuteKelvin": { name: "millilitrePerMinuteKelvin", label: "millilitre per minute kelvin", symbol: "ml/(min·K)", code: "G75", referenceUnit: null, conversionFactor: null, quantityKinds: [ "volumeFlowRate" ] },
        "millilitrePerSecond": { name: "millilitrePerSecond", label: "millilitre per second", symbol: "ml/s", code: "40", referenceUnit: function() { return samm.units["cubicMetrePerSecond"] }, conversionFactor: "10⁻⁶ m³/s", quantityKinds: [ "volumeFlowRate", "volumeFlowRate", "recombinationCoefficient", "instantaneousVolumeFlowRate" ] },
        "millilitrePerSecondBar": { name: "millilitrePerSecondBar", label: "millilitre per second bar", symbol: "ml/(s·bar)", code: "G93", referenceUnit: null, conversionFactor: null, quantityKinds: [ "volumeFlowRate" ] },
        "millilitrePerSecondKelvin": { name: "millilitrePerSecondKelvin", label: "millilitre per second kelvin", symbol: "ml/(s·K)", code: "G76", referenceUnit: null, conversionFactor: null, quantityKinds: [ "volumeFlowRate" ] },
        "millilitrePerSquareCentimetreMinute": { name: "millilitrePerSquareCentimetreMinute", label: "millilitre per square centimetre minute", symbol: "(ml/min)/cm²", code: "M22", referenceUnit: function() { return samm.units["cubicMetrePerSecondSquareMetre"] }, conversionFactor: "2.777778 × 10⁻⁶ (m³/s)/m²", quantityKinds: [ "porosity", "phaseVelocity", "velocity", "groupVelocity" ] },
        "millilitrePerSquareCentimetreSecond": { name: "millilitrePerSquareCentimetreSecond", label: "millilitre per square centimetre second", symbol: "ml/(cm²·s)", code: "35", referenceUnit: function() { return samm.units["metrePerSecond"] }, conversionFactor: "10⁻² m/s", quantityKinds: [ "groupVelocity", "velocityOfSoundPhaseVelocity", "phaseVelocity", "neutronSpeed", "phaseSpeedOfElectromagneticWaves", "velocity", "velocitySpeedOnPropagationOfElectromagneticWavesInVacuo", "instantaneousSoundParticleVelocity", "phaseVelocityOfElectromagneticWaves", "porosity" ] },
        "millimetre": { name: "millimetre", label: "millimetre", symbol: "mm", code: "MMT", referenceUnit: function() { return samm.units["metre"] }, conversionFactor: "10⁻³ m", quantityKinds: [ "length", "radius", "lengthOfPath", "distance", "breadth", "diameter", "thickness", "cartesianCoordinates", "radiusOfCurvature", "height", "thickness", "particlePositionVector", "cartesianCoordinates", "focalDistance", "radius", "radiusOfCurvature", "displacementVectorOfIonOrAtom", "lengthOfPath", "diameter", "comptonWavelength", "slowingDownLength", "migrationLength", "meanFreePath", "equilibriumPositionVectorOfIonOrAtom", "instantaneousSoundParticleDisplacement", "imageDistance", "breadth", "length", "halfValueThickness", "coherenceLength", "latticeVector", "londonPenetrationDepth", "diffusionLength", "meanFreePathOfPhononsOrElectrons", "diffusionCoefficientForNeutronFluxDensity", "halfThickness", "height", "electronRadius", "distance", "objectDistance", "bohrRadius", "diffusionCoefficientForNeutronFluenceRate", "nuclearRadius", "wavelength", "fundamentalLatticeVector", "meanLinearRange" ] },
        "millimetrePerBar": { name: "millimetrePerBar", label: "millimetre per bar", symbol: "mm/bar", code: "G06", referenceUnit: null, conversionFactor: null, quantityKinds: [ "length", "radius", "breadth", "thickness", "distance", "radiusOfCurvature", "height", "cartesianCoordinates", "lengthOfPath", "diameter" ] },
        "millimetrePerDegreeCelsiusMetre": { name: "millimetrePerDegreeCelsiusMetre", label: "millimetre per degree Celsius metre", symbol: "mm/(°C·m)", code: "E97", referenceUnit: function() { return samm.units["reciprocalKelvinOrKelvinToThePowerMinusOne"] }, conversionFactor: "10⁻³ K⁻¹", quantityKinds: [ "relativePressureCoefficient", "linearExpansionCoefficient", "cubicExpansionCoefficient", "thermalDiffusivity" ] },
        "millimetrePerHour": { name: "millimetrePerHour", label: "millimetre per hour", symbol: "mm/h", code: "H67", referenceUnit: null, conversionFactor: null, quantityKinds: [ "velocity", "phaseVelocity", "groupVelocity" ] },
        "millimetrePerKelvin": { name: "millimetrePerKelvin", label: "millimetre per kelvin", symbol: "mm/K", code: "F53", referenceUnit: null, conversionFactor: null, quantityKinds: [ "thermalDiffusivity" ] },
        "millimetrePerMinute": { name: "millimetrePerMinute", label: "millimetre per minute", symbol: "mm/min", code: "H81", referenceUnit: null, conversionFactor: null, quantityKinds: [ "velocity", "phaseVelocity", "groupVelocity" ] },
        "millimetrePerSecond": { name: "millimetrePerSecond", label: "millimetre per second", symbol: "mm/s", code: "C16", referenceUnit: function() { return samm.units["metrePerSecond"] }, conversionFactor: "10⁻³ m/s", quantityKinds: [ "groupVelocity", "velocityOfSoundPhaseVelocity", "phaseVelocity", "neutronSpeed", "phaseSpeedOfElectromagneticWaves", "velocity", "velocitySpeedOnPropagationOfElectromagneticWavesInVacuo", "instantaneousSoundParticleVelocity", "phaseVelocityOfElectromagneticWaves", "phaseVelocity", "velocity", "groupVelocity" ] },
        "millimetrePerSecondSquared": { name: "millimetrePerSecondSquared", label: "millimetre per second squared", symbol: "mm/s²", code: "M41", referenceUnit: function() { return samm.units["metrePerSecondSquared"] }, conversionFactor: "10⁻³ m/s²", quantityKinds: [ "accelerationDueToGravity", "accelerationOfFreeFall", "acceleration", "acceleration", "instantaneousSoundParticleAcceleration", "accelerationOfFreeFall", "accelerationDueToGravity" ] },
        "millimetrePerYear": { name: "millimetrePerYear", label: "millimetre per year", symbol: "mm/y", code: "H66", referenceUnit: null, conversionFactor: null, quantityKinds: [ "velocity", "phaseVelocity", "groupVelocity" ] },
        "millimetreSquaredPerSecond": { name: "millimetreSquaredPerSecond", label: "millimetre squared per second", symbol: "mm²/s", code: "C17", referenceUnit: function() { return samm.units["squareMetrePerSecond"] }, conversionFactor: "10⁻⁶ m²/s", quantityKinds: [ "thermalDiffusivity", "diffusionCoefficientForNeutronNumberDensity", "thermalDiffusionCoefficient", "diffusionCoefficient", "kinematicViscosity", "kinematicViscosity" ] },
        "millimetreToTheFourthPower": { name: "millimetreToTheFourthPower", label: "millimetre to the fourth power", symbol: "mm⁴", code: "G77", referenceUnit: function() { return samm.units["metreToTheFourthPower"] }, conversionFactor: "10⁻¹² m⁴", quantityKinds: [ "secondMomentOfArea", "secondAxialMomentOfArea", "secondMomentOfArea", "secondAxialMomentOfArea" ] },
        "millimole": { name: "millimole", label: "millimole", symbol: "mmol", code: "C18", referenceUnit: function() { return samm.units["mole"] }, conversionFactor: "10⁻³ mol", quantityKinds: [ "amountOfSubstance", "amountOfSubstance" ] },
        "millimolePerGram": { name: "millimolePerGram", label: "millimole per gram", symbol: "mmol/g", code: "H68", referenceUnit: null, conversionFactor: null, quantityKinds: [ "ionicStrength" ] },
        "millimolePerKilogram": { name: "millimolePerKilogram", label: "millimole per kilogram", symbol: "mmol/kg", code: "D87", referenceUnit: function() { return samm.units["molePerKilogram"] }, conversionFactor: "10⁻³ mol/kg", quantityKinds: [ "molalityOfSoluteB", "ionicStrength" ] },
        "millimolePerLitre": { name: "millimolePerLitre", label: "millimole per litre", symbol: "mmol/l", code: "M33", referenceUnit: function() { return samm.units["molePerCubicMetre"] }, conversionFactor: "mol/m³", quantityKinds: [ "volumicMass", "massDensity", "density", "massConcentrationOfB", "concentrationOfB", "amountOfSubstance", "massDensity", "density", "amountOfSubstance", "concentrationOfB", "volumicMass", "massConcentrationOfB" ] },
        "millinewton": { name: "millinewton", label: "millinewton", symbol: "mN", code: "C20", referenceUnit: function() { return samm.units["newton"] }, conversionFactor: "10⁻³ N", quantityKinds: [ "weight", "force", "weight", "force" ] },
        "millinewtonMetre": { name: "millinewtonMetre", label: "millinewton metre", symbol: "mN·m", code: "D83", referenceUnit: function() { return samm.units["newtonMetre"] }, conversionFactor: "10⁻³ N × m", quantityKinds: [ "momentOfACouple", "torque", "momentOfForce", "torque", "momentOfForce", "momentOfACouple" ] },
        "millinewtonPerMetre": { name: "millinewtonPerMetre", label: "millinewton per metre", symbol: "mN/m", code: "C22", referenceUnit: function() { return samm.units["newtonPerMetre"] }, conversionFactor: "10⁻³ N/m", quantityKinds: [ "surfaceTension", "surfaceTension" ] },
        "milliohm": { name: "milliohm", label: "milliohm", symbol: "mΩ", code: "E45", referenceUnit: function() { return samm.units["ohm"] }, conversionFactor: "10⁻³ Ω", quantityKinds: [ "resistanceToAlternatingCurrent", "impedance", "resistanceToDirectCurrent", "reactance", "modulusOfImpedance", "complexImpedances", "impedance", "reactance", "modulusOfImpedance", "resistanceToDirectCurrent", "complexImpedances", "resistanceToAlternatingCurrent" ] },
        "milliohmMetre": { name: "milliohmMetre", label: "milliohm metre", symbol: "mΩ·m", code: "C23", referenceUnit: function() { return samm.units["ohmMetre"] }, conversionFactor: "10⁻³ Ω × m", quantityKinds: [ "resistivity", "residualResistivity", "resistivity" ] },
        "milliohmPerMetre": { name: "milliohmPerMetre", label: "milliohm per metre", symbol: "mΩ/m", code: "F54", referenceUnit: function() { return samm.units["ohmPerMetre"] }, conversionFactor: "10⁻³ Ω/m", quantityKinds: [ "lineicResistance", "lineicResistance" ] },
        "million": { name: "million", label: "million", symbol: null, code: "MIO", referenceUnit: null, conversionFactor: null, quantityKinds: null },
        "millionBtuItPerHour": { name: "millionBtuItPerHour", label: "million Btu(IT) per hour", symbol: "BtuIT/h", code: "E16", referenceUnit: function() { return samm.units["watt"] }, conversionFactor: "293071.1 W", quantityKinds: [ "radiantEnergyflux", "activePower", "heatFlowRate", "soundPower", "power", "radiantPower", "powerForDirectCurrent" ] },
        "millionBtuPer1000CubicFoot": { name: "millionBtuPer1000CubicFoot", label: "million Btu per 1000 cubic foot", symbol: "MBTU/kft³", code: "M9", referenceUnit: null, conversionFactor: null, quantityKinds: null },
        "millionCubicMetre": { name: "millionCubicMetre", label: "million cubic metre", symbol: "Mm³", code: "HMQ", referenceUnit: null, conversionFactor: null, quantityKinds: null },
        "millionInternationalUnit": { name: "millionInternationalUnit", label: "million international unit", symbol: null, code: "MIU", referenceUnit: null, conversionFactor: null, quantityKinds: null },
        "millipascal": { name: "millipascal", label: "millipascal", symbol: "mPa", code: "74", referenceUnit: function() { return samm.units["pascal"] }, conversionFactor: "10⁻³ Pa", quantityKinds: [ "fugacityOfBInAGaseousMixture", "pressure", "shearModulus", "staticPressure", "normalStress", "modulusOfRigidity", "instantaneousSoundPressure", "modulusOfElasticity", "shearStress", "modulusOfCompression", "partialPressureOfBInAGaseousMixture", "bulkModulus", "osmoticPressure", "modulusOfRigidity", "normalStress", "shearModulus", "pressure", "bulkModulus", "modulusOfCompression", "shearStress", "modulusOfElasticity" ] },
        "millipascalPerMetre": { name: "millipascalPerMetre", label: "millipascal per metre", symbol: "mPa/m", code: "P80", referenceUnit: null, conversionFactor: null, quantityKinds: [ "hardnessIndex" ] },
        "millipascalSecond": { name: "millipascalSecond", label: "millipascal second", symbol: "mPa·s", code: "C24", referenceUnit: function() { return samm.units["pascalSecond"] }, conversionFactor: "10⁻³ Pa × s", quantityKinds: [ "viscosityDynamicViscosity", "viscosityDynamicViscosity" ] },
        "millipascalSecondPerBar": { name: "millipascalSecondPerBar", label: "millipascal second per bar", symbol: "mPa·s/bar", code: "L16", referenceUnit: function() { return samm.units["secondUnitOfTime"] }, conversionFactor: "10⁻⁸ s", quantityKinds: [ "viscosityDynamicViscosity", "timeConstant", "reactorTimeConstant", "halfLife", "meanLife", "time", "relaxationTime", "period", "carrierLifeTime", "periodicTime", "reverberationTime" ] },
        "millipascalSecondPerKelvin": { name: "millipascalSecondPerKelvin", label: "millipascal second per kelvin", symbol: "mPa·s/K", code: "L15", referenceUnit: null, conversionFactor: null, quantityKinds: [ "viscosityDynamicViscosity" ] },
        "milliradian": { name: "milliradian", label: "milliradian", symbol: "mrad", code: "C25", referenceUnit: function() { return samm.units["rad"] }, conversionFactor: "10⁻³ rad", quantityKinds: [ "anglePlane", "absorbedDose" ] },
        "milliroentgen": { name: "milliroentgen", label: "milliroentgen", symbol: "mR", code: "2Y", referenceUnit: function() { return samm.units["coulombPerKilogram"] }, conversionFactor: "2.58 × 10⁻⁷ C/kg", quantityKinds: [ "exposure", "exposure" ] },
        "milliroentgenAequivalentMen": { name: "milliroentgenAequivalentMen", label: "milliroentgen aequivalent men", symbol: "mrem", code: "L31", referenceUnit: function() { return samm.units["sievert"] }, conversionFactor: "10⁻⁵ Sv", quantityKinds: [ "doseEquivalent", "doseEquivalent" ] },
        "millisecond": { name: "millisecond", label: "millisecond", symbol: "ms", code: "C26", referenceUnit: function() { return samm.units["secondUnitOfTime"] }, conversionFactor: "10⁻³ s", quantityKinds: [ "timeConstant", "reactorTimeConstant", "halfLife", "meanLife", "time", "relaxationTime", "period", "carrierLifeTime", "periodicTime", "reverberationTime", "time" ] },
        "millisiemens": { name: "millisiemens", label: "millisiemens", symbol: "mS", code: "C27", referenceUnit: function() { return samm.units["siemens"] }, conversionFactor: "10⁻³ S", quantityKinds: [ "conductanceForDirectCurrent", "admittance", "modulusOfAdmittance", "conductanceForAlternatingCurrent", "complexAdmittance", "modulusOfAdmittance", "conductanceForDirectCurrent", "conductanceForAlternatingCurrent", "admittance", "complexAdmittance" ] },
        "millisiemensPerCentimetre": { name: "millisiemensPerCentimetre", label: "millisiemens per centimetre", symbol: "mS/cm", code: "H61", referenceUnit: function() { return samm.units["siemensPerMetre"] }, conversionFactor: "10⁻¹ S/m", quantityKinds: [ "electrolyticConductivity", "conductivity", "conductivity" ] },
        "millisievert": { name: "millisievert", label: "millisievert", symbol: "mSv", code: "C28", referenceUnit: function() { return samm.units["sievert"] }, conversionFactor: "10⁻³ Sv", quantityKinds: [ "doseEquivalent", "doseEquivalent" ] },
        "millisievertPerHour": { name: "millisievertPerHour", label: "millisievert per hour", symbol: "mSv/h", code: "P71", referenceUnit: function() { return samm.units["sievertPerSecond"] }, conversionFactor: "0.277777778 × 10⁻⁷ Sv/s", quantityKinds: [ "equivalenceDoseOutput", "equivalenceDoseOutput" ] },
        "millisievertPerMinute": { name: "millisievertPerMinute", label: "millisievert per minute", symbol: "mSv/min", code: "P75", referenceUnit: function() { return samm.units["sievertPerSecond"] }, conversionFactor: "1.666666667 × 10⁻⁵ Sv/s", quantityKinds: [ "equivalenceDoseOutput", "equivalenceDoseOutput" ] },
        "millisievertPerSecond": { name: "millisievertPerSecond", label: "millisievert per second", symbol: "mSv/s", code: "P66", referenceUnit: function() { return samm.units["sievertPerSecond"] }, conversionFactor: "10⁻³ Sv/s", quantityKinds: [ "equivalenceDoseOutput", "equivalenceDoseOutput" ] },
        "millitesla": { name: "millitesla", label: "millitesla", symbol: "mT", code: "C29", referenceUnit: function() { return samm.units["tesla"] }, conversionFactor: "10⁻³ T", quantityKinds: [ "magneticInduction", "magneticFluxDensity", "magneticPolarization", "magneticFluxDensity", "magneticInduction", "lowerCriticalMagneticFluxDensity", "upperCriticalMagneticFluxDensity", "magneticPolarization", "thermodynamicCriticalMagneticFluxDensity" ] },
        "millivolt": { name: "millivolt", label: "millivolt", symbol: "mV", code: "2Z", referenceUnit: function() { return samm.units["volt"] }, conversionFactor: "10⁻³ V", quantityKinds: [ "tension", "voltage", "peltierCoefficientForSubstancesAAndB", "electromotiveForce", "thermoelectromotiveForceBetweenSubstancesAAndB", "potentialDifference", "electricPotential", "electricPotential", "electromotiveForce", "tension", "potentialDifference", "voltage" ] },
        "millivoltAmpere": { name: "millivoltAmpere", label: "millivolt - ampere", symbol: "mV·A", code: "M35", referenceUnit: function() { return samm.units["voltAmpere"] }, conversionFactor: "10⁻³ V × A", quantityKinds: [ "apparentPower", "apparentPower" ] },
        "millivoltPerKelvin": { name: "millivoltPerKelvin", label: "millivolt per kelvin", symbol: "mV/K", code: "D49", referenceUnit: function() { return samm.units["voltPerKelvin"] }, conversionFactor: "10⁻³ V/K", quantityKinds: [ "seebeckCoefficientForSubstancesAAndB", "thompsonCoefficient" ] },
        "millivoltPerMetre": { name: "millivoltPerMetre", label: "millivolt per metre", symbol: "mV/m", code: "C30", referenceUnit: function() { return samm.units["voltPerMetre"] }, conversionFactor: "10⁻³ V/m", quantityKinds: [ "electricFieldStrength", "electricFieldStrength" ] },
        "millivoltPerMinute": { name: "millivoltPerMinute", label: "millivolt per minute", symbol: "mV/min", code: "H62", referenceUnit: null, conversionFactor: null, quantityKinds: [ "electricFieldStrength" ] },
        "milliwatt": { name: "milliwatt", label: "milliwatt", symbol: "mW", code: "C31", referenceUnit: function() { return samm.units["watt"] }, conversionFactor: "10⁻³ W", quantityKinds: [ "power", "activePower", "powerForDirectCurrent", "radiantEnergyflux", "activePower", "heatFlowRate", "soundPower", "power", "radiantPower", "powerForDirectCurrent" ] },
        "milliwattPerSquareMetre": { name: "milliwattPerSquareMetre", label: "milliwatt per square metre", symbol: "mW/m²", code: "C32", referenceUnit: function() { return samm.units["wattPerSquareMetre"] }, conversionFactor: "10⁻³ W/m²", quantityKinds: [ "soundIntensity", "poyntingVector", "fluenceRate", "irradiance", "soundIntensity", "radiantEnergy", "firstRadiationConstant", "energyFluenceRate", "energyFluxDensity", "densityOfHeatFlowRate", "radiantExitance" ] },
        "milliweber": { name: "milliweber", label: "milliweber", symbol: "mWb", code: "C33", referenceUnit: function() { return samm.units["weber"] }, conversionFactor: "10⁻³ Wb", quantityKinds: [ "magneticFlux", "magneticFluxQuantum", "magneticFlux" ] },
        "minuteUnitOfAngle": { name: "minuteUnitOfAngle", label: "minute [unit of angle]", symbol: "'", code: "D61", referenceUnit: function() { return samm.units["rad"] }, conversionFactor: "2.908882 × 10⁻⁴ rad", quantityKinds: [ "absorbedDose", "anglePlane" ] },
        "minuteUnitOfTime": { name: "minuteUnitOfTime", label: "minute [unit of time]", symbol: "min", code: "MIN", referenceUnit: function() { return samm.units["secondUnitOfTime"] }, conversionFactor: "60 s", quantityKinds: [ "timeConstant", "reactorTimeConstant", "halfLife", "meanLife", "time", "relaxationTime", "period", "carrierLifeTime", "periodicTime", "reverberationTime", "time" ] },
        "mmscfPerDay": { name: "mmscfPerDay", label: "MMSCF/day", symbol: null, code: "5E", referenceUnit: null, conversionFactor: null, quantityKinds: null },
        "moduleWidth": { name: "moduleWidth", label: "module width", symbol: "MW", code: "H77", referenceUnit: null, conversionFactor: null, quantityKinds: null },
        "molPerCubicMetrePascal": { name: "molPerCubicMetrePascal", label: "mol per cubic metre pascal", symbol: "(mol/m³)/Pa", code: "P52", referenceUnit: null, conversionFactor: null, quantityKinds: [ "concentrationOfB", "density", "massDensity", "amountOfSubstance", "volumicMass", "massConcentrationOfB" ] },
        "molPerKilogramPascal": { name: "molPerKilogramPascal", label: "mol per kilogram pascal", symbol: "(mol/kg)/Pa", code: "P51", referenceUnit: null, conversionFactor: null, quantityKinds: [ "volumicMass", "massConcentrationOfB", "amountOfSubstance", "density", "concentrationOfB", "massDensity" ] },
        "mole": { name: "mole", label: "mole", symbol: "mol", code: "C34", referenceUnit: null, conversionFactor: null, quantityKinds: [ "amountOfSubstance" ] },
        "molePerCubicDecimetre": { name: "molePerCubicDecimetre", label: "mole per cubic decimetre", symbol: "mol/dm³", code: "C35", referenceUnit: function() { return samm.units["molePerCubicMetre"] }, conversionFactor: "10³ mol/m³", quantityKinds: [ "massDensity", "density", "amountOfSubstance", "concentrationOfB", "volumicMass", "massConcentrationOfB", "density", "concentrationOfB", "volumicMass", "massDensity", "amountOfSubstance", "massConcentrationOfB" ] },
        "molePerCubicMetre": { name: "molePerCubicMetre", label: "mole per cubic metre", symbol: "mol/m³", code: "C36", referenceUnit: null, conversionFactor: null, quantityKinds: [ "massDensity", "density", "amountOfSubstance", "concentrationOfB", "volumicMass", "massConcentrationOfB" ] },
        "molePerCubicMetreBar": { name: "molePerCubicMetreBar", label: "mole per cubic metre bar", symbol: "(mol/m³)/bar", code: "L29", referenceUnit: function() { return samm.units["molPerCubicMetrePascal"] }, conversionFactor: "10⁻⁵ (mol/m³)/Pa", quantityKinds: [ "concentrationOfB", "density", "massDensity", "amountOfSubstance", "volumicMass", "massConcentrationOfB", "concentrationOfB", "density", "amountOfSubstance", "massConcentrationOfB", "massDensity", "volumicMass" ] },
        "molePerCubicMetreKelvin": { name: "molePerCubicMetreKelvin", label: "mole per cubic metre kelvin", symbol: "(mol/m³)/K", code: "L28", referenceUnit: null, conversionFactor: null, quantityKinds: [ "massDensity", "amountOfSubstance", "massConcentrationOfB", "density", "volumicMass", "concentrationOfB" ] },
        "molePerCubicMetreToThePowerSumOfStoichiometricNumbers": { name: "molePerCubicMetreToThePowerSumOfStoichiometricNumbers", label: "mole per cubic metre to the power sum of stoichiometric numbers", symbol: "(mol/m³)∑νB", code: "P99", referenceUnit: null, conversionFactor: null, quantityKinds: null },
        "molePerHour": { name: "molePerHour", label: "mole per hour", symbol: "mol/h", code: "L23", referenceUnit: function() { return samm.units["molePerSecond"] }, conversionFactor: "2.77778 × 10⁻⁴ mol/s", quantityKinds: [ "molarFlux", "volumicMass", "density", "concentrationOfB", "massConcentrationOfB", "amountOfSubstance", "massDensity" ] },
        "molePerKilogram": { name: "molePerKilogram", label: "mole per kilogram", symbol: "mol/kg", code: "C19", referenceUnit: null, conversionFactor: null, quantityKinds: [ "molalityOfSoluteB" ] },
        "molePerKilogramBar": { name: "molePerKilogramBar", label: "mole per kilogram bar", symbol: "(mol/kg)/bar", code: "L25", referenceUnit: function() { return samm.units["molPerKilogramPascal"] }, conversionFactor: "10⁻⁵ (mol/kg)/Pa", quantityKinds: [ "massDensity", "concentrationOfB", "massConcentrationOfB", "density", "volumicMass", "amountOfSubstance", "volumicMass", "massConcentrationOfB", "amountOfSubstance", "density", "concentrationOfB", "massDensity" ] },
        "molePerKilogramKelvin": { name: "molePerKilogramKelvin", label: "mole per kilogram kelvin", symbol: "(mol/kg)/K", code: "L24", referenceUnit: null, conversionFactor: null, quantityKinds: [ "density", "massConcentrationOfB", "volumicMass", "amountOfSubstance", "massDensity", "concentrationOfB" ] },
        "molePerLitre": { name: "molePerLitre", label: "mole per litre", symbol: "mol/l", code: "C38", referenceUnit: function() { return samm.units["molePerCubicMetre"] }, conversionFactor: "10³ mol/m³", quantityKinds: [ "massDensity", "density", "amountOfSubstance", "concentrationOfB", "volumicMass", "massConcentrationOfB", "massDensity", "volumicMass", "concentrationOfB", "massConcentrationOfB", "density", "amountOfSubstance" ] },
        "molePerLitreBar": { name: "molePerLitreBar", label: "mole per litre bar", symbol: "(mol/l)/bar", code: "L27", referenceUnit: function() { return samm.units["molPerCubicMetrePascal"] }, conversionFactor: "10⁻² (mol/m³)/Pa", quantityKinds: [ "amountOfSubstance", "density", "massConcentrationOfB", "volumicMass", "massDensity", "concentrationOfB", "concentrationOfB", "density", "massDensity", "amountOfSubstance", "volumicMass", "massConcentrationOfB" ] },
        "molePerLitreKelvin": { name: "molePerLitreKelvin", label: "mole per litre kelvin", symbol: "(mol/l)/K", code: "L26", referenceUnit: function() { return samm.units["molePerCubicMetreKelvin"] }, conversionFactor: "10³ (mol/m³)/K", quantityKinds: [ "massDensity", "amountOfSubstance", "massConcentrationOfB", "density", "volumicMass", "concentrationOfB", "massConcentrationOfB", "amountOfSubstance", "density", "concentrationOfB", "massDensity", "volumicMass" ] },
        "molePerMinute": { name: "molePerMinute", label: "mole per minute", symbol: "mol/min", code: "L30", referenceUnit: function() { return samm.units["molePerSecond"] }, conversionFactor: "1.66667 × 10⁻² mol/s", quantityKinds: [ "volumicMass", "density", "concentrationOfB", "massConcentrationOfB", "amountOfSubstance", "massDensity", "molarFlux" ] },
        "molePerSecond": { name: "molePerSecond", label: "mole per second", symbol: "mol/s", code: "E95", referenceUnit: null, conversionFactor: null, quantityKinds: [ "volumicMass", "density", "concentrationOfB", "massConcentrationOfB", "amountOfSubstance", "massDensity" ] },
        "monetaryValue": { name: "monetaryValue", label: "monetary value", symbol: null, code: "M4", referenceUnit: null, conversionFactor: null, quantityKinds: null },
        "month": { name: "month", label: "month", symbol: "mo", code: "MON", referenceUnit: function() { return samm.units["secondUnitOfTime"] }, conversionFactor: "2.629800 × 10⁶ s", quantityKinds: [ "time", "timeConstant", "reactorTimeConstant", "halfLife", "meanLife", "time", "relaxationTime", "period", "carrierLifeTime", "periodicTime", "reverberationTime" ] },
        "mutuallyDefined": { name: "mutuallyDefined", label: "mutually defined", symbol: null, code: "ZZ", referenceUnit: null, conversionFactor: null, quantityKinds: null },
        "nanoampere": { name: "nanoampere", label: "nanoampere", symbol: "nA", code: "C39", referenceUnit: function() { return samm.units["ampere"] }, conversionFactor: "10⁻⁹ A", quantityKinds: [ "magnetomotiveForce", "currentLinkage", "magneticPotentialDifference", "electricCurrent", "electricCurrent", "magneticPotentialDifference", "magnetomotiveForce", "currentLinkage" ] },
        "nanocoulomb": { name: "nanocoulomb", label: "nanocoulomb", symbol: "nC", code: "C40", referenceUnit: function() { return samm.units["coulomb"] }, conversionFactor: "10⁻⁹ C", quantityKinds: [ "quantityOfElectricity", "electricCharge", "electricFluxFluxOfDisplacement", "elementaryCharge", "electricFluxFluxOfDisplacement", "electricCharge", "quantityOfElectricity" ] },
        "nanofarad": { name: "nanofarad", label: "nanofarad", symbol: "nF", code: "C41", referenceUnit: function() { return samm.units["farad"] }, conversionFactor: "10⁻⁹ F", quantityKinds: [ "capacitance", "capacitance" ] },
        "nanofaradPerMetre": { name: "nanofaradPerMetre", label: "nanofarad per metre", symbol: "nF/m", code: "C42", referenceUnit: function() { return samm.units["faradPerMetre"] }, conversionFactor: "10⁻⁹ F/m", quantityKinds: [ "permittivity", "electricConstant", "permittivityOfVacuum", "permittivityOfVacuum", "permittivity", "electricConstant" ] },
        "nanogramPerKilogram": { name: "nanogramPerKilogram", label: "nanogram per kilogram", symbol: "ng/kg", code: "L32", referenceUnit: null, conversionFactor: null, quantityKinds: [ "massRatio" ] },
        "nanograyPerHour": { name: "nanograyPerHour", label: "nanogray per hour", symbol: "nGy/h", code: "P64", referenceUnit: function() { return samm.units["grayPerSecond"] }, conversionFactor: "2.77778 × 10⁻¹³ Gy/s", quantityKinds: [ "absorbedDoseRate", "absorbedDoseRate" ] },
        "nanograyPerMinute": { name: "nanograyPerMinute", label: "nanogray per minute", symbol: "nGy/min", code: "P60", referenceUnit: function() { return samm.units["grayPerSecond"] }, conversionFactor: "1.66667 × 10⁻¹¹ Gy/s", quantityKinds: [ "absorbedDoseRate", "absorbedDoseRate" ] },
        "nanograyPerSecond": { name: "nanograyPerSecond", label: "nanogray per second", symbol: "nGy/s", code: "P56", referenceUnit: function() { return samm.units["grayPerSecond"] }, conversionFactor: "10⁻⁹ Gy/s", quantityKinds: [ "absorbedDoseRate", "absorbedDoseRate" ] },
        "nanohenry": { name: "nanohenry", label: "nanohenry", symbol: "nH", code: "C43", referenceUnit: function() { return samm.units["henry"] }, conversionFactor: "10⁻⁹ H", quantityKinds: [ "selfInductance", "mutualInductance", "permeance", "selfInductance", "permeance", "mutualInductance" ] },
        "nanohenryPerMetre": { name: "nanohenryPerMetre", label: "nanohenry per metre", symbol: "nH/m", code: "C44", referenceUnit: function() { return samm.units["henryPerMetre"] }, conversionFactor: "10⁻⁹ H/m", quantityKinds: [ "magneticConstant", "permeabilityOfVacuum", "permeability", "permeabilityOfVacuum", "permeability", "magneticConstant" ] },
        "nanometre": { name: "nanometre", label: "nanometre", symbol: "nm", code: "C45", referenceUnit: function() { return samm.units["metre"] }, conversionFactor: "10⁻⁹ m", quantityKinds: [ "thickness", "particlePositionVector", "cartesianCoordinates", "focalDistance", "radius", "radiusOfCurvature", "displacementVectorOfIonOrAtom", "lengthOfPath", "diameter", "comptonWavelength", "slowingDownLength", "migrationLength", "meanFreePath", "equilibriumPositionVectorOfIonOrAtom", "instantaneousSoundParticleDisplacement", "imageDistance", "breadth", "length", "halfValueThickness", "coherenceLength", "latticeVector", "londonPenetrationDepth", "diffusionLength", "meanFreePathOfPhononsOrElectrons", "diffusionCoefficientForNeutronFluxDensity", "halfThickness", "height", "electronRadius", "distance", "objectDistance", "bohrRadius", "diffusionCoefficientForNeutronFluenceRate", "nuclearRadius", "wavelength", "fundamentalLatticeVector", "meanLinearRange", "height", "radiusOfCurvature", "distance", "diameter", "thickness", "lengthOfPath", "cartesianCoordinates", "breadth", "length", "radius" ] },
        "nanoohm": { name: "nanoohm", label: "nanoohm", symbol: "nΩ", code: "P22", referenceUnit: function() { return samm.units["ohm"] }, conversionFactor: "10⁻⁹ Ω", quantityKinds: [ "impedance", "reactance", "modulusOfImpedance", "resistanceToDirectCurrent", "complexImpedances", "resistanceToAlternatingCurrent", "impedance", "complexImpedances", "resistanceToDirectCurrent", "resistanceToAlternatingCurrent", "reactance", "modulusOfImpedance" ] },
        "nanoohmMetre": { name: "nanoohmMetre", label: "nanoohm metre", symbol: "nΩ·m", code: "C46", referenceUnit: null, conversionFactor: null, quantityKinds: [ "resistivity" ] },
        "nanosecond": { name: "nanosecond", label: "nanosecond", symbol: "ns", code: "C47", referenceUnit: function() { return samm.units["secondUnitOfTime"] }, conversionFactor: "10⁻⁹ s", quantityKinds: [ "time", "timeConstant", "reactorTimeConstant", "halfLife", "meanLife", "time", "relaxationTime", "period", "carrierLifeTime", "periodicTime", "reverberationTime" ] },
        "nanosiemensPerCentimetre": { name: "nanosiemensPerCentimetre", label: "nanosiemens per centimetre", symbol: "nS/cm", code: "G44", referenceUnit: function() { return samm.units["siemensPerMetre"] }, conversionFactor: "10⁻⁷ S/m", quantityKinds: [ "electrolyticConductivity", "conductivity", "conductivity" ] },
        "nanosiemensPerMetre": { name: "nanosiemensPerMetre", label: "nanosiemens per metre", symbol: "nS/m", code: "G45", referenceUnit: function() { return samm.units["siemensPerMetre"] }, conversionFactor: "10⁻⁹ S/m", quantityKinds: [ "electrolyticConductivity", "conductivity", "conductivity" ] },
        "nanosievertPerHour": { name: "nanosievertPerHour", label: "nanosievert per hour", symbol: "nSv/h", code: "P73", referenceUnit: function() { return samm.units["sievertPerSecond"] }, conversionFactor: "0.277777778 × 10⁻¹³ Sv/s", quantityKinds: [ "equivalenceDoseOutput", "equivalenceDoseOutput" ] },
        "nanosievertPerMinute": { name: "nanosievertPerMinute", label: "nanosievert per minute", symbol: "nSv/min", code: "P77", referenceUnit: function() { return samm.units["sievertPerSecond"] }, conversionFactor: "1.666666667 × 10⁻¹¹ Sv/s", quantityKinds: [ "equivalenceDoseOutput", "equivalenceDoseOutput" ] },
        "nanosievertPerSecond": { name: "nanosievertPerSecond", label: "nanosievert per second", symbol: "nSv/s", code: "P68", referenceUnit: function() { return samm.units["sievertPerSecond"] }, conversionFactor: "10⁻⁹ Sv/s", quantityKinds: [ "equivalenceDoseOutput", "equivalenceDoseOutput" ] },
        "nanotesla": { name: "nanotesla", label: "nanotesla", symbol: "nT", code: "C48", referenceUnit: function() { return samm.units["tesla"] }, conversionFactor: "10⁻⁹ T", quantityKinds: [ "magneticInduction", "magneticPolarization", "magneticFluxDensity", "magneticFluxDensity", "magneticInduction", "lowerCriticalMagneticFluxDensity", "upperCriticalMagneticFluxDensity", "magneticPolarization", "thermodynamicCriticalMagneticFluxDensity" ] },
        "nanowatt": { name: "nanowatt", label: "nanowatt", symbol: "nW", code: "C49", referenceUnit: function() { return samm.units["watt"] }, conversionFactor: "10⁻⁹ W", quantityKinds: [ "activePower", "powerForDirectCurrent", "radiantEnergyflux", "activePower", "heatFlowRate", "soundPower", "power", "radiantPower", "powerForDirectCurrent" ] },
        "naturalUnitOfInformation": { name: "naturalUnitOfInformation", label: "natural unit of information", symbol: "nat", code: "Q16", referenceUnit: null, conversionFactor: null, quantityKinds: null },
        "naturalUnitOfInformationPerSecond": { name: "naturalUnitOfInformationPerSecond", label: "natural unit of information per second", symbol: "nat/s", code: "Q19", referenceUnit: null, conversionFactor: null, quantityKinds: null },
        "nauticalMile": { name: "nauticalMile", label: "nautical mile", symbol: "n mile", code: "NMI", referenceUnit: function() { return samm.units["metre"] }, conversionFactor: "1852 m", quantityKinds: [ "thickness", "particlePositionVector", "cartesianCoordinates", "focalDistance", "radius", "radiusOfCurvature", "displacementVectorOfIonOrAtom", "lengthOfPath", "diameter", "comptonWavelength", "slowingDownLength", "migrationLength", "meanFreePath", "equilibriumPositionVectorOfIonOrAtom", "instantaneousSoundParticleDisplacement", "imageDistance", "breadth", "length", "halfValueThickness", "coherenceLength", "latticeVector", "londonPenetrationDepth", "diffusionLength", "meanFreePathOfPhononsOrElectrons", "diffusionCoefficientForNeutronFluxDensity", "halfThickness", "height", "electronRadius", "distance", "objectDistance", "bohrRadius", "diffusionCoefficientForNeutronFluenceRate", "nuclearRadius", "wavelength", "fundamentalLatticeVector", "meanLinearRange", "distance", "breadth", "length", "thickness", "radiusOfCurvature", "radius", "diameter", "height", "cartesianCoordinates", "lengthOfPath" ] },
        "neper": { name: "neper", label: "neper", symbol: "Np", code: "C50", referenceUnit: null, conversionFactor: null, quantityKinds: [ "logarithmicDecrement", "levelOfAPowerQuantity", "levelOfAFieldQuantity" ] },
        "neperPerSecond": { name: "neperPerSecond", label: "neper per second", symbol: "Np/s", code: "C51", referenceUnit: null, conversionFactor: null, quantityKinds: [ "dampingCoefficient" ] },
        "netKilogram": { name: "netKilogram", label: "net kilogram", symbol: null, code: "58", referenceUnit: null, conversionFactor: null, quantityKinds: null },
        "netTon": { name: "netTon", label: "net ton", symbol: null, code: "NT", referenceUnit: null, conversionFactor: null, quantityKinds: null },
        "newton": { name: "newton", label: "newton", symbol: "N", code: "NEW", referenceUnit: null, conversionFactor: null, quantityKinds: [ "weight", "force" ] },
        "newtonCentimetre": { name: "newtonCentimetre", label: "newton centimetre", symbol: "N·cm", code: "F88", referenceUnit: null, conversionFactor: null, quantityKinds: [ "torque", "momentOfForce", "momentOfACouple" ] },
        "newtonMetre": { name: "newtonMetre", label: "newton metre", symbol: "N·m", code: "NU", referenceUnit: null, conversionFactor: null, quantityKinds: [ "torque", "momentOfForce", "momentOfACouple" ] },
        "newtonMetrePerAmpere": { name: "newtonMetrePerAmpere", label: "newton metre per ampere", symbol: "N·m/A", code: "F90", referenceUnit: null, conversionFactor: null, quantityKinds: [ "torque", "momentOfForce", "momentOfACouple" ] },
        "newtonMetrePerDegree": { name: "newtonMetrePerDegree", label: "newton metre per degree", symbol: "Nm/°", code: "F89", referenceUnit: null, conversionFactor: null, quantityKinds: [ "torque", "momentOfForce", "momentOfACouple" ] },
        "newtonMetrePerKilogram": { name: "newtonMetrePerKilogram", label: "newton metre per kilogram", symbol: "N·m/kg", code: "G19", referenceUnit: null, conversionFactor: null, quantityKinds: [ "torque", "momentOfForce", "momentOfACouple" ] },
        "newtonMetrePerMetre": { name: "newtonMetrePerMetre", label: "newton metre per metre", symbol: "N·m/m²", code: "Q27", referenceUnit: null, conversionFactor: null, quantityKinds: null },
        "newtonMetrePerRadian": { name: "newtonMetrePerRadian", label: "newton metre per radian", symbol: "N·m/rad", code: "M93", referenceUnit: null, conversionFactor: null, quantityKinds: [ "torque", "momentOfForce", "momentOfACouple" ] },
        "newtonMetrePerSquareMetre": { name: "newtonMetrePerSquareMetre", label: "newton metre per square metre", symbol: "N·m/m²", code: "M34", referenceUnit: null, conversionFactor: null, quantityKinds: [ "torsionalStiffness", "areaRelatedTorsionalMoment" ] },
        "newtonMetreSecond": { name: "newtonMetreSecond", label: "newton metre second", symbol: "N·m·s", code: "C53", referenceUnit: null, conversionFactor: null, quantityKinds: [ "angularImpulse" ] },
        "newtonMetreSquaredPerKilogramSquared": { name: "newtonMetreSquaredPerKilogramSquared", label: "newton metre squared per kilogram squared", symbol: "N·m²/kg²", code: "C54", referenceUnit: null, conversionFactor: null, quantityKinds: [ "gravitationalConstant" ] },
        "newtonMetreWattToThePowerMinus0point5": { name: "newtonMetreWattToThePowerMinus0point5", label: "newton metre watt to the power minus 0,5", symbol: "N·m·W⁻⁰‧⁵", code: "H41", referenceUnit: null, conversionFactor: null, quantityKinds: [ "torque", "momentOfForce", "momentOfACouple" ] },
        "newtonPerAmpere": { name: "newtonPerAmpere", label: "newton per ampere", symbol: "N/A", code: "H40", referenceUnit: null, conversionFactor: null, quantityKinds: [ "torque", "momentOfForce", "momentOfACouple" ] },
        "newtonPerCentimetre": { name: "newtonPerCentimetre", label: "newton per centimetre", symbol: "N/cm", code: "M23", referenceUnit: function() { return samm.units["newtonPerMetre"] }, conversionFactor: "10² N/m", quantityKinds: [ "surfaceTension", "surfaceTension" ] },
        "newtonPerMetre": { name: "newtonPerMetre", label: "newton per metre", symbol: "N/m", code: "4P", referenceUnit: null, conversionFactor: null, quantityKinds: [ "surfaceTension" ] },
        "newtonPerMillimetre": { name: "newtonPerMillimetre", label: "newton per millimetre", symbol: "N/mm", code: "F47", referenceUnit: null, conversionFactor: null, quantityKinds: [ "torque", "momentOfForce", "momentOfACouple" ] },
        "newtonPerSquareCentimetre": { name: "newtonPerSquareCentimetre", label: "newton per square centimetre", symbol: "N/cm²", code: "E01", referenceUnit: function() { return samm.units["pascal"] }, conversionFactor: "10⁴ Pa", quantityKinds: [ "pressure", "normalStress", "shearStress", "modulusOfRigidity", "modulusOfCompression", "shearModulus", "modulusOfElasticity", "bulkModulus", "fugacityOfBInAGaseousMixture", "pressure", "shearModulus", "staticPressure", "normalStress", "modulusOfRigidity", "instantaneousSoundPressure", "modulusOfElasticity", "shearStress", "modulusOfCompression", "partialPressureOfBInAGaseousMixture", "bulkModulus", "osmoticPressure" ] },
        "newtonPerSquareMetre": { name: "newtonPerSquareMetre", label: "newton per square metre", symbol: "N/m²", code: "C55", referenceUnit: function() { return samm.units["pascal"] }, conversionFactor: "Pa", quantityKinds: [ "fugacityOfBInAGaseousMixture", "pressure", "shearModulus", "staticPressure", "normalStress", "modulusOfRigidity", "instantaneousSoundPressure", "modulusOfElasticity", "shearStress", "modulusOfCompression", "partialPressureOfBInAGaseousMixture", "bulkModulus", "osmoticPressure", "bulkModulus", "shearStress", "modulusOfRigidity", "shearModulus", "pressure", "modulusOfCompression", "modulusOfElasticity", "normalStress" ] },
        "newtonPerSquareMillimetre": { name: "newtonPerSquareMillimetre", label: "newton per square millimetre", symbol: "N/mm²", code: "C56", referenceUnit: function() { return samm.units["pascal"] }, conversionFactor: "10⁶ Pa", quantityKinds: [ "fugacityOfBInAGaseousMixture", "pressure", "shearModulus", "staticPressure", "normalStress", "modulusOfRigidity", "instantaneousSoundPressure", "modulusOfElasticity", "shearStress", "modulusOfCompression", "partialPressureOfBInAGaseousMixture", "bulkModulus", "osmoticPressure", "modulusOfCompression", "pressure", "shearModulus", "shearStress", "normalStress", "modulusOfRigidity", "bulkModulus", "modulusOfElasticity" ] },
        "newtonSecond": { name: "newtonSecond", label: "newton second", symbol: "N·s", code: "C57", referenceUnit: null, conversionFactor: null, quantityKinds: [ "impulse" ] },
        "newtonSecondPerMetre": { name: "newtonSecondPerMetre", label: "newton second per metre", symbol: "N·s/m", code: "C58", referenceUnit: null, conversionFactor: null, quantityKinds: [ "mechanicalImpedance" ] },
        "newtonSecondPerSquareMetre": { name: "newtonSecondPerSquareMetre", label: "newton second per square metre", symbol: "(N/m²)·s", code: "N36", referenceUnit: function() { return samm.units["pascalSecond"] }, conversionFactor: "Pa × s", quantityKinds: [ "viscosityDynamicViscosity", "viscosityDynamicViscosity" ] },
        "newtonSquareMetrePerAmpere": { name: "newtonSquareMetrePerAmpere", label: "newton square metre per ampere", symbol: "N·m²/A", code: "P49", referenceUnit: null, conversionFactor: null, quantityKinds: [ "magneticDipoleMoment" ] },
        "nil": { name: "nil", label: "nil", symbol: "()", code: "NIL", referenceUnit: null, conversionFactor: null, quantityKinds: null },
        "numberOfArticles": { name: "numberOfArticles", label: "number of articles", symbol: null, code: "NAR", referenceUnit: null, conversionFactor: null, quantityKinds: null },
        "numberOfCells": { name: "numberOfCells", label: "number of cells", symbol: null, code: "NCL", referenceUnit: null, conversionFactor: null, quantityKinds: null },
        "numberOfInternationalUnits": { name: "numberOfInternationalUnits", label: "number of international units", symbol: null, code: "NIU", referenceUnit: null, conversionFactor: null, quantityKinds: null },
        "numberOfJewels": { name: "numberOfJewels", label: "number of jewels", symbol: null, code: "JWL", referenceUnit: null, conversionFactor: null, quantityKinds: null },
        "numberOfPacks": { name: "numberOfPacks", label: "number of packs", symbol: null, code: "NMP", referenceUnit: null, conversionFactor: null, quantityKinds: null },
        "numberOfParts": { name: "numberOfParts", label: "number of parts", symbol: null, code: "NPT", referenceUnit: null, conversionFactor: null, quantityKinds: null },
        "numberOfWords": { name: "numberOfWords", label: "number of words", symbol: null, code: "D68", referenceUnit: null, conversionFactor: null, quantityKinds: null },
        "octave": { name: "octave", label: "octave", symbol: null, code: "C59", referenceUnit: null, conversionFactor: null, quantityKinds: [ "frequencyInterval" ] },
        "octet": { name: "octet", label: "octet", symbol: "o", code: "Q12", referenceUnit: function() { return samm.units["bit"] }, conversionFactor: "8 bit", quantityKinds: [ "informationEntropy" ] },
        "octetPerSecond": { name: "octetPerSecond", label: "octet per second", symbol: "o/s", code: "Q13", referenceUnit: function() { return samm.units["bitPerSecond"] }, conversionFactor: "8 bit/s", quantityKinds: null },
        "ohm": { name: "ohm", label: "ohm", symbol: "Ω", code: "OHM", referenceUnit: null, conversionFactor: null, quantityKinds: [ "impedance", "reactance", "modulusOfImpedance", "resistanceToDirectCurrent", "complexImpedances", "resistanceToAlternatingCurrent" ] },
        "ohmCentimetre": { name: "ohmCentimetre", label: "ohm centimetre", symbol: "Ω·cm", code: "C60", referenceUnit: function() { return samm.units["ohmMetre"] }, conversionFactor: "10⁻² Ω × m", quantityKinds: [ "resistivity", "residualResistivity", "resistivity" ] },
        "ohmCircularMilPerFoot": { name: "ohmCircularMilPerFoot", label: "ohm circular-mil per foot", symbol: "Ω·cmil/ft", code: "P23", referenceUnit: function() { return samm.units["ohmMetre"] }, conversionFactor: "1.662426 × 10⁻⁹ Ω × m", quantityKinds: [ "resistivity", "resistivity", "residualResistivity" ] },
        "ohmKilometre": { name: "ohmKilometre", label: "ohm kilometre", symbol: "Ω·km", code: "M24", referenceUnit: function() { return samm.units["ohmMetre"] }, conversionFactor: "10³ Ω × m", quantityKinds: [ "resistivity", "resistivity", "residualResistivity" ] },
        "ohmMetre": { name: "ohmMetre", label: "ohm metre", symbol: "Ω·m", code: "C61", referenceUnit: null, conversionFactor: null, quantityKinds: [ "resistivity", "residualResistivity" ] },
        "ohmPerKilometre": { name: "ohmPerKilometre", label: "ohm per kilometre", symbol: "Ω/km", code: "F56", referenceUnit: function() { return samm.units["ohmPerMetre"] }, conversionFactor: "10⁻³ Ω/m", quantityKinds: [ "lineicResistance", "lineicResistance" ] },
        "ohmPerMetre": { name: "ohmPerMetre", label: "ohm per metre", symbol: "Ω/m", code: "H26", referenceUnit: null, conversionFactor: null, quantityKinds: [ "lineicResistance" ] },
        "ohmPerMileStatuteMile": { name: "ohmPerMileStatuteMile", label: "ohm per mile (statute mile)", symbol: "Ω/mi", code: "F55", referenceUnit: function() { return samm.units["ohmPerMetre"] }, conversionFactor: "6.21371 × 10⁻⁴  Ω/m", quantityKinds: [ "lineicResistance", "lineicResistance" ] },
        "one": { name: "one", label: "one", symbol: "1", code: "C62", referenceUnit: null, conversionFactor: null, quantityKinds: [ "statisticalWeight", "fourierNumber", "neutronYieldPerFission", "numberOfPairsOfPoles", "partitionFunctionOfAMolecule", "refractiveIndex", "relativeDensity", "relativeMassDefect", "spectralReflectionfactor", "microcanonicalPartitionFunction", "standardAbsoluteActivityOfBInAGaseousMixture", "numberOfTurnsInAWinding", "transmissionFactor", "moleFractionOfB", "machNumber", "activityCoefficientOfSoluteBEspeciallyInADiluteSolution", "nucleonNumber", "relativeMassDensity", "spectralAbsorptance", "lewisNumber", "thermalUtilizationFactor", "orderOfReflexion", "shearStrain", "landauGinzburgNumber", "nuclearSpinQuantumNumber", "packingFraction", "transportNumberOfIonB", "isentropicExponent", "pecletNumber", "relativeAtomicMass", "grandPartitionFunction", "directionalSpectralEmissivity", "nusseltNumberForMassTransfer", "spectralEmissivity", "standardAbsoluteActivityOfBInALiquidOrASolidMixture", "coefficientOfFriction", "orbitalAngularMomentumQuantumNumber", "spinAngularMomentumQuantumNumber", "absorbance", "restMassOfNeutron", "schmidtNumber", "stoichiometricNumberOfB", "infiniteMediumMultiplicationFactor", "linearStrain", "magneticReynoldsNumber", "luminousEfficiencyAtASpecifiedWavelength", "grashofNumber", "alfvenNumber", "grandCanonicalPartitionFunction", "spectralAbsorptionFactor", "chargeNumberOfIon", "leakageCoefficient", "madelungConstant", "gFactorOfAtomOrElectron", "spectralTransmissionFactor", "stantonNumberForMassTransfer", "reynoldsNumber", "magneticQuantumNumber", "relativeElongation", "relativeMolecularMass", "emissivityAtASpecifiedWavelength", "frictionFactor", "restMassOfElectron", "coordinatesTrichromatic", "couplingCoefficient", "eulerNumber", "moleRatioOfSoluteB", "poissonNumber", "averageLogarithmicEnergyDecrement", "numberOfPhases", "dissipance", "rayleighNumber", "dissipationFactor", "degreeOfDissociation", "internalConversionFactor", "atomicNumber", "massNumber", "volumeOrBulkStrain", "activityCoefficientOfBInALiquidAsASolidMixture", "opticalDensity", "poissonRatio", "effectiveMultiplicationFactor", "standardAbsoluteActivityOfSolventAEspeciallyInADiluteSolution", "debyeWalleFactor", "reflectance", "fastFissionFactor", "standardEquilibriumConstant", "relativeActivityOfSolventAEspeciallyInADiluteSolution", "luminousEfficiency", "thermalDiffusionFactor", "relativePermittivity", "longRangeOrderParameter", "ratioOfTheSpecificHeatCapacities", "cowlingNumber", "standardAbsoluteActivityOfSoluteBEspeciallyInADiluteSolution", "fineStructureConstant", "shortRangeOrderParameter", "weberNumber", "grueneisenParameter", "canonicalPartitionFunction", "stantonNumber", "resonanceEscapeProbability", "spectralTransmittance", "numberOfMoleculesOrOtherElementaryEntities", "restMassOfProton", "spectralRadianceFactor", "neutronYieldPerAbsorption", "neutronNumber", "gFactorOfNucleus", "reflectionFactor", "currentFractionOfIonB", "multiplicationFactor", "absorptionFactor", "mobilityRatio", "reactivity", "hyperfineStructureQuantumNumber", "grashofNumberForMassTransfer", "protonNumber", "principleQuantumNumber", "activityOfSolventA", "bindingFraction", "spectralLuminousEfficiency", "nonLeakageProbability", "nusseltNumber", "prandtlNumber", "relativeMassExcess", "knudsenNumber", "thermalDiffusionRatio", "osmoticCoefficientOfTheSolventAEspeciallyInADiluteSolution", "cieColorimetricFunctions", "relativePermeability", "ratioOfTheMassicHeatCapacity", "molecularPartitionFunction", "electricSusceptibility", "fourierNumberForMassTransfer", "emissivity", "lethargy", "magneticSusceptibility", "pecletNumberForMassTransfer", "strouhalNumber", "absoluteActivity", "totalAngularMomentumQuantumNumber", "transmittance", "spectralReflectance", "hartmannNumber", "froudeNumber" ] },
        "onePerOne": { name: "onePerOne", label: "one per one", symbol: "1/1", code: "Q26", referenceUnit: null, conversionFactor: null, quantityKinds: null },
        "ounceAvoirdupois": { name: "ounceAvoirdupois", label: "ounce (avoirdupois)", symbol: "oz", code: "ONZ", referenceUnit: function() { return samm.units["kilogram"] }, conversionFactor: "2.834952 × 10⁻² kg", quantityKinds: [ "massOfAtomOfANuclideX", "massOfMolecule", "effectiveMass", "mass", "nuclidicMass", "massExcess", "mass" ] },
        "ounceAvoirdupoisForce": { name: "ounceAvoirdupoisForce", label: "ounce (avoirdupois)-force", symbol: "ozf", code: "L40", referenceUnit: function() { return samm.units["newton"] }, conversionFactor: "0.2780139 N", quantityKinds: [ "force", "weight", "weight", "force" ] },
        "ounceAvoirdupoisForceInch": { name: "ounceAvoirdupoisForceInch", label: "ounce (avoirdupois)-force inch", symbol: "ozf·in", code: "L41", referenceUnit: function() { return samm.units["newtonMetre"] }, conversionFactor: "7.061552 × 10⁻³ N × m", quantityKinds: [ "momentOfForce", "momentOfACouple", "torque", "torque", "momentOfForce", "momentOfACouple" ] },
        "ounceAvoirdupoisPerCubicInch": { name: "ounceAvoirdupoisPerCubicInch", label: "ounce (avoirdupois) per cubic inch", symbol: "oz/in³", code: "L39", referenceUnit: function() { return samm.units["kilogramPerCubicMetre"] }, conversionFactor: "1.729994 × 10³ kg/m³", quantityKinds: [ "amountOfSubstance", "massDensity", "density", "concentrationOfB", "massConcentrationOfB", "volumicMass", "density", "volumicMass", "massDensity" ] },
        "ounceAvoirdupoisPerCubicYard": { name: "ounceAvoirdupoisPerCubicYard", label: "ounce (avoirdupois) per cubic yard", symbol: "oz/yd³", code: "G32", referenceUnit: null, conversionFactor: null, quantityKinds: [ "volumicMass", "massDensity", "density" ] },
        "ounceAvoirdupoisPerDay": { name: "ounceAvoirdupoisPerDay", label: "ounce (avoirdupois) per day", symbol: "oz/d", code: "L33", referenceUnit: function() { return samm.units["kilogramPerSecond"] }, conversionFactor: "3.281194 × 10⁻⁷kg/s", quantityKinds: [ "massFlowRate", "massFlowRate" ] },
        "ounceAvoirdupoisPerGallonUk": { name: "ounceAvoirdupoisPerGallonUk", label: "ounce (avoirdupois) per gallon (UK)", symbol: "oz/gal (UK)", code: "L37", referenceUnit: function() { return samm.units["kilogramPerCubicMetre"] }, conversionFactor: "6.236023 kg/m³", quantityKinds: [ "amountOfSubstance", "massDensity", "density", "concentrationOfB", "massConcentrationOfB", "volumicMass", "density", "massDensity", "volumicMass" ] },
        "ounceAvoirdupoisPerGallonUs": { name: "ounceAvoirdupoisPerGallonUs", label: "ounce (avoirdupois) per gallon (US)", symbol: "oz/gal (US)", code: "L38", referenceUnit: function() { return samm.units["kilogramPerCubicMetre"] }, conversionFactor: "7.489152 kg/m³", quantityKinds: [ "volumicMass", "massDensity", "density", "amountOfSubstance", "massDensity", "density", "concentrationOfB", "massConcentrationOfB", "volumicMass" ] },
        "ounceAvoirdupoisPerHour": { name: "ounceAvoirdupoisPerHour", label: "ounce (avoirdupois) per hour", symbol: "oz/h", code: "L34", referenceUnit: function() { return samm.units["kilogramPerSecond"] }, conversionFactor: "7.874867 × 10⁻⁶ kg/s", quantityKinds: [ "massFlowRate", "massFlowRate" ] },
        "ounceAvoirdupoisPerMinute": { name: "ounceAvoirdupoisPerMinute", label: "ounce (avoirdupois) per minute", symbol: "oz/min", code: "L35", referenceUnit: function() { return samm.units["kilogramPerSecond"] }, conversionFactor: "4.72492 × 10⁻⁴ kg/s", quantityKinds: [ "massFlowRate", "massFlowRate" ] },
        "ounceAvoirdupoisPerSecond": { name: "ounceAvoirdupoisPerSecond", label: "ounce (avoirdupois) per second", symbol: "oz/s", code: "L36", referenceUnit: function() { return samm.units["kilogramPerSecond"] }, conversionFactor: "2.834952 × 10⁻² kg/s", quantityKinds: [ "massFlowRate", "massFlowRate" ] },
        "ounceAvoirdupoisPerSquareInch": { name: "ounceAvoirdupoisPerSquareInch", label: "ounce (avoirdupois) per square inch", symbol: "oz/in²", code: "N22", referenceUnit: function() { return samm.units["kilogramPerSquareMetre"] }, conversionFactor: "4.394185 × 10 kg/m²", quantityKinds: [ "shearModulus", "normalStress", "bulkModulus", "modulusOfCompression", "pressure", "modulusOfElasticity", "shearStress", "modulusOfRigidity", "surfaceDensity", "meanMassRange", "areicMass" ] },
        "ounceFoot": { name: "ounceFoot", label: "ounce foot", symbol: "oz·ft", code: "4R", referenceUnit: function() { return samm.units["kilogramMetre"] }, conversionFactor: "8.640934 × 10⁻³ kg × m", quantityKinds: [ "momentOfForce", "momentOfACouple", "torque", "torque", "momentOfForce", "momentOfACouple" ] },
        "ounceInch": { name: "ounceInch", label: "ounce inch", symbol: "oz·in", code: "4Q", referenceUnit: function() { return samm.units["kilogramMetre"] }, conversionFactor: "7.200778 × 10⁻⁴ kg × m", quantityKinds: [ "momentOfACouple", "torque", "momentOfForce", "torque", "momentOfForce", "momentOfACouple" ] },
        "ouncePerSquareFoot": { name: "ouncePerSquareFoot", label: "ounce per square foot", symbol: "oz/ft²", code: "37", referenceUnit: function() { return samm.units["kilogramPerSquareMetre"] }, conversionFactor: "0.3051517 kg/m²", quantityKinds: [ "surfaceDensity", "areicMass", "surfaceDensity", "meanMassRange", "areicMass" ] },
        "ouncePerSquareFootPer0point01inch": { name: "ouncePerSquareFootPer0point01inch", label: "ounce per square foot per 0,01inch", symbol: "oz/(ft²/cin)", code: "38", referenceUnit: null, conversionFactor: null, quantityKinds: null },
        "ouncePerSquareYard": { name: "ouncePerSquareYard", label: "ounce per square yard", symbol: "oz/yd²", code: "ON", referenceUnit: function() { return samm.units["kilogramPerSquareMetre"] }, conversionFactor: "3.390575 × 10⁻² kg/m²", quantityKinds: [ "surfaceDensity", "areicMass", "surfaceDensity", "meanMassRange", "areicMass" ] },
        "ounceUkFluidPerDay": { name: "ounceUkFluidPerDay", label: "ounce (UK fluid) per day", symbol: "fl oz (UK)/d", code: "J95", referenceUnit: function() { return samm.units["cubicMetrePerSecond"] }, conversionFactor: "3.288549 × 10⁻¹⁰ m³/s", quantityKinds: [ "volumeFlowRate", "volumeFlowRate", "recombinationCoefficient", "instantaneousVolumeFlowRate" ] },
        "ounceUkFluidPerHour": { name: "ounceUkFluidPerHour", label: "ounce (UK fluid) per hour", symbol: "fl oz (UK)/h", code: "J96", referenceUnit: function() { return samm.units["cubicMetrePerSecond"] }, conversionFactor: "7.892517 × 10⁻⁹ m³/s", quantityKinds: [ "volumeFlowRate", "volumeFlowRate", "recombinationCoefficient", "instantaneousVolumeFlowRate" ] },
        "ounceUkFluidPerMinute": { name: "ounceUkFluidPerMinute", label: "ounce (UK fluid) per minute", symbol: "fl oz (UK)/min", code: "J97", referenceUnit: function() { return samm.units["cubicMetrePerSecond"] }, conversionFactor: "4.73551 × 10⁻⁷ m³/s", quantityKinds: [ "volumeFlowRate", "recombinationCoefficient", "instantaneousVolumeFlowRate", "volumeFlowRate" ] },
        "ounceUkFluidPerSecond": { name: "ounceUkFluidPerSecond", label: "ounce (UK fluid) per second", symbol: "fl oz (UK)/s", code: "J98", referenceUnit: function() { return samm.units["cubicMetrePerSecond"] }, conversionFactor: "2.841306 × 10⁻⁵ m³/s", quantityKinds: [ "volumeFlowRate", "recombinationCoefficient", "instantaneousVolumeFlowRate", "volumeFlowRate" ] },
        "ounceUsFluidPerDay": { name: "ounceUsFluidPerDay", label: "ounce (US fluid) per day", symbol: "fl oz (US)/d", code: "J99", referenceUnit: function() { return samm.units["cubicMetrePerSecond"] }, conversionFactor: "3.422862 × 10⁻¹⁰ m³/s", quantityKinds: [ "volumeFlowRate", "volumeFlowRate", "recombinationCoefficient", "instantaneousVolumeFlowRate" ] },
        "ounceUsFluidPerHour": { name: "ounceUsFluidPerHour", label: "ounce (US fluid) per hour", symbol: "fl oz (US)/h", code: "K10", referenceUnit: function() { return samm.units["cubicMetrePerSecond"] }, conversionFactor: "8.214869 × 10⁻⁹ m³/s", quantityKinds: [ "volumeFlowRate", "recombinationCoefficient", "instantaneousVolumeFlowRate", "volumeFlowRate" ] },
        "ounceUsFluidPerMinute": { name: "ounceUsFluidPerMinute", label: "ounce (US fluid) per minute", symbol: "fl oz (US)/min", code: "K11", referenceUnit: function() { return samm.units["cubicMetrePerSecond"] }, conversionFactor: "4.928922 × 10⁻⁷ m³/s", quantityKinds: [ "volumeFlowRate", "volumeFlowRate", "recombinationCoefficient", "instantaneousVolumeFlowRate" ] },
        "ounceUsFluidPerSecond": { name: "ounceUsFluidPerSecond", label: "ounce (US fluid) per second", symbol: "fl oz (US)/s", code: "K12", referenceUnit: function() { return samm.units["cubicMetrePerSecond"] }, conversionFactor: "2.957353 × 10⁻⁵ m³/s", quantityKinds: [ "volumeFlowRate", "recombinationCoefficient", "instantaneousVolumeFlowRate", "volumeFlowRate" ] },
        "outfit": { name: "outfit", label: "outfit", symbol: null, code: "11", referenceUnit: null, conversionFactor: null, quantityKinds: null },
        "overtimeHour": { name: "overtimeHour", label: "overtime hour", symbol: null, code: "OT", referenceUnit: null, conversionFactor: null, quantityKinds: null },
        "ozoneDepletionEquivalent": { name: "ozoneDepletionEquivalent", label: "ozone depletion equivalent", symbol: null, code: "ODE", referenceUnit: null, conversionFactor: null, quantityKinds: null },
        "pad": { name: "pad", label: "pad", symbol: null, code: "PD", referenceUnit: null, conversionFactor: null, quantityKinds: null },
        "page": { name: "page", label: "page", symbol: null, code: "ZP", referenceUnit: null, conversionFactor: null, quantityKinds: null },
        "pageFacsimile": { name: "pageFacsimile", label: "page - facsimile", symbol: null, code: "QA", referenceUnit: null, conversionFactor: null, quantityKinds: null },
        "pageHardcopy": { name: "pageHardcopy", label: "page - hardcopy", symbol: null, code: "QB", referenceUnit: null, conversionFactor: null, quantityKinds: null },
        "pagePerInch": { name: "pagePerInch", label: "page per inch", symbol: "ppi", code: "PQ", referenceUnit: null, conversionFactor: null, quantityKinds: null },
        "pair": { name: "pair", label: "pair", symbol: null, code: "PR", referenceUnit: null, conversionFactor: null, quantityKinds: null },
        "panel": { name: "panel", label: "panel", symbol: null, code: "OA", referenceUnit: null, conversionFactor: null, quantityKinds: null },
        "parsec": { name: "parsec", label: "parsec", symbol: "pc", code: "C63", referenceUnit: function() { return samm.units["metre"] }, conversionFactor: "3.085678 × 10¹⁶ m", quantityKinds: [ "distance", "thickness", "breadth", "diameter", "radius", "cartesianCoordinates", "length", "lengthOfPath", "height", "radiusOfCurvature", "thickness", "particlePositionVector", "cartesianCoordinates", "focalDistance", "radius", "radiusOfCurvature", "displacementVectorOfIonOrAtom", "lengthOfPath", "diameter", "comptonWavelength", "slowingDownLength", "migrationLength", "meanFreePath", "equilibriumPositionVectorOfIonOrAtom", "instantaneousSoundParticleDisplacement", "imageDistance", "breadth", "length", "halfValueThickness", "coherenceLength", "latticeVector", "londonPenetrationDepth", "diffusionLength", "meanFreePathOfPhononsOrElectrons", "diffusionCoefficientForNeutronFluxDensity", "halfThickness", "height", "electronRadius", "distance", "objectDistance", "bohrRadius", "diffusionCoefficientForNeutronFluenceRate", "nuclearRadius", "wavelength", "fundamentalLatticeVector", "meanLinearRange" ] },
        "partPerBillionUs": { name: "partPerBillionUs", label: "part per billion (US)", symbol: "ppb", code: "61", referenceUnit: null, conversionFactor: null, quantityKinds: null },
        "partPerHundredThousand": { name: "partPerHundredThousand", label: "part per hundred thousand", symbol: "ppht", code: "E40", referenceUnit: null, conversionFactor: null, quantityKinds: null },
        "partPerMillion": { name: "partPerMillion", label: "part per million", symbol: "ppm", code: "59", referenceUnit: null, conversionFactor: null, quantityKinds: null },
        "partPerQuadrillionUs": { name: "partPerQuadrillionUs", label: "Part per quadrillion (US)", symbol: "ppq", code: null, referenceUnit: null, conversionFactor: null, quantityKinds: null },
        "partPerThousand": { name: "partPerThousand", label: "part per thousand", symbol: "‰", code: "NX", referenceUnit: null, conversionFactor: null, quantityKinds: null },
        "partPerTrillionUs": { name: "partPerTrillionUs", label: "part per trillion (US)", symbol: "ppt", code: null, referenceUnit: null, conversionFactor: null, quantityKinds: null },
        "pascal": { name: "pascal", label: "pascal", symbol: "Pa", code: "PAL", referenceUnit: null, conversionFactor: null, quantityKinds: [ "fugacityOfBInAGaseousMixture", "pressure", "shearModulus", "staticPressure", "normalStress", "modulusOfRigidity", "instantaneousSoundPressure", "modulusOfElasticity", "shearStress", "modulusOfCompression", "partialPressureOfBInAGaseousMixture", "bulkModulus", "osmoticPressure" ] },
        "pascalCubicMetrePerSecond": { name: "pascalCubicMetrePerSecond", label: "pascal cubic metre per second", symbol: "Pa·m³/s", code: "G01", referenceUnit: null, conversionFactor: null, quantityKinds: [ "bulkModulus", "shearStress", "modulusOfRigidity", "pressure", "modulusOfCompression", "shearModulus", "normalStress", "modulusOfElasticity" ] },
        "pascalLitrePerSecond": { name: "pascalLitrePerSecond", label: "pascal litre per second", symbol: "Pa·l/s", code: "F99", referenceUnit: null, conversionFactor: null, quantityKinds: [ "pressure", "modulusOfCompression", "modulusOfElasticity", "bulkModulus", "shearStress", "modulusOfRigidity", "normalStress", "shearModulus" ] },
        "pascalPerBar": { name: "pascalPerBar", label: "pascal per bar", symbol: "Pa/bar", code: "F07", referenceUnit: null, conversionFactor: null, quantityKinds: [ "pressureRatio" ] },
        "pascalPerKelvin": { name: "pascalPerKelvin", label: "pascal per kelvin", symbol: "Pa/K", code: "C64", referenceUnit: null, conversionFactor: null, quantityKinds: [ "pressureCoefficient" ] },
        "pascalPerMetre": { name: "pascalPerMetre", label: "pascal per metre", symbol: "Pa/m", code: "H42", referenceUnit: null, conversionFactor: null, quantityKinds: [ "hardnessIndex" ] },
        "pascalSecond": { name: "pascalSecond", label: "pascal second", symbol: "Pa·s", code: "C65", referenceUnit: null, conversionFactor: null, quantityKinds: [ "viscosityDynamicViscosity" ] },
        "pascalSecondPerBar": { name: "pascalSecondPerBar", label: "pascal second per bar", symbol: "Pa·s/bar", code: "H07", referenceUnit: function() { return samm.units["secondUnitOfTime"] }, conversionFactor: "10⁻⁵ s", quantityKinds: [ "modulusOfRigidity", "normalStress", "modulusOfCompression", "bulkModulus", "pressure", "shearModulus", "shearStress", "modulusOfElasticity", "timeConstant", "reactorTimeConstant", "halfLife", "meanLife", "time", "relaxationTime", "period", "carrierLifeTime", "periodicTime", "reverberationTime" ] },
        "pascalSecondPerCubicMetre": { name: "pascalSecondPerCubicMetre", label: "pascal second per cubic metre", symbol: "Pa·s/m³", code: "C66", referenceUnit: null, conversionFactor: null, quantityKinds: [ "acousticImpedance" ] },
        "pascalSecondPerKelvin": { name: "pascalSecondPerKelvin", label: "pascal second per kelvin", symbol: "Pa.s/K", code: "F77", referenceUnit: null, conversionFactor: null, quantityKinds: [ "normalStress", "shearModulus", "bulkModulus", "modulusOfRigidity", "modulusOfElasticity", "shearStress", "pressure", "modulusOfCompression" ] },
        "pascalSecondPerLitre": { name: "pascalSecondPerLitre", label: "pascal second per litre", symbol: "Pa·s/l", code: "M32", referenceUnit: function() { return samm.units["pascalSecondPerCubicMetre"] }, conversionFactor: "10³ Pa × s/m³", quantityKinds: [ "acousticImpedance", "acousticImpedance" ] },
        "pascalSecondPerMetre": { name: "pascalSecondPerMetre", label: "pascal second per metre", symbol: "Pa· s/m", code: "C67", referenceUnit: null, conversionFactor: null, quantityKinds: [ "characteristicImpedanceOfAMedium" ] },
        "pascalSquareMetrePerKilogram": { name: "pascalSquareMetrePerKilogram", label: "pascal square metre per kilogram", symbol: "Pa/(kg/m²)", code: "P79", referenceUnit: function() { return samm.units["metrePerSecondSquared"] }, conversionFactor: "m/s²", quantityKinds: [ "burstIndex", "acceleration", "instantaneousSoundParticleAcceleration", "accelerationOfFreeFall", "accelerationDueToGravity" ] },
        "pascalSquaredSecond": { name: "pascalSquaredSecond", label: "pascal squared second", symbol: "Pa²·s", code: "P42", referenceUnit: null, conversionFactor: null, quantityKinds: [ "soundExposure" ] },
        "pascalToThePowerSumOfStoichiometricNumbers": { name: "pascalToThePowerSumOfStoichiometricNumbers", label: "pascal to the power sum of stoichiometric numbers", symbol: "PaΣνB", code: "P98", referenceUnit: null, conversionFactor: null, quantityKinds: null },
        "pebibitPerCubicMetre": { name: "pebibitPerCubicMetre", label: "pebibit per cubic metre", symbol: "Pibit/m³", code: "E82", referenceUnit: null, conversionFactor: null, quantityKinds: null },
        "pebibitPerMetre": { name: "pebibitPerMetre", label: "pebibit per metre", symbol: "Pibit/m", code: "E80", referenceUnit: null, conversionFactor: null, quantityKinds: null },
        "pebibitPerSquareMetre": { name: "pebibitPerSquareMetre", label: "pebibit per square metre", symbol: "Pibit/m²", code: "E81", referenceUnit: null, conversionFactor: null, quantityKinds: null },
        "pebibyte": { name: "pebibyte", label: "pebibyte", symbol: "PiB", code: "E60", referenceUnit: function() { return samm.units["byte"] }, conversionFactor: "2⁵⁰ B", quantityKinds: [ "informationEntropy", "informationEntropy" ] },
        "peck": { name: "peck", label: "peck", symbol: "pk (US)", code: "G23", referenceUnit: function() { return samm.units["cubicMetre"] }, conversionFactor: "8.809768 × 10⁻³ m³", quantityKinds: [ "volume", "sectionModulus", "volume" ] },
        "peckUk": { name: "peckUk", label: "peck (UK)", symbol: "pk (UK)", code: "L43", referenceUnit: function() { return samm.units["cubicMetre"] }, conversionFactor: "9.092181 × 10⁻³ m³", quantityKinds: [ "volume", "volume", "sectionModulus" ] },
        "peckUkPerDay": { name: "peckUkPerDay", label: "peck (UK) per day", symbol: "pk (UK)/d", code: "L44", referenceUnit: function() { return samm.units["cubicMetrePerSecond"] }, conversionFactor: "1.052336 × 10⁻⁷ m³/s", quantityKinds: [ "volumeFlowRate", "volumeFlowRate", "recombinationCoefficient", "instantaneousVolumeFlowRate" ] },
        "peckUkPerHour": { name: "peckUkPerHour", label: "peck (UK) per hour", symbol: "pk (UK)/h", code: "L45", referenceUnit: function() { return samm.units["cubicMetrePerSecond"] }, conversionFactor: "2.525606 × 10⁻⁶ m³/s", quantityKinds: [ "volumeFlowRate", "recombinationCoefficient", "instantaneousVolumeFlowRate", "volumeFlowRate" ] },
        "peckUkPerMinute": { name: "peckUkPerMinute", label: "peck (UK) per minute", symbol: "pk (UK)/min", code: "L46", referenceUnit: function() { return samm.units["cubicMetrePerSecond"] }, conversionFactor: "1.5153635 × 10⁻⁴ m³/s", quantityKinds: [ "volumeFlowRate", "recombinationCoefficient", "instantaneousVolumeFlowRate", "volumeFlowRate" ] },
        "peckUkPerSecond": { name: "peckUkPerSecond", label: "peck (UK) per second", symbol: "pk (UK)/s", code: "L47", referenceUnit: function() { return samm.units["cubicMetrePerSecond"] }, conversionFactor: "9.092181 × 10⁻³ m³/s", quantityKinds: [ "volumeFlowRate", "recombinationCoefficient", "instantaneousVolumeFlowRate", "volumeFlowRate" ] },
        "peckUsDryPerDay": { name: "peckUsDryPerDay", label: "peck (US dry) per day", symbol: "pk (US dry)/d", code: "L48", referenceUnit: function() { return samm.units["cubicMetrePerSecond"] }, conversionFactor: "1.019649 × 10⁻⁷ m³/s", quantityKinds: [ "volumeFlowRate", "volumeFlowRate", "recombinationCoefficient", "instantaneousVolumeFlowRate" ] },
        "peckUsDryPerHour": { name: "peckUsDryPerHour", label: "peck (US dry) per hour", symbol: "pk (US dry)/h", code: "L49", referenceUnit: function() { return samm.units["cubicMetrePerSecond"] }, conversionFactor: "2.447158 × 10⁻⁶ m³/s", quantityKinds: [ "volumeFlowRate", "recombinationCoefficient", "instantaneousVolumeFlowRate", "volumeFlowRate" ] },
        "peckUsDryPerMinute": { name: "peckUsDryPerMinute", label: "peck (US dry) per minute", symbol: "pk (US dry)/min", code: "L50", referenceUnit: function() { return samm.units["cubicMetrePerSecond"] }, conversionFactor: "1.468295 × 10⁻⁴ m³/s", quantityKinds: [ "volumeFlowRate", "recombinationCoefficient", "instantaneousVolumeFlowRate", "volumeFlowRate" ] },
        "peckUsDryPerSecond": { name: "peckUsDryPerSecond", label: "peck (US dry) per second", symbol: "pk (US dry)/s", code: "L51", referenceUnit: function() { return samm.units["cubicMetrePerSecond"] }, conversionFactor: "8.809768 × 10⁻³ m³/s", quantityKinds: [ "volumeFlowRate", "recombinationCoefficient", "instantaneousVolumeFlowRate", "volumeFlowRate" ] },
        "penCalorie": { name: "penCalorie", label: "pen calorie", symbol: null, code: "N1", referenceUnit: null, conversionFactor: null, quantityKinds: null },
        "penGramProtein": { name: "penGramProtein", label: "pen gram (protein)", symbol: null, code: "D23", referenceUnit: null, conversionFactor: null, quantityKinds: null },
        "pennyweight": { name: "pennyweight", label: "pennyweight", symbol: null, code: "DWT", referenceUnit: function() { return samm.units["gram"] }, conversionFactor: "1.555174 g", quantityKinds: [ "mass" ] },
        "perMillePerPsi": { name: "perMillePerPsi", label: "per mille per psi", symbol: "‰/psi", code: "J12", referenceUnit: function() { return samm.units["reciprocalPascalOrPascalToThePowerMinusOne"] }, conversionFactor: "1.450377 × 10⁻⁷ Pa⁻¹", quantityKinds: [ "isothermalCompressibility", "compressibility", "bulkCompressibility", "isentropicCompressibility" ] },
        "percent": { name: "percent", label: "percent", symbol: "%", code: "P1", referenceUnit: null, conversionFactor: null, quantityKinds: [ "dimensionless" ] },
        "percentPerBar": { name: "percentPerBar", label: "percent per bar", symbol: "%/bar", code: "H96", referenceUnit: function() { return samm.units["reciprocalPascalOrPascalToThePowerMinusOne"] }, conversionFactor: "10⁻⁷ Pa⁻¹", quantityKinds: [ "isothermalCompressibility", "compressibility", "bulkCompressibility", "isentropicCompressibility" ] },
        "percentPerDecakelvin": { name: "percentPerDecakelvin", label: "percent per decakelvin", symbol: "%/daK", code: "H73", referenceUnit: function() { return samm.units["reciprocalKelvinOrKelvinToThePowerMinusOne"] }, conversionFactor: "10⁻³ K⁻¹", quantityKinds: [ "relativePressureCoefficient", "linearExpansionCoefficient", "cubicExpansionCoefficient" ] },
        "percentPerDegree": { name: "percentPerDegree", label: "percent per degree", symbol: "%/°", code: "H90", referenceUnit: null, conversionFactor: null, quantityKinds: null },
        "percentPerDegreeCelsius": { name: "percentPerDegreeCelsius", label: "percent per degree Celsius", symbol: "%/°C", code: "M25", referenceUnit: null, conversionFactor: null, quantityKinds: null },
        "percentPerHectobar": { name: "percentPerHectobar", label: "percent per hectobar", symbol: "%/hbar", code: "H72", referenceUnit: null, conversionFactor: null, quantityKinds: null },
        "percentPerHundred": { name: "percentPerHundred", label: "percent per hundred", symbol: "%/100", code: "H93", referenceUnit: null, conversionFactor: null, quantityKinds: null },
        "percentPerInch": { name: "percentPerInch", label: "percent per inch", symbol: "%/in", code: "H98", referenceUnit: function() { return samm.units["reciprocalMetre"] }, conversionFactor: "0.3937008 m⁻¹", quantityKinds: [ "linearAbsorptionCoefficient", "linearIonizationByAParticle", "attenuationCoefficient", "macroscopicTotalCrossSection", "repetency", "angularWaveNumber", "angularReciprocalLatticeVector", "fundamentalReciprocalLatticeVector", "linearAttenuationCoefficient", "volumicCrossSection", "propagationCoefficient", "linearExtinctionCoefficient", "vergence", "totalIonizationByAParticle", "angularRepetency", "wavenumber", "volumicTotalCrossSection", "lensPower", "waveNumber", "curvature", "phaseCoefficient", "rydbergConstant", "macroscopicCrossSection" ] },
        "percentPerKelvin": { name: "percentPerKelvin", label: "percent per kelvin", symbol: "%/K", code: "H25", referenceUnit: function() { return samm.units["reciprocalKelvinOrKelvinToThePowerMinusOne"] }, conversionFactor: "10⁻² K⁻¹", quantityKinds: [ "relativePressureCoefficient", "linearExpansionCoefficient", "cubicExpansionCoefficient" ] },
        "percentPerMetre": { name: "percentPerMetre", label: "percent per metre", symbol: "%/m", code: "H99", referenceUnit: function() { return samm.units["reciprocalMetre"] }, conversionFactor: "10⁻² m⁻¹", quantityKinds: [ "linearAbsorptionCoefficient", "linearIonizationByAParticle", "attenuationCoefficient", "macroscopicTotalCrossSection", "repetency", "angularWaveNumber", "angularReciprocalLatticeVector", "fundamentalReciprocalLatticeVector", "linearAttenuationCoefficient", "volumicCrossSection", "propagationCoefficient", "linearExtinctionCoefficient", "vergence", "totalIonizationByAParticle", "angularRepetency", "wavenumber", "volumicTotalCrossSection", "lensPower", "waveNumber", "curvature", "phaseCoefficient", "rydbergConstant", "macroscopicCrossSection" ] },
        "percentPerMillimetre": { name: "percentPerMillimetre", label: "percent per millimetre", symbol: "%/mm", code: "J10", referenceUnit: function() { return samm.units["reciprocalMetre"] }, conversionFactor: "10 m⁻¹", quantityKinds: [ "linearAbsorptionCoefficient", "linearIonizationByAParticle", "attenuationCoefficient", "macroscopicTotalCrossSection", "repetency", "angularWaveNumber", "angularReciprocalLatticeVector", "fundamentalReciprocalLatticeVector", "linearAttenuationCoefficient", "volumicCrossSection", "propagationCoefficient", "linearExtinctionCoefficient", "vergence", "totalIonizationByAParticle", "angularRepetency", "wavenumber", "volumicTotalCrossSection", "lensPower", "waveNumber", "curvature", "phaseCoefficient", "rydbergConstant", "macroscopicCrossSection" ] },
        "percentPerMonth": { name: "percentPerMonth", label: "percent per month", symbol: "%/mo", code: "H71", referenceUnit: null, conversionFactor: null, quantityKinds: null },
        "percentPerOhm": { name: "percentPerOhm", label: "percent per ohm", symbol: "%/Ω", code: "H89", referenceUnit: null, conversionFactor: null, quantityKinds: null },
        "percentPerOneHundredThousand": { name: "percentPerOneHundredThousand", label: "percent per one hundred thousand", symbol: "%/100000", code: "H92", referenceUnit: null, conversionFactor: null, quantityKinds: null },
        "percentPerTenThousand": { name: "percentPerTenThousand", label: "percent per ten thousand", symbol: "%/10000", code: "H91", referenceUnit: null, conversionFactor: null, quantityKinds: null },
        "percentPerThousand": { name: "percentPerThousand", label: "percent per thousand", symbol: "%/1000", code: "H94", referenceUnit: null, conversionFactor: null, quantityKinds: null },
        "percentPerVolt": { name: "percentPerVolt", label: "percent per volt", symbol: "%/V", code: "H95", referenceUnit: null, conversionFactor: null, quantityKinds: null },
        "percentVolume": { name: "percentVolume", label: "percent volume", symbol: null, code: "VP", referenceUnit: null, conversionFactor: null, quantityKinds: null },
        "percentWeight": { name: "percentWeight", label: "percent weight", symbol: null, code: "60", referenceUnit: null, conversionFactor: null, quantityKinds: null },
        "perm0Degreesc": { name: "perm0Degreesc", label: "perm (0 °C)", symbol: "perm (0 °C)", code: "P91", referenceUnit: function() { return samm.units["kilogramPerSquareMetrePascalSecond"] }, conversionFactor: "5.72135 × 10⁻¹¹ kg/(m² × Pa × s)", quantityKinds: null },
        "perm23Degreesc": { name: "perm23Degreesc", label: "perm (23 °C)", symbol: "perm (23 °C)", code: "P92", referenceUnit: function() { return samm.units["kilogramPerSquareMetrePascalSecond"] }, conversionFactor: "5.74525 × 10⁻¹¹ kg/(m² × Pa × s)", quantityKinds: null },
        "person": { name: "person", label: "person", symbol: null, code: "IE", referenceUnit: null, conversionFactor: null, quantityKinds: null },
        "petabit": { name: "petabit", label: "petabit", symbol: "Pbit", code: "E78", referenceUnit: null, conversionFactor: null, quantityKinds: null },
        "petabitPerSecond": { name: "petabitPerSecond", label: "petabit per second", symbol: "Pbit/s", code: "E79", referenceUnit: null, conversionFactor: null, quantityKinds: null },
        "petabyte": { name: "petabyte", label: "petabyte", symbol: "Pbyte", code: "E36", referenceUnit: function() { return samm.units["byte"] }, conversionFactor: "10¹⁵ B", quantityKinds: [ "informationEntropy", "informationEntropy" ] },
        "petajoule": { name: "petajoule", label: "petajoule", symbol: "PJ", code: "C68", referenceUnit: function() { return samm.units["joule"] }, conversionFactor: "10¹⁵ J", quantityKinds: [ "quantityOfHeat", "reactionEnergy", "workFunction", "activeEnergy", "kineticEnergy", "levelWidth", "meanEnergyImparted", "helmholtzFunction", "radiantEnergy", "potentialEnergy", "energy", "thermodynamicEnergy", "helmholtzFreeEnergy", "work", "heat", "hartreeEnergy", "energyImparted", "enthalpy", "alphaDisintegrationEnergy", "kineticEnergy", "potentialEnergy", "work", "energy" ] },
        "pferdestaerke": { name: "pferdestaerke", label: "Pferdestaerke", symbol: "PS", code: "N12", referenceUnit: function() { return samm.units["watt"] }, conversionFactor: "7.354988 × 10² W", quantityKinds: [ "radiantEnergyflux", "activePower", "heatFlowRate", "soundPower", "power", "radiantPower", "powerForDirectCurrent", "power" ] },
        "pfund": { name: "pfund", label: "pfund", symbol: "pfd", code: "M86", referenceUnit: function() { return samm.units["kilogram"] }, conversionFactor: "0.5 kg", quantityKinds: [ "mass", "massOfAtomOfANuclideX", "massOfMolecule", "effectiveMass", "mass", "nuclidicMass", "massExcess" ] },
        "phon": { name: "phon", label: "phon", symbol: null, code: "C69", referenceUnit: null, conversionFactor: null, quantityKinds: [ "loudnessLevel" ] },
        "phot": { name: "phot", label: "phot", symbol: "ph", code: "P26", referenceUnit: null, conversionFactor: null, quantityKinds: [ "illuminance" ] },
        "pica": { name: "pica", label: "pica", symbol: null, code: "R1", referenceUnit: function() { return samm.units["metre"] }, conversionFactor: "4.217518 × 10⁻³ m", quantityKinds: [ "thickness", "particlePositionVector", "cartesianCoordinates", "focalDistance", "radius", "radiusOfCurvature", "displacementVectorOfIonOrAtom", "lengthOfPath", "diameter", "comptonWavelength", "slowingDownLength", "migrationLength", "meanFreePath", "equilibriumPositionVectorOfIonOrAtom", "instantaneousSoundParticleDisplacement", "imageDistance", "breadth", "length", "halfValueThickness", "coherenceLength", "latticeVector", "londonPenetrationDepth", "diffusionLength", "meanFreePathOfPhononsOrElectrons", "diffusionCoefficientForNeutronFluxDensity", "halfThickness", "height", "electronRadius", "distance", "objectDistance", "bohrRadius", "diffusionCoefficientForNeutronFluenceRate", "nuclearRadius", "wavelength", "fundamentalLatticeVector", "meanLinearRange" ] },
        "picoampere": { name: "picoampere", label: "picoampere", symbol: "pA", code: "C70", referenceUnit: function() { return samm.units["ampere"] }, conversionFactor: "10⁻¹² A", quantityKinds: [ "magnetomotiveForce", "currentLinkage", "magneticPotentialDifference", "electricCurrent", "magneticPotentialDifference", "electricCurrent", "currentLinkage", "magnetomotiveForce" ] },
        "picocoulomb": { name: "picocoulomb", label: "picocoulomb", symbol: "pC", code: "C71", referenceUnit: function() { return samm.units["coulomb"] }, conversionFactor: "10⁻¹² C", quantityKinds: [ "elementaryCharge", "electricFluxFluxOfDisplacement", "electricCharge", "quantityOfElectricity", "electricFluxFluxOfDisplacement", "quantityOfElectricity", "electricCharge" ] },
        "picofarad": { name: "picofarad", label: "picofarad", symbol: "pF", code: "4T", referenceUnit: function() { return samm.units["farad"] }, conversionFactor: "10⁻¹² F", quantityKinds: [ "capacitance", "capacitance" ] },
        "picofaradPerMetre": { name: "picofaradPerMetre", label: "picofarad per metre", symbol: "pF/m", code: "C72", referenceUnit: function() { return samm.units["faradPerMetre"] }, conversionFactor: "10⁻¹² F/m", quantityKinds: [ "electricConstant", "permittivity", "permittivityOfVacuum", "permittivityOfVacuum", "permittivity", "electricConstant" ] },
        "picohenry": { name: "picohenry", label: "picohenry", symbol: "pH", code: "C73", referenceUnit: function() { return samm.units["henry"] }, conversionFactor: "10⁻¹² H", quantityKinds: [ "mutualInductance", "permeance", "selfInductance", "selfInductance", "permeance", "mutualInductance" ] },
        "picometre": { name: "picometre", label: "picometre", symbol: "pm", code: "C52", referenceUnit: function() { return samm.units["metre"] }, conversionFactor: "10⁻¹² m", quantityKinds: [ "radiusOfCurvature", "distance", "breadth", "lengthOfPath", "radius", "length", "thickness", "cartesianCoordinates", "height", "diameter", "thickness", "particlePositionVector", "cartesianCoordinates", "focalDistance", "radius", "radiusOfCurvature", "displacementVectorOfIonOrAtom", "lengthOfPath", "diameter", "comptonWavelength", "slowingDownLength", "migrationLength", "meanFreePath", "equilibriumPositionVectorOfIonOrAtom", "instantaneousSoundParticleDisplacement", "imageDistance", "breadth", "length", "halfValueThickness", "coherenceLength", "latticeVector", "londonPenetrationDepth", "diffusionLength", "meanFreePathOfPhononsOrElectrons", "diffusionCoefficientForNeutronFluxDensity", "halfThickness", "height", "electronRadius", "distance", "objectDistance", "bohrRadius", "diffusionCoefficientForNeutronFluenceRate", "nuclearRadius", "wavelength", "fundamentalLatticeVector", "meanLinearRange" ] },
        "picopascalPerKilometre": { name: "picopascalPerKilometre", label: "picopascal per kilometre", symbol: "pPa/km", code: "H69", referenceUnit: null, conversionFactor: null, quantityKinds: [ "hardnessIndex" ] },
        "picosecond": { name: "picosecond", label: "picosecond", symbol: "ps", code: "H70", referenceUnit: function() { return samm.units["secondUnitOfTime"] }, conversionFactor: "10⁻¹² s", quantityKinds: [ "timeConstant", "reactorTimeConstant", "halfLife", "meanLife", "time", "relaxationTime", "period", "carrierLifeTime", "periodicTime", "reverberationTime", "time" ] },
        "picosiemens": { name: "picosiemens", label: "picosiemens", symbol: "pS", code: "N92", referenceUnit: function() { return samm.units["siemens"] }, conversionFactor: "10⁻¹² S", quantityKinds: [ "conductanceForDirectCurrent", "admittance", "modulusOfAdmittance", "conductanceForAlternatingCurrent", "complexAdmittance", "conductanceForAlternatingCurrent", "complexAdmittance", "admittance", "conductanceForDirectCurrent", "modulusOfAdmittance" ] },
        "picosiemensPerMetre": { name: "picosiemensPerMetre", label: "picosiemens per metre", symbol: "pS/m", code: "L42", referenceUnit: function() { return samm.units["siemensPerMetre"] }, conversionFactor: "10⁻¹² S/m", quantityKinds: [ "electrolyticConductivity", "conductivity", "conductivity" ] },
        "picovolt": { name: "picovolt", label: "picovolt", symbol: "pV", code: "N99", referenceUnit: function() { return samm.units["volt"] }, conversionFactor: "10⁻¹² V", quantityKinds: [ "tension", "voltage", "peltierCoefficientForSubstancesAAndB", "electromotiveForce", "thermoelectromotiveForceBetweenSubstancesAAndB", "potentialDifference", "electricPotential", "voltage", "potentialDifference", "electromotiveForce", "tension", "electricPotential" ] },
        "picowatt": { name: "picowatt", label: "picowatt", symbol: "pW", code: "C75", referenceUnit: function() { return samm.units["watt"] }, conversionFactor: "10⁻¹² W", quantityKinds: [ "radiantEnergyflux", "activePower", "heatFlowRate", "soundPower", "power", "radiantPower", "powerForDirectCurrent", "powerForDirectCurrent", "activePower" ] },
        "picowattPerSquareMetre": { name: "picowattPerSquareMetre", label: "picowatt per square metre", symbol: "pW/m²", code: "C76", referenceUnit: function() { return samm.units["wattPerSquareMetre"] }, conversionFactor: "10⁻¹² W/m²", quantityKinds: [ "soundIntensity", "poyntingVector", "fluenceRate", "irradiance", "soundIntensity", "radiantEnergy", "firstRadiationConstant", "energyFluenceRate", "energyFluxDensity", "densityOfHeatFlowRate", "radiantExitance" ] },
        "piece": { name: "piece", label: "piece", symbol: null, code: "H87", referenceUnit: null, conversionFactor: null, quantityKinds: null },
        "ping": { name: "ping", label: "ping", symbol: null, code: "E19", referenceUnit: function() { return samm.units["squareMetre"] }, conversionFactor: "3.305 m²", quantityKinds: [ "area", "atomicAttenuationCoefficient", "migrationArea", "crossSection", "equivalentAbsorptionAreaOfASurfaceOrObject", "nuclearQuadrupoleMoment", "slowingDownArea", "diffusionArea" ] },
        "pintUk": { name: "pintUk", label: "pint (UK)", symbol: "pt (UK)", code: "PTI", referenceUnit: function() { return samm.units["cubicMetre"] }, conversionFactor: "5. 68261 × 10⁻⁴ m³", quantityKinds: [ "volume", "sectionModulus", "volume" ] },
        "pintUkPerDay": { name: "pintUkPerDay", label: "pint (UK) per day", symbol: "pt (UK)/d", code: "L53", referenceUnit: function() { return samm.units["cubicMetrePerSecond"] }, conversionFactor: "6.577098 × 10⁻⁹ m³/s", quantityKinds: [ "volumeFlowRate", "volumeFlowRate", "recombinationCoefficient", "instantaneousVolumeFlowRate" ] },
        "pintUkPerHour": { name: "pintUkPerHour", label: "pint (UK) per hour", symbol: "pt (UK)/h", code: "L54", referenceUnit: function() { return samm.units["cubicMetrePerSecond"] }, conversionFactor: "1.578504 × 10⁻⁷ m³/s", quantityKinds: [ "volumeFlowRate", "recombinationCoefficient", "instantaneousVolumeFlowRate", "volumeFlowRate" ] },
        "pintUkPerMinute": { name: "pintUkPerMinute", label: "pint (UK) per minute", symbol: "pt (UK)/min", code: "L55", referenceUnit: function() { return samm.units["cubicMetrePerSecond"] }, conversionFactor: "9.471022 × 10⁻⁶ m³/s", quantityKinds: [ "volumeFlowRate", "recombinationCoefficient", "instantaneousVolumeFlowRate", "volumeFlowRate" ] },
        "pintUkPerSecond": { name: "pintUkPerSecond", label: "pint (UK) per second", symbol: "pt (UK)/s", code: "L56", referenceUnit: function() { return samm.units["cubicMetrePerSecond"] }, conversionFactor: "5.682613 × 10⁻⁴ m³/s", quantityKinds: [ "volumeFlowRate", "recombinationCoefficient", "instantaneousVolumeFlowRate", "volumeFlowRate" ] },
        "pintUsLiquidPerDay": { name: "pintUsLiquidPerDay", label: "pint (US liquid) per day", symbol: "pt (US liq.)/d", code: "L57", referenceUnit: function() { return samm.units["cubicMetrePerSecond"] }, conversionFactor: "5.476580 × 10⁻⁹ m³/s", quantityKinds: [ "volumeFlowRate", "recombinationCoefficient", "instantaneousVolumeFlowRate", "volumeFlowRate" ] },
        "pintUsLiquidPerHour": { name: "pintUsLiquidPerHour", label: "pint (US liquid) per hour", symbol: "pt (US liq.)/h", code: "L58", referenceUnit: function() { return samm.units["cubicMetrePerSecond"] }, conversionFactor: "1.314379 × 10⁻⁷ m³/s", quantityKinds: [ "volumeFlowRate", "volumeFlowRate", "recombinationCoefficient", "instantaneousVolumeFlowRate" ] },
        "pintUsLiquidPerMinute": { name: "pintUsLiquidPerMinute", label: "pint (US liquid) per minute", symbol: "pt (US liq.)/min", code: "L59", referenceUnit: function() { return samm.units["cubicMetrePerSecond"] }, conversionFactor: "7.886275 × 10⁻⁶ m³/s", quantityKinds: [ "volumeFlowRate", "recombinationCoefficient", "instantaneousVolumeFlowRate", "volumeFlowRate" ] },
        "pintUsLiquidPerSecond": { name: "pintUsLiquidPerSecond", label: "pint (US liquid) per second", symbol: "pt (US liq.)/s", code: "L60", referenceUnit: function() { return samm.units["cubicMetrePerSecond"] }, conversionFactor: "4.731765 × 10⁻⁴ m³/s", quantityKinds: [ "volumeFlowRate", "volumeFlowRate", "recombinationCoefficient", "instantaneousVolumeFlowRate" ] },
        "pipelineJoint": { name: "pipelineJoint", label: "pipeline joint", symbol: null, code: "JNT", referenceUnit: null, conversionFactor: null, quantityKinds: null },
        "pitch": { name: "pitch", label: "pitch", symbol: null, code: "PI", referenceUnit: null, conversionFactor: null, quantityKinds: null },
        "pixel": { name: "pixel", label: "pixel", symbol: null, code: "E37", referenceUnit: null, conversionFactor: null, quantityKinds: null },
        "poise": { name: "poise", label: "poise", symbol: "P", code: "89", referenceUnit: function() { return samm.units["pascalSecond"] }, conversionFactor: "0.1 Pa × s", quantityKinds: [ "viscosityDynamicViscosity", "viscosityDynamicViscosity" ] },
        "poisePerBar": { name: "poisePerBar", label: "poise per bar", symbol: "P/bar", code: "F06", referenceUnit: function() { return samm.units["secondUnitOfTime"] }, conversionFactor: "10⁻⁶ s", quantityKinds: [ "viscosityDynamicViscosity", "timeConstant", "reactorTimeConstant", "halfLife", "meanLife", "time", "relaxationTime", "period", "carrierLifeTime", "periodicTime", "reverberationTime" ] },
        "poisePerKelvin": { name: "poisePerKelvin", label: "poise per kelvin", symbol: "P/K", code: "F86", referenceUnit: null, conversionFactor: null, quantityKinds: [ "viscosityDynamicViscosity" ] },
        "poisePerPascal": { name: "poisePerPascal", label: "poise per pascal", symbol: "P/Pa", code: "N35", referenceUnit: function() { return samm.units["secondUnitOfTime"] }, conversionFactor: "0.1 s", quantityKinds: [ "viscosityDynamicViscosity", "timeConstant", "reactorTimeConstant", "halfLife", "meanLife", "time", "relaxationTime", "period", "carrierLifeTime", "periodicTime", "reverberationTime" ] },
        "pond": { name: "pond", label: "pond", symbol: "p", code: "M78", referenceUnit: function() { return samm.units["newton"] }, conversionFactor: "9.80665 × 10⁻³ N", quantityKinds: [ "force", "weight", "weight", "force" ] },
        "pound": { name: "pound", label: "pound", symbol: "lb", code: "LBR", referenceUnit: function() { return samm.units["kilogram"] }, conversionFactor: "0.45359237 kg", quantityKinds: [ "massOfAtomOfANuclideX", "massOfMolecule", "effectiveMass", "mass", "nuclidicMass", "massExcess", "mass" ] },
        "poundAvoirdupoisPerCubicFootDegreeFahrenheit": { name: "poundAvoirdupoisPerCubicFootDegreeFahrenheit", label: "pound (avoirdupois) per cubic foot degree Fahrenheit", symbol: "(lb/ft³)/°F", code: "K69", referenceUnit: null, conversionFactor: null, quantityKinds: [ "volumicMass", "massDensity", "density" ] },
        "poundAvoirdupoisPerCubicFootPsi": { name: "poundAvoirdupoisPerCubicFootPsi", label: "pound (avoirdupois) per cubic foot psi", symbol: "(lb/ft³)/psi", code: "K70", referenceUnit: null, conversionFactor: null, quantityKinds: [ "volumicMass", "massDensity", "density" ] },
        "poundAvoirdupoisPerCubicInchDegreeFahrenheit": { name: "poundAvoirdupoisPerCubicInchDegreeFahrenheit", label: "pound (avoirdupois) per cubic inch degree Fahrenheit", symbol: "(lb/in³)/°F", code: "K75", referenceUnit: null, conversionFactor: null, quantityKinds: [ "volumicMass", "massDensity", "density" ] },
        "poundAvoirdupoisPerCubicInchPsi": { name: "poundAvoirdupoisPerCubicInchPsi", label: "pound (avoirdupois) per cubic inch psi", symbol: "(lb/in³)/psi", code: "K76", referenceUnit: function() { return samm.units["kilogramPerCubicMetrePascal"] }, conversionFactor: "4.014632 (kg/m³)/Pa", quantityKinds: [ "volumicMass", "massDensity", "density", "density", "massDensity", "volumicMass" ] },
        "poundAvoirdupoisPerDay": { name: "poundAvoirdupoisPerDay", label: "pound (avoirdupois) per day", symbol: "lb/d", code: "K66", referenceUnit: function() { return samm.units["kilogramPerSecond"] }, conversionFactor: "5.249912 × 10⁻⁶ kg/s", quantityKinds: [ "massFlowRate", "massFlowRate" ] },
        "poundAvoirdupoisPerDegreeFahrenheit": { name: "poundAvoirdupoisPerDegreeFahrenheit", label: "pound (avoirdupois) per degree Fahrenheit", symbol: "lb/°F", code: "K64", referenceUnit: function() { return samm.units["kilogramPerKelvin"] }, conversionFactor: "0.8164663 kg/K", quantityKinds: [ "volumicMass", "massDensity", "density", "mass" ] },
        "poundAvoirdupoisPerGallonUk": { name: "poundAvoirdupoisPerGallonUk", label: "pound (avoirdupois) per gallon (UK)", symbol: "lb/gal (UK)", code: "K71", referenceUnit: function() { return samm.units["kilogramPerCubicMetre"] }, conversionFactor: "99.77637 kg/m³", quantityKinds: [ "amountOfSubstance", "massDensity", "density", "concentrationOfB", "massConcentrationOfB", "volumicMass", "volumicMass", "density", "massDensity" ] },
        "poundAvoirdupoisPerHourDegreeFahrenheit": { name: "poundAvoirdupoisPerHourDegreeFahrenheit", label: "pound (avoirdupois) per hour degree Fahrenheit", symbol: "(lb/h)/°F", code: "K73", referenceUnit: null, conversionFactor: null, quantityKinds: [ "massFlowRate" ] },
        "poundAvoirdupoisPerHourPsi": { name: "poundAvoirdupoisPerHourPsi", label: "pound (avoirdupois) per hour psi", symbol: "(lb/h)/psi", code: "K74", referenceUnit: function() { return samm.units["kilogramPerSecondPascal"] }, conversionFactor: "1.827445 × 10⁻⁸ (kg/s)/Pa", quantityKinds: [ "massFlowRate", "massFlowRate" ] },
        "poundAvoirdupoisPerMinute": { name: "poundAvoirdupoisPerMinute", label: "pound (avoirdupois) per minute", symbol: "lb/min", code: "K78", referenceUnit: function() { return samm.units["kilogramPerSecond"] }, conversionFactor: "7.559873 × 10⁻³ kg/s", quantityKinds: [ "massFlowRate", "massFlowRate" ] },
        "poundAvoirdupoisPerMinuteDegreeFahrenheit": { name: "poundAvoirdupoisPerMinuteDegreeFahrenheit", label: "pound (avoirdupois) per minute degree Fahrenheit", symbol: "lb/(min·°F)", code: "K79", referenceUnit: null, conversionFactor: null, quantityKinds: [ "massFlowRate" ] },
        "poundAvoirdupoisPerMinutePsi": { name: "poundAvoirdupoisPerMinutePsi", label: "pound (avoirdupois) per minute psi", symbol: "(lb/min)/psi", code: "K80", referenceUnit: function() { return samm.units["kilogramPerSecondPascal"] }, conversionFactor: "1.096467 × 10⁻⁶ (kg/s)/Pa", quantityKinds: [ "massFlowRate", "massFlowRate" ] },
        "poundAvoirdupoisPerPsi": { name: "poundAvoirdupoisPerPsi", label: "pound (avoirdupois) per psi", symbol: "lb/psi", code: "K77", referenceUnit: function() { return samm.units["kilogramPerPascal"] }, conversionFactor: "6.578802 × 10⁻⁵ kg/Pa", quantityKinds: [ "volumicMass", "density", "massDensity", "volumicMass", "massDensity", "density" ] },
        "poundAvoirdupoisPerSecond": { name: "poundAvoirdupoisPerSecond", label: "pound (avoirdupois) per second", symbol: "lb/s", code: "K81", referenceUnit: function() { return samm.units["kilogramPerSecond"] }, conversionFactor: "0.4535924 kg/s", quantityKinds: [ "massFlowRate", "massFlowRate" ] },
        "poundAvoirdupoisPerSecondDegreeFahrenheit": { name: "poundAvoirdupoisPerSecondDegreeFahrenheit", label: "pound (avoirdupois) per second degree Fahrenheit", symbol: "(lb/s)/°F", code: "K82", referenceUnit: null, conversionFactor: null, quantityKinds: [ "massFlowRate" ] },
        "poundAvoirdupoisPerSecondPsi": { name: "poundAvoirdupoisPerSecondPsi", label: "pound (avoirdupois) per second psi", symbol: "(lb/s)/psi", code: "K83", referenceUnit: function() { return samm.units["kilogramPerSecondPascal"] }, conversionFactor: "6.578802 × 10⁻⁵ (kg/s)/Pa", quantityKinds: [ "massFlowRate", "massFlowRate" ] },
        "poundAvoirdupoisSquareFoot": { name: "poundAvoirdupoisSquareFoot", label: "pound (avoirdupois) square foot", symbol: "lb·ft²", code: "K65", referenceUnit: function() { return samm.units["kilogramMetreSquared"] }, conversionFactor: "4.214011 × 10⁻² kg × m²", quantityKinds: [ "momentOfInertiaDynamicMomentOfInertia", "momentOfInertiaDynamicMomentOfInertia" ] },
        "poundFootPerSecond": { name: "poundFootPerSecond", label: "pound foot per second", symbol: "lb·(ft/s)", code: "N10", referenceUnit: function() { return samm.units["kilogramMetrePerSecond"] }, conversionFactor: "1.382550 × 10⁻¹ kg × m/s", quantityKinds: [ "momentum", "momentum" ] },
        "poundForce": { name: "poundForce", label: "pound-force", symbol: "lbf", code: "C78", referenceUnit: function() { return samm.units["newton"] }, conversionFactor: "4.448222 N", quantityKinds: [ "weight", "force", "weight", "force" ] },
        "poundForceFoot": { name: "poundForceFoot", label: "pound-force foot", symbol: "lbf·ft", code: "M92", referenceUnit: function() { return samm.units["newtonMetre"] }, conversionFactor: "1.355818 N × m", quantityKinds: [ "momentOfForce", "momentOfACouple", "torque", "torque", "momentOfForce", "momentOfACouple" ] },
        "poundForceFootPerAmpere": { name: "poundForceFootPerAmpere", label: "pound-force foot per ampere", symbol: "lbf·ft/A", code: "F22", referenceUnit: null, conversionFactor: null, quantityKinds: [ "torque", "momentOfForce", "momentOfACouple" ] },
        "poundForceFootPerInch": { name: "poundForceFootPerInch", label: "pound-force foot per inch", symbol: "lbf·ft/in", code: "P89", referenceUnit: null, conversionFactor: null, quantityKinds: null },
        "poundForceFootPerPound": { name: "poundForceFootPerPound", label: "pound-force foot per pound", symbol: "lbf·ft/lb", code: "G20", referenceUnit: null, conversionFactor: null, quantityKinds: [ "workPerUnitWeight", "momentOfForce", "momentOfACouple", "torque" ] },
        "poundForceInch": { name: "poundForceInch", label: "pound-force inch", symbol: "lbf·in", code: "F21", referenceUnit: null, conversionFactor: null, quantityKinds: [ "torque", "momentOfForce", "momentOfACouple" ] },
        "poundForceInchPerInch": { name: "poundForceInchPerInch", label: "pound-force inch per inch", symbol: "lbf·in/in", code: "P90", referenceUnit: null, conversionFactor: null, quantityKinds: null },
        "poundForcePerFoot": { name: "poundForcePerFoot", label: "pound-force per foot", symbol: "lbf/ft", code: "F17", referenceUnit: null, conversionFactor: null, quantityKinds: [ "forceDividedByLength" ] },
        "poundForcePerInch": { name: "poundForcePerInch", label: "pound-force per inch", symbol: "lbf/in", code: "F48", referenceUnit: null, conversionFactor: null, quantityKinds: [ "forceDividedByLength" ] },
        "poundForcePerSquareFoot": { name: "poundForcePerSquareFoot", label: "pound-force per square foot", symbol: "lbf/ft²", code: "K85", referenceUnit: function() { return samm.units["pascal"] }, conversionFactor: "47.88026 Pa", quantityKinds: [ "fugacityOfBInAGaseousMixture", "pressure", "shearModulus", "staticPressure", "normalStress", "modulusOfRigidity", "instantaneousSoundPressure", "modulusOfElasticity", "shearStress", "modulusOfCompression", "partialPressureOfBInAGaseousMixture", "bulkModulus", "osmoticPressure", "pressure", "shearModulus", "bulkModulus", "modulusOfElasticity", "modulusOfRigidity", "normalStress", "modulusOfCompression", "shearStress" ] },
        "poundForcePerSquareInch": { name: "poundForcePerSquareInch", label: "pound-force per square inch", symbol: "lbf/in²", code: "PS", referenceUnit: function() { return samm.units["pascal"] }, conversionFactor: "6.894757 × 10³ Pa", quantityKinds: [ "bulkModulus", "modulusOfElasticity", "modulusOfCompression", "modulusOfRigidity", "normalStress", "shearStress", "pressure", "shearModulus", "fugacityOfBInAGaseousMixture", "pressure", "shearModulus", "staticPressure", "normalStress", "modulusOfRigidity", "instantaneousSoundPressure", "modulusOfElasticity", "shearStress", "modulusOfCompression", "partialPressureOfBInAGaseousMixture", "bulkModulus", "osmoticPressure" ] },
        "poundForcePerSquareInchDegreeFahrenheit": { name: "poundForcePerSquareInchDegreeFahrenheit", label: "pound-force per square inch degree Fahrenheit", symbol: "psi/°F", code: "K86", referenceUnit: function() { return samm.units["pascalPerKelvin"] }, conversionFactor: "1.241056 × 10⁴ Pa/K", quantityKinds: [ "pressureCoefficient", "pressure", "normalStress", "modulusOfRigidity", "shearModulus", "modulusOfElasticity", "shearStress", "bulkModulus", "modulusOfCompression" ] },
        "poundForcePerYard": { name: "poundForcePerYard", label: "pound-force per yard", symbol: "lbf/yd", code: "N33", referenceUnit: function() { return samm.units["newtonPerMetre"] }, conversionFactor: "4.864635 N/m", quantityKinds: [ "surfaceTension", "surfaceTension" ] },
        "poundForceSecondPerSquareFoot": { name: "poundForceSecondPerSquareFoot", label: "pound-force second per square foot", symbol: "lbf·s/ft²", code: "K91", referenceUnit: function() { return samm.units["pascalSecond"] }, conversionFactor: "47.88026 Pa × s", quantityKinds: [ "viscosityDynamicViscosity", "viscosityDynamicViscosity" ] },
        "poundForceSecondPerSquareInch": { name: "poundForceSecondPerSquareInch", label: "pound-force second per square inch", symbol: "lbf·s/in²", code: "K92", referenceUnit: function() { return samm.units["pascalSecond"] }, conversionFactor: "6.894757 × 10³ Pa × s", quantityKinds: [ "viscosityDynamicViscosity", "viscosityDynamicViscosity" ] },
        "poundInchPerSecond": { name: "poundInchPerSecond", label: "pound inch per second", symbol: "lb·(in/s)", code: "N11", referenceUnit: function() { return samm.units["kilogramMetrePerSecond"] }, conversionFactor: "1.152125 × 10⁻² kg × m/s", quantityKinds: [ "momentum", "momentum" ] },
        "poundInchSquared": { name: "poundInchSquared", label: "pound inch squared", symbol: "lb·in²", code: "F20", referenceUnit: function() { return samm.units["kilogramMetreSquared"] }, conversionFactor: "2.926397 × 10⁻⁴ kg × m²", quantityKinds: [ "momentOfInertiaDynamicMomentOfInertia", "momentOfInertiaDynamicMomentOfInertia" ] },
        "poundMole": { name: "poundMole", label: "pound mole", symbol: "lbmol", code: "P44", referenceUnit: function() { return samm.units["mole"] }, conversionFactor: "453.5924 mol", quantityKinds: [ "amountOfSubstance", "amountOfSubstance" ] },
        "poundMolePerMinute": { name: "poundMolePerMinute", label: "pound mole per minute", symbol: "lbmol/h", code: "P46", referenceUnit: function() { return samm.units["molePerSecond"] }, conversionFactor: "7.559873 mol/s", quantityKinds: [ "volumicMass", "density", "concentrationOfB", "massConcentrationOfB", "amountOfSubstance", "massDensity", "catalyticActivity" ] },
        "poundMolePerPound": { name: "poundMolePerPound", label: "pound mole per pound", symbol: "lbmol/lb", code: "P48", referenceUnit: function() { return samm.units["molePerKilogram"] }, conversionFactor: "10³ mol/kg", quantityKinds: [ "molalityOfSoluteB", "ionicStrength" ] },
        "poundMolePerSecond": { name: "poundMolePerSecond", label: "pound mole per second", symbol: "lbmol/s", code: "P45", referenceUnit: function() { return samm.units["molePerSecond"] }, conversionFactor: "4.535924 × 10² mol/s", quantityKinds: [ "volumicMass", "density", "concentrationOfB", "massConcentrationOfB", "amountOfSubstance", "massDensity", "catalyticActivity" ] },
        "poundPerCubicFoot": { name: "poundPerCubicFoot", label: "pound per cubic foot", symbol: "lb/ft³", code: "87", referenceUnit: function() { return samm.units["kilogramPerCubicMetre"] }, conversionFactor: "1.601846 × 10¹ kg/m³", quantityKinds: [ "density", "massDensity", "volumicMass", "amountOfSubstance", "massDensity", "density", "concentrationOfB", "massConcentrationOfB", "volumicMass" ] },
        "poundPerCubicInch": { name: "poundPerCubicInch", label: "pound per cubic inch", symbol: "lb/in³", code: "LA", referenceUnit: function() { return samm.units["kilogramPerCubicMetre"] }, conversionFactor: "2.767990 × 10⁴ kg/m³", quantityKinds: [ "amountOfSubstance", "massDensity", "density", "concentrationOfB", "massConcentrationOfB", "volumicMass", "volumicMass", "density", "massDensity" ] },
        "poundPerCubicYard": { name: "poundPerCubicYard", label: "pound per cubic yard", symbol: "lb/yd³", code: "K84", referenceUnit: function() { return samm.units["kilogramPerCubicMetre"] }, conversionFactor: "0.5932764 kg/m³", quantityKinds: [ "volumicMass", "density", "massDensity", "amountOfSubstance", "massDensity", "density", "concentrationOfB", "massConcentrationOfB", "volumicMass" ] },
        "poundPerFoot": { name: "poundPerFoot", label: "pound per foot", symbol: "lb/ft", code: "P2", referenceUnit: function() { return samm.units["kilogramPerMetre"] }, conversionFactor: "1.488164 kg/m", quantityKinds: [ "linearMass", "linearDensity", "linearMass", "linearDensity" ] },
        "poundPerFootDay": { name: "poundPerFootDay", label: "pound per foot day", symbol: "lb/(ft·d)", code: "N44", referenceUnit: function() { return samm.units["pascalSecond"] }, conversionFactor: "1.722412 × 10⁻⁵ Pa × s", quantityKinds: [ "viscosityDynamicViscosity", "viscosityDynamicViscosity" ] },
        "poundPerFootHour": { name: "poundPerFootHour", label: "pound per foot hour", symbol: "lb/(ft·h)", code: "K67", referenceUnit: function() { return samm.units["pascalSecond"] }, conversionFactor: "4.133789 × 10⁻⁴ Pa × s", quantityKinds: [ "viscosityDynamicViscosity", "viscosityDynamicViscosity" ] },
        "poundPerFootMinute": { name: "poundPerFootMinute", label: "pound per foot minute", symbol: "lb/(ft·min)", code: "N43", referenceUnit: function() { return samm.units["pascalSecond"] }, conversionFactor: "2.480273 × 10⁻² Pa × s", quantityKinds: [ "viscosityDynamicViscosity", "viscosityDynamicViscosity" ] },
        "poundPerFootSecond": { name: "poundPerFootSecond", label: "pound per foot second", symbol: "lb/(ft·s)", code: "K68", referenceUnit: function() { return samm.units["pascalSecond"] }, conversionFactor: "1.488164 Pa × s", quantityKinds: [ "viscosityDynamicViscosity", "viscosityDynamicViscosity" ] },
        "poundPerGallonUs": { name: "poundPerGallonUs", label: "pound per gallon (US)", symbol: "lb/gal (US)", code: "GE", referenceUnit: function() { return samm.units["kilogramPerCubicMetre"] }, conversionFactor: "1.198264 × 10² kg/m³", quantityKinds: [ "density", "volumicMass", "massDensity", "amountOfSubstance", "massDensity", "density", "concentrationOfB", "massConcentrationOfB", "volumicMass" ] },
        "poundPerHour": { name: "poundPerHour", label: "pound per hour", symbol: "lb/h", code: "4U", referenceUnit: function() { return samm.units["kilogramPerSecond"] }, conversionFactor: "1.259979 × 10⁻⁴ kg/s", quantityKinds: [ "massFlowRate", "massFlowRate" ] },
        "poundPerInchOfLengthUnit": { name: "poundPerInchOfLengthUnit", label: "pound per inch of length", symbol: "lb/in", code: "PO", referenceUnit: function() { return samm.units["kilogramPerMetre"] }, conversionFactor: "1.785797 × 10¹ kg/m", quantityKinds: [ "linearMass", "linearDensity", "linearDensity", "linearMass" ] },
        "poundPerPound": { name: "poundPerPound", label: "pound per pound", symbol: "lb/lb", code: "M91", referenceUnit: null, conversionFactor: null, quantityKinds: [ "massRatio" ] },
        "poundPerReam": { name: "poundPerReam", label: "pound per ream", symbol: null, code: "RP", referenceUnit: null, conversionFactor: null, quantityKinds: null },
        "poundPerSquareFoot": { name: "poundPerSquareFoot", label: "pound per square foot", symbol: "lb/ft²", code: "FP", referenceUnit: function() { return samm.units["kilogramPerSquareMetre"] }, conversionFactor: "4.882428 kg/m²", quantityKinds: [ "modulusOfCompression", "bulkModulus", "modulusOfRigidity", "shearModulus", "modulusOfElasticity", "pressure", "shearStress", "normalStress", "surfaceDensity", "meanMassRange", "areicMass" ] },
        "poundPerSquareInchAbsolute": { name: "poundPerSquareInchAbsolute", label: "pound per square inch absolute", symbol: "lb/in²", code: "80", referenceUnit: function() { return samm.units["kilogramPerSquareMetre"] }, conversionFactor: "7.030696 × 10² kg/m²", quantityKinds: [ "normalStress", "modulusOfRigidity", "modulusOfCompression", "pressure", "bulkModulus", "modulusOfElasticity", "shearModulus", "shearStress", "surfaceDensity", "meanMassRange", "areicMass" ] },
        "poundPerSquareYard": { name: "poundPerSquareYard", label: "pound per square yard", symbol: "lb/yd²", code: "N25", referenceUnit: function() { return samm.units["kilogramPerSquareMetre"] }, conversionFactor: "5.424919 × 10⁻¹ kg/m²", quantityKinds: [ "modulusOfCompression", "modulusOfRigidity", "shearStress", "modulusOfElasticity", "pressure", "shearModulus", "bulkModulus", "normalStress", "surfaceDensity", "meanMassRange", "areicMass" ] },
        "poundPerYard": { name: "poundPerYard", label: "pound per yard", symbol: "lb/yd", code: "M84", referenceUnit: function() { return samm.units["kilogramPerMetre"] }, conversionFactor: "4.960546 × 10⁻¹ kg/m", quantityKinds: [ "linearMass", "linearDensity", "linearMass", "linearDensity" ] },
        "poundal": { name: "poundal", label: "poundal", symbol: "pdl", code: "M76", referenceUnit: function() { return samm.units["newton"] }, conversionFactor: "1.382550 × 10⁻¹ N", quantityKinds: [ "weight", "force", "weight", "force" ] },
        "poundalFoot": { name: "poundalFoot", label: "poundal foot", symbol: "pdl·ft", code: "M95", referenceUnit: function() { return samm.units["newtonMetre"] }, conversionFactor: "4.214011 × 10⁻² N × m", quantityKinds: [ "torque", "momentOfForce", "momentOfACouple", "torque", "momentOfForce", "momentOfACouple" ] },
        "poundalInch": { name: "poundalInch", label: "poundal inch", symbol: "pdl·in", code: "M96", referenceUnit: function() { return samm.units["newtonMetre"] }, conversionFactor: "3.51167710⁻³ N × m", quantityKinds: [ "torque", "momentOfForce", "momentOfACouple", "torque", "momentOfForce", "momentOfACouple" ] },
        "poundalPerInch": { name: "poundalPerInch", label: "poundal per inch", symbol: "pdl/in", code: "N32", referenceUnit: function() { return samm.units["newtonPerMetre"] }, conversionFactor: "5.443110 N/m", quantityKinds: [ "surfaceTension", "surfaceTension" ] },
        "poundalPerSquareFoot": { name: "poundalPerSquareFoot", label: "poundal per square foot", symbol: "pdl/ft²", code: "N21", referenceUnit: function() { return samm.units["pascal"] }, conversionFactor: "1.488164 Pa", quantityKinds: [ "fugacityOfBInAGaseousMixture", "pressure", "shearModulus", "staticPressure", "normalStress", "modulusOfRigidity", "instantaneousSoundPressure", "modulusOfElasticity", "shearStress", "modulusOfCompression", "partialPressureOfBInAGaseousMixture", "bulkModulus", "osmoticPressure", "bulkModulus", "normalStress", "modulusOfCompression", "shearStress", "shearModulus", "modulusOfElasticity", "pressure", "modulusOfRigidity" ] },
        "poundalPerSquareInch": { name: "poundalPerSquareInch", label: "poundal per square inch", symbol: "pdl/in²", code: "N26", referenceUnit: function() { return samm.units["pascal"] }, conversionFactor: "2.142957 × 10² Pa", quantityKinds: [ "fugacityOfBInAGaseousMixture", "pressure", "shearModulus", "staticPressure", "normalStress", "modulusOfRigidity", "instantaneousSoundPressure", "modulusOfElasticity", "shearStress", "modulusOfCompression", "partialPressureOfBInAGaseousMixture", "bulkModulus", "osmoticPressure", "modulusOfCompression", "bulkModulus", "normalStress", "pressure", "modulusOfRigidity", "shearModulus", "modulusOfElasticity", "shearStress" ] },
        "poundalSecondPerSquareFoot": { name: "poundalSecondPerSquareFoot", label: "poundal second per square foot", symbol: "(pdl/ft²)·s", code: "N34", referenceUnit: function() { return samm.units["pascalSecond"] }, conversionFactor: "1.488164 Pa × s", quantityKinds: [ "viscosityDynamicViscosity", "viscosityDynamicViscosity" ] },
        "poundalSecondPerSquareInch": { name: "poundalSecondPerSquareInch", label: "poundal second per square inch", symbol: "(pdl/in²)·s", code: "N42", referenceUnit: function() { return samm.units["pascalSecond"] }, conversionFactor: "2.142957 × 10² Pa × s", quantityKinds: [ "viscosityDynamicViscosity", "viscosityDynamicViscosity" ] },
        "printPoint": { name: "printPoint", label: "print point", symbol: null, code: "N3", referenceUnit: null, conversionFactor: null, quantityKinds: null },
        "proofGallon": { name: "proofGallon", label: "proof gallon", symbol: null, code: "PGL", referenceUnit: null, conversionFactor: null, quantityKinds: null },
        "proofLitre": { name: "proofLitre", label: "proof litre", symbol: null, code: "PFL", referenceUnit: null, conversionFactor: null, quantityKinds: null },
        "psiCubicInchPerSecond": { name: "psiCubicInchPerSecond", label: "psi cubic inch per second", symbol: "psi·in³/s", code: "K87", referenceUnit: function() { return samm.units["pascalCubicMetrePerSecond"] }, conversionFactor: "0.112985 Pa × m³/s", quantityKinds: [ "bulkModulus", "shearStress", "modulusOfRigidity", "pressure", "modulusOfCompression", "shearModulus", "normalStress", "modulusOfElasticity", "leakageRateOfGas" ] },
        "psiCubicMetrePerSecond": { name: "psiCubicMetrePerSecond", label: "psi cubic metre per second", symbol: "psi·m³/s", code: "K89", referenceUnit: function() { return samm.units["pascalCubicMetrePerSecond"] }, conversionFactor: "6.894757 × 10³ Pa × m³/s", quantityKinds: [ "bulkModulus", "shearStress", "modulusOfRigidity", "pressure", "modulusOfCompression", "shearModulus", "normalStress", "modulusOfElasticity", "leakageRateOfGas" ] },
        "psiCubicYardPerSecond": { name: "psiCubicYardPerSecond", label: "psi cubic yard per second", symbol: "psi·yd³/s", code: "K90", referenceUnit: function() { return samm.units["pascalCubicMetrePerSecond"] }, conversionFactor: "5.271420 × 10³ Pa × m³/s", quantityKinds: [ "bulkModulus", "shearStress", "modulusOfRigidity", "pressure", "modulusOfCompression", "shearModulus", "normalStress", "modulusOfElasticity", "leakageRateOfGas" ] },
        "psiLitrePerSecond": { name: "psiLitrePerSecond", label: "psi litre per second", symbol: "psi·l/s", code: "K88", referenceUnit: function() { return samm.units["pascalCubicMetrePerSecond"] }, conversionFactor: "6.894757 Pa × m³/s", quantityKinds: [ "bulkModulus", "shearStress", "modulusOfRigidity", "pressure", "modulusOfCompression", "shearModulus", "normalStress", "modulusOfElasticity", "leakageRateOfGas" ] },
        "psiPerInch": { name: "psiPerInch", label: "psi per inch", symbol: "psi/in", code: "P86", referenceUnit: null, conversionFactor: null, quantityKinds: [ "hardnessIndex" ] },
        "psiPerPsi": { name: "psiPerPsi", label: "psi per psi", symbol: "psi/psi", code: "L52", referenceUnit: null, conversionFactor: null, quantityKinds: [ "pressureRatio" ] },
        "quad1015Btuit": { name: "quad1015Btuit", label: "quad (1015 BtuIT)", symbol: "quad", code: "N70", referenceUnit: function() { return samm.units["joule"] }, conversionFactor: "1.055056 × 10¹⁸ J", quantityKinds: [ "quantityOfHeat", "reactionEnergy", "workFunction", "activeEnergy", "kineticEnergy", "levelWidth", "meanEnergyImparted", "helmholtzFunction", "radiantEnergy", "potentialEnergy", "energy", "thermodynamicEnergy", "helmholtzFreeEnergy", "work", "heat", "hartreeEnergy", "energyImparted", "enthalpy", "alphaDisintegrationEnergy", "helmholtzFunction", "thermodynamicEnergy", "helmholtzFreeEnergy", "heat", "enthalpy", "energy", "quantityOfHeat" ] },
        "quartUk": { name: "quartUk", label: "quart (UK)", symbol: "qt (UK)", code: "QTI", referenceUnit: function() { return samm.units["cubicMetre"] }, conversionFactor: "1.1365225 × 10⁻³ m³", quantityKinds: [ "volume", "sectionModulus", "volume" ] },
        "quartUkLiquidPerDay": { name: "quartUkLiquidPerDay", label: "quart (UK liquid) per day", symbol: "qt (UK liq.)/d", code: "K94", referenceUnit: function() { return samm.units["cubicMetrePerSecond"] }, conversionFactor: "1.315420 × 10⁻⁸ m³/s", quantityKinds: [ "volumeFlowRate", "recombinationCoefficient", "instantaneousVolumeFlowRate", "volumeFlowRate" ] },
        "quartUkLiquidPerHour": { name: "quartUkLiquidPerHour", label: "quart (UK liquid) per hour", symbol: "qt (UK liq.)/h", code: "K95", referenceUnit: function() { return samm.units["cubicMetrePerSecond"] }, conversionFactor: "3.157008 × 10⁻⁷ m³/s", quantityKinds: [ "volumeFlowRate", "recombinationCoefficient", "instantaneousVolumeFlowRate", "volumeFlowRate" ] },
        "quartUkLiquidPerMinute": { name: "quartUkLiquidPerMinute", label: "quart (UK liquid) per minute", symbol: "qt (UK liq.)/min", code: "K96", referenceUnit: function() { return samm.units["cubicMetrePerSecond"] }, conversionFactor: "1.894205 × 10⁻⁵ m³/s", quantityKinds: [ "volumeFlowRate", "volumeFlowRate", "recombinationCoefficient", "instantaneousVolumeFlowRate" ] },
        "quartUkLiquidPerSecond": { name: "quartUkLiquidPerSecond", label: "quart (UK liquid) per second", symbol: "qt (UK liq.)/s", code: "K97", referenceUnit: function() { return samm.units["cubicMetrePerSecond"] }, conversionFactor: "1.136523 × 10⁻³ m³/s", quantityKinds: [ "volumeFlowRate", "recombinationCoefficient", "instantaneousVolumeFlowRate", "volumeFlowRate" ] },
        "quartUsLiquidPerDay": { name: "quartUsLiquidPerDay", label: "quart (US liquid) per day", symbol: "qt (US liq.)/d", code: "K98", referenceUnit: function() { return samm.units["cubicMetrePerSecond"] }, conversionFactor: "1.095316 × 10⁻⁸ m³/s", quantityKinds: [ "volumeFlowRate", "volumeFlowRate", "recombinationCoefficient", "instantaneousVolumeFlowRate" ] },
        "quartUsLiquidPerHour": { name: "quartUsLiquidPerHour", label: "quart (US liquid) per hour", symbol: "qt (US liq.)/h", code: "K99", referenceUnit: function() { return samm.units["cubicMetrePerSecond"] }, conversionFactor: "2.628758 × 10⁻⁷ m³/s", quantityKinds: [ "volumeFlowRate", "recombinationCoefficient", "instantaneousVolumeFlowRate", "volumeFlowRate" ] },
        "quartUsLiquidPerMinute": { name: "quartUsLiquidPerMinute", label: "quart (US liquid) per minute", symbol: "qt (US liq.)/min", code: "L10", referenceUnit: function() { return samm.units["cubicMetrePerSecond"] }, conversionFactor: "1.577255 × 10⁻⁵ m³/s", quantityKinds: [ "volumeFlowRate", "recombinationCoefficient", "instantaneousVolumeFlowRate", "volumeFlowRate" ] },
        "quartUsLiquidPerSecond": { name: "quartUsLiquidPerSecond", label: "quart (US liquid) per second", symbol: "qt (US liq.)/s", code: "L11", referenceUnit: function() { return samm.units["cubicMetrePerSecond"] }, conversionFactor: "9.463529 × 10⁻⁴ m³/s", quantityKinds: [ "volumeFlowRate", "recombinationCoefficient", "instantaneousVolumeFlowRate", "volumeFlowRate" ] },
        "quarterOfAYear": { name: "quarterOfAYear", label: "quarter (of a year)", symbol: null, code: "QAN", referenceUnit: null, conversionFactor: null, quantityKinds: null },
        "quarterUk": { name: "quarterUk", label: "quarter (UK)", symbol: "Qr (UK)", code: "QTR", referenceUnit: function() { return samm.units["kilogram"] }, conversionFactor: "12.700 59 kg", quantityKinds: [ "massOfAtomOfANuclideX", "massOfMolecule", "effectiveMass", "mass", "nuclidicMass", "massExcess" ] },
        "quire": { name: "quire", label: "quire", symbol: "qr", code: "QR", referenceUnit: null, conversionFactor: null, quantityKinds: null },
        "rackUnit": { name: "rackUnit", label: "rack unit", symbol: "U or RU", code: "H80", referenceUnit: function() { return samm.units["metre"] }, conversionFactor: "4.445 × 10⁻² m", quantityKinds: [ "thickness", "particlePositionVector", "cartesianCoordinates", "focalDistance", "radius", "radiusOfCurvature", "displacementVectorOfIonOrAtom", "lengthOfPath", "diameter", "comptonWavelength", "slowingDownLength", "migrationLength", "meanFreePath", "equilibriumPositionVectorOfIonOrAtom", "instantaneousSoundParticleDisplacement", "imageDistance", "breadth", "length", "halfValueThickness", "coherenceLength", "latticeVector", "londonPenetrationDepth", "diffusionLength", "meanFreePathOfPhononsOrElectrons", "diffusionCoefficientForNeutronFluxDensity", "halfThickness", "height", "electronRadius", "distance", "objectDistance", "bohrRadius", "diffusionCoefficientForNeutronFluenceRate", "nuclearRadius", "wavelength", "fundamentalLatticeVector", "meanLinearRange" ] },
        "rad": { name: "rad", label: "rad", symbol: "rad", code: "C80", referenceUnit: function() { return samm.units["gray"] }, conversionFactor: "10⁻² Gy", quantityKinds: [ "specificEnergyImparted", "massicEnergyImparted", "absorbedDose" ] },
        "radian": { name: "radian", label: "radian", symbol: "rad", code: "C81", referenceUnit: null, conversionFactor: null, quantityKinds: [ "angleOfOpticalRotation", "phaseDifference", "braggAngle", "lossAngle", "anglePlane", "phaseDisplacement" ] },
        "radianPerMetre": { name: "radianPerMetre", label: "radian per metre", symbol: "rad/m", code: "C84", referenceUnit: null, conversionFactor: null, quantityKinds: [ "angularWaveNumber", "angularWavenumber", "angularRepetency", "debyeAngularRepetency", "debyeAngularWaveNumber" ] },
        "radianPerSecond": { name: "radianPerSecond", label: "radian per second", symbol: "rad/s", code: "2A", referenceUnit: null, conversionFactor: null, quantityKinds: [ "cyclotronAngularFrequency", "angularVelocity", "pulsatance", "debyeAngularFrequency", "angularFrequency", "circularFrequency", "nuclearPrecession" ] },
        "radianPerSecondSquared": { name: "radianPerSecondSquared", label: "radian per second squared", symbol: "rad/s²", code: "2B", referenceUnit: null, conversionFactor: null, quantityKinds: [ "angularAcceleration" ] },
        "radianSquareMetrePerKilogram": { name: "radianSquareMetrePerKilogram", label: "radian square metre per kilogram", symbol: "rad·m²/kg", code: "C83", referenceUnit: null, conversionFactor: null, quantityKinds: [ "specificOpticalRotatoryPower", "rotatoryPower", "massicOptical" ] },
        "radianSquareMetrePerMole": { name: "radianSquareMetrePerMole", label: "radian square metre per mole", symbol: "rad·m²/mol", code: "C82", referenceUnit: null, conversionFactor: null, quantityKinds: [ "molarOpticalRotatoryPower" ] },
        "rate": { name: "rate", label: "rate", symbol: null, code: "A9", referenceUnit: null, conversionFactor: null, quantityKinds: null },
        "ration": { name: "ration", label: "ration", symbol: null, code: "13", referenceUnit: null, conversionFactor: null, quantityKinds: null },
        "ream": { name: "ream", label: "ream", symbol: null, code: "RM", referenceUnit: null, conversionFactor: null, quantityKinds: null },
        "reciprocalAngstrom": { name: "reciprocalAngstrom", label: "reciprocal angstrom", symbol: "Å⁻¹", code: "C85", referenceUnit: function() { return samm.units["reciprocalMetre"] }, conversionFactor: "10¹⁰ m⁻¹", quantityKinds: [ "linearAbsorptionCoefficient", "linearIonizationByAParticle", "attenuationCoefficient", "macroscopicTotalCrossSection", "repetency", "angularWaveNumber", "angularReciprocalLatticeVector", "fundamentalReciprocalLatticeVector", "linearAttenuationCoefficient", "volumicCrossSection", "propagationCoefficient", "linearExtinctionCoefficient", "vergence", "totalIonizationByAParticle", "angularRepetency", "wavenumber", "volumicTotalCrossSection", "lensPower", "waveNumber", "curvature", "phaseCoefficient", "rydbergConstant", "macroscopicCrossSection", "fermiAngularRepetency", "fermiAngularWaveNumber" ] },
        "reciprocalBar": { name: "reciprocalBar", label: "reciprocal bar", symbol: "1/bar", code: "F58", referenceUnit: null, conversionFactor: null, quantityKinds: [ "compressibility", "bulkCompressibility" ] },
        "reciprocalCentimetre": { name: "reciprocalCentimetre", label: "reciprocal centimetre", symbol: "cm⁻¹", code: "E90", referenceUnit: function() { return samm.units["reciprocalMetre"] }, conversionFactor: "10² m⁻¹", quantityKinds: [ "linearAbsorptionCoefficient", "linearIonizationByAParticle", "attenuationCoefficient", "macroscopicTotalCrossSection", "repetency", "angularWaveNumber", "angularReciprocalLatticeVector", "fundamentalReciprocalLatticeVector", "linearAttenuationCoefficient", "volumicCrossSection", "propagationCoefficient", "linearExtinctionCoefficient", "vergence", "totalIonizationByAParticle", "angularRepetency", "wavenumber", "volumicTotalCrossSection", "lensPower", "waveNumber", "curvature", "phaseCoefficient", "rydbergConstant", "macroscopicCrossSection" ] },
        "reciprocalCubicCentimetre": { name: "reciprocalCubicCentimetre", label: "reciprocal cubic centimetre", symbol: "cm⁻³", code: "H50", referenceUnit: function() { return samm.units["reciprocalCubicMetre"] }, conversionFactor: "10⁶ m⁻³", quantityKinds: [ "ionNumberDensity", "numberDensityOfMoleculesOrParticles", "electronNumberDensity", "volumicAcceptorNumber", "ionDensity", "volumicElectronNumber", "neutronNumberDensity", "volumicIntrinsisNumber", "volumicDonorNumber", "volumicNumberOfMoleculesOrParticles", "donorNumberDensity", "molecularConcentrationOfB", "holeNumberDensity", "acceptorNumberDensity", "intrinsicNumberDensity", "volumicHoleNumber", "numberDensityOfMoleculesOrParticles", "molecularConcentrationOfB", "volumicNumberOfMoleculesOrParticles" ] },
        "reciprocalCubicFoot": { name: "reciprocalCubicFoot", label: "reciprocal cubic foot", symbol: "1/ft³", code: "K20", referenceUnit: function() { return samm.units["reciprocalCubicMetre"] }, conversionFactor: "35.31466 m⁻³", quantityKinds: [ "ionNumberDensity", "numberDensityOfMoleculesOrParticles", "electronNumberDensity", "volumicAcceptorNumber", "ionDensity", "volumicElectronNumber", "neutronNumberDensity", "volumicIntrinsisNumber", "volumicDonorNumber", "volumicNumberOfMoleculesOrParticles", "donorNumberDensity", "molecularConcentrationOfB", "holeNumberDensity", "acceptorNumberDensity", "intrinsicNumberDensity", "volumicHoleNumber", "volumicNumberOfMoleculesOrParticles", "numberDensityOfMoleculesOrParticles", "molecularConcentrationOfB" ] },
        "reciprocalCubicInch": { name: "reciprocalCubicInch", label: "reciprocal cubic inch", symbol: "1/in³", code: "K49", referenceUnit: function() { return samm.units["reciprocalCubicMetre"] }, conversionFactor: "6.1023759 × 10⁴ m⁻³", quantityKinds: [ "ionNumberDensity", "numberDensityOfMoleculesOrParticles", "electronNumberDensity", "volumicAcceptorNumber", "ionDensity", "volumicElectronNumber", "neutronNumberDensity", "volumicIntrinsisNumber", "volumicDonorNumber", "volumicNumberOfMoleculesOrParticles", "donorNumberDensity", "molecularConcentrationOfB", "holeNumberDensity", "acceptorNumberDensity", "intrinsicNumberDensity", "volumicHoleNumber", "molecularConcentrationOfB", "volumicNumberOfMoleculesOrParticles", "numberDensityOfMoleculesOrParticles" ] },
        "reciprocalCubicMetre": { name: "reciprocalCubicMetre", label: "reciprocal cubic metre", symbol: "m⁻³", code: "C86", referenceUnit: null, conversionFactor: null, quantityKinds: [ "ionNumberDensity", "numberDensityOfMoleculesOrParticles", "electronNumberDensity", "volumicAcceptorNumber", "ionDensity", "volumicElectronNumber", "neutronNumberDensity", "volumicIntrinsisNumber", "volumicDonorNumber", "volumicNumberOfMoleculesOrParticles", "donorNumberDensity", "molecularConcentrationOfB", "holeNumberDensity", "acceptorNumberDensity", "intrinsicNumberDensity", "volumicHoleNumber" ] },
        "reciprocalCubicMetrePerSecond": { name: "reciprocalCubicMetrePerSecond", label: "reciprocal cubic metre per second", symbol: "m⁻³/s", code: "C87", referenceUnit: null, conversionFactor: null, quantityKinds: [ "slowingDownDensity" ] },
        "reciprocalCubicMillimetre": { name: "reciprocalCubicMillimetre", label: "reciprocal cubic millimetre", symbol: "1/mm³", code: "L20", referenceUnit: function() { return samm.units["reciprocalCubicMetre"] }, conversionFactor: "10⁹ m⁻³", quantityKinds: [ "ionNumberDensity", "numberDensityOfMoleculesOrParticles", "electronNumberDensity", "volumicAcceptorNumber", "ionDensity", "volumicElectronNumber", "neutronNumberDensity", "volumicIntrinsisNumber", "volumicDonorNumber", "volumicNumberOfMoleculesOrParticles", "donorNumberDensity", "molecularConcentrationOfB", "holeNumberDensity", "acceptorNumberDensity", "intrinsicNumberDensity", "volumicHoleNumber", "molecularConcentrationOfB", "volumicNumberOfMoleculesOrParticles", "numberDensityOfMoleculesOrParticles" ] },
        "reciprocalCubicYard": { name: "reciprocalCubicYard", label: "reciprocal cubic yard", symbol: "1/yd³", code: "M10", referenceUnit: function() { return samm.units["reciprocalCubicMetre"] }, conversionFactor: "1.307951 m⁻³", quantityKinds: [ "ionNumberDensity", "numberDensityOfMoleculesOrParticles", "electronNumberDensity", "volumicAcceptorNumber", "ionDensity", "volumicElectronNumber", "neutronNumberDensity", "volumicIntrinsisNumber", "volumicDonorNumber", "volumicNumberOfMoleculesOrParticles", "donorNumberDensity", "molecularConcentrationOfB", "holeNumberDensity", "acceptorNumberDensity", "intrinsicNumberDensity", "volumicHoleNumber", "numberDensityOfMoleculesOrParticles", "molecularConcentrationOfB", "volumicNumberOfMoleculesOrParticles" ] },
        "reciprocalDay": { name: "reciprocalDay", label: "reciprocal day", symbol: "d⁻¹", code: "E91", referenceUnit: function() { return samm.units["reciprocalSecond"] }, conversionFactor: "1.15741 × 10⁻⁵ s⁻¹", quantityKinds: [ "angularFrequency", "decayConstant", "dampingCoefficient", "debyeAngularFrequency", "disintegrationConstant", "photonFlux", "larmorAngularFrequency", "circularFrequency", "pulsatance", "rotationalFrequency" ] },
        "reciprocalDegreeFahrenheit": { name: "reciprocalDegreeFahrenheit", label: "reciprocal degree Fahrenheit", symbol: "1/°F", code: "J26", referenceUnit: null, conversionFactor: null, quantityKinds: [ "temperature" ] },
        "reciprocalElectronVoltPerCubicMetre": { name: "reciprocalElectronVoltPerCubicMetre", label: "reciprocal electron volt per cubic metre", symbol: "eV⁻¹/m³", code: "C88", referenceUnit: function() { return samm.units["reciprocalJoulePerCubicMetre"] }, conversionFactor: "6.24146 × 10¹⁸ J⁻¹/m³", quantityKinds: [ "densityOfStates", "densityOfStates" ] },
        "reciprocalHenry": { name: "reciprocalHenry", label: "reciprocal henry", symbol: "H⁻¹", code: "C89", referenceUnit: null, conversionFactor: null, quantityKinds: [ "reluctance" ] },
        "reciprocalHour": { name: "reciprocalHour", label: "reciprocal hour", symbol: "1/h", code: "H10", referenceUnit: function() { return samm.units["reciprocalSecond"] }, conversionFactor: "2.77778 × 10⁻⁴ s⁻¹", quantityKinds: [ "angularFrequency", "decayConstant", "dampingCoefficient", "debyeAngularFrequency", "disintegrationConstant", "photonFlux", "larmorAngularFrequency", "circularFrequency", "pulsatance", "rotationalFrequency", "frequency" ] },
        "reciprocalInch": { name: "reciprocalInch", label: "reciprocal inch", symbol: "1/in", code: "Q24", referenceUnit: function() { return samm.units["reciprocalMetre"] }, conversionFactor: "39.37008 m⁻¹", quantityKinds: [ "linearAbsorptionCoefficient", "linearIonizationByAParticle", "attenuationCoefficient", "macroscopicTotalCrossSection", "repetency", "angularWaveNumber", "angularReciprocalLatticeVector", "fundamentalReciprocalLatticeVector", "linearAttenuationCoefficient", "volumicCrossSection", "propagationCoefficient", "linearExtinctionCoefficient", "vergence", "totalIonizationByAParticle", "angularRepetency", "wavenumber", "volumicTotalCrossSection", "lensPower", "waveNumber", "curvature", "phaseCoefficient", "rydbergConstant", "macroscopicCrossSection" ] },
        "reciprocalJoule": { name: "reciprocalJoule", label: "reciprocal joule", symbol: "1/J", code: "N91", referenceUnit: null, conversionFactor: null, quantityKinds: [ "performanceCharacteristic", "coefficient" ] },
        "reciprocalJoulePerCubicMetre": { name: "reciprocalJoulePerCubicMetre", label: "reciprocal joule per cubic metre", symbol: "J⁻¹/m³", code: "C90", referenceUnit: null, conversionFactor: null, quantityKinds: [ "densityOfStates" ] },
        "reciprocalKelvinOrKelvinToThePowerMinusOne": { name: "reciprocalKelvinOrKelvinToThePowerMinusOne", label: "reciprocal kelvin or kelvin to the power minus one", symbol: "K⁻¹", code: "C91", referenceUnit: null, conversionFactor: null, quantityKinds: [ "relativePressureCoefficient", "linearExpansionCoefficient", "cubicExpansionCoefficient" ] },
        "reciprocalKilovoltAmpereReciprocalHour": { name: "reciprocalKilovoltAmpereReciprocalHour", label: "reciprocal kilovolt - ampere reciprocal hour", symbol: "1/kVAh", code: "M21", referenceUnit: null, conversionFactor: null, quantityKinds: [ "performanceCharacteristic", "coefficient" ] },
        "reciprocalLitre": { name: "reciprocalLitre", label: "reciprocal litre", symbol: "1/l", code: "K63", referenceUnit: function() { return samm.units["reciprocalCubicMetre"] }, conversionFactor: "10³ m⁻³", quantityKinds: [ "ionNumberDensity", "numberDensityOfMoleculesOrParticles", "electronNumberDensity", "volumicAcceptorNumber", "ionDensity", "volumicElectronNumber", "neutronNumberDensity", "volumicIntrinsisNumber", "volumicDonorNumber", "volumicNumberOfMoleculesOrParticles", "donorNumberDensity", "molecularConcentrationOfB", "holeNumberDensity", "acceptorNumberDensity", "intrinsicNumberDensity", "volumicHoleNumber", "volumicNumberOfMoleculesOrParticles", "molecularConcentrationOfB", "numberDensityOfMoleculesOrParticles" ] },
        "reciprocalMegakelvinOrMegakelvinToThePowerMinusOne": { name: "reciprocalMegakelvinOrMegakelvinToThePowerMinusOne", label: "reciprocal megakelvin or megakelvin to the power minus one", symbol: "1/MK", code: "M20", referenceUnit: function() { return samm.units["reciprocalKelvinOrKelvinToThePowerMinusOne"] }, conversionFactor: "10⁻⁶ K⁻¹", quantityKinds: [ "relativePressureCoefficient", "linearExpansionCoefficient", "cubicExpansionCoefficient", "relativePressureCoefficient", "cubicExpansionCoefficient", "linearExpansionCoefficient" ] },
        "reciprocalMetre": { name: "reciprocalMetre", label: "reciprocal metre", symbol: "m⁻¹", code: "C92", referenceUnit: null, conversionFactor: null, quantityKinds: [ "linearAbsorptionCoefficient", "linearIonizationByAParticle", "attenuationCoefficient", "macroscopicTotalCrossSection", "repetency", "angularWaveNumber", "angularReciprocalLatticeVector", "fundamentalReciprocalLatticeVector", "linearAttenuationCoefficient", "volumicCrossSection", "propagationCoefficient", "linearExtinctionCoefficient", "vergence", "totalIonizationByAParticle", "angularRepetency", "wavenumber", "volumicTotalCrossSection", "lensPower", "waveNumber", "curvature", "phaseCoefficient", "rydbergConstant", "macroscopicCrossSection" ] },
        "reciprocalMetreSquaredReciprocalSecond": { name: "reciprocalMetreSquaredReciprocalSecond", label: "reciprocal metre squared reciprocal second", symbol: "m⁻²/s", code: "B81", referenceUnit: null, conversionFactor: null, quantityKinds: [ "particalFluxDensity", "particleFluenceRate", "neutronFluenceRate", "neutronfluxDensity", "currentDensityOfParticles" ] },
        "reciprocalMinute": { name: "reciprocalMinute", label: "reciprocal minute", symbol: "min⁻¹", code: "C94", referenceUnit: function() { return samm.units["secondUnitOfTime"] }, conversionFactor: "1.666667 × 10⁻² s", quantityKinds: [ "rotationalFrequency", "timeConstant", "reactorTimeConstant", "halfLife", "meanLife", "time", "relaxationTime", "period", "carrierLifeTime", "periodicTime", "reverberationTime" ] },
        "reciprocalMole": { name: "reciprocalMole", label: "reciprocal mole", symbol: "mol⁻¹", code: "C95", referenceUnit: null, conversionFactor: null, quantityKinds: [ "avogadroConstant" ] },
        "reciprocalMonth": { name: "reciprocalMonth", label: "reciprocal month", symbol: "1/mo", code: "H11", referenceUnit: function() { return samm.units["reciprocalSecond"] }, conversionFactor: "3.80257 × 10⁻⁷ s⁻¹", quantityKinds: [ "angularFrequency", "decayConstant", "dampingCoefficient", "debyeAngularFrequency", "disintegrationConstant", "photonFlux", "larmorAngularFrequency", "circularFrequency", "pulsatance", "rotationalFrequency", "frequency" ] },
        "reciprocalPascalOrPascalToThePowerMinusOne": { name: "reciprocalPascalOrPascalToThePowerMinusOne", label: "reciprocal pascal or pascal to the power minus one", symbol: "Pa⁻¹", code: "C96", referenceUnit: null, conversionFactor: null, quantityKinds: [ "isothermalCompressibility", "compressibility", "bulkCompressibility", "isentropicCompressibility" ] },
        "reciprocalPsi": { name: "reciprocalPsi", label: "reciprocal psi", symbol: "1/psi", code: "K93", referenceUnit: function() { return samm.units["reciprocalPascalOrPascalToThePowerMinusOne"] }, conversionFactor: "1.450377 × 10⁻⁴ Pa⁻¹", quantityKinds: [ "amountOfSubstance", "massConcentrationOfB", "density", "volumicMass", "massDensity", "concentrationOfB", "isothermalCompressibility", "compressibility", "bulkCompressibility", "isentropicCompressibility" ] },
        "reciprocalRadian": { name: "reciprocalRadian", label: "reciprocal radian", symbol: "1/rad", code: "P97", referenceUnit: null, conversionFactor: null, quantityKinds: null },
        "reciprocalSecond": { name: "reciprocalSecond", label: "reciprocal second", symbol: "s⁻¹", code: "C97", referenceUnit: null, conversionFactor: null, quantityKinds: [ "angularFrequency", "decayConstant", "dampingCoefficient", "debyeAngularFrequency", "disintegrationConstant", "photonFlux", "larmorAngularFrequency", "circularFrequency", "pulsatance", "rotationalFrequency" ] },
        "reciprocalSecondPerMetreSquared": { name: "reciprocalSecondPerMetreSquared", label: "reciprocal second per metre squared", symbol: "s⁻¹/m²", code: "C99", referenceUnit: null, conversionFactor: null, quantityKinds: [ "photonExitance", "irradiance" ] },
        "reciprocalSecondPerSteradian": { name: "reciprocalSecondPerSteradian", label: "reciprocal second per steradian", symbol: "s⁻¹/sr", code: "D1", referenceUnit: null, conversionFactor: null, quantityKinds: [ "photonIntensity" ] },
        "reciprocalSecondPerSteradianMetreSquared": { name: "reciprocalSecondPerSteradianMetreSquared", label: "reciprocal second per steradian metre squared", symbol: "s⁻¹/(sr·m²)", code: "D2", referenceUnit: null, conversionFactor: null, quantityKinds: [ "photonRadiance", "photonLuminance" ] },
        "reciprocalSquareInch": { name: "reciprocalSquareInch", label: "reciprocal square inch", symbol: "1/in²", code: "P78", referenceUnit: function() { return samm.units["reciprocalSquareMetre"] }, conversionFactor: "1.550003 × 10³ m⁻²", quantityKinds: [ "photonExposure", "particleFluence", "particleFluence" ] },
        "reciprocalSquareMetre": { name: "reciprocalSquareMetre", label: "reciprocal square metre", symbol: "m⁻²", code: "C93", referenceUnit: null, conversionFactor: null, quantityKinds: [ "photonExposure", "particleFluence" ] },
        "reciprocalVolt": { name: "reciprocalVolt", label: "reciprocal volt", symbol: "1/V", code: "P96", referenceUnit: null, conversionFactor: null, quantityKinds: null },
        "reciprocalVoltAmpereReciprocalSecond": { name: "reciprocalVoltAmpereReciprocalSecond", label: "reciprocal volt - ampere reciprocal second", symbol: "1/(V·A·s)", code: "M30", referenceUnit: null, conversionFactor: null, quantityKinds: [ "performanceCharacteristic", "coefficient" ] },
        "reciprocalWeek": { name: "reciprocalWeek", label: "reciprocal week", symbol: "1/wk", code: "H85", referenceUnit: function() { return samm.units["reciprocalSecond"] }, conversionFactor: "1.647989452868 × 10⁻⁶ s⁻¹", quantityKinds: [ "angularFrequency", "decayConstant", "dampingCoefficient", "debyeAngularFrequency", "disintegrationConstant", "photonFlux", "larmorAngularFrequency", "circularFrequency", "pulsatance", "rotationalFrequency", "frequency" ] },
        "reciprocalYear": { name: "reciprocalYear", label: "reciprocal year", symbol: "1/y", code: "H09", referenceUnit: function() { return samm.units["reciprocalSecond"] }, conversionFactor: "3.16881 × 10⁻⁸ s⁻¹", quantityKinds: [ "angularFrequency", "decayConstant", "dampingCoefficient", "debyeAngularFrequency", "disintegrationConstant", "photonFlux", "larmorAngularFrequency", "circularFrequency", "pulsatance", "rotationalFrequency", "frequency" ] },
        "rem": { name: "rem", label: "rem", symbol: "rem", code: "D91", referenceUnit: function() { return samm.units["sievert"] }, conversionFactor: "10⁻² Sv", quantityKinds: [ "doseEquivalent", "doseEquivalent" ] },
        "remPerSecond": { name: "remPerSecond", label: "rem per second", symbol: "rem/s", code: "P69", referenceUnit: function() { return samm.units["sievertPerSecond"] }, conversionFactor: "10⁻² Sv/s", quantityKinds: [ "equivalenceDoseOutput", "equivalenceDoseOutput" ] },
        "revenueTonMile": { name: "revenueTonMile", label: "revenue ton mile", symbol: null, code: "RT", referenceUnit: null, conversionFactor: null, quantityKinds: null },
        "revolution": { name: "revolution", label: "revolution", symbol: "rev", code: "M44", referenceUnit: function() { return samm.units["rad"] }, conversionFactor: "6.283185 rad", quantityKinds: [ "anglePlane", "absorbedDose" ] },
        "revolutionPerMinute": { name: "revolutionPerMinute", label: "revolution per minute", symbol: "r/min", code: "M46", referenceUnit: function() { return samm.units["radianPerSecond"] }, conversionFactor: "0.1047198 rad/s", quantityKinds: [ "angularVelocity", "cyclotronAngularFrequency", "angularVelocity", "pulsatance", "debyeAngularFrequency", "angularFrequency", "circularFrequency", "nuclearPrecession" ] },
        "revolutionsPerMinute": { name: "revolutionsPerMinute", label: "revolutions per minute", symbol: "r/min", code: "RPM", referenceUnit: null, conversionFactor: null, quantityKinds: [ "rotationalFrequency" ] },
        "revolutionsPerSecond": { name: "revolutionsPerSecond", label: "revolutions per second", symbol: "r/s", code: "RPS", referenceUnit: null, conversionFactor: null, quantityKinds: [ "rotationalFrequency" ] },
        "rhe": { name: "rhe", label: "rhe", symbol: "rhe", code: "P88", referenceUnit: null, conversionFactor: null, quantityKinds: null },
        "rodUnitOfDistance": { name: "rodUnitOfDistance", label: "rod [unit of distance]", symbol: "rd (US)", code: "F49", referenceUnit: function() { return samm.units["metre"] }, conversionFactor: "5.029210 m", quantityKinds: [ "thickness", "particlePositionVector", "cartesianCoordinates", "focalDistance", "radius", "radiusOfCurvature", "displacementVectorOfIonOrAtom", "lengthOfPath", "diameter", "comptonWavelength", "slowingDownLength", "migrationLength", "meanFreePath", "equilibriumPositionVectorOfIonOrAtom", "instantaneousSoundParticleDisplacement", "imageDistance", "breadth", "length", "halfValueThickness", "coherenceLength", "latticeVector", "londonPenetrationDepth", "diffusionLength", "meanFreePathOfPhononsOrElectrons", "diffusionCoefficientForNeutronFluxDensity", "halfThickness", "height", "electronRadius", "distance", "objectDistance", "bohrRadius", "diffusionCoefficientForNeutronFluenceRate", "nuclearRadius", "wavelength", "fundamentalLatticeVector", "meanLinearRange", "cartesianCoordinates", "distance", "radius", "height", "radiusOfCurvature", "lengthOfPath", "thickness", "diameter", "breadth", "length" ] },
        "roentgen": { name: "roentgen", label: "roentgen", symbol: "R", code: "2C", referenceUnit: function() { return samm.units["coulombPerKilogram"] }, conversionFactor: "2.58 × 10⁻⁴ C/kg", quantityKinds: [ "exposure", "exposure" ] },
        "roentgenPerSecond": { name: "roentgenPerSecond", label: "roentgen per second", symbol: "R/s", code: "D6", referenceUnit: function() { return samm.units["coulombPerKilogramSecond"] }, conversionFactor: "2.58 × 10⁻⁴ C/(kg × s)", quantityKinds: [ "exposureRate", "exposureRate" ] },
        "room": { name: "room", label: "room", symbol: null, code: "ROM", referenceUnit: null, conversionFactor: null, quantityKinds: null },
        "round": { name: "round", label: "round", symbol: null, code: "D65", referenceUnit: null, conversionFactor: null, quantityKinds: null },
        "runFoot": { name: "runFoot", label: "run foot", symbol: null, code: "E52", referenceUnit: null, conversionFactor: null, quantityKinds: null },
        "runningOrOperatingHour": { name: "runningOrOperatingHour", label: "running or operating hour", symbol: null, code: "RH", referenceUnit: null, conversionFactor: null, quantityKinds: null },
        "score": { name: "score", label: "score", symbol: null, code: "SCO", referenceUnit: null, conversionFactor: null, quantityKinds: null },
        "scruple": { name: "scruple", label: "scruple", symbol: null, code: "SCR", referenceUnit: function() { return samm.units["gram"] }, conversionFactor: "1.295982 g", quantityKinds: [ "mass" ] },
        "secondPerCubicMetre": { name: "secondPerCubicMetre", label: "second per cubic metre", symbol: "s/m³", code: "D93", referenceUnit: null, conversionFactor: null, quantityKinds: [ "volumicDose" ] },
        "secondPerCubicMetreRadian": { name: "secondPerCubicMetreRadian", label: "second per cubic metre radian", symbol: "s/(rad·m³)", code: "D94", referenceUnit: null, conversionFactor: null, quantityKinds: [ "spectralConcentrationOfVibrationalModesInTermsOfAngularFrequency" ] },
        "secondPerKilogramm": { name: "secondPerKilogramm", label: "second per kilogramm", symbol: "s/kg", code: "Q20", referenceUnit: null, conversionFactor: null, quantityKinds: null },
        "secondPerRadianCubicMetre": { name: "secondPerRadianCubicMetre", label: "second per radian cubic metre", symbol: "1/(Hz·rad·m³)", code: "Q22", referenceUnit: null, conversionFactor: null, quantityKinds: null },
        "secondUnitOfAngle": { name: "secondUnitOfAngle", label: "second [unit of angle]", symbol: "\"", code: "D62", referenceUnit: function() { return samm.units["rad"] }, conversionFactor: "4.848137 × 10⁻⁶ rad", quantityKinds: [ "anglePlane", "absorbedDose" ] },
        "secondUnitOfTime": { name: "secondUnitOfTime", label: "second [unit of time]", symbol: "s", code: "SEC", referenceUnit: null, conversionFactor: null, quantityKinds: [ "timeConstant", "reactorTimeConstant", "halfLife", "meanLife", "time", "relaxationTime", "period", "carrierLifeTime", "periodicTime", "reverberationTime" ] },
        "segment": { name: "segment", label: "segment", symbol: null, code: "SG", referenceUnit: null, conversionFactor: null, quantityKinds: null },
        "serviceUnit": { name: "serviceUnit", label: "service unit", symbol: null, code: "E48", referenceUnit: null, conversionFactor: null, quantityKinds: null },
        "set": { name: "set", label: "set", symbol: null, code: "SET", referenceUnit: null, conversionFactor: null, quantityKinds: null },
        "shake": { name: "shake", label: "shake", symbol: "shake", code: "M56", referenceUnit: function() { return samm.units["secondUnitOfTime"] }, conversionFactor: "10⁻⁸ s", quantityKinds: [ "time", "timeConstant", "reactorTimeConstant", "halfLife", "meanLife", "time", "relaxationTime", "period", "carrierLifeTime", "periodicTime", "reverberationTime" ] },
        "shannon": { name: "shannon", label: "shannon", symbol: "Sh", code: "Q14", referenceUnit: null, conversionFactor: null, quantityKinds: null },
        "shannonPerSecond": { name: "shannonPerSecond", label: "shannon per second", symbol: "Sh/s", code: "Q17", referenceUnit: null, conversionFactor: null, quantityKinds: null },
        "shares": { name: "shares", label: "shares", symbol: null, code: "E21", referenceUnit: null, conversionFactor: null, quantityKinds: null },
        "shipment": { name: "shipment", label: "shipment", symbol: null, code: "SX", referenceUnit: null, conversionFactor: null, quantityKinds: null },
        "shot": { name: "shot", label: "shot", symbol: null, code: "14", referenceUnit: null, conversionFactor: null, quantityKinds: null },
        "siderealYear": { name: "siderealYear", label: "sidereal year", symbol: "y (sidereal)", code: "L96", referenceUnit: function() { return samm.units["secondUnitOfTime"] }, conversionFactor: "3.155815 × 10⁷ s", quantityKinds: [ "time", "timeConstant", "reactorTimeConstant", "halfLife", "meanLife", "time", "relaxationTime", "period", "carrierLifeTime", "periodicTime", "reverberationTime" ] },
        "siemens": { name: "siemens", label: "siemens", symbol: "S", code: "SIE", referenceUnit: null, conversionFactor: null, quantityKinds: [ "conductanceForDirectCurrent", "admittance", "modulusOfAdmittance", "conductanceForAlternatingCurrent", "complexAdmittance" ] },
        "siemensPerCentimetre": { name: "siemensPerCentimetre", label: "siemens per centimetre", symbol: "S/cm", code: "H43", referenceUnit: function() { return samm.units["siemensPerMetre"] }, conversionFactor: "10² S/m", quantityKinds: [ "electrolyticConductivity", "conductivity", "conductivity" ] },
        "siemensPerMetre": { name: "siemensPerMetre", label: "siemens per metre", symbol: "S/m", code: "D10", referenceUnit: null, conversionFactor: null, quantityKinds: [ "electrolyticConductivity", "conductivity" ] },
        "siemensSquareMetrePerMole": { name: "siemensSquareMetrePerMole", label: "siemens square metre per mole", symbol: "S·m²/mol", code: "D12", referenceUnit: null, conversionFactor: null, quantityKinds: [ "molarConductivity" ] },
        "sievert": { name: "sievert", label: "sievert", symbol: "Sv", code: "D13", referenceUnit: null, conversionFactor: null, quantityKinds: [ "doseEquivalent" ] },
        "sievertPerHour": { name: "sievertPerHour", label: "sievert per hour", symbol: "Sv/h", code: "P70", referenceUnit: function() { return samm.units["sievertPerSecond"] }, conversionFactor: "2.77778 × 10⁻⁴ Sv/s", quantityKinds: [ "equivalenceDoseOutput", "equivalenceDoseOutput" ] },
        "sievertPerMinute": { name: "sievertPerMinute", label: "sievert per minute", symbol: "Sv/min", code: "P74", referenceUnit: function() { return samm.units["sievertPerSecond"] }, conversionFactor: "0.016666 Sv/s", quantityKinds: [ "equivalenceDoseOutput", "equivalenceDoseOutput" ] },
        "sievertPerSecond": { name: "sievertPerSecond", label: "sievert per second", symbol: "Sv/s", code: "P65", referenceUnit: null, conversionFactor: null, quantityKinds: [ "equivalenceDoseOutput" ] },
        "sitas": { name: "sitas", label: "sitas", symbol: null, code: "56", referenceUnit: null, conversionFactor: null, quantityKinds: null },
        "skein": { name: "skein", label: "skein", symbol: null, code: "SW", referenceUnit: null, conversionFactor: null, quantityKinds: null },
        "slug": { name: "slug", label: "slug", symbol: "slug", code: "F13", referenceUnit: function() { return samm.units["kilogram"] }, conversionFactor: "1.459390 × 10¹ kg", quantityKinds: [ "mass", "massOfAtomOfANuclideX", "massOfMolecule", "effectiveMass", "mass", "nuclidicMass", "massExcess" ] },
        "slugPerCubicFoot": { name: "slugPerCubicFoot", label: "slug per cubic foot", symbol: "slug/ft³", code: "L65", referenceUnit: function() { return samm.units["kilogramPerCubicMetre"] }, conversionFactor: "5.153788 × 10² kg/m³", quantityKinds: [ "volumicMass", "massDensity", "density", "amountOfSubstance", "massDensity", "density", "concentrationOfB", "massConcentrationOfB", "volumicMass" ] },
        "slugPerDay": { name: "slugPerDay", label: "slug per day", symbol: "slug/d", code: "L63", referenceUnit: function() { return samm.units["kilogramPerSecond"] }, conversionFactor: "1.689109 × 10⁻⁴ kg/s", quantityKinds: [ "massFlowRate", "massFlowRate" ] },
        "slugPerFootSecond": { name: "slugPerFootSecond", label: "slug per foot second", symbol: "slug/(ft·s)", code: "L64", referenceUnit: function() { return samm.units["pascalSecond"] }, conversionFactor: "47.88026 Pa × s", quantityKinds: [ "viscosityDynamicViscosity", "viscosityDynamicViscosity" ] },
        "slugPerHour": { name: "slugPerHour", label: "slug per hour", symbol: "slug/h", code: "L66", referenceUnit: function() { return samm.units["kilogramPerSecond"] }, conversionFactor: "4.053861 × 10⁻³ kg/s", quantityKinds: [ "massFlowRate", "massFlowRate" ] },
        "slugPerMinute": { name: "slugPerMinute", label: "slug per minute", symbol: "slug/min", code: "L67", referenceUnit: function() { return samm.units["kilogramPerSecond"] }, conversionFactor: "0.2432317 kg/s", quantityKinds: [ "massFlowRate", "massFlowRate" ] },
        "slugPerSecond": { name: "slugPerSecond", label: "slug per second", symbol: "slug/s", code: "L68", referenceUnit: function() { return samm.units["kilogramPerSecond"] }, conversionFactor: "14.59390 kg/s", quantityKinds: [ "massFlowRate", "massFlowRate" ] },
        "sone": { name: "sone", label: "sone", symbol: null, code: "D15", referenceUnit: null, conversionFactor: null, quantityKinds: [ "loudness" ] },
        "square": { name: "square", label: "square", symbol: null, code: "SQ", referenceUnit: null, conversionFactor: null, quantityKinds: null },
        "squareCentimetre": { name: "squareCentimetre", label: "square centimetre", symbol: "cm²", code: "CMK", referenceUnit: function() { return samm.units["squareMetre"] }, conversionFactor: "10⁻⁴ m²", quantityKinds: [ "area", "area", "atomicAttenuationCoefficient", "migrationArea", "crossSection", "equivalentAbsorptionAreaOfASurfaceOrObject", "nuclearQuadrupoleMoment", "slowingDownArea", "diffusionArea" ] },
        "squareCentimetrePerErg": { name: "squareCentimetrePerErg", label: "square centimetre per erg", symbol: "cm²/erg", code: "D16", referenceUnit: function() { return samm.units["squareMetrePerJoule"] }, conversionFactor: "10³ m²/J", quantityKinds: [ "spectralCrossSection", "spectralCrossSection" ] },
        "squareCentimetrePerGram": { name: "squareCentimetrePerGram", label: "square centimetre per gram", symbol: "cm²/g", code: "H15", referenceUnit: null, conversionFactor: null, quantityKinds: [ "specificVolume", "massicVolume" ] },
        "squareCentimetrePerSecond": { name: "squareCentimetrePerSecond", label: "square centimetre per second", symbol: "cm²/s", code: "M81", referenceUnit: function() { return samm.units["squareMetrePerSecond"] }, conversionFactor: "10⁻⁴ m²/s", quantityKinds: [ "thermalDiffusivity", "diffusionCoefficientForNeutronNumberDensity", "thermalDiffusionCoefficient", "diffusionCoefficient", "kinematicViscosity", "kinematicViscosity" ] },
        "squareCentimetrePerSteradianErg": { name: "squareCentimetrePerSteradianErg", label: "square centimetre per steradian erg", symbol: "cm²/(sr·erg)", code: "D17", referenceUnit: function() { return samm.units["squareMetrePerSteradianJoule"] }, conversionFactor: "10³ m²/(sr × J)", quantityKinds: [ "spectralAngularCrossSection", "spectralAngularCrossSection" ] },
        "squareDecametre": { name: "squareDecametre", label: "square decametre", symbol: "dam²", code: "H16", referenceUnit: function() { return samm.units["squareMetre"] }, conversionFactor: "10² m²", quantityKinds: [ "area", "area", "atomicAttenuationCoefficient", "migrationArea", "crossSection", "equivalentAbsorptionAreaOfASurfaceOrObject", "nuclearQuadrupoleMoment", "slowingDownArea", "diffusionArea" ] },
        "squareDecimetre": { name: "squareDecimetre", label: "square decimetre", symbol: "dm²", code: "DMK", referenceUnit: function() { return samm.units["squareMetre"] }, conversionFactor: "10⁻² m²", quantityKinds: [ "area", "area", "atomicAttenuationCoefficient", "migrationArea", "crossSection", "equivalentAbsorptionAreaOfASurfaceOrObject", "nuclearQuadrupoleMoment", "slowingDownArea", "diffusionArea" ] },
        "squareFoot": { name: "squareFoot", label: "square foot", symbol: "ft²", code: "FTK", referenceUnit: function() { return samm.units["squareMetre"] }, conversionFactor: "9.290304 × 10⁻² m²", quantityKinds: [ "area", "area", "atomicAttenuationCoefficient", "migrationArea", "crossSection", "equivalentAbsorptionAreaOfASurfaceOrObject", "nuclearQuadrupoleMoment", "slowingDownArea", "diffusionArea" ] },
        "squareFootPerHour": { name: "squareFootPerHour", label: "square foot per hour", symbol: "ft²/h", code: "M79", referenceUnit: function() { return samm.units["squareMetrePerSecond"] }, conversionFactor: "2.58064 × 10⁻⁵ m²/s", quantityKinds: [ "thermalDiffusivity", "diffusionCoefficientForNeutronNumberDensity", "thermalDiffusionCoefficient", "diffusionCoefficient", "kinematicViscosity", "kinematicViscosity" ] },
        "squareFootPerSecond": { name: "squareFootPerSecond", label: "square foot per second", symbol: "ft²/s", code: "S3", referenceUnit: function() { return samm.units["squareMetrePerSecond"] }, conversionFactor: "0.09290304 m²/s", quantityKinds: [ "kinematicViscosity", "thermalDiffusivity", "thermalDiffusivity", "diffusionCoefficientForNeutronNumberDensity", "thermalDiffusionCoefficient", "diffusionCoefficient", "kinematicViscosity" ] },
        "squareHectometre": { name: "squareHectometre", label: "square hectometre", symbol: "hm²", code: "H18", referenceUnit: function() { return samm.units["squareMetre"] }, conversionFactor: "10⁴ m²", quantityKinds: [ "area", "atomicAttenuationCoefficient", "migrationArea", "crossSection", "equivalentAbsorptionAreaOfASurfaceOrObject", "nuclearQuadrupoleMoment", "slowingDownArea", "diffusionArea", "area" ] },
        "squareInch": { name: "squareInch", label: "square inch", symbol: "in²", code: "INK", referenceUnit: function() { return samm.units["squareMetre"] }, conversionFactor: "6.4516 × 10⁻⁴ m²", quantityKinds: [ "area", "area", "atomicAttenuationCoefficient", "migrationArea", "crossSection", "equivalentAbsorptionAreaOfASurfaceOrObject", "nuclearQuadrupoleMoment", "slowingDownArea", "diffusionArea" ] },
        "squareInchPerSecond": { name: "squareInchPerSecond", label: "square inch per second", symbol: "in²/s", code: "G08", referenceUnit: null, conversionFactor: null, quantityKinds: [ "kinematicViscosity" ] },
        "squareKilometre": { name: "squareKilometre", label: "square kilometre", symbol: "km²", code: "KMK", referenceUnit: function() { return samm.units["squareMetre"] }, conversionFactor: "10⁶ m²", quantityKinds: [ "area", "area", "atomicAttenuationCoefficient", "migrationArea", "crossSection", "equivalentAbsorptionAreaOfASurfaceOrObject", "nuclearQuadrupoleMoment", "slowingDownArea", "diffusionArea" ] },
        "squareMetre": { name: "squareMetre", label: "square metre", symbol: "m²", code: "MTK", referenceUnit: null, conversionFactor: null, quantityKinds: [ "area", "atomicAttenuationCoefficient", "migrationArea", "crossSection", "equivalentAbsorptionAreaOfASurfaceOrObject", "nuclearQuadrupoleMoment", "slowingDownArea", "diffusionArea" ] },
        "squareMetreHourDegreeCelsiusPerKilocalorieInternationalTable": { name: "squareMetreHourDegreeCelsiusPerKilocalorieInternationalTable", label: "square metre hour degree Celsius per kilocalorie (international table)", symbol: "m²·h·°C/kcal", code: "L14", referenceUnit: null, conversionFactor: null, quantityKinds: [ "thermalInsulance", "coefficientOfThermalInsulation" ] },
        "squareMetreKelvinPerWatt": { name: "squareMetreKelvinPerWatt", label: "square metre kelvin per watt", symbol: "m²·K/W", code: "D19", referenceUnit: null, conversionFactor: null, quantityKinds: [ "thermalInsulance", "coefficientOfThermalInsulation" ] },
        "squareMetrePerJoule": { name: "squareMetrePerJoule", label: "square metre per joule", symbol: "m²/J", code: "D20", referenceUnit: null, conversionFactor: null, quantityKinds: [ "spectralCrossSection" ] },
        "squareMetrePerKilogram": { name: "squareMetrePerKilogram", label: "square metre per kilogram", symbol: "m²/kg", code: "D21", referenceUnit: null, conversionFactor: null, quantityKinds: [ "massEnergyTransferCoefficient", "massAttenuationCoefficient" ] },
        "squareMetrePerLitre": { name: "squareMetrePerLitre", label: "square metre per litre", symbol: "m²/l", code: "E31", referenceUnit: null, conversionFactor: null, quantityKinds: null },
        "squareMetrePerMole": { name: "squareMetrePerMole", label: "square metre per mole", symbol: "m²/mol", code: "D22", referenceUnit: null, conversionFactor: null, quantityKinds: [ "molarAttenuationCoefficient", "molarAbsorptionCoefficient" ] },
        "squareMetrePerNewton": { name: "squareMetrePerNewton", label: "square metre per newton", symbol: "m²/N", code: "H59", referenceUnit: null, conversionFactor: null, quantityKinds: [ "area" ] },
        "squareMetrePerSecond": { name: "squareMetrePerSecond", label: "square metre per second", symbol: "m²/s", code: "S4", referenceUnit: null, conversionFactor: null, quantityKinds: [ "thermalDiffusivity", "diffusionCoefficientForNeutronNumberDensity", "thermalDiffusionCoefficient", "diffusionCoefficient", "kinematicViscosity" ] },
        "squareMetrePerSecondBar": { name: "squareMetrePerSecondBar", label: "square metre per second bar", symbol: "m²/(s·bar)", code: "G41", referenceUnit: null, conversionFactor: null, quantityKinds: [ "kinematicViscosity" ] },
        "squareMetrePerSecondKelvin": { name: "squareMetrePerSecondKelvin", label: "square metre per second kelvin", symbol: "m²/(s·K)", code: "G09", referenceUnit: null, conversionFactor: null, quantityKinds: [ "kinematicViscosity" ] },
        "squareMetrePerSecondPascal": { name: "squareMetrePerSecondPascal", label: "square metre per second pascal", symbol: "(m²/s)/Pa", code: "M82", referenceUnit: null, conversionFactor: null, quantityKinds: [ "kinematicViscosity" ] },
        "squareMetrePerSteradian": { name: "squareMetrePerSteradian", label: "square metre per steradian", symbol: "m²/sr", code: "D24", referenceUnit: null, conversionFactor: null, quantityKinds: [ "angularCrossSection" ] },
        "squareMetrePerSteradianJoule": { name: "squareMetrePerSteradianJoule", label: "square metre per steradian joule", symbol: "m²/(sr·J)", code: "D25", referenceUnit: null, conversionFactor: null, quantityKinds: [ "spectralAngularCrossSection" ] },
        "squareMetrePerVoltSecond": { name: "squareMetrePerVoltSecond", label: "square metre per volt second", symbol: "m²/(V·s)", code: "D26", referenceUnit: null, conversionFactor: null, quantityKinds: [ "mobility" ] },
        "squareMicrometreSquareMicron": { name: "squareMicrometreSquareMicron", label: "square micrometre (square micron)", symbol: "µm²", code: "H30", referenceUnit: function() { return samm.units["squareMetre"] }, conversionFactor: "10⁻¹² m²", quantityKinds: [ "area", "area", "atomicAttenuationCoefficient", "migrationArea", "crossSection", "equivalentAbsorptionAreaOfASurfaceOrObject", "nuclearQuadrupoleMoment", "slowingDownArea", "diffusionArea" ] },
        "squareMileBasedOnUsSurveyFoot": { name: "squareMileBasedOnUsSurveyFoot", label: "square mile (based on U.S. survey foot)", symbol: "mi² (US survey)", code: "M48", referenceUnit: function() { return samm.units["squareMetre"] }, conversionFactor: "2.589998 × 10⁶ m²", quantityKinds: [ "area", "area", "atomicAttenuationCoefficient", "migrationArea", "crossSection", "equivalentAbsorptionAreaOfASurfaceOrObject", "nuclearQuadrupoleMoment", "slowingDownArea", "diffusionArea" ] },
        "squareMileStatuteMile": { name: "squareMileStatuteMile", label: "square mile (statute mile)", symbol: "mi²", code: "MIK", referenceUnit: function() { return samm.units["squareKilometre"] }, conversionFactor: "2.589988 km²", quantityKinds: [ "area", "area" ] },
        "squareMillimetre": { name: "squareMillimetre", label: "square millimetre", symbol: "mm²", code: "MMK", referenceUnit: function() { return samm.units["squareMetre"] }, conversionFactor: "10⁻⁶ m²", quantityKinds: [ "area", "area", "atomicAttenuationCoefficient", "migrationArea", "crossSection", "equivalentAbsorptionAreaOfASurfaceOrObject", "nuclearQuadrupoleMoment", "slowingDownArea", "diffusionArea" ] },
        "squareRoofing": { name: "squareRoofing", label: "square, roofing", symbol: null, code: "SQR", referenceUnit: null, conversionFactor: null, quantityKinds: null },
        "squareYard": { name: "squareYard", label: "square yard", symbol: "yd²", code: "YDK", referenceUnit: function() { return samm.units["squareMetre"] }, conversionFactor: "8.361274 × 10⁻¹ m²", quantityKinds: [ "area", "area", "atomicAttenuationCoefficient", "migrationArea", "crossSection", "equivalentAbsorptionAreaOfASurfaceOrObject", "nuclearQuadrupoleMoment", "slowingDownArea", "diffusionArea" ] },
        "standard": { name: "standard", label: "standard", symbol: "std", code: "WSD", referenceUnit: function() { return samm.units["cubicMetre"] }, conversionFactor: "4.672 m³", quantityKinds: [ "volume", "sectionModulus" ] },
        "standardAccelerationOfFreeFall": { name: "standardAccelerationOfFreeFall", label: "standard acceleration of free fall", symbol: "gn", code: "K40", referenceUnit: function() { return samm.units["metrePerSecondSquared"] }, conversionFactor: "9.80665 m/s²", quantityKinds: [ "accelerationDueToGravity", "accelerationOfFreeFall", "acceleration", "acceleration", "instantaneousSoundParticleAcceleration", "accelerationOfFreeFall", "accelerationDueToGravity" ] },
        "standardAtmosphere": { name: "standardAtmosphere", label: "standard atmosphere", symbol: "atm", code: "ATM", referenceUnit: function() { return samm.units["pascal"] }, conversionFactor: "101325 Pa", quantityKinds: [ "modulusOfCompression", "shearModulus", "shearStress", "modulusOfElasticity", "normalStress", "bulkModulus", "modulusOfRigidity", "pressure", "fugacityOfBInAGaseousMixture", "pressure", "shearModulus", "staticPressure", "normalStress", "modulusOfRigidity", "instantaneousSoundPressure", "modulusOfElasticity", "shearStress", "modulusOfCompression", "partialPressureOfBInAGaseousMixture", "bulkModulus", "osmoticPressure" ] },
        "standardAtmospherePerMetre": { name: "standardAtmospherePerMetre", label: "standard atmosphere per metre", symbol: "Atm/m", code: "P83", referenceUnit: null, conversionFactor: null, quantityKinds: [ "hardnessIndex" ] },
        "standardKilolitre": { name: "standardKilolitre", label: "standard kilolitre", symbol: null, code: "DMO", referenceUnit: null, conversionFactor: null, quantityKinds: null },
        "standardLitre": { name: "standardLitre", label: "standard litre", symbol: null, code: "STL", referenceUnit: null, conversionFactor: null, quantityKinds: null },
        "steradian": { name: "steradian", label: "steradian", symbol: "sr", code: "D27", referenceUnit: null, conversionFactor: null, quantityKinds: [ "solidAngle" ] },
        "stere": { name: "stere", label: "stere", symbol: "st", code: "G26", referenceUnit: function() { return samm.units["cubicMetre"] }, conversionFactor: "m³", quantityKinds: [ "volume", "sectionModulus", "volume" ] },
        "stick": { name: "stick", label: "stick", symbol: null, code: "STC", referenceUnit: null, conversionFactor: null, quantityKinds: null },
        "stickCigarette": { name: "stickCigarette", label: "stick, cigarette", symbol: null, code: "STK", referenceUnit: null, conversionFactor: null, quantityKinds: null },
        "stickMilitary": { name: "stickMilitary", label: "stick, military", symbol: null, code: "15", referenceUnit: null, conversionFactor: null, quantityKinds: null },
        "stilb": { name: "stilb", label: "stilb", symbol: "sb", code: "P31", referenceUnit: function() { return samm.units["candelaPerSquareMetre"] }, conversionFactor: "10⁴ cd/m²", quantityKinds: [ "luminance", "luminance" ] },
        "stokes": { name: "stokes", label: "stokes", symbol: "St", code: "91", referenceUnit: function() { return samm.units["squareMetrePerSecond"] }, conversionFactor: "10⁻⁴ m²/s", quantityKinds: [ "kinematicViscosity", "thermalDiffusivity", "diffusionCoefficientForNeutronNumberDensity", "thermalDiffusionCoefficient", "diffusionCoefficient", "kinematicViscosity" ] },
        "stokesPerBar": { name: "stokesPerBar", label: "stokes per bar", symbol: "St/bar", code: "G46", referenceUnit: null, conversionFactor: null, quantityKinds: [ "kinematicViscosity" ] },
        "stokesPerKelvin": { name: "stokesPerKelvin", label: "stokes per kelvin", symbol: "St/K", code: "G10", referenceUnit: null, conversionFactor: null, quantityKinds: [ "kinematicViscosity" ] },
        "stokesPerPascal": { name: "stokesPerPascal", label: "stokes per pascal", symbol: "St/Pa", code: "M80", referenceUnit: null, conversionFactor: null, quantityKinds: [ "kinematicViscosity" ] },
        "stoneUk": { name: "stoneUk", label: "stone (UK)", symbol: "st", code: "STI", referenceUnit: function() { return samm.units["kilogram"] }, conversionFactor: "6.350293 kg", quantityKinds: [ "massOfAtomOfANuclideX", "massOfMolecule", "effectiveMass", "mass", "nuclidicMass", "massExcess", "mass" ] },
        "strand": { name: "strand", label: "strand", symbol: null, code: "E30", referenceUnit: null, conversionFactor: null, quantityKinds: null },
        "straw": { name: "straw", label: "straw", symbol: null, code: "STW", referenceUnit: null, conversionFactor: null, quantityKinds: null },
        "strip": { name: "strip", label: "strip", symbol: null, code: "SR", referenceUnit: null, conversionFactor: null, quantityKinds: null },
        "syringe": { name: "syringe", label: "syringe", symbol: null, code: "SYR", referenceUnit: null, conversionFactor: null, quantityKinds: null },
        "tablespoonUs": { name: "tablespoonUs", label: "tablespoon (US)", symbol: "tablespoon (US)", code: "G24", referenceUnit: function() { return samm.units["cubicMetre"] }, conversionFactor: "1.478676 × 10⁻⁵ m³", quantityKinds: [ "volume", "sectionModulus", "volume" ] },
        "tablet": { name: "tablet", label: "tablet", symbol: null, code: "U2", referenceUnit: null, conversionFactor: null, quantityKinds: null },
        "teaspoonUs": { name: "teaspoonUs", label: "teaspoon (US)", symbol: "teaspoon (US)", code: "G25", referenceUnit: function() { return samm.units["cubicMetre"] }, conversionFactor: "4.928922 × 10⁻⁶ m³", quantityKinds: [ "volume", "sectionModulus", "volume" ] },
        "tebibitPerCubicMetre": { name: "tebibitPerCubicMetre", label: "tebibit per cubic metre", symbol: "Tibit/m³", code: "E86", referenceUnit: null, conversionFactor: null, quantityKinds: null },
        "tebibitPerMetre": { name: "tebibitPerMetre", label: "tebibit per metre", symbol: "Tibit/m", code: "E85", referenceUnit: null, conversionFactor: null, quantityKinds: null },
        "tebibitPerSquareMetre": { name: "tebibitPerSquareMetre", label: "tebibit per square metre", symbol: "Tibit/m²", code: "E87", referenceUnit: null, conversionFactor: null, quantityKinds: null },
        "tebibyte": { name: "tebibyte", label: "Tebibyte", symbol: "TiB", code: "E61", referenceUnit: function() { return samm.units["byte"] }, conversionFactor: "2⁴⁰ B", quantityKinds: [ "informationEntropy", "informationEntropy" ] },
        "technicalAtmospherePerMetre": { name: "technicalAtmospherePerMetre", label: "technical atmosphere per metre", symbol: "at/m", code: "P84", referenceUnit: null, conversionFactor: null, quantityKinds: [ "hardnessIndex" ] },
        "telecommunicationLineInService": { name: "telecommunicationLineInService", label: "telecommunication line in service", symbol: null, code: "T0", referenceUnit: null, conversionFactor: null, quantityKinds: null },
        "telecommunicationLineInServiceAverage": { name: "telecommunicationLineInServiceAverage", label: "telecommunication line in service average", symbol: null, code: "UB", referenceUnit: null, conversionFactor: null, quantityKinds: null },
        "telecommunicationPort": { name: "telecommunicationPort", label: "telecommunication port", symbol: null, code: "UC", referenceUnit: null, conversionFactor: null, quantityKinds: null },
        "tenDay": { name: "tenDay", label: "ten day", symbol: null, code: "DAD", referenceUnit: null, conversionFactor: null, quantityKinds: null },
        "tenPack": { name: "tenPack", label: "ten pack", symbol: null, code: "TP", referenceUnit: null, conversionFactor: null, quantityKinds: null },
        "tenPair": { name: "tenPair", label: "ten pair", symbol: null, code: "TPR", referenceUnit: null, conversionFactor: null, quantityKinds: null },
        "tenSet": { name: "tenSet", label: "ten set", symbol: null, code: "TST", referenceUnit: null, conversionFactor: null, quantityKinds: null },
        "tenThousandSticks": { name: "tenThousandSticks", label: "ten thousand sticks", symbol: null, code: "TTS", referenceUnit: null, conversionFactor: null, quantityKinds: null },
        "terabit": { name: "terabit", label: "terabit", symbol: "Tbit", code: "E83", referenceUnit: null, conversionFactor: null, quantityKinds: null },
        "terabitPerSecond": { name: "terabitPerSecond", label: "terabit per second", symbol: "Tbit/s", code: "E84", referenceUnit: null, conversionFactor: null, quantityKinds: null },
        "terabyte": { name: "terabyte", label: "terabyte", symbol: "TB", code: "E35", referenceUnit: function() { return samm.units["byte"] }, conversionFactor: "10¹² B", quantityKinds: [ "informationEntropy", "informationEntropy" ] },
        "terahertz": { name: "terahertz", label: "terahertz", symbol: "THz", code: "D29", referenceUnit: function() { return samm.units["hertz"] }, conversionFactor: "10¹² Hz", quantityKinds: [ "frequency", "frequency" ] },
        "terajoule": { name: "terajoule", label: "terajoule", symbol: "TJ", code: "D30", referenceUnit: function() { return samm.units["joule"] }, conversionFactor: "10¹² J", quantityKinds: [ "energy", "work", "potentialEnergy", "kineticEnergy", "quantityOfHeat", "reactionEnergy", "workFunction", "activeEnergy", "kineticEnergy", "levelWidth", "meanEnergyImparted", "helmholtzFunction", "radiantEnergy", "potentialEnergy", "energy", "thermodynamicEnergy", "helmholtzFreeEnergy", "work", "heat", "hartreeEnergy", "energyImparted", "enthalpy", "alphaDisintegrationEnergy" ] },
        "teraohm": { name: "teraohm", label: "teraohm", symbol: "TΩ", code: "H44", referenceUnit: function() { return samm.units["ohm"] }, conversionFactor: "10¹² Ω", quantityKinds: [ "impedance", "reactance", "modulusOfImpedance", "resistanceToDirectCurrent", "complexImpedances", "resistanceToAlternatingCurrent", "modulusOfImpedance", "impedance", "resistanceToDirectCurrent", "reactance", "complexImpedances", "resistanceToAlternatingCurrent" ] },
        "terawatt": { name: "terawatt", label: "terawatt", symbol: "TW", code: "D31", referenceUnit: function() { return samm.units["watt"] }, conversionFactor: "10¹² W", quantityKinds: [ "radiantEnergyflux", "activePower", "heatFlowRate", "soundPower", "power", "radiantPower", "powerForDirectCurrent", "powerForDirectCurrent", "activePower" ] },
        "terawattHour": { name: "terawattHour", label: "terawatt hour", symbol: "TW·h", code: "D32", referenceUnit: function() { return samm.units["joule"] }, conversionFactor: "3.6 × 10¹⁵ J", quantityKinds: [ "quantityOfHeat", "reactionEnergy", "workFunction", "activeEnergy", "kineticEnergy", "levelWidth", "meanEnergyImparted", "helmholtzFunction", "radiantEnergy", "potentialEnergy", "energy", "thermodynamicEnergy", "helmholtzFreeEnergy", "work", "heat", "hartreeEnergy", "energyImparted", "enthalpy", "alphaDisintegrationEnergy", "kineticEnergy", "energy", "work", "potentialEnergy" ] },
        "tesla": { name: "tesla", label: "tesla", symbol: "T", code: "D33", referenceUnit: null, conversionFactor: null, quantityKinds: [ "magneticFluxDensity", "magneticInduction", "lowerCriticalMagneticFluxDensity", "upperCriticalMagneticFluxDensity", "magneticPolarization", "thermodynamicCriticalMagneticFluxDensity" ] },
        "test": { name: "test", label: "test", symbol: null, code: "E53", referenceUnit: null, conversionFactor: null, quantityKinds: null },
        "teu": { name: "teu", label: "TEU", symbol: null, code: "E22", referenceUnit: null, conversionFactor: null, quantityKinds: null },
        "tex": { name: "tex", label: "tex", symbol: "tex (g/km)", code: "D34", referenceUnit: function() { return samm.units["kilogramPerMetre"] }, conversionFactor: "10⁻⁶ kg/m", quantityKinds: [ "linearMass", "linearDensity" ] },
        "theoreticalPound": { name: "theoreticalPound", label: "theoretical pound", symbol: null, code: "24", referenceUnit: null, conversionFactor: null, quantityKinds: null },
        "theoreticalTon": { name: "theoreticalTon", label: "theoretical ton", symbol: null, code: "27", referenceUnit: null, conversionFactor: null, quantityKinds: null },
        "thermEc": { name: "thermEc", label: "therm (EC)", symbol: "thm (EC)", code: "N71", referenceUnit: function() { return samm.units["joule"] }, conversionFactor: "1.05506 × 10⁸ J", quantityKinds: [ "helmholtzFunction", "heat", "energy", "helmholtzFreeEnergy", "enthalpy", "thermodynamicEnergy", "quantityOfHeat", "quantityOfHeat", "reactionEnergy", "workFunction", "activeEnergy", "kineticEnergy", "levelWidth", "meanEnergyImparted", "helmholtzFunction", "radiantEnergy", "potentialEnergy", "energy", "thermodynamicEnergy", "helmholtzFreeEnergy", "work", "heat", "hartreeEnergy", "energyImparted", "enthalpy", "alphaDisintegrationEnergy" ] },
        "thermUs": { name: "thermUs", label: "therm (U.S.)", symbol: "thm (US)", code: "N72", referenceUnit: function() { return samm.units["joule"] }, conversionFactor: "1.054804 × 10⁸ J", quantityKinds: [ "helmholtzFunction", "energy", "heat", "helmholtzFreeEnergy", "enthalpy", "thermodynamicEnergy", "quantityOfHeat", "quantityOfHeat", "reactionEnergy", "workFunction", "activeEnergy", "kineticEnergy", "levelWidth", "meanEnergyImparted", "helmholtzFunction", "radiantEnergy", "potentialEnergy", "energy", "thermodynamicEnergy", "helmholtzFreeEnergy", "work", "heat", "hartreeEnergy", "energyImparted", "enthalpy", "alphaDisintegrationEnergy" ] },
        "thirtyDayMonth": { name: "thirtyDayMonth", label: "30-day month", symbol: "mo (30 days)", code: "M36", referenceUnit: function() { return samm.units["secondUnitOfTime"] }, conversionFactor: "2.592000 × 10⁶ s", quantityKinds: [ "timeConstant", "reactorTimeConstant", "halfLife", "meanLife", "time", "relaxationTime", "period", "carrierLifeTime", "periodicTime", "reverberationTime" ] },
        "thousand": { name: "thousand", label: "thousand", symbol: null, code: "MIL", referenceUnit: null, conversionFactor: null, quantityKinds: null },
        "thousandBoardFoot": { name: "thousandBoardFoot", label: "thousand board foot", symbol: null, code: "MBF", referenceUnit: null, conversionFactor: null, quantityKinds: null },
        "thousandCubicFoot": { name: "thousandCubicFoot", label: "thousand cubic foot", symbol: "kft³", code: "FC", referenceUnit: null, conversionFactor: null, quantityKinds: null },
        "thousandCubicMetre": { name: "thousandCubicMetre", label: "thousand cubic metre", symbol: null, code: "R9", referenceUnit: function() { return samm.units["cubicMetre"] }, conversionFactor: "10³m³", quantityKinds: [ "volume", "sectionModulus" ] },
        "thousandCubicMetrePerDay": { name: "thousandCubicMetrePerDay", label: "thousand cubic metre per day", symbol: "km³/d", code: "TQD", referenceUnit: function() { return samm.units["cubicMetrePerSecond"] }, conversionFactor: "1.15741 × 10⁻² m³/s", quantityKinds: [ "volumeFlowRate", "recombinationCoefficient", "instantaneousVolumeFlowRate" ] },
        "thousandPiece": { name: "thousandPiece", label: "thousand piece", symbol: null, code: "T3", referenceUnit: null, conversionFactor: null, quantityKinds: null },
        "thousandSquareInch": { name: "thousandSquareInch", label: "thousand square inch", symbol: null, code: "TI", referenceUnit: null, conversionFactor: null, quantityKinds: null },
        "thousandStandardBrickEquivalent": { name: "thousandStandardBrickEquivalent", label: "thousand standard brick equivalent", symbol: null, code: "MBE", referenceUnit: null, conversionFactor: null, quantityKinds: null },
        "tonAssay": { name: "tonAssay", label: "ton, assay", symbol: null, code: "M85", referenceUnit: function() { return samm.units["kilogram"] }, conversionFactor: "2.916667 × 10⁻² kg", quantityKinds: [ "mass", "massOfAtomOfANuclideX", "massOfMolecule", "effectiveMass", "mass", "nuclidicMass", "massExcess" ] },
        "tonForceUsShort": { name: "tonForceUsShort", label: "ton-force (US short)", symbol: "ton.sh-force", code: "L94", referenceUnit: function() { return samm.units["newton"] }, conversionFactor: "8.896443 × 10³ N", quantityKinds: [ "weight", "force", "force", "weight" ] },
        "tonLongPerDay": { name: "tonLongPerDay", label: "ton long per day", symbol: "ton (UK)/d", code: "L85", referenceUnit: function() { return samm.units["kilogramPerSecond"] }, conversionFactor: "1.175980 × 10⁻² kg/s", quantityKinds: [ "massFlowRate", "massFlowRate" ] },
        "tonRegister": { name: "tonRegister", label: "ton, register", symbol: "RT", code: "M70", referenceUnit: function() { return samm.units["cubicMetre"] }, conversionFactor: "2.831685 m³", quantityKinds: [ "volume", "volume", "sectionModulus" ] },
        "tonShortPerDay": { name: "tonShortPerDay", label: "ton short per day", symbol: "ton (US)/d", code: "L88", referenceUnit: function() { return samm.units["kilogramPerSecond"] }, conversionFactor: "1.049982 × 10⁻² kg/s", quantityKinds: [ "massFlowRate", "massFlowRate" ] },
        "tonShortPerDegreeFahrenheit": { name: "tonShortPerDegreeFahrenheit", label: "ton short per degree Fahrenheit", symbol: "ton (US)/°F", code: "L87", referenceUnit: function() { return samm.units["kilogramPerKelvin"] }, conversionFactor: "1.632932 × 10³ kg/K", quantityKinds: [ "volumicMass", "massDensity", "density", "mass" ] },
        "tonShortPerHourDegreeFahrenheit": { name: "tonShortPerHourDegreeFahrenheit", label: "ton short per hour degree Fahrenheit", symbol: "ton (US)/(h·°F)", code: "L89", referenceUnit: null, conversionFactor: null, quantityKinds: [ "massFlowRate" ] },
        "tonShortPerHourPsi": { name: "tonShortPerHourPsi", label: "ton short per hour psi", symbol: "(ton (US)/h)/psi", code: "L90", referenceUnit: function() { return samm.units["kilogramPerSecondPascal"] }, conversionFactor: "3.654889 × 10⁻⁵ (kg/s)/Pa", quantityKinds: [ "massFlowRate", "massFlowRate" ] },
        "tonShortPerPsi": { name: "tonShortPerPsi", label: "ton short per psi", symbol: "ton (US)/psi", code: "L91", referenceUnit: null, conversionFactor: null, quantityKinds: [ "volumicMass", "massDensity", "density" ] },
        "tonUkLongPerCubicYard": { name: "tonUkLongPerCubicYard", label: "ton (UK long) per cubic yard", symbol: "ton.l/yd³ (UK)", code: "L92", referenceUnit: function() { return samm.units["kilogramPerCubicMetre"] }, conversionFactor: "1.328939 × 10³ kg/m³", quantityKinds: [ "amountOfSubstance", "massDensity", "density", "concentrationOfB", "massConcentrationOfB", "volumicMass", "massDensity", "density", "volumicMass" ] },
        "tonUkOrLongTonUs": { name: "tonUkOrLongTonUs", label: "ton (UK) or long ton (US)", symbol: "ton (UK)", code: "LTN", referenceUnit: function() { return samm.units["kilogram"] }, conversionFactor: "1.016047 × 10³ kg", quantityKinds: [ "massOfAtomOfANuclideX", "massOfMolecule", "effectiveMass", "mass", "nuclidicMass", "massExcess", "mass" ] },
        "tonUkShipping": { name: "tonUkShipping", label: "ton (UK shipping)", symbol: "British shipping ton", code: "L84", referenceUnit: function() { return samm.units["cubicMetre"] }, conversionFactor: "1.1893 m³", quantityKinds: [ "volume", "sectionModulus", "volume" ] },
        "tonUsOrShortTonUkorus": { name: "tonUsOrShortTonUkorus", label: "ton (US) or short ton (UK/US)", symbol: "ton (US)", code: "STN", referenceUnit: function() { return samm.units["kilogram"] }, conversionFactor: "0.9071847 × 10³ kg", quantityKinds: [ "mass", "massOfAtomOfANuclideX", "massOfMolecule", "effectiveMass", "mass", "nuclidicMass", "massExcess" ] },
        "tonUsPerHour": { name: "tonUsPerHour", label: "ton (US) per hour", symbol: "ton (US) /h", code: "4W", referenceUnit: function() { return samm.units["kilogramPerSecond"] }, conversionFactor: "2.519958 × 10⁻¹ kg/s", quantityKinds: [ "massFlowRate", "massFlowRate" ] },
        "tonUsShipping": { name: "tonUsShipping", label: "ton (US shipping)", symbol: "(US) shipping ton", code: "L86", referenceUnit: function() { return samm.units["cubicMetre"] }, conversionFactor: "1.1326 m³", quantityKinds: [ "volume", "sectionModulus", "volume" ] },
        "tonUsShortPerCubicYard": { name: "tonUsShortPerCubicYard", label: "ton (US short) per cubic yard", symbol: "ton.s/yd³ (US)", code: "L93", referenceUnit: function() { return samm.units["kilogramPerCubicMetre"] }, conversionFactor: "1.186553 × 10³ kg/m³", quantityKinds: [ "massDensity", "volumicMass", "density", "amountOfSubstance", "massDensity", "density", "concentrationOfB", "massConcentrationOfB", "volumicMass" ] },
        "tonneKilometre": { name: "tonneKilometre", label: "tonne kilometre", symbol: "t·km", code: "TKM", referenceUnit: function() { return samm.units["kilogramMetre"] }, conversionFactor: "10⁶ kg × m", quantityKinds: [ "torque", "momentOfForce", "momentOfACouple" ] },
        "tonneMetricTon": { name: "tonneMetricTon", label: "tonne (metric ton)", symbol: "t", code: "TNE", referenceUnit: function() { return samm.units["kilogram"] }, conversionFactor: "10³ kg", quantityKinds: [ "massOfAtomOfANuclideX", "massOfMolecule", "effectiveMass", "mass", "nuclidicMass", "massExcess", "mass" ] },
        "tonnePerBar": { name: "tonnePerBar", label: "tonne per bar", symbol: "t/bar", code: "L70", referenceUnit: function() { return samm.units["kilogramPerPascal"] }, conversionFactor: "10⁻² kg/Pa", quantityKinds: [ "massDensity", "density", "volumicMass", "volumicMass", "massDensity", "density" ] },
        "tonnePerCubicMetre": { name: "tonnePerCubicMetre", label: "tonne per cubic metre", symbol: "t/m³", code: "D41", referenceUnit: function() { return samm.units["kilogramPerCubicMetre"] }, conversionFactor: "10³ kg/m³", quantityKinds: [ "massDensity", "density", "volumicMass", "amountOfSubstance", "massDensity", "density", "concentrationOfB", "massConcentrationOfB", "volumicMass" ] },
        "tonnePerCubicMetreBar": { name: "tonnePerCubicMetreBar", label: "tonne per cubic metre bar", symbol: "(t/m³)/bar", code: "L77", referenceUnit: function() { return samm.units["kilogramPerCubicMetrePascal"] }, conversionFactor: "10⁻² (kg/m³)/Pa", quantityKinds: [ "volumicMass", "massDensity", "density", "density", "volumicMass", "massDensity" ] },
        "tonnePerCubicMetreKelvin": { name: "tonnePerCubicMetreKelvin", label: "tonne per cubic metre kelvin", symbol: "(t/m³)/K", code: "L76", referenceUnit: null, conversionFactor: null, quantityKinds: [ "volumicMass", "massDensity", "density" ] },
        "tonnePerDay": { name: "tonnePerDay", label: "tonne per day", symbol: "t/d", code: "L71", referenceUnit: function() { return samm.units["kilogramPerSecond"] }, conversionFactor: "1.15741 × 10⁻² kg/s", quantityKinds: [ "massFlowRate", "massFlowRate" ] },
        "tonnePerDayBar": { name: "tonnePerDayBar", label: "tonne per day bar", symbol: "(t/d)/bar", code: "L73", referenceUnit: function() { return samm.units["kilogramPerSecondPascal"] }, conversionFactor: "1.15741 × 10⁻⁷ (kg/s)/Pa", quantityKinds: [ "massFlowRate", "massFlowRate" ] },
        "tonnePerDayKelvin": { name: "tonnePerDayKelvin", label: "tonne per day kelvin", symbol: "(t/d)/K", code: "L72", referenceUnit: null, conversionFactor: null, quantityKinds: [ "massFlowRate" ] },
        "tonnePerHour": { name: "tonnePerHour", label: "tonne per hour", symbol: "t/h", code: "E18", referenceUnit: function() { return samm.units["kilogramPerSecond"] }, conversionFactor: "2.77778 × 10⁻¹ kg/s", quantityKinds: [ "massFlowRate", "massFlowRate" ] },
        "tonnePerHourBar": { name: "tonnePerHourBar", label: "tonne per hour bar", symbol: "(t/h)/bar", code: "L75", referenceUnit: function() { return samm.units["kilogramPerSecondPascal"] }, conversionFactor: "2.77778 × 10⁻⁶ (kg/s)/Pa", quantityKinds: [ "massFlowRate", "massFlowRate" ] },
        "tonnePerHourKelvin": { name: "tonnePerHourKelvin", label: "tonne per hour kelvin", symbol: "(t/h)/K", code: "L74", referenceUnit: null, conversionFactor: null, quantityKinds: [ "massFlowRate" ] },
        "tonnePerKelvin": { name: "tonnePerKelvin", label: "tonne per kelvin", symbol: "t/K", code: "L69", referenceUnit: function() { return samm.units["kilogramPerKelvin"] }, conversionFactor: "10³ kg/K", quantityKinds: [ "mass", "volumicMass", "massDensity", "density" ] },
        "tonnePerMinute": { name: "tonnePerMinute", label: "tonne per minute", symbol: "t/min", code: "L78", referenceUnit: function() { return samm.units["kilogramPerSecond"] }, conversionFactor: "16.6667 kg/s", quantityKinds: [ "massFlowRate", "massFlowRate" ] },
        "tonnePerMinuteBar": { name: "tonnePerMinuteBar", label: "tonne per minute bar", symbol: "(t/min)/bar", code: "L80", referenceUnit: function() { return samm.units["kilogramPerSecondPascal"] }, conversionFactor: "1.66667 × 10⁻⁴ (kg/s)/Pa", quantityKinds: [ "massFlowRate", "massFlowRate" ] },
        "tonnePerMinuteKelvin": { name: "tonnePerMinuteKelvin", label: "tonne per minute kelvin", symbol: "(t/min)/K", code: "L79", referenceUnit: null, conversionFactor: null, quantityKinds: [ "massFlowRate" ] },
        "tonnePerMonth": { name: "tonnePerMonth", label: "tonne per month", symbol: "t/mo", code: "M88", referenceUnit: function() { return samm.units["kilogramPerSecond"] }, conversionFactor: "3.80257053768 × 10⁻⁴ kg/s", quantityKinds: [ "massFlowRate", "massFlowRate" ] },
        "tonnePerSecond": { name: "tonnePerSecond", label: "tonne per second", symbol: "t/s", code: "L81", referenceUnit: function() { return samm.units["kilogramPerSecond"] }, conversionFactor: "10³ kg/s", quantityKinds: [ "massFlowRate", "massFlowRate" ] },
        "tonnePerSecondBar": { name: "tonnePerSecondBar", label: "tonne per second bar", symbol: "(t/s)/bar", code: "L83", referenceUnit: function() { return samm.units["kilogramPerSecondPascal"] }, conversionFactor: "10⁻² (kg/s)/Pa", quantityKinds: [ "massFlowRate", "massFlowRate" ] },
        "tonnePerSecondKelvin": { name: "tonnePerSecondKelvin", label: "tonne per second kelvin", symbol: "(t/s)/K", code: "L82", referenceUnit: null, conversionFactor: null, quantityKinds: [ "massFlowRate" ] },
        "tonnePerYear": { name: "tonnePerYear", label: "tonne per year", symbol: "t/y", code: "M89", referenceUnit: function() { return samm.units["kilogramPerSecond"] }, conversionFactor: "3.168808781 × 10⁻⁵ kg/s", quantityKinds: [ "massFlowRate", "massFlowRate" ] },
        "torrPerMetre": { name: "torrPerMetre", label: "torr per metre", symbol: "Torr/m", code: "P85", referenceUnit: null, conversionFactor: null, quantityKinds: [ "hardnessIndex" ] },
        "totalAcidNumber": { name: "totalAcidNumber", label: "total acid number", symbol: "TAN", code: "TAN", referenceUnit: null, conversionFactor: null, quantityKinds: null },
        "treatment": { name: "treatment", label: "treatment", symbol: null, code: "U1", referenceUnit: null, conversionFactor: null, quantityKinds: null },
        "trillionEur": { name: "trillionEur", label: "trillion (EUR)", symbol: null, code: "TRL", referenceUnit: null, conversionFactor: null, quantityKinds: null },
        "trip": { name: "trip", label: "trip", symbol: null, code: "E54", referenceUnit: null, conversionFactor: null, quantityKinds: null },
        "tropicalYear": { name: "tropicalYear", label: "tropical year", symbol: "y (tropical)", code: "D42", referenceUnit: function() { return samm.units["secondUnitOfTime"] }, conversionFactor: "3.155692 5 × 10⁷ s", quantityKinds: [ "timeConstant", "reactorTimeConstant", "halfLife", "meanLife", "time", "relaxationTime", "period", "carrierLifeTime", "periodicTime", "reverberationTime", "time" ] },
        "troyOunceOrApothecaryOunce": { name: "troyOunceOrApothecaryOunce", label: "troy ounce or apothecary ounce", symbol: "tr oz", code: "APZ", referenceUnit: function() { return samm.units["kilogram"] }, conversionFactor: "3.110348 × 10⁻³ kg", quantityKinds: [ "mass", "massOfAtomOfANuclideX", "massOfMolecule", "effectiveMass", "mass", "nuclidicMass", "massExcess" ] },
        "troyPoundUs": { name: "troyPoundUs", label: "troy pound (US)", symbol: null, code: "LBT", referenceUnit: function() { return samm.units["gram"] }, conversionFactor: "373.2417 g", quantityKinds: [ "mass" ] },
        "twentyFootContainer": { name: "twentyFootContainer", label: "twenty foot container", symbol: null, code: "20", referenceUnit: null, conversionFactor: null, quantityKinds: null },
        "tyre": { name: "tyre", label: "tyre", symbol: null, code: "E23", referenceUnit: null, conversionFactor: null, quantityKinds: null },
        "unifiedAtomicMassUnit": { name: "unifiedAtomicMassUnit", label: "unified atomic mass unit", symbol: "u", code: "D43", referenceUnit: function() { return samm.units["kilogram"] }, conversionFactor: "1.660 538 782 × 10⁻²⁷ kg", quantityKinds: [ "massDefect", "nuclidicMass", "massOfAtomOfANuclideX", "massOfMolecule", "unifiedAtomicMassConstant", "massOfAtomOfANuclideX", "massOfMolecule", "effectiveMass", "mass", "nuclidicMass", "massExcess" ] },
        "unitPole": { name: "unitPole", label: "unit pole", symbol: "unit pole", code: "P53", referenceUnit: function() { return samm.units["weber"] }, conversionFactor: "1.256637 × 10⁻⁷ Wb", quantityKinds: [ "magneticFluxQuantum", "magneticFluxQuantum", "magneticFlux" ] },
        "usGallonPerMinute": { name: "usGallonPerMinute", label: "US gallon per minute", symbol: "gal (US) /min", code: "G2", referenceUnit: function() { return samm.units["cubicMetrePerSecond"] }, conversionFactor: "6.309020 × 10⁻⁵ m³/s", quantityKinds: [ "volumeFlowRate", "recombinationCoefficient", "instantaneousVolumeFlowRate", "volumeFlowRate" ] },
        "use": { name: "use", label: "use", symbol: null, code: "E55", referenceUnit: null, conversionFactor: null, quantityKinds: null },
        "var": { name: "var", label: "var", symbol: "var", code: "D44", referenceUnit: function() { return samm.units["voltAmpere"] }, conversionFactor: "V × A", quantityKinds: [ "apparentPower", "reactivePower" ] },
        "volt": { name: "volt", label: "volt", symbol: "V", code: "VLT", referenceUnit: null, conversionFactor: null, quantityKinds: [ "tension", "voltage", "peltierCoefficientForSubstancesAAndB", "electromotiveForce", "thermoelectromotiveForceBetweenSubstancesAAndB", "potentialDifference", "electricPotential" ] },
        "voltAc": { name: "voltAc", label: "volt AC", symbol: "V", code: "2G", referenceUnit: null, conversionFactor: null, quantityKinds: null },
        "voltAmpere": { name: "voltAmpere", label: "volt - ampere", symbol: "V·A", code: "D46", referenceUnit: function() { return samm.units["watt"] }, conversionFactor: "W", quantityKinds: [ "radiantEnergyflux", "activePower", "heatFlowRate", "soundPower", "power", "radiantPower", "powerForDirectCurrent", "apparentPower" ] },
        "voltAmperePerKilogram": { name: "voltAmperePerKilogram", label: "volt - ampere per kilogram", symbol: "V·A / kg", code: "VA", referenceUnit: null, conversionFactor: null, quantityKinds: null },
        "voltDc": { name: "voltDc", label: "volt DC", symbol: "V", code: "2H", referenceUnit: null, conversionFactor: null, quantityKinds: null },
        "voltPerBar": { name: "voltPerBar", label: "volt per bar", symbol: "V/bar", code: "G60", referenceUnit: null, conversionFactor: null, quantityKinds: [ "electricFieldStrength" ] },
        "voltPerCentimetre": { name: "voltPerCentimetre", label: "volt per centimetre", symbol: "V/cm", code: "D47", referenceUnit: null, conversionFactor: null, quantityKinds: [ "electricFieldStrength" ] },
        "voltPerInch": { name: "voltPerInch", label: "volt per inch", symbol: "V/in", code: "H23", referenceUnit: null, conversionFactor: null, quantityKinds: [ "electricFieldStrength" ] },
        "voltPerKelvin": { name: "voltPerKelvin", label: "volt per kelvin", symbol: "V/K", code: "D48", referenceUnit: null, conversionFactor: null, quantityKinds: [ "seebeckCoefficientForSubstancesAAndB" ] },
        "voltPerLitreMinute": { name: "voltPerLitreMinute", label: "volt per litre minute", symbol: "V/(l·min)", code: "F87", referenceUnit: null, conversionFactor: null, quantityKinds: [ "electricFieldStrength" ] },
        "voltPerMetre": { name: "voltPerMetre", label: "volt per metre", symbol: "V/m", code: "D50", referenceUnit: null, conversionFactor: null, quantityKinds: [ "electricFieldStrength" ] },
        "voltPerMicrosecond": { name: "voltPerMicrosecond", label: "volt per microsecond", symbol: "V/µs", code: "H24", referenceUnit: function() { return samm.units["voltPerSecond"] }, conversionFactor: "10⁶ V/s", quantityKinds: [ "electricFieldStrength", "electricFieldStrength" ] },
        "voltPerMillimetre": { name: "voltPerMillimetre", label: "volt per millimetre", symbol: "V/mm", code: "D51", referenceUnit: function() { return samm.units["voltPerMetre"] }, conversionFactor: "10³ V/m", quantityKinds: [ "electricFieldStrength", "electricFieldStrength" ] },
        "voltPerPascal": { name: "voltPerPascal", label: "volt per pascal", symbol: "V/Pa", code: "N98", referenceUnit: null, conversionFactor: null, quantityKinds: [ "electricFieldStrength" ] },
        "voltPerSecond": { name: "voltPerSecond", label: "volt per second", symbol: "V/s", code: "H46", referenceUnit: null, conversionFactor: null, quantityKinds: [ "electricFieldStrength" ] },
        "voltSecondPerMetre": { name: "voltSecondPerMetre", label: "volt second per metre", symbol: "V·s/m", code: "H45", referenceUnit: null, conversionFactor: null, quantityKinds: [ "electricFieldStrength" ] },
        "voltSquareInchPerPoundForce": { name: "voltSquareInchPerPoundForce", label: "volt square inch per pound-force", symbol: "V/(lbf/in²)", code: "H22", referenceUnit: null, conversionFactor: null, quantityKinds: [ "electricFieldStrength" ] },
        "voltSquaredPerKelvinSquared": { name: "voltSquaredPerKelvinSquared", label: "volt squared per kelvin squared", symbol: "V²/K²", code: "D45", referenceUnit: null, conversionFactor: null, quantityKinds: [ "electricFieldStrength" ] },
        "waterHorsePower": { name: "waterHorsePower", label: "water horse power", symbol: null, code: "F80", referenceUnit: function() { return samm.units["watt"] }, conversionFactor: "7.46043 × 10² W", quantityKinds: [ "power", "radiantEnergyflux", "activePower", "heatFlowRate", "soundPower", "power", "radiantPower", "powerForDirectCurrent" ] },
        "watt": { name: "watt", label: "watt", symbol: "W", code: "WTT", referenceUnit: null, conversionFactor: null, quantityKinds: [ "radiantEnergyflux", "activePower", "heatFlowRate", "soundPower", "power", "radiantPower", "powerForDirectCurrent" ] },
        "wattHour": { name: "wattHour", label: "watt hour", symbol: "W·h", code: "WHR", referenceUnit: function() { return samm.units["joule"] }, conversionFactor: "3.6 × 10³ J", quantityKinds: [ "work", "activeEnergy", "energy", "kineticEnergy", "potentialEnergy", "quantityOfHeat", "reactionEnergy", "workFunction", "activeEnergy", "kineticEnergy", "levelWidth", "meanEnergyImparted", "helmholtzFunction", "radiantEnergy", "potentialEnergy", "energy", "thermodynamicEnergy", "helmholtzFreeEnergy", "work", "heat", "hartreeEnergy", "energyImparted", "enthalpy", "alphaDisintegrationEnergy" ] },
        "wattPerCubicMetre": { name: "wattPerCubicMetre", label: "watt per cubic metre", symbol: "W/m³", code: "H47", referenceUnit: null, conversionFactor: null, quantityKinds: [ "firstRadiationConstant", "radiantEnergy", "radiantExitance", "fluenceRate", "irradiance" ] },
        "wattPerKelvin": { name: "wattPerKelvin", label: "watt per kelvin", symbol: "W/K", code: "D52", referenceUnit: null, conversionFactor: null, quantityKinds: [ "thermalConductance" ] },
        "wattPerKilogram": { name: "wattPerKilogram", label: "watt per kilogram", symbol: "W/kg", code: "WA", referenceUnit: null, conversionFactor: null, quantityKinds: null },
        "wattPerMetre": { name: "wattPerMetre", label: "watt per metre", symbol: "W/m", code: "H74", referenceUnit: null, conversionFactor: null, quantityKinds: [ "radiantEnergy", "fluenceRate", "irradiance", "radiantExitance", "firstRadiationConstant" ] },
        "wattPerMetreDegreeCelsius": { name: "wattPerMetreDegreeCelsius", label: "watt per metre degree Celsius", symbol: "W/(m·°C)", code: "N80", referenceUnit: function() { return samm.units["wattPerMetreKelvin"] }, conversionFactor: "W/(m × K)", quantityKinds: [ "thermalConductivity", "thermalConductivity" ] },
        "wattPerMetreKelvin": { name: "wattPerMetreKelvin", label: "watt per metre kelvin", symbol: "W/(m·K)", code: "D53", referenceUnit: null, conversionFactor: null, quantityKinds: [ "thermalConductivity" ] },
        "wattPerSquareCentimetre": { name: "wattPerSquareCentimetre", label: "watt per square centimetre", symbol: "W/cm²", code: "N48", referenceUnit: function() { return samm.units["wattPerSquareMetre"] }, conversionFactor: "10⁴ W/m²", quantityKinds: [ "densityOfHeatFlowRate", "poyntingVector", "fluenceRate", "irradiance", "soundIntensity", "radiantEnergy", "firstRadiationConstant", "energyFluenceRate", "energyFluxDensity", "densityOfHeatFlowRate", "radiantExitance" ] },
        "wattPerSquareInch": { name: "wattPerSquareInch", label: "watt per square inch", symbol: "W/in²", code: "N49", referenceUnit: function() { return samm.units["wattPerSquareMetre"] }, conversionFactor: "1.550003 × 10³ W/m²", quantityKinds: [ "densityOfHeatFlowRate", "poyntingVector", "fluenceRate", "irradiance", "soundIntensity", "radiantEnergy", "firstRadiationConstant", "energyFluenceRate", "energyFluxDensity", "densityOfHeatFlowRate", "radiantExitance" ] },
        "wattPerSquareMetre": { name: "wattPerSquareMetre", label: "watt per square metre", symbol: "W/m²", code: "D54", referenceUnit: null, conversionFactor: null, quantityKinds: [ "poyntingVector", "fluenceRate", "irradiance", "soundIntensity", "radiantEnergy", "firstRadiationConstant", "energyFluenceRate", "energyFluxDensity", "densityOfHeatFlowRate", "radiantExitance" ] },
        "wattPerSquareMetreKelvin": { name: "wattPerSquareMetreKelvin", label: "watt per square metre kelvin", symbol: "W/(m²·K)", code: "D55", referenceUnit: null, conversionFactor: null, quantityKinds: [ "coefficientOfHeatTransfer" ] },
        "wattPerSquareMetreKelvinToTheFourthPower": { name: "wattPerSquareMetreKelvinToTheFourthPower", label: "watt per square metre kelvin to the fourth power", symbol: "W/(m²·K⁴)", code: "D56", referenceUnit: null, conversionFactor: null, quantityKinds: [ "stefanBoltzmannConstant" ] },
        "wattPerSteradian": { name: "wattPerSteradian", label: "watt per steradian", symbol: "W/sr", code: "D57", referenceUnit: null, conversionFactor: null, quantityKinds: [ "radiantIntensity" ] },
        "wattPerSteradianSquareMetre": { name: "wattPerSteradianSquareMetre", label: "watt per steradian square metre", symbol: "W/(sr·m²)", code: "D58", referenceUnit: null, conversionFactor: null, quantityKinds: [ "radiance" ] },
        "wattSecond": { name: "wattSecond", label: "watt second", symbol: "W·s", code: "J55", referenceUnit: null, conversionFactor: null, quantityKinds: [ "energy", "quantityOfHeat", "thermodynamicEnergy", "helmholtzFunction", "helmholtzFreeEnergy", "enthalpy", "heat" ] },
        "wattSquareMetre": { name: "wattSquareMetre", label: "watt square metre", symbol: "W·m²", code: "Q21", referenceUnit: null, conversionFactor: null, quantityKinds: null },
        "weber": { name: "weber", label: "weber", symbol: "Wb", code: "WEB", referenceUnit: null, conversionFactor: null, quantityKinds: [ "magneticFluxQuantum", "magneticFlux" ] },
        "weberMetre": { name: "weberMetre", label: "weber metre", symbol: "Wb·m", code: "P50", referenceUnit: null, conversionFactor: null, quantityKinds: [ "magneticDipoleMoment" ] },
        "weberPerMetre": { name: "weberPerMetre", label: "weber per metre", symbol: "Wb/m", code: "D59", referenceUnit: null, conversionFactor: null, quantityKinds: [ "magneticVectorPotential" ] },
        "weberPerMillimetre": { name: "weberPerMillimetre", label: "weber per millimetre", symbol: "Wb/mm", code: "D60", referenceUnit: function() { return samm.units["weberPerMetre"] }, conversionFactor: "10³ Wb/m", quantityKinds: [ "magneticVectorPotential", "magneticVectorPotential" ] },
        "weberToThePowerMinusOne": { name: "weberToThePowerMinusOne", label: "weber to the power minus one", symbol: "1/Wb", code: "Q23", referenceUnit: null, conversionFactor: null, quantityKinds: null },
        "week": { name: "week", label: "week", symbol: "wk", code: "WEE", referenceUnit: function() { return samm.units["secondUnitOfTime"] }, conversionFactor: "6.048 × 10⁵ s", quantityKinds: [ "timeConstant", "reactorTimeConstant", "halfLife", "meanLife", "time", "relaxationTime", "period", "carrierLifeTime", "periodicTime", "reverberationTime", "time" ] },
        "well": { name: "well", label: "well", symbol: null, code: "E56", referenceUnit: null, conversionFactor: null, quantityKinds: null },
        "wetKilo": { name: "wetKilo", label: "wet kilo", symbol: null, code: "W2", referenceUnit: null, conversionFactor: null, quantityKinds: null },
        "wetPound": { name: "wetPound", label: "wet pound", symbol: null, code: "WB", referenceUnit: null, conversionFactor: null, quantityKinds: null },
        "wetTon": { name: "wetTon", label: "wet ton", symbol: null, code: "WE", referenceUnit: null, conversionFactor: null, quantityKinds: null },
        "wineGallon": { name: "wineGallon", label: "wine gallon", symbol: null, code: "WG", referenceUnit: null, conversionFactor: null, quantityKinds: null },
        "workingDay": { name: "workingDay", label: "working day", symbol: null, code: "E49", referenceUnit: null, conversionFactor: null, quantityKinds: null },
        "workingMonth": { name: "workingMonth", label: "working month", symbol: null, code: "WM", referenceUnit: null, conversionFactor: null, quantityKinds: null },
        "yard": { name: "yard", label: "yard", symbol: "yd", code: "YRD", referenceUnit: function() { return samm.units["metre"] }, conversionFactor: "0.9144 m", quantityKinds: [ "length", "radius", "thickness", "radiusOfCurvature", "distance", "breadth", "cartesianCoordinates", "height", "diameter", "lengthOfPath", "thickness", "particlePositionVector", "cartesianCoordinates", "focalDistance", "radius", "radiusOfCurvature", "displacementVectorOfIonOrAtom", "lengthOfPath", "diameter", "comptonWavelength", "slowingDownLength", "migrationLength", "meanFreePath", "equilibriumPositionVectorOfIonOrAtom", "instantaneousSoundParticleDisplacement", "imageDistance", "breadth", "length", "halfValueThickness", "coherenceLength", "latticeVector", "londonPenetrationDepth", "diffusionLength", "meanFreePathOfPhononsOrElectrons", "diffusionCoefficientForNeutronFluxDensity", "halfThickness", "height", "electronRadius", "distance", "objectDistance", "bohrRadius", "diffusionCoefficientForNeutronFluenceRate", "nuclearRadius", "wavelength", "fundamentalLatticeVector", "meanLinearRange" ] },
        "yardPerDegreeFahrenheit": { name: "yardPerDegreeFahrenheit", label: "yard per degree Fahrenheit", symbol: "yd/°F", code: "L98", referenceUnit: function() { return samm.units["metrePerKelvin"] }, conversionFactor: "1.64592 m/K", quantityKinds: [ "thickness", "length", "lengthOfPath", "distance", "radius", "diameter", "breadth", "cartesianCoordinates", "radiusOfCurvature", "height", "length", "radius", "height", "thickness", "distance", "lengthOfPath", "diameter", "breadth", "cartesianCoordinates", "radiusOfCurvature" ] },
        "yardPerHour": { name: "yardPerHour", label: "yard per hour", symbol: "yd/h", code: "M66", referenceUnit: function() { return samm.units["metrePerSecond"] }, conversionFactor: "2.54 × 10⁻⁴ m/s", quantityKinds: [ "velocity", "phaseVelocity", "groupVelocity", "groupVelocity", "velocityOfSoundPhaseVelocity", "phaseVelocity", "neutronSpeed", "phaseSpeedOfElectromagneticWaves", "velocity", "velocitySpeedOnPropagationOfElectromagneticWavesInVacuo", "instantaneousSoundParticleVelocity", "phaseVelocityOfElectromagneticWaves" ] },
        "yardPerMinute": { name: "yardPerMinute", label: "yard per minute", symbol: "yd/min", code: "M65", referenceUnit: function() { return samm.units["metrePerSecond"] }, conversionFactor: "1.524 × 10⁻² m/s", quantityKinds: [ "groupVelocity", "velocityOfSoundPhaseVelocity", "phaseVelocity", "neutronSpeed", "phaseSpeedOfElectromagneticWaves", "velocity", "velocitySpeedOnPropagationOfElectromagneticWavesInVacuo", "instantaneousSoundParticleVelocity", "phaseVelocityOfElectromagneticWaves", "groupVelocity", "velocity", "phaseVelocity" ] },
        "yardPerPsi": { name: "yardPerPsi", label: "yard per psi", symbol: "yd/psi", code: "L99", referenceUnit: function() { return samm.units["metrePerPascal"] }, conversionFactor: "1.326225 × 10⁻⁴ m/Pa", quantityKinds: [ "diameter", "height", "radiusOfCurvature", "distance", "lengthOfPath", "length", "cartesianCoordinates", "breadth", "radius", "thickness", "cartesianCoordinates", "radius", "lengthOfPath", "diameter", "radiusOfCurvature", "height", "length", "breadth", "distance", "thickness" ] },
        "yardPerSecond": { name: "yardPerSecond", label: "yard per second", symbol: "yd/s", code: "M64", referenceUnit: function() { return samm.units["metrePerSecond"] }, conversionFactor: "9.144 × 10⁻¹ m/s", quantityKinds: [ "groupVelocity", "velocityOfSoundPhaseVelocity", "phaseVelocity", "neutronSpeed", "phaseSpeedOfElectromagneticWaves", "velocity", "velocitySpeedOnPropagationOfElectromagneticWavesInVacuo", "instantaneousSoundParticleVelocity", "phaseVelocityOfElectromagneticWaves", "phaseVelocity", "groupVelocity", "velocity" ] },
        "yardPerSecondSquared": { name: "yardPerSecondSquared", label: "yard per second squared", symbol: "yd/s²", code: "M40", referenceUnit: function() { return samm.units["metrePerSecondSquared"] }, conversionFactor: "9.144 × 10⁻¹ m/s²", quantityKinds: [ "acceleration", "instantaneousSoundParticleAcceleration", "accelerationOfFreeFall", "accelerationDueToGravity", "accelerationDueToGravity", "acceleration", "accelerationOfFreeFall" ] },
        "year": { name: "year", label: "year", symbol: "y", code: "ANN", referenceUnit: function() { return samm.units["secondUnitOfTime"] }, conversionFactor: "3.15576 × 10⁷ s", quantityKinds: [ "time", "timeConstant", "reactorTimeConstant", "halfLife", "meanLife", "time", "relaxationTime", "period", "carrierLifeTime", "periodicTime", "reverberationTime" ] },
        "yobibyte": { name: "yobibyte", label: "Yobibyte", symbol: "YiB", code: null, referenceUnit: function() { return samm.units["byte"] }, conversionFactor: "2⁸⁰ B", quantityKinds: [ "informationEntropy", "informationEntropy" ] },
        "yottabyte": { name: "yottabyte", label: "Yottabyte", symbol: "YB", code: null, referenceUnit: function() { return samm.units["byte"] }, conversionFactor: "10²⁴ B", quantityKinds: [ "informationEntropy", "informationEntropy" ] },
        "zebibyte": { name: "zebibyte", label: "Zebibyte", symbol: "ZiB", code: null, referenceUnit: function() { return samm.units["byte"] }, conversionFactor: "2⁷⁰ B", quantityKinds: [ "informationEntropy", "informationEntropy" ] },
        "zettabyte": { name: "zettabyte", label: "Zettabyte", symbol: "ZB", code: null, referenceUnit: function() { return samm.units["byte"] }, conversionFactor: "10²¹ B", quantityKinds: [ "informationEntropy", "informationEntropy" ] },
        "zone": { name: "zone", label: "zone", symbol: null, code: "E57", referenceUnit: null, conversionFactor: null, quantityKinds: null }
    }
};
