/*
 * Copyright (c) 2023 Robert Bosch Manufacturing Solutions GmbH
 *
 * See the AUTHORS file(s) distributed with this work for additional
 * information regarding authorship.
 *
 * This Source Code Form is subject to the terms of the Mozilla Public
 * License, v. 2.0. If a copy of the MPL was not distributed with this
 * file, You can obtain one at https://mozilla.org/MPL/2.0/.
 *
 * SPDX-License-Identifier: MPL-2.0
 */

package org.eclipse.esmf.metamodel;

import java.util.List;
import java.util.Optional;

/**
 * Represents model elements that contain {@link Property}s
 */
public interface HasProperties extends ModelElement {
   /**
    * @return the {@link Property}(ies) defined in the scope of this element.
    */
   List<Property> getProperties();

   default Optional<Property> getPropertyByName( final String name ) {
      return getProperties().stream().filter( property -> property.getName().equals( name ) ).findAny();
   }
}
