/*
 * Copyright (c) 2023 Robert Bosch Manufacturing Solutions GmbH
 *
 * See the AUTHORS file(s) distributed with this work for additional
 * information regarding authorship.
 *
 * This Source Code Form is subject to the terms of the Mozilla Public
 * License, v. 2.0. If a copy of the MPL was not distributed with this
 * file, You can obtain one at https://mozilla.org/MPL/2.0/.
 *
 * SPDX-License-Identifier: MPL-2.0
 */

package org.eclipse.esmf.metamodel.impl;

import java.util.List;
import java.util.Objects;

import org.eclipse.esmf.aspectmodel.loader.MetaModelBaseAttributes;
import org.eclipse.esmf.aspectmodel.visitor.AspectVisitor;
import org.eclipse.esmf.metamodel.Event;
import org.eclipse.esmf.metamodel.Property;

public class DefaultEvent extends ModelElementImpl implements Event {
   private final List<Property> properties;

   public DefaultEvent( final MetaModelBaseAttributes metaModelBaseAttributes,
         final List<Property> properties ) {
      super( metaModelBaseAttributes );
      this.properties = properties;
   }

   @Override
   public List<Property> getProperties() {
      return properties;
   }

   /**
    * Accepts an Aspect visitor
    *
    * @param visitor The visitor to accept
    * @param <T> The result type of the traversal operation
    * @param <C> The context of the visitor traversal
    */
   @Override
   public <T, C> T accept( final AspectVisitor<T, C> visitor, final C context ) {
      return visitor.visitEvent( this, context );
   }

   @Override
   public boolean equals( final Object o ) {
      if ( this == o ) {
         return true;
      }
      if ( o == null || getClass() != o.getClass() ) {
         return false;
      }
      final DefaultEvent that = (DefaultEvent) o;
      return Objects.equals( properties, that.properties );
   }

   @Override
   public int hashCode() {
      return Objects.hash( properties );
   }
}
