/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.esmf.aspectmodel.java;

import com.fasterxml.jackson.annotation.JsonSubTypes;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import com.google.common.base.CaseFormat;
import com.google.common.base.Converter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.Predicate;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import java.util.stream.Stream;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.text.StringEscapeUtils;
import org.apache.commons.text.translate.UnicodeUnescaper;
import org.apache.jena.rdf.model.Resource;
import org.apache.jena.rdf.model.ResourceFactory;
import org.apache.jena.vocabulary.RDF;
import org.apache.jena.vocabulary.XSD;
import org.eclipse.esmf.aspectmodel.java.CollectionAspect;
import org.eclipse.esmf.aspectmodel.java.ConstraintAnnotationBuilder;
import org.eclipse.esmf.aspectmodel.java.ImportTracker;
import org.eclipse.esmf.aspectmodel.java.JavaCodeGenerationConfig;
import org.eclipse.esmf.aspectmodel.java.ValueExpressionVisitor;
import org.eclipse.esmf.aspectmodel.java.ValueInitializer;
import org.eclipse.esmf.aspectmodel.java.ValueToEnumKeyVisitor;
import org.eclipse.esmf.aspectmodel.java.exception.CodeGenerationException;
import org.eclipse.esmf.aspectmodel.java.types.Either;
import org.eclipse.esmf.aspectmodel.visitor.AspectStreamTraversalVisitor;
import org.eclipse.esmf.aspectmodel.visitor.AspectVisitor;
import org.eclipse.esmf.metamodel.AbstractEntity;
import org.eclipse.esmf.metamodel.Characteristic;
import org.eclipse.esmf.metamodel.ComplexType;
import org.eclipse.esmf.metamodel.Constraint;
import org.eclipse.esmf.metamodel.Entity;
import org.eclipse.esmf.metamodel.HasProperties;
import org.eclipse.esmf.metamodel.Property;
import org.eclipse.esmf.metamodel.Scalar;
import org.eclipse.esmf.metamodel.StructureElement;
import org.eclipse.esmf.metamodel.Type;
import org.eclipse.esmf.metamodel.Value;
import org.eclipse.esmf.metamodel.characteristic.Enumeration;
import org.eclipse.esmf.metamodel.characteristic.Quantifiable;
import org.eclipse.esmf.metamodel.characteristic.State;
import org.eclipse.esmf.metamodel.characteristic.Trait;
import org.eclipse.esmf.metamodel.datatype.LangString;
import org.eclipse.esmf.metamodel.datatype.SammXsdType;

public class AspectModelJavaUtil {
    public static final Converter<String, String> TO_CONSTANT = CaseFormat.UPPER_CAMEL.converterTo(CaseFormat.UPPER_UNDERSCORE);
    public static final UnicodeUnescaper UNESCAPER = new UnicodeUnescaper();

    private AspectModelJavaUtil() {
    }

    public static String getPropertyType(Property property, boolean inclValidation, JavaCodeGenerationConfig codeGenerationConfig) {
        String propertyType = AspectModelJavaUtil.determinePropertyType(property.getCharacteristic(), inclValidation, codeGenerationConfig);
        if (property.isOptional()) {
            Optional<String> optional;
            Object t;
            if (inclValidation && property.getCharacteristic().isPresent() && (t = property.getCharacteristic().get()) instanceof Trait) {
                Trait t2 = (Trait)t;
                optional = Optional.of(AspectModelJavaUtil.buildConstraintsForCharacteristic(t2, codeGenerationConfig));
            } else {
                optional = Optional.empty();
            }
            return AspectModelJavaUtil.containerType(Optional.class, propertyType, optional);
        }
        return propertyType;
    }

    public static String getPropertyType(Property property, JavaCodeGenerationConfig codeGenerationConfig) {
        if (property.isAbstract()) {
            return "Object";
        }
        String propertyType = AspectModelJavaUtil.determinePropertyType(property.getCharacteristic(), false, codeGenerationConfig);
        codeGenerationConfig.importTracker().trackPotentiallyParameterizedType(propertyType);
        if (property.isOptional()) {
            return AspectModelJavaUtil.containerType(Optional.class, propertyType, Optional.empty());
        }
        return propertyType;
    }

    public static boolean hasContainerType(Property property) {
        return property.isOptional() || property.getEffectiveCharacteristic().map(characteristic -> characteristic.is(org.eclipse.esmf.metamodel.characteristic.Collection.class)).orElse(false) != false;
    }

    public static boolean hasUnit(Characteristic characteristic) {
        if (characteristic instanceof Quantifiable) {
            Quantifiable quantifiable = (Quantifiable)characteristic;
            return quantifiable.getUnit().isPresent();
        }
        return false;
    }

    public static String determinePropertyType(Optional<Characteristic> optionalCharacteristic, boolean inclValidation, JavaCodeGenerationConfig codeGenerationConfig) {
        Characteristic baseCharacteristic;
        Optional<Type> dataType = optionalCharacteristic.flatMap(Characteristic::getDataType);
        Characteristic characteristic = optionalCharacteristic.orElseThrow(() -> new CodeGenerationException("Can not determine type of missing Characteristic"));
        if (characteristic.is(org.eclipse.esmf.metamodel.characteristic.Collection.class)) {
            return AspectModelJavaUtil.determineCollectionType((org.eclipse.esmf.metamodel.characteristic.Collection)characteristic.as(org.eclipse.esmf.metamodel.characteristic.Collection.class), inclValidation, codeGenerationConfig);
        }
        if (characteristic.is(Enumeration.class)) {
            return characteristic.getName();
        }
        if (characteristic.is(Trait.class) && (baseCharacteristic = ((Trait)characteristic.as(Trait.class)).getBaseCharacteristic()).is(org.eclipse.esmf.metamodel.characteristic.Collection.class)) {
            return AspectModelJavaUtil.determineCollectionType((org.eclipse.esmf.metamodel.characteristic.Collection)baseCharacteristic.as(org.eclipse.esmf.metamodel.characteristic.Collection.class), inclValidation, codeGenerationConfig);
        }
        if (characteristic.is(org.eclipse.esmf.metamodel.characteristic.Either.class)) {
            if (codeGenerationConfig.enableJacksonAnnotations()) {
                codeGenerationConfig.importTracker().importExplicit("org.eclipse.esmf.aspectmodel.jackson.Either");
            } else {
                codeGenerationConfig.importTracker().importExplicit(Either.class);
            }
            String left = AspectModelJavaUtil.determinePropertyType(optionalCharacteristic.map(c -> (org.eclipse.esmf.metamodel.characteristic.Either)c.as(org.eclipse.esmf.metamodel.characteristic.Either.class)).map(org.eclipse.esmf.metamodel.characteristic.Either::getLeft), inclValidation, codeGenerationConfig);
            String right = AspectModelJavaUtil.determinePropertyType(optionalCharacteristic.map(c -> (org.eclipse.esmf.metamodel.characteristic.Either)c.as(org.eclipse.esmf.metamodel.characteristic.Either.class)).map(org.eclipse.esmf.metamodel.characteristic.Either::getRight), inclValidation, codeGenerationConfig);
            return String.format("Either<%s,%s>", left, right);
        }
        return AspectModelJavaUtil.getDataType(dataType, codeGenerationConfig.importTracker(), codeGenerationConfig);
    }

    public static String determineCollectionAspectClassDefinition(StructureElement element, JavaCodeGenerationConfig codeGenerationConfig) {
        Supplier<RuntimeException> error = () -> new CodeGenerationException("Tried to generate a Collection Aspect class definition, but no Property has a Collection Characteristic in " + element.getName());
        codeGenerationConfig.importTracker().importExplicit(CollectionAspect.class);
        for (Property property : element.getProperties()) {
            Characteristic characteristic = (Characteristic)property.getEffectiveCharacteristic().orElseThrow(error);
            if (!(characteristic instanceof org.eclipse.esmf.metamodel.characteristic.Collection)) continue;
            String collectionType = AspectModelJavaUtil.determineCollectionType((org.eclipse.esmf.metamodel.characteristic.Collection)characteristic, false, codeGenerationConfig);
            String dataType = AspectModelJavaUtil.getDataType(characteristic.getDataType(), codeGenerationConfig.importTracker(), codeGenerationConfig);
            return String.format("public class %s implements CollectionAspect<%s,%s>", element.getName(), collectionType, dataType);
        }
        throw error.get();
    }

    public static String determineComplexTypeClassDefinition(ComplexType element, JavaCodeGenerationConfig codeGenerationConfig) {
        StringBuilder classDefinitionBuilder = new StringBuilder("public ");
        if (element.isAbstractEntity()) {
            classDefinitionBuilder.append("abstract ");
        }
        classDefinitionBuilder.append("class ").append(AspectModelJavaUtil.generateClassName((StructureElement)element, codeGenerationConfig));
        classDefinitionBuilder.append(AspectModelJavaUtil.genericClassSignature((StructureElement)element));
        if (element.getExtends().isPresent()) {
            ComplexType extendedComplexType = (ComplexType)element.getExtends().get();
            classDefinitionBuilder.append(" extends ");
            classDefinitionBuilder.append(extendedComplexType.getName());
            String generics = element.getProperties().stream().filter(property -> property.getExtends().isPresent()).map(property -> AspectModelJavaUtil.getPropertyType(property, false, codeGenerationConfig)).collect(Collectors.joining(","));
            Object superTypeGenerics = generics.isEmpty() ? "" : "<" + generics + ">";
            classDefinitionBuilder.append((String)superTypeGenerics);
        }
        classDefinitionBuilder.append(" {");
        return classDefinitionBuilder.toString();
    }

    public static String generateAbstractEntityClassAnnotations(ComplexType element, JavaCodeGenerationConfig codeGenerationConfig, Set<ComplexType> extendingEntities) {
        StringBuilder classAnnotationBuilder = new StringBuilder();
        if (element.isAbstractEntity() || !element.getExtendingElements().isEmpty()) {
            codeGenerationConfig.importTracker().importExplicit(JsonTypeInfo.class);
            codeGenerationConfig.importTracker().importExplicit(JsonSubTypes.class);
            classAnnotationBuilder.append("@JsonTypeInfo(use = JsonTypeInfo.Id.");
            classAnnotationBuilder.append(codeGenerationConfig.jsonTypeInfo().toString());
            classAnnotationBuilder.append(")");
            classAnnotationBuilder.append("@JsonSubTypes({");
            Iterator extendingComplexTypeIterator = AspectModelJavaUtil.getExtendingClosure(element, extendingEntities).iterator();
            while (extendingComplexTypeIterator.hasNext()) {
                ComplexType extendingComplexType = (ComplexType)extendingComplexTypeIterator.next();
                classAnnotationBuilder.append("@JsonSubTypes.Type(value = ");
                classAnnotationBuilder.append(extendingComplexType.getName());
                classAnnotationBuilder.append(".class, name = \"");
                classAnnotationBuilder.append(extendingComplexType.getName());
                classAnnotationBuilder.append("\")");
                if (!extendingComplexTypeIterator.hasNext()) continue;
                classAnnotationBuilder.append(",");
            }
            classAnnotationBuilder.append("})");
        } else if (element.getExtends().isPresent()) {
            codeGenerationConfig.importTracker().importExplicit(JsonTypeInfo.class);
            classAnnotationBuilder.append("@JsonTypeInfo(use = JsonTypeInfo.Id.");
            classAnnotationBuilder.append(codeGenerationConfig.jsonTypeInfo().toString());
            classAnnotationBuilder.append(",");
            classAnnotationBuilder.append("              defaultImpl = ");
            classAnnotationBuilder.append(element.getName());
            classAnnotationBuilder.append(".class)");
        }
        return classAnnotationBuilder.toString();
    }

    private static Stream<ComplexType> getExtendingClosure(ComplexType element, Set<ComplexType> extendingEntities) {
        return Stream.concat(extendingEntities.stream().filter(entity -> element.equals(entity.getExtends().get())), extendingEntities.stream().filter(entity -> element.equals(entity.getExtends().get())).flatMap(extendingElement -> AspectModelJavaUtil.getExtendingClosure(extendingElement, extendingEntities)));
    }

    private static String determineCollectionType(org.eclipse.esmf.metamodel.characteristic.Collection collection, boolean inclValidation, JavaCodeGenerationConfig codeGenerationConfig) {
        Optional<String> elementConstraint;
        Optional dataType = collection.getDataType();
        Optional<String> optional = elementConstraint = inclValidation ? AspectModelJavaUtil.buildConstraintForCollectionElements(collection, codeGenerationConfig) : Optional.empty();
        if (collection.allowsDuplicates() && collection.isOrdered()) {
            codeGenerationConfig.importTracker().importExplicit(List.class);
            return AspectModelJavaUtil.containerType(List.class, AspectModelJavaUtil.getDataType(dataType, codeGenerationConfig.importTracker(), codeGenerationConfig), elementConstraint);
        }
        if (!collection.allowsDuplicates() && collection.isOrdered()) {
            codeGenerationConfig.importTracker().importExplicit(LinkedHashSet.class);
            return AspectModelJavaUtil.containerType(LinkedHashSet.class, AspectModelJavaUtil.getDataType(dataType, codeGenerationConfig.importTracker(), codeGenerationConfig), elementConstraint);
        }
        if (collection.allowsDuplicates() && !collection.isOrdered()) {
            codeGenerationConfig.importTracker().importExplicit(Collection.class);
            return AspectModelJavaUtil.containerType(Collection.class, AspectModelJavaUtil.getDataType(dataType, codeGenerationConfig.importTracker(), codeGenerationConfig), elementConstraint);
        }
        if (!collection.allowsDuplicates() && !collection.isOrdered()) {
            codeGenerationConfig.importTracker().importExplicit(Set.class);
            return AspectModelJavaUtil.containerType(Set.class, AspectModelJavaUtil.getDataType(dataType, codeGenerationConfig.importTracker(), codeGenerationConfig), elementConstraint);
        }
        throw new CodeGenerationException("Could not determine Java collection type for " + collection.getName());
    }

    private static Optional<String> buildConstraintForCollectionElements(org.eclipse.esmf.metamodel.characteristic.Collection collection, JavaCodeGenerationConfig codeGenerationConfig) {
        return collection.getElementCharacteristic().filter(elementCharacteristic -> elementCharacteristic.is(Trait.class)).map(elementCharacteristic -> AspectModelJavaUtil.buildConstraintsForCharacteristic((Trait)elementCharacteristic, codeGenerationConfig));
    }

    public static String containerType(Class<?> containerClass, String elementType, Optional<String> elementConstraint) {
        StringBuilder containerTypeBuilder = new StringBuilder().append(containerClass.getName()).append("<");
        elementConstraint.ifPresent(containerTypeBuilder::append);
        containerTypeBuilder.append(elementType).append(">");
        return containerTypeBuilder.toString();
    }

    public static String getDataType(Optional<Type> dataType, ImportTracker importTracker, JavaCodeGenerationConfig codeGenerationConfig) {
        return dataType.map(type -> {
            Type actualDataType = (Type)dataType.get();
            if (actualDataType instanceof ComplexType) {
                String complexDataType = ((ComplexType)actualDataType).getName();
                if (!codeGenerationConfig.namePrefix().isBlank() || !codeGenerationConfig.namePostfix().isBlank()) {
                    return codeGenerationConfig.namePrefix() + complexDataType + codeGenerationConfig.namePostfix();
                }
                return complexDataType;
            }
            if (actualDataType instanceof Scalar) {
                Resource typeResource = ResourceFactory.createResource((String)actualDataType.getUrn());
                if (typeResource.getURI().equals(RDF.langString.getURI())) {
                    importTracker.importExplicit(LangString.class);
                    return "LangString";
                }
                Class result = SammXsdType.getJavaTypeForMetaModelType((Resource)typeResource);
                importTracker.importExplicit(result);
                return result.getTypeName();
            }
            throw new CodeGenerationException("Could not determine Java type for model type that is neither Scalar nor Entity: " + type.getUrn());
        }).orElseThrow(() -> new CodeGenerationException("Failed to determine Java data type for empty model type"));
    }

    public static Class<?> getDataTypeClass(Type dataType) {
        if (dataType instanceof ComplexType) {
            return ((ComplexType)dataType).getClass();
        }
        Resource typeResource = ResourceFactory.createResource((String)dataType.getUrn());
        if (typeResource.getURI().equals(RDF.langString.getURI())) {
            return Map.class;
        }
        Class result = SammXsdType.getJavaTypeForMetaModelType((Resource)typeResource);
        return result;
    }

    public static String toConstant(String upperOrLowerCamel) {
        if (AspectModelJavaUtil.isAllUppercaseWithUnderscore(upperOrLowerCamel)) {
            return upperOrLowerCamel;
        }
        return (String)TO_CONSTANT.convert((Object)StringUtils.capitalize((String)upperOrLowerCamel));
    }

    public static boolean isAllUppercaseWithUnderscore(String upperOrLowerCamel) {
        return upperOrLowerCamel != null && upperOrLowerCamel.matches("[A-Z0-9_]+");
    }

    public static String createLiteral(String value) {
        return "\"" + AspectModelJavaUtil.escapeForLiteral(value) + "\"";
    }

    public static String escapeForLiteral(String value) {
        return UNESCAPER.translate((CharSequence)StringEscapeUtils.escapeJava((String)value));
    }

    public static String generateEnumKey(Value value) {
        return (String)value.accept((AspectVisitor)new ValueToEnumKeyVisitor(), null);
    }

    public static String applyImports(String body, JavaCodeGenerationConfig codeGenerationConfig) {
        String importsApplied = body;
        for (String oneImport : codeGenerationConfig.importTracker().getUsedImports()) {
            String className = oneImport.substring(oneImport.lastIndexOf(46) + 1);
            importsApplied = importsApplied.replaceAll(oneImport, className);
        }
        return importsApplied;
    }

    public static boolean isPropertyNotInPayload(Property property, JavaCodeGenerationConfig codeGenerationConfig) {
        if (property.isNotInPayload()) {
            codeGenerationConfig.importTracker().importExplicit("com.fasterxml.jackson.annotation.JsonIgnore");
            return true;
        }
        return false;
    }

    public static String buildConstraintsForCharacteristic(Trait trait, JavaCodeGenerationConfig codeGenerationConfig) {
        return trait.getConstraints().stream().map(constraint -> new ConstraintAnnotationBuilder().setConstraintClass((Constraint)constraint).setImportTracker(codeGenerationConfig.importTracker()).build()).collect(Collectors.joining());
    }

    public static boolean anyPropertyNotInPayload(HasProperties element) {
        return element.getProperties().stream().anyMatch(Property::isNotInPayload);
    }

    public static List<Property> getAllProperties(ComplexType element) {
        ArrayList<Property> allProperties = new ArrayList<Property>(element.getProperties());
        if (element.getExtends().isPresent()) {
            ComplexType extendedComplexType = (ComplexType)element.getExtends().get();
            List<Property> allPropertiesFromExtendedComplexType = AspectModelJavaUtil.getAllProperties(extendedComplexType);
            allProperties.addAll(allPropertiesFromExtendedComplexType);
        }
        return allProperties;
    }

    public static List<Property> getAllPropertiesInPayload(ComplexType element) {
        List<Property> allPropertiesInPayload = AspectModelJavaUtil.getPropertiesInPayload((HasProperties)element);
        if (element.getExtends().isPresent()) {
            ComplexType extendedComplexType = (ComplexType)element.getExtends().get();
            List<Property> allPropertiesFromExtendedComplexType = AspectModelJavaUtil.getPropertiesInPayload((HasProperties)extendedComplexType);
            allPropertiesInPayload.addAll(allPropertiesFromExtendedComplexType);
        }
        return allPropertiesInPayload;
    }

    public static List<Property> getPropertiesInPayload(HasProperties element) {
        Predicate<Property> notInPayload = Property::isNotInPayload;
        Predicate<Property> inPayload = notInPayload.negate();
        return element.getProperties().stream().filter(inPayload).collect(Collectors.toList());
    }

    public static String generateInitializer(Property property, String value, JavaCodeGenerationConfig codeGenerationConfig, ValueInitializer valueInitializer) {
        return property.getDataType().map(type -> {
            Resource typeResource = ResourceFactory.createResource((String)type.getUrn());
            Class result = SammXsdType.getJavaTypeForMetaModelType((Resource)typeResource);
            codeGenerationConfig.importTracker().importExplicit(result);
            return valueInitializer.apply(typeResource, value);
        }).orElseThrow(() -> new CodeGenerationException("The Either Characteristic is not allowed for Properties used as elements in a StructuredValue"));
    }

    public static String generateEnumValue(Value value, JavaCodeGenerationConfig codeGenerationConfig) {
        ValueExpressionVisitor.Context context = new ValueExpressionVisitor.Context(codeGenerationConfig, false);
        return (String)value.accept((AspectVisitor)new ValueExpressionVisitor(), (Object)context);
    }

    public static String generateFilterCompare(Optional<Type> optionalDataType) {
        Type dataType = optionalDataType.orElseThrow(() -> new CodeGenerationException("Could not generate equals expression for empty Enumeration datatype"));
        if (dataType instanceof Scalar) {
            return "enumValue.getValue().equals(value)";
        }
        Entity entity = (Entity)dataType;
        if (entity.getProperties().isEmpty()) {
            return "enumValue.getValue().equals(value)";
        }
        return entity.getProperties().stream().filter(property -> !property.isNotInPayload()).map(property -> {
            String propertyName = StringUtils.capitalize((String)property.getName());
            return String.format("enumValue.getValue().get%s().equals(value.get%s())", propertyName, propertyName);
        }).collect(Collectors.joining(" && "));
    }

    public static String getCharacteristicJavaType(Property property, JavaCodeGenerationConfig codeGenerationConfig) {
        Supplier<RuntimeException> error = () -> new CodeGenerationException("No data type found for Property " + property.getName());
        if (AspectModelJavaUtil.hasContainerType(property)) {
            return AspectModelJavaUtil.getDataType(((Characteristic)property.getCharacteristic().orElseThrow(error)).getDataType(), codeGenerationConfig.importTracker(), codeGenerationConfig);
        }
        return property.getEffectiveCharacteristic().flatMap(Characteristic::getDataType).map(type -> {
            if (type.is(Scalar.class)) {
                return AspectModelJavaUtil.determinePropertyType(property.getEffectiveCharacteristic(), false, codeGenerationConfig);
            }
            if (type.is(Entity.class)) {
                return ((Entity)type.as(Entity.class)).getName();
            }
            throw new CodeGenerationException("Unknown Characteristic data type " + String.valueOf(type));
        }).orElseThrow(error);
    }

    public static String printStructuredValueElement(Object object) {
        if (object instanceof String) {
            return AspectModelJavaUtil.createLiteral(object.toString());
        }
        return AspectModelJavaUtil.toConstant(((Property)object).getName());
    }

    public static boolean isXmlDatatypeFactoryRequired(StructureElement element) {
        AspectStreamTraversalVisitor visitor = new AspectStreamTraversalVisitor();
        return visitor.visitStructureElement(element, null).filter(modelElement -> Scalar.class.isAssignableFrom(modelElement.getClass())).map(Scalar.class::cast).map(Type::getUrn).anyMatch(typeUrn -> typeUrn.equals(XSD.date.getURI()) || typeUrn.equals(XSD.time.getURI()) || typeUrn.equals(XSD.dateTime.getURI()) || typeUrn.equals(XSD.dateTimeStamp.getURI()) || typeUrn.equals(XSD.gYear.getURI()) || typeUrn.equals(XSD.gMonth.getURI()) || typeUrn.equals(XSD.gDay.getURI()) || typeUrn.equals(XSD.gYearMonth.getURI()) || typeUrn.equals(XSD.gMonthDay.getURI()) || typeUrn.equals(XSD.duration.getURI()) || typeUrn.equals(XSD.yearMonthDuration.getURI()) || typeUrn.equals(XSD.dayTimeDuration.getURI()));
    }

    public static boolean doesValueNeedToBeQuoted(String typeUrn) {
        return typeUrn.equals(XSD.integer.getURI()) || typeUrn.equals(XSD.xshort.getURI()) || typeUrn.equals(XSD.decimal.getURI()) || typeUrn.equals(XSD.unsignedLong.getURI()) || typeUrn.equals(XSD.positiveInteger.getURI()) || typeUrn.equals(XSD.nonNegativeInteger.getURI()) || typeUrn.equals(XSD.negativeInteger.getURI()) || typeUrn.equals(XSD.nonPositiveInteger.getURI()) || typeUrn.equals(XSD.date.getURI()) || typeUrn.equals(XSD.time.getURI()) || typeUrn.equals(XSD.dateTime.getURI()) || typeUrn.equals(XSD.dateTimeStamp.getURI()) || typeUrn.equals(XSD.gDay.getURI()) || typeUrn.equals(XSD.gMonth.getURI()) || typeUrn.equals(XSD.gYearMonth.getURI()) || typeUrn.equals(XSD.gMonthDay.getURI()) || typeUrn.equals(XSD.duration.getURI()) || typeUrn.equals(XSD.yearMonthDuration.getURI()) || typeUrn.equals(XSD.dayTimeDuration.getURI());
    }

    public static String genericClassSignature(StructureElement element) {
        List properties = element.getProperties();
        String generics = IntStream.range(0, properties.size()).filter(i -> ((Property)properties.get(i)).isAbstract()).mapToObj(i -> "T" + i + " /* type of " + ((Property)properties.get(i)).getName() + " */").collect(Collectors.joining(","));
        return generics.isEmpty() ? "" : "<" + generics + ">";
    }

    public static String generateClassName(StructureElement element, JavaCodeGenerationConfig config) {
        if (!(config.namePrefix().isBlank() && config.namePostfix().isBlank() || !element.is(StructureElement.class))) {
            return config.namePrefix() + element.getName() + config.namePostfix();
        }
        return element.getName();
    }

    public static String constructorArguments(List<Property> allProperties, JavaCodeGenerationConfig codeGenerationConfig, boolean enableJacksonAnnotations) {
        return allProperties.stream().filter(property -> !property.isAbstract()).map(property -> {
            Object declaration = "";
            if (enableJacksonAnnotations) {
                declaration = (String)declaration + "@JsonProperty( value = \"" + property.getPayloadName() + "\" ) ";
            }
            declaration = (String)declaration + AspectModelJavaUtil.getPropertyType(property, false, codeGenerationConfig) + " " + property.getPayloadName();
            return declaration;
        }).collect(Collectors.joining(", "));
    }

    public static String objectEqualsExpression(StructureElement element) {
        return element.getProperties().stream().filter(property -> !property.isAbstract()).map(property -> "Objects.equals(" + property.getPayloadName() + ", that." + property.getPayloadName() + ")").collect(Collectors.joining(" && "));
    }

    public static String objectsHashCodeExpression(StructureElement element, boolean needsLeadingComma) {
        String elementString = element.getProperties().stream().filter(property -> !property.isAbstract()).map(Property::getPayloadName).collect(Collectors.joining(", "));
        if (StringUtils.isNotBlank((CharSequence)elementString) && needsLeadingComma) {
            return ", " + elementString;
        }
        return elementString;
    }

    public static String superConstructorCallExpression(List<Property> allProperties, List<Property> elementProperties) {
        return allProperties.stream().filter(property -> !elementProperties.contains(property)).filter(property -> property.getExtends().isEmpty() && !property.isAbstract()).map(Property::getPayloadName).collect(Collectors.joining(", "));
    }

    public static String staticPropertiesExpression(StructureElement element) {
        return element.getProperties().stream().filter(property -> !property.isAbstract()).map(property -> AspectModelJavaUtil.toConstant(property.getName())).collect(Collectors.joining(", "));
    }

    public static Trait castToTrait(Characteristic characteristic) {
        return (Trait)characteristic;
    }

    public static Entity castToEntity(ComplexType complexType) {
        return (Entity)complexType;
    }

    public static ComplexType castToComplexType(StructureElement structureElement) {
        return (ComplexType)structureElement;
    }

    public static State castToState(Enumeration enumeration) {
        return (State)enumeration;
    }

    public static AbstractEntity castToAbstractEntity(ComplexType complexType) {
        return (AbstractEntity)complexType;
    }

    public static Quantifiable castToQuantifiable(Characteristic characteristic) {
        return (Quantifiable)characteristic;
    }

    public static String getterName(Property property) {
        boolean isBooleanType = !property.isOptional() && property.getDataType().filter(Type::isScalar).map(type -> XSD.xboolean.getURI().equals(type.getUrn())).orElse(false) != false;
        return (isBooleanType ? "is" : "get") + StringUtils.capitalize((String)property.getPayloadName());
    }
}

