/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.esmf.aspectmodel.java;

import jakarta.validation.constraints.Digits;
import jakarta.validation.constraints.Pattern;
import jakarta.validation.constraints.Size;
import java.util.Optional;
import org.apache.commons.text.StringEscapeUtils;
import org.eclipse.esmf.aspectmodel.java.ImportTracker;
import org.eclipse.esmf.aspectmodel.java.rangeconstraint.AnnotationExpression;
import org.eclipse.esmf.aspectmodel.java.rangeconstraint.AnnotationFactory;
import org.eclipse.esmf.aspectmodel.java.rangeconstraint.AnnotationTypeMapping;
import org.eclipse.esmf.metamodel.BoundDefinition;
import org.eclipse.esmf.metamodel.Constraint;
import org.eclipse.esmf.metamodel.ScalarValue;
import org.eclipse.esmf.metamodel.constraint.FixedPointConstraint;
import org.eclipse.esmf.metamodel.constraint.LengthConstraint;
import org.eclipse.esmf.metamodel.constraint.RangeConstraint;
import org.eclipse.esmf.metamodel.constraint.RegularExpressionConstraint;

public class ConstraintAnnotationBuilder {
    private static final String ANNOTATION_MARKING = "@";
    private static final String LEFT_BRACKET = "(";
    private static final String RIGHT_BRACKET = ")";
    private final StringBuilder constraintAnnotation = new StringBuilder(110);
    private Constraint constraintClass;
    private ImportTracker importTracker;

    public ConstraintAnnotationBuilder setConstraintClass(Constraint constraintClass) {
        this.constraintClass = constraintClass;
        return this;
    }

    public ConstraintAnnotationBuilder setImportTracker(ImportTracker importTracker) {
        this.importTracker = importTracker;
        return this;
    }

    public String build() {
        return this.createConstraintAnnotation();
    }

    private String createConstraintAnnotation() {
        this.createRegularExpressionConstraint();
        this.createRangeConstraint();
        this.createLengthConstraint();
        this.createFixedPointConstraint();
        return this.constraintAnnotation.toString();
    }

    private void createRegularExpressionConstraint() {
        if (!(this.constraintClass instanceof RegularExpressionConstraint)) {
            return;
        }
        RegularExpressionConstraint regularExpressionConstraint = (RegularExpressionConstraint)this.constraintClass;
        String value = regularExpressionConstraint.getValue();
        String escapedValue = StringEscapeUtils.escapeJava((String)value);
        this.appendStringBuilder(Pattern.class, "regexp = \"" + escapedValue + "\"");
    }

    private void createRangeConstraint() {
        if (!(this.constraintClass instanceof RangeConstraint)) {
            return;
        }
        RangeConstraint rangeConstraint = (RangeConstraint)this.constraintClass;
        Optional<Object> minValue = rangeConstraint.getMinValue().map(ScalarValue::getValue);
        Optional<Object> maxValue = rangeConstraint.getMaxValue().map(ScalarValue::getValue);
        BoundDefinition lowerBoundDefinition = rangeConstraint.getLowerBoundDefinition();
        BoundDefinition upperBoundDefinition = rangeConstraint.getUpperBoundDefinition();
        if (minValue.isPresent() || maxValue.isPresent()) {
            this.importTracker.importExplicit(BoundDefinition.class);
        }
        minValue.ifPresent(value -> {
            AnnotationExpression targetAnnotation = this.getAnnotationExpression(value, AnnotationTypeMapping.MINIMUM);
            this.importTracker.importExplicit(targetAnnotation.getTargetAnnotation());
            this.constraintAnnotation.append(targetAnnotation.apply(value, lowerBoundDefinition));
        });
        maxValue.ifPresent(value -> {
            AnnotationExpression targetAnnotation = this.getAnnotationExpression(value, AnnotationTypeMapping.MAXIMUM);
            this.importTracker.importExplicit(targetAnnotation.getTargetAnnotation());
            this.constraintAnnotation.append(targetAnnotation.apply(value, upperBoundDefinition));
        });
    }

    private AnnotationExpression getAnnotationExpression(Object value, AnnotationTypeMapping annotationTypeMapping) {
        return AnnotationFactory.getOperation(value.getClass(), annotationTypeMapping).orElseThrow(() -> new IllegalArgumentException("Invalid Annotation"));
    }

    private void createLengthConstraint() {
        if (!(this.constraintClass instanceof LengthConstraint)) {
            return;
        }
        LengthConstraint lengthConstraint = (LengthConstraint)this.constraintClass;
        Optional minValue = lengthConstraint.getMinValue();
        Optional maxValue = lengthConstraint.getMaxValue();
        StringBuilder sizeExpression = new StringBuilder(30);
        minValue.ifPresent(value -> sizeExpression.append("min = ").append(value));
        if (minValue.isPresent() && maxValue.isPresent()) {
            sizeExpression.append(",");
        }
        maxValue.ifPresent(value -> sizeExpression.append("max = ").append(value));
        this.appendStringBuilder(Size.class, sizeExpression.toString());
    }

    private void createFixedPointConstraint() {
        if (!(this.constraintClass instanceof FixedPointConstraint)) {
            return;
        }
        FixedPointConstraint fixedPointConstraint = (FixedPointConstraint)this.constraintClass;
        Integer scale = fixedPointConstraint.getScale();
        Integer integer = fixedPointConstraint.getInteger();
        StringBuilder fixedPointExpression = new StringBuilder(30);
        fixedPointExpression.append("fraction = ").append(scale);
        fixedPointExpression.append(", integer = ").append(integer);
        this.appendStringBuilder(Digits.class, fixedPointExpression);
    }

    private void appendStringBuilder(Class<?> beanAnnotation, Object expression) {
        this.importTracker.importExplicit(beanAnnotation);
        this.constraintAnnotation.append(ANNOTATION_MARKING).append(beanAnnotation.getSimpleName()).append(LEFT_BRACKET).append(expression).append(RIGHT_BRACKET).append('\n');
    }
}

