/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.esmf.aspectmodel.java;

import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;

public class ImportTracker {
    private static final String GENERICS_START = "<";
    private static final String EMPTY_STRING = "";
    private static final String COMMA_STRING = ",";
    private static final String TYPE_BRACKETS_AND_WHITESPACE = "[<>\\s]";
    private final Set<String> usedImports = new HashSet<String>();
    private final Set<String> usedStaticImports = new HashSet<String>();

    public String getRawContainerType(String parameterizedContainerType) {
        this.trackPotentiallyParameterizedType(parameterizedContainerType);
        return parameterizedContainerType.substring(0, parameterizedContainerType.indexOf(GENERICS_START));
    }

    public void trackPotentiallyParameterizedType(String potentiallyParameterizedType) {
        if (potentiallyParameterizedType.contains(GENERICS_START)) {
            List<String> types = Arrays.stream(potentiallyParameterizedType.split(GENERICS_START)).flatMap(substring -> Arrays.stream(substring.split(COMMA_STRING))).map(substring -> substring.replaceAll(TYPE_BRACKETS_AND_WHITESPACE, EMPTY_STRING)).toList();
            this.usedImports.addAll(types);
        } else {
            this.usedImports.add(potentiallyParameterizedType);
        }
    }

    public void importExplicit(Class<?> clazz) {
        this.usedImports.add(clazz.getName());
    }

    public void importExplicit(String clazz) {
        this.usedImports.add(clazz);
    }

    public void importStaticExplicit(Class<?> clazz) {
        this.usedStaticImports.add(clazz.getName());
    }

    public List<String> getUsedImports() {
        return this.usedImports.stream().filter(usedImport -> usedImport.contains(".")).collect(Collectors.toList());
    }

    public List<String> getUsedImportsWithoutJavaLang() {
        return this.getUsedImports().stream().filter(usedImport -> !usedImport.startsWith("java.lang.")).sorted().collect(Collectors.toList());
    }

    public List<String> getUsedStaticImports() {
        return this.usedStaticImports.stream().sorted().collect(Collectors.toList());
    }
}

