/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.esmf.aspectmodel.java;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.BiFunction;
import javax.xml.datatype.XMLGregorianCalendar;
import org.apache.jena.rdf.model.Resource;
import org.apache.jena.rdf.model.ResourceFactory;
import org.apache.jena.vocabulary.XSD;
import org.eclipse.esmf.aspectmodel.java.DeconstructionSet;
import org.eclipse.esmf.metamodel.datatype.SammXsdType;
import org.eclipse.esmf.metamodel.vocabulary.SammNs;

public class ValueInitializer {
    private static final Map<Resource, BiFunction<Class<?>, String, String>> INITIALIZERS;

    public boolean needInitializationToConstructor(List<DeconstructionSet> deconstructionSets) {
        return deconstructionSets.stream().flatMap(deconstructionSet -> deconstructionSet.getElementProperties().stream().map(property -> property.getDataType().map(type -> SammXsdType.getJavaTypeForMetaModelType((Resource)ResourceFactory.createResource((String)type.getUrn()))))).anyMatch(dataType -> dataType.map(type -> type == XMLGregorianCalendar.class).orElse(false));
    }

    public String apply(Resource rdfType, String valueExpression) {
        return this.apply(rdfType, SammXsdType.getJavaTypeForMetaModelType((Resource)rdfType), valueExpression);
    }

    public String apply(Resource rdfType, Class<?> javaType, String valueExpression) {
        if (rdfType.equals((Object)SammNs.SAMM.curie())) {
            return String.format("new Curie( %s )", valueExpression);
        }
        return INITIALIZERS.get(rdfType).apply(javaType, valueExpression);
    }

    static {
        BiFunction<Class, String, String> literalExpression = (type, valueExpression) -> valueExpression;
        BiFunction<Class, String, String> stringConstructor = (type, valueExpression) -> String.format("new %s( %s )", type.getSimpleName(), valueExpression);
        BiFunction<Class, String, String> create = (type, valueExpression) -> String.format("%s.create( %s )", type.getSimpleName(), valueExpression);
        BiFunction<Class, String, String> parseTypeName = (type, valueExpression) -> String.format("%s.parse%s( %s )", type.getSimpleName(), type.getSimpleName(), valueExpression);
        BiFunction<Class, String, String> valueOf = (type, valueExpression) -> String.format("%s.valueOf( %s )", type.getSimpleName(), valueExpression);
        BiFunction<Class, String, String> gregorianCalendar = (type, valueExpression) -> "_datatypeFactory.newXMLGregorianCalendar( " + valueExpression + " )";
        BiFunction<Class, String, String> duration = (type, valueExpression) -> "_datatypeFactory.newDuration( " + valueExpression + " )";
        INITIALIZERS = new HashMap();
        INITIALIZERS.put(XSD.xstring, literalExpression);
        INITIALIZERS.put(XSD.xboolean, valueOf);
        INITIALIZERS.put(XSD.decimal, stringConstructor);
        INITIALIZERS.put(XSD.integer, stringConstructor);
        INITIALIZERS.put(XSD.xdouble, valueOf);
        INITIALIZERS.put(XSD.xfloat, valueOf);
        INITIALIZERS.put(XSD.date, gregorianCalendar);
        INITIALIZERS.put(XSD.dateTime, gregorianCalendar);
        INITIALIZERS.put(XSD.dateTimeStamp, gregorianCalendar);
        INITIALIZERS.put(XSD.gYear, (type, valueExpression) -> "_datatypeFactory.newXMLGregorianCalendarDate( Integer.valueOf( " + valueExpression + " ), DatatypeConstants.FIELD_UNDEFINED, DatatypeConstants.FIELD_UNDEFINED, DatatypeConstants.FIELD_UNDEFINED )");
        INITIALIZERS.put(XSD.gMonth, (type, valueExpression) -> "_datatypeFactory.newXMLGregorianCalendarDate( DatatypeConstants.FIELD_UNDEFINED, Integer.valueOf( " + valueExpression + " ), DatatypeConstants.FIELD_UNDEFINED, DatatypeConstants.FIELD_UNDEFINED )");
        INITIALIZERS.put(XSD.gYearMonth, gregorianCalendar);
        INITIALIZERS.put(XSD.gMonthDay, (type, valueExpression) -> "_datatypeFactory.newXMLGregorianCalendarDate( DatatypeConstants.FIELD_UNDEFINED, DatatypeConstants.FIELD_UNDEFINED, Integer.valueOf( " + valueExpression + " ), DatatypeConstants.FIELD_UNDEFINED )");
        INITIALIZERS.put(XSD.gDay, gregorianCalendar);
        INITIALIZERS.put(XSD.duration, duration);
        INITIALIZERS.put(XSD.yearMonthDuration, duration);
        INITIALIZERS.put(XSD.dayTimeDuration, duration);
        INITIALIZERS.put(XSD.xbyte, parseTypeName);
        INITIALIZERS.put(XSD.xshort, parseTypeName);
        INITIALIZERS.put(XSD.xint, valueOf);
        INITIALIZERS.put(XSD.xlong, valueOf);
        INITIALIZERS.put(XSD.unsignedByte, parseTypeName);
        INITIALIZERS.put(XSD.unsignedShort, parseTypeName);
        INITIALIZERS.put(XSD.unsignedInt, valueOf);
        INITIALIZERS.put(XSD.unsignedLong, stringConstructor);
        INITIALIZERS.put(XSD.positiveInteger, stringConstructor);
        INITIALIZERS.put(XSD.nonNegativeInteger, stringConstructor);
        INITIALIZERS.put(XSD.negativeInteger, stringConstructor);
        INITIALIZERS.put(XSD.nonPositiveInteger, stringConstructor);
        INITIALIZERS.put(XSD.hexBinary, null);
        INITIALIZERS.put(XSD.base64Binary, null);
        INITIALIZERS.put(XSD.anyURI, create);
    }
}

