/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.esmf.aspectmodel.java.customconstraint;

import jakarta.validation.ConstraintValidator;
import jakarta.validation.ConstraintValidatorContext;
import javax.xml.datatype.DatatypeConfigurationException;
import javax.xml.datatype.DatatypeFactory;
import javax.xml.datatype.Duration;
import org.eclipse.esmf.aspectmodel.java.customconstraint.DurationMax;
import org.eclipse.esmf.metamodel.BoundDefinition;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DurationMaxValidator
implements ConstraintValidator<DurationMax, Duration> {
    private static final Logger LOG = LoggerFactory.getLogger(DurationMaxValidator.class);
    private Duration durationMax;
    private BoundDefinition boundDefinition;

    public void initialize(DurationMax durationMax) {
        try {
            DatatypeFactory datatypeFactory = DatatypeFactory.newInstance();
            this.durationMax = datatypeFactory.newDuration(durationMax.value());
            this.boundDefinition = durationMax.boundDefinition();
        }
        catch (DatatypeConfigurationException exception) {
            LOG.error("Could not instantiate DatatypeFactory", (Throwable)exception);
        }
    }

    public boolean isValid(Duration durationValue, ConstraintValidatorContext context) {
        if (durationValue == null) {
            return true;
        }
        return this.boundDefinition.isValid(durationValue, this.durationMax);
    }
}

