/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.esmf.aspectmodel.java.customconstraint;

import jakarta.validation.ConstraintValidator;
import jakarta.validation.ConstraintValidatorContext;
import javax.xml.datatype.DatatypeConfigurationException;
import javax.xml.datatype.DatatypeFactory;
import javax.xml.datatype.Duration;
import org.eclipse.esmf.aspectmodel.java.customconstraint.DurationMin;
import org.eclipse.esmf.metamodel.BoundDefinition;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DurationMinValidator
implements ConstraintValidator<DurationMin, Duration> {
    private static final Logger LOG = LoggerFactory.getLogger(DurationMinValidator.class);
    private Duration durationMin;
    private BoundDefinition boundDefinition;

    public void initialize(DurationMin durationMin) {
        try {
            DatatypeFactory datatypeFactory = DatatypeFactory.newInstance();
            this.durationMin = datatypeFactory.newDuration(durationMin.value());
            this.boundDefinition = durationMin.boundDefinition();
        }
        catch (DatatypeConfigurationException exception) {
            LOG.error("Could not instantiate DatatypeFactory", (Throwable)exception);
        }
    }

    public boolean isValid(Duration durationValue, ConstraintValidatorContext context) {
        if (durationValue == null) {
            return true;
        }
        return this.boundDefinition.isValid(durationValue, this.durationMin);
    }
}

