/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.esmf.aspectmodel.java.customconstraint;

import jakarta.validation.ConstraintValidator;
import jakarta.validation.ConstraintValidatorContext;
import javax.xml.datatype.DatatypeConfigurationException;
import javax.xml.datatype.DatatypeFactory;
import javax.xml.datatype.XMLGregorianCalendar;
import org.eclipse.esmf.aspectmodel.java.customconstraint.GregorianCalendarMax;
import org.eclipse.esmf.metamodel.BoundDefinition;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GregorianCalendarMaxValidator
implements ConstraintValidator<GregorianCalendarMax, XMLGregorianCalendar> {
    private static final Logger LOG = LoggerFactory.getLogger(GregorianCalendarMaxValidator.class);
    private XMLGregorianCalendar xmlGregorianCalendar;
    private BoundDefinition boundDefinition;

    public void initialize(GregorianCalendarMax gregorianCalendarMax) {
        try {
            DatatypeFactory datatypeFactory = DatatypeFactory.newInstance();
            this.xmlGregorianCalendar = datatypeFactory.newXMLGregorianCalendar(gregorianCalendarMax.value());
            this.boundDefinition = gregorianCalendarMax.boundDefinition();
        }
        catch (DatatypeConfigurationException exception) {
            LOG.error("Could not instantiate DatatypeFactory", (Throwable)exception);
        }
    }

    public boolean isValid(XMLGregorianCalendar xmlGregorianCalendarValue, ConstraintValidatorContext context) {
        if (xmlGregorianCalendarValue == null) {
            return true;
        }
        return this.boundDefinition.isValid(xmlGregorianCalendarValue, this.xmlGregorianCalendar);
    }
}

