/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.esmf.aspectmodel.java.metamodel;

import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.commons.text.StringEscapeUtils;
import org.apache.jena.rdf.model.Resource;
import org.apache.jena.rdf.model.ResourceFactory;
import org.apache.jena.vocabulary.XSD;
import org.eclipse.esmf.aspectmodel.java.AspectModelJavaUtil;
import org.eclipse.esmf.aspectmodel.java.ValueExpressionVisitor;
import org.eclipse.esmf.aspectmodel.java.ValueInitializer;
import org.eclipse.esmf.aspectmodel.java.exception.CodeGenerationException;
import org.eclipse.esmf.aspectmodel.java.metamodel.StaticCodeGenerationContext;
import org.eclipse.esmf.aspectmodel.visitor.AspectVisitor;
import org.eclipse.esmf.metamodel.AbstractEntity;
import org.eclipse.esmf.metamodel.BoundDefinition;
import org.eclipse.esmf.metamodel.Characteristic;
import org.eclipse.esmf.metamodel.CollectionValue;
import org.eclipse.esmf.metamodel.ComplexType;
import org.eclipse.esmf.metamodel.Constraint;
import org.eclipse.esmf.metamodel.Entity;
import org.eclipse.esmf.metamodel.EntityInstance;
import org.eclipse.esmf.metamodel.ModelElement;
import org.eclipse.esmf.metamodel.Property;
import org.eclipse.esmf.metamodel.QuantityKind;
import org.eclipse.esmf.metamodel.QuantityKinds;
import org.eclipse.esmf.metamodel.Scalar;
import org.eclipse.esmf.metamodel.ScalarValue;
import org.eclipse.esmf.metamodel.Type;
import org.eclipse.esmf.metamodel.Unit;
import org.eclipse.esmf.metamodel.Units;
import org.eclipse.esmf.metamodel.Value;
import org.eclipse.esmf.metamodel.characteristic.Code;
import org.eclipse.esmf.metamodel.characteristic.Collection;
import org.eclipse.esmf.metamodel.characteristic.Duration;
import org.eclipse.esmf.metamodel.characteristic.Enumeration;
import org.eclipse.esmf.metamodel.characteristic.Measurement;
import org.eclipse.esmf.metamodel.characteristic.Quantifiable;
import org.eclipse.esmf.metamodel.characteristic.SingleEntity;
import org.eclipse.esmf.metamodel.characteristic.State;
import org.eclipse.esmf.metamodel.characteristic.StructuredValue;
import org.eclipse.esmf.metamodel.characteristic.Trait;
import org.eclipse.esmf.metamodel.characteristic.impl.DefaultCode;
import org.eclipse.esmf.metamodel.characteristic.impl.DefaultCollection;
import org.eclipse.esmf.metamodel.characteristic.impl.DefaultEnumeration;
import org.eclipse.esmf.metamodel.characteristic.impl.DefaultList;
import org.eclipse.esmf.metamodel.characteristic.impl.DefaultSet;
import org.eclipse.esmf.metamodel.characteristic.impl.DefaultSingleEntity;
import org.eclipse.esmf.metamodel.characteristic.impl.DefaultSortedSet;
import org.eclipse.esmf.metamodel.characteristic.impl.DefaultState;
import org.eclipse.esmf.metamodel.characteristic.impl.DefaultStructuredValue;
import org.eclipse.esmf.metamodel.characteristic.impl.DefaultTrait;
import org.eclipse.esmf.metamodel.constraint.EncodingConstraint;
import org.eclipse.esmf.metamodel.constraint.FixedPointConstraint;
import org.eclipse.esmf.metamodel.constraint.LanguageConstraint;
import org.eclipse.esmf.metamodel.constraint.LengthConstraint;
import org.eclipse.esmf.metamodel.constraint.LocaleConstraint;
import org.eclipse.esmf.metamodel.constraint.RangeConstraint;
import org.eclipse.esmf.metamodel.constraint.RegularExpressionConstraint;
import org.eclipse.esmf.metamodel.constraint.impl.DefaultEncodingConstraint;
import org.eclipse.esmf.metamodel.constraint.impl.DefaultFixedPointConstraint;
import org.eclipse.esmf.metamodel.constraint.impl.DefaultLanguageConstraint;
import org.eclipse.esmf.metamodel.constraint.impl.DefaultLengthConstraint;
import org.eclipse.esmf.metamodel.constraint.impl.DefaultLocaleConstraint;
import org.eclipse.esmf.metamodel.constraint.impl.DefaultRangeConstraint;
import org.eclipse.esmf.metamodel.constraint.impl.DefaultRegularExpressionConstraint;
import org.eclipse.esmf.metamodel.impl.DefaultAbstractEntity;
import org.eclipse.esmf.metamodel.impl.DefaultCharacteristic;
import org.eclipse.esmf.metamodel.impl.DefaultCollectionValue;
import org.eclipse.esmf.metamodel.impl.DefaultEntity;
import org.eclipse.esmf.metamodel.impl.DefaultEntityInstance;
import org.eclipse.esmf.metamodel.impl.DefaultQuantityKind;
import org.eclipse.esmf.metamodel.impl.DefaultScalar;
import org.eclipse.esmf.metamodel.impl.DefaultScalarValue;
import org.eclipse.esmf.metamodel.impl.DefaultUnit;

public class StaticMetaModelVisitor
implements AspectVisitor<String, StaticCodeGenerationContext> {
    private final ValueExpressionVisitor valueExpressionVisitor = new ValueExpressionVisitor();
    private final ValueInitializer valueInitializer = new ValueInitializer();
    private final Supplier<CodeGenerationException> noTypeException = () -> new CodeGenerationException("Characteristic is missing its dataType");

    public String visitBase(ModelElement modelElement, StaticCodeGenerationContext context) {
        throw new UnsupportedOperationException();
    }

    public String visitScalarValue(ScalarValue value, StaticCodeGenerationContext context) {
        context.getCodeGenerationConfig().importTracker().importExplicit(DefaultScalarValue.class);
        ValueExpressionVisitor.Context valueContext = new ValueExpressionVisitor.Context(context.getCodeGenerationConfig(), false);
        String metaModelAttributes = !value.getSee().isEmpty() && !value.getPreferredNames().isEmpty() ? this.getMetaModelBaseAttributes((ModelElement)value, context) : "MetaModelBaseAttributes.builder().build()";
        return "new DefaultScalarValue(" + metaModelAttributes + "," + (String)value.accept((AspectVisitor)this.valueExpressionVisitor, (Object)valueContext) + "," + (String)value.getType().accept((AspectVisitor)this, (Object)context) + ")";
    }

    public String visitCollectionValue(CollectionValue collection, StaticCodeGenerationContext context) {
        Class<?> collectionClass = collection.getValues().getClass();
        context.getCodeGenerationConfig().importTracker().importExplicit(DefaultCollectionValue.class);
        context.getCodeGenerationConfig().importTracker().importExplicit(collectionClass);
        StringBuilder result = new StringBuilder();
        result.append("new DefaultCollectionValue(");
        result.append("new ");
        result.append(collectionClass.getSimpleName());
        result.append("<>() {{");
        collection.getValues().forEach(value -> {
            result.append("add(");
            result.append((String)value.accept((AspectVisitor)this, (Object)context));
            result.append(");");
        });
        result.append("}}");
        result.append(",");
        result.append(CollectionValue.CollectionType.class.getName().replace("$", ".")).append(".");
        result.append(collection.getCollectionType()).append(",");
        result.append((String)collection.getType().accept((AspectVisitor)this, (Object)context));
        result.append(")");
        return result.toString();
    }

    public String visitEntityInstance(EntityInstance instance, StaticCodeGenerationContext context) {
        context.getCodeGenerationConfig().importTracker().importExplicit(DefaultEntityInstance.class);
        context.getCodeGenerationConfig().importTracker().importExplicit(Map.class);
        context.getCodeGenerationConfig().importTracker().importExplicit(HashMap.class);
        context.getCodeGenerationConfig().importTracker().importExplicit(Property.class);
        context.getCodeGenerationConfig().importTracker().importExplicit(Value.class);
        Entity entity = instance.getEntityType();
        StringBuilder builder = new StringBuilder();
        builder.append("new DefaultEntityInstance(");
        builder.append(this.getMetaModelBaseAttributes((ModelElement)instance, context));
        builder.append(",");
        builder.append("new HashMap<Property, Value>() {{");
        for (Property property : instance.getEntityType().getProperties()) {
            Value instancePropertyValue = (Value)instance.getAssertions().get(property);
            if (instancePropertyValue == null) continue;
            String className = "Meta" + entity.getName();
            String staticPropertyField = AspectModelJavaUtil.toConstant(property.getName());
            builder.append("put(");
            builder.append(className);
            builder.append(".");
            builder.append(staticPropertyField);
            builder.append(",");
            builder.append((String)instancePropertyValue.accept((AspectVisitor)this, (Object)context));
            builder.append(");");
        }
        builder.append("}},");
        builder.append((String)instance.getEntityType().accept((AspectVisitor)this, (Object)context));
        builder.append(")");
        return builder.toString();
    }

    public String visitSingleEntity(SingleEntity singleEntity, StaticCodeGenerationContext context) {
        context.getCodeGenerationConfig().importTracker().importExplicit(DefaultSingleEntity.class);
        return "new DefaultSingleEntity(" + this.getMetaModelBaseAttributes((ModelElement)singleEntity, context) + ", " + (String)((Type)singleEntity.getDataType().orElseThrow(this.noTypeException)).accept((AspectVisitor)this, (Object)context) + ")";
    }

    public String visitCollection(Collection collection, StaticCodeGenerationContext context) {
        Class<DefaultList> implementationClass = switch (collection.getCollectionType()) {
            case CollectionValue.CollectionType.LIST -> DefaultList.class;
            case CollectionValue.CollectionType.SET -> DefaultSet.class;
            case CollectionValue.CollectionType.SORTEDSET -> DefaultSortedSet.class;
            default -> DefaultCollection.class;
        };
        context.getCodeGenerationConfig().importTracker().importExplicit(implementationClass);
        String optionalType = collection.getDataType().map(type -> (String)type.accept((AspectVisitor)this, (Object)context)).map(type -> "Optional.of(" + type + ")").orElse("Optional.empty()");
        String optionalElementCharacteristic = collection.getElementCharacteristic().map(characteristic -> (String)characteristic.accept((AspectVisitor)this, (Object)context)).map(characteristic -> "Optional.of(" + characteristic + ")").orElse("Optional.empty()");
        return "new " + implementationClass.getSimpleName() + "(" + this.getMetaModelBaseAttributes((ModelElement)collection, context) + "," + optionalType + "," + optionalElementCharacteristic + ")";
    }

    public String visitCode(Code code, StaticCodeGenerationContext context) {
        context.getCodeGenerationConfig().importTracker().importExplicit(DefaultCode.class);
        return "new DefaultCode(" + this.getMetaModelBaseAttributes((ModelElement)code, context) + "," + (String)((Type)code.getDataType().orElseThrow(this.noTypeException)).accept((AspectVisitor)this, (Object)context) + ")";
    }

    public String visitDuration(Duration duration, StaticCodeGenerationContext context) {
        return this.generateForQuantifiable(duration, context);
    }

    public String visitMeasurement(Measurement measurement, StaticCodeGenerationContext context) {
        return this.generateForQuantifiable(measurement, context);
    }

    public String visitQuantifiable(Quantifiable quantifiable, StaticCodeGenerationContext context) {
        return this.generateForQuantifiable(quantifiable, context);
    }

    private <T extends Quantifiable> String generateForQuantifiable(T quantifiable, StaticCodeGenerationContext context) {
        context.getCodeGenerationConfig().importTracker().importExplicit(quantifiable.getClass());
        context.getCodeGenerationConfig().importTracker().importExplicit(Units.class);
        return "new " + quantifiable.getClass().getSimpleName() + "(" + this.getMetaModelBaseAttributes((ModelElement)quantifiable, context) + "," + (String)((Type)quantifiable.getDataType().orElseThrow(this.noTypeException)).accept((AspectVisitor)this, (Object)context) + "," + quantifiable.getUnit().map(unit -> (String)unit.accept((AspectVisitor)this, (Object)context)).orElse("Optional.empty()") + ")";
    }

    private String optionalString(Optional<String> optionalString) {
        return optionalString.map(value -> "Optional.of(\"" + value + "\")").orElse("Optional.empty()");
    }

    public String visitUnit(Unit unit, StaticCodeGenerationContext context) {
        Optional unitFromCatalog = Units.fromName((String)unit.getName());
        if (unitFromCatalog.isPresent()) {
            context.getCodeGenerationConfig().importTracker().importExplicit(Units.class);
            return "Units.fromName(\"" + unit.getName() + "\")";
        }
        context.getCodeGenerationConfig().importTracker().importExplicit(DefaultUnit.class);
        context.getCodeGenerationConfig().importTracker().importExplicit(HashSet.class);
        context.getCodeGenerationConfig().importTracker().importExplicit(Optional.class);
        return "Optional.of(new DefaultUnit(" + this.getMetaModelBaseAttributes((ModelElement)unit, context) + "," + this.optionalString(unit.getSymbol()) + "," + this.optionalString(unit.getCode()) + "," + this.optionalString(unit.getReferenceUnit()) + "," + this.optionalString(unit.getConversionFactor()) + ",new HashSet<>(){{" + unit.getQuantityKinds().stream().map(quantityKind -> (String)quantityKind.accept((AspectVisitor)this, (Object)context)).map(quantityKindInitializer -> String.format("add(%s);", quantityKindInitializer)).collect(Collectors.joining()) + "}}))";
    }

    public String visitQuantityKind(QuantityKind quantityKind, StaticCodeGenerationContext context) {
        if (QuantityKinds.fromName((String)quantityKind.getName()).isPresent()) {
            context.getCodeGenerationConfig().importTracker().importExplicit(QuantityKinds.class);
            return "QuantityKinds." + AspectModelJavaUtil.toConstant(quantityKind.getName());
        }
        context.getCodeGenerationConfig().importTracker().importExplicit(DefaultQuantityKind.class);
        return "new DefaultQuantityKind(" + this.getMetaModelBaseAttributes((ModelElement)quantityKind, context) + ",\"" + StringEscapeUtils.escapeJava((String)quantityKind.getLabel()) + "\")";
    }

    public String visitState(State state, StaticCodeGenerationContext context) {
        context.getCodeGenerationConfig().importTracker().importExplicit(DefaultState.class);
        context.getCodeGenerationConfig().importTracker().importExplicit(ArrayList.class);
        context.getCodeGenerationConfig().importTracker().importExplicit(Value.class);
        return "new DefaultState(" + this.getMetaModelBaseAttributes((ModelElement)state, context) + "," + (String)((Type)state.getDataType().orElseThrow(this.noTypeException)).accept((AspectVisitor)this, (Object)context) + ",new ArrayList<Value>(){{" + state.getValues().stream().sorted().map(value -> String.format("add(%s);", value.accept((AspectVisitor)this, (Object)context))).collect(Collectors.joining()) + "}}," + (String)state.getDefaultValue().accept((AspectVisitor)this, (Object)context) + ")";
    }

    public String visitEnumeration(Enumeration enumeration, StaticCodeGenerationContext context) {
        context.getCodeGenerationConfig().importTracker().importExplicit(DefaultEnumeration.class);
        context.getCodeGenerationConfig().importTracker().importExplicit(ArrayList.class);
        context.getCodeGenerationConfig().importTracker().importExplicit(Value.class);
        return "new DefaultEnumeration(" + this.getMetaModelBaseAttributes((ModelElement)enumeration, context) + "," + (String)((Type)enumeration.getDataType().orElseThrow(this.noTypeException)).accept((AspectVisitor)this, (Object)context) + ",new ArrayList<Value>(){{" + enumeration.getValues().stream().sorted().map(value -> String.format("add(%s);", value.accept((AspectVisitor)this, (Object)context))).collect(Collectors.joining()) + "}})";
    }

    public String visitStructuredValue(StructuredValue structuredValue, StaticCodeGenerationContext context) {
        context.getCodeGenerationConfig().importTracker().importExplicit(DefaultStructuredValue.class);
        context.getCodeGenerationConfig().importTracker().importExplicit(ArrayList.class);
        return "new DefaultStructuredValue(" + this.getMetaModelBaseAttributes((ModelElement)structuredValue, context) + "," + (String)((Type)structuredValue.getDataType().orElseThrow(this.noTypeException)).accept((AspectVisitor)this, (Object)context) + "," + AspectModelJavaUtil.createLiteral(structuredValue.getDeconstructionRule()) + ",new ArrayList<Object>(){{" + ((Stream)structuredValue.getElements().stream().sequential()).map(element -> String.format("add(%s);", AspectModelJavaUtil.printStructuredValueElement(element))).collect(Collectors.joining()) + "}})";
    }

    public String visitTrait(Trait trait, StaticCodeGenerationContext context) {
        context.getCodeGenerationConfig().importTracker().importExplicit(DefaultTrait.class);
        context.getCodeGenerationConfig().importTracker().importExplicit(ArrayList.class);
        return "new DefaultTrait(" + this.getMetaModelBaseAttributes((ModelElement)trait, context) + "," + (String)trait.getBaseCharacteristic().accept((AspectVisitor)this, (Object)context) + ",new ArrayList<Constraint>(){{" + trait.getConstraints().stream().sorted().map(constraint -> String.format("add(%s);", constraint.accept((AspectVisitor)this, (Object)context.withCurrentCharacteristic((Characteristic)trait)))).collect(Collectors.joining()) + "}})";
    }

    public String visitCharacteristic(Characteristic characteristic, StaticCodeGenerationContext context) {
        context.getCodeGenerationConfig().importTracker().importExplicit(DefaultCharacteristic.class);
        return "new DefaultCharacteristic(" + this.getMetaModelBaseAttributes((ModelElement)characteristic, context) + "," + characteristic.getDataType().map(type -> "Optional.of(" + (String)type.accept((AspectVisitor)this, (Object)context) + ")").orElse("Optional.empty()") + ")";
    }

    public String visitLengthConstraint(LengthConstraint lengthConstraint, StaticCodeGenerationContext context) {
        context.getCodeGenerationConfig().importTracker().importExplicit(DefaultLengthConstraint.class);
        DefaultScalar nonNegativeInteger = new DefaultScalar(XSD.nonNegativeInteger.getURI());
        return "new DefaultLengthConstraint(" + this.getMetaModelBaseAttributes((ModelElement)lengthConstraint, context) + "," + this.getOptionalStaticDeclarationValue((Type)nonNegativeInteger, lengthConstraint.getMinValue(), context) + "," + this.getOptionalStaticDeclarationValue((Type)nonNegativeInteger, lengthConstraint.getMaxValue(), context) + ")";
    }

    public String visitRangeConstraint(RangeConstraint rangeConstraint, StaticCodeGenerationContext context) {
        context.getCodeGenerationConfig().importTracker().importExplicit(DefaultRangeConstraint.class);
        context.getCodeGenerationConfig().importTracker().importExplicit(BoundDefinition.class);
        Type characteristicType = (Type)context.getCurrentCharacteristic().getDataType().orElseThrow(this.noTypeException);
        return "new DefaultRangeConstraint(" + this.getMetaModelBaseAttributes((ModelElement)rangeConstraint, context) + "," + this.getOptionalStaticDeclarationValue(characteristicType, rangeConstraint.getMinValue(), context) + "," + this.getOptionalStaticDeclarationValue(characteristicType, rangeConstraint.getMaxValue(), context) + ",BoundDefinition." + rangeConstraint.getLowerBoundDefinition().name() + ",BoundDefinition." + rangeConstraint.getUpperBoundDefinition().name() + ")";
    }

    public String visitRegularExpressionConstraint(RegularExpressionConstraint regularExpressionConstraint, StaticCodeGenerationContext context) {
        context.getCodeGenerationConfig().importTracker().importExplicit(DefaultRegularExpressionConstraint.class);
        return "new DefaultRegularExpressionConstraint(" + this.getMetaModelBaseAttributes((ModelElement)regularExpressionConstraint, context) + "," + AspectModelJavaUtil.createLiteral(regularExpressionConstraint.getValue()) + ")";
    }

    public String visitEncodingConstraint(EncodingConstraint encodingConstraint, StaticCodeGenerationContext context) {
        context.getCodeGenerationConfig().importTracker().importExplicit(DefaultEncodingConstraint.class);
        context.getCodeGenerationConfig().importTracker().importExplicit(Charset.class);
        return "new DefaultEncodingConstraint(" + this.getMetaModelBaseAttributes((ModelElement)encodingConstraint, context) + ",Charset.forName(\"" + String.valueOf(encodingConstraint.getValue()) + "\"))";
    }

    public String visitLanguageConstraint(LanguageConstraint languageConstraint, StaticCodeGenerationContext context) {
        context.getCodeGenerationConfig().importTracker().importExplicit(DefaultLanguageConstraint.class);
        context.getCodeGenerationConfig().importTracker().importExplicit(Locale.class);
        return "new DefaultLanguageConstraint(" + this.getMetaModelBaseAttributes((ModelElement)languageConstraint, context) + ",Locale.forLanguageTag(\"" + languageConstraint.getLanguageCode().toLanguageTag() + "\"))";
    }

    public String visitLocaleConstraint(LocaleConstraint localeConstraint, StaticCodeGenerationContext context) {
        context.getCodeGenerationConfig().importTracker().importExplicit(DefaultLocaleConstraint.class);
        context.getCodeGenerationConfig().importTracker().importExplicit(Locale.class);
        return "new DefaultLanguageConstraint(" + this.getMetaModelBaseAttributes((ModelElement)localeConstraint, context) + ",Locale.forLanguageTag(\"" + localeConstraint.getLocaleCode().toLanguageTag() + "\"))";
    }

    public String visitFixedPointConstraint(FixedPointConstraint fixedPointConstraint, StaticCodeGenerationContext context) {
        context.getCodeGenerationConfig().importTracker().importExplicit(DefaultFixedPointConstraint.class);
        return "new DefaultFixedPointConstraint(" + this.getMetaModelBaseAttributes((ModelElement)fixedPointConstraint, context) + "," + fixedPointConstraint.getScale() + "," + fixedPointConstraint.getInteger() + ")";
    }

    public String visitConstraint(Constraint constraint, StaticCodeGenerationContext context) {
        throw new UnsupportedOperationException("Could not generate code for unknown constraint: " + constraint.getName());
    }

    public String visitEntity(Entity entity, StaticCodeGenerationContext context) {
        context.getCodeGenerationConfig().importTracker().importExplicit(DefaultEntity.class);
        return "DefaultEntity.createDefaultEntity(" + this.getMetaModelBaseAttributes((ModelElement)entity, context) + ",Meta" + entity.getName() + ".INSTANCE.getProperties()," + this.extendsComplexType((ComplexType)entity, context) + ")";
    }

    public String visitAbstractEntity(AbstractEntity abstractEntity, StaticCodeGenerationContext context) {
        context.getCodeGenerationConfig().importTracker().importExplicit(DefaultAbstractEntity.class);
        return "DefaultAbstractEntity.createDefaultAbstractEntity(" + this.getMetaModelBaseAttributes((ModelElement)abstractEntity, context) + ",Meta" + abstractEntity.getName() + ".INSTANCE.getProperties()," + this.extendsComplexType((ComplexType)abstractEntity, context) + ",List.of(" + abstractEntity.getExtendingElements().stream().sorted().map(extendingElement -> "AspectModelUrn.fromUrn(\"" + extendingElement.getUrn() + "\")").collect(Collectors.joining(",")) + "))";
    }

    public String visitScalar(Scalar scalar, StaticCodeGenerationContext context) {
        context.getCodeGenerationConfig().importTracker().importExplicit(DefaultScalar.class);
        return "new DefaultScalar(\"" + scalar.getUrn() + "\" )";
    }

    private String extendsComplexType(ComplexType complexType, StaticCodeGenerationContext context) {
        if (complexType.getExtends().isEmpty()) {
            return "Optional.empty()";
        }
        ComplexType type = (ComplexType)complexType.getExtends().get();
        if (type.is(Entity.class)) {
            Entity entity = (Entity)type.as(Entity.class);
            context.getCodeGenerationConfig().importTracker().importExplicit(DefaultEntity.class);
            return "Optional.of(DefaultEntity.createDefaultEntity(" + this.getMetaModelBaseAttributes((ModelElement)complexType, context) + ",Meta" + entity.getName() + ".INSTANCE.getProperties()," + this.extendsComplexType((ComplexType)entity, context) + "))";
        }
        AbstractEntity abstractEntity = (AbstractEntity)type.as(AbstractEntity.class);
        context.getCodeGenerationConfig().importTracker().importExplicit(DefaultAbstractEntity.class);
        return "Optional.of(DefaultAbstractEntity.createDefaultAbstractEntity(" + this.getMetaModelBaseAttributes((ModelElement)abstractEntity, context) + ",Meta" + abstractEntity.getName() + ".INSTANCE.getProperties()," + this.extendsComplexType((ComplexType)abstractEntity, context) + ",List.of(" + abstractEntity.getExtendingElements().stream().sorted().map(extendingElement -> "AspectModelUrn.fromUrn( \"" + extendingElement.getUrn() + "\" )").collect(Collectors.joining(",")) + ")))";
    }

    private <T> String getOptionalStaticDeclarationValue(Type type, Optional<T> optionalValue, StaticCodeGenerationContext context) {
        if (optionalValue.isEmpty()) {
            return "Optional.empty()";
        }
        T t = optionalValue.get();
        if (t instanceof ScalarValue) {
            ScalarValue scalarValue = (ScalarValue)t;
            return "Optional.of(" + (String)scalarValue.accept((AspectVisitor)this, (Object)context) + ")";
        }
        context.getCodeGenerationConfig().importTracker().importExplicit(AspectModelJavaUtil.getDataTypeClass(type));
        Resource xsdType = ResourceFactory.createResource((String)type.getUrn());
        Object valueExpression = optionalValue.get().toString();
        if (type.getUrn().endsWith("#float")) {
            valueExpression = (String)valueExpression + "f";
        }
        valueExpression = AspectModelJavaUtil.doesValueNeedToBeQuoted(type.getUrn()) ? "\"" + (String)valueExpression + "\"" : StringEscapeUtils.escapeJava((String)valueExpression);
        return "Optional.of(" + this.valueInitializer.apply(xsdType, (String)valueExpression) + ")";
    }

    public String exampleValue(Property property, StaticCodeGenerationContext context) {
        return property.getExampleValue().map(exampleValue -> {
            if (exampleValue instanceof ScalarValue) {
                ScalarValue scalarValue = exampleValue;
                return "Optional.of(" + this.visitScalarValue(scalarValue, context) + ")";
            }
            if (exampleValue instanceof Value) {
                ScalarValue value = exampleValue;
                return "Optional.of(" + (String)this.visitValue((Value)value, context) + ")";
            }
            throw new IllegalArgumentException("Unexpected exampleValue type: " + String.valueOf(exampleValue.getClass()));
        }).orElse("Optional.empty()");
    }

    public String metaModelBaseAttributes(Property property, StaticCodeGenerationContext context) {
        return this.getMetaModelBaseAttributes((ModelElement)property, context);
    }

    public String getMetaModelBaseAttributes(ModelElement element, StaticCodeGenerationContext context) {
        StringBuilder builder = new StringBuilder();
        builder.append("MetaModelBaseAttributes.builder()");
        if (element.isAnonymous()) {
            builder.append(".isAnonymous()");
        } else {
            builder.append(".withUrn(");
            builder.append(this.elementUrn(element, context));
            builder.append(")");
        }
        element.getPreferredNames().stream().sorted().forEach(preferredName -> {
            builder.append(".withPreferredName(Locale.forLanguageTag(\"").append(preferredName.getLanguageTag().toLanguageTag()).append("\"),");
            builder.append(AspectModelJavaUtil.createLiteral(preferredName.getValue())).append(")");
        });
        element.getDescriptions().stream().sorted().forEach(description -> {
            builder.append(".withDescription(Locale.forLanguageTag(\"").append(description.getLanguageTag().toLanguageTag()).append("\"),");
            builder.append(AspectModelJavaUtil.createLiteral(description.getValue())).append(")");
        });
        element.getSee().stream().sorted().forEach(see -> builder.append(".withSee(").append(AspectModelJavaUtil.createLiteral(see)).append(")"));
        builder.append(".build()");
        return builder.toString();
    }

    public String elementUrn(ModelElement element, StaticCodeGenerationContext context) {
        if (element.urn().toString().startsWith(context.getModelUrnPrefix())) {
            return "AspectModelUrn.fromUrn( NAMESPACE + \"" + element.getName() + "\" )";
        }
        if (element.urn().toString().startsWith(context.getCharacteristicBaseUrn())) {
            return "AspectModelUrn.fromUrn( CHARACTERISTIC_NAMESPACE + \"#" + element.getName() + "\" )";
        }
        return "AspectModelUrn.fromUrn( \"" + String.valueOf(element.urn()) + "\" )";
    }
}

