/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.esmf.aspectmodel.java.pojo;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonFormat;
import com.fasterxml.jackson.annotation.JsonValue;
import com.google.common.collect.ImmutableMap;
import java.time.Year;
import java.util.Arrays;
import java.util.Map;
import java.util.Optional;
import java.util.Properties;
import org.eclipse.esmf.aspectmodel.generator.TemplateEngine;
import org.eclipse.esmf.aspectmodel.java.AspectModelJavaUtil;
import org.eclipse.esmf.aspectmodel.java.ImportTracker;
import org.eclipse.esmf.aspectmodel.java.JavaArtifact;
import org.eclipse.esmf.aspectmodel.java.JavaCodeGenerationConfig;
import org.eclipse.esmf.aspectmodel.java.exception.CodeGenerationException;
import org.eclipse.esmf.aspectmodel.java.exception.EnumAttributeNotFoundException;
import org.eclipse.esmf.aspectmodel.java.pojo.JavaArtifactGenerator;
import org.eclipse.esmf.metamodel.Entity;
import org.eclipse.esmf.metamodel.Scalar;
import org.eclipse.esmf.metamodel.characteristic.Enumeration;
import org.eclipse.esmf.metamodel.characteristic.State;
import org.jboss.forge.roaster.Roaster;

public class EnumerationJavaArtifactGenerator<E extends Enumeration>
implements JavaArtifactGenerator<E> {
    public JavaArtifact apply(E element, JavaCodeGenerationConfig config) {
        ImportTracker importTracker = config.importTracker();
        importTracker.importExplicit(EnumAttributeNotFoundException.class);
        ImmutableMap context = ImmutableMap.builder().put((Object)"Arrays", Arrays.class).put((Object)"className", (Object)element.getName()).put((Object)"codeGenerationConfig", (Object)config).put((Object)"currentYear", (Object)Year.now()).put((Object)"dataType", (Object)AspectModelJavaUtil.getDataType(element.getDataType(), config.importTracker(), config)).put((Object)"Entity", Entity.class).put((Object)"enumeration", element).put((Object)"importTracker", (Object)importTracker).put((Object)"JsonValue", JsonValue.class).put((Object)"JsonCreator", JsonCreator.class).put((Object)"JsonFormat", JsonFormat.class).put((Object)"Optional", Optional.class).put((Object)"Scalar", Scalar.class).put((Object)"State", State.class).put((Object)"util", AspectModelJavaUtil.class).build();
        try {
            Properties engineConfiguration = new Properties();
            if (config.executeLibraryMacros()) {
                engineConfiguration.put("velocimacro.library.path", config.templateLibFile().getName());
                engineConfiguration.put("resource.loader.file.path", config.templateLibFile().getParent());
            }
            String generatedSource = new TemplateEngine((Map)context, engineConfiguration).apply("java-enumeration");
            return new JavaArtifact(Roaster.format((String)generatedSource), element.getName(), config.packageName());
        }
        catch (Exception e) {
            throw new CodeGenerationException(e);
        }
    }
}

