/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.esmf.aspectmodel.java.rangeconstraint;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.EnumMap;
import java.util.Map;
import java.util.Optional;
import javax.xml.datatype.Duration;
import javax.xml.datatype.XMLGregorianCalendar;
import org.eclipse.esmf.aspectmodel.java.rangeconstraint.AnnotationExpression;
import org.eclipse.esmf.aspectmodel.java.rangeconstraint.AnnotationTypeMapping;
import org.eclipse.esmf.aspectmodel.java.rangeconstraint.BigDecimalAnnotation;
import org.eclipse.esmf.aspectmodel.java.rangeconstraint.BigIntegerAnnotation;
import org.eclipse.esmf.aspectmodel.java.rangeconstraint.DateTimeAnnotation;
import org.eclipse.esmf.aspectmodel.java.rangeconstraint.DoubleAnnotation;
import org.eclipse.esmf.aspectmodel.java.rangeconstraint.DurationAnnotation;
import org.eclipse.esmf.aspectmodel.java.rangeconstraint.FloatAnnotation;
import org.eclipse.esmf.aspectmodel.java.rangeconstraint.IntegerAnnotation;
import org.eclipse.esmf.aspectmodel.java.rangeconstraint.LongAnnotation;
import org.eclipse.esmf.aspectmodel.java.rangeconstraint.ShortAnnotation;

public class AnnotationFactory {
    static final Map<OperationKeys, AnnotationExpression> OPERATION_MAP = new EnumMap<OperationKeys, AnnotationExpression>(OperationKeys.class);

    public static Optional<AnnotationExpression> getOperation(Class<?> clazz, AnnotationTypeMapping annotationTypeMapping) {
        return Optional.ofNullable(OPERATION_MAP.get((Object)OperationKeys.getByClassAndBound(clazz, annotationTypeMapping)));
    }

    static {
        OPERATION_MAP.put(OperationKeys.FLOAT_MINIMUM, new FloatAnnotation(AnnotationTypeMapping.MINIMUM.getAnnotationType(Float.class)));
        OPERATION_MAP.put(OperationKeys.FLOAT_MAXIMUM, new FloatAnnotation(AnnotationTypeMapping.MAXIMUM.getAnnotationType(Float.class)));
        OPERATION_MAP.put(OperationKeys.DOUBLE_MINIMUM, new DoubleAnnotation(AnnotationTypeMapping.MINIMUM.getAnnotationType(Double.class)));
        OPERATION_MAP.put(OperationKeys.DOUBLE_MAXIMUM, new DoubleAnnotation(AnnotationTypeMapping.MAXIMUM.getAnnotationType(Double.class)));
        OPERATION_MAP.put(OperationKeys.BIGINTEGER_MINIMUM, new BigIntegerAnnotation(AnnotationTypeMapping.MINIMUM.getAnnotationType(BigInteger.class)));
        OPERATION_MAP.put(OperationKeys.BIGINTEGER_MAXIMUM, new BigIntegerAnnotation(AnnotationTypeMapping.MAXIMUM.getAnnotationType(BigInteger.class)));
        OPERATION_MAP.put(OperationKeys.BIGDECIMAL_MINIMUM, new BigDecimalAnnotation(AnnotationTypeMapping.MINIMUM.getAnnotationType(BigDecimal.class)));
        OPERATION_MAP.put(OperationKeys.BIGDECIMAL_MAXIMUM, new BigDecimalAnnotation(AnnotationTypeMapping.MAXIMUM.getAnnotationType(BigDecimal.class)));
        OPERATION_MAP.put(OperationKeys.INTEGER_MINIMUM, new IntegerAnnotation(AnnotationTypeMapping.MINIMUM.getAnnotationType(Integer.class)));
        OPERATION_MAP.put(OperationKeys.INTEGER_MAXIMUM, new IntegerAnnotation(AnnotationTypeMapping.MAXIMUM.getAnnotationType(Integer.class)));
        OPERATION_MAP.put(OperationKeys.SHORT_MINIMUM, new ShortAnnotation(AnnotationTypeMapping.MINIMUM.getAnnotationType(Short.class)));
        OPERATION_MAP.put(OperationKeys.SHORT_MAXIMUM, new ShortAnnotation(AnnotationTypeMapping.MAXIMUM.getAnnotationType(Short.class)));
        OPERATION_MAP.put(OperationKeys.LONG_MINIMUM, new LongAnnotation(AnnotationTypeMapping.MINIMUM.getAnnotationType(Long.class)));
        OPERATION_MAP.put(OperationKeys.LONG_MAXIMUM, new LongAnnotation(AnnotationTypeMapping.MAXIMUM.getAnnotationType(Long.class)));
        OPERATION_MAP.put(OperationKeys.DURATIONIMPL_MINIMUM, new DurationAnnotation(AnnotationTypeMapping.MINIMUM.getAnnotationType(Duration.class)));
        OPERATION_MAP.put(OperationKeys.DURATIONIMPL_MAXIMUM, new DurationAnnotation(AnnotationTypeMapping.MAXIMUM.getAnnotationType(Duration.class)));
        OPERATION_MAP.put(OperationKeys.DURATIONYEARMONTHIMPL_MINIMUM, new DurationAnnotation(AnnotationTypeMapping.MINIMUM.getAnnotationType(Duration.class)));
        OPERATION_MAP.put(OperationKeys.DURATIONYEARMONTHIMPL_MAXIMUM, new DurationAnnotation(AnnotationTypeMapping.MAXIMUM.getAnnotationType(Duration.class)));
        OPERATION_MAP.put(OperationKeys.DURATIONDAYTIMEIMPL_MINIMUM, new DurationAnnotation(AnnotationTypeMapping.MINIMUM.getAnnotationType(Duration.class)));
        OPERATION_MAP.put(OperationKeys.DURATIONDAYTIMEIMPL_MAXIMUM, new DurationAnnotation(AnnotationTypeMapping.MAXIMUM.getAnnotationType(Duration.class)));
        OPERATION_MAP.put(OperationKeys.XMLGREGORIANCALENDARIMPL_MINIMUM, new DateTimeAnnotation(AnnotationTypeMapping.MINIMUM.getAnnotationType(XMLGregorianCalendar.class)));
        OPERATION_MAP.put(OperationKeys.XMLGREGORIANCALENDARIMPL_MAXIMUM, new DateTimeAnnotation(AnnotationTypeMapping.MAXIMUM.getAnnotationType(XMLGregorianCalendar.class)));
    }

    private static enum OperationKeys {
        FLOAT_MINIMUM,
        FLOAT_MAXIMUM,
        DOUBLE_MINIMUM,
        DOUBLE_MAXIMUM,
        BIGINTEGER_MINIMUM,
        BIGINTEGER_MAXIMUM,
        BIGDECIMAL_MINIMUM,
        BIGDECIMAL_MAXIMUM,
        INTEGER_MINIMUM,
        INTEGER_MAXIMUM,
        SHORT_MINIMUM,
        SHORT_MAXIMUM,
        LONG_MINIMUM,
        LONG_MAXIMUM,
        DURATIONIMPL_MINIMUM,
        DURATIONIMPL_MAXIMUM,
        DURATIONYEARMONTHIMPL_MINIMUM,
        DURATIONYEARMONTHIMPL_MAXIMUM,
        DURATIONDAYTIMEIMPL_MINIMUM,
        DURATIONDAYTIMEIMPL_MAXIMUM,
        XMLGREGORIANCALENDARIMPL_MINIMUM,
        XMLGREGORIANCALENDARIMPL_MAXIMUM;


        static OperationKeys getByClassAndBound(Class<?> clazz, AnnotationTypeMapping extremum) {
            return OperationKeys.valueOf(clazz.getSimpleName().toUpperCase() + "_" + extremum.name().toUpperCase());
        }
    }
}

