/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.http.spi;

import com.sun.net.httpserver.Authenticator;
import com.sun.net.httpserver.HttpContext;
import com.sun.net.httpserver.HttpHandler;
import com.sun.net.httpserver.HttpPrincipal;
import java.io.IOException;
import java.io.PrintWriter;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.eclipse.jetty.http.spi.JettyHttpExchange;
import org.eclipse.jetty.server.Request;
import org.eclipse.jetty.server.handler.ContextHandler;

public class HttpSpiContextHandler
extends ContextHandler {
    private HttpContext _httpContext;
    private HttpHandler _httpHandler;

    public HttpSpiContextHandler(HttpContext httpContext, HttpHandler httpHandler) {
        this._httpContext = httpContext;
        this._httpHandler = httpHandler;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doScope(String target, Request baseRequest, HttpServletRequest req, HttpServletResponse resp) throws IOException, ServletException {
        if (!target.startsWith(this.getContextPath())) {
            return;
        }
        JettyHttpExchange jettyHttpExchange = new JettyHttpExchange(this._httpContext, req, resp);
        try {
            Authenticator auth = this._httpContext.getAuthenticator();
            if (auth != null) {
                this.handleAuthentication(resp, jettyHttpExchange, auth);
            } else {
                this._httpHandler.handle(jettyHttpExchange);
            }
        }
        catch (Exception ex) {
            PrintWriter writer = new PrintWriter(jettyHttpExchange.getResponseBody());
            resp.setStatus(500);
            writer.println("<h2>HTTP ERROR: 500</h2>");
            writer.println("<pre>INTERNAL_SERVER_ERROR</pre>");
            writer.println("<p>RequestURI=" + req.getRequestURI() + "</p>");
            writer.println("<pre>");
            ex.printStackTrace(writer);
            writer.println("</pre>");
            writer.println("<p><i><small><a href=\"http://jetty.mortbay.org\">Powered by jetty://</a></small></i></p>");
            writer.close();
        }
        finally {
            baseRequest.setHandled(true);
        }
    }

    private void handleAuthentication(HttpServletResponse resp, JettyHttpExchange jettyHttpExchange, Authenticator auth) throws IOException {
        Authenticator.Result result = auth.authenticate(jettyHttpExchange);
        if (result instanceof Authenticator.Failure) {
            int rc = ((Authenticator.Failure)result).getResponseCode();
            resp.sendError(rc);
        } else if (result instanceof Authenticator.Retry) {
            int rc = ((Authenticator.Retry)result).getResponseCode();
            resp.sendError(rc);
        } else if (result instanceof Authenticator.Success) {
            HttpPrincipal principal = ((Authenticator.Success)result).getPrincipal();
            jettyHttpExchange.setPrincipal(principal);
            this._httpHandler.handle(jettyHttpExchange);
        }
    }

    public HttpHandler getHttpHandler() {
        return this._httpHandler;
    }

    public void setHttpHandler(HttpHandler handler) {
        this._httpHandler = handler;
    }
}

