/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.reactive.client.internal;

import java.util.ArrayDeque;
import java.util.Queue;
import java.util.concurrent.CompletionException;
import org.eclipse.jetty.reactive.client.internal.AbstractSinglePublisher;
import org.eclipse.jetty.util.MathUtils;
import org.reactivestreams.Subscriber;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class QueuedSinglePublisher<T>
extends AbstractSinglePublisher<T> {
    public static final Terminal<?> COMPLETE = Subscriber::onComplete;
    private static final Logger logger = LoggerFactory.getLogger(QueuedSinglePublisher.class);
    private final Queue<Object> items = new ArrayDeque<Object>();
    private long demand;
    private boolean stalled = true;
    private boolean active;
    private Throwable terminated;

    public void offer(T item) {
        if (logger.isDebugEnabled()) {
            logger.debug("offered item {} to {}", item, (Object)this);
        }
        this.process(item);
    }

    public void complete() {
        if (logger.isDebugEnabled()) {
            logger.debug("completed {}", (Object)this);
        }
        this.process(COMPLETE);
    }

    public boolean fail(Throwable failure) {
        if (logger.isDebugEnabled()) {
            logger.debug("failed {}", (Object)this, (Object)failure);
        }
        return this.process(new Failure(failure));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void onRequest(Subscriber<? super T> subscriber, long n) {
        boolean proceed = false;
        QueuedSinglePublisher queuedSinglePublisher = this;
        synchronized (queuedSinglePublisher) {
            this.demand = MathUtils.cappedAdd((long)this.demand, (long)n);
            if (this.stalled) {
                this.stalled = false;
                proceed = true;
            }
        }
        if (proceed) {
            this.proceed(subscriber);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean process(Object item) {
        Subscriber subscriber;
        QueuedSinglePublisher queuedSinglePublisher = this;
        synchronized (queuedSinglePublisher) {
            if (this.terminated != null) {
                throw new IllegalStateException(this.terminated);
            }
            if (this.isTerminal(item)) {
                this.terminated = new CompletionException("terminated from " + Thread.currentThread(), null);
            }
            this.items.offer(item);
            subscriber = this.subscriber();
            if (subscriber != null && this.stalled) {
                this.stalled = false;
            }
        }
        if (subscriber != null) {
            this.proceed(subscriber);
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void proceed(Subscriber<? super T> subscriber) {
        QueuedSinglePublisher queuedSinglePublisher = this;
        synchronized (queuedSinglePublisher) {
            if (this.active) {
                return;
            }
            this.active = true;
        }
        while (true) {
            Object t;
            boolean terminal;
            Object item;
            QueuedSinglePublisher queuedSinglePublisher2 = this;
            synchronized (queuedSinglePublisher2) {
                item = this.items.peek();
                if (item == null) {
                    this.stalled = true;
                    this.active = false;
                    return;
                }
                terminal = this.isTerminal(item);
                if (!terminal) {
                    if (this.demand > 0L) {
                        --this.demand;
                    } else {
                        this.stalled = true;
                        this.active = false;
                        return;
                    }
                }
                item = this.items.poll();
            }
            if (logger.isDebugEnabled()) {
                logger.debug("processing {} item {} by {}", new Object[]{terminal ? "last" : "next", item, this});
            }
            if (terminal) {
                t = (Terminal)item;
                t.notify(subscriber);
                continue;
            }
            t = item;
            this.onNext(subscriber, t);
        }
    }

    protected void onNext(Subscriber<? super T> subscriber, T item) {
        subscriber.onNext(item);
    }

    private boolean isTerminal(Object item) {
        return item instanceof Terminal;
    }

    private static class Failure<F>
    implements Terminal<F> {
        private final Throwable failure;

        private Failure(Throwable failure) {
            this.failure = failure;
        }

        @Override
        public void notify(Subscriber<? super F> subscriber) {
            subscriber.onError(this.failure);
        }
    }

    @FunctionalInterface
    private static interface Terminal<T> {
        public void notify(Subscriber<? super T> var1);
    }
}

