/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.util.ajax;

import java.util.Map;
import org.eclipse.jetty.util.Loader;
import org.eclipse.jetty.util.ajax.JSON;
import org.eclipse.jetty.util.ajax.JSONPojoConvertor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JSONPojoConvertorFactory
implements JSON.Convertor {
    private static final Logger LOG = LoggerFactory.getLogger(JSONPojoConvertorFactory.class);
    private final JSON _json;
    private final boolean _fromJson;

    public JSONPojoConvertorFactory(JSON json) {
        this(json, true);
    }

    public JSONPojoConvertorFactory(JSON json, boolean fromJSON) {
        if (json == null) {
            throw new IllegalArgumentException();
        }
        this._json = json;
        this._fromJson = fromJSON;
    }

    @Override
    public void toJSON(Object obj, JSON.Output out) {
        Class<?> cls = obj.getClass();
        String clsName = cls.getName();
        JSON.Convertor convertor = this._json.getConvertorFor(clsName);
        if (convertor == null) {
            convertor = new JSONPojoConvertor(cls, this._fromJson);
            this._json.addConvertorFor(clsName, convertor);
        }
        convertor.toJSON(obj, out);
    }

    @Override
    public Object fromJSON(Map<String, Object> map) {
        String clsName = (String)map.get("class");
        if (clsName != null) {
            JSON.Convertor convertor = this._json.getConvertorFor(clsName);
            if (convertor == null) {
                try {
                    Class cls = Loader.loadClass((String)clsName);
                    convertor = new JSONPojoConvertor(cls, this._fromJson);
                    this._json.addConvertorFor(clsName, convertor);
                }
                catch (ClassNotFoundException e) {
                    LOG.warn("Unable to find class: " + clsName, (Throwable)e);
                }
            }
            if (convertor != null) {
                return convertor.fromJSON(map);
            }
        }
        return map;
    }
}

