/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jgit.pgm;

import java.io.Writer;
import java.util.List;
import org.eclipse.jgit.api.FetchCommand;
import org.eclipse.jgit.api.Git;
import org.eclipse.jgit.lib.ProgressMonitor;
import org.eclipse.jgit.lib.TextProgressMonitor;
import org.eclipse.jgit.pgm.AbstractFetchCommand;
import org.eclipse.jgit.pgm.Command;
import org.eclipse.jgit.transport.FetchResult;
import org.eclipse.jgit.transport.RefSpec;
import org.eclipse.jgit.transport.TagOpt;
import org.kohsuke.args4j.Argument;
import org.kohsuke.args4j.Option;

@Command(common=true, usage="usage_updateRemoteRefsFromAnotherRepository")
class Fetch
extends AbstractFetchCommand {
    @Option(name="--timeout", metaVar="metaVar_seconds", usage="usage_abortConnectionIfNoActivity")
    int timeout = -1;
    @Option(name="--fsck", usage="usage_performFsckStyleChecksOnReceive")
    private Boolean fsck;
    @Option(name="--prune", usage="usage_pruneStaleTrackingRefs")
    private Boolean prune;
    @Option(name="--dry-run")
    private boolean dryRun;
    @Option(name="--thin", usage="usage_fetchThinPack")
    private Boolean thin;
    @Option(name="--quiet", usage="usage_quiet")
    private Boolean quiet;
    @Option(name="--tags", usage="usage_tags", aliases={"-t"})
    private Boolean tags;
    @Argument(index=0, metaVar="metaVar_uriish")
    private String remote = "origin";
    @Argument(index=1, metaVar="metaVar_refspec")
    private List<RefSpec> toget;

    Fetch() {
    }

    @Option(name="--no-fsck")
    void nofsck(boolean ignored) {
        this.fsck = Boolean.FALSE;
    }

    @Option(name="--no-thin")
    void nothin(boolean ignored) {
        this.thin = Boolean.FALSE;
    }

    @Option(name="--no-tags", usage="usage_notags", aliases={"-n"})
    void notags(boolean ignored) {
        this.tags = Boolean.FALSE;
    }

    @Override
    protected void run() throws Exception {
        try (Git git = new Git(this.db);){
            FetchResult result;
            FetchCommand fetch = git.fetch();
            if (this.fsck != null) {
                fetch.setCheckFetchedObjects(this.fsck.booleanValue());
            }
            if (this.prune != null) {
                fetch.setRemoveDeletedRefs(this.prune.booleanValue());
            }
            if (this.toget != null) {
                fetch.setRefSpecs(this.toget);
            }
            if (this.tags != null) {
                fetch.setTagOpt(this.tags != false ? TagOpt.FETCH_TAGS : TagOpt.NO_TAGS);
            }
            if (0 <= this.timeout) {
                fetch.setTimeout(this.timeout);
            }
            fetch.setDryRun(this.dryRun);
            fetch.setRemote(this.remote);
            if (this.thin != null) {
                fetch.setThin(this.thin.booleanValue());
            }
            if (this.quiet == null || !this.quiet.booleanValue()) {
                fetch.setProgressMonitor((ProgressMonitor)new TextProgressMonitor((Writer)this.errw));
            }
            if ((result = fetch.call()).getTrackingRefUpdates().isEmpty()) {
                return;
            }
            this.showFetchResult(result);
        }
    }
}

