/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jgit.pgm;

import java.io.BufferedOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.Writer;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.jgit.diff.DiffFormatter;
import org.eclipse.jgit.diff.RawText;
import org.eclipse.jgit.diff.RawTextComparator;
import org.eclipse.jgit.diff.RenameDetector;
import org.eclipse.jgit.errors.LargeObjectException;
import org.eclipse.jgit.lib.AnyObjectId;
import org.eclipse.jgit.lib.ObjectId;
import org.eclipse.jgit.lib.ObjectReader;
import org.eclipse.jgit.lib.PersonIdent;
import org.eclipse.jgit.lib.Ref;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.jgit.notes.NoteMap;
import org.eclipse.jgit.pgm.Command;
import org.eclipse.jgit.pgm.Diff;
import org.eclipse.jgit.pgm.RevWalkTextBuiltin;
import org.eclipse.jgit.pgm.internal.CLIText;
import org.eclipse.jgit.revwalk.RevCommit;
import org.eclipse.jgit.revwalk.RevTree;
import org.eclipse.jgit.util.GitDateFormatter;
import org.kohsuke.args4j.Option;

@Command(common=true, usage="usage_viewCommitHistory")
class Log
extends RevWalkTextBuiltin {
    private GitDateFormatter dateFormatter = new GitDateFormatter(GitDateFormatter.Format.DEFAULT);
    private DiffFormatter diffFmt;
    private Map<AnyObjectId, Set<Ref>> allRefsByPeeledObjectId;
    private Map<String, NoteMap> noteMaps;
    @Option(name="--decorate", usage="usage_showRefNamesMatchingCommits")
    private boolean decorate;
    @Option(name="--no-standard-notes", usage="usage_noShowStandardNotes")
    private boolean noStandardNotes;
    private List<String> additionalNoteRefs = new ArrayList<String>();
    @Option(name="-p", usage="usage_showPatch")
    boolean showPatch;
    @Option(name="-M", usage="usage_detectRenames")
    private Boolean detectRenames;
    @Option(name="-l", usage="usage_renameLimit")
    private Integer renameLimit;
    @Option(name="--name-status", usage="usage_nameStatus")
    private boolean showNameAndStatusOnly;

    @Option(name="--show-notes", usage="usage_showNotes", metaVar="metaVar_ref")
    void addAdditionalNoteRef(String notesRef) {
        this.additionalNoteRefs.add(notesRef);
    }

    @Option(name="--date", usage="usage_date")
    void dateFormat(String date) {
        if (date.toLowerCase().equals(date)) {
            date = date.toUpperCase();
        }
        this.dateFormatter = new GitDateFormatter(GitDateFormatter.Format.valueOf((String)date));
    }

    @Option(name="--no-renames", usage="usage_noRenames")
    void noRenames(boolean on) {
        this.detectRenames = Boolean.FALSE;
    }

    @Option(name="--ignore-space-at-eol")
    void ignoreSpaceAtEol(boolean on) {
        this.diffFmt.setDiffComparator(RawTextComparator.WS_IGNORE_TRAILING);
    }

    @Option(name="--ignore-leading-space")
    void ignoreLeadingSpace(boolean on) {
        this.diffFmt.setDiffComparator(RawTextComparator.WS_IGNORE_LEADING);
    }

    @Option(name="-b", aliases={"--ignore-space-change"})
    void ignoreSpaceChange(boolean on) {
        this.diffFmt.setDiffComparator(RawTextComparator.WS_IGNORE_CHANGE);
    }

    @Option(name="-w", aliases={"--ignore-all-space"})
    void ignoreAllSpace(boolean on) {
        this.diffFmt.setDiffComparator(RawTextComparator.WS_IGNORE_ALL);
    }

    @Option(name="-U", aliases={"--unified"}, metaVar="metaVar_linesOfContext")
    void unified(int lines) {
        this.diffFmt.setContext(lines);
    }

    @Option(name="--abbrev", metaVar="metaVar_n")
    void abbrev(int lines) {
        this.diffFmt.setAbbreviationLength(lines);
    }

    @Option(name="--full-index")
    void abbrev(boolean on) {
        this.diffFmt.setAbbreviationLength(40);
    }

    @Option(name="--src-prefix", usage="usage_srcPrefix")
    void sourcePrefix(String path) {
        this.diffFmt.setOldPrefix(path);
    }

    @Option(name="--dst-prefix", usage="usage_dstPrefix")
    void dstPrefix(String path) {
        this.diffFmt.setNewPrefix(path);
    }

    @Option(name="--no-prefix", usage="usage_noPrefix")
    void noPrefix(boolean on) {
        this.diffFmt.setOldPrefix("");
        this.diffFmt.setNewPrefix("");
    }

    Log() {
        this.dateFormatter = new GitDateFormatter(GitDateFormatter.Format.DEFAULT);
    }

    @Override
    protected void init(Repository repository, String gitDir) {
        super.init(repository, gitDir);
        this.diffFmt = new DiffFormatter((OutputStream)new BufferedOutputStream(this.outs));
    }

    @Override
    protected void run() throws Exception {
        this.diffFmt.setRepository(this.db);
        try {
            this.diffFmt.setPathFilter(this.pathFilter);
            if (this.detectRenames != null) {
                this.diffFmt.setDetectRenames(this.detectRenames.booleanValue());
            }
            if (this.renameLimit != null && this.diffFmt.isDetectRenames()) {
                RenameDetector rd = this.diffFmt.getRenameDetector();
                rd.setRenameLimit(this.renameLimit.intValue());
            }
            if (!this.noStandardNotes || !this.additionalNoteRefs.isEmpty()) {
                this.createWalk();
                this.noteMaps = new LinkedHashMap<String, NoteMap>();
                if (!this.noStandardNotes) {
                    this.addNoteMap("refs/notes/commits");
                }
                if (!this.additionalNoteRefs.isEmpty()) {
                    for (String notesRef : this.additionalNoteRefs) {
                        if (!notesRef.startsWith("refs/notes/")) {
                            notesRef = "refs/notes/" + notesRef;
                        }
                        this.addNoteMap(notesRef);
                    }
                }
            }
            if (this.decorate) {
                this.allRefsByPeeledObjectId = this.getRepository().getAllRefsByPeeledObjectId();
            }
            super.run();
        }
        finally {
            this.diffFmt.close();
        }
    }

    private void addNoteMap(String notesRef) throws IOException {
        Ref notes = this.db.exactRef(notesRef);
        if (notes == null) {
            return;
        }
        RevCommit notesCommit = this.argWalk.parseCommit((AnyObjectId)notes.getObjectId());
        this.noteMaps.put(notesRef, NoteMap.read((ObjectReader)this.argWalk.getObjectReader(), (RevCommit)notesCommit));
    }

    @Override
    protected void show(RevCommit c) throws Exception {
        String[] lines;
        Collection list;
        this.outw.print((Object)CLIText.get().commitLabel);
        this.outw.print((Object)" ");
        c.getId().copyTo(this.outbuffer, (Writer)this.outw);
        if (this.decorate && (list = (Collection)this.allRefsByPeeledObjectId.get(c)) != null) {
            this.outw.print((Object)" (");
            Iterator i = list.iterator();
            while (i.hasNext()) {
                this.outw.print((Object)((Ref)i.next()).getName());
                if (!i.hasNext()) continue;
                this.outw.print((Object)" ");
            }
            this.outw.print((Object)")");
        }
        this.outw.println();
        PersonIdent author = c.getAuthorIdent();
        this.outw.println(MessageFormat.format(CLIText.get().authorInfo, author.getName(), author.getEmailAddress()));
        this.outw.println(MessageFormat.format(CLIText.get().dateInfo, this.dateFormatter.formatDate(author)));
        this.outw.println();
        for (String s : lines = c.getFullMessage().split("\n")) {
            this.outw.print((Object)"    ");
            this.outw.print((Object)s);
            this.outw.println();
        }
        c.disposeBody();
        this.outw.println();
        if (this.showNotes(c)) {
            this.outw.println();
        }
        if (c.getParentCount() <= 1 && (this.showNameAndStatusOnly || this.showPatch)) {
            this.showDiff(c);
        }
        this.outw.flush();
    }

    private boolean showNotes(RevCommit c) throws IOException {
        if (this.noteMaps == null) {
            return false;
        }
        boolean printEmptyLine = false;
        boolean atLeastOnePrinted = false;
        for (Map.Entry<String, NoteMap> e : this.noteMaps.entrySet()) {
            String label = null;
            String notesRef = e.getKey();
            if (!notesRef.equals("refs/notes/commits")) {
                label = notesRef.startsWith("refs/notes/") ? notesRef.substring("refs/notes/".length()) : notesRef;
            }
            boolean printedNote = this.showNotes(c, e.getValue(), label, printEmptyLine);
            atLeastOnePrinted |= printedNote;
            printEmptyLine = printedNote;
        }
        return atLeastOnePrinted;
    }

    private boolean showNotes(RevCommit c, NoteMap map, String label, boolean emptyLine) throws IOException {
        ObjectId blobId = map.get((AnyObjectId)c);
        if (blobId == null) {
            return false;
        }
        if (emptyLine) {
            this.outw.println();
        }
        this.outw.print((Object)"Notes");
        if (label != null) {
            this.outw.print((Object)" (");
            this.outw.print((Object)label);
            this.outw.print((Object)")");
        }
        this.outw.println(":");
        try {
            RawText rawText = new RawText(this.argWalk.getObjectReader().open((AnyObjectId)blobId).getCachedBytes(Integer.MAX_VALUE));
            for (int i = 0; i < rawText.size(); ++i) {
                this.outw.print((Object)"    ");
                this.outw.println(rawText.getString(i));
            }
        }
        catch (LargeObjectException e) {
            this.outw.println(MessageFormat.format(CLIText.get().noteObjectTooLargeToPrint, blobId.name()));
        }
        return true;
    }

    private void showDiff(RevCommit c) throws IOException {
        RevTree a = c.getParentCount() > 0 ? c.getParent(0).getTree() : null;
        RevTree b = c.getTree();
        if (this.showNameAndStatusOnly) {
            Diff.nameStatus(this.outw, this.diffFmt.scan(a, b));
        } else {
            this.outw.flush();
            this.diffFmt.format(a, b);
            this.diffFmt.flush();
        }
        this.outw.println();
    }
}

