/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jgit.pgm.debug;

import java.io.File;
import java.io.IOException;
import java.net.InetAddress;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.UnknownHostException;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.text.MessageFormat;
import javax.servlet.Servlet;
import org.eclipse.jetty.server.ConnectionFactory;
import org.eclipse.jetty.server.Connector;
import org.eclipse.jetty.server.Handler;
import org.eclipse.jetty.server.HttpConfiguration;
import org.eclipse.jetty.server.HttpConnectionFactory;
import org.eclipse.jetty.server.Server;
import org.eclipse.jetty.server.ServerConnector;
import org.eclipse.jetty.server.handler.ContextHandlerCollection;
import org.eclipse.jetty.servlet.ServletContextHandler;
import org.eclipse.jetty.servlet.ServletHolder;
import org.eclipse.jgit.errors.ConfigInvalidException;
import org.eclipse.jgit.lfs.server.LargeFileRepository;
import org.eclipse.jgit.lfs.server.LfsProtocolServlet;
import org.eclipse.jgit.lfs.server.fs.FileLfsRepository;
import org.eclipse.jgit.lfs.server.fs.FileLfsServlet;
import org.eclipse.jgit.lfs.server.s3.S3Config;
import org.eclipse.jgit.lfs.server.s3.S3Repository;
import org.eclipse.jgit.pgm.Command;
import org.eclipse.jgit.pgm.TextBuiltin;
import org.eclipse.jgit.pgm.internal.CLIText;
import org.eclipse.jgit.storage.file.FileBasedConfig;
import org.eclipse.jgit.util.FS;
import org.kohsuke.args4j.Argument;
import org.kohsuke.args4j.Option;

@Command(common=true, usage="usage_runLfsStore")
class LfsStore
extends TextBuiltin {
    private static final String OBJECTS = "objects/";
    private static final String STORE_PATH = "/objects/*";
    private static final String PROTOCOL_PATH = "/lfs/objects/batch";
    @Option(name="--port", aliases={"-p"}, metaVar="metaVar_port", usage="usage_LFSPort")
    int port;
    @Option(name="--store", metaVar="metaVar_lfsStorage", usage="usage_LFSRunStore")
    StoreType storeType;
    @Option(name="--store-url", aliases={"-u"}, metaVar="metaVar_url", usage="usage_LFSStoreUrl")
    String storeUrl;
    @Option(name="--region", aliases={"-r"}, metaVar="metaVar_s3Region", usage="usage_S3Region")
    String region;
    @Option(name="--bucket", aliases={"-b"}, metaVar="metaVar_s3Bucket", usage="usage_S3Bucket")
    String bucket;
    @Option(name="--storage-class", aliases={"-c"}, metaVar="metaVar_s3StorageClass", usage="usage_S3StorageClass")
    StorageClass storageClass = StorageClass.REDUCED_REDUNDANCY;
    @Option(name="--expire", aliases={"-e"}, metaVar="metaVar_seconds", usage="usage_S3Expiration")
    int expirationSeconds = 600;
    @Option(name="--no-ssl-verify", usage="usage_S3NoSslVerify")
    boolean disableSslVerify = false;
    @Argument(required=false, metaVar="metaVar_directory", usage="usage_LFSDirectory")
    String directory;
    String protocolUrl;
    String accessKey;
    String secretKey;

    LfsStore() {
    }

    @Override
    protected boolean requiresRepository() {
        return false;
    }

    @Override
    protected void run() throws Exception {
        FileLfsRepository repository;
        AppServer server = new AppServer(this.port);
        URI baseURI = server.getURI();
        ServletContextHandler app = server.addContext("/");
        switch (this.storeType) {
            case FS: {
                Path dir = Paths.get(this.directory, new String[0]);
                FileLfsRepository fsRepo = new FileLfsRepository(this.getStoreUrl(baseURI), dir);
                FileLfsServlet content = new FileLfsServlet(fsRepo, 30000L);
                app.addServlet(new ServletHolder((Servlet)content), STORE_PATH);
                repository = fsRepo;
                break;
            }
            case S3: {
                this.readAWSKeys();
                this.checkOptions();
                S3Config config = new S3Config(this.region.toString(), this.bucket, this.storageClass.toString(), this.accessKey, this.secretKey, this.expirationSeconds, this.disableSslVerify);
                repository = new S3Repository(config);
                break;
            }
            default: {
                throw new IllegalArgumentException(MessageFormat.format(CLIText.get().lfsUnknownStoreType, new Object[]{this.storeType}));
            }
        }
        LfsProtocolServlet protocol = new LfsProtocolServlet((LargeFileRepository)repository){
            private static final long serialVersionUID = 1L;
            final /* synthetic */ LargeFileRepository val$repository;
            {
                this.val$repository = largeFileRepository;
            }

            protected LargeFileRepository getLargeFileRepository(LfsProtocolServlet.LfsRequest request, String path) {
                return this.val$repository;
            }
        };
        app.addServlet(new ServletHolder((Servlet)protocol), PROTOCOL_PATH);
        server.start();
        this.outw.println(MessageFormat.format(CLIText.get().lfsProtocolUrl, this.getProtocolUrl(baseURI)));
        if (this.storeType == StoreType.FS) {
            this.outw.println(MessageFormat.format(CLIText.get().lfsStoreDirectory, this.directory));
            this.outw.println(MessageFormat.format(CLIText.get().lfsStoreUrl, this.getStoreUrl(baseURI)));
        }
    }

    private void checkOptions() {
        if (this.bucket == null || this.bucket.length() == 0) {
            throw LfsStore.die(MessageFormat.format(CLIText.get().s3InvalidBucket, this.bucket));
        }
    }

    private void readAWSKeys() throws IOException, ConfigInvalidException {
        String credentialsPath = System.getProperty("user.home") + "/.aws/credentials";
        FileBasedConfig c = new FileBasedConfig(new File(credentialsPath), FS.DETECTED);
        c.load();
        this.accessKey = c.getString("default", null, "accessKey");
        this.secretKey = c.getString("default", null, "secretKey");
        if (this.accessKey == null || this.accessKey.isEmpty()) {
            throw LfsStore.die(MessageFormat.format(CLIText.get().lfsNoAccessKey, credentialsPath));
        }
        if (this.secretKey == null || this.secretKey.isEmpty()) {
            throw LfsStore.die(MessageFormat.format(CLIText.get().lfsNoSecretKey, credentialsPath));
        }
    }

    private String getStoreUrl(URI baseURI) {
        if (this.storeUrl == null) {
            if (this.storeType == StoreType.FS) {
                this.storeUrl = baseURI + "/" + OBJECTS;
            } else {
                LfsStore.die("Local store not running and no --store-url specified");
            }
        }
        return this.storeUrl;
    }

    private String getProtocolUrl(URI baseURI) {
        if (this.protocolUrl == null) {
            this.protocolUrl = baseURI + PROTOCOL_PATH;
        }
        return this.protocolUrl;
    }

    class AppServer {
        private final Server server = new Server();
        private final ServerConnector connector;
        private final ContextHandlerCollection contexts;
        private URI uri;

        AppServer(int port) {
            HttpConfiguration http_config = new HttpConfiguration();
            http_config.setOutputBufferSize(32768);
            this.connector = new ServerConnector(this.server, new ConnectionFactory[]{new HttpConnectionFactory(http_config)});
            this.connector.setPort(port);
            try {
                String host = InetAddress.getByName("localhost").getHostAddress();
                this.connector.setHost(host);
                if (host.contains(":") && !host.startsWith("[")) {
                    host = "[" + host + "]";
                }
                this.uri = new URI("http://" + host + ":" + port);
            }
            catch (UnknownHostException e) {
                throw new RuntimeException("Cannot find localhost", e);
            }
            catch (URISyntaxException e) {
                throw new RuntimeException("Unexpected URI error on " + this.uri, e);
            }
            this.contexts = new ContextHandlerCollection();
            this.server.setHandler((Handler)this.contexts);
            this.server.setConnectors(new Connector[]{this.connector});
        }

        ServletContextHandler addContext(String path) {
            this.assertNotRunning();
            if ("".equals(path)) {
                path = "/";
            }
            ServletContextHandler ctx = new ServletContextHandler();
            ctx.setContextPath(path);
            this.contexts.addHandler((Handler)ctx);
            return ctx;
        }

        void start() throws Exception {
            this.server.start();
        }

        void stop() throws Exception {
            this.server.stop();
        }

        URI getURI() {
            return this.uri;
        }

        private void assertNotRunning() {
            if (this.server.isRunning()) {
                throw new IllegalStateException("server is running");
            }
        }
    }

    private static enum StorageClass {
        REDUCED_REDUNDANCY,
        STANDARD;

    }

    private static enum StoreType {
        FS,
        S3;

    }
}

