/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jgit.pgm.opt;

import java.io.IOException;
import java.text.MessageFormat;
import org.eclipse.jgit.errors.IncorrectObjectTypeException;
import org.eclipse.jgit.errors.MissingObjectException;
import org.eclipse.jgit.lib.AnyObjectId;
import org.eclipse.jgit.lib.ObjectId;
import org.eclipse.jgit.pgm.internal.CLIText;
import org.eclipse.jgit.pgm.opt.CmdLineParser;
import org.eclipse.jgit.revwalk.RevCommit;
import org.eclipse.jgit.revwalk.RevFlag;
import org.kohsuke.args4j.CmdLineException;
import org.kohsuke.args4j.OptionDef;
import org.kohsuke.args4j.spi.OptionHandler;
import org.kohsuke.args4j.spi.Parameters;
import org.kohsuke.args4j.spi.Setter;

public class RevCommitHandler
extends OptionHandler<RevCommit> {
    private final CmdLineParser clp;

    public RevCommitHandler(org.kohsuke.args4j.CmdLineParser parser, OptionDef option, Setter<? super RevCommit> setter) {
        super(parser, option, setter);
        this.clp = (CmdLineParser)parser;
    }

    public int parseArguments(Parameters params) throws CmdLineException {
        int dot2;
        String name = params.getParameter(0);
        boolean interesting = true;
        if (name.startsWith("^")) {
            name = name.substring(1);
            interesting = false;
        }
        if ((dot2 = name.indexOf("..")) != -1) {
            if (!this.option.isMultiValued()) {
                throw new CmdLineException((org.kohsuke.args4j.CmdLineParser)this.clp, MessageFormat.format(CLIText.get().onlyOneMetaVarExpectedIn, this.option.metaVar(), name));
            }
            String left = name.substring(0, dot2);
            String right = name.substring(dot2 + 2);
            this.addOne(left, false);
            this.addOne(right, true);
            return 1;
        }
        this.addOne(name, interesting);
        return 1;
    }

    private void addOne(String name, boolean interesting) throws CmdLineException {
        RevCommit c;
        ObjectId id;
        try {
            id = this.clp.getRepository().resolve(name);
        }
        catch (IOException e) {
            throw new CmdLineException((org.kohsuke.args4j.CmdLineParser)this.clp, e.getMessage());
        }
        if (id == null) {
            throw new CmdLineException((org.kohsuke.args4j.CmdLineParser)this.clp, MessageFormat.format(CLIText.get().notACommit, name));
        }
        try {
            c = this.clp.getRevWalk().parseCommit((AnyObjectId)id);
        }
        catch (MissingObjectException e) {
            throw new CmdLineException((org.kohsuke.args4j.CmdLineParser)this.clp, MessageFormat.format(CLIText.get().notACommit, name));
        }
        catch (IncorrectObjectTypeException e) {
            throw new CmdLineException((org.kohsuke.args4j.CmdLineParser)this.clp, MessageFormat.format(CLIText.get().notACommit, name));
        }
        catch (IOException e) {
            throw new CmdLineException((org.kohsuke.args4j.CmdLineParser)this.clp, MessageFormat.format(CLIText.get().cannotReadBecause, name, e.getMessage()));
        }
        if (interesting) {
            c.remove(RevFlag.UNINTERESTING);
        } else {
            c.add(RevFlag.UNINTERESTING);
        }
        this.setter.addValue((Object)c);
    }

    public String getDefaultMetaVariable() {
        return CLIText.get().metaVar_commitish;
    }
}

