/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jgit.internal.storage.file;

import java.io.File;
import java.io.IOException;
import java.text.MessageFormat;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.jgit.dircache.DirCacheIterator;
import org.eclipse.jgit.errors.CorruptObjectException;
import org.eclipse.jgit.errors.IncorrectObjectTypeException;
import org.eclipse.jgit.errors.MissingObjectException;
import org.eclipse.jgit.errors.NoWorkTreeException;
import org.eclipse.jgit.internal.JGitText;
import org.eclipse.jgit.internal.storage.file.FileRepository;
import org.eclipse.jgit.internal.storage.file.ObjectDirectory;
import org.eclipse.jgit.internal.storage.file.PackFile;
import org.eclipse.jgit.internal.storage.file.PackIndex;
import org.eclipse.jgit.internal.storage.file.RefDirectory;
import org.eclipse.jgit.internal.storage.pack.PackExt;
import org.eclipse.jgit.internal.storage.pack.PackWriter;
import org.eclipse.jgit.lib.AnyObjectId;
import org.eclipse.jgit.lib.NullProgressMonitor;
import org.eclipse.jgit.lib.ObjectId;
import org.eclipse.jgit.lib.ProgressMonitor;
import org.eclipse.jgit.lib.Ref;
import org.eclipse.jgit.lib.RefDatabase;
import org.eclipse.jgit.lib.ReflogEntry;
import org.eclipse.jgit.revwalk.ObjectWalk;
import org.eclipse.jgit.revwalk.RevObject;
import org.eclipse.jgit.revwalk.RevWalk;
import org.eclipse.jgit.treewalk.TreeWalk;
import org.eclipse.jgit.treewalk.filter.TreeFilter;
import org.eclipse.jgit.util.FileUtils;
import org.eclipse.jgit.util.GitDateParser;
import org.eclipse.jgit.util.SystemReader;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GC {
    private static final String PRUNE_EXPIRE_DEFAULT = "2.weeks.ago";
    private final FileRepository repo;
    private ProgressMonitor pm;
    private long expireAgeMillis = -1L;
    private Date expire;
    private Map<String, Ref> lastPackedRefs;
    private long lastRepackTime;

    public GC(FileRepository repo) {
        this.repo = repo;
        this.pm = NullProgressMonitor.INSTANCE;
    }

    public Collection<PackFile> gc() throws IOException, ParseException {
        this.pm.start(6);
        this.packRefs();
        Collection<PackFile> newPacks = this.repack();
        this.prune(Collections.<ObjectId>emptySet());
        return newPacks;
    }

    private void deleteOldPacks(Collection<PackFile> oldPacks, Collection<PackFile> newPacks) {
        block0: for (PackFile oldPack : oldPacks) {
            String oldName = oldPack.getPackName();
            for (PackFile newPack : newPacks) {
                if (!oldName.equals(newPack.getPackName())) continue;
                continue block0;
            }
            if (oldPack.shouldBeKept()) continue;
            oldPack.close();
            this.prunePack(oldName);
        }
        this.repo.getObjectDatabase().close();
    }

    private void prunePack(String packName) {
        PackExt[] extensions = PackExt.values();
        try {
            File f;
            int deleteOptions = 6;
            for (PackExt ext : extensions) {
                if (!PackExt.PACK.equals(ext)) continue;
                f = this.nameFor(packName, "." + ext.getExtension());
                FileUtils.delete(f, deleteOptions);
                break;
            }
            deleteOptions |= 8;
            for (PackExt ext : extensions) {
                if (PackExt.PACK.equals(ext)) continue;
                f = this.nameFor(packName, "." + ext.getExtension());
                FileUtils.delete(f, deleteOptions);
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void prunePacked() throws IOException {
        ObjectDirectory objdb = this.repo.getObjectDatabase();
        Collection<PackFile> packs = objdb.getPacks();
        File objects = this.repo.getObjectsDirectory();
        String[] fanout = objects.list();
        if (fanout != null && fanout.length > 0) {
            this.pm.beginTask(JGitText.get().pruneLoosePackedObjects, fanout.length);
            try {
                for (String d : fanout) {
                    String[] entries;
                    this.pm.update(1);
                    if (d.length() != 2 || (entries = new File(objects, d).list()) == null) continue;
                    for (String e : entries) {
                        ObjectId id;
                        if (e.length() != 38) continue;
                        try {
                            id = ObjectId.fromString(d + e);
                        }
                        catch (IllegalArgumentException notAnObject) {
                            continue;
                        }
                        boolean found = false;
                        for (PackFile p : packs) {
                            if (!p.hasObject(id)) continue;
                            found = true;
                            break;
                        }
                        if (!found) continue;
                        FileUtils.delete(objdb.fileFor(id), 14);
                    }
                }
            }
            finally {
                this.pm.endTask();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void prune(Set<ObjectId> objectsToKeep) throws IOException, ParseException {
        Map<String, Ref> newRefs;
        long expireDate = Long.MAX_VALUE;
        if (this.expire == null && this.expireAgeMillis == -1L) {
            String pruneExpireStr = this.repo.getConfig().getString("gc", null, "pruneexpire");
            if (pruneExpireStr == null) {
                pruneExpireStr = PRUNE_EXPIRE_DEFAULT;
            }
            this.expire = GitDateParser.parse(pruneExpireStr, null, SystemReader.getInstance().getLocale());
            this.expireAgeMillis = -1L;
        }
        if (this.expire != null) {
            expireDate = this.expire.getTime();
        }
        if (this.expireAgeMillis != -1L) {
            expireDate = System.currentTimeMillis() - this.expireAgeMillis;
        }
        HashMap<ObjectId, File> deletionCandidates = new HashMap<ObjectId, File>();
        Set<ObjectId> indexObjects = null;
        File objects = this.repo.getObjectsDirectory();
        String[] fanout = objects.list();
        if (fanout != null && fanout.length > 0) {
            this.pm.beginTask(JGitText.get().pruneLooseUnreferencedObjects, fanout.length);
            try {
                for (String d : fanout) {
                    File[] entries;
                    this.pm.update(1);
                    if (d.length() != 2 || (entries = new File(objects, d).listFiles()) == null) continue;
                    for (File f : entries) {
                        String fName = f.getName();
                        if (fName.length() != 38 || f.lastModified() >= expireDate) continue;
                        try {
                            ObjectId id = ObjectId.fromString(d + fName);
                            if (objectsToKeep.contains(id)) continue;
                            if (indexObjects == null) {
                                indexObjects = this.listNonHEADIndexObjects();
                            }
                            if (indexObjects.contains(id)) continue;
                            deletionCandidates.put(id, f);
                        }
                        catch (IllegalArgumentException notAnObject) {
                            // empty catch block
                        }
                    }
                }
            }
            finally {
                this.pm.endTask();
            }
        }
        if (deletionCandidates.isEmpty()) {
            return;
        }
        if (this.lastPackedRefs == null || this.lastPackedRefs.isEmpty()) {
            newRefs = this.getAllRefs();
        } else {
            newRefs = new HashMap<String, Ref>();
            for (Map.Entry<String, Ref> newEntry : this.getAllRefs().entrySet()) {
                Ref old = this.lastPackedRefs.get(newEntry.getKey());
                if (GC.equals(newEntry.getValue(), old)) continue;
                newRefs.put(newEntry.getKey(), newEntry.getValue());
            }
        }
        if (!newRefs.isEmpty()) {
            ObjectWalk w = new ObjectWalk(this.repo);
            try {
                for (Ref cr : newRefs.values()) {
                    w.markStart(w.parseAny(cr.getObjectId()));
                }
                if (this.lastPackedRefs != null) {
                    for (Ref lpr : this.lastPackedRefs.values()) {
                        w.markUninteresting(w.parseAny(lpr.getObjectId()));
                    }
                }
                this.removeReferenced(deletionCandidates, w);
            }
            finally {
                w.dispose();
            }
        }
        if (deletionCandidates.isEmpty()) {
            return;
        }
        ObjectWalk w = new ObjectWalk(this.repo);
        try {
            for (Ref ar : this.getAllRefs().values()) {
                for (ObjectId id : this.listRefLogObjects(ar, this.lastRepackTime)) {
                    w.markStart(w.parseAny(id));
                }
            }
            if (this.lastPackedRefs != null) {
                for (Ref lpr : this.lastPackedRefs.values()) {
                    w.markUninteresting(w.parseAny(lpr.getObjectId()));
                }
            }
            this.removeReferenced(deletionCandidates, w);
        }
        finally {
            w.dispose();
        }
        if (deletionCandidates.isEmpty()) {
            return;
        }
        for (File f : deletionCandidates.values()) {
            f.delete();
        }
        this.repo.getObjectDatabase().close();
    }

    private void removeReferenced(Map<ObjectId, File> id2File, ObjectWalk w) throws MissingObjectException, IncorrectObjectTypeException, IOException {
        RevObject ro = w.next();
        while (ro != null) {
            if (id2File.remove(ro.getId()) != null && id2File.isEmpty()) {
                return;
            }
            ro = w.next();
        }
        ro = w.nextObject();
        while (ro != null) {
            if (id2File.remove(ro.getId()) != null && id2File.isEmpty()) {
                return;
            }
            ro = w.nextObject();
        }
    }

    private static boolean equals(Ref r1, Ref r2) {
        if (r1 == null || r2 == null) {
            return false;
        }
        if (r1.isSymbolic()) {
            if (!r2.isSymbolic()) {
                return false;
            }
            return r1.getTarget().getName().equals(r2.getTarget().getName());
        }
        if (r2.isSymbolic()) {
            return false;
        }
        return r1.getObjectId().equals(r2.getObjectId());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void packRefs() throws IOException {
        Collection<Ref> refs = this.repo.getRefDatabase().getRefs("refs/").values();
        ArrayList<String> refsToBePacked = new ArrayList<String>(refs.size());
        this.pm.beginTask(JGitText.get().packRefs, refs.size());
        try {
            for (Ref ref : refs) {
                if (!ref.isSymbolic() && ref.getStorage().isLoose()) {
                    refsToBePacked.add(ref.getName());
                }
                this.pm.update(1);
            }
            ((RefDirectory)this.repo.getRefDatabase()).pack(refsToBePacked);
        }
        finally {
            this.pm.endTask();
        }
    }

    public Collection<PackFile> repack() throws IOException {
        PackFile rest;
        Collection<PackFile> toBeDeleted = this.repo.getObjectDatabase().getPacks();
        long time = System.currentTimeMillis();
        Map<String, Ref> refsBefore = this.getAllRefs();
        HashSet<ObjectId> allHeads = new HashSet<ObjectId>();
        HashSet<ObjectId> nonHeads = new HashSet<ObjectId>();
        HashSet<ObjectId> tagTargets = new HashSet<ObjectId>();
        Set<ObjectId> indexObjects = this.listNonHEADIndexObjects();
        for (Ref ref : refsBefore.values()) {
            nonHeads.addAll(this.listRefLogObjects(ref, 0L));
            if (ref.isSymbolic() || ref.getObjectId() == null) continue;
            if (ref.getName().startsWith("refs/heads/")) {
                allHeads.add(ref.getObjectId());
            } else {
                nonHeads.add(ref.getObjectId());
            }
            if (ref.getPeeledObjectId() == null) continue;
            tagTargets.add(ref.getPeeledObjectId());
        }
        LinkedList<PackWriter.ObjectIdSet> excluded = new LinkedList<PackWriter.ObjectIdSet>();
        for (PackFile f : this.repo.getObjectDatabase().getPacks()) {
            if (!f.shouldBeKept()) continue;
            excluded.add(GC.objectIdSet(f.getIndex()));
        }
        tagTargets.addAll(allHeads);
        nonHeads.addAll(indexObjects);
        ArrayList<PackFile> ret = new ArrayList<PackFile>(2);
        PackFile heads = null;
        if (!allHeads.isEmpty() && (heads = this.writePack(allHeads, Collections.emptySet(), tagTargets, excluded)) != null) {
            ret.add(heads);
            excluded.add(0, GC.objectIdSet(heads.getIndex()));
        }
        if (!nonHeads.isEmpty() && (rest = this.writePack(nonHeads, allHeads, tagTargets, excluded)) != null) {
            ret.add(rest);
        }
        this.deleteOldPacks(toBeDeleted, ret);
        this.prunePacked();
        this.lastPackedRefs = refsBefore;
        this.lastRepackTime = time;
        return ret;
    }

    private Set<ObjectId> listRefLogObjects(Ref ref, long minTime) throws IOException {
        List<ReflogEntry> rlEntries = this.repo.getReflogReader(ref.getName()).getReverseEntries();
        if (rlEntries == null || rlEntries.isEmpty()) {
            return Collections.emptySet();
        }
        HashSet<ObjectId> ret = new HashSet<ObjectId>();
        for (ReflogEntry e : rlEntries) {
            ObjectId oldId;
            if (e.getWho().getWhen().getTime() < minTime) break;
            ObjectId newId = e.getNewId();
            if (newId != null && !ObjectId.zeroId().equals(newId)) {
                ret.add(newId);
            }
            if ((oldId = e.getOldId()) == null || ObjectId.zeroId().equals(oldId)) continue;
            ret.add(oldId);
        }
        return ret;
    }

    private Map<String, Ref> getAllRefs() throws IOException {
        Map<String, Ref> ret = this.repo.getRefDatabase().getRefs("");
        for (Ref ref : this.repo.getRefDatabase().getAdditionalRefs()) {
            ret.put(ref.getName(), ref);
        }
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Set<ObjectId> listNonHEADIndexObjects() throws CorruptObjectException, IOException {
        RevWalk revWalk = null;
        try {
            if (this.repo.getIndexFile() == null) {
                return Collections.emptySet();
            }
        }
        catch (NoWorkTreeException e) {
            return Collections.emptySet();
        }
        TreeWalk treeWalk = new TreeWalk(this.repo);
        try {
            treeWalk.addTree(new DirCacheIterator(this.repo.readDirCache()));
            ObjectId headID = this.repo.resolve("HEAD");
            if (headID != null) {
                revWalk = new RevWalk(this.repo);
                treeWalk.addTree(revWalk.parseTree(headID));
                revWalk.dispose();
                revWalk = null;
            }
            treeWalk.setFilter(TreeFilter.ANY_DIFF);
            treeWalk.setRecursive(true);
            HashSet<ObjectId> ret = new HashSet<ObjectId>();
            block9: while (treeWalk.next()) {
                ObjectId objectId = treeWalk.getObjectId(0);
                switch (treeWalk.getRawMode(0) & 0xF000) {
                    case 0: 
                    case 57344: {
                        continue block9;
                    }
                    case 16384: 
                    case 32768: 
                    case 40960: {
                        ret.add(objectId);
                        continue block9;
                    }
                }
                throw new IOException(MessageFormat.format(JGitText.get().corruptObjectInvalidMode3, String.format("%o", treeWalk.getRawMode(0)), objectId == null ? "null" : objectId.name(), treeWalk.getPathString(), this.repo.getIndexFile()));
            }
            HashSet<ObjectId> hashSet = ret;
            return hashSet;
        }
        finally {
            if (revWalk != null) {
                revWalk.dispose();
            }
            treeWalk.release();
        }
    }

    /*
     * Exception decompiling
     */
    private PackFile writePack(Set<? extends ObjectId> want, Set<? extends ObjectId> have, Set<ObjectId> tagTargets, List<PackWriter.ObjectIdSet> excludeObjects) throws IOException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private File nameFor(String name, String ext) {
        File packdir = new File(this.repo.getObjectsDirectory(), "pack");
        return new File(packdir, "pack-" + name + ext);
    }

    public RepoStatistics getStatistics() throws IOException {
        RepoStatistics ret = new RepoStatistics();
        Collection<PackFile> packs = this.repo.getObjectDatabase().getPacks();
        for (PackFile f : packs) {
            ret.numberOfPackedObjects += f.getIndex().getObjectCount();
            ++ret.numberOfPackFiles;
            ret.sizeOfPackedObjects += f.getPackFile().length();
        }
        File objDir = this.repo.getObjectsDirectory();
        String[] fanout = objDir.list();
        if (fanout != null && fanout.length > 0) {
            for (String d : fanout) {
                File[] entries;
                if (d.length() != 2 || (entries = new File(objDir, d).listFiles()) == null) continue;
                for (File f : entries) {
                    if (f.getName().length() != 38) continue;
                    ++ret.numberOfLooseObjects;
                    ret.sizeOfLooseObjects += f.length();
                }
            }
        }
        RefDatabase refDb = this.repo.getRefDatabase();
        for (Ref r : refDb.getRefs("").values()) {
            Ref.Storage storage = r.getStorage();
            if (storage == Ref.Storage.LOOSE || storage == Ref.Storage.LOOSE_PACKED) {
                ++ret.numberOfLooseRefs;
            }
            if (storage != Ref.Storage.PACKED && storage != Ref.Storage.LOOSE_PACKED) continue;
            ++ret.numberOfPackedRefs;
        }
        return ret;
    }

    public GC setProgressMonitor(ProgressMonitor pm) {
        this.pm = pm == null ? NullProgressMonitor.INSTANCE : pm;
        return this;
    }

    public void setExpireAgeMillis(long expireAgeMillis) {
        this.expireAgeMillis = expireAgeMillis;
        this.expire = null;
    }

    public void setExpire(Date expire) {
        this.expire = expire;
        this.expireAgeMillis = -1L;
    }

    private static PackWriter.ObjectIdSet objectIdSet(final PackIndex idx) {
        return new PackWriter.ObjectIdSet(){

            public boolean contains(AnyObjectId objectId) {
                return idx.hasObject(objectId);
            }
        };
    }

    public class RepoStatistics {
        public long numberOfPackedObjects;
        public long numberOfPackFiles;
        public long numberOfLooseObjects;
        public long sizeOfLooseObjects;
        public long sizeOfPackedObjects;
        public long numberOfLooseRefs;
        public long numberOfPackedRefs;

        public String toString() {
            StringBuilder b = new StringBuilder();
            b.append("numberOfPackedObjects=").append(this.numberOfPackedObjects);
            b.append(", numberOfPackFiles=").append(this.numberOfPackFiles);
            b.append(", numberOfLooseObjects=").append(this.numberOfLooseObjects);
            b.append(", numberOfLooseRefs=").append(this.numberOfLooseRefs);
            b.append(", numberOfPackedRefs=").append(this.numberOfPackedRefs);
            b.append(", sizeOfLooseObjects=").append(this.sizeOfLooseObjects);
            b.append(", sizeOfPackedObjects=").append(this.sizeOfPackedObjects);
            return b.toString();
        }
    }
}

