/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jkube.kit.build.core;

public class GavLabel {
    private String mavenCoordinates;
    public static final String KEY = "jkube.coordinates";

    public GavLabel(String label) {
        String[] parts = label.split(":");
        if (parts.length != 3) {
            throw new IllegalArgumentException("Label '" + label + "' has not the format <group>:<artifact>:<version>");
        }
        this.mavenCoordinates = parts[0] + ":" + parts[1] + ":" + parts[2];
    }

    public GavLabel(String groupId, String artifactId, String version) {
        this.mavenCoordinates = groupId + ":" + artifactId + ":" + version;
    }

    public String getValue() {
        return this.mavenCoordinates;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        return this.mavenCoordinates.equals(((GavLabel)o).mavenCoordinates);
    }

    public int hashCode() {
        return this.mavenCoordinates.hashCode();
    }
}

