/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jkube.kit.build.core;

import java.io.File;
import java.io.IOException;
import java.io.Serializable;
import java.util.List;
import java.util.Properties;
import org.eclipse.jkube.kit.build.api.BuildContext;
import org.eclipse.jkube.kit.build.core.JKubeArchiveService;
import org.eclipse.jkube.kit.build.core.config.JKubeBuildConfiguration;
import org.eclipse.jkube.kit.common.JKubeProject;
import org.eclipse.jkube.kit.common.KitLogger;

public class JKubeBuildContext
implements BuildContext<JKubeBuildConfiguration>,
Serializable {
    private String sourceDirectory;
    private String outputDirectory;
    private JKubeProject project;
    private List<JKubeProject> reactorProjects;
    private transient JKubeArchiveService archiveService;

    private JKubeBuildContext() {
    }

    public String getSourceDirectory() {
        return this.sourceDirectory;
    }

    public String getOutputDirectory() {
        return this.outputDirectory;
    }

    public File getBasedir() {
        return this.project.getBaseDirectory();
    }

    public Properties getProperties() {
        return this.project.getProperties();
    }

    public File createImageContentArchive(String imageName, JKubeBuildConfiguration buildConfig, KitLogger log) throws IOException {
        try {
            return this.archiveService.createArchive(imageName, buildConfig, this, log);
        }
        catch (Exception e) {
            throw new IOException(e.getMessage());
        }
    }

    public File inOutputDir(String path) {
        return this.inDir(this.getOutputDirectory(), path);
    }

    public File inSourceDir(String path) {
        return this.inDir(this.getSourceDirectory(), path);
    }

    public File inDir(String dir, String path) {
        File file = new File(path);
        if (file.isAbsolute()) {
            return file;
        }
        File absoluteSourceDir = new File(this.getBasedir(), dir);
        return new File(absoluteSourceDir, path);
    }

    public JKubeProject getProject() {
        return this.project;
    }

    public List<JKubeProject> getReactorProjects() {
        return this.reactorProjects;
    }

    public static class Builder {
        private JKubeBuildContext context;

        public Builder() {
            this.context = new JKubeBuildContext();
        }

        public Builder(JKubeBuildContext context) {
            this.context = context;
        }

        public Builder sourceDirectory(String sourceDirectory) {
            this.context.sourceDirectory = sourceDirectory;
            return this;
        }

        public Builder outputDirectory(String outputDirectory) {
            this.context.outputDirectory = outputDirectory;
            return this;
        }

        public Builder project(JKubeProject project) {
            this.context.project = project;
            return this;
        }

        public Builder reactorProjects(List<JKubeProject> reactorProjects) {
            this.context.reactorProjects = reactorProjects;
            return this;
        }

        public Builder archiveService(JKubeArchiveService archiveService) {
            this.context.archiveService = archiveService;
            return this;
        }

        public JKubeBuildContext build() {
            return this.context;
        }
    }
}

