/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jkube.kit.build.core.assembly;

import java.io.File;
import org.eclipse.jkube.kit.build.core.JKubeBuildContext;
import org.eclipse.jkube.kit.common.util.EnvUtil;

class BuildDirs {
    private final String buildTopDir;
    private final JKubeBuildContext params;

    BuildDirs(String imageName, JKubeBuildContext params) {
        this.params = params;
        this.buildTopDir = imageName != null ? imageName.replace(':', '/') : null;
    }

    File getOutputDirectory() {
        return this.getDir("build");
    }

    File getWorkingDirectory() {
        return this.getDir("work");
    }

    File getTemporaryRootDirectory() {
        return this.getDir("tmp");
    }

    void createDirs() {
        for (String workDir : new String[]{"build", "work", "tmp"}) {
            File dir = this.getDir(workDir);
            if (dir.exists() || dir.mkdirs()) continue;
            throw new IllegalArgumentException("Cannot create directory " + dir.getAbsolutePath());
        }
    }

    private File getDir(String dir) {
        return EnvUtil.prepareAbsoluteOutputDirPath((String)this.params.getOutputDirectory(), (String)(this.params.getProject().getBaseDirectory() != null ? this.params.getProject().getBaseDirectory().toString() : null), (String)this.buildTopDir, (String)dir);
    }
}

