/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jkube.kit.build.core.assembly;

import java.io.File;
import java.util.List;
import org.eclipse.jkube.kit.build.core.JKubeBuildContext;
import org.eclipse.jkube.kit.build.core.assembly.BuildDirs;
import org.eclipse.jkube.kit.build.core.config.JKubeAssemblyConfiguration;
import org.eclipse.jkube.kit.common.JKubeProject;
import org.eclipse.jkube.kit.config.image.build.AssemblyConfiguration;

public class DockerAssemblyConfigurationSource {
    private final JKubeAssemblyConfiguration assemblyConfig;
    private final JKubeBuildContext context;
    private final BuildDirs buildDirs;

    public DockerAssemblyConfigurationSource(JKubeBuildContext context, BuildDirs buildDirs, JKubeAssemblyConfiguration assemblyConfig) {
        this.context = context;
        this.assemblyConfig = assemblyConfig;
        this.buildDirs = buildDirs;
    }

    public String[] getDescriptors() {
        String descriptor;
        if (this.assemblyConfig != null && (descriptor = this.assemblyConfig.getDescriptor()) != null) {
            return new String[]{this.context.inSourceDir(descriptor).getAbsolutePath()};
        }
        return new String[0];
    }

    public String[] getDescriptorReferences() {
        String descriptorRef;
        if (this.assemblyConfig != null && (descriptorRef = this.assemblyConfig.getDescriptorRef()) != null) {
            return new String[]{descriptorRef};
        }
        return new String[0];
    }

    public File getOutputDirectory() {
        return this.buildDirs.getOutputDirectory();
    }

    public File getWorkingDirectory() {
        return this.buildDirs.getWorkingDirectory();
    }

    public File getTemporaryRootDirectory() {
        return this.buildDirs.getTemporaryRootDirectory();
    }

    public List<JKubeProject> getReactorProjects() {
        return this.context.getReactorProjects();
    }

    public String getEncoding() {
        return this.context.getProject().getProperties().getProperty("project.build.sourceEncoding");
    }

    public JKubeProject getProject() {
        return this.context.getProject();
    }

    public File getBasedir() {
        return this.context.getProject().getBaseDirectory();
    }

    public boolean isIgnorePermissions() {
        return this.assemblyConfig != null && this.assemblyConfig.getPermissions() != null && this.assemblyConfig.getPermissions() == AssemblyConfiguration.PermissionMode.ignore;
    }
}

