/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jkube.kit.build.core.assembly;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.nio.file.StandardCopyOption;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.eclipse.jkube.kit.build.core.JKubeBuildContext;
import org.eclipse.jkube.kit.build.core.assembly.ArchiverCustomizer;
import org.eclipse.jkube.kit.build.core.assembly.AssemblyFiles;
import org.eclipse.jkube.kit.build.core.assembly.BuildDirs;
import org.eclipse.jkube.kit.build.core.assembly.DockerAssemblyConfigurationSource;
import org.eclipse.jkube.kit.build.core.assembly.JKubeAssemblyConfigurationUtils;
import org.eclipse.jkube.kit.build.core.assembly.JKubeTarArchiver;
import org.eclipse.jkube.kit.build.core.config.JKubeAssemblyConfiguration;
import org.eclipse.jkube.kit.build.core.config.JKubeBuildConfiguration;
import org.eclipse.jkube.kit.build.service.docker.helper.DockerFileUtil;
import org.eclipse.jkube.kit.common.JKubeAssemblyFile;
import org.eclipse.jkube.kit.common.JKubeAssemblyFileSet;
import org.eclipse.jkube.kit.common.JKubeProject;
import org.eclipse.jkube.kit.common.KitLogger;
import org.eclipse.jkube.kit.common.util.FileUtil;
import org.eclipse.jkube.kit.common.util.JKubeProjectUtil;
import org.eclipse.jkube.kit.config.image.build.ArchiveCompression;
import org.eclipse.jkube.kit.config.image.build.AssemblyConfiguration;
import org.eclipse.jkube.kit.config.image.build.AssemblyMode;
import org.eclipse.jkube.kit.config.image.build.BuildConfiguration;
import org.eclipse.jkube.kit.config.image.build.DockerFileBuilder;

public class DockerAssemblyManager {
    private static DockerAssemblyManager dockerAssemblyManager = null;
    public static final String DEFAULT_DATA_BASE_IMAGE = "busybox:latest";
    public static final String SCRATCH_IMAGE = "scratch";
    public static final String DOCKER_IGNORE = ".maven-dockerignore";
    public static final String DOCKER_EXCLUDE = ".maven-dockerexclude";
    public static final String DOCKER_INCLUDE = ".maven-dockerinclude";
    public static final String DOCKERFILE_NAME = "Dockerfile";

    private DockerAssemblyManager() {
    }

    public static DockerAssemblyManager getInstance() {
        if (dockerAssemblyManager == null) {
            dockerAssemblyManager = new DockerAssemblyManager();
        }
        return dockerAssemblyManager;
    }

    public File createDockerTarArchive(String imageName, JKubeBuildContext params, JKubeBuildConfiguration buildConfig, KitLogger log) throws IOException {
        return this.createDockerTarArchive(imageName, params, buildConfig, log, null);
    }

    public File createDockerTarArchive(String imageName, JKubeBuildContext params, JKubeBuildConfiguration buildConfig, KitLogger log, ArchiverCustomizer finalCustomizer) throws IOException {
        final BuildDirs buildDirs = DockerAssemblyManager.createBuildDirs(imageName, params);
        Map<File, String> fileToPermissionsMap = this.copyFilesToFinalTarballDirectory(params.getProject(), buildDirs, (JKubeAssemblyConfiguration)buildConfig.getAssemblyConfiguration());
        final JKubeAssemblyConfiguration assemblyConfig = JKubeAssemblyConfigurationUtils.getAssemblyConfigurationOrCreateDefault(buildConfig);
        ArrayList<ArchiverCustomizer> archiveCustomizers = new ArrayList<ArchiverCustomizer>();
        if (DockerAssemblyManager.hasAssemblyConfiguration(assemblyConfig)) {
            this.createAssemblyArchive(assemblyConfig, params, buildDirs, buildConfig.getCompression());
        }
        try {
            if (buildConfig.isDockerFileMode()) {
                final File dockerFile = buildConfig.getAbsoluteDockerFilePath(params.getSourceDirectory(), params.getProject().getBaseDirectory().toString());
                if (!dockerFile.exists()) {
                    throw new IOException("Configured Dockerfile \"" + buildConfig.getDockerFile() + "\" (resolved to \"" + dockerFile + "\") doesn't exist");
                }
                this.verifyGivenDockerfile(dockerFile, buildConfig, params.getProperties(), log);
                this.interpolateDockerfile(dockerFile, buildDirs, params.getProperties());
                archiveCustomizers.add(new ArchiverCustomizer(){

                    @Override
                    public JKubeTarArchiver customize(JKubeTarArchiver archiver) {
                        if (DockerAssemblyManager.isArchive(assemblyConfig)) {
                            String name = dockerFile.getName();
                            archiver.includeFile(new File(buildDirs.getOutputDirectory(), name), name);
                        }
                        return archiver;
                    }
                });
            } else {
                DockerFileBuilder builder = this.createDockerFileBuilder(buildConfig, assemblyConfig);
                builder.write(buildDirs.getOutputDirectory());
                File dockerFile = new File(buildDirs.getOutputDirectory(), DOCKERFILE_NAME);
                archiveCustomizers.add(archiver -> {
                    archiver.includeFile(dockerFile, DOCKERFILE_NAME);
                    return archiver;
                });
            }
            if (finalCustomizer != null) {
                archiveCustomizers.add(finalCustomizer);
            }
            archiveCustomizers.add(archiver -> {
                File finalArtifactFile = JKubeProjectUtil.getFinalOutputArtifact((JKubeProject)params.getProject());
                if (finalArtifactFile != null) {
                    archiver.includeFile(finalArtifactFile, (assemblyConfig != null ? assemblyConfig.getName() : "maven") + File.separator + finalArtifactFile.getName());
                }
                return archiver;
            });
            List<String> filesToExclude = JKubeAssemblyConfigurationUtils.getJKubeAssemblyFileSetsExcludes((JKubeAssemblyConfiguration)buildConfig.getAssemblyConfiguration());
            archiveCustomizers.add(archiver -> {
                filesToExclude.forEach(archiver::excludeFile);
                fileToPermissionsMap.forEach(archiver::setFilePermissions);
                return archiver;
            });
            return this.createBuildTarBall(params, buildDirs, archiveCustomizers, assemblyConfig, buildConfig.getCompression());
        }
        catch (IOException e) {
            throw new IOException(String.format("Cannot create %s in %s", DOCKERFILE_NAME, buildDirs.getOutputDirectory()), e);
        }
    }

    private void interpolateDockerfile(File dockerFile, BuildDirs params, Properties properties) throws IOException {
        File targetDockerfile = new File(params.getOutputDirectory(), dockerFile.getName());
        String dockerFileInterpolated = DockerFileUtil.interpolate(dockerFile, properties);
        try (BufferedWriter writer = new BufferedWriter(new FileWriter(targetDockerfile));){
            writer.write(dockerFileInterpolated);
        }
    }

    void verifyGivenDockerfile(File dockerFile, BuildConfiguration buildConfig, Properties properties, KitLogger log) throws IOException {
        AssemblyConfiguration assemblyConfig = buildConfig.getAssemblyConfiguration();
        if (assemblyConfig == null) {
            return;
        }
        String name = assemblyConfig.getName();
        for (String keyword : new String[]{"ADD", "COPY"}) {
            List<String[]> lines = DockerFileUtil.extractLines(dockerFile, keyword, properties);
            for (String[] line : lines) {
                String component;
                int i;
                if (line[0].startsWith("#")) continue;
                for (i = 1; i < line.length && (component = line[i]).startsWith("--"); ++i) {
                }
                if (i >= line.length || !line[i].contains(name)) continue;
                return;
            }
        }
        log.warn("Dockerfile %s does not contain an ADD or COPY directive to include assembly created at %s. Ignoring assembly.", new Object[]{dockerFile.getPath(), name});
    }

    public AssemblyFiles getAssemblyFiles(String name, JKubeBuildConfiguration buildConfig, JKubeBuildContext mojoParams, KitLogger log) {
        BuildDirs buildDirs = DockerAssemblyManager.createBuildDirs(name, mojoParams);
        JKubeAssemblyConfiguration assemblyConfig = (JKubeAssemblyConfiguration)buildConfig.getAssemblyConfiguration();
        String assemblyName = assemblyConfig.getName();
        AssemblyFiles assemblyFiles = new AssemblyFiles(buildDirs.getOutputDirectory());
        File finalOutputArtifact = JKubeProjectUtil.getFinalOutputArtifact((JKubeProject)mojoParams.getProject());
        if (finalOutputArtifact != null) {
            assemblyFiles.addEntry(finalOutputArtifact, new File(buildDirs.getOutputDirectory().getAbsolutePath() + File.separator + assemblyName, finalOutputArtifact.getName()));
        }
        return assemblyFiles;
    }

    public File createChangedFilesArchive(List<AssemblyFiles.Entry> entries, File assemblyDirectory, String imageName, JKubeBuildContext mojoParameters) throws IOException {
        BuildDirs dirs = DockerAssemblyManager.createBuildDirs(imageName, mojoParameters);
        try {
            File archive = new File(dirs.getTemporaryRootDirectory(), "changed-files.tar");
            File archiveDir = this.createArchiveDir(dirs);
            for (AssemblyFiles.Entry entry : entries) {
                File dest = this.prepareChangedFilesArchivePath(archiveDir, entry.getDestFile(), assemblyDirectory);
                Files.copy(Paths.get(entry.getSrcFile().getAbsolutePath(), new String[0]), Paths.get(dest.getAbsolutePath(), new String[0]), new CopyOption[0]);
            }
            return new JKubeTarArchiver().createTarBallOfDirectory(archive, archiveDir, ArchiveCompression.none);
        }
        catch (IOException exp) {
            throw new IOException("Error while creating " + dirs.getTemporaryRootDirectory() + "/changed-files.tar: " + exp);
        }
    }

    private File prepareChangedFilesArchivePath(File archiveDir, File destFile, File assemblyDir) throws IOException {
        String relativePath = FileUtil.getRelativeFilePath((String)assemblyDir.getCanonicalPath(), (String)destFile.getCanonicalPath());
        return new File(archiveDir, relativePath);
    }

    private File createBuildTarBall(JKubeBuildContext params, BuildDirs buildDirs, List<ArchiverCustomizer> archiverCustomizers, JKubeAssemblyConfiguration assemblyConfig, ArchiveCompression compression) throws IOException {
        DockerAssemblyConfigurationSource source = new DockerAssemblyConfigurationSource(params, buildDirs, assemblyConfig);
        JKubeTarArchiver jkubeTarArchiver = new JKubeTarArchiver();
        for (ArchiverCustomizer customizer : archiverCustomizers) {
            if (customizer == null) continue;
            jkubeTarArchiver = customizer.customize(jkubeTarArchiver);
        }
        return jkubeTarArchiver.createArchive(source.getOutputDirectory(), buildDirs, compression);
    }

    private File createArchiveDir(BuildDirs dirs) throws IOException {
        File archiveDir = new File(dirs.getTemporaryRootDirectory(), "changed-files");
        if (archiveDir.exists()) {
            FileUtil.cleanDirectory((File)archiveDir);
        } else if (!archiveDir.mkdir()) {
            throw new IOException("Cannot create " + archiveDir);
        }
        return archiveDir;
    }

    DockerFileBuilder createDockerFileBuilder(BuildConfiguration buildConfig, AssemblyConfiguration assemblyConfig) {
        DockerFileBuilder builder = new DockerFileBuilder().env(buildConfig.getEnv()).labels(buildConfig.getLabels()).expose(buildConfig.getPorts()).run(buildConfig.getRunCmds()).volumes(buildConfig.getVolumes()).user(buildConfig.getUser());
        if (buildConfig.getMaintainer() != null) {
            builder.maintainer(buildConfig.getMaintainer());
        }
        if (buildConfig.getWorkdir() != null) {
            builder.workdir(buildConfig.getWorkdir());
        }
        if (assemblyConfig != null) {
            builder.add(assemblyConfig.getName(), "").basedir(assemblyConfig.getTargetDir()).assemblyUser(assemblyConfig.getUser()).exportTargetDir(assemblyConfig.exportTargetDir());
        } else {
            builder.exportTargetDir(Boolean.valueOf(false));
        }
        builder.baseImage(buildConfig.getFrom());
        if (buildConfig.getHealthCheck() != null) {
            builder.healthCheck(buildConfig.getHealthCheck());
        }
        if (buildConfig.getCmd() != null) {
            builder.cmd(buildConfig.getCmd());
        }
        if (buildConfig.getEntryPoint() != null) {
            builder.entryPoint(buildConfig.getEntryPoint());
        }
        if (buildConfig.optimise()) {
            builder.optimise();
        }
        return builder;
    }

    private void createAssemblyArchive(JKubeAssemblyConfiguration assemblyConfig, JKubeBuildContext params, BuildDirs buildDirs, ArchiveCompression compression) throws IOException {
        DockerAssemblyConfigurationSource source = new DockerAssemblyConfigurationSource(params, buildDirs, assemblyConfig);
        JKubeTarArchiver jkubeTarArchiver = new JKubeTarArchiver();
        Map<File, String> fileToPermissionsMap = this.copyFilesToFinalTarballDirectory(params.getProject(), buildDirs, assemblyConfig);
        AssemblyMode buildMode = assemblyConfig.getMode();
        File originalArtifactFile = null;
        try {
            originalArtifactFile = this.ensureThatArtifactFileIsSet(params.getProject());
            fileToPermissionsMap.forEach(jkubeTarArchiver::setFilePermissions);
            jkubeTarArchiver.createArchive(source.getOutputDirectory(), buildDirs, compression);
        }
        catch (IOException e) {
            String error = "Failed to create assembly for docker image  (with mode '" + buildMode + "'): " + e.getMessage() + ".";
            if (params.getProject().getArtifact() == null) {
                error = error + " If you include the build artifact please ensure that you have built the artifact before with 'mvn package' (should be available in the target/ dir). Please see the documentation (section \"Assembly\") for more information.";
            }
            throw new IOException(error, e);
        }
        finally {
            this.setArtifactFile(params.getProject(), originalArtifactFile);
        }
    }

    private File ensureThatArtifactFileIsSet(JKubeProject project) throws IOException {
        File artifact = project.getArtifact();
        if (artifact == null) {
            return null;
        }
        File oldFile = artifact;
        if (oldFile != null) {
            return oldFile;
        }
        String finalName = project.getBuildFinalName();
        String target = project.getBuildDirectory();
        if (finalName == null || target == null) {
            return null;
        }
        File artifactFile = new File(target, finalName + "." + project.getPackaging());
        if (artifactFile.exists() && artifactFile.isFile()) {
            this.setArtifactFile(project, artifactFile);
        }
        return null;
    }

    private void setArtifactFile(JKubeProject project, File artifactFile) throws IOException {
        File artifact = project.getArtifact();
        if (artifact != null && artifactFile != null) {
            Files.copy(Paths.get(artifactFile.getAbsolutePath(), new String[0]), Paths.get(artifact.getAbsolutePath(), new String[0]), StandardCopyOption.REPLACE_EXISTING);
        }
    }

    private Map<File, String> copyFilesToFinalTarballDirectory(JKubeProject project, BuildDirs buildDirs, JKubeAssemblyConfiguration assemblyConfiguration) throws IOException {
        HashMap<File, String> filesToPermissionsMap = new HashMap<File, String>();
        FileUtil.createDirectory((File)new File(buildDirs.getOutputDirectory(), assemblyConfiguration.getName()));
        for (JKubeAssemblyFileSet fileSet : JKubeAssemblyConfigurationUtils.getJKubeAssemblyFileSets(assemblyConfiguration)) {
            filesToPermissionsMap.putAll(this.processJKubeProjectAssemblyFileSet(project, fileSet, buildDirs, assemblyConfiguration));
        }
        for (JKubeAssemblyFile file : JKubeAssemblyConfigurationUtils.getJKubeAssemblyFiles(assemblyConfiguration)) {
            this.processJKubeProjectAssemblyFile(project, file, buildDirs, assemblyConfiguration);
        }
        return filesToPermissionsMap;
    }

    private Map<File, String> processJKubeProjectAssemblyFileSet(JKubeProject project, JKubeAssemblyFileSet jkubeProjectAssemblyFileSet, BuildDirs buildDirs, JKubeAssemblyConfiguration jkubeProjectAssemblyConfiguration) throws IOException {
        HashMap<File, String> fileToPermissionsMap = new HashMap<File, String>();
        for (String relativePathInclude : jkubeProjectAssemblyFileSet.getIncludes()) {
            File assemblyFileSetOutputDirectory = new File(jkubeProjectAssemblyFileSet.getDirectory());
            File sourceFile = new File(assemblyFileSetOutputDirectory.isAbsolute() ? assemblyFileSetOutputDirectory : new File(project.getBaseDirectory() + File.separator + jkubeProjectAssemblyFileSet.getDirectory()), FileUtil.trimWildcardCharactersFromPath((String)relativePathInclude));
            File destParentFile = new File(buildDirs.getOutputDirectory() + File.separator + jkubeProjectAssemblyConfiguration.getName());
            if (jkubeProjectAssemblyFileSet.getOutputDirectory() != null && !jkubeProjectAssemblyFileSet.getOutputDirectory().equalsIgnoreCase(".")) {
                destParentFile = new File(buildDirs.getOutputDirectory() + File.separator + jkubeProjectAssemblyConfiguration.getName() + File.separator + jkubeProjectAssemblyFileSet.getOutputDirectory());
            }
            FileUtil.createDirectory((File)destParentFile);
            File destFile = new File(destParentFile, sourceFile.getName());
            if (!sourceFile.exists()) continue;
            if (sourceFile.isDirectory()) {
                FileUtil.copyDirectory((File)sourceFile, (File)destFile);
            } else {
                FileUtil.copy((File)sourceFile, (File)destFile);
            }
            fileToPermissionsMap.put(destFile, jkubeProjectAssemblyFileSet.getFileMode());
        }
        return fileToPermissionsMap;
    }

    private void processJKubeProjectAssemblyFile(JKubeProject project, JKubeAssemblyFile assemblyFile, BuildDirs buildDirs, JKubeAssemblyConfiguration assemblyConfiguration) throws IOException {
        File outputDirectory = new File(assemblyFile.getOutputDirectory()).isAbsolute() ? new File(assemblyFile.getOutputDirectory()) : buildDirs.getOutputDirectory().toPath().resolve(assemblyConfiguration.getName()).resolve(assemblyFile.getOutputDirectory()).toFile();
        File sourceFile = new File(assemblyFile.getSource()).isAbsolute() ? new File(assemblyFile.getSource()) : new File(project.getBaseDirectory(), assemblyFile.getSource());
        FileUtil.createDirectory((File)outputDirectory);
        File destinationFile = new File(outputDirectory, sourceFile.getName());
        FileUtil.copy((File)sourceFile, (File)destinationFile);
    }

    private static BuildDirs createBuildDirs(String imageName, JKubeBuildContext params) {
        BuildDirs buildDirs = new BuildDirs(imageName, params);
        buildDirs.createDirs();
        return buildDirs;
    }

    private static boolean hasAssemblyConfiguration(JKubeAssemblyConfiguration assemblyConfig) {
        return assemblyConfig != null && (assemblyConfig.getInline() != null || assemblyConfig.getDescriptor() != null || assemblyConfig.getDescriptorRef() != null);
    }

    private static boolean isArchive(JKubeAssemblyConfiguration assemblyConfig) {
        return DockerAssemblyManager.hasAssemblyConfiguration(assemblyConfig) && assemblyConfig.getMode() != null && assemblyConfig.getMode().isArchive();
    }
}

