/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jkube.kit.build.core.assembly;

import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.compress.archivers.ArchiveEntry;
import org.apache.commons.compress.archivers.tar.TarArchiveEntry;
import org.apache.commons.compress.archivers.tar.TarArchiveOutputStream;
import org.apache.commons.compress.compressors.bzip2.BZip2CompressorOutputStream;
import org.apache.commons.compress.compressors.gzip.GzipCompressorOutputStream;
import org.apache.commons.compress.utils.IOUtils;
import org.apache.commons.io.FileUtils;
import org.eclipse.jkube.kit.build.core.assembly.BuildDirs;
import org.eclipse.jkube.kit.common.util.FileUtil;
import org.eclipse.jkube.kit.config.image.build.ArchiveCompression;

public class JKubeTarArchiver {
    private Map<File, String> filesToIncludeNameMap = new HashMap<File, String>();
    private Map<File, String> fileToPermissionsMap = new HashMap<File, String>();
    private List<String> filesNamesToExclude = new ArrayList<String>();

    public void includeFile(File inputFile, String destinationFileName) {
        this.filesToIncludeNameMap.put(inputFile, destinationFileName);
    }

    public void setFilePermissions(File file, String permissions) {
        this.fileToPermissionsMap.put(file, permissions);
    }

    public void excludeFile(String inputFilePath) {
        this.filesNamesToExclude.add(inputFilePath);
    }

    public Map<File, String> getFilesToIncludeNameMap() {
        return this.filesToIncludeNameMap;
    }

    public List<String> getFilesNamesToExcludeName() {
        return this.filesNamesToExclude;
    }

    public File createArchive(File inputDirectory, BuildDirs buildDirs, ArchiveCompression compression) throws IOException {
        File outputFile = new File(buildDirs.getTemporaryRootDirectory(), "docker-build." + (compression.equals((Object)ArchiveCompression.none) ? "tar" : compression.getFileSuffix()));
        List files = FileUtil.listFilesRecursivelyInDirectory((File)inputDirectory);
        if (!this.filesToIncludeNameMap.isEmpty()) {
            for (Map.Entry<File, String> entry : this.filesToIncludeNameMap.entrySet()) {
                File targetFile;
                File srcFile = entry.getKey();
                String targetFileName = entry.getValue();
                String[] pathParts = targetFileName.split(File.separator);
                File parentDirectory = inputDirectory;
                if (pathParts.length > 0) {
                    StringBuilder finalPathBuilder = new StringBuilder();
                    for (int i = 0; i < pathParts.length - 1; ++i) {
                        String pathPart = pathParts[i];
                        finalPathBuilder.append(pathPart + File.separator);
                    }
                    parentDirectory = new File(inputDirectory, finalPathBuilder.toString());
                    parentDirectory.mkdirs();
                }
                if ((targetFile = new File(parentDirectory, pathParts[pathParts.length - 1])).exists()) continue;
                FileUtils.copyFile((File)srcFile, (File)targetFile);
                files.add(targetFile);
            }
        }
        ArrayList<File> fileListToAddInTarball = new ArrayList<File>();
        for (int i = 0; i < files.size(); ++i) {
            File currentFile = (File)files.get(i);
            if (this.filesNamesToExclude.contains(currentFile.getName())) continue;
            fileListToAddInTarball.add(currentFile);
        }
        return this.createTarBall(outputFile, inputDirectory, fileListToAddInTarball, compression);
    }

    public File createTarBallOfDirectory(File outputFile, File inputDirectory, ArchiveCompression compression) throws IOException {
        return this.createTarBall(outputFile, inputDirectory, FileUtil.listFilesRecursivelyInDirectory((File)inputDirectory), compression);
    }

    public File createTarBall(File outputFile, File inputDirectory, List<File> fileList, ArchiveCompression compression) throws IOException {
        try (FileOutputStream fileOutputStream = new FileOutputStream(outputFile);
             BufferedOutputStream bufferedOutputStream = new BufferedOutputStream(fileOutputStream);){
            TarArchiveOutputStream tarArchiveOutputStream = null;
            tarArchiveOutputStream = compression.equals((Object)ArchiveCompression.gzip) ? new TarArchiveOutputStream((OutputStream)new GzipCompressorOutputStream((OutputStream)bufferedOutputStream)) : (compression.equals((Object)ArchiveCompression.bzip2) ? new TarArchiveOutputStream((OutputStream)new BZip2CompressorOutputStream((OutputStream)bufferedOutputStream)) : new TarArchiveOutputStream((OutputStream)bufferedOutputStream));
            tarArchiveOutputStream.setBigNumberMode(2);
            tarArchiveOutputStream.setLongFileMode(2);
            for (File currentFile : fileList) {
                String relativeFilePath = inputDirectory.toURI().relativize(new File(currentFile.getAbsolutePath()).toURI()).getPath();
                TarArchiveEntry tarEntry = new TarArchiveEntry(currentFile, relativeFilePath);
                tarEntry.setSize(currentFile.length());
                if (this.fileToPermissionsMap.containsKey(currentFile)) {
                    tarEntry.setMode(Integer.parseInt(this.fileToPermissionsMap.get(currentFile), 8));
                }
                tarArchiveOutputStream.putArchiveEntry((ArchiveEntry)tarEntry);
                tarArchiveOutputStream.setLongFileMode(3);
                tarArchiveOutputStream.write(IOUtils.toByteArray((InputStream)new FileInputStream(currentFile)));
                tarArchiveOutputStream.closeArchiveEntry();
            }
            tarArchiveOutputStream.close();
        }
        return outputFile;
    }
}

