/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jkube.kit.build.service.docker;

import java.io.File;
import java.io.IOException;
import java.util.List;
import org.eclipse.jkube.kit.build.core.JKubeBuildContext;
import org.eclipse.jkube.kit.build.core.assembly.ArchiverCustomizer;
import org.eclipse.jkube.kit.build.core.assembly.AssemblyFiles;
import org.eclipse.jkube.kit.build.core.assembly.DockerAssemblyManager;
import org.eclipse.jkube.kit.build.core.config.JKubeBuildConfiguration;
import org.eclipse.jkube.kit.build.service.docker.ImageConfiguration;
import org.eclipse.jkube.kit.common.KitLogger;

public class ArchiveService {
    private final KitLogger log;
    private DockerAssemblyManager dockerAssemblyManager;

    public ArchiveService(DockerAssemblyManager dockerAssemblyManager, KitLogger log) {
        this.log = log;
        this.dockerAssemblyManager = dockerAssemblyManager;
    }

    public File createDockerBuildArchive(ImageConfiguration imageConfig, JKubeBuildContext params) throws IOException {
        return this.createDockerBuildArchive(imageConfig, params, null);
    }

    public File createDockerBuildArchive(ImageConfiguration imageConfig, JKubeBuildContext params, ArchiverCustomizer customizer) throws IOException {
        File ret = this.createArchive(imageConfig.getName(), imageConfig.getBuildConfiguration(), params, this.log, customizer);
        this.log.info("%s: Created docker source tar %s", new Object[]{imageConfig.getDescription(), ret});
        return ret;
    }

    public AssemblyFiles getAssemblyFiles(ImageConfiguration imageConfig, JKubeBuildContext mojoParameters) throws IOException {
        String name = imageConfig.getName();
        try {
            return this.dockerAssemblyManager.getAssemblyFiles(name, imageConfig.getBuildConfiguration(), mojoParameters, this.log);
        }
        catch (Exception e) {
            throw new IOException("Cannot extract assembly files for image " + name + ": " + e, e);
        }
    }

    public File createChangedFilesArchive(List<AssemblyFiles.Entry> entries, File assemblyDir, String imageName, JKubeBuildContext mojoParameters) throws IOException {
        return this.dockerAssemblyManager.createChangedFilesArchive(entries, assemblyDir, imageName, mojoParameters);
    }

    File createArchive(String imageName, JKubeBuildConfiguration buildConfig, JKubeBuildContext params, KitLogger log) throws IOException {
        return this.createArchive(imageName, buildConfig, params, log, null);
    }

    File createArchive(String imageName, JKubeBuildConfiguration buildConfig, JKubeBuildContext params, KitLogger log, ArchiverCustomizer customizer) throws IOException {
        return this.dockerAssemblyManager.createDockerTarArchive(imageName, params, buildConfig, log, customizer);
    }
}

