/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jkube.kit.build.service.docker;

import java.io.IOException;
import java.io.Serializable;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import org.eclipse.jkube.kit.build.service.docker.access.DockerAccess;
import org.eclipse.jkube.kit.build.service.docker.access.DockerConnectionDetector;
import org.eclipse.jkube.kit.build.service.docker.access.DockerMachine;
import org.eclipse.jkube.kit.build.service.docker.access.hc.DockerAccessWithHcClient;
import org.eclipse.jkube.kit.build.service.docker.config.DockerMachineConfiguration;
import org.eclipse.jkube.kit.common.KitLogger;

public class DockerAccessFactory {
    public DockerAccess createDockerAccess(DockerAccessContext dockerAccessContext) {
        try {
            DockerConnectionDetector dockerConnectionDetector = this.createDockerConnectionDetector(dockerAccessContext, dockerAccessContext.getLog());
            DockerConnectionDetector.ConnectionParameter connectionParam = dockerConnectionDetector.detectConnectionParameter(dockerAccessContext.getDockerHost(), dockerAccessContext.getCertPath());
            DockerAccessWithHcClient access = new DockerAccessWithHcClient(connectionParam.getUrl(), connectionParam.getCertPath(), dockerAccessContext.getMaxConnections(), dockerAccessContext.getLog());
            access.start();
            this.setDockerHostAddressProperty(dockerAccessContext, connectionParam.getUrl());
            return access;
        }
        catch (IOException e) {
            throw new IllegalStateException("Cannot create docker access object ", e);
        }
    }

    private DockerConnectionDetector createDockerConnectionDetector(DockerAccessContext dockerAccessContext, KitLogger log) {
        return new DockerConnectionDetector(this.getDockerHostProviders(dockerAccessContext, log));
    }

    private List<DockerConnectionDetector.DockerHostProvider> getDockerHostProviders(DockerAccessContext dockerAccessContext, KitLogger log) {
        if (dockerAccessContext.getDockerHostProviders() != null) {
            return dockerAccessContext.getDockerHostProviders();
        }
        return this.getDefaultDockerHostProviders(dockerAccessContext, log);
    }

    private List<DockerConnectionDetector.DockerHostProvider> getDefaultDockerHostProviders(DockerAccessContext dockerAccessContext, KitLogger log) {
        Properties projectProps;
        DockerMachineConfiguration config = dockerAccessContext.getMachine();
        if (dockerAccessContext.isSkipMachine()) {
            config = null;
        } else if (config == null && (projectProps = dockerAccessContext.getProjectProperties()).containsKey("docker.machine.name")) {
            config = new DockerMachineConfiguration(projectProps.getProperty("docker.machine.name"), projectProps.getProperty("docker.machine.autoCreate"), projectProps.getProperty("docker.machine.regenerateCertsAfterStart"));
        }
        ArrayList<DockerConnectionDetector.DockerHostProvider> ret = new ArrayList<DockerConnectionDetector.DockerHostProvider>();
        ret.add(new DockerMachine(log, config));
        return ret;
    }

    private void setDockerHostAddressProperty(DockerAccessContext dockerAccessContext, String dockerUrl) {
        Properties props = dockerAccessContext.getProjectProperties();
        if (props.getProperty("docker.host.address") == null) {
            String host;
            try {
                URI uri = new URI(dockerUrl);
                host = uri.getHost() == null && (uri.getScheme().equals("unix") || uri.getScheme().equals("npipe")) ? "localhost" : uri.getHost();
            }
            catch (URISyntaxException e) {
                throw new IllegalStateException("Cannot parse " + dockerUrl + " as URI: " + e.getMessage(), e);
            }
            props.setProperty("docker.host.address", host == null ? "" : host);
        }
    }

    public static class DockerAccessContext
    implements Serializable {
        private Properties projectProperties;
        private DockerMachineConfiguration machine;
        private List<DockerConnectionDetector.DockerHostProvider> dockerHostProviders;
        private boolean skipMachine;
        private String minimalApiVersion;
        private String dockerHost;
        private String certPath;
        private int maxConnections;
        private KitLogger log;

        public Properties getProjectProperties() {
            return this.projectProperties;
        }

        public DockerMachineConfiguration getMachine() {
            return this.machine;
        }

        public List<DockerConnectionDetector.DockerHostProvider> getDockerHostProviders() {
            return this.dockerHostProviders;
        }

        public boolean isSkipMachine() {
            return this.skipMachine;
        }

        public String getMinimalApiVersion() {
            return this.minimalApiVersion;
        }

        public String getDockerHost() {
            return this.dockerHost;
        }

        public String getCertPath() {
            return this.certPath;
        }

        public int getMaxConnections() {
            return this.maxConnections;
        }

        public KitLogger getLog() {
            return this.log;
        }

        public static class Builder {
            private DockerAccessContext context = new DockerAccessContext();

            public Builder() {
                this.context = new DockerAccessContext();
            }

            public Builder(DockerAccessContext context) {
                this.context = context;
            }

            public Builder projectProperties(Properties projectProperties) {
                this.context.projectProperties = projectProperties;
                return this;
            }

            public Builder machine(DockerMachineConfiguration machine) {
                this.context.machine = machine;
                return this;
            }

            public Builder dockerHostProviders(List<DockerConnectionDetector.DockerHostProvider> dockerHostProviders) {
                this.context.dockerHostProviders = dockerHostProviders;
                return this;
            }

            public Builder skipMachine(boolean skipMachine) {
                this.context.skipMachine = skipMachine;
                return this;
            }

            public Builder minimalApiVersion(String minimalApiVersion) {
                this.context.minimalApiVersion = minimalApiVersion;
                return this;
            }

            public Builder dockerHost(String dockerHost) {
                this.context.dockerHost = dockerHost;
                return this;
            }

            public Builder certPath(String certPath) {
                this.context.certPath = certPath;
                return this;
            }

            public Builder maxConnections(int maxConnections) {
                this.context.maxConnections = maxConnections;
                return this;
            }

            public Builder log(KitLogger log) {
                this.context.log = log;
                return this;
            }

            public DockerAccessContext build() {
                return this.context;
            }
        }
    }
}

