/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jkube.kit.build.service.docker;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.eclipse.jkube.kit.build.core.config.JKubeBuildConfiguration;
import org.eclipse.jkube.kit.build.service.docker.config.ConfigHelper;
import org.eclipse.jkube.kit.build.service.docker.config.NetworkConfig;
import org.eclipse.jkube.kit.build.service.docker.config.RunImageConfiguration;
import org.eclipse.jkube.kit.build.service.docker.config.RunVolumeConfiguration;
import org.eclipse.jkube.kit.build.service.docker.config.WatchImageConfiguration;
import org.eclipse.jkube.kit.build.service.docker.helper.DeepCopy;
import org.eclipse.jkube.kit.build.service.docker.helper.StartOrderResolver;
import org.eclipse.jkube.kit.common.KitLogger;
import org.eclipse.jkube.kit.common.util.EnvUtil;
import org.eclipse.jkube.kit.config.image.ImageName;

public class ImageConfiguration
implements StartOrderResolver.Resolvable,
Serializable {
    private String name;
    private String alias;
    private RunImageConfiguration run;
    private JKubeBuildConfiguration build;
    private WatchImageConfiguration watch;
    private Map<String, String> external;
    private String registry;

    @Override
    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setExternalConfiguration(Map<String, String> externalConfiguration) {
        this.external = externalConfiguration;
    }

    @Override
    public String getAlias() {
        return this.alias;
    }

    public RunImageConfiguration getRunConfiguration() {
        return this.run == null ? RunImageConfiguration.DEFAULT : this.run;
    }

    public JKubeBuildConfiguration getBuildConfiguration() {
        return this.build;
    }

    public WatchImageConfiguration getWatchConfiguration() {
        return this.watch;
    }

    public Map<String, String> getExternalConfig() {
        return this.external;
    }

    @Override
    public List<String> getDependencies() {
        RunImageConfiguration runConfig = this.getRunConfiguration();
        ArrayList<String> ret = new ArrayList<String>();
        if (runConfig != null) {
            this.addVolumes(runConfig, ret);
            this.addLinks(runConfig, ret);
            this.addContainerNetwork(runConfig, ret);
            this.addDependsOn(runConfig, ret);
        }
        return ret;
    }

    private void addVolumes(RunImageConfiguration runConfig, List<String> ret) {
        List<String> volumeImages;
        RunVolumeConfiguration volConfig = runConfig.getVolumeConfiguration();
        if (volConfig != null && (volumeImages = volConfig.getFrom()) != null) {
            ret.addAll(volumeImages);
        }
    }

    private void addLinks(RunImageConfiguration runConfig, List<String> ret) {
        if (!runConfig.getNetworkingConfig().isCustomNetwork()) {
            for (String[] link : EnvUtil.splitOnLastColon(runConfig.getLinks())) {
                ret.add(link[0]);
            }
        }
    }

    private void addContainerNetwork(RunImageConfiguration runConfig, List<String> ret) {
        NetworkConfig config = runConfig.getNetworkingConfig();
        String alias = config.getContainerAlias();
        if (alias != null) {
            ret.add(alias);
        }
    }

    private void addDependsOn(RunImageConfiguration runConfig, List<String> ret) {
        if (runConfig.getNetworkingConfig().isCustomNetwork()) {
            ret.addAll(runConfig.getDependsOn());
        }
    }

    public boolean isDataImage() {
        return this.getRunConfiguration() == null;
    }

    public String getDescription() {
        return String.format("[%s] %s", new ImageName(this.name).getFullName(), this.alias != null ? "\"" + this.alias + "\"" : "").trim();
    }

    public String getRegistry() {
        return this.registry;
    }

    public String toString() {
        return String.format("ImageConfiguration {name='%s', alias='%s'}", this.name, this.alias);
    }

    public String initAndValidate(ConfigHelper.NameFormatter nameFormatter, KitLogger log) {
        this.name = nameFormatter.format(this.name);
        String minimalApiVersion = null;
        if (this.build != null) {
            minimalApiVersion = this.build.initAndValidate(log);
        }
        if (this.run != null) {
            minimalApiVersion = EnvUtil.extractLargerVersion((String)minimalApiVersion, (String)this.run.initAndValidate());
        }
        return minimalApiVersion;
    }

    public static class Builder {
        private final ImageConfiguration config;

        public Builder() {
            this(null);
        }

        public Builder(ImageConfiguration that) {
            this.config = that == null ? new ImageConfiguration() : DeepCopy.copy(that);
        }

        public Builder name(String name) {
            this.config.name = name;
            return this;
        }

        public Builder alias(String alias) {
            this.config.alias = alias;
            return this;
        }

        public Builder runConfig(RunImageConfiguration runConfig) {
            this.config.run = runConfig;
            return this;
        }

        public Builder buildConfig(JKubeBuildConfiguration buildConfig) {
            this.config.build = buildConfig;
            return this;
        }

        public Builder externalConfig(Map<String, String> externalConfig) {
            this.config.external = externalConfig;
            return this;
        }

        public Builder registry(String registry) {
            this.config.registry = registry;
            return this;
        }

        public Builder watchConfig(WatchImageConfiguration watchConfig) {
            this.config.watch = watchConfig;
            return this;
        }

        public ImageConfiguration build() {
            return this.config;
        }
    }
}

