/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jkube.kit.build.service.docker;

import java.io.IOException;
import java.io.Serializable;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.function.UnaryOperator;
import org.eclipse.jkube.kit.build.api.auth.AuthConfig;
import org.eclipse.jkube.kit.build.core.config.JKubeBuildConfiguration;
import org.eclipse.jkube.kit.build.service.docker.ImageConfiguration;
import org.eclipse.jkube.kit.build.service.docker.ImagePullManager;
import org.eclipse.jkube.kit.build.service.docker.access.DockerAccess;
import org.eclipse.jkube.kit.build.service.docker.auth.AuthConfigFactory;
import org.eclipse.jkube.kit.common.KitLogger;
import org.eclipse.jkube.kit.common.RegistryServerConfiguration;
import org.eclipse.jkube.kit.common.util.EnvUtil;
import org.eclipse.jkube.kit.config.image.ImageName;
import org.eclipse.jkube.kit.config.image.build.ImagePullPolicy;

public class RegistryService {
    private final DockerAccess docker;
    private final KitLogger log;

    RegistryService(DockerAccess docker, KitLogger log) {
        this.docker = docker;
        this.log = log;
    }

    public void pushImages(Collection<ImageConfiguration> imageConfigs, int retries, RegistryConfig registryConfig, boolean skipTag) throws Exception {
        for (ImageConfiguration imageConfig : imageConfigs) {
            JKubeBuildConfiguration buildConfig = imageConfig.getBuildConfiguration();
            String name = imageConfig.getName();
            if (buildConfig == null) continue;
            String configuredRegistry = EnvUtil.firstRegistryOf((String[])new String[]{new ImageName(imageConfig.getName()).getRegistry(), imageConfig.getRegistry(), registryConfig.getRegistry()});
            AuthConfig authConfig = this.createAuthConfig(true, new ImageName(name).getUser(), configuredRegistry, registryConfig);
            long start = System.currentTimeMillis();
            this.docker.pushImage(name, authConfig, configuredRegistry, retries);
            this.log.info("Pushed %s in %s", new Object[]{name, EnvUtil.formatDurationTill((long)start)});
            if (skipTag) continue;
            for (String tag : imageConfig.getBuildConfiguration().getTags()) {
                if (tag == null) continue;
                this.docker.pushImage(new ImageName(name, tag).getFullName(), authConfig, configuredRegistry, retries);
            }
        }
    }

    public void pullImageWithPolicy(String image, ImagePullManager pullManager, RegistryConfig registryConfig, boolean hasImage) throws Exception {
        if (pullManager.hasAlreadyPulled(image)) {
            return;
        }
        if (!this.imageRequiresPull(hasImage, pullManager.getImagePullPolicy(), image)) {
            return;
        }
        ImageName imageName = new ImageName(image);
        long time = System.currentTimeMillis();
        String actualRegistry = EnvUtil.firstRegistryOf((String[])new String[]{imageName.getRegistry(), registryConfig.getRegistry()});
        this.docker.pullImage(imageName.getFullName(), this.createAuthConfig(false, null, actualRegistry, registryConfig), actualRegistry);
        this.log.info("Pulled %s in %s", new Object[]{imageName.getFullName(), EnvUtil.formatDurationTill((long)time)});
        pullManager.pulled(image);
        if (actualRegistry != null && !imageName.hasRegistry()) {
            this.docker.tag(imageName.getFullName(actualRegistry), image, false);
        }
    }

    private boolean imageRequiresPull(boolean hasImage, ImagePullPolicy pullPolicy, String imageName) throws IOException {
        if (pullPolicy == ImagePullPolicy.Never) {
            if (!hasImage) {
                throw new IOException(String.format("No image '%s' found and pull policy 'Never' is set. Please chose another pull policy or pull the image yourself)", imageName));
            }
            return false;
        }
        if (!hasImage) {
            return true;
        }
        return pullPolicy == ImagePullPolicy.Always;
    }

    private AuthConfig createAuthConfig(boolean isPush, String user, String registry, RegistryConfig config) throws Exception {
        return config.getAuthConfigFactory().createAuthConfig(isPush, config.isSkipExtendedAuth(), config.getAuthConfig(), config.getSettings(), user, registry, config.getPasswordDecryptionMethod());
    }

    public static class RegistryConfig
    implements Serializable {
        private String registry;
        private List<RegistryServerConfiguration> settings;
        private AuthConfigFactory authConfigFactory;
        private boolean skipExtendedAuth;
        private Map authConfig;
        private transient UnaryOperator<String> passwordDecryptionMethod;

        public String getRegistry() {
            return this.registry;
        }

        public List<RegistryServerConfiguration> getSettings() {
            return this.settings;
        }

        public AuthConfigFactory getAuthConfigFactory() {
            return this.authConfigFactory;
        }

        public boolean isSkipExtendedAuth() {
            return this.skipExtendedAuth;
        }

        public Map getAuthConfig() {
            return this.authConfig;
        }

        public UnaryOperator<String> getPasswordDecryptionMethod() {
            return this.passwordDecryptionMethod;
        }

        public static class Builder {
            private RegistryConfig context = new RegistryConfig();

            public Builder() {
                this.context = new RegistryConfig();
            }

            public Builder(RegistryConfig context) {
                this.context = context;
            }

            public Builder registry(String registry) {
                this.context.registry = registry;
                return this;
            }

            public Builder settings(List<RegistryServerConfiguration> registryServerConfigurations) {
                this.context.settings = registryServerConfigurations;
                return this;
            }

            public Builder authConfigFactory(AuthConfigFactory authConfigFactory) {
                this.context.authConfigFactory = authConfigFactory;
                return this;
            }

            public Builder skipExtendedAuth(boolean skipExtendedAuth) {
                this.context.skipExtendedAuth = skipExtendedAuth;
                return this;
            }

            public Builder authConfig(Map authConfig) {
                this.context.authConfig = authConfig;
                return this;
            }

            public Builder passwordDecryptionMethod(UnaryOperator<String> passwordDecrypt) {
                this.context.passwordDecryptionMethod = passwordDecrypt;
                return this;
            }

            public RegistryConfig build() {
                return this.context;
            }
        }
    }
}

