/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jkube.kit.build.service.docker;

import java.io.File;
import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;
import org.eclipse.jkube.kit.build.core.GavLabel;
import org.eclipse.jkube.kit.build.core.JKubeBuildContext;
import org.eclipse.jkube.kit.build.core.assembly.AssemblyFiles;
import org.eclipse.jkube.kit.build.core.config.JKubeAssemblyConfiguration;
import org.eclipse.jkube.kit.build.service.docker.ArchiveService;
import org.eclipse.jkube.kit.build.service.docker.BuildService;
import org.eclipse.jkube.kit.build.service.docker.ImageConfiguration;
import org.eclipse.jkube.kit.build.service.docker.QueryService;
import org.eclipse.jkube.kit.build.service.docker.RunService;
import org.eclipse.jkube.kit.build.service.docker.ServiceHub;
import org.eclipse.jkube.kit.build.service.docker.ServiceHubFactory;
import org.eclipse.jkube.kit.build.service.docker.access.DockerAccess;
import org.eclipse.jkube.kit.build.service.docker.access.DockerAccessException;
import org.eclipse.jkube.kit.build.service.docker.access.ExecException;
import org.eclipse.jkube.kit.build.service.docker.access.PortMapping;
import org.eclipse.jkube.kit.build.service.docker.access.log.LogDispatcher;
import org.eclipse.jkube.kit.build.service.docker.config.WatchImageConfiguration;
import org.eclipse.jkube.kit.build.service.docker.config.WatchMode;
import org.eclipse.jkube.kit.build.service.docker.helper.StartContainerExecutor;
import org.eclipse.jkube.kit.build.service.docker.helper.StartOrderResolver;
import org.eclipse.jkube.kit.build.service.docker.helper.Task;
import org.eclipse.jkube.kit.common.KitLogger;

public class WatchService {
    private final ArchiveService archiveService;
    private final BuildService buildService;
    private final DockerAccess dockerAccess;
    private final QueryService queryService;
    private final RunService runService;
    private final KitLogger log;

    public WatchService(ArchiveService archiveService, BuildService buildService, DockerAccess dockerAccess, QueryService queryService, RunService runService, KitLogger log) {
        this.archiveService = archiveService;
        this.buildService = buildService;
        this.dockerAccess = dockerAccess;
        this.queryService = queryService;
        this.runService = runService;
        this.log = log;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void watch(WatchContext context, BuildService.BuildContext buildContext, List<ImageConfiguration> images) throws DockerAccessException, IOException {
        ScheduledExecutorService executor = null;
        try {
            executor = Executors.newSingleThreadScheduledExecutor();
            for (StartOrderResolver.Resolvable resolvable : this.runService.getImagesConfigsInOrder(this.queryService, images)) {
                ImageConfiguration imageConfig = (ImageConfiguration)resolvable;
                String imageId = this.queryService.getImageId(imageConfig.getName());
                String containerId = this.runService.lookupContainer(imageConfig.getName());
                ImageWatcher watcher = new ImageWatcher(imageConfig, context, imageId, containerId);
                long interval = watcher.getInterval();
                WatchMode watchMode = watcher.getWatchMode(imageConfig);
                this.log.info("Watching " + imageConfig.getName() + (watchMode != null ? " using " + watchMode.getDescription() : ""), new Object[0]);
                ArrayList<String> tasks = new ArrayList<String>();
                if (imageConfig.getBuildConfiguration() != null && imageConfig.getBuildConfiguration().getAssemblyConfiguration() != null) {
                    if (watcher.isCopy()) {
                        String containerBaseDir = ((JKubeAssemblyConfiguration)imageConfig.getBuildConfiguration().getAssemblyConfiguration()).getTargetDir();
                        this.schedule(executor, this.createCopyWatchTask(watcher, context.getMavenBuildContext(), containerBaseDir), interval);
                        tasks.add("copying artifacts");
                    }
                    if (watcher.isBuild()) {
                        this.schedule(executor, this.createBuildWatchTask(watcher, context.getMavenBuildContext(), watchMode == WatchMode.both, buildContext), interval);
                        tasks.add("rebuilding");
                    }
                }
                if (watcher.isRun() && watcher.getContainerId() != null) {
                    this.schedule(executor, this.createRestartWatchTask(watcher), interval);
                    tasks.add("restarting");
                }
                if (tasks.size() <= 0) continue;
                this.log.info("%s: Watch for %s", new Object[]{imageConfig.getDescription(), String.join((CharSequence)" and ", tasks)});
            }
            this.log.info("Waiting ...", new Object[0]);
            if (!context.isKeepRunning()) {
                this.runService.addShutdownHookForStoppingContainers(context.isKeepContainer(), context.isRemoveVolumes(), context.isAutoCreateCustomNetworks());
            }
            this.wait();
        }
        catch (InterruptedException e) {
            this.log.warn("Interrupted", new Object[0]);
        }
        finally {
            if (executor != null) {
                executor.shutdownNow();
            }
        }
    }

    private void schedule(ScheduledExecutorService executor, Runnable runnable, long interval) {
        executor.scheduleAtFixedRate(runnable, 0L, interval, TimeUnit.MILLISECONDS);
    }

    private Runnable createCopyWatchTask(final ImageWatcher watcher, final JKubeBuildContext mojoParameters, final String containerBaseDir) throws IOException {
        final ImageConfiguration imageConfig = watcher.getImageConfiguration();
        final AssemblyFiles files = this.archiveService.getAssemblyFiles(imageConfig, mojoParameters);
        return new Runnable(){

            @Override
            public void run() {
                List<AssemblyFiles.Entry> entries = files.getUpdatedEntriesAndRefresh();
                if (entries != null && entries.size() > 0) {
                    try {
                        WatchService.this.log.info("%s: Assembly changed. Copying changed files to container ...", new Object[]{imageConfig.getDescription()});
                        File changedFilesArchive = WatchService.this.archiveService.createChangedFilesArchive(entries, files.getAssemblyDirectory(), imageConfig.getName(), mojoParameters);
                        WatchService.this.dockerAccess.copyArchive(watcher.getContainerId(), changedFilesArchive, containerBaseDir);
                        WatchService.this.callPostExec(watcher);
                    }
                    catch (IOException | ExecException e) {
                        WatchService.this.log.error("%s: Error when copying files to container %s: %s", new Object[]{imageConfig.getDescription(), watcher.getContainerId(), e.getMessage()});
                    }
                }
            }
        };
    }

    private void callPostExec(ImageWatcher watcher) throws DockerAccessException, ExecException {
        if (watcher.getPostExec() != null) {
            String containerId = watcher.getContainerId();
            this.runService.execInContainer(containerId, watcher.getPostExec(), watcher.getImageConfiguration());
        }
    }

    private Runnable createBuildWatchTask(final ImageWatcher watcher, JKubeBuildContext mojoParameters, final boolean doRestart, final BuildService.BuildContext buildContext) throws IOException {
        final ImageConfiguration imageConfig = watcher.getImageConfiguration();
        final AssemblyFiles files = this.archiveService.getAssemblyFiles(imageConfig, mojoParameters);
        if (files != null && files.isEmpty()) {
            this.log.error("No assembly files for %s. Are you sure you invoked together with the `package` goal?", new Object[]{imageConfig.getDescription()});
            throw new IOException("No files to watch found for " + imageConfig);
        }
        return new Runnable(){

            @Override
            public void run() {
                List<AssemblyFiles.Entry> entries = files.getUpdatedEntriesAndRefresh();
                if (entries != null && entries.size() > 0) {
                    try {
                        WatchService.this.log.info("%s: Assembly changed. Rebuild ...", new Object[]{imageConfig.getDescription()});
                        if (watcher.getWatchContext().getImageCustomizer() != null) {
                            WatchService.this.log.info("%s: Customizing the image ...", new Object[]{imageConfig.getDescription()});
                            watcher.getWatchContext().getImageCustomizer().execute(imageConfig);
                        }
                        WatchService.this.buildService.buildImage(imageConfig, null, buildContext);
                        String name = imageConfig.getName();
                        watcher.setImageId(WatchService.this.queryService.getImageId(name));
                        if (doRestart) {
                            WatchService.this.restartContainer(watcher);
                        }
                    }
                    catch (Exception e) {
                        WatchService.this.log.error("%s: Error when rebuilding - %s", new Object[]{imageConfig.getDescription(), e});
                    }
                }
            }
        };
    }

    private Runnable createRestartWatchTask(final ImageWatcher watcher) throws DockerAccessException {
        final String imageName = watcher.getImageName();
        return new Runnable(){

            @Override
            public void run() {
                try {
                    String currentImageId = WatchService.this.queryService.getImageId(imageName);
                    String oldValue = watcher.getAndSetImageId(currentImageId);
                    if (!currentImageId.equals(oldValue)) {
                        WatchService.this.restartContainer(watcher);
                    }
                }
                catch (Exception e) {
                    WatchService.this.log.warn("%s: Error when restarting image - %s", new Object[]{watcher.getImageConfiguration().getDescription(), e});
                }
            }
        };
    }

    private void restartContainer(ImageWatcher watcher) throws Exception {
        Task<ImageWatcher> restarter = watcher.getWatchContext().getContainerRestarter();
        if (restarter == null) {
            restarter = this.defaultContainerRestartTask();
        }
        restarter.execute(watcher);
    }

    private Task<ImageWatcher> defaultContainerRestartTask() {
        return watcher -> {
            ImageConfiguration imageConfig = watcher.getImageConfiguration();
            PortMapping mappedPorts = this.runService.createPortMapping(imageConfig.getRunConfiguration(), watcher.getWatchContext().getMavenBuildContext().getProject().getProperties());
            String id = watcher.getContainerId();
            String optionalPreStop = this.getPreStopCommand(imageConfig);
            if (optionalPreStop != null) {
                this.runService.execInContainer(id, optionalPreStop, watcher.getImageConfiguration());
            }
            this.runService.stopPreviouslyStartedContainer(id, false, false);
            StartContainerExecutor helper = new StartContainerExecutor.Builder().dispatcher(((ImageWatcher)watcher).watchContext.dispatcher).follow(((ImageWatcher)watcher).watchContext.follow).log(this.log).portMapping(mappedPorts).gavLabel(((ImageWatcher)watcher).watchContext.getGavLabel()).projectProperties(((ImageWatcher)watcher).watchContext.mojoParameters.getProject().getProperties()).basedir(((ImageWatcher)watcher).watchContext.mojoParameters.getProject().getBaseDirectory()).imageConfig(imageConfig).serviceHub(((ImageWatcher)watcher).watchContext.hub).logOutputSpecFactory(((ImageWatcher)watcher).watchContext.serviceHubFactory.getLogOutputSpecFactory()).showLogs(((ImageWatcher)watcher).watchContext.showLogs).containerNamePattern(((ImageWatcher)watcher).watchContext.containerNamePattern).buildTimestamp(((ImageWatcher)watcher).watchContext.buildTimestamp).build();
            String containerId = helper.startContainers();
            watcher.setContainerId(containerId);
        };
    }

    private String getPreStopCommand(ImageConfiguration imageConfig) {
        if (imageConfig.getRunConfiguration() != null && imageConfig.getRunConfiguration().getWaitConfiguration() != null && imageConfig.getRunConfiguration().getWaitConfiguration().getExec() != null) {
            return imageConfig.getRunConfiguration().getWaitConfiguration().getExec().getPreStop();
        }
        return null;
    }

    public static class WatchContext
    implements Serializable {
        private JKubeBuildContext mojoParameters;
        private WatchMode watchMode;
        private int watchInterval;
        private boolean keepRunning;
        private String watchPostGoal;
        private String watchPostExec;
        private GavLabel gavLabel;
        private boolean keepContainer;
        private boolean removeVolumes;
        private boolean autoCreateCustomNetworks;
        private Task<ImageConfiguration> imageCustomizer;
        private Task<ImageWatcher> containerRestarter;
        private transient ServiceHub hub;
        private transient ServiceHubFactory serviceHubFactory;
        private transient LogDispatcher dispatcher;
        private boolean follow;
        private String showLogs;
        private Date buildTimestamp;
        private String containerNamePattern;

        public JKubeBuildContext getMavenBuildContext() {
            return this.mojoParameters;
        }

        public WatchMode getWatchMode() {
            return this.watchMode;
        }

        public int getWatchInterval() {
            return this.watchInterval;
        }

        public boolean isKeepRunning() {
            return this.keepRunning;
        }

        public String getWatchPostGoal() {
            return this.watchPostGoal;
        }

        public String getWatchPostExec() {
            return this.watchPostExec;
        }

        public GavLabel getGavLabel() {
            return this.gavLabel;
        }

        public boolean isKeepContainer() {
            return this.keepContainer;
        }

        public boolean isRemoveVolumes() {
            return this.removeVolumes;
        }

        public boolean isAutoCreateCustomNetworks() {
            return this.autoCreateCustomNetworks;
        }

        public Task<ImageConfiguration> getImageCustomizer() {
            return this.imageCustomizer;
        }

        public Task<ImageWatcher> getContainerRestarter() {
            return this.containerRestarter;
        }

        public Date getBuildTimestamp() {
            return this.buildTimestamp;
        }

        public String getContainerNamePattern() {
            return this.containerNamePattern;
        }

        public static class Builder {
            private WatchContext context;

            public Builder() {
                this.context = new WatchContext();
            }

            public Builder(WatchContext context) {
                this.context = context;
            }

            public Builder mojoParameters(JKubeBuildContext mojoParameters) {
                this.context.mojoParameters = mojoParameters;
                return this;
            }

            public Builder watchMode(WatchMode watchMode) {
                this.context.watchMode = watchMode;
                return this;
            }

            public Builder watchInterval(int watchInterval) {
                this.context.watchInterval = watchInterval;
                return this;
            }

            public Builder keepRunning(boolean keepRunning) {
                this.context.keepRunning = keepRunning;
                return this;
            }

            public Builder watchPostGoal(String watchPostGoal) {
                this.context.watchPostGoal = watchPostGoal;
                return this;
            }

            public Builder watchPostExec(String watchPostExec) {
                this.context.watchPostExec = watchPostExec;
                return this;
            }

            public Builder pomLabel(GavLabel gavLabel) {
                this.context.gavLabel = gavLabel;
                return this;
            }

            public Builder keepContainer(boolean keepContainer) {
                this.context.keepContainer = keepContainer;
                return this;
            }

            public Builder removeVolumes(boolean removeVolumes) {
                this.context.removeVolumes = removeVolumes;
                return this;
            }

            public Builder imageCustomizer(Task<ImageConfiguration> imageCustomizer) {
                this.context.imageCustomizer = imageCustomizer;
                return this;
            }

            public Builder containerRestarter(Task<ImageWatcher> containerRestarter) {
                this.context.containerRestarter = containerRestarter;
                return this;
            }

            public Builder autoCreateCustomNetworks(boolean autoCreateCustomNetworks) {
                this.context.autoCreateCustomNetworks = autoCreateCustomNetworks;
                return this;
            }

            public Builder follow(boolean follow) {
                this.context.follow = follow;
                return this;
            }

            public Builder showLogs(String showLogs) {
                this.context.showLogs = showLogs;
                return this;
            }

            public Builder hub(ServiceHub hub) {
                this.context.hub = hub;
                return this;
            }

            public Builder serviceHubFactory(ServiceHubFactory serviceHubFactory) {
                this.context.serviceHubFactory = serviceHubFactory;
                return this;
            }

            public Builder dispatcher(LogDispatcher dispatcher) {
                this.context.dispatcher = dispatcher;
                return this;
            }

            public Builder buildTimestamp(Date buildTimestamp) {
                this.context.buildTimestamp = buildTimestamp;
                return this;
            }

            public Builder containerNamePattern(String containerNamePattern) {
                this.context.containerNamePattern = containerNamePattern;
                return this;
            }

            public WatchContext build() {
                return this.context;
            }
        }
    }

    public class ImageWatcher {
        private final ImageConfiguration imageConfig;
        private final WatchContext watchContext;
        private final WatchMode mode;
        private final AtomicReference<String> imageIdRef;
        private final AtomicReference<String> containerIdRef;
        private final long interval;
        private final String postGoal;
        private String postExec;

        public ImageWatcher(ImageConfiguration imageConfig, WatchContext watchContext, String imageId, String containerIdRef) {
            this.imageConfig = imageConfig;
            this.watchContext = watchContext;
            this.imageIdRef = new AtomicReference<String>(imageId);
            this.containerIdRef = new AtomicReference<String>(containerIdRef);
            this.interval = this.getWatchInterval(imageConfig);
            this.mode = this.getWatchMode(imageConfig);
            this.postGoal = this.getPostGoal(imageConfig);
            this.postExec = this.getPostExec(imageConfig);
        }

        public String getContainerId() {
            return this.containerIdRef.get();
        }

        public long getInterval() {
            return this.interval;
        }

        public String getPostGoal() {
            return this.postGoal;
        }

        public boolean isCopy() {
            return this.mode.isCopy();
        }

        public boolean isBuild() {
            return this.mode.isBuild();
        }

        public boolean isRun() {
            return this.mode.isRun();
        }

        public ImageConfiguration getImageConfiguration() {
            return this.imageConfig;
        }

        public void setImageId(String imageId) {
            this.imageIdRef.set(imageId);
        }

        public void setContainerId(String containerId) {
            this.containerIdRef.set(containerId);
        }

        public String getImageName() {
            return this.imageConfig.getName();
        }

        public String getAndSetImageId(String currentImageId) {
            return this.imageIdRef.getAndSet(currentImageId);
        }

        public String getPostExec() {
            return this.postExec;
        }

        public WatchContext getWatchContext() {
            return this.watchContext;
        }

        private int getWatchInterval(ImageConfiguration imageConfig) {
            WatchImageConfiguration watchConfig = imageConfig.getWatchConfiguration();
            int interval = watchConfig != null ? watchConfig.getInterval() : this.watchContext.getWatchInterval();
            return interval < 100 ? 100 : interval;
        }

        private String getPostExec(ImageConfiguration imageConfig) {
            WatchImageConfiguration watchConfig = imageConfig.getWatchConfiguration();
            return watchConfig != null && watchConfig.getPostExec() != null ? watchConfig.getPostExec() : this.watchContext.getWatchPostExec();
        }

        private String getPostGoal(ImageConfiguration imageConfig) {
            WatchImageConfiguration watchConfig = imageConfig.getWatchConfiguration();
            return watchConfig != null && watchConfig.getPostGoal() != null ? watchConfig.getPostGoal() : this.watchContext.getWatchPostGoal();
        }

        private WatchMode getWatchMode(ImageConfiguration imageConfig) {
            WatchImageConfiguration watchConfig = imageConfig.getWatchConfiguration();
            WatchMode mode = watchConfig != null ? watchConfig.getMode() : null;
            return mode != null ? mode : this.watchContext.getWatchMode();
        }
    }
}

