/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jkube.kit.build.service.docker.access.chunked;

import com.google.gson.JsonObject;
import org.eclipse.jkube.kit.build.service.docker.access.DockerAccessException;
import org.eclipse.jkube.kit.build.service.docker.access.chunked.EntityStreamReaderUtil;
import org.eclipse.jkube.kit.common.KitLogger;

public class PullOrPushResponseJsonHandler
implements EntityStreamReaderUtil.JsonEntityResponseHandler {
    private final KitLogger log;

    public PullOrPushResponseJsonHandler(KitLogger log) {
        this.log = log;
    }

    @Override
    public void process(JsonObject json) throws DockerAccessException {
        if (json.has("progressDetail")) {
            this.log.progressUpdate(this.getStringOrEmpty(json, "id"), this.getStringOrEmpty(json, "status"), this.getStringOrEmpty(json, "progress"));
        } else if (json.has("error")) {
            this.throwDockerAccessException(json);
        } else {
            this.log.progressFinished();
            this.logInfoMessage(json);
            this.log.progressStart();
        }
    }

    private void logInfoMessage(JsonObject json) {
        String value = json.has("stream") ? json.get("stream").getAsString().replaceFirst("\n$", "") : (json.has("status") ? json.get("status").getAsString() : json.toString());
        this.log.info("%s", new Object[]{value});
    }

    private void throwDockerAccessException(JsonObject json) throws DockerAccessException {
        String msg = json.get("error").getAsString().trim();
        String details = json.getAsJsonObject("errorDetail").get("message").getAsString().trim();
        throw new DockerAccessException("%s %s", msg, msg.equals(details) ? "" : "(" + details + ")");
    }

    private String getStringOrEmpty(JsonObject json, String what) {
        return json.has(what) ? json.get(what).getAsString() : "";
    }

    @Override
    public void start() {
        this.log.progressStart();
    }

    @Override
    public void stop() {
        this.log.progressFinished();
    }
}

