/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jkube.kit.build.service.docker.auth;

import com.google.gson.JsonObject;
import java.io.IOException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.function.UnaryOperator;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.http.conn.ConnectTimeoutException;
import org.eclipse.jkube.kit.build.api.auth.AuthConfig;
import org.eclipse.jkube.kit.build.service.docker.auth.CredentialHelperClient;
import org.eclipse.jkube.kit.build.service.docker.auth.ecr.EcrExtendedAuth;
import org.eclipse.jkube.kit.build.service.docker.helper.DockerFileUtil;
import org.eclipse.jkube.kit.common.KitLogger;
import org.eclipse.jkube.kit.common.RegistryServerConfiguration;
import org.eclipse.jkube.kit.common.util.EnvUtil;

public class AuthConfigFactory {
    public static final String AUTH_USERNAME = "username";
    public static final String AUTH_PASSWORD = "password";
    public static final String AUTH_EMAIL = "email";
    public static final String AUTH_AUTHTOKEN = "authToken";
    private static final String AUTH_USE_OPENSHIFT_AUTH = "useOpenShiftAuth";
    static final String DOCKER_LOGIN_DEFAULT_REGISTRY = "https://index.docker.io/v1/";
    private final KitLogger log;
    private static final String[] DEFAULT_REGISTRIES = new String[]{"docker.io", "index.docker.io", "registry.hub.docker.com"};

    public AuthConfigFactory(KitLogger log) {
        this.log = log;
    }

    public AuthConfig createAuthConfig(boolean isPush, boolean skipExtendedAuth, Map authConfig, List<RegistryServerConfiguration> settings, String user, String registry, UnaryOperator<String> passwordDecryptionMethod) throws Exception {
        AuthConfig ret = this.createStandardAuthConfig(isPush, authConfig, settings, user, registry, passwordDecryptionMethod);
        if (ret != null) {
            if (registry == null || skipExtendedAuth) {
                return ret;
            }
            try {
                return this.extendedAuthentication(ret, registry);
            }
            catch (IOException e) {
                throw new IOException(e.getMessage(), e);
            }
        }
        ret = this.getAuthConfigFromDockerConfig(registry);
        if (ret != null) {
            this.log.debug("AuthConfig: credentials from ~/.docker/config.json", new Object[0]);
            return ret;
        }
        this.log.debug("AuthConfig: no credentials found", new Object[0]);
        return null;
    }

    private AuthConfig extendedAuthentication(AuthConfig standardAuthConfig, String registry) throws IOException {
        EcrExtendedAuth ecr = new EcrExtendedAuth(this.log, registry);
        if (ecr.isAwsRegistry()) {
            return ecr.extendedAuth(standardAuthConfig);
        }
        return standardAuthConfig;
    }

    private AuthConfig createStandardAuthConfig(boolean isPush, Map authConfigMap, List<RegistryServerConfiguration> settings, String user, String registry, UnaryOperator<String> passwordDecryptionMethod) throws Exception {
        AuthConfig ret;
        for (LookupMode lookupMode : new LookupMode[]{this.getLookupMode(isPush), LookupMode.DEFAULT}) {
            ret = this.getAuthConfigFromSystemProperties(lookupMode, passwordDecryptionMethod);
            if (ret != null) {
                this.log.debug("AuthConfig: credentials from system properties", new Object[0]);
                return ret;
            }
            ret = this.getAuthConfigFromOpenShiftConfig(lookupMode, authConfigMap);
            if (ret != null) {
                this.log.debug("AuthConfig: OpenShift credentials", new Object[0]);
                return ret;
            }
            ret = this.getAuthConfigFromPluginConfiguration(lookupMode, authConfigMap, passwordDecryptionMethod);
            if (ret == null) continue;
            this.log.debug("AuthConfig: credentials from plugin config", new Object[0]);
            return ret;
        }
        ret = this.getAuthConfigFromSettings(settings, user, registry, passwordDecryptionMethod);
        if (ret != null) {
            this.log.debug("AuthConfig: credentials from ~/.m2/setting.xml", new Object[0]);
            return ret;
        }
        if (EcrExtendedAuth.isAwsRegistry(registry)) {
            try {
                ret = this.getAuthConfigFromEC2InstanceRole();
            }
            catch (ConnectTimeoutException ex) {
                this.log.debug("Connection timeout while retrieving instance meta-data, likely not an EC2 instance (%s)", new Object[]{ex.getMessage()});
            }
            catch (IOException ex) {
                this.log.warn("Error while retrieving EC2 instance credentials: %s", new Object[]{ex.getMessage()});
            }
            if (ret != null) {
                this.log.debug("AuthConfig: credentials from EC2 instance role", new Object[0]);
                return ret;
            }
        }
        return null;
    }

    /*
     * Exception decompiling
     */
    private AuthConfig getAuthConfigFromEC2InstanceRole() throws IOException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [13[TRYBLOCK]], but top level block is 18[TRYBLOCK]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private AuthConfig getAuthConfigFromSystemProperties(LookupMode lookupMode, UnaryOperator<String> passwordDecryptionMethod) throws Exception {
        Properties props = System.getProperties();
        String userKey = lookupMode.asSysProperty(AUTH_USERNAME);
        String passwordKey = lookupMode.asSysProperty(AUTH_PASSWORD);
        if (props.containsKey(userKey)) {
            if (!props.containsKey(passwordKey)) {
                throw new IOException("No " + passwordKey + " provided for username " + props.getProperty(userKey));
            }
            return new AuthConfig(props.getProperty(userKey), (String)passwordDecryptionMethod.apply(props.getProperty(passwordKey)), props.getProperty(lookupMode.asSysProperty(AUTH_EMAIL)), props.getProperty(lookupMode.asSysProperty(AUTH_AUTHTOKEN)));
        }
        return null;
    }

    private AuthConfig getAuthConfigFromOpenShiftConfig(LookupMode lookupMode, Map authConfigMap) {
        String useOpenAuthModeProp;
        Properties props = System.getProperties();
        if (props.containsKey(useOpenAuthModeProp = lookupMode.asSysProperty(AUTH_USE_OPENSHIFT_AUTH))) {
            boolean useOpenShift = Boolean.valueOf(props.getProperty(useOpenAuthModeProp));
            if (useOpenShift) {
                return this.validateMandatoryOpenShiftLogin(this.parseOpenShiftConfig(), useOpenAuthModeProp);
            }
            return null;
        }
        Map mapToCheck = this.getAuthConfigMapToCheck(lookupMode, authConfigMap);
        if (mapToCheck != null && mapToCheck.containsKey(AUTH_USE_OPENSHIFT_AUTH) && Boolean.valueOf((String)mapToCheck.get(AUTH_USE_OPENSHIFT_AUTH)).booleanValue()) {
            return this.validateMandatoryOpenShiftLogin(this.parseOpenShiftConfig(), useOpenAuthModeProp);
        }
        return null;
    }

    private AuthConfig getAuthConfigFromPluginConfiguration(LookupMode lookupMode, Map authConfig, UnaryOperator<String> passwordDecryptionMethod) throws Exception {
        Map mapToCheck = this.getAuthConfigMapToCheck(lookupMode, authConfig);
        if (mapToCheck != null && mapToCheck.containsKey(AUTH_USERNAME)) {
            if (!mapToCheck.containsKey(AUTH_PASSWORD)) {
                throw new IllegalStateException("No 'password' given while using <authConfig> in configuration for mode " + (Object)((Object)lookupMode));
            }
            HashMap cloneConfig = new HashMap(mapToCheck);
            cloneConfig.put(AUTH_PASSWORD, passwordDecryptionMethod.apply((String)cloneConfig.get(AUTH_PASSWORD)));
            return new AuthConfig(cloneConfig);
        }
        return null;
    }

    private AuthConfig getAuthConfigFromSettings(List<RegistryServerConfiguration> settings, String user, String registry, UnaryOperator<String> passwordDecryptionMethod) throws Exception {
        RegistryServerConfiguration defaultServer = null;
        for (RegistryServerConfiguration server : settings) {
            RegistryServerConfiguration found;
            String id = server.getId();
            if (defaultServer == null) {
                defaultServer = this.checkForServer(server, id, registry, null);
            }
            if ((found = this.checkForServer(server, id, registry, user)) == null) continue;
            return this.createAuthConfigFromServer(found, passwordDecryptionMethod);
        }
        return defaultServer != null ? this.createAuthConfigFromServer(defaultServer, passwordDecryptionMethod) : null;
    }

    private AuthConfig getAuthConfigFromDockerConfig(String registry) throws IOException {
        String registryToLookup;
        JsonObject dockerConfig = DockerFileUtil.readDockerConfig();
        if (dockerConfig == null) {
            return null;
        }
        String string = registryToLookup = registry != null ? registry : DOCKER_LOGIN_DEFAULT_REGISTRY;
        if (dockerConfig.has("credHelpers") || dockerConfig.has("credsStore")) {
            JsonObject credHelpers;
            if (dockerConfig.has("credHelpers") && (credHelpers = dockerConfig.getAsJsonObject("credHelpers")).has(registryToLookup)) {
                return this.extractAuthConfigFromCredentialsHelper(registryToLookup, credHelpers.get(registryToLookup).getAsString());
            }
            if (dockerConfig.has("credsStore")) {
                return this.extractAuthConfigFromCredentialsHelper(registryToLookup, dockerConfig.get("credsStore").getAsString());
            }
        }
        if (dockerConfig.has("auths")) {
            return this.extractAuthConfigFromAuths(registryToLookup, dockerConfig.getAsJsonObject("auths"));
        }
        return null;
    }

    private AuthConfig extractAuthConfigFromAuths(String registryToLookup, JsonObject auths) {
        JsonObject credentials = this.getCredentialsNode(auths, registryToLookup);
        if (credentials == null || !credentials.has("auth")) {
            return null;
        }
        String auth = credentials.get("auth").getAsString();
        String email = credentials.has(AUTH_EMAIL) ? credentials.get(AUTH_EMAIL).getAsString() : null;
        return new AuthConfig(auth, email);
    }

    private AuthConfig extractAuthConfigFromCredentialsHelper(String registryToLookup, String credConfig) throws IOException {
        CredentialHelperClient credentialHelper = new CredentialHelperClient(this.log, credConfig);
        String version = credentialHelper.getVersion();
        this.log.debug("AuthConfig: credentials from credential helper/store %s%s", new Object[]{credentialHelper.getName(), version != null ? " version " + version : ""});
        return credentialHelper.getAuthConfig(registryToLookup);
    }

    private JsonObject getCredentialsNode(JsonObject auths, String registryToLookup) {
        if (auths.has(registryToLookup)) {
            return auths.getAsJsonObject(registryToLookup);
        }
        String registryWithScheme = EnvUtil.ensureRegistryHttpUrl((String)registryToLookup);
        if (auths.has(registryWithScheme)) {
            return auths.getAsJsonObject(registryWithScheme);
        }
        return null;
    }

    private Map getAuthConfigMapToCheck(LookupMode lookupMode, Map authConfigMap) {
        String configMapKey = lookupMode.getConfigMapKey();
        if (configMapKey == null) {
            return authConfigMap;
        }
        if (authConfigMap != null) {
            return (Map)authConfigMap.get(configMapKey);
        }
        return null;
    }

    private AuthConfig parseOpenShiftConfig() {
        Map<String, ?> kubeConfig = DockerFileUtil.readKubeConfig();
        if (kubeConfig == null) {
            return null;
        }
        String currentContextName = (String)kubeConfig.get("current-context");
        if (currentContextName == null) {
            return null;
        }
        for (Map contextMap : (List)kubeConfig.get("contexts")) {
            if (!currentContextName.equals(contextMap.get("name"))) continue;
            return this.parseContext(kubeConfig, (Map)contextMap.get("context"));
        }
        return null;
    }

    private AuthConfig parseContext(Map kubeConfig, Map context) {
        if (context == null) {
            return null;
        }
        String userName = (String)context.get("user");
        if (userName == null) {
            return null;
        }
        List users = (List)kubeConfig.get("users");
        if (users == null) {
            return null;
        }
        for (Map userMap : users) {
            if (!userName.equals(userMap.get("name"))) continue;
            return this.parseUser(userName, (Map)userMap.get("user"));
        }
        return null;
    }

    private AuthConfig parseUser(String userName, Map user) {
        if (user == null) {
            return null;
        }
        String token = (String)user.get("token");
        if (token == null) {
            return null;
        }
        Matcher matcher = Pattern.compile("^([^/]+).*$").matcher(userName);
        return new AuthConfig(matcher.matches() ? matcher.group(1) : userName, token, null, null);
    }

    private AuthConfig validateMandatoryOpenShiftLogin(AuthConfig openShiftAuthConfig, String useOpenAuthModeProp) {
        if (openShiftAuthConfig != null) {
            return openShiftAuthConfig;
        }
        String kubeConfigEnv = System.getenv("KUBECONFIG");
        throw new IllegalStateException(String.format("System property %s set, but not active user and/or token found in %s. Please use 'oc login' for connecting to OpenShift.", useOpenAuthModeProp, kubeConfigEnv != null ? kubeConfigEnv : "~/.kube/config"));
    }

    private RegistryServerConfiguration checkForServer(RegistryServerConfiguration server, String id, String registry, String user) {
        String[] registries;
        String[] stringArray;
        if (registry != null) {
            String[] stringArray2 = new String[1];
            stringArray = stringArray2;
            stringArray2[0] = registry;
        } else {
            stringArray = DEFAULT_REGISTRIES;
        }
        for (String reg : registries = stringArray) {
            if (!id.equals(user == null ? reg : reg + "/" + user)) continue;
            return server;
        }
        return null;
    }

    private AuthConfig createAuthConfigFromServer(RegistryServerConfiguration server, UnaryOperator<String> passwordDecryptionMethod) throws Exception {
        return new AuthConfig(server.getUsername(), (String)passwordDecryptionMethod.apply(server.getPassword()), this.extractFromServerConfiguration(server.getConfiguration(), AUTH_EMAIL), this.extractFromServerConfiguration(server.getConfiguration(), "auth"));
    }

    private String extractFromServerConfiguration(Map<String, Object> configuration, String prop) {
        if (configuration != null && configuration.containsKey(prop)) {
            return configuration.get(prop).toString();
        }
        return null;
    }

    private LookupMode getLookupMode(boolean isPush) {
        return isPush ? LookupMode.PUSH : LookupMode.PULL;
    }

    private static enum LookupMode {
        PUSH("docker.push.", "push"),
        PULL("docker.pull.", "pull"),
        DEFAULT("docker.", null);

        private final String sysPropPrefix;
        private String configMapKey;

        private LookupMode(String sysPropPrefix, String configMapKey) {
            this.sysPropPrefix = sysPropPrefix;
            this.configMapKey = configMapKey;
        }

        public String asSysProperty(String prop) {
            return this.sysPropPrefix + prop;
        }

        public String getConfigMapKey() {
            return this.configMapKey;
        }
    }
}

