/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jkube.kit.build.service.docker.auth;

import com.google.gson.Gson;
import com.google.gson.JsonObject;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.io.Reader;
import java.util.Optional;
import java.util.function.Function;
import org.eclipse.jkube.kit.build.api.auth.AuthConfig;
import org.eclipse.jkube.kit.build.api.auth.RegistryAuthConfig;
import org.eclipse.jkube.kit.build.api.auth.RegistryAuthHandler;
import org.eclipse.jkube.kit.build.service.docker.auth.CredentialHelperClient;
import org.eclipse.jkube.kit.common.KitLogger;

public class DockerRegistryAuthHandler
implements RegistryAuthHandler {
    static final String DOCKER_LOGIN_DEFAULT_REGISTRY = "https://index.docker.io/v1/";
    private final KitLogger log;
    private final Gson gson;

    public DockerRegistryAuthHandler(KitLogger log) {
        this.log = log;
        this.gson = new Gson();
    }

    public String getId() {
        return "docker";
    }

    public AuthConfig create(RegistryAuthConfig.Kind kind, String user, String registry, Function<String, String> decryptor) {
        return this.readDockerConfig().map(d -> this.extractAuthConfigFromDocker((JsonObject)d, registry)).orElse(null);
    }

    private AuthConfig extractAuthConfigFromDocker(JsonObject dockerConfig, String registry) {
        String registryToLookup = registry != null ? registry : DOCKER_LOGIN_DEFAULT_REGISTRY;
        try {
            if (dockerConfig.has("credHelpers") || dockerConfig.has("credsStore")) {
                JsonObject credHelpers;
                if (dockerConfig.has("credHelpers") && (credHelpers = dockerConfig.getAsJsonObject("credHelpers")).has(registryToLookup)) {
                    return this.extractAuthConfigFromCredentialsHelper(registryToLookup, credHelpers.get(registryToLookup).getAsString());
                }
                if (dockerConfig.has("credsStore")) {
                    return this.extractAuthConfigFromCredentialsHelper(registryToLookup, dockerConfig.get("credsStore").getAsString());
                }
            }
            if (dockerConfig.has("auths")) {
                return this.extractAuthConfigFromAuths(registryToLookup, dockerConfig.getAsJsonObject("auths"));
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return null;
    }

    private Optional<JsonObject> readDockerConfig() {
        String dockerConfig = System.getenv("DOCKER_CONFIG");
        Optional<Reader> reader = dockerConfig == null ? this.getFileReaderFromDir(new File(this.getHomeDir(), ".docker/config.json")) : this.getFileReaderFromDir(new File(dockerConfig, "config.json"));
        return reader.map(r -> (JsonObject)this.gson.fromJson(r, JsonObject.class));
    }

    private AuthConfig extractAuthConfigFromAuths(String registryToLookup, JsonObject auths) {
        JsonObject credentials = this.getCredentialsNode(auths, registryToLookup);
        if (credentials == null || !credentials.has("auth")) {
            return null;
        }
        String auth = credentials.get("auth").getAsString();
        String email = credentials.has("email") ? credentials.get("email").getAsString() : null;
        return new AuthConfig.Builder().withCredentialsEncoded(auth).email(email).build();
    }

    private AuthConfig extractAuthConfigFromCredentialsHelper(String registryToLookup, String credConfig) throws IOException {
        CredentialHelperClient credentialHelper = new CredentialHelperClient(this.log, credConfig);
        this.log.debug("AuthConfig: credentials from credential helper/store %s version %s", new Object[]{credentialHelper.getName(), credentialHelper.getVersion()});
        return credentialHelper.getAuthConfig(registryToLookup);
    }

    private JsonObject getCredentialsNode(JsonObject auths, String registryToLookup) {
        if (auths.has(registryToLookup)) {
            return auths.getAsJsonObject(registryToLookup);
        }
        String registryWithScheme = Optional.of(registryToLookup).filter(r -> r.toLowerCase().startsWith("http")).orElse("https://" + registryToLookup);
        if (auths.has(registryWithScheme)) {
            return auths.getAsJsonObject(registryWithScheme);
        }
        return null;
    }

    private Optional<Reader> getFileReaderFromDir(File file) {
        try {
            return Optional.of(new FileReader(file));
        }
        catch (FileNotFoundException e) {
            return Optional.empty();
        }
    }

    private File getHomeDir() {
        String homeDir = Optional.ofNullable(System.getProperty("user.home")).orElse(System.getenv("HOME"));
        return new File(homeDir);
    }
}

