/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jkube.kit.build.service.docker.auth.ecr;

import java.io.IOException;
import java.lang.reflect.UndeclaredThrowableException;
import java.net.URI;
import java.net.URISyntaxException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Locale;
import java.util.Map;
import java.util.TimeZone;
import java.util.TreeMap;
import org.apache.commons.lang3.StringUtils;
import org.apache.http.Header;
import org.apache.http.HttpEntity;
import org.apache.http.HttpRequest;
import org.apache.http.client.methods.HttpEntityEnclosingRequestBase;
import org.apache.http.util.EntityUtils;

public class AwsSigner4Request {
    static final SimpleDateFormat TIME_FORMAT = new SimpleDateFormat("yyyyMMdd'T'HHmmss'Z'");
    private static final byte[] EMPTY_BYTES;
    private final String region;
    private final String service;
    private final HttpRequest request;
    private final String signingDate;
    private final String signingDateTime;
    private final String scope;
    private final String method;
    private final URI uri;
    private final String canonicalHeaders;
    private final String signedHeaders;

    AwsSigner4Request(String region, String service, HttpRequest request, Date signingTime) {
        this.region = region;
        this.service = service;
        this.request = request;
        this.signingDateTime = AwsSigner4Request.getSigningDateTime(request, signingTime);
        this.signingDate = this.signingDateTime.substring(0, 8);
        this.scope = this.signingDate + '/' + region + '/' + service + "/aws4_request";
        this.method = request.getRequestLine().getMethod();
        this.uri = AwsSigner4Request.getUri(request);
        Map<String, String> headers = AwsSigner4Request.getOrderedHeadersToSign(request.getAllHeaders());
        this.signedHeaders = StringUtils.join(headers.keySet(), (char)';');
        this.canonicalHeaders = AwsSigner4Request.canonicalHeaders(headers);
    }

    public String getRegion() {
        return this.region;
    }

    public String getService() {
        return this.service;
    }

    public String getSigningDate() {
        return this.signingDate;
    }

    public String getSigningDateTime() {
        return this.signingDateTime;
    }

    public String getScope() {
        return this.scope;
    }

    public String getMethod() {
        return this.method;
    }

    public URI getUri() {
        return this.uri;
    }

    public String getCanonicalHeaders() {
        return this.canonicalHeaders;
    }

    public String getSignedHeaders() {
        return this.signedHeaders;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static String getSigningDateTime(HttpRequest request, Date signingTime) {
        Header dateHeader = request.getFirstHeader("X-Amz-Date");
        if (dateHeader != null) {
            return dateHeader.getValue();
        }
        SimpleDateFormat simpleDateFormat = TIME_FORMAT;
        synchronized (simpleDateFormat) {
            return TIME_FORMAT.format(signingTime);
        }
    }

    private static URI getUri(HttpRequest request) {
        String hostName = request.getFirstHeader("host").getValue();
        String requestTarget = request.getRequestLine().getUri();
        URI requestUri = AwsSigner4Request.createUri(hostName, requestTarget);
        return requestUri.normalize();
    }

    private static URI createUri(String authority, String uri) {
        String path;
        String query;
        int queryIdx;
        String scheme = "https";
        int schemeEnd = uri.indexOf(58);
        int pathStart = uri.indexOf(47);
        if (schemeEnd >= 0 && schemeEnd < pathStart) {
            scheme = uri.substring(0, schemeEnd);
            if (uri.charAt(pathStart + 1) == '/') {
                authority = uri.substring(pathStart);
                pathStart = uri.indexOf(47, pathStart + 2);
            }
        }
        if ((queryIdx = uri.indexOf(63, pathStart)) < 0) {
            query = null;
            path = uri.substring(pathStart);
        } else {
            query = uri.substring(queryIdx + 1);
            path = uri.substring(pathStart, queryIdx);
        }
        try {
            return new URI(scheme, authority, path, query, null);
        }
        catch (URISyntaxException e) {
            throw new UndeclaredThrowableException(e);
        }
    }

    private static Map<String, String> getOrderedHeadersToSign(Header[] headers) {
        TreeMap<String, String> unique = new TreeMap<String, String>();
        for (Header header : headers) {
            String key = header.getName().toLowerCase(Locale.US).trim();
            if (key.equals("connection")) continue;
            String value = header.getValue();
            value = value == null ? "" : value.trim().replaceAll("\\s+", " ");
            String prior = (String)unique.get(key);
            if (prior != null) {
                if (prior.length() > 0) {
                    value = prior + ',' + value;
                }
                unique.put(key, value);
                continue;
            }
            unique.put(key, value);
        }
        return unique;
    }

    private static String canonicalHeaders(Map<String, String> headers) {
        StringBuilder canonical = new StringBuilder();
        for (Map.Entry<String, String> header : headers.entrySet()) {
            canonical.append(header.getKey()).append(':').append(header.getValue()).append('\n');
        }
        return canonical.toString();
    }

    byte[] getBytes() {
        if (this.request instanceof HttpEntityEnclosingRequestBase) {
            try {
                HttpEntity entity = ((HttpEntityEnclosingRequestBase)this.request).getEntity();
                return EntityUtils.toByteArray((HttpEntity)entity);
            }
            catch (IOException e) {
                throw new UndeclaredThrowableException(e);
            }
        }
        return EMPTY_BYTES;
    }

    static {
        TimeZone utc = TimeZone.getTimeZone("GMT");
        TIME_FORMAT.setTimeZone(utc);
        EMPTY_BYTES = new byte[0];
    }
}

