/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jkube.kit.build.service.docker.auth.ecr;

import com.google.gson.Gson;
import com.google.gson.JsonArray;
import com.google.gson.JsonObject;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.StandardCharsets;
import java.util.Date;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.http.HttpEntity;
import org.apache.http.HttpRequest;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.entity.StringEntity;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClients;
import org.eclipse.jkube.kit.build.api.auth.AuthConfig;
import org.eclipse.jkube.kit.build.service.docker.auth.ecr.AwsSigner4;
import org.eclipse.jkube.kit.common.KitLogger;

public class EcrExtendedAuth {
    private static final Pattern AWS_REGISTRY = Pattern.compile("^(\\d{12})\\.dkr\\.ecr\\.([a-z\\-0-9]+)\\.amazonaws\\.com$");
    private final KitLogger logger;
    private final boolean isAwsRegistry;
    private final String accountId;
    private final String region;

    public static boolean isAwsRegistry(String registry) {
        return registry != null && AWS_REGISTRY.matcher(registry).matches();
    }

    public EcrExtendedAuth(KitLogger logger, String registry) {
        this.logger = logger;
        Matcher matcher = AWS_REGISTRY.matcher(registry);
        this.isAwsRegistry = matcher.matches();
        if (this.isAwsRegistry) {
            this.accountId = matcher.group(1);
            this.region = matcher.group(2);
        } else {
            this.accountId = null;
            this.region = null;
        }
        logger.debug("registry = %s, isValid= %b", new Object[]{registry, this.isAwsRegistry});
    }

    public boolean isAwsRegistry() {
        return this.isAwsRegistry;
    }

    public AuthConfig extendedAuth(AuthConfig localCredentials) throws IOException {
        JsonObject jo = this.getAuthorizationToken(localCredentials);
        JsonArray authorizationDatas = jo.getAsJsonArray("authorizationData");
        JsonObject authorizationData = authorizationDatas.get(0).getAsJsonObject();
        String authorizationToken = authorizationData.get("authorizationToken").getAsString();
        return new AuthConfig(authorizationToken, "none");
    }

    private JsonObject getAuthorizationToken(AuthConfig localCredentials) throws IOException {
        HttpPost request = this.createSignedRequest(localCredentials, new Date());
        return this.executeRequest(this.createClient(), request);
    }

    CloseableHttpClient createClient() {
        return HttpClients.custom().useSystemProperties().build();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private JsonObject executeRequest(CloseableHttpClient client, HttpPost request) throws IOException {
        try {
            CloseableHttpResponse response = client.execute((HttpUriRequest)request);
            int statusCode = response.getStatusLine().getStatusCode();
            this.logger.debug("Response status %d", new Object[]{statusCode});
            if (statusCode != 200) {
                throw new IOException("AWS authentication failure");
            }
            HttpEntity entity = response.getEntity();
            InputStreamReader jr = new InputStreamReader(entity.getContent(), StandardCharsets.UTF_8);
            JsonObject jsonObject = (JsonObject)new Gson().fromJson((Reader)jr, JsonObject.class);
            return jsonObject;
        }
        finally {
            client.close();
        }
    }

    HttpPost createSignedRequest(AuthConfig localCredentials, Date time) {
        String host = "ecr." + this.region + ".amazonaws.com";
        this.logger.debug("Get ECR AuthorizationToken from %s", new Object[]{host});
        HttpPost request = new HttpPost("https://" + host + '/');
        request.setHeader("host", host);
        request.setHeader("Content-Type", "application/x-amz-json-1.1");
        request.setHeader("X-Amz-Target", "AmazonEC2ContainerRegistry_V20150921.GetAuthorizationToken");
        request.setEntity((HttpEntity)new StringEntity("{\"registryIds\":[\"" + this.accountId + "\"]}", StandardCharsets.UTF_8));
        AwsSigner4 signer = new AwsSigner4(this.region, "ecr");
        signer.sign((HttpRequest)request, localCredentials, time);
        return request;
    }
}

