/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jkube.kit.build.service.docker.config;

import java.io.Serializable;
import java.util.Map;
import org.eclipse.jkube.kit.build.service.docker.helper.DeepCopy;

public class VolumeConfiguration
implements Serializable {
    private String name;
    private String driver;
    private Map<String, String> opts;
    private Map<String, String> labels;

    public String getName() {
        return this.name;
    }

    public String getDriver() {
        return this.driver;
    }

    public Map<String, String> getOpts() {
        return this.opts;
    }

    public Map<String, String> getLabels() {
        return this.labels;
    }

    public static class Builder {
        private final VolumeConfiguration config;

        public Builder() {
            this(null);
        }

        public Builder(VolumeConfiguration that) {
            this.config = that == null ? new VolumeConfiguration() : DeepCopy.copy(that);
        }

        public Builder name(String name) {
            this.config.name = name;
            return this;
        }

        public Builder driver(String driver) {
            this.config.driver = driver;
            return this;
        }

        public Builder opts(Map<String, String> opts) {
            this.config.opts = opts;
            return this;
        }

        public Builder labels(Map<String, String> labels) {
            this.config.labels = labels;
            return this;
        }

        public VolumeConfiguration build() {
            return this.config;
        }
    }
}

