/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jkube.kit.build.service.docker.config;

import java.io.Serializable;
import org.eclipse.jkube.kit.build.service.docker.config.WatchMode;
import org.eclipse.jkube.kit.build.service.docker.helper.DeepCopy;

public class WatchImageConfiguration
implements Serializable {
    private Integer interval;
    private WatchMode mode;
    private String postGoal;
    private String postExec;

    public int getInterval() {
        return this.interval != null ? this.interval : 5000;
    }

    public Integer getIntervalRaw() {
        return this.interval;
    }

    public WatchMode getMode() {
        return this.mode;
    }

    public String getPostGoal() {
        return this.postGoal;
    }

    public String getPostExec() {
        return this.postExec;
    }

    public static class Builder {
        private final WatchImageConfiguration c;

        public Builder() {
            this(null);
        }

        public Builder(WatchImageConfiguration that) {
            this.c = that == null ? new WatchImageConfiguration() : DeepCopy.copy(that);
        }

        public Builder interval(Integer interval) {
            this.c.interval = interval;
            return this;
        }

        public Builder mode(String mode) {
            if (mode != null) {
                this.c.mode = WatchMode.valueOf(mode.toLowerCase());
            }
            return this;
        }

        public Builder postGoal(String goal) {
            this.c.postGoal = goal;
            return this;
        }

        public Builder postExec(String exec) {
            this.c.postExec = exec;
            return this;
        }

        public WatchImageConfiguration build() {
            return this.c;
        }
    }
}

