/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jkube.kit.build.service.docker.config.handler;

import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.jkube.kit.build.service.docker.ImageConfiguration;
import org.eclipse.jkube.kit.build.service.docker.config.ConfigHelper;
import org.eclipse.jkube.kit.build.service.docker.config.handler.ExternalConfigHandler;
import org.eclipse.jkube.kit.common.JKubeProject;
import org.eclipse.jkube.kit.common.KitLogger;

public class ImageConfigResolver {
    private Map<String, ExternalConfigHandler> registry;
    private ExternalConfigHandler propertyConfigHandler;
    private ExternalConfigHandler dockerComposeConfigHandler;
    private KitLogger log;

    public void initialize() {
        this.registry = new HashMap<String, ExternalConfigHandler>();
        for (ExternalConfigHandler handler : new ExternalConfigHandler[]{this.propertyConfigHandler, this.dockerComposeConfigHandler}) {
            if (handler == null) continue;
            this.registry.put(handler.getType(), handler);
        }
    }

    public void setLog(KitLogger log) {
        this.log = log;
    }

    public List<ImageConfiguration> resolve(ImageConfiguration unresolvedConfig, JKubeProject project) {
        this.injectExternalConfigActivation(unresolvedConfig, project);
        Map<String, String> externalConfig = unresolvedConfig.getExternalConfig();
        if (externalConfig != null) {
            String type = externalConfig.get("type");
            if (type == null) {
                throw new IllegalArgumentException(unresolvedConfig.getDescription() + ": No config type given");
            }
            ExternalConfigHandler handler = this.registry.get(type);
            if (handler == null) {
                throw new IllegalArgumentException(unresolvedConfig.getDescription() + ": No handler for type " + type + " given");
            }
            return handler.resolve(unresolvedConfig, project);
        }
        return Collections.singletonList(unresolvedConfig);
    }

    private void injectExternalConfigActivation(ImageConfiguration unresolvedConfig, JKubeProject project) {
        String mode = ConfigHelper.getExternalConfigActivationProperty(project);
        if (mode == null) {
            return;
        }
        Map<String, String> externalConfig = unresolvedConfig.getExternalConfig();
        if (externalConfig == null) {
            externalConfig = new HashMap<String, String>();
            externalConfig.put("type", this.propertyConfigHandler.getType());
            externalConfig.put("mode", mode);
            unresolvedConfig.setExternalConfiguration(externalConfig);
            this.log.verbose("Global %s=%s property activates property configuration for image", new Object[]{"docker.imagePropertyConfiguration", mode});
        } else {
            this.log.verbose("Ignoring %s=%s property, image has <external> in POM which takes precedence", new Object[]{"docker.imagePropertyConfiguration", mode});
        }
    }
}

