/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jkube.kit.build.service.docker.config.handler.compose;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.Reader;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.eclipse.jkube.kit.build.core.config.JKubeBuildConfiguration;
import org.eclipse.jkube.kit.build.service.docker.ImageConfiguration;
import org.eclipse.jkube.kit.build.service.docker.config.RunImageConfiguration;
import org.eclipse.jkube.kit.build.service.docker.config.handler.ExternalConfigHandler;
import org.eclipse.jkube.kit.build.service.docker.config.handler.ExternalConfigHandlerException;
import org.eclipse.jkube.kit.build.service.docker.config.handler.compose.ComposeUtils;
import org.eclipse.jkube.kit.build.service.docker.config.handler.compose.DockerComposeConfiguration;
import org.eclipse.jkube.kit.build.service.docker.config.handler.compose.DockerComposeServiceWrapper;
import org.eclipse.jkube.kit.build.service.docker.helper.DeepCopy;
import org.eclipse.jkube.kit.common.JKubeProject;
import org.yaml.snakeyaml.Yaml;

public class DockerComposeConfigHandler
implements ExternalConfigHandler {
    @Override
    public String getType() {
        return "compose";
    }

    @Override
    public List<ImageConfiguration> resolve(ImageConfiguration unresolvedConfig, JKubeProject project) {
        ArrayList<ImageConfiguration> resolved = new ArrayList<ImageConfiguration>();
        DockerComposeConfiguration handlerConfig = new DockerComposeConfiguration(unresolvedConfig.getExternalConfig());
        File composeFile = ComposeUtils.resolveComposeFileAbsolutely(handlerConfig.getBasedir(), handlerConfig.getComposeFile(), project != null && project.getBaseDirectory() != null ? project.getBaseDirectory().getAbsolutePath() : null);
        for (Object composeO : this.getComposeConfigurations(composeFile)) {
            Map compose = (Map)composeO;
            this.validateVersion(compose, composeFile);
            Map services = (Map)compose.get("services");
            for (Map.Entry entry : services.entrySet()) {
                String serviceName = (String)entry.getKey();
                Map serviceDefinition = (Map)entry.getValue();
                DockerComposeServiceWrapper mapper = new DockerComposeServiceWrapper(serviceName, composeFile, serviceDefinition, unresolvedConfig, ComposeUtils.resolveAbsolutely(handlerConfig.getBasedir(), project != null && project.getBaseDirectory() != null ? project.getBaseDirectory().getAbsolutePath() : null));
                resolved.add(this.buildImageConfiguration(mapper, composeFile.getParentFile(), unresolvedConfig, handlerConfig));
            }
        }
        return resolved;
    }

    private void validateVersion(Map<String, Object> compose, File file) {
        Object version = compose.get("version");
        if (version == null || !this.isVersion2(version.toString().trim())) {
            throw new ExternalConfigHandlerException("Only version 2.x of the docker-compose format is supported for " + file);
        }
    }

    private boolean isVersion2(String version) {
        return version.equals("2") || version.startsWith("2.");
    }

    private String extractDockerFilePath(DockerComposeServiceWrapper mapper, File parentDir) {
        if (mapper.requiresBuild()) {
            File ret;
            File buildDir = new File(mapper.getBuildDir());
            String dockerFile = mapper.getDockerfile();
            if (dockerFile == null) {
                dockerFile = "Dockerfile";
            }
            return (ret = new File(buildDir, dockerFile)).isAbsolute() ? ret.getAbsolutePath() : new File(parentDir, ret.getPath()).getAbsolutePath();
        }
        return null;
    }

    private ImageConfiguration buildImageConfiguration(DockerComposeServiceWrapper mapper, File composeParent, ImageConfiguration unresolvedConfig, DockerComposeConfiguration handlerConfig) {
        ImageConfiguration.Builder builder = new ImageConfiguration.Builder().name(this.getImageName(mapper, unresolvedConfig)).alias(mapper.getAlias()).buildConfig(this.createBuildImageConfiguration(mapper, composeParent, unresolvedConfig, handlerConfig)).runConfig(this.createRunConfiguration(mapper, unresolvedConfig));
        if (this.serviceMatchesAlias(mapper, unresolvedConfig)) {
            builder.watchConfig(DeepCopy.copy(unresolvedConfig.getWatchConfiguration()));
        }
        return builder.build();
    }

    private String getImageName(DockerComposeServiceWrapper mapper, ImageConfiguration unresolvedConfig) {
        String name = mapper.getImage();
        if (name != null) {
            return name;
        }
        if (unresolvedConfig.getAlias() != null && unresolvedConfig.getAlias().equals(mapper.getAlias())) {
            return unresolvedConfig.getName();
        }
        return null;
    }

    private Iterable<Object> getComposeConfigurations(File composePath) {
        try {
            Yaml yaml = new Yaml();
            return yaml.loadAll((Reader)new FileReader(composePath));
        }
        catch (FileNotFoundException e) {
            throw new ExternalConfigHandlerException("failed to load external configuration: " + composePath, e);
        }
    }

    private JKubeBuildConfiguration createBuildImageConfiguration(DockerComposeServiceWrapper mapper, File composeParent, ImageConfiguration imageConfig, DockerComposeConfiguration handlerConfig) {
        JKubeBuildConfiguration buildConfig = imageConfig.getBuildConfiguration();
        if (handlerConfig.isIgnoreBuild() || !mapper.requiresBuild()) {
            if (this.serviceMatchesAlias(mapper, imageConfig)) {
                return buildConfig;
            }
            return null;
        }
        return (JKubeBuildConfiguration)new JKubeBuildConfiguration.Builder(buildConfig).dockerFile(this.extractDockerFilePath(mapper, composeParent)).args(mapper.getBuildArgs()).build();
    }

    private boolean serviceMatchesAlias(DockerComposeServiceWrapper mapper, ImageConfiguration imageConfig) {
        return mapper.getAlias() != null && mapper.getAlias().equals(imageConfig.getAlias());
    }

    private RunImageConfiguration createRunConfiguration(DockerComposeServiceWrapper wrapper, ImageConfiguration imageConfig) {
        RunImageConfiguration.Builder builder = this.serviceMatchesAlias(wrapper, imageConfig) ? new RunImageConfiguration.Builder(imageConfig.getRunConfiguration()) : new RunImageConfiguration.Builder();
        return builder.capAdd(wrapper.getCapAdd()).capDrop(wrapper.getCapDrop()).cmd(wrapper.getCommand()).dependsOn(wrapper.getDependsOn()).dns(wrapper.getDns()).dnsSearch(wrapper.getDnsSearch()).tmpfs(wrapper.getTmpfs()).entrypoint(wrapper.getEntrypoint()).env(wrapper.getEnvironment()).extraHosts(wrapper.getExtraHosts()).labels(wrapper.getLabels()).links(wrapper.getLinks()).log(wrapper.getLogConfiguration()).network(wrapper.getNetworkConfig()).ports(wrapper.getPortMapping()).ulimits(wrapper.getUlimits()).volumes(wrapper.getVolumeConfig()).cpuShares(wrapper.getCpuShares()).cpus(wrapper.getCpusCount()).cpuSet(wrapper.getCpuSet()).domainname(wrapper.getDomainname()).hostname(wrapper.getHostname()).memory(wrapper.getMemory()).memorySwap(wrapper.getMemorySwap()).privileged(wrapper.getPrivileged()).restartPolicy(wrapper.getRestartPolicy()).shmSize(wrapper.getShmSize()).user(wrapper.getUser()).workingDir(wrapper.getWorkingDir()).build();
    }
}

