/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jkube.kit.build.service.docker.helper;

import java.util.HashMap;
import java.util.Map;
import java.util.Properties;

public class JKubeDockerfileInterpolator {
    private static Map<String, String> delimiters = new HashMap<String, String>();

    private JKubeDockerfileInterpolator() {
    }

    public static String interpolate(String line, Properties properties) {
        for (String property : properties.stringPropertyNames()) {
            String value = JKubeDockerfileInterpolator.checkPropertyWithDelimiters(line, property, properties);
            if (value == null) continue;
            line = value;
        }
        return line;
    }

    private static String checkPropertyWithDelimiters(String line, String property, Properties properties) {
        for (Map.Entry<String, String> delimiter : delimiters.entrySet()) {
            String searchPhrase = delimiter.getKey() + property + delimiter.getValue();
            if (!line.contains(searchPhrase)) continue;
            return line.replace(searchPhrase, properties.getProperty(property));
        }
        return null;
    }

    static {
        delimiters.put("@", "@");
        delimiters.put("${", "}");
    }
}

