/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jkube.kit.build.service.docker.helper;

import java.io.File;
import java.io.IOException;
import java.util.Date;
import java.util.Map;
import java.util.Properties;
import org.apache.commons.lang3.StringUtils;
import org.eclipse.jkube.kit.build.api.model.Container;
import org.eclipse.jkube.kit.build.core.GavLabel;
import org.eclipse.jkube.kit.build.service.docker.ImageConfiguration;
import org.eclipse.jkube.kit.build.service.docker.ServiceHub;
import org.eclipse.jkube.kit.build.service.docker.access.DockerAccessException;
import org.eclipse.jkube.kit.build.service.docker.access.ExecException;
import org.eclipse.jkube.kit.build.service.docker.access.PortMapping;
import org.eclipse.jkube.kit.build.service.docker.access.log.LogDispatcher;
import org.eclipse.jkube.kit.build.service.docker.access.log.LogOutputSpecFactory;
import org.eclipse.jkube.kit.build.service.docker.config.ConfigHelper;
import org.eclipse.jkube.kit.build.service.docker.config.LogConfiguration;
import org.eclipse.jkube.kit.build.service.docker.config.RunImageConfiguration;
import org.eclipse.jkube.kit.build.service.docker.config.WaitConfiguration;
import org.eclipse.jkube.kit.common.KitLogger;

public class StartContainerExecutor {
    private String exposeContainerProps;
    private KitLogger log;
    private LogOutputSpecFactory logOutputSpecFactory;
    private ServiceHub hub;
    private boolean follow;
    private String showLogs;
    private String containerNamePattern;
    private Date buildDate;
    private Properties projectProperties;
    private File basedir;
    private ImageConfiguration imageConfig;
    private GavLabel gavLabel;
    private PortMapping portMapping;
    private LogDispatcher dispatcher;

    private StartContainerExecutor() {
    }

    public String startContainers() throws IOException, ExecException {
        Properties projProperties = this.projectProperties;
        String containerId = this.hub.getRunService().createAndStartContainer(this.imageConfig, this.portMapping, this.gavLabel, projProperties, this.basedir, this.containerNamePattern, this.buildDate);
        this.showLogsIfRequested(containerId);
        this.exposeContainerProps(containerId);
        this.waitAndPostExec(containerId, projProperties);
        return containerId;
    }

    private void exposeContainerProps(String containerId) throws DockerAccessException {
        String propKey = this.getExposedPropertyKeyPart();
        if (StringUtils.isNotEmpty((CharSequence)this.exposeContainerProps) && StringUtils.isNotEmpty((CharSequence)propKey)) {
            Map nets;
            Container container = this.hub.getQueryService().getMandatoryContainer(containerId);
            String prefix = this.addDot(this.exposeContainerProps) + this.addDot(propKey);
            this.projectProperties.put(prefix + "id", containerId);
            String ip = container.getIPAddress();
            if (StringUtils.isNotEmpty((CharSequence)ip)) {
                this.projectProperties.put(prefix + "ip", ip);
            }
            if ((nets = container.getCustomNetworkIpAddresses()) != null) {
                for (Map.Entry entry : nets.entrySet()) {
                    this.projectProperties.put(prefix + this.addDot("net") + this.addDot((String)entry.getKey()) + "ip", entry.getValue());
                }
            }
        }
    }

    String getExposedPropertyKeyPart() {
        String propKey;
        String string = propKey = this.imageConfig.getRunConfiguration() != null ? this.imageConfig.getRunConfiguration().getExposedPropertyKey() : "";
        if (StringUtils.isEmpty((CharSequence)propKey)) {
            propKey = this.imageConfig.getAlias();
        }
        return propKey;
    }

    private String addDot(String part) {
        return part.endsWith(".") ? part : part + ".";
    }

    private void showLogsIfRequested(String containerId) {
        if (this.showLogs()) {
            this.dispatcher.trackContainerLog(containerId, this.logOutputSpecFactory.createSpec(containerId, this.imageConfig));
        }
    }

    private void waitAndPostExec(String containerId, Properties projProperties) throws IOException, ExecException {
        this.hub.getWaitService().wait(this.imageConfig, projProperties, containerId);
        WaitConfiguration waitConfig = this.imageConfig.getRunConfiguration().getWaitConfiguration();
        if (waitConfig != null && waitConfig.getExec() != null && waitConfig.getExec().getPostStart() != null) {
            try {
                this.hub.getRunService().execInContainer(containerId, waitConfig.getExec().getPostStart(), this.imageConfig);
            }
            catch (ExecException exp) {
                if (waitConfig.getExec().isBreakOnError()) {
                    throw exp;
                }
                this.log.warn("Cannot run postStart: %s", new Object[]{exp.getMessage()});
            }
        }
    }

    boolean showLogs() {
        if (this.showLogs != null) {
            if (this.showLogs.equalsIgnoreCase("true")) {
                return true;
            }
            if (this.showLogs.equalsIgnoreCase("false")) {
                return false;
            }
            return ConfigHelper.matchesConfiguredImages(this.showLogs, this.imageConfig);
        }
        RunImageConfiguration runConfig = this.imageConfig.getRunConfiguration();
        if (runConfig != null) {
            LogConfiguration logConfig = runConfig.getLogConfiguration();
            if (logConfig != null) {
                return logConfig.isActivated();
            }
            return this.follow;
        }
        return false;
    }

    public static class Builder {
        private final StartContainerExecutor helper = new StartContainerExecutor();

        public Builder log(KitLogger log) {
            this.helper.log = log;
            return this;
        }

        public Builder logOutputSpecFactory(LogOutputSpecFactory factory) {
            this.helper.logOutputSpecFactory = factory;
            return this;
        }

        public Builder exposeContainerProps(String exposeContainerProps) {
            this.helper.exposeContainerProps = exposeContainerProps;
            return this;
        }

        public Builder serviceHub(ServiceHub hub) {
            this.helper.hub = hub;
            return this;
        }

        public Builder projectProperties(Properties props) {
            this.helper.projectProperties = props;
            return this;
        }

        public Builder basedir(File dir) {
            this.helper.basedir = dir;
            return this;
        }

        public Builder follow(boolean follow) {
            this.helper.follow = follow;
            return this;
        }

        public Builder showLogs(String showLogs) {
            this.helper.showLogs = showLogs;
            return this;
        }

        public Builder containerNamePattern(String pattern) {
            this.helper.containerNamePattern = pattern;
            return this;
        }

        public Builder buildTimestamp(Date date) {
            this.helper.buildDate = date;
            return this;
        }

        public Builder dispatcher(LogDispatcher dispatcher) {
            this.helper.dispatcher = dispatcher;
            return this;
        }

        public Builder portMapping(PortMapping portMapping) {
            this.helper.portMapping = portMapping;
            return this;
        }

        public Builder gavLabel(GavLabel gavLabel) {
            this.helper.gavLabel = gavLabel;
            return this;
        }

        public Builder imageConfig(ImageConfiguration imageConfig) {
            this.helper.imageConfig = imageConfig;
            return this;
        }

        public StartContainerExecutor build() {
            return this.helper;
        }
    }
}

