/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jkube.kit.build.service.docker;

import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.eclipse.jkube.kit.build.api.model.Container;
import org.eclipse.jkube.kit.build.api.model.Network;
import org.eclipse.jkube.kit.build.service.docker.access.DockerAccess;
import org.eclipse.jkube.kit.build.service.docker.access.DockerAccessException;

public class QueryService {
    private DockerAccess docker;

    public QueryService(DockerAccess docker) {
        this.docker = docker;
    }

    public Container getMandatoryContainer(String containerIdOrName) throws DockerAccessException {
        Container container = this.getContainer(containerIdOrName);
        if (container == null) {
            throw new DockerAccessException("Cannot find container %s", containerIdOrName);
        }
        return container;
    }

    public Container getContainer(String containerIdOrName) throws DockerAccessException {
        return this.docker.getContainer(containerIdOrName);
    }

    public Network getNetworkByName(String networkName) throws DockerAccessException {
        for (Network el : this.docker.listNetworks()) {
            if (!networkName.equals(el.getName())) continue;
            return el;
        }
        return null;
    }

    public Set<Network> getNetworks() throws DockerAccessException {
        return new HashSet<Network>(this.docker.listNetworks());
    }

    public String getContainerName(String containerId) throws DockerAccessException {
        return this.getMandatoryContainer(containerId).getName();
    }

    public List<Container> getContainersForImage(String image, boolean all) throws DockerAccessException {
        return this.docker.getContainersForImage(image, all);
    }

    public String getImageId(String imageName) throws DockerAccessException {
        return this.docker.getImageId(imageName);
    }

    public Container getLatestContainerForImage(String image) throws DockerAccessException {
        long newest = 0L;
        Container result = null;
        for (Container container : this.getContainersForImage(image, false)) {
            long timestamp = container.getCreated();
            if (timestamp < newest) continue;
            newest = timestamp;
            result = container;
        }
        return result;
    }

    public boolean hasContainer(String containerName) throws DockerAccessException {
        return this.getContainer(containerName) != null;
    }

    public boolean hasNetwork(String networkName) throws DockerAccessException {
        return this.getNetworkByName(networkName) != null;
    }

    public boolean hasImage(String name) throws DockerAccessException {
        return this.docker.hasImage(name);
    }
}

