/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jkube.kit.build.service.docker.access.log;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.jkube.kit.build.service.docker.access.DockerAccess;
import org.eclipse.jkube.kit.build.service.docker.access.log.DefaultLogCallback;
import org.eclipse.jkube.kit.build.service.docker.access.log.LogGetHandle;
import org.eclipse.jkube.kit.build.service.docker.access.log.LogOutputSpec;

public class LogDispatcher {
    private Map<String, LogGetHandle> logHandles;
    private DockerAccess dockerAccess;

    public LogDispatcher(DockerAccess dockerAccess) {
        this.dockerAccess = dockerAccess;
        this.logHandles = new HashMap<String, LogGetHandle>();
    }

    public synchronized void trackContainerLog(String containerId, LogOutputSpec spec) {
        LogGetHandle handle = this.dockerAccess.getLogAsync(containerId, new DefaultLogCallback(spec));
        this.logHandles.put(containerId, handle);
    }

    public synchronized void fetchContainerLog(String containerId, LogOutputSpec spec) {
        this.dockerAccess.getLogSync(containerId, new DefaultLogCallback(spec));
    }

    public synchronized void untrackAllContainerLogs() {
        for (Map.Entry<String, LogGetHandle> logHandlesEntry : this.logHandles.entrySet()) {
            LogGetHandle handle = logHandlesEntry.getValue();
            handle.finish();
        }
        this.logHandles.clear();
    }
}

